/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.injection.struct;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.util.Bytecode;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2;

public class InjectionNodes
extends ArrayList<InjectionNode> {
    private static final long serialVersionUID = 1L;

    public InjectionNode add(AbstractInsnNode abstractInsnNode) {
        InjectionNode injectionNode = this.get(abstractInsnNode);
        if (injectionNode == null) {
            injectionNode = new InjectionNode(abstractInsnNode);
            this.add(injectionNode);
        }
        return injectionNode;
    }

    public InjectionNode get(AbstractInsnNode abstractInsnNode) {
        for (InjectionNode injectionNode : this) {
            if (!injectionNode.matches(abstractInsnNode)) continue;
            return injectionNode;
        }
        return null;
    }

    public boolean contains(AbstractInsnNode abstractInsnNode) {
        return (this.get(abstractInsnNode) != null ? 0xE1E3526E ^ 0xE1E3526F : 0xF9D1EEC3 ^ 0xF9D1EEC3) != 0;
    }

    public void replace(AbstractInsnNode abstractInsnNode, AbstractInsnNode abstractInsnNode2) {
        InjectionNode injectionNode = this.get(abstractInsnNode);
        if (injectionNode != null) {
            injectionNode.replace(abstractInsnNode2);
        }
    }

    public void remove(AbstractInsnNode abstractInsnNode) {
        InjectionNode injectionNode = this.get(abstractInsnNode);
        if (injectionNode != null) {
            injectionNode.remove();
        }
    }

    public static class InjectionNode
    implements Comparable<InjectionNode> {
        private static int nextId = 0x9F369338 ^ 0x9F369338;
        private final int id;
        private final AbstractInsnNode originalTarget;
        private AbstractInsnNode currentTarget;
        private Map<String, Object> decorations;

        public InjectionNode(AbstractInsnNode abstractInsnNode) {
            this.currentTarget = this.originalTarget = abstractInsnNode;
            int n = nextId;
            nextId = n + (0x47FD1298 ^ 0x47FD1299);
            this.id = n;
        }

        public int getId() {
            return this.id;
        }

        public AbstractInsnNode getOriginalTarget() {
            return this.originalTarget;
        }

        public AbstractInsnNode getCurrentTarget() {
            return this.currentTarget;
        }

        public InjectionNode replace(AbstractInsnNode abstractInsnNode) {
            this.currentTarget = abstractInsnNode;
            return this;
        }

        public InjectionNode remove() {
            this.currentTarget = null;
            return this;
        }

        public boolean matches(AbstractInsnNode abstractInsnNode) {
            return (this.originalTarget == abstractInsnNode || this.currentTarget == abstractInsnNode ? 0xF2AC46E9 ^ 0xF2AC46E8 : 0x7177C42C ^ 0x7177C42C) != 0;
        }

        public boolean isReplaced() {
            return (this.originalTarget != this.currentTarget ? 0xD60DB54B ^ 0xD60DB54A : 0x6AEC1ED7 ^ 0x6AEC1ED7) != 0;
        }

        public boolean isRemoved() {
            return (this.currentTarget == null ? 0x7ABAE393 ^ 0x7ABAE392 : 0xA7FF5E79 ^ 0xA7FF5E79) != 0;
        }

        public <V> InjectionNode decorate(String string, V v) {
            if (this.decorations == null) {
                this.decorations = new HashMap<String, Object>();
            }
            this.decorations.put(string, v);
            return this;
        }

        public boolean hasDecoration(String string) {
            return (this.decorations != null && this.decorations.get(string) != null ? 0x9BC960EE ^ 0x9BC960EF : 0x6A942DC0 ^ 0x6A942DC0) != 0;
        }

        public <V> V getDecoration(String string) {
            return (V)(this.decorations == null ? null : this.decorations.get(string));
        }

        @Override
        public int compareTo(InjectionNode injectionNode) {
            return injectionNode == null ? 0xE1595D46 ^ 0x9EA6A2B9 : this.hashCode() - injectionNode.hashCode();
        }

        public String toString() {
            Object[] objectArray = new Object[0xF33D76C2 ^ 0xF33D76C3];
            objectArray[0xA17AAFCA ^ 0xA17AAFCA] = Bytecode.describeNode(this.currentTarget).replaceAll(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("N\ua7f5\ua4fe"), \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2"));
            return String.format(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("[\ua7e8\ua4bf\ua074\ua906\u7d62\u8e43\u2475\u8b39\u3459}\ua7e2\ua4b0\ua04a\ua940\u7d65\u8e77"), objectArray);
        }
    }
}

