/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.injection.struct;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.spongepowered.asm.lib.Label;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.lib.tree.InsnList;
import org.spongepowered.asm.lib.tree.LabelNode;
import org.spongepowered.asm.lib.tree.LocalVariableNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.lib.tree.TypeInsnNode;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.struct.InjectionNodes;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import org.spongepowered.asm.util.Bytecode;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2;

public class Target
implements Comparable<Target>,
Iterable<AbstractInsnNode> {
    public final ClassNode classNode;
    public final MethodNode method;
    public final InsnList insns;
    public final boolean isStatic;
    public final boolean isCtor;
    public final Type[] arguments;
    public final Type returnType;
    private final int maxStack;
    private final int maxLocals;
    private final InjectionNodes injectionNodes = new InjectionNodes();
    private String callbackInfoClass;
    private String callbackDescriptor;
    private int[] argIndices;
    private List<Integer> argMapVars;
    private LabelNode start;
    private LabelNode end;

    public Target(ClassNode classNode, MethodNode methodNode) {
        this.classNode = classNode;
        this.method = methodNode;
        this.insns = methodNode.instructions;
        this.isStatic = Bytecode.methodIsStatic(methodNode);
        this.isCtor = methodNode.name.equals(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20(".\ua7ef\ua4bb\ua078\ua911\u7d28"));
        this.arguments = Type.getArgumentTypes(methodNode.desc);
        this.returnType = Type.getReturnType(methodNode.desc);
        this.maxStack = methodNode.maxStack;
        this.maxLocals = methodNode.maxLocals;
    }

    public InjectionNodes.InjectionNode addInjectionNode(AbstractInsnNode abstractInsnNode) {
        return this.injectionNodes.add(abstractInsnNode);
    }

    public InjectionNodes.InjectionNode getInjectionNode(AbstractInsnNode abstractInsnNode) {
        return this.injectionNodes.get(abstractInsnNode);
    }

    public int getMaxLocals() {
        return this.maxLocals;
    }

    public int getMaxStack() {
        return this.maxStack;
    }

    public int getCurrentMaxLocals() {
        return this.method.maxLocals;
    }

    public int getCurrentMaxStack() {
        return this.method.maxStack;
    }

    public int allocateLocal() {
        return this.allocateLocals(0xC94F217C ^ 0xC94F217D);
    }

    public int allocateLocals(int n) {
        int n2 = this.method.maxLocals;
        this.method.maxLocals += n;
        return n2;
    }

    public void addToLocals(int n) {
        this.setMaxLocals(this.maxLocals + n);
    }

    public void setMaxLocals(int n) {
        if (n > this.method.maxLocals) {
            this.method.maxLocals = n;
        }
    }

    public void addToStack(int n) {
        this.setMaxStack(this.maxStack + n);
    }

    public void setMaxStack(int n) {
        if (n > this.method.maxStack) {
            this.method.maxStack = n;
        }
    }

    public int[] generateArgMap(Type[] typeArray, int n) {
        if (this.argMapVars == null) {
            this.argMapVars = new ArrayList<Integer>();
        }
        int[] nArray = new int[typeArray.length];
        int n2 = 0xF623F654 ^ 0xF623F654;
        for (int i = n; i < typeArray.length; ++i) {
            int n3 = typeArray[i].getSize();
            nArray[i] = this.allocateArgMapLocal(n2, n3);
            n2 += n3;
        }
        return nArray;
    }

    private int allocateArgMapLocal(int n, int n2) {
        if (n >= this.argMapVars.size()) {
            int n3 = this.allocateLocals(n2);
            for (int i = 0x9B05D360 ^ 0x9B05D360; i < n2; ++i) {
                this.argMapVars.add(n3 + i);
            }
            return n3;
        }
        int n4 = this.argMapVars.get(n);
        if (n2 > (0x2CFF499D ^ 0x2CFF499C) && n + n2 > this.argMapVars.size()) {
            int n5 = this.allocateLocals(0x9A2CD5DC ^ 0x9A2CD5DD);
            if (n5 == n4 + (0x8069BF75 ^ 0x8069BF74)) {
                this.argMapVars.add(n5);
                return n4;
            }
            this.argMapVars.set(n, n5);
            this.argMapVars.add(this.allocateLocals(0x5F3D6B55 ^ 0x5F3D6B54));
            return n5;
        }
        return n4;
    }

    public int[] getArgIndices() {
        if (this.argIndices == null) {
            this.argIndices = this.calcArgIndices(this.isStatic ? 0x3C1599E1 ^ 0x3C1599E1 : 0x3E0F44E ^ 0x3E0F44F);
        }
        return this.argIndices;
    }

    private int[] calcArgIndices(int n) {
        int[] nArray = new int[this.arguments.length];
        for (int i = 0x7F3562B6 ^ 0x7F3562B6; i < this.arguments.length; ++i) {
            nArray[i] = n;
            n += this.arguments[i].getSize();
        }
        return nArray;
    }

    public String getCallbackInfoClass() {
        if (this.callbackInfoClass == null) {
            this.callbackInfoClass = CallbackInfo.getCallInfoClassName(this.returnType);
        }
        return this.callbackInfoClass;
    }

    public String getSimpleCallbackDescriptor() {
        Object[] objectArray = new Object[0x8DAA764C ^ 0x8DAA764D];
        objectArray[0xD17C7B31 ^ 0xD17C7B31] = this.getCallbackInfoClass();
        return String.format(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20(":\ua7ca\ua4f0\ua062\ua95e\u7d3f\u8e7c"), objectArray);
    }

    public String getCallbackDescriptor(Type[] typeArray, Type[] typeArray2) {
        return this.getCallbackDescriptor((0xFFF2445E ^ 0xFFF2445E) != 0, typeArray, typeArray2, 0xC3C5213A ^ 0xC3C5213A, 0xAEE308EE ^ 0xAEE37711);
    }

    public String getCallbackDescriptor(boolean bl, Type[] typeArray, Type[] typeArray2, int n, int n2) {
        if (this.callbackDescriptor == null) {
            Object[] objectArray = new Object[0xFF924162 ^ 0xFF924160];
            objectArray[0x8AC63DC4 ^ 0x8AC63DC4] = this.method.desc.substring(0xB96FDFF0 ^ 0xB96FDFF1, this.method.desc.indexOf(0xC25ACCD1 ^ 0xC25ACCF8));
            objectArray[0x41E569A7 ^ 0x41E569A6] = this.getCallbackInfoClass();
            this.callbackDescriptor = String.format(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20(":\ua7a3\ua4a6\ua05d\ua940\u7d65\u8e11\u2433\u8b01"), objectArray);
        }
        if (!bl || typeArray == null) {
            return this.callbackDescriptor;
        }
        StringBuilder stringBuilder = new StringBuilder(this.callbackDescriptor.substring(0x45F9152 ^ 0x45F9152, this.callbackDescriptor.indexOf(0xF3D1D336 ^ 0xF3D1D31F)));
        for (int i = n; i < typeArray.length && n2 > 0; ++i) {
            if (typeArray[i] == null) continue;
            stringBuilder.append(typeArray[i].getDescriptor());
            --n2;
        }
        return stringBuilder.append(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20(";\ua7d0")).toString();
    }

    public String toString() {
        Object[] objectArray = new Object[0xF7873FFC ^ 0xF7873FFF];
        objectArray[0x9DC6988E ^ 0x9DC6988E] = this.classNode.name;
        objectArray[0x28A15DD8 ^ 0x28A15DD9] = this.method.name;
        objectArray[0x70F933AF ^ 0x70F933AD] = this.method.desc;
        return String.format(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("7\ua7f5\ua4ef\ua02b\ua940\u7d65\u8e0f\u2469"), objectArray);
    }

    @Override
    public int compareTo(Target target) {
        if (target == null) {
            return 0x90235AA2 ^ 0xEFDCA55D;
        }
        return this.toString().compareTo(target.toString());
    }

    public int indexOf(InjectionNodes.InjectionNode injectionNode) {
        return this.insns.indexOf(injectionNode.getCurrentTarget());
    }

    public int indexOf(AbstractInsnNode abstractInsnNode) {
        return this.insns.indexOf(abstractInsnNode);
    }

    public AbstractInsnNode get(int n) {
        return this.insns.get(n);
    }

    @Override
    public Iterator<AbstractInsnNode> iterator() {
        return this.insns.iterator();
    }

    public MethodInsnNode findInitNodeFor(TypeInsnNode typeInsnNode) {
        int n = this.indexOf(typeInsnNode);
        ListIterator<AbstractInsnNode> listIterator = this.insns.iterator(n);
        while (listIterator.hasNext()) {
            AbstractInsnNode abstractInsnNode = (AbstractInsnNode)listIterator.next();
            if (!(abstractInsnNode instanceof MethodInsnNode)) continue;
            if (abstractInsnNode.getOpcode() != (0x46A2514A ^ 0x46A251FD)) continue;
            MethodInsnNode methodInsnNode = (MethodInsnNode)abstractInsnNode;
            if (!\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20(".\ua7ef\ua4bb\ua078\ua911\u7d28").equals(methodInsnNode.name) || !methodInsnNode.owner.equals(typeInsnNode.desc)) continue;
            return methodInsnNode;
        }
        return null;
    }

    public MethodInsnNode findSuperInitNode() {
        if (!this.isCtor) {
            return null;
        }
        return Bytecode.findSuperInit(this.method, ClassInfo.forName(this.classNode.name).getSuperName());
    }

    public void insertBefore(InjectionNodes.InjectionNode injectionNode, InsnList insnList) {
        this.insns.insertBefore(injectionNode.getCurrentTarget(), insnList);
    }

    public void insertBefore(AbstractInsnNode abstractInsnNode, InsnList insnList) {
        this.insns.insertBefore(abstractInsnNode, insnList);
    }

    public void replaceNode(AbstractInsnNode abstractInsnNode, AbstractInsnNode abstractInsnNode2) {
        this.insns.insertBefore(abstractInsnNode, abstractInsnNode2);
        this.insns.remove(abstractInsnNode);
        this.injectionNodes.replace(abstractInsnNode, abstractInsnNode2);
    }

    public void replaceNode(AbstractInsnNode abstractInsnNode, AbstractInsnNode abstractInsnNode2, InsnList insnList) {
        this.insns.insertBefore(abstractInsnNode, insnList);
        this.insns.remove(abstractInsnNode);
        this.injectionNodes.replace(abstractInsnNode, abstractInsnNode2);
    }

    public void wrapNode(AbstractInsnNode abstractInsnNode, AbstractInsnNode abstractInsnNode2, InsnList insnList, InsnList insnList2) {
        this.insns.insertBefore(abstractInsnNode, insnList);
        this.insns.insert(abstractInsnNode, insnList2);
        this.injectionNodes.replace(abstractInsnNode, abstractInsnNode2);
    }

    public void replaceNode(AbstractInsnNode abstractInsnNode, InsnList insnList) {
        this.insns.insertBefore(abstractInsnNode, insnList);
        this.removeNode(abstractInsnNode);
    }

    public void removeNode(AbstractInsnNode abstractInsnNode) {
        this.insns.remove(abstractInsnNode);
        this.injectionNodes.remove(abstractInsnNode);
    }

    public void addLocalVariable(int n, String string, String string2) {
        if (this.start == null) {
            this.start = new LabelNode(new Label());
            this.end = new LabelNode(new Label());
            this.insns.insert(this.start);
            this.insns.add(this.end);
        }
        this.addLocalVariable(n, string, string2, this.start, this.end);
    }

    private void addLocalVariable(int n, String string, String string2, LabelNode labelNode, LabelNode labelNode2) {
        if (this.method.localVariables == null) {
            this.method.localVariables = new ArrayList<LocalVariableNode>();
        }
        this.method.localVariables.add(new LocalVariableNode(string, string2, null, labelNode, labelNode2, n));
    }
}

