/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.struct;

import org.spongepowered.asm.lib.tree.FieldInsnNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.mixin.transformer.throwables.MixinTransformerError;
import org.spongepowered.asm.util.Bytecode;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2;

public abstract class MemberRef {
    private static final int[] H_OPCODES;

    public abstract boolean isField();

    public abstract int getOpcode();

    public abstract void setOpcode(int var1);

    public abstract String getOwner();

    public abstract void setOwner(String var1);

    public abstract String getName();

    public abstract void setName(String var1);

    public abstract String getDesc();

    public abstract void setDesc(String var1);

    public String toString() {
        String string = Bytecode.getOpcodeName(this.getOpcode());
        Object[] objectArray = new Object[0x2EEC82A4 ^ 0x2EEC82A1];
        objectArray[0x27FD4BF7 ^ 0x27FD4BF7] = string;
        objectArray[0x7B970ED2 ^ 0x7B970ED3] = this.getOwner();
        objectArray[0xAB365FF5 ^ 0xAB365FF7] = this.getName();
        objectArray[0xB164AFD7 ^ 0xB164AFD4] = this.isField() ? \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("(") : \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("");
        objectArray[0xB693DB74 ^ 0xB693DB70] = this.getDesc();
        return String.format(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("7\ua7f5\ua4f5\ua077\ua90a\u7d64\u8e0a\u243f\u8b24\u34397\ua7f5\ua4f0\ua062\ua940\u7d65"), objectArray);
    }

    public boolean equals(Object object) {
        if (!(object instanceof MemberRef)) {
            return (0x9419D91C ^ 0x9419D91C) != 0;
        }
        MemberRef memberRef = (MemberRef)object;
        return (this.getOpcode() == memberRef.getOpcode() && this.getOwner().equals(memberRef.getOwner()) && this.getName().equals(memberRef.getName()) && this.getDesc().equals(memberRef.getDesc()) ? 0x591102C ^ 0x591102D : 0x9D1B187B ^ 0x9D1B187B) != 0;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    static int opcodeFromTag(int n) {
        return n >= 0 && n < H_OPCODES.length ? H_OPCODES[n] : 0x77C567FA ^ 0x77C567FA;
    }

    static int tagFromOpcode(int n) {
        for (int i = 0x1C9A82C ^ 0x1C9A82D; i < H_OPCODES.length; ++i) {
            if (H_OPCODES[i] != n) continue;
            return i;
        }
        return 0x4735A115 ^ 0x4735A115;
    }

    static {
        int[] nArray = new int[0x512EA7F8 ^ 0x512EA7F2];
        nArray[0x5A129BD5 ^ 0x5A129BD5] = 0x1DD2C014 ^ 0x1DD2C014;
        nArray[0xFD580A8A ^ 0xFD580A8B] = 0x4C4237F8 ^ 0x4C42374C;
        nArray[0xE169560E ^ 0xE169560C] = 0x6F88DB53 ^ 0x6F88DBE1;
        nArray[0x5388D6DF ^ 0x5388D6DC] = 0xBEE43626 ^ 0xBEE43693;
        nArray[0xF4A49EE6 ^ 0xF4A49EE2] = 0xAECB951D ^ 0xAECB95AE;
        nArray[0xF705A2E9 ^ 0xF705A2EC] = 0xA30BEB3E ^ 0xA30BEB88;
        nArray[0xFC55AE9C ^ 0xFC55AE9A] = 0x35D79006 ^ 0x35D790BE;
        nArray[0x70A75925 ^ 0x70A75922] = 0xFC2BCAD0 ^ 0xFC2BCA67;
        nArray[0xEBD197B5 ^ 0xEBD197BD] = 0x4AE3962 ^ 0x4AE39D5;
        nArray[0x2D6DDB0A ^ 0x2D6DDB03] = 0x6D434E3C ^ 0x6D434E85;
        H_OPCODES = nArray;
    }

    public static final class Handle
    extends MemberRef {
        private org.spongepowered.asm.lib.Handle handle;

        public Handle(org.spongepowered.asm.lib.Handle handle) {
            this.handle = handle;
        }

        public org.spongepowered.asm.lib.Handle getMethodHandle() {
            return this.handle;
        }

        @Override
        public boolean isField() {
            switch (this.handle.getTag()) {
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    return (0x2480504 ^ 0x2480504) != 0;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    return (0xA0CE4EF1 ^ 0xA0CE4EF0) != 0;
                }
            }
            throw new MixinTransformerError(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b23\u3476u\ua7a6") + this.handle.getTag() + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2\ua7e0\ua4ba\ua063\ua945\u7d7b\u8e4f\u246e\u8b3f\u3478v\ua7a6\ua4bd\ua070\ua90b\u7d72\u8e46\u247f\u8b77") + this.handle + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("<"));
        }

        @Override
        public int getOpcode() {
            int n = MemberRef.opcodeFromTag(this.handle.getTag());
            if (n == 0) {
                throw new MixinTransformerError(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b23\u3476u\ua7a6") + this.handle.getTag() + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2\ua7e0\ua4ba\ua063\ua945\u7d7b\u8e4f\u246e\u8b3f\u3478v\ua7a6\ua4bd\ua070\ua90b\u7d72\u8e46\u247f\u8b77") + this.handle + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("<"));
            }
            return n;
        }

        @Override
        public void setOpcode(int n) {
            int n2 = MemberRef.tagFromOpcode(n);
            if (n2 == 0) {
                throw new MixinTransformerError(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b38\u3467q\ua7e9\ua4b1\ua074\ua945") + Bytecode.getOpcodeName(n) + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2\ua7e0\ua4ba\ua063\ua945\u7d7b\u8e4f\u246e\u8b3f\u3478v\ua7a6\ua4bd\ua070\ua90b\u7d72\u8e46\u247f\u8b77") + this.handle + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("<"));
            }
            int n3 = n2 == (0x7D5AF6F9 ^ 0x7D5AF6F0) ? 0x4CA7AF38 ^ 0x4CA7AF39 : 0x169B8EDA ^ 0x169B8EDA;
            this.handle = new org.spongepowered.asm.lib.Handle(n2, this.handle.getOwner(), this.handle.getName(), this.handle.getDesc(), n3 != 0);
        }

        @Override
        public String getOwner() {
            return this.handle.getOwner();
        }

        @Override
        public void setOwner(String string) {
            int n = this.handle.getTag() == (0x42FE0178 ^ 0x42FE0171) ? 0xAA62B1DA ^ 0xAA62B1DB : 0x3C07E13D ^ 0x3C07E13D;
            this.handle = new org.spongepowered.asm.lib.Handle(this.handle.getTag(), string, this.handle.getName(), this.handle.getDesc(), n != 0);
        }

        @Override
        public String getName() {
            return this.handle.getName();
        }

        @Override
        public void setName(String string) {
            int n = this.handle.getTag() == (0x29493F8F ^ 0x29493F86) ? 0x43906E8B ^ 0x43906E8A : 0x30BAC06C ^ 0x30BAC06C;
            this.handle = new org.spongepowered.asm.lib.Handle(this.handle.getTag(), this.handle.getOwner(), string, this.handle.getDesc(), n != 0);
        }

        @Override
        public String getDesc() {
            return this.handle.getDesc();
        }

        @Override
        public void setDesc(String string) {
            int n = this.handle.getTag() == (0x364BBE5C ^ 0x364BBE55) ? 0x8BBD7AF0 ^ 0x8BBD7AF1 : 0x596BE15A ^ 0x596BE15A;
            this.handle = new org.spongepowered.asm.lib.Handle(this.handle.getTag(), this.handle.getOwner(), this.handle.getName(), string, n != 0);
        }
    }

    public static final class Field
    extends MemberRef {
        private static final int OPCODES = 183;
        public final FieldInsnNode insn;

        public Field(FieldInsnNode fieldInsnNode) {
            this.insn = fieldInsnNode;
        }

        @Override
        public boolean isField() {
            return (0xD702162E ^ 0xD702162F) != 0;
        }

        @Override
        public int getOpcode() {
            return this.insn.getOpcode();
        }

        @Override
        public void setOpcode(int n) {
            if ((n & (0xF9CC8876 ^ 0xF9CC88C1)) == 0) {
                throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b38\u3467q\ua7e9\ua4b1\ua074\ua945\u7d70\u8e45\u2468\u8b77\u3471{\ua7e3\ua4b9\ua075\ua945\u7d7f\u8e44\u2469\u8b23\u3465g\ua7e5\ua4a1\ua078\ua90a\u7d78\u8e10\u243a\u8b67\u346f") + Integer.toHexString(n));
            }
            this.insn.setOpcode(n);
        }

        @Override
        public String getOwner() {
            return this.insn.owner;
        }

        @Override
        public void setOwner(String string) {
            this.insn.owner = string;
        }

        @Override
        public String getName() {
            return this.insn.name;
        }

        @Override
        public void setName(String string) {
            this.insn.name = string;
        }

        @Override
        public String getDesc() {
            return this.insn.desc;
        }

        @Override
        public void setDesc(String string) {
            this.insn.desc = string;
        }
    }

    public static final class Method
    extends MemberRef {
        private static final int OPCODES = 191;
        public final MethodInsnNode insn;

        public Method(MethodInsnNode methodInsnNode) {
            this.insn = methodInsnNode;
        }

        @Override
        public boolean isField() {
            return (0x18D48470 ^ 0x18D48470) != 0;
        }

        @Override
        public int getOpcode() {
            return this.insn.getOpcode();
        }

        @Override
        public void setOpcode(int n) {
            if ((n & (0x3F77F8DC ^ 0x3F77F863)) == 0) {
                throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b38\u3467q\ua7e9\ua4b1\ua074\ua945\u7d70\u8e45\u2468\u8b77\u347aw\ua7f2\ua4bd\ua07e\ua901\u7d36\u8e43\u2474\u8b24\u3463`\ua7f3\ua4b6\ua065\ua90c\u7d79\u8e44\u2420\u8b77\u3427j") + Integer.toHexString(n));
            }
            this.insn.setOpcode(n);
        }

        @Override
        public String getOwner() {
            return this.insn.owner;
        }

        @Override
        public void setOwner(String string) {
            this.insn.owner = string;
        }

        @Override
        public String getName() {
            return this.insn.name;
        }

        @Override
        public void setName(String string) {
            this.insn.name = string;
        }

        @Override
        public String getDesc() {
            return this.insn.desc;
        }

        @Override
        public void setDesc(String string) {
            this.insn.desc = string;
        }
    }
}

