/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.lib.tree.FieldInsnNode;
import org.spongepowered.asm.lib.tree.FieldNode;
import org.spongepowered.asm.lib.tree.FrameNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.gen.Invoker;
import org.spongepowered.asm.mixin.transformer.MethodMapper;
import org.spongepowered.asm.mixin.transformer.MixinInfo;
import org.spongepowered.asm.service.MixinService;
import org.spongepowered.asm.util.Annotations;
import org.spongepowered.asm.util.ClassSignature;
import org.spongepowered.asm.util.perf.Profiler;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2;

public final class ClassInfo {
    public static final int INCLUDE_PRIVATE = 2;
    public static final int INCLUDE_STATIC = 8;
    public static final int INCLUDE_ALL = 10;
    private static final Logger logger = LogManager.getLogger((String)\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("\u007f\ua7ef\ua4ad\ua078\ua90b"));
    private static final Profiler profiler = MixinEnvironment.getProfiler();
    private static final String JAVA_LANG_OBJECT = "java/lang/Object";
    private static final Map<String, ClassInfo> cache = new HashMap<String, ClassInfo>();
    private static final ClassInfo OBJECT = new ClassInfo();
    private final String name;
    private final String superName;
    private final String outerName;
    private final boolean isProbablyStatic;
    private final Set<String> interfaces;
    private final Set<Method> methods;
    private final Set<Field> fields;
    private final Set<MixinInfo> mixins = new HashSet<MixinInfo>();
    private final Map<ClassInfo, ClassInfo> correspondingTypes = new HashMap<ClassInfo, ClassInfo>();
    private final MixinInfo mixin;
    private final MethodMapper methodMapper;
    private final boolean isMixin;
    private final boolean isInterface;
    private final int access;
    private ClassInfo superClass;
    private ClassInfo outerClass;
    private ClassSignature signature;

    private ClassInfo() {
        this.name = \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438]\ua7e4\ua4bf\ua074\ua906\u7d62");
        this.superName = null;
        this.outerName = null;
        this.isProbablyStatic = 0xF3EC43F8 ^ 0xF3EC43F9;
        Object[] objectArray = new Method[0x16255361 ^ 0x16255364];
        objectArray[0x4B912121 ^ 0x4B912121] = new Method(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("|\ua7e9\ua4a1\ua078\ua903\u7d6f\u8e6b\u2476\u8b3b"), \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20(":\ua7af\ua483"));
        objectArray[0x7E3C544D ^ 0x7E3C544C] = new Method(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("e\ua7e7\ua4bc\ua065"), \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20(":\ua7cc\ua4fc\ua047"));
        objectArray[0xF6FBAB64 ^ 0xF6FBAB66] = new Method(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("e\ua7e7\ua4bc\ua065"), \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20(":\ua7cc\ua49c\ua038\ua933"));
        objectArray[0x9197638E ^ 0x9197638D] = new Method(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("e\ua7e7\ua4bc\ua065"), \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20(":\ua7af\ua483"));
        objectArray[0x1821DE3E ^ 0x1821DE3A] = new Method(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("t\ua7ef\ua4bb\ua070\ua909\u7d7f\u8e50\u247f"), \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20(":\ua7af\ua483"));
        this.methods = ImmutableSet.of((Object)new Method(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("u\ua7e3\ua4a1\ua052\ua909\u7d77\u8e59\u2469"), \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20(":\ua7af\ua499\ua07b\ua904\u7d60\u8e4b\u2435\u8b3b\u3476|\ua7e1\ua4fa\ua052\ua909\u7d77\u8e59\u2469\u8b6c")), (Object)new Method(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("z\ua7e7\ua4a6\ua079\ua926\u7d79\u8e4e\u247f"), \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20(":\ua7af\ua49c")), (Object)new Method(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("w\ua7f7\ua4a0\ua070\ua909\u7d65"), \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20(":\ua7ca\ua4bf\ua070\ua913\u7d77\u8e05\u2476\u8b36\u3479u\ua7a9\ua49a\ua073\ua90f\u7d73\u8e49\u246e\u8b6c\u343eH")), (Object)new Method(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("q\ua7ea\ua4ba\ua07f\ua900"), \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20(":\ua7af\ua499\ua07b\ua904\u7d60\u8e4b\u2435\u8b3b\u3476|\ua7e1\ua4fa\ua05e\ua907\u7d7c\u8e4f\u2479\u8b23\u342c")), (Object)new Method(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("f\ua7e9\ua486\ua065\ua917\u7d7f\u8e44\u247d"), \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20(":\ua7af\ua499\ua07b\ua904\u7d60\u8e4b\u2435\u8b3b\u3476|\ua7e1\ua4fa\ua042\ua911\u7d64\u8e43\u2474\u8b30\u342c")), (Object)new Method(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("|\ua7e9\ua4a1\ua078\ua903\u7d6f"), \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20(":\ua7af\ua483")), (Object[])objectArray);
        this.fields = Collections.emptySet();
        this.isInterface = 0x492DDFB7 ^ 0x492DDFB7;
        this.interfaces = Collections.emptySet();
        this.access = 0x3E65122B ^ 0x3E65122A;
        this.isMixin = 0xA7114624 ^ 0xA7114624;
        this.mixin = null;
        this.methodMapper = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private ClassInfo(ClassNode classNode) {
        Profiler.Section section = profiler.begin(0x55673A6A ^ 0x55673A6B, \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("q\ua7ea\ua4b4\ua062\ua916\u7d38\u8e47\u247f\u8b23\u3476"));
        try {
            void var4_7;
            this.name = classNode.name;
            this.superName = classNode.superName != null ? classNode.superName : \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438]\ua7e4\ua4bf\ua074\ua906\u7d62");
            this.methods = new HashSet<Method>();
            this.fields = new HashSet<Field>();
            this.isInterface = (classNode.access & (0x52300307 ^ 0x52300107)) != 0 ? 0xF00C29F ^ 0xF00C29E : 0xEB8BF4BC ^ 0xEB8BF4BC;
            this.interfaces = new HashSet<String>();
            this.access = classNode.access;
            this.isMixin = classNode instanceof MixinInfo.MixinClassNode;
            this.mixin = this.isMixin ? ((MixinInfo.MixinClassNode)classNode).getMixin() : null;
            this.interfaces.addAll(classNode.interfaces);
            for (MethodNode object2 : classNode.methods) {
                this.addMethod(object2, this.isMixin);
            }
            int n = 0x25ED4063 ^ 0x25ED4062;
            String string = classNode.outerClass;
            for (FieldNode fieldNode : classNode.fields) {
                if ((fieldNode.access & (0xCC313376 ^ 0xCC312376)) != 0 && fieldNode.name.startsWith(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("f\ua7ee\ua4bc\ua062\ua941"))) {
                    String string2;
                    n = 0x9C830CA4 ^ 0x9C830CA4;
                    if (var4_7 == null && (string2 = fieldNode.desc) != null && string2.startsWith(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("^"))) {
                        String string3 = string2.substring(0xA06BB3C9 ^ 0xA06BB3C8, string2.length() - (0x312CD0A3 ^ 0x312CD0A2));
                    }
                }
                this.fields.add(new Field(fieldNode, this.isMixin));
            }
            this.isProbablyStatic = n;
            this.outerName = var4_7;
            this.methodMapper = new MethodMapper(MixinEnvironment.getCurrentEnvironment(), this);
            this.signature = ClassSignature.ofLazy(classNode);
        }
        finally {
            section.end();
        }
    }

    void addInterface(String string) {
        this.interfaces.add(string);
        this.getSignature().addInterface(string);
    }

    void addMethod(MethodNode methodNode) {
        this.addMethod(methodNode, (0x3199711 ^ 0x3199710) != 0);
    }

    private void addMethod(MethodNode methodNode, boolean bl) {
        if (!methodNode.name.startsWith(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("."))) {
            this.methods.add(new Method(methodNode, bl));
        }
    }

    void addMixin(MixinInfo mixinInfo) {
        if (this.isMixin) {
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("Q\ua7e7\ua4bb\ua07f\ua90a\u7d62\u8e0a\u247b\u8b33\u34732\ua7f2\ua4b4\ua063\ua902\u7d73\u8e5e\u243a") + this.name + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2\ua7e0\ua4ba\ua063\ua945") + mixinInfo.getClassName() + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2\ua7e4\ua4b0\ua072\ua904\u7d63\u8e59\u247f\u8b77\u3463z\ua7e3\ua4f5\ua065\ua904\u7d64\u8e4d\u247f\u8b23\u3437{\ua7f5\ua4f5\ua070\ua945\u7d7b\u8e43\u2462\u8b3e\u3479"));
        }
        this.mixins.add(mixinInfo);
    }

    public Set<MixinInfo> getMixins() {
        return Collections.unmodifiableSet(this.mixins);
    }

    public boolean isMixin() {
        return this.isMixin;
    }

    public boolean isPublic() {
        return ((this.access & (0x471522BE ^ 0x471522BF)) != 0 ? 0xD435F902 ^ 0xD435F903 : 0xF7E245AC ^ 0xF7E245AC) != 0;
    }

    public boolean isAbstract() {
        return ((this.access & (0xCE9A1C7B ^ 0xCE9A187B)) != 0 ? 0xE78B7531 ^ 0xE78B7530 : 0x1FE2A530 ^ 0x1FE2A530) != 0;
    }

    public boolean isSynthetic() {
        return ((this.access & (0xAA65C9D5 ^ 0xAA65D9D5)) != 0 ? 0x4883B776 ^ 0x4883B777 : 0x6A3D409B ^ 0x6A3D409B) != 0;
    }

    public boolean isProbablyStatic() {
        return this.isProbablyStatic;
    }

    public boolean isInner() {
        return (this.outerName != null ? 0xA20835E7 ^ 0xA20835E6 : 0xBA59FB34 ^ 0xBA59FB34) != 0;
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public Set<String> getInterfaces() {
        return Collections.unmodifiableSet(this.interfaces);
    }

    public String toString() {
        return this.name;
    }

    public MethodMapper getMethodMapper() {
        return this.methodMapper;
    }

    public int getAccess() {
        return this.access;
    }

    public String getName() {
        return this.name;
    }

    public String getClassName() {
        return this.name.replace((char)(0x7D8E7915 ^ 0x7D8E793A), (char)(0x68ACE51C ^ 0x68ACE532));
    }

    public String getSuperName() {
        return this.superName;
    }

    public ClassInfo getSuperClass() {
        if (this.superClass == null && this.superName != null) {
            this.superClass = ClassInfo.forName(this.superName);
        }
        return this.superClass;
    }

    public String getOuterName() {
        return this.outerName;
    }

    public ClassInfo getOuterClass() {
        if (this.outerClass == null && this.outerName != null) {
            this.outerClass = ClassInfo.forName(this.outerName);
        }
        return this.outerClass;
    }

    public ClassSignature getSignature() {
        return this.signature.wake();
    }

    List<ClassInfo> getTargets() {
        if (this.mixin != null) {
            ArrayList<ClassInfo> arrayList = new ArrayList<ClassInfo>();
            arrayList.add(this);
            arrayList.addAll(this.mixin.getTargets());
            return arrayList;
        }
        return ImmutableList.of((Object)this);
    }

    public Set<Method> getMethods() {
        return Collections.unmodifiableSet(this.methods);
    }

    public Set<Method> getInterfaceMethods(boolean bl) {
        HashSet<Method> hashSet = new HashSet<Method>();
        if (!this.isInterface) {
            for (ClassInfo classInfo = this.addMethodsRecursive(hashSet, bl); classInfo != null && classInfo != OBJECT; classInfo = classInfo.addMethodsRecursive(hashSet, bl)) {
            }
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            if (((Method)iterator.next()).isAbstract()) continue;
            iterator.remove();
        }
        return Collections.unmodifiableSet(hashSet);
    }

    private ClassInfo addMethodsRecursive(Set<Method> set, boolean bl) {
        if (this.isInterface) {
            for (Method object : this.methods) {
                if (!object.isAbstract()) {
                    set.remove(object);
                }
                set.add(object);
            }
        } else if (!this.isMixin && bl) {
            for (MixinInfo mixinInfo : this.mixins) {
                mixinInfo.getClassInfo().addMethodsRecursive(set, bl);
            }
        }
        for (String string : this.interfaces) {
            ClassInfo.forName(string).addMethodsRecursive(set, bl);
        }
        return this.getSuperClass();
    }

    public boolean hasSuperClass(String string) {
        return this.hasSuperClass(string, Traversal.NONE);
    }

    public boolean hasSuperClass(String string, Traversal traversal) {
        if (\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438]\ua7e4\ua4bf\ua074\ua906\u7d62").equals(string)) {
            return (0xE557EA37 ^ 0xE557EA36) != 0;
        }
        return (this.findSuperClass(string, traversal) != null ? 0xD5CC74BB ^ 0xD5CC74BA : 0x3B00C2E5 ^ 0x3B00C2E5) != 0;
    }

    public boolean hasSuperClass(ClassInfo classInfo) {
        return this.hasSuperClass(classInfo, Traversal.NONE, (0xCD64FEA6 ^ 0xCD64FEA6) != 0);
    }

    public boolean hasSuperClass(ClassInfo classInfo, Traversal traversal) {
        return this.hasSuperClass(classInfo, traversal, (0xC384F350 ^ 0xC384F350) != 0);
    }

    public boolean hasSuperClass(ClassInfo classInfo, Traversal traversal, boolean bl) {
        if (OBJECT == classInfo) {
            return (0x501BD17E ^ 0x501BD17F) != 0;
        }
        return (this.findSuperClass(classInfo.name, traversal, bl) != null ? 0xA5BC907B ^ 0xA5BC907A : 0xFC1E8DD4 ^ 0xFC1E8DD4) != 0;
    }

    public ClassInfo findSuperClass(String string) {
        return this.findSuperClass(string, Traversal.NONE);
    }

    public ClassInfo findSuperClass(String string, Traversal traversal) {
        return this.findSuperClass(string, traversal, (0xB31EBD07 ^ 0xB31EBD07) != 0, new HashSet<String>());
    }

    public ClassInfo findSuperClass(String string, Traversal traversal, boolean bl) {
        if (ClassInfo.OBJECT.name.equals(string)) {
            return null;
        }
        return this.findSuperClass(string, traversal, bl, new HashSet<String>());
    }

    private ClassInfo findSuperClass(String string, Traversal traversal, boolean bl, Set<String> set) {
        Object object;
        Iterator<MixinInfo> iterator;
        ClassInfo classInfo = this.getSuperClass();
        if (classInfo != null) {
            iterator = classInfo.getTargets().iterator();
            while (iterator.hasNext()) {
                ClassInfo object2 = (ClassInfo)iterator.next();
                if (string.equals(object2.getName())) {
                    return classInfo;
                }
                object = object2.findSuperClass(string, traversal.next(), bl, set);
                if (object == null) continue;
                return object;
            }
        }
        if (bl && (iterator = this.findInterface(string)) != null) {
            return iterator;
        }
        if (traversal.canTraverse()) {
            for (MixinInfo mixinInfo : this.mixins) {
                object = mixinInfo.getClassName();
                if (set.contains(object)) continue;
                set.add((String)object);
                ClassInfo classInfo2 = mixinInfo.getClassInfo();
                if (string.equals(classInfo2.getName())) {
                    return classInfo2;
                }
                ClassInfo classInfo3 = classInfo2.findSuperClass(string, Traversal.ALL, bl, set);
                if (classInfo3 == null) continue;
                return classInfo3;
            }
        }
        return null;
    }

    private ClassInfo findInterface(String string) {
        for (String string2 : this.getInterfaces()) {
            ClassInfo classInfo = ClassInfo.forName(string2);
            if (string.equals(string2)) {
                return classInfo;
            }
            ClassInfo classInfo2 = classInfo.findInterface(string);
            if (classInfo2 == null) continue;
            return classInfo2;
        }
        return null;
    }

    ClassInfo findCorrespondingType(ClassInfo classInfo) {
        if (classInfo == null || !classInfo.isMixin || this.isMixin) {
            return null;
        }
        ClassInfo classInfo2 = this.correspondingTypes.get(classInfo);
        if (classInfo2 == null) {
            classInfo2 = this.findSuperTypeForMixin(classInfo);
            this.correspondingTypes.put(classInfo, classInfo2);
        }
        return classInfo2;
    }

    private ClassInfo findSuperTypeForMixin(ClassInfo classInfo) {
        for (ClassInfo classInfo2 = this; classInfo2 != null && classInfo2 != OBJECT; classInfo2 = classInfo2.getSuperClass()) {
            for (MixinInfo mixinInfo : classInfo2.mixins) {
                if (!mixinInfo.getClassInfo().equals(classInfo)) continue;
                return classInfo2;
            }
        }
        return null;
    }

    public boolean hasMixinInHierarchy() {
        if (!this.isMixin) {
            return (0xDA20C2CE ^ 0xDA20C2CE) != 0;
        }
        for (ClassInfo classInfo = this.getSuperClass(); classInfo != null && classInfo != OBJECT; classInfo = classInfo.getSuperClass()) {
            if (!classInfo.isMixin) continue;
            return (0x24AC4E7D ^ 0x24AC4E7C) != 0;
        }
        return (0x1334EE30 ^ 0x1334EE30) != 0;
    }

    public boolean hasMixinTargetInHierarchy() {
        if (this.isMixin) {
            return (0x71EDAFA5 ^ 0x71EDAFA5) != 0;
        }
        for (ClassInfo classInfo = this.getSuperClass(); classInfo != null && classInfo != OBJECT; classInfo = classInfo.getSuperClass()) {
            if (classInfo.mixins.size() <= 0) continue;
            return (0x43A7597C ^ 0x43A7597D) != 0;
        }
        return (0xE3775356 ^ 0xE3775356) != 0;
    }

    public Method findMethodInHierarchy(MethodNode methodNode, SearchType searchType) {
        return this.findMethodInHierarchy(methodNode.name, methodNode.desc, searchType, Traversal.NONE);
    }

    public Method findMethodInHierarchy(MethodNode methodNode, SearchType searchType, int n) {
        return this.findMethodInHierarchy(methodNode.name, methodNode.desc, searchType, Traversal.NONE, n);
    }

    public Method findMethodInHierarchy(MethodInsnNode methodInsnNode, SearchType searchType) {
        return this.findMethodInHierarchy(methodInsnNode.name, methodInsnNode.desc, searchType, Traversal.NONE);
    }

    public Method findMethodInHierarchy(MethodInsnNode methodInsnNode, SearchType searchType, int n) {
        return this.findMethodInHierarchy(methodInsnNode.name, methodInsnNode.desc, searchType, Traversal.NONE, n);
    }

    public Method findMethodInHierarchy(String string, String string2, SearchType searchType) {
        return this.findMethodInHierarchy(string, string2, searchType, Traversal.NONE);
    }

    public Method findMethodInHierarchy(String string, String string2, SearchType searchType, Traversal traversal) {
        return this.findMethodInHierarchy(string, string2, searchType, traversal, 0xE9D4009E ^ 0xE9D4009E);
    }

    public Method findMethodInHierarchy(String string, String string2, SearchType searchType, Traversal traversal, int n) {
        return (Method)this.findInHierarchy(string, string2, searchType, traversal, n, Member.Type.METHOD);
    }

    public Field findFieldInHierarchy(FieldNode fieldNode, SearchType searchType) {
        return this.findFieldInHierarchy(fieldNode.name, fieldNode.desc, searchType, Traversal.NONE);
    }

    public Field findFieldInHierarchy(FieldNode fieldNode, SearchType searchType, int n) {
        return this.findFieldInHierarchy(fieldNode.name, fieldNode.desc, searchType, Traversal.NONE, n);
    }

    public Field findFieldInHierarchy(FieldInsnNode fieldInsnNode, SearchType searchType) {
        return this.findFieldInHierarchy(fieldInsnNode.name, fieldInsnNode.desc, searchType, Traversal.NONE);
    }

    public Field findFieldInHierarchy(FieldInsnNode fieldInsnNode, SearchType searchType, int n) {
        return this.findFieldInHierarchy(fieldInsnNode.name, fieldInsnNode.desc, searchType, Traversal.NONE, n);
    }

    public Field findFieldInHierarchy(String string, String string2, SearchType searchType) {
        return this.findFieldInHierarchy(string, string2, searchType, Traversal.NONE);
    }

    public Field findFieldInHierarchy(String string, String string2, SearchType searchType, Traversal traversal) {
        return this.findFieldInHierarchy(string, string2, searchType, traversal, 0xF854405F ^ 0xF854405F);
    }

    public Field findFieldInHierarchy(String string, String string2, SearchType searchType, Traversal traversal, int n) {
        return (Field)this.findInHierarchy(string, string2, searchType, traversal, n, Member.Type.FIELD);
    }

    private <M extends Member> M findInHierarchy(String string, String string2, SearchType searchType, Traversal traversal, int n, Member.Type type) {
        ClassInfo classInfo;
        ClassInfo classInfo2;
        if (searchType == SearchType.ALL_CLASSES) {
            classInfo2 = this.findMember(string, string2, n, type);
            if (classInfo2 != null) {
                return (M)classInfo2;
            }
            if (traversal.canTraverse()) {
                for (MixinInfo object : this.mixins) {
                    classInfo = object.getClassInfo().findMember(string, string2, n, type);
                    if (classInfo == null) continue;
                    return (M)this.cloneMember(classInfo);
                }
            }
        }
        if ((classInfo2 = this.getSuperClass()) != null) {
            for (ClassInfo classInfo3 : classInfo2.getTargets()) {
                classInfo = classInfo3.findInHierarchy(string, string2, SearchType.ALL_CLASSES, traversal.next(), n & (0x7D233A91 ^ 0x82DCC56C), type);
                if (classInfo == null) continue;
                return (M)classInfo;
            }
        }
        if (type == Member.Type.METHOD && (this.isInterface || MixinEnvironment.getCompatibilityLevel().supportsMethodsInInterfaces())) {
            for (String string3 : this.interfaces) {
                classInfo = ClassInfo.forName(string3);
                if (classInfo == null) {
                    Object[] objectArray = new Object[0x1DA4E9A2 ^ 0x1DA4E9A0];
                    objectArray[0x1EFF22DE ^ 0x1EFF22DE] = string3;
                    objectArray[0x4C9B899B ^ 0x4C9B899A] = this.name;
                    logger.debug(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("T\ua7e7\ua4bc\ua07d\ua900\u7d72\u8e0a\u246e\u8b38\u3437`\ua7e3\ua4a6\ua07e\ua909\u7d60\u8e4f\u243a\u8b33\u3472q\ua7ea\ua4b4\ua063\ua900\u7d72\u8e0a\u2473\u8b39\u3463w\ua7f4\ua4b3\ua070\ua906\u7d73\u8e0a\u2461\u8b2a\u3437}\ua7e8\ua4f5\ua06a\ua918"), objectArray);
                    continue;
                }
                M m = classInfo.findInHierarchy(string, string2, SearchType.ALL_CLASSES, traversal.next(), n & (0x6BCAA037 ^ 0x94355FCA), type);
                if (m == null) continue;
                return (M)(this.isInterface ? m : new InterfaceMethod((Member)m));
            }
        }
        return null;
    }

    private <M extends Member> M cloneMember(M m) {
        if (m instanceof Method) {
            return (M)new Method(m);
        }
        return (M)new Field(m);
    }

    public Method findMethod(MethodNode methodNode) {
        return this.findMethod(methodNode.name, methodNode.desc, methodNode.access);
    }

    public Method findMethod(MethodNode methodNode, int n) {
        return this.findMethod(methodNode.name, methodNode.desc, n);
    }

    public Method findMethod(MethodInsnNode methodInsnNode) {
        return this.findMethod(methodInsnNode.name, methodInsnNode.desc, 0xAA4074D0 ^ 0xAA4074D0);
    }

    public Method findMethod(MethodInsnNode methodInsnNode, int n) {
        return this.findMethod(methodInsnNode.name, methodInsnNode.desc, n);
    }

    public Method findMethod(String string, String string2, int n) {
        return (Method)this.findMember(string, string2, n, Member.Type.METHOD);
    }

    public Field findField(FieldNode fieldNode) {
        return this.findField(fieldNode.name, fieldNode.desc, fieldNode.access);
    }

    public Field findField(FieldInsnNode fieldInsnNode, int n) {
        return this.findField(fieldInsnNode.name, fieldInsnNode.desc, n);
    }

    public Field findField(String string, String string2, int n) {
        return (Field)this.findMember(string, string2, n, Member.Type.FIELD);
    }

    private <M extends Member> M findMember(String string, String string2, int n, Member.Type type) {
        Set<Member> set = type == Member.Type.METHOD ? this.methods : this.fields;
        for (Member member : set) {
            if (!member.equals(string, string2) || !member.matchesFlags(n)) continue;
            return (M)member;
        }
        return null;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ClassInfo)) {
            return (0x8C964F03 ^ 0x8C964F03) != 0;
        }
        return ((ClassInfo)object).name.equals(this.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    static ClassInfo fromClassNode(ClassNode classNode) {
        ClassInfo classInfo = cache.get(classNode.name);
        if (classInfo == null) {
            classInfo = new ClassInfo(classNode);
            cache.put(classNode.name, classInfo);
        }
        return classInfo;
    }

    public static ClassInfo forName(String string) {
        ClassInfo classInfo = cache.get(string = string.replace((char)(0xA0EDB03E ^ 0xA0EDB010), (char)(0x58046312 ^ 0x5804633D)));
        if (classInfo == null) {
            try {
                ClassNode classNode = MixinService.getService().getBytecodeProvider().getClassNode(string);
                classInfo = new ClassInfo(classNode);
            }
            catch (Exception exception) {
                logger.catching(Level.TRACE, (Throwable)exception);
                Object[] objectArray = new Object[0xA5D8E8DD ^ 0xA5D8E8DE];
                objectArray[0x16C411D7 ^ 0x16C411D7] = string;
                objectArray[0x63DC743A ^ 0x63DC743B] = exception.getClass().getName();
                objectArray[0xE129FD2C ^ 0xE129FD2E] = exception.getMessage();
                logger.warn(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("W\ua7f4\ua4a7\ua07e\ua917\u7d36\u8e46\u2475\u8b36\u3473{\ua7e8\ua4b2\ua031\ua906\u7d7a\u8e4b\u2469\u8b24\u342d2\ua7fd\ua4a8\ua031\ua94d\u7d6d\u8e57\u2420\u8b77\u346co\ua7af"), objectArray);
            }
            cache.put(string, classInfo);
            Object[] objectArray = new Object[0x78EC4901 ^ 0x78EC4900];
            objectArray[0xA856C462 ^ 0xA856C462] = string;
            logger.trace(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("S\ua7e2\ua4b1\ua074\ua901\u7d36\u8e49\u2476\u8b36\u3464a\ua7a6\ua4b8\ua074\ua911\u7d77\u8e4e\u247b\u8b23\u34762\ua7e0\ua4ba\ua063\ua945\u7d6d\u8e57\u243a\u8b23\u34782\ua7eb\ua4b0\ua065\ua904\u7d72\u8e4b\u246e\u8b36\u3437q\ua7e7\ua4b6\ua079\ua900"), objectArray);
        }
        return classInfo;
    }

    public static ClassInfo forType(Type type) {
        if (type.getSort() == (0x201E106E ^ 0x201E1067)) {
            return ClassInfo.forType(type.getElementType());
        }
        if (type.getSort() < (0xB1BB9F9A ^ 0xB1BB9F93)) {
            return null;
        }
        return ClassInfo.forName(type.getClassName().replace((char)(0xE1FBB983 ^ 0xE1FBB9AD), (char)(0x7BE9951C ^ 0x7BE99533)));
    }

    public static ClassInfo getCommonSuperClass(String string, String string2) {
        if (string == null || string2 == null) {
            return OBJECT;
        }
        return ClassInfo.getCommonSuperClass(ClassInfo.forName(string), ClassInfo.forName(string2));
    }

    public static ClassInfo getCommonSuperClass(Type type, Type type2) {
        block3: {
            block2: {
                if (type == null || type2 == null) break block2;
                if (type.getSort() != (0x4A0EF5BA ^ 0x4A0EF5B0)) break block2;
                if (type2.getSort() == (0xB95F6CEE ^ 0xB95F6CE4)) break block3;
            }
            return OBJECT;
        }
        return ClassInfo.getCommonSuperClass(ClassInfo.forType(type), ClassInfo.forType(type2));
    }

    private static ClassInfo getCommonSuperClass(ClassInfo classInfo, ClassInfo classInfo2) {
        return ClassInfo.getCommonSuperClass(classInfo, classInfo2, (0xE55A434 ^ 0xE55A434) != 0);
    }

    public static ClassInfo getCommonSuperClassOrInterface(String string, String string2) {
        if (string == null || string2 == null) {
            return OBJECT;
        }
        return ClassInfo.getCommonSuperClassOrInterface(ClassInfo.forName(string), ClassInfo.forName(string2));
    }

    public static ClassInfo getCommonSuperClassOrInterface(Type type, Type type2) {
        block3: {
            block2: {
                if (type == null || type2 == null) break block2;
                if (type.getSort() != (0xD192B6EA ^ 0xD192B6E0)) break block2;
                if (type2.getSort() == (0x8B85CD19 ^ 0x8B85CD13)) break block3;
            }
            return OBJECT;
        }
        return ClassInfo.getCommonSuperClassOrInterface(ClassInfo.forType(type), ClassInfo.forType(type2));
    }

    public static ClassInfo getCommonSuperClassOrInterface(ClassInfo classInfo, ClassInfo classInfo2) {
        return ClassInfo.getCommonSuperClass(classInfo, classInfo2, (0xF0865ACB ^ 0xF0865ACA) != 0);
    }

    private static ClassInfo getCommonSuperClass(ClassInfo classInfo, ClassInfo classInfo2, boolean bl) {
        if (classInfo.hasSuperClass(classInfo2, Traversal.NONE, bl)) {
            return classInfo2;
        }
        if (classInfo2.hasSuperClass(classInfo, Traversal.NONE, bl)) {
            return classInfo;
        }
        if (classInfo.isInterface() || classInfo2.isInterface()) {
            return OBJECT;
        }
        do {
            if ((classInfo = classInfo.getSuperClass()) != null) continue;
            return OBJECT;
        } while (!classInfo2.hasSuperClass(classInfo, Traversal.NONE, bl));
        return classInfo;
    }

    static {
        cache.put(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438]\ua7e4\ua4bf\ua074\ua906\u7d62"), OBJECT);
    }

    class Field
    extends Member {
        public Field(Member member) {
            super(member);
        }

        public Field(FieldNode fieldNode) {
            this(fieldNode, (0x4B28F89E ^ 0x4B28F89E) != 0);
        }

        public Field(FieldNode fieldNode, boolean bl) {
            super(Member.Type.FIELD, fieldNode.name, fieldNode.desc, fieldNode.access, bl);
            this.setUnique((Annotations.getVisible(fieldNode, Unique.class) != null ? 0x59149A7D ^ 0x59149A7C : 0x6B504BDF ^ 0x6B504BDF) != 0);
            if (Annotations.getVisible(fieldNode, Shadow.class) != null) {
                int n;
                int n2 = Annotations.getVisible(fieldNode, Final.class) != null ? 0x114035E8 ^ 0x114035E9 : (n = 0x9D4BAB28 ^ 0x9D4BAB28);
                int n3 = Annotations.getVisible(fieldNode, Mutable.class) != null ? 0x2AFB3F01 ^ 0x2AFB3F00 : 0x360B9146 ^ 0x360B9146;
                this.setDecoratedFinal(n != 0, n3 != 0);
            }
        }

        public Field(String string, String string2, int n) {
            super(Member.Type.FIELD, string, string2, n, (0xDBF6C31 ^ 0xDBF6C31) != 0);
        }

        public Field(String string, String string2, int n, boolean bl) {
            super(Member.Type.FIELD, string, string2, n, bl);
        }

        @Override
        public ClassInfo getOwner() {
            return ClassInfo.this;
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof Field)) {
                return (0x4A8D510 ^ 0x4A8D510) != 0;
            }
            return super.equals(object);
        }

        @Override
        protected String getDisplayFormat() {
            return \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("7\ua7f5\ua4ef\ua034\ua916");
        }
    }

    public class InterfaceMethod
    extends Method {
        private final ClassInfo owner;

        public InterfaceMethod(Member member) {
            super(member);
            this.owner = member.getOwner();
        }

        @Override
        public ClassInfo getOwner() {
            return this.owner;
        }

        @Override
        public ClassInfo getImplementor() {
            return ClassInfo.this;
        }
    }

    public class Method
    extends Member {
        private final List<FrameData> frames;
        private boolean isAccessor;

        public Method(Member member) {
            super(member);
            this.frames = member instanceof Method ? ((Method)member).frames : null;
        }

        public Method(MethodNode methodNode) {
            this(methodNode, (0xFDDECFD1 ^ 0xFDDECFD1) != 0);
            this.setUnique((Annotations.getVisible(methodNode, Unique.class) != null ? 0x9ECD735E ^ 0x9ECD735F : 0x2E3B2931 ^ 0x2E3B2931) != 0);
            Class[] classArray = new Class[0xB6260C9 ^ 0xB6260CB];
            classArray[0xBF2BC61B ^ 0xBF2BC61B] = Accessor.class;
            classArray[0x8E99AF0D ^ 0x8E99AF0C] = Invoker.class;
            this.isAccessor = Annotations.getSingleVisible(methodNode, classArray) != null ? 0x61319BB0 ^ 0x61319BB1 : 0x9ECB6A82 ^ 0x9ECB6A82;
        }

        public Method(MethodNode methodNode, boolean bl) {
            super(Member.Type.METHOD, methodNode.name, methodNode.desc, methodNode.access, bl);
            this.frames = this.gatherFrames(methodNode);
            this.setUnique((Annotations.getVisible(methodNode, Unique.class) != null ? 0x69178959 ^ 0x69178958 : 0x55C14BE0 ^ 0x55C14BE0) != 0);
            Class[] classArray = new Class[0x62F7AA9 ^ 0x62F7AAB];
            classArray[0xC85E4A95 ^ 0xC85E4A95] = Accessor.class;
            classArray[0x6F5DD9C4 ^ 0x6F5DD9C5] = Invoker.class;
            this.isAccessor = Annotations.getSingleVisible(methodNode, classArray) != null ? 0xC0AE507A ^ 0xC0AE507B : 0x9747AF0B ^ 0x9747AF0B;
        }

        public Method(String string, String string2) {
            super(Member.Type.METHOD, string, string2, 0x160AFC6F ^ 0x160AFC6E, (0xE317E76F ^ 0xE317E76F) != 0);
            this.frames = null;
        }

        public Method(String string, String string2, int n) {
            super(Member.Type.METHOD, string, string2, n, (0xA8DFD4FD ^ 0xA8DFD4FD) != 0);
            this.frames = null;
        }

        public Method(String string, String string2, int n, boolean bl) {
            super(Member.Type.METHOD, string, string2, n, bl);
            this.frames = null;
        }

        private List<FrameData> gatherFrames(MethodNode methodNode) {
            ArrayList<FrameData> arrayList = new ArrayList<FrameData>();
            ListIterator<AbstractInsnNode> listIterator = methodNode.instructions.iterator();
            while (listIterator.hasNext()) {
                AbstractInsnNode abstractInsnNode = (AbstractInsnNode)listIterator.next();
                if (!(abstractInsnNode instanceof FrameNode)) continue;
                arrayList.add(new FrameData(methodNode.instructions.indexOf(abstractInsnNode), (FrameNode)abstractInsnNode));
            }
            return arrayList;
        }

        public List<FrameData> getFrames() {
            return this.frames;
        }

        @Override
        public ClassInfo getOwner() {
            return ClassInfo.this;
        }

        public boolean isAccessor() {
            return this.isAccessor;
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof Method)) {
                return (0xB5B990DE ^ 0xB5B990DE) != 0;
            }
            return super.equals(object);
        }
    }

    static abstract class Member {
        private final Type type;
        private final String memberName;
        private final String memberDesc;
        private final boolean isInjected;
        private final int modifiers;
        private String currentName;
        private String currentDesc;
        private boolean decoratedFinal;
        private boolean decoratedMutable;
        private boolean unique;

        protected Member(Member member) {
            this(member.type, member.memberName, member.memberDesc, member.modifiers, member.isInjected);
            this.currentName = member.currentName;
            this.currentDesc = member.currentDesc;
            this.unique = member.unique;
        }

        protected Member(Type type, String string, String string2, int n) {
            this(type, string, string2, n, (0x991F4468 ^ 0x991F4468) != 0);
        }

        protected Member(Type type, String string, String string2, int n, boolean bl) {
            this.type = type;
            this.memberName = string;
            this.memberDesc = string2;
            this.isInjected = bl;
            this.currentName = string;
            this.currentDesc = string2;
            this.modifiers = n;
        }

        public String getOriginalName() {
            return this.memberName;
        }

        public String getName() {
            return this.currentName;
        }

        public String getOriginalDesc() {
            return this.memberDesc;
        }

        public String getDesc() {
            return this.currentDesc;
        }

        public boolean isInjected() {
            return this.isInjected;
        }

        public boolean isRenamed() {
            return (!this.currentName.equals(this.memberName) ? 0xD5B2C34 ^ 0xD5B2C35 : 0x848F4DE4 ^ 0x848F4DE4) != 0;
        }

        public boolean isRemapped() {
            return (!this.currentDesc.equals(this.memberDesc) ? 0xF3840101 ^ 0xF3840100 : 0x4735F75A ^ 0x4735F75A) != 0;
        }

        public boolean isPrivate() {
            return ((this.modifiers & (0xBE3EA556 ^ 0xBE3EA554)) != 0 ? 0x73A80939 ^ 0x73A80938 : 0x4BF7D0FE ^ 0x4BF7D0FE) != 0;
        }

        public boolean isStatic() {
            return ((this.modifiers & (0xE5884A26 ^ 0xE5884A2E)) != 0 ? 0xC1F19D96 ^ 0xC1F19D97 : 0xB5810A15 ^ 0xB5810A15) != 0;
        }

        public boolean isAbstract() {
            return ((this.modifiers & (0xD983ACA3 ^ 0xD983A8A3)) != 0 ? 0x7451DA15 ^ 0x7451DA14 : 0xD99AAD30 ^ 0xD99AAD30) != 0;
        }

        public boolean isFinal() {
            return ((this.modifiers & (0x20266A0D ^ 0x20266A1D)) != 0 ? 0x1FB99FC1 ^ 0x1FB99FC0 : 0x11CE1118 ^ 0x11CE1118) != 0;
        }

        public boolean isSynthetic() {
            return ((this.modifiers & (0x1754CF82 ^ 0x1754DF82)) != 0 ? 0x4E4E306B ^ 0x4E4E306A : 0x4E85A36D ^ 0x4E85A36D) != 0;
        }

        public boolean isUnique() {
            return this.unique;
        }

        public void setUnique(boolean bl) {
            this.unique = bl;
        }

        public boolean isDecoratedFinal() {
            return this.decoratedFinal;
        }

        public boolean isDecoratedMutable() {
            return this.decoratedMutable;
        }

        public void setDecoratedFinal(boolean bl, boolean bl2) {
            this.decoratedFinal = bl;
            this.decoratedMutable = bl2;
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean matchesFlags(int n) {
            int n2;
            if (((this.modifiers ^ (0x5CAD7084 ^ 0xA3528F7B) | n & (0xEB7AF6E2 ^ 0xEB7AF6E0)) & (0x4D34D87F ^ 0x4D34D87D)) != 0) {
                if (((this.modifiers ^ (0x1554FE85 ^ 0xEAAB017A) | n & (0xC9019E6A ^ 0xC9019E62)) & (0x7F435F80 ^ 0x7F435F88)) != 0) {
                    n2 = 0x71C66D43 ^ 0x71C66D42;
                    return n2 != 0;
                }
            }
            n2 = 0x6A9A360A ^ 0x6A9A360A;
            return n2 != 0;
        }

        public abstract ClassInfo getOwner();

        public ClassInfo getImplementor() {
            return this.getOwner();
        }

        public int getAccess() {
            return this.modifiers;
        }

        public String renameTo(String string) {
            this.currentName = string;
            return string;
        }

        public String remapTo(String string) {
            this.currentDesc = string;
            return string;
        }

        public boolean equals(String string, String string2) {
            return ((this.memberName.equals(string) || this.currentName.equals(string)) && (this.memberDesc.equals(string2) || this.currentDesc.equals(string2)) ? 0xC72CC92E ^ 0xC72CC92F : 0x6739CC79 ^ 0x6739CC79) != 0;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Member)) {
                return (0x283AEEF6 ^ 0x283AEEF6) != 0;
            }
            Member member = (Member)object;
            return ((member.memberName.equals(this.memberName) || member.currentName.equals(this.currentName)) && (member.memberDesc.equals(this.memberDesc) || member.currentDesc.equals(this.currentDesc)) ? 0x60D62971 ^ 0x60D62970 : 0x91531ADF ^ 0x91531ADF) != 0;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public String toString() {
            Object[] objectArray = new Object[0x4E2144E0 ^ 0x4E2144E2];
            objectArray[0xA0225C11 ^ 0xA0225C11] = this.memberName;
            objectArray[0x538E5E23 ^ 0x538E5E22] = this.memberDesc;
            return String.format(this.getDisplayFormat(), objectArray);
        }

        protected String getDisplayFormat() {
            return \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("7\ua7f5\ua4f0\ua062");
        }

        static final class Type
        extends Enum<Type> {
            public static final /* enum */ Type METHOD = new Type();
            public static final /* enum */ Type FIELD = new Type();
            private static final /* synthetic */ Type[] $VALUES;

            public static Type[] values() {
                return (Type[])$VALUES.clone();
            }

            public static Type valueOf(String string) {
                return Enum.valueOf(Type.class, string);
            }

            static {
                Type[] typeArray = new Type[0x89D644C4 ^ 0x89D644C6];
                typeArray[0x8924F72B ^ 0x8924F72B] = METHOD;
                typeArray[0x6E3825EE ^ 0x6E3825EF] = FIELD;
                $VALUES = typeArray;
            }
        }
    }

    public static class FrameData {
        private static final String[] FRAMETYPES;
        public final int index;
        public final int type;
        public final int locals;

        FrameData(int n, int n2, int n3) {
            this.index = n;
            this.type = n2;
            this.locals = n3;
        }

        FrameData(int n, FrameNode frameNode) {
            this.index = n;
            this.type = frameNode.type;
            this.locals = frameNode.local != null ? frameNode.local.size() : 0x908740F2 ^ 0x908740F2;
        }

        public String toString() {
            Object[] objectArray = new Object[0x78BEED4F ^ 0x78BEED4C];
            objectArray[0x25570849 ^ 0x25570849] = this.index;
            objectArray[0x61A60637 ^ 0x61A60636] = FRAMETYPES[this.type + (0x41DE48C8 ^ 0x41DE48C9)];
            objectArray[0xE79E6A65 ^ 0xE79E6A67] = this.locals;
            return String.format(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("T\ua7f4\ua4b4\ua07c\ua900\u7d52\u8e4b\u246e\u8b36\u344c{\ua7e8\ua4b1\ua074\ua91d\u7d2b\u8e0f\u247e\u8b7b\u3437f\ua7ff\ua4a5\ua074\ua958\u7d33\u8e59\u2436\u8b77\u347b}\ua7e5\ua4b4\ua07d\ua916\u7d2b\u8e0f\u247e\u8b0a"), objectArray);
        }

        static {
            String[] stringArray = new String[0x5EA62867 ^ 0x5EA62861];
            stringArray[0x78874F58 ^ 0x78874F58] = \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("\\\ua7c3\ua482");
            stringArray[0x26A7ADEC ^ 0x26A7ADED] = \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("T\ua7d3\ua499\ua05d");
            stringArray[0xBCCA7D59 ^ 0xBCCA7D5B] = \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("S\ua7d6\ua485\ua054\ua92b\u7d52");
            stringArray[0x490A6373 ^ 0x490A6370] = \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("Q\ua7ce\ua49a\ua041");
            stringArray[0x36055B1C ^ 0x36055B18] = \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("A\ua7c7\ua498\ua054");
            stringArray[0x5B334C3D ^ 0x5B334C38] = \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("A\ua7c7\ua498\ua054\ua954");
            FRAMETYPES = stringArray;
        }
    }

    public static final class Traversal
    extends Enum<Traversal> {
        public static final /* enum */ Traversal NONE = new Traversal(null, (0x3DF3FE0D ^ 0x3DF3FE0D) != 0, SearchType.SUPER_CLASSES_ONLY);
        public static final /* enum */ Traversal ALL = new Traversal(null, (0x147CC090 ^ 0x147CC091) != 0, SearchType.ALL_CLASSES);
        public static final /* enum */ Traversal IMMEDIATE = new Traversal(NONE, (0xC5EC24B6 ^ 0xC5EC24B7) != 0, SearchType.SUPER_CLASSES_ONLY);
        public static final /* enum */ Traversal SUPER = new Traversal(ALL, (0x5D7A9123 ^ 0x5D7A9123) != 0, SearchType.SUPER_CLASSES_ONLY);
        private final Traversal next;
        private final boolean traverse;
        private final SearchType searchType;
        private static final /* synthetic */ Traversal[] $VALUES;

        public static Traversal[] values() {
            return (Traversal[])$VALUES.clone();
        }

        public static Traversal valueOf(String string) {
            return Enum.valueOf(Traversal.class, string);
        }

        private Traversal(Traversal traversal, boolean bl, SearchType searchType) {
            this.next = traversal != null ? traversal : this;
            this.traverse = bl;
            this.searchType = searchType;
        }

        public Traversal next() {
            return this.next;
        }

        public boolean canTraverse() {
            return this.traverse;
        }

        public SearchType getSearchType() {
            return this.searchType;
        }

        static {
            Traversal[] traversalArray = new Traversal[0x467D131F ^ 0x467D131B];
            traversalArray[0x423AF610 ^ 0x423AF610] = NONE;
            traversalArray[0x2AED156D ^ 0x2AED156C] = ALL;
            traversalArray[0x75D9D67 ^ 0x75D9D65] = IMMEDIATE;
            traversalArray[0xA42E8C0B ^ 0xA42E8C08] = SUPER;
            $VALUES = traversalArray;
        }
    }

    public static final class SearchType
    extends Enum<SearchType> {
        public static final /* enum */ SearchType ALL_CLASSES = new SearchType();
        public static final /* enum */ SearchType SUPER_CLASSES_ONLY = new SearchType();
        private static final /* synthetic */ SearchType[] $VALUES;

        public static SearchType[] values() {
            return (SearchType[])$VALUES.clone();
        }

        public static SearchType valueOf(String string) {
            return Enum.valueOf(SearchType.class, string);
        }

        static {
            SearchType[] searchTypeArray = new SearchType[0x59DBEAF9 ^ 0x59DBEAFB];
            searchTypeArray[0x4A49505A ^ 0x4A49505A] = ALL_CLASSES;
            searchTypeArray[0x6CA84736 ^ 0x6CA84737] = SUPER_CLASSES_ONLY;
            $VALUES = searchTypeArray;
        }
    }
}

