/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer;

import java.util.HashSet;
import java.util.Set;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import org.spongepowered.asm.mixin.transformer.MixinInfo;
import org.spongepowered.asm.mixin.transformer.meta.MixinRenamed;
import org.spongepowered.asm.mixin.transformer.throwables.InvalidMixinException;
import org.spongepowered.asm.util.Annotations;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2;

public final class InterfaceInfo {
    private final MixinInfo mixin;
    private final String prefix;
    private final Type iface;
    private final boolean unique;
    private Set<String> methods;

    private InterfaceInfo(MixinInfo mixinInfo, String string, Type type, boolean bl) {
        block3: {
            block2: {
                if (string == null) break block2;
                if (string.length() >= (0xEED774DD ^ 0xEED774DF) && string.endsWith(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("6"))) break block3;
            }
            Object[] objectArray = new Object[0x27D4573C ^ 0x27D4573E];
            objectArray[0x5311A6E6 ^ 0x5311A6E6] = string;
            objectArray[0x99C89C0E ^ 0x99C89C0F] = type.toString();
            throw new InvalidMixinException((IMixinInfo)mixinInfo, String.format(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("B\ua7f4\ua4b0\ua077\ua90c\u7d6e\u8e0a\u243f\u8b24\u3437t\ua7e9\ua4a7\ua031\ua90c\u7d70\u8e4b\u2479\u8b32\u34377\ua7f5\ua4f5\ua078\ua916\u7d36\u8e44\u2475\u8b23\u3437d\ua7e7\ua4b9\ua078\ua901"), objectArray));
        }
        this.mixin = mixinInfo;
        this.prefix = string;
        this.iface = type;
        this.unique = bl;
    }

    private void initMethods() {
        this.methods = new HashSet<String>();
        this.readInterface(this.iface.getInternalName());
    }

    private void readInterface(String string) {
        ClassInfo classInfo = ClassInfo.forName(string);
        for (ClassInfo.Method object : classInfo.getMethods()) {
            this.methods.add(object.toString());
        }
        for (String string2 : classInfo.getInterfaces()) {
            this.readInterface(string2);
        }
    }

    public String getPrefix() {
        return this.prefix;
    }

    public Type getIface() {
        return this.iface;
    }

    public String getName() {
        return this.iface.getClassName();
    }

    public String getInternalName() {
        return this.iface.getInternalName();
    }

    public boolean isUnique() {
        return this.unique;
    }

    public boolean renameMethod(MethodNode methodNode) {
        if (this.methods == null) {
            this.initMethods();
        }
        if (!methodNode.name.startsWith(this.prefix)) {
            if (this.methods.contains(methodNode.name + methodNode.desc)) {
                this.decorateUniqueMethod(methodNode);
            }
            return (0x9C64C3D6 ^ 0x9C64C3D6) != 0;
        }
        String string = methodNode.name.substring(this.prefix.length());
        String string2 = string + methodNode.desc;
        if (!this.methods.contains(string2)) {
            Object[] objectArray = new Object[0x763D003B ^ 0x763D0039];
            objectArray[0x1FA5BACC ^ 0x1FA5BACC] = string;
            objectArray[0x80958DC1 ^ 0x80958DC0] = this.getName();
            throw new InvalidMixinException((IMixinInfo)this.mixin, String.format(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("7\ua7f5\ua4f5\ua075\ua90a\u7d73\u8e59\u243a\u8b39\u3478f\ua7a6\ua4b0\ua069\ua90c\u7d65\u8e5e\u243a\u8b3e\u34792\ua7f2\ua4b4\ua063\ua902\u7d73\u8e5e\u243a\u8b3e\u3479f\ua7e3\ua4a7\ua077\ua904\u7d75\u8e4f\u243a\u8b72\u3464"), objectArray));
        }
        if ((methodNode.access & (0x43D093E4 ^ 0x43D093E5)) == 0) {
            Object[] objectArray = new Object[0xA66BF346 ^ 0xA66BF344];
            objectArray[0x195D159C ^ 0x195D159C] = string;
            objectArray[0x31067A4C ^ 0x31067A4D] = this.getName();
            throw new InvalidMixinException((IMixinInfo)this.mixin, String.format(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("7\ua7f5\ua4f5\ua072\ua904\u7d78\u8e44\u2475\u8b23\u3437{\ua7eb\ua4a5\ua07d\ua900\u7d7b\u8e4f\u2474\u8b23\u34377\ua7f5\ua4f5\ua073\ua900\u7d75\u8e4b\u246f\u8b24\u34722\ua7ef\ua4a1\ua031\ua90c\u7d65\u8e0a\u2474\u8b38\u34632\ua7f0\ua4bc\ua062\ua90c\u7d74\u8e46\u247f"), objectArray));
        }
        Object[] objectArray = new Object[0x97CD7ACE ^ 0x97CD7ACA];
        objectArray[0x2532D7D2 ^ 0x2532D7D2] = \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("}\ua7f4\ua4bc\ua076\ua90c\u7d78\u8e4b\u2476\u8b19\u3476\u007f\ua7e3");
        objectArray[0x16D8DBFD ^ 0x16D8DBFC] = methodNode.name;
        objectArray[0xA8CBB61F ^ 0xA8CBB61D] = \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("{\ua7f5\ua49c\ua07f\ua911\u7d73\u8e58\u247c\u8b36\u3474w\ua7cb\ua4b0\ua07c\ua907\u7d73\u8e58");
        objectArray[0x22C253E0 ^ 0x22C253E3] = (0xA137D86B ^ 0xA137D86A) != 0;
        Annotations.setVisible(methodNode, MixinRenamed.class, objectArray);
        this.decorateUniqueMethod(methodNode);
        methodNode.name = string;
        return (0x53422483 ^ 0x53422482) != 0;
    }

    private void decorateUniqueMethod(MethodNode methodNode) {
        if (!this.unique) {
            return;
        }
        if (Annotations.getVisible(methodNode, Unique.class) == null) {
            Annotations.setVisible(methodNode, Unique.class, new Object[0xCAB356CA ^ 0xCAB356CA]);
            this.mixin.getClassInfo().findMethod(methodNode).setUnique((0x7E72DDF5 ^ 0x7E72DDF4) != 0);
        }
    }

    static InterfaceInfo fromAnnotation(MixinInfo mixinInfo, AnnotationNode annotationNode) {
        String string = (String)Annotations.getValue(annotationNode, \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("b\ua7f4\ua4b0\ua077\ua90c\u7d6e"));
        Type type = (Type)Annotations.getValue(annotationNode, \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("{\ua7e0\ua4b4\ua072\ua900"));
        Boolean bl = (Boolean)Annotations.getValue(annotationNode, \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("g\ua7e8\ua4bc\ua060\ua910\u7d73"));
        if (string == null || type == null) {
            Object[] objectArray = new Object[0x26E2B50B ^ 0x26E2B50A];
            objectArray[0xBFC52C53 ^ 0xBFC52C53] = mixinInfo;
            throw new InvalidMixinException((IMixinInfo)mixinInfo, String.format(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("R\ua7cf\ua4bb\ua065\ua900\u7d64\u8e4c\u247b\u8b34\u34722\ua7e7\ua4bb\ua07f\ua90a\u7d62\u8e4b\u246e\u8b3e\u3478|\ua7a6\ua4ba\ua07f\ua945\u7d33\u8e59\u243a\u8b3e\u34642\ua7eb\ua4bc\ua062\ua916\u7d7f\u8e44\u247d\u8b77\u34762\ua7f4\ua4b0\ua060\ua910\u7d7f\u8e58\u247f\u8b33\u3437b\ua7e7\ua4a7\ua070\ua908\u7d73\u8e5e\u247f\u8b25"), objectArray));
        }
        return new InterfaceInfo(mixinInfo, string, type, (bl != null && bl.booleanValue() ? 0xA942D408 ^ 0xA942D409 : 0x93413BC8 ^ 0x93413BC8) != 0);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return (0xE72A381B ^ 0xE72A381A) != 0;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return (0xFA26B31E ^ 0xFA26B31E) != 0;
        }
        InterfaceInfo interfaceInfo = (InterfaceInfo)object;
        return (this.mixin.equals(interfaceInfo.mixin) && this.prefix.equals(interfaceInfo.prefix) && this.iface.equals(interfaceInfo.iface) ? 0x84C18B8B ^ 0x84C18B8A : 0x567E98A2 ^ 0x567E98A2) != 0;
    }

    public int hashCode() {
        int n = this.mixin.hashCode();
        n = (0x85736E67 ^ 0x85736E78) * n + this.prefix.hashCode();
        n = (0x718728E9 ^ 0x718728F6) * n + this.iface.hashCode();
        return n;
    }
}

