/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import org.spongepowered.asm.mixin.transformer.MixinInfo;
import org.spongepowered.asm.util.Counter;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2;

public class MethodMapper {
    private static final Logger logger = LogManager.getLogger((String)\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("\u007f\ua7ef\ua4ad\ua078\ua90b"));
    private static final List<String> classes = new ArrayList<String>();
    private static final Map<String, Counter> methods = new HashMap<String, Counter>();
    private final ClassInfo info;

    public MethodMapper(MixinEnvironment mixinEnvironment, ClassInfo classInfo) {
        this.info = classInfo;
    }

    public ClassInfo getClassInfo() {
        return this.info;
    }

    public void remapHandlerMethod(MixinInfo mixinInfo, MethodNode methodNode, ClassInfo.Method method) {
        if (!(methodNode instanceof MixinInfo.MixinMethodNode) || !((MixinInfo.MixinMethodNode)methodNode).isInjector()) {
            return;
        }
        if (method.isUnique()) {
            Object[] objectArray = new Object[0x8D52DA88 ^ 0x8D52DA8A];
            objectArray[0x4623C566 ^ 0x4623C566] = method;
            objectArray[0x64ED25AE ^ 0x64ED25AF] = mixinInfo;
            logger.warn(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("@\ua7e3\ua4b1\ua064\ua90b\u7d72\u8e4b\u2474\u8b23\u3437R\ua7d3\ua4bb\ua078\ua914\u7d63\u8e4f\u243a\u8b38\u34792\ua7ef\ua4bb\ua07b\ua900\u7d75\u8e5e\u2475\u8b25\u3437\u007f\ua7e3\ua4a1\ua079\ua90a\u7d72\u8e0a\u2461\u8b2a\u3437{\ua7e8\ua4f5\ua06a\ua918\u7d38\u8e0a\u2453\u8b39\u347dw\ua7e5\ua4a1\ua07e\ua917\u7d65\u8e0a\u247b\u8b25\u34722\ua7ef\ua4b8\ua061\ua909\u7d7f\u8e49\u2473\u8b23\u347bk\ua7a6\ua4a0\ua07f\ua90c\u7d67\u8e5f\u247f"), objectArray);
        }
        if (method.isRenamed()) {
            methodNode.name = method.getName();
            return;
        }
        String string = this.getHandlerName((MixinInfo.MixinMethodNode)methodNode);
        methodNode.name = method.renameTo(string);
    }

    public String getHandlerName(MixinInfo.MixinMethodNode mixinMethodNode) {
        String string = InjectionInfo.getInjectorPrefix(mixinMethodNode.getInjectorAnnotation());
        String string2 = MethodMapper.getClassUID(mixinMethodNode.getOwner().getClassRef());
        String string3 = MethodMapper.getMethodUID(mixinMethodNode.name, mixinMethodNode.desc, (!mixinMethodNode.isSurrogate() ? 0x51333993 ^ 0x51333992 : 0x97BAAAF9 ^ 0x97BAAAF9) != 0);
        Object[] objectArray = new Object[0x2B211C67 ^ 0x2B211C63];
        objectArray[0x9D2D8179 ^ 0x9D2D8179] = string;
        objectArray[0x74A34F68 ^ 0x74A34F69] = mixinMethodNode.name;
        objectArray[0xA82C4740 ^ 0xA82C4742] = string2;
        objectArray[0xF9E7E3DF ^ 0xF9E7E3DC] = string3;
        return String.format(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("7\ua7f5\ua4f1\ua034\ua916\u7d32\u8e0f\u2469\u8b72\u3464"), objectArray);
    }

    private static String getClassUID(String string) {
        int n = classes.indexOf(string);
        if (n < 0) {
            n = classes.size();
            classes.add(string);
        }
        return MethodMapper.finagle(n);
    }

    private static String getMethodUID(String string, String string2, boolean bl) {
        Object[] objectArray = new Object[0x7514200B ^ 0x75142009];
        objectArray[0xB33314D8 ^ 0xB33314D8] = string;
        objectArray[0xA185906A ^ 0xA185906B] = string2;
        String string3 = String.format(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("7\ua7f5\ua4f0\ua062"), objectArray);
        Counter counter = methods.get(string3);
        if (counter == null) {
            counter = new Counter();
            methods.put(string3, counter);
        } else if (bl) {
            counter.value += 0x9D9EC644 ^ 0x9D9EC645;
        }
        Object[] objectArray2 = new Object[0x3692CA94 ^ 0x3692CA95];
        objectArray2[0x6BE42D9A ^ 0x6BE42D9A] = counter.value;
        return String.format(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("7\ua7b6\ua4e6\ua069"), objectArray2);
    }

    private static String finagle(int n) {
        String string = Integer.toHexString(n);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0x2D3AC1D6 ^ 0x2D3AC1D6; i < string.length(); ++i) {
            char c = string.charAt(i);
            c = (char)(c + (c < (0x23A02486 ^ 0x23A024BC) ? 0x64CE83CF ^ 0x64CE83FE : 0x8FE1C706 ^ 0x8FE1C70C));
            stringBuilder.append(c);
        }
        return Strings.padStart((String)stringBuilder.toString(), (int)(0x62DA266F ^ 0x62DA266C), (char)(0xF9181186 ^ 0xF91811FC));
    }
}

