/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer;

import com.google.common.collect.ImmutableList;
import java.lang.annotation.Annotation;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.SortedSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.lib.Label;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.signature.SignatureReader;
import org.spongepowered.asm.lib.signature.SignatureVisitor;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.lib.tree.FieldInsnNode;
import org.spongepowered.asm.lib.tree.FieldNode;
import org.spongepowered.asm.lib.tree.JumpInsnNode;
import org.spongepowered.asm.lib.tree.LabelNode;
import org.spongepowered.asm.lib.tree.LineNumberNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.refmap.IMixinContext;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import org.spongepowered.asm.mixin.transformer.MixinInfo;
import org.spongepowered.asm.mixin.transformer.MixinTargetContext;
import org.spongepowered.asm.mixin.transformer.TargetClassContext;
import org.spongepowered.asm.mixin.transformer.ext.extensions.ExtensionClassExporter;
import org.spongepowered.asm.mixin.transformer.meta.MixinMerged;
import org.spongepowered.asm.mixin.transformer.meta.MixinRenamed;
import org.spongepowered.asm.mixin.transformer.throwables.InvalidMixinException;
import org.spongepowered.asm.util.Annotations;
import org.spongepowered.asm.util.Bytecode;
import org.spongepowered.asm.util.ConstraintParser;
import org.spongepowered.asm.util.perf.Profiler;
import org.spongepowered.asm.util.throwables.ConstraintViolationException;
import org.spongepowered.asm.util.throwables.InvalidConstraintException;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2;

class MixinApplicatorStandard {
    protected static final List<Class<? extends Annotation>> CONSTRAINED_ANNOTATIONS = ImmutableList.of(Overwrite.class, Inject.class, ModifyArg.class, ModifyArgs.class, Redirect.class, ModifyVariable.class, ModifyConstant.class);
    protected static final int[] INITIALISER_OPCODE_BLACKLIST;
    protected final Logger logger = LogManager.getLogger((String)\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("\u007f\ua7ef\ua4ad\ua078\ua90b"));
    protected final TargetClassContext context;
    protected final String targetName;
    protected final ClassNode targetClass;
    protected final Profiler profiler = MixinEnvironment.getProfiler();
    protected final boolean mergeSignatures;

    MixinApplicatorStandard(TargetClassContext targetClassContext) {
        this.context = targetClassContext;
        this.targetName = targetClassContext.getClassName();
        this.targetClass = targetClassContext.getClassNode();
        ExtensionClassExporter extensionClassExporter = (ExtensionClassExporter)targetClassContext.getExtensions().getExtension(ExtensionClassExporter.class);
        this.mergeSignatures = extensionClassExporter.isDecompilerActive() && MixinEnvironment.getCurrentEnvironment().getOption(MixinEnvironment.Option.DEBUG_EXPORT_DECOMPILE_MERGESIGNATURES) ? 0xFC20DA99 ^ 0xFC20DA98 : 0x5B87A0D9 ^ 0x5B87A0D9;
    }

    void apply(SortedSet<MixinInfo> sortedSet) {
        ArrayList<MixinTargetContext> arrayList = new ArrayList<MixinTargetContext>();
        for (MixinInfo object2 : sortedSet) {
            Object[] objectArray = new Object[0x2D94264E ^ 0x2D94264D];
            objectArray[0x5E33EBF3 ^ 0x5E33EBF3] = object2.getName();
            objectArray[0x6B22936D ^ 0x6B22936C] = object2.getParent();
            objectArray[0xE3BB7BD7 ^ 0xE3BB7BD5] = this.targetName;
            this.logger.log(object2.getLoggingLevel(), \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("_\ua7ef\ua4ad\ua078\ua90b\u7d71\u8e0a\u2461\u8b2a\u3437t\ua7f4\ua4ba\ua07c\ua945\u7d6d\u8e57\u243a\u8b3e\u3479f\ua7e9\ua4f5\ua06a\ua918"), objectArray);
            arrayList.add(object2.createContextFor(this.context));
        }
        Object object = null;
        try {
            for (MixinTargetContext mixinTargetContext : arrayList) {
                object = mixinTargetContext;
                ((MixinTargetContext)object).preApply(this.targetName, this.targetClass);
            }
            ApplicatorPass[] exception = ApplicatorPass.values();
            int n = exception.length;
            for (int i = 0xE25E346A ^ 0xE25E346A; i < n; ++i) {
                ApplicatorPass applicatorPass = exception[i];
                String[] stringArray = new String[0xFD6CFAF4 ^ 0xFD6CFAF6];
                stringArray[0x3F23DCDD ^ 0x3F23DCDD] = \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("b\ua7e7\ua4a6\ua062");
                stringArray[0x87CC08DE ^ 0x87CC08DF] = applicatorPass.name().toLowerCase();
                Profiler.Section section = this.profiler.begin(stringArray);
                for (MixinTargetContext mixinTargetContext : arrayList) {
                    object = mixinTargetContext;
                    this.applyMixin((MixinTargetContext)object, applicatorPass);
                }
                section.end();
            }
            for (MixinTargetContext mixinTargetContext : arrayList) {
                object = mixinTargetContext;
                ((MixinTargetContext)object).postApply(this.targetName, this.targetClass);
            }
        }
        catch (InvalidMixinException invalidMixinException) {
            throw invalidMixinException;
        }
        catch (Exception exception) {
            throw new InvalidMixinException((IMixinContext)object, \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("G\ua7e8\ua4b0\ua069\ua915\u7d73\u8e49\u246e\u8b32\u3473w\ua7e2\ua4f5") + exception.getClass().getSimpleName() + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2\ua7f1\ua4bd\ua078\ua909\u7d65\u8e5e\u243a\u8b36\u3467b\ua7ea\ua4ac\ua078\ua90b\u7d71\u8e0a\u246e\u8b3f\u34722\ua7eb\ua4bc\ua069\ua90c\u7d78\u8e0a\u2479\u8b3b\u3476a\ua7f5\ua4ef\ua031") + exception.getMessage(), (Throwable)exception);
        }
        this.applySourceMap(this.context);
        this.context.processDebugTasks();
    }

    protected final void applyMixin(MixinTargetContext mixinTargetContext, ApplicatorPass applicatorPass) {
        switch (1.$SwitchMap$org$spongepowered$asm$mixin$transformer$MixinApplicatorStandard$ApplicatorPass[applicatorPass.ordinal()]) {
            case 1: {
                this.applySignature(mixinTargetContext);
                this.applyInterfaces(mixinTargetContext);
                this.applyAttributes(mixinTargetContext);
                this.applyAnnotations(mixinTargetContext);
                this.applyFields(mixinTargetContext);
                this.applyMethods(mixinTargetContext);
                this.applyInitialisers(mixinTargetContext);
                break;
            }
            case 2: {
                this.prepareInjections(mixinTargetContext);
                break;
            }
            case 3: {
                this.applyAccessors(mixinTargetContext);
                this.applyInjections(mixinTargetContext);
                break;
            }
            default: {
                throw new IllegalStateException(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b27\u3476a\ua7f5\ua4f5\ua062\ua915\u7d73\u8e49\u2473\u8b31\u347ew\ua7e2\ua4f5") + (Object)((Object)applicatorPass));
            }
        }
    }

    protected void applySignature(MixinTargetContext mixinTargetContext) {
        if (this.mergeSignatures) {
            this.context.mergeSignature(mixinTargetContext.getSignature());
        }
    }

    protected void applyInterfaces(MixinTargetContext mixinTargetContext) {
        for (String string : mixinTargetContext.getInterfaces()) {
            if (this.targetClass.interfaces.contains(string)) continue;
            this.targetClass.interfaces.add(string);
            mixinTargetContext.getTargetClassInfo().addInterface(string);
        }
    }

    protected void applyAttributes(MixinTargetContext mixinTargetContext) {
        if (mixinTargetContext.shouldSetSourceFile()) {
            this.targetClass.sourceFile = mixinTargetContext.getSourceFile();
        }
        this.targetClass.version = Math.max(this.targetClass.version, mixinTargetContext.getMinRequiredClassVersion());
    }

    protected void applyAnnotations(MixinTargetContext mixinTargetContext) {
        ClassNode classNode = mixinTargetContext.getClassNode();
        Bytecode.mergeAnnotations(classNode, this.targetClass);
    }

    protected void applyFields(MixinTargetContext mixinTargetContext) {
        this.mergeShadowFields(mixinTargetContext);
        this.mergeNewFields(mixinTargetContext);
    }

    protected void mergeShadowFields(MixinTargetContext mixinTargetContext) {
        for (Map.Entry<FieldNode, ClassInfo.Field> entry : mixinTargetContext.getShadowFields()) {
            FieldNode fieldNode = entry.getKey();
            FieldNode fieldNode2 = this.findTargetField(fieldNode);
            if (fieldNode2 == null) continue;
            Bytecode.mergeAnnotations(fieldNode, fieldNode2);
            if (!entry.getValue().isDecoratedMutable()) continue;
            if (Bytecode.hasFlag(fieldNode2, 0xCD71008D ^ 0xCD71008F)) continue;
            fieldNode2.access &= 0x8AE21532 ^ 0x751DEADD;
        }
    }

    protected void mergeNewFields(MixinTargetContext mixinTargetContext) {
        for (FieldNode fieldNode : mixinTargetContext.getFields()) {
            FieldNode fieldNode2 = this.findTargetField(fieldNode);
            if (fieldNode2 != null) continue;
            this.targetClass.fields.add(fieldNode);
            if (fieldNode.signature == null) continue;
            if (this.mergeSignatures) {
                SignatureVisitor signatureVisitor = mixinTargetContext.getSignature().getRemapper();
                new SignatureReader(fieldNode.signature).accept(signatureVisitor);
                fieldNode.signature = signatureVisitor.toString();
                continue;
            }
            fieldNode.signature = null;
        }
    }

    protected void applyMethods(MixinTargetContext mixinTargetContext) {
        for (MethodNode methodNode : mixinTargetContext.getShadowMethods()) {
            this.applyShadowMethod(mixinTargetContext, methodNode);
        }
        for (MethodNode methodNode : mixinTargetContext.getMethods()) {
            this.applyNormalMethod(mixinTargetContext, methodNode);
        }
    }

    protected void applyShadowMethod(MixinTargetContext mixinTargetContext, MethodNode methodNode) {
        MethodNode methodNode2 = this.findTargetMethod(methodNode);
        if (methodNode2 != null) {
            Bytecode.mergeAnnotations(methodNode, methodNode2);
        }
    }

    protected void applyNormalMethod(MixinTargetContext mixinTargetContext, MethodNode methodNode) {
        mixinTargetContext.transformMethod(methodNode);
        if (!methodNode.name.startsWith(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("."))) {
            this.checkMethodVisibility(mixinTargetContext, methodNode);
            this.checkMethodConstraints(mixinTargetContext, methodNode);
            this.mergeMethod(mixinTargetContext, methodNode);
        } else if (\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20(".\ua7e5\ua4b9\ua078\ua90b\u7d7f\u8e5e\u2424").equals(methodNode.name)) {
            this.appendInsns(mixinTargetContext, methodNode);
        }
    }

    protected void mergeMethod(MixinTargetContext mixinTargetContext, MethodNode methodNode) {
        Object object;
        int n = Annotations.getVisible(methodNode, Overwrite.class) != null ? 0xA9AFC099 ^ 0xA9AFC098 : 0xED56C5B5 ^ 0xED56C5B5;
        MethodNode methodNode2 = this.findTargetMethod(methodNode);
        if (methodNode2 != null) {
            if (this.isAlreadyMerged(mixinTargetContext, methodNode, n != 0, methodNode2)) {
                return;
            }
            object = Annotations.getInvisible(methodNode, Intrinsic.class);
            if (object != null) {
                if (this.mergeIntrinsic(mixinTargetContext, methodNode, n != 0, methodNode2, (AnnotationNode)object)) {
                    mixinTargetContext.getTarget().methodMerged(methodNode);
                    return;
                }
            } else {
                if (mixinTargetContext.requireOverwriteAnnotations() && !n) {
                    Object[] objectArray = new Object[0x8D53E255 ^ 0x8D53E251];
                    objectArray[0xE92AB5FE ^ 0xE92AB5FE] = methodNode.name;
                    objectArray[0x2AC60C65 ^ 0x2AC60C64] = methodNode.desc;
                    objectArray[0x93E31AC9 ^ 0x93E31ACB] = mixinTargetContext;
                    objectArray[0x61296954 ^ 0x61296957] = mixinTargetContext.getTarget().getClassName();
                    throw new InvalidMixinException((IMixinContext)mixinTargetContext, String.format(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("7\ua7f5\ua4f0\ua062\ua945\u7d7f\u8e44\u243a\u8b72\u34642\ua7e5\ua4b4\ua07f\ua90b\u7d79\u8e5e\u243a\u8b38\u3461w\ua7f4\ua4a2\ua063\ua90c\u7d62\u8e4f\u243a\u8b3a\u3472f\ua7ee\ua4ba\ua075\ua945\u7d7f\u8e44\u243a\u8b72\u34642\ua7e4\ua4b0\ua072\ua904\u7d63\u8e59\u247f\u8b77\u3457]\ua7f0\ua4b0\ua063\ua912\u7d64\u8e43\u246e\u8b32\u3437{\ua7f5\ua4f5\ua063\ua900\u7d67\u8e5f\u2473\u8b25\u3472v\ua7a6\ua4b7\ua068\ua945\u7d62\u8e42\u247f\u8b77\u3467s\ua7f4\ua4b0\ua07f\ua911\u7d36\u8e49\u2475\u8b39\u3471{\ua7e1\ua4a0\ua063\ua904\u7d62\u8e43\u2475\u8b39"), objectArray));
                }
                this.targetClass.methods.remove(methodNode2);
            }
        } else if (n) {
            Object[] objectArray = new Object[0xD6CED008 ^ 0xD6CED00A];
            objectArray[0x7AD3A7DE ^ 0x7AD3A7DE] = methodNode.name;
            objectArray[0x49643AF8 ^ 0x49643AF9] = mixinTargetContext.getTargetClassRef();
            throw new InvalidMixinException((IMixinContext)mixinTargetContext, String.format(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("]\ua7f0\ua4b0\ua063\ua912\u7d64\u8e43\u246e\u8b32\u3437f\ua7e7\ua4a7\ua076\ua900\u7d62\u8e0a\u2438\u8b72\u34640\ua7a6\ua4a2\ua070\ua916\u7d36\u8e44\u2475\u8b23\u3437~\ua7e9\ua4b6\ua070\ua911\u7d73\u8e4e\u243a\u8b3e\u34792\ua7f2\ua4b4\ua063\ua902\u7d73\u8e5e\u243a\u8b34\u347bs\ua7f5\ua4a6\ua031\ua940\u7d65"), objectArray));
        }
        this.targetClass.methods.add(methodNode);
        mixinTargetContext.methodMerged(methodNode);
        if (methodNode.signature != null) {
            if (this.mergeSignatures) {
                object = mixinTargetContext.getSignature().getRemapper();
                new SignatureReader(methodNode.signature).accept((SignatureVisitor)object);
                methodNode.signature = object.toString();
            } else {
                methodNode.signature = null;
            }
        }
    }

    protected boolean isAlreadyMerged(MixinTargetContext mixinTargetContext, MethodNode methodNode, boolean bl, MethodNode methodNode2) {
        AnnotationNode annotationNode = Annotations.getVisible(methodNode2, MixinMerged.class);
        if (annotationNode == null) {
            if (Annotations.getVisible(methodNode2, Final.class) != null) {
                Object[] objectArray = new Object[0xACA309AC ^ 0xACA309AE];
                objectArray[0x1A330137 ^ 0x1A330137] = methodNode.name;
                objectArray[0x2818581 ^ 0x2818580] = mixinTargetContext;
                this.logger.warn(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("]\ua7f0\ua4b0\ua063\ua912\u7d64\u8e43\u246e\u8b32\u3437b\ua7f4\ua4ba\ua079\ua90c\u7d74\u8e43\u246e\u8b32\u34732\ua7e0\ua4ba\ua063\ua945\u7d56\u8e6c\u2473\u8b39\u3476~\ua7a6\ua4b8\ua074\ua911\u7d7e\u8e45\u247e\u8b77\u346co\ua7a6\ua4bc\ua07f\ua945\u7d6d\u8e57\u2434\u8b77\u3444y\ua7ef\ua4a5\ua061\ua90c\u7d78\u8e4d\u243a\u8b3a\u3472f\ua7ee\ua4ba\ua075\ua94b"), objectArray);
                return (0x2FA4014A ^ 0x2FA4014B) != 0;
            }
            return (0x613803A5 ^ 0x613803A5) != 0;
        }
        String string = (String)Annotations.getValue(annotationNode, \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("a\ua7e3\ua4a6\ua062\ua90c\u7d79\u8e44\u2453\u8b33"));
        if (!this.context.getSessionId().equals(string)) {
            throw new ClassFormatError(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b17\u345a{\ua7fe\ua4bc\ua07f\ua928\u7d73\u8e58\u247d\u8b32\u34732\ua7e7\ua4bb\ua07f\ua90a\u7d62\u8e4b\u246e\u8b3e\u3478|\ua7a6\ua4b3\ua07e\ua910\u7d78\u8e4e\u243a\u8b3e\u3479") + mixinTargetContext + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2\ua7e7\ua4a1\ua031") + methodNode.name + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2\ua7ef\ua4bb\ua031") + this.targetClass.name);
        }
        if (Bytecode.hasFlag(methodNode2, 0xAF3E065D ^ 0xAF3E161D)) {
            if (Bytecode.hasFlag(methodNode, 0x31B06B6B ^ 0x31B07B2B)) {
                if (mixinTargetContext.getEnvironment().getOption(MixinEnvironment.Option.DEBUG_VERBOSE)) {
                    Object[] objectArray = new Object[0xF9FD9FB1 ^ 0xF9FD9FB3];
                    objectArray[0xFD36EB48 ^ 0xFD36EB48] = methodNode.name;
                    objectArray[0xF93FD8E2 ^ 0xF93FD8E3] = mixinTargetContext;
                    this.logger.warn(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("A\ua7ff\ua4bb\ua065\ua90d\u7d73\u8e5e\u2473\u8b34\u3437p\ua7f4\ua4bc\ua075\ua902\u7d73\u8e0a\u2477\u8b32\u3463z\ua7e9\ua4b1\ua031\ua906\u7d7a\u8e4b\u2469\u8b3f\u3437t\ua7e9\ua4a7\ua031\ua91e\u7d6b\u8e0a\u2473\u8b39\u3437i\ua7fb"), objectArray);
                }
                return (0x2DC86C11 ^ 0x2DC86C10) != 0;
            }
        }
        String string2 = (String)Annotations.getValue(annotationNode, \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("\u007f\ua7ef\ua4ad\ua078\ua90b"));
        int n = (Integer)Annotations.getValue(annotationNode, \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("b\ua7f4\ua4bc\ua07e\ua917\u7d7f\u8e5e\u2463"));
        if (n >= mixinTargetContext.getPriority() && !string2.equals(mixinTargetContext.getClassName())) {
            Object[] objectArray = new Object[0x3C3C92DE ^ 0x3C3C92DD];
            objectArray[0x1CAF82AC ^ 0x1CAF82AC] = methodNode.name;
            objectArray[0x81FCE3B0 ^ 0x81FCE3B1] = mixinTargetContext;
            objectArray[0x804F7EE1 ^ 0x804F7EE3] = string2;
            this.logger.warn(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("_\ua7e3\ua4a1\ua079\ua90a\u7d72\u8e0a\u2475\u8b21\u3472`\ua7f1\ua4a7\ua078\ua911\u7d73\u8e0a\u2479\u8b38\u3479t\ua7ea\ua4bc\ua072\ua911\u7d36\u8e4c\u2475\u8b25\u3437i\ua7fb\ua4f5\ua078\ua90b\u7d36\u8e51\u2467\u8b7b\u3437b\ua7f4\ua4b0\ua067\ua90c\u7d79\u8e5f\u2469\u8b3b\u346e2\ua7f1\ua4a7\ua078\ua911\u7d62\u8e4f\u2474\u8b77\u3475k\ua7a6\ua4ae\ua06c\ua94b\u7d36\u8e79\u2471\u8b3e\u3467b\ua7ef\ua4bb\ua076\ua945\u7d7b\u8e4f\u246e\u8b3f\u3478v\ua7a8"), objectArray);
            return (0xA895C27A ^ 0xA895C27B) != 0;
        }
        if (Annotations.getVisible(methodNode2, Final.class) != null) {
            Object[] objectArray = new Object[0x43DE9B98 ^ 0x43DE9B9B];
            objectArray[0xBD149BAA ^ 0xBD149BAA] = methodNode.name;
            objectArray[0x1FE2ADFE ^ 0x1FE2ADFF] = mixinTargetContext;
            objectArray[0x1483BBBF ^ 0x1483BBBD] = string2;
            this.logger.warn(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("_\ua7e3\ua4a1\ua079\ua90a\u7d72\u8e0a\u2475\u8b21\u3472`\ua7f1\ua4a7\ua078\ua911\u7d73\u8e0a\u2479\u8b38\u3479t\ua7ea\ua4bc\ua072\ua911\u7d36\u8e4c\u2475\u8b25\u3437R\ua7c0\ua4bc\ua07f\ua904\u7d7a\u8e0a\u2477\u8b32\u3463z\ua7e9\ua4b1\ua031\ua91e\u7d6b\u8e0a\u2473\u8b39\u3437i\ua7fb\ua4f5\ua075\ua900\u7d75\u8e46\u247b\u8b25\u3472v\ua7a6\ua4b7\ua068\ua945\u7d6d\u8e57\u2434\u8b77\u3444y\ua7ef\ua4a5\ua061\ua90c\u7d78\u8e4d\u243a\u8b3a\u3472f\ua7ee\ua4ba\ua075\ua94b"), objectArray);
            return (0x2249C0AC ^ 0x2249C0AD) != 0;
        }
        return (0xBD105B9E ^ 0xBD105B9E) != 0;
    }

    protected boolean mergeIntrinsic(MixinTargetContext mixinTargetContext, MethodNode methodNode, boolean bl, MethodNode methodNode2, AnnotationNode annotationNode) {
        AnnotationNode annotationNode2;
        if (bl) {
            throw new InvalidMixinException((IMixinContext)mixinTargetContext, \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("R\ua7cf\ua4bb\ua065\ua917\u7d7f\u8e44\u2469\u8b3e\u34742\ua7ef\ua4a6\ua031\ua90b\u7d79\u8e5e\u243a\u8b34\u3478\u007f\ua7f6\ua4b4\ua065\ua90c\u7d74\u8e46\u247f\u8b77\u3460{\ua7f2\ua4bd\ua031\ua925\u7d59\u8e5c\u247f\u8b25\u3460`\ua7ef\ua4a1\ua074\ua949\u7d36\u8e58\u247f\u8b3a\u3478d\ua7e3\ua4f5\ua07e\ua90b\u7d73\u8e0a\u2475\u8b31\u3437f\ua7ee\ua4b0\ua062\ua900\u7d36\u8e4b\u2474\u8b39\u3478f\ua7e7\ua4a1\ua078\ua90a\u7d78\u8e59\u243a\u8b38\u34792") + methodNode.name + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2\ua7ef\ua4bb\ua031") + mixinTargetContext);
        }
        String string = methodNode.name + methodNode.desc;
        if (Bytecode.hasFlag(methodNode, 0xED80ADF ^ 0xED80AD7)) {
            throw new InvalidMixinException((IMixinContext)mixinTargetContext, \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("R\ua7cf\ua4bb\ua065\ua917\u7d7f\u8e44\u2469\u8b3e\u34742\ua7eb\ua4b0\ua065\ua90d\u7d79\u8e4e\u243a\u8b34\u3476|\ua7e8\ua4ba\ua065\ua945\u7d74\u8e4f\u243a\u8b24\u3463s\ua7f2\ua4bc\ua072\ua949\u7d36\u8e4c\u2475\u8b22\u3479v\ua7a6") + string + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2\ua7ef\ua4bb\ua031") + mixinTargetContext);
        }
        if (!(Bytecode.hasFlag(methodNode, 0xD392EC74 ^ 0xD392FC74) || (annotationNode2 = Annotations.getVisible(methodNode, MixinRenamed.class)) != null && Annotations.getValue(annotationNode2, \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("{\ua7f5\ua49c\ua07f\ua911\u7d73\u8e58\u247c\u8b36\u3474w\ua7cb\ua4b0\ua07c\ua907\u7d73\u8e58"), Boolean.FALSE).booleanValue())) {
            throw new InvalidMixinException((IMixinContext)mixinTargetContext, \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("R\ua7cf\ua4bb\ua065\ua917\u7d7f\u8e44\u2469\u8b3e\u34742\ua7eb\ua4b0\ua065\ua90d\u7d79\u8e4e\u243a\u8b3a\u3462a\ua7f2\ua4f5\ua073\ua900\u7d36\u8e5a\u2468\u8b32\u3471{\ua7fe\ua4b0\ua075\ua945\u7d7f\u8e44\u246e\u8b32\u3465t\ua7e7\ua4b6\ua074\ua945\u7d7b\u8e4f\u246e\u8b3f\u3478v\ua7aa\ua4f5\ua07f\ua90a\u7d36\u8e58\u247f\u8b39\u3476\u007f\ua7e3\ua4f5\ua074\ua90b\u7d75\u8e45\u246f\u8b39\u3463w\ua7f4\ua4b0\ua075\ua945\u7d79\u8e44\u243a") + string + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2\ua7ef\ua4bb\ua031") + mixinTargetContext);
        }
        if (!Annotations.getValue(annotationNode, \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("v\ua7ef\ua4a6\ua061\ua909\u7d77\u8e49\u247f"), Boolean.FALSE).booleanValue()) {
            Object[] objectArray = new Object[0xA76A1A81 ^ 0xA76A1A83];
            objectArray[0x78346285 ^ 0x78346285] = string;
            objectArray[0xCDC84BFE ^ 0xCDC84BFF] = mixinTargetContext.getTargetClassRef();
            this.logger.log(mixinTargetContext.getLoggingLevel(), \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("A\ua7ed\ua4bc\ua061\ua915\u7d7f\u8e44\u247d\u8b77\u345e|\ua7f2\ua4a7\ua078\ua90b\u7d65\u8e43\u2479\u8b77\u347a{\ua7fe\ua4bc\ua07f\ua945\u7d7b\u8e4f\u246e\u8b3f\u3478v\ua7a6\ua4ae\ua06c\ua945\u7d70\u8e45\u2468\u8b77\u346co"), objectArray);
            return (0x1F97D02C ^ 0x1F97D02D) != 0;
        }
        this.displaceIntrinsic(mixinTargetContext, methodNode, methodNode2);
        return (0xB00C75C0 ^ 0xB00C75C0) != 0;
    }

    protected void displaceIntrinsic(MixinTargetContext mixinTargetContext, MethodNode methodNode, MethodNode methodNode2) {
        String string = \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("b\ua7f4\ua4ba\ua069\ua91c\u7d3d") + methodNode2.name;
        ListIterator<AbstractInsnNode> listIterator = methodNode.instructions.iterator();
        while (listIterator.hasNext()) {
            AbstractInsnNode abstractInsnNode = (AbstractInsnNode)listIterator.next();
            if (!(abstractInsnNode instanceof MethodInsnNode)) continue;
            if (abstractInsnNode.getOpcode() == (0x9F23ABFF ^ 0x9F23AB47)) continue;
            MethodInsnNode methodInsnNode = (MethodInsnNode)abstractInsnNode;
            if (!methodInsnNode.owner.equals(this.targetClass.name) || !methodInsnNode.name.equals(methodNode2.name) || !methodInsnNode.desc.equals(methodNode2.desc)) continue;
            methodInsnNode.name = string;
        }
        methodNode2.name = string;
    }

    protected final void appendInsns(MixinTargetContext mixinTargetContext, MethodNode methodNode) {
        if (Type.getReturnType(methodNode.desc) != Type.VOID_TYPE) {
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("S\ua7f2\ua4a1\ua074\ua908\u7d66\u8e5e\u247f\u8b33\u3437f\ua7e9\ua4f5\ua07c\ua900\u7d64\u8e4d\u247f\u8b77\u347e|\ua7f5\ua4bb\ua062\ua945\u7d70\u8e58\u2475\u8b3a\u3437s\ua7a6\ua4b8\ua074\ua911\u7d7e\u8e45\u247e\u8b77\u3460z\ua7ef\ua4b6\ua079\ua945\u7d72\u8e45\u247f\u8b24\u3437|\ua7e9\ua4a1\ua031\ua917\u7d73\u8e5e\u246f\u8b25\u34792\ua7f0\ua4ba\ua078\ua901"));
        }
        MethodNode methodNode2 = this.findTargetMethod(methodNode);
        if (methodNode2 != null) {
            AbstractInsnNode abstractInsnNode = Bytecode.findInsn(methodNode2, 0xB7FC5352 ^ 0xB7FC53E3);
            if (abstractInsnNode != null) {
                ListIterator<AbstractInsnNode> listIterator = methodNode.instructions.iterator();
                while (listIterator.hasNext()) {
                    AbstractInsnNode abstractInsnNode2 = (AbstractInsnNode)listIterator.next();
                    if (abstractInsnNode2 instanceof LineNumberNode) continue;
                    if (abstractInsnNode2.getOpcode() == (0xFCD66B0D ^ 0xFCD66BBC)) continue;
                    methodNode2.instructions.insertBefore(abstractInsnNode, abstractInsnNode2);
                }
                methodNode2.maxLocals = Math.max(methodNode2.maxLocals, methodNode.maxLocals);
                methodNode2.maxStack = Math.max(methodNode2.maxStack, methodNode.maxStack);
            }
            return;
        }
        this.targetClass.methods.add(methodNode);
    }

    protected void applyInitialisers(MixinTargetContext mixinTargetContext) {
        MethodNode methodNode = this.getConstructor(mixinTargetContext);
        if (methodNode == null) {
            return;
        }
        Deque<AbstractInsnNode> deque = this.getInitialiser(mixinTargetContext, methodNode);
        if (deque == null || deque.size() == 0) {
            return;
        }
        for (MethodNode methodNode2 : this.targetClass.methods) {
            if (!\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20(".\ua7ef\ua4bb\ua078\ua911\u7d28").equals(methodNode2.name)) continue;
            methodNode2.maxStack = Math.max(methodNode2.maxStack, methodNode.maxStack);
            this.injectInitialiser(mixinTargetContext, methodNode2, deque);
        }
    }

    protected MethodNode getConstructor(MixinTargetContext mixinTargetContext) {
        MethodNode methodNode = null;
        for (MethodNode methodNode2 : mixinTargetContext.getMethods()) {
            if (!\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20(".\ua7ef\ua4bb\ua078\ua911\u7d28").equals(methodNode2.name) || !Bytecode.methodHasLineNumbers(methodNode2)) continue;
            if (methodNode == null) {
                methodNode = methodNode2;
                continue;
            }
            Object[] objectArray = new Object[0xE0192A1E ^ 0xE0192A1C];
            objectArray[0xA975D8C6 ^ 0xA975D8C6] = mixinTargetContext;
            objectArray[0x8D04135B ^ 0x8D04135A] = methodNode.desc;
            this.logger.warn(String.format(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("_\ua7ef\ua4ad\ua078\ua90b\u7d36\u8e0f\u2469\u8b77\u347fs\ua7f5\ua4f5\ua07c\ua910\u7d7a\u8e5e\u2473\u8b27\u347bw\ua7a6\ua4b6\ua07e\ua90b\u7d65\u8e5e\u2468\u8b22\u3474f\ua7e9\ua4a7\ua062\ua949\u7d36\u8e0f\u2469\u8b77\u3460s\ua7f5\ua4f5\ua062\ua900\u7d7a\u8e4f\u2479\u8b23\u3472v\ua78c"), objectArray));
        }
        return methodNode;
    }

    private Range getConstructorRange(MethodNode methodNode) {
        int n = 0x7D2BB338 ^ 0x7D2BB338;
        AbstractInsnNode abstractInsnNode = null;
        int n2 = 0xA1990954 ^ 0xA1990954;
        int n3 = 0x5442F778 ^ 0x5442F778;
        int n4 = 0x2425C874 ^ 0x2425C874;
        int n5 = 0xB321AADE ^ 0x4CDE5521;
        Object object = methodNode.instructions.iterator();
        while (object.hasNext()) {
            AbstractInsnNode abstractInsnNode2 = (AbstractInsnNode)object.next();
            if (abstractInsnNode2 instanceof LineNumberNode) {
                n2 = ((LineNumberNode)abstractInsnNode2).line;
                n = 0xA221192D ^ 0xA221192C;
                continue;
            }
            if (abstractInsnNode2 instanceof MethodInsnNode) {
                if (abstractInsnNode2.getOpcode() != (0xF7E1EDCD ^ 0xF7E1ED7A) || !\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20(".\ua7ef\ua4bb\ua078\ua911\u7d28").equals(((MethodInsnNode)abstractInsnNode2).name)) continue;
                if (n5 != (0x1F2E5697 ^ 0xE0D1A968)) continue;
                n5 = methodNode.instructions.indexOf(abstractInsnNode2);
                n3 = n2;
                continue;
            }
            if (abstractInsnNode2.getOpcode() == (0xCECFE4F ^ 0xCECFEFA)) {
                n = 0x16E34B4D ^ 0x16E34B4D;
                continue;
            }
            if (abstractInsnNode2.getOpcode() != (0xFD625676 ^ 0xFD6256C7)) continue;
            if (n != 0) {
                n4 = n2;
                continue;
            }
            n4 = n3;
            abstractInsnNode = abstractInsnNode2;
        }
        if (abstractInsnNode != null) {
            object = new LabelNode(new Label());
            methodNode.instructions.insertBefore(abstractInsnNode, (AbstractInsnNode)object);
            methodNode.instructions.insertBefore(abstractInsnNode, new LineNumberNode(n3, (LabelNode)object));
        }
        return new Range(n3, n4, n5);
    }

    protected final Deque<AbstractInsnNode> getInitialiser(MixinTargetContext mixinTargetContext, MethodNode methodNode) {
        Range range = this.getConstructorRange(methodNode);
        if (!range.isValid()) {
            return null;
        }
        int n = 0x6F20D8B2 ^ 0x6F20D8B2;
        ArrayDeque<AbstractInsnNode> arrayDeque = new ArrayDeque<AbstractInsnNode>();
        int n2 = 0x1B0D84D0 ^ 0x1B0D84D0;
        int n3 = 0x276F9F3A ^ 0xD89060C5;
        LabelNode labelNode = null;
        Object object = methodNode.instructions.iterator(range.marker);
        while (object.hasNext()) {
            AbstractInsnNode abstractInsnNode = (AbstractInsnNode)object.next();
            if (abstractInsnNode instanceof LineNumberNode) {
                n = ((LineNumberNode)abstractInsnNode).line;
                AbstractInsnNode abstractInsnNode2 = methodNode.instructions.get(methodNode.instructions.indexOf(abstractInsnNode) + (0x7AB4B21 ^ 0x7AB4B20));
                if (n == range.end) {
                    if (abstractInsnNode2.getOpcode() != (0xF3F8F636 ^ 0xF3F8F687)) {
                        n2 = 0x664EF6C1 ^ 0x664EF6C0;
                        n3 = 0x1161E9EA ^ 0x1161E95B;
                        continue;
                    }
                }
                n2 = range.excludes(n) ? 1 : 0;
                n3 = 0x801617B8 ^ 0x7FE9E847;
                continue;
            }
            if (n2 == 0) continue;
            if (labelNode != null) {
                arrayDeque.add(labelNode);
                labelNode = null;
            }
            if (abstractInsnNode instanceof LabelNode) {
                labelNode = (LabelNode)abstractInsnNode;
                continue;
            }
            int n4 = abstractInsnNode.getOpcode();
            if (n4 == n3) {
                n3 = 0xA578B162 ^ 0x5A874E9D;
                continue;
            }
            int[] nArray = INITIALISER_OPCODE_BLACKLIST;
            int n5 = nArray.length;
            for (int i = 0x25CC6B9 ^ 0x25CC6B9; i < n5; ++i) {
                int n6 = nArray[i];
                if (n4 != n6) continue;
                throw new InvalidMixinException((IMixinContext)mixinTargetContext, \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("Q\ua7e7\ua4bb\ua07f\ua90a\u7d62\u8e0a\u2472\u8b36\u3479v\ua7ea\ua4b0\ua031") + Bytecode.getOpcodeName(n4) + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2\ua7e9\ua4a5\ua072\ua90a\u7d72\u8e4f\u243a\u8b7f\u3427j") + Integer.toHexString(n4).toUpperCase() + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20(";\ua7a6\ua4bc\ua07f\ua945\u7d75\u8e46\u247b\u8b24\u34642\ua7ef\ua4bb\ua078\ua911\u7d7f\u8e4b\u2476\u8b3e\u3464w\ua7f4"));
            }
            arrayDeque.add(abstractInsnNode);
        }
        object = (AbstractInsnNode)arrayDeque.peekLast();
        if (object != null) {
            if (((AbstractInsnNode)object).getOpcode() != (0xD82F2A82 ^ 0xD82F2A37)) {
                throw new InvalidMixinException((IMixinContext)mixinTargetContext, \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("Q\ua7e9\ua4a0\ua07d\ua901\u7d36\u8e44\u2475\u8b23\u3437b\ua7e7\ua4a7\ua062\ua900\u7d36\u8e43\u2474\u8b3e\u3463{\ua7e7\ua4b9\ua078\ua916\u7d73\u8e58\u2436\u8b77\u3472j\ua7f6\ua4b0\ua072\ua911\u7d73\u8e4e\u243a\u8b67\u346fP\ua7b3\ua4f9\ua031\ua903\u7d79\u8e5f\u2474\u8b33\u3437\"\ua7fe") + Integer.toHexString(((AbstractInsnNode)object).getOpcode()) + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2\ua7ef\ua4bb\ua031") + mixinTargetContext);
            }
        }
        return arrayDeque;
    }

    protected final void injectInitialiser(MixinTargetContext mixinTargetContext, MethodNode methodNode, Deque<AbstractInsnNode> deque) {
        Map<LabelNode, LabelNode> map = Bytecode.cloneLabels(methodNode.instructions);
        AbstractInsnNode abstractInsnNode = this.findInitialiserInjectionPoint(mixinTargetContext, methodNode, deque);
        if (abstractInsnNode == null) {
            Object[] objectArray = new Object[0x9F0A34C8 ^ 0x9F0A34C9];
            objectArray[0xA9BB2D09 ^ 0xA9BB2D09] = methodNode.desc;
            this.logger.warn(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("T\ua7e7\ua4bc\ua07d\ua900\u7d72\u8e0a\u246e\u8b38\u3437~\ua7e9\ua4b6\ua070\ua911\u7d73\u8e0a\u2473\u8b39\u347ef\ua7ef\ua4b4\ua07d\ua90c\u7d65\u8e4f\u2468\u8b77\u347e|\ua7ec\ua4b0\ua072\ua911\u7d7f\u8e45\u2474\u8b77\u3467}\ua7ef\ua4bb\ua065\ua945\u7d7f\u8e44\u243a\u8b6b\u347e|\ua7ef\ua4a1\ua02f\ua91e\u7d6b\u8e06\u243a\u8b3e\u3479{\ua7f2\ua4bc\ua070\ua909\u7d7f\u8e59\u247f\u8b25\u3437e\ua7e7\ua4a6\ua031\ua90b\u7d79\u8e5e\u243a\u8b3a\u347ej\ua7e3\ua4b1\ua031\ua90c\u7d78\u8e04"), objectArray);
            return;
        }
        for (AbstractInsnNode abstractInsnNode2 : deque) {
            if (abstractInsnNode2 instanceof LabelNode) continue;
            if (abstractInsnNode2 instanceof JumpInsnNode) {
                throw new InvalidMixinException((IMixinContext)mixinTargetContext, \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("G\ua7e8\ua4a6\ua064\ua915\u7d66\u8e45\u2468\u8b23\u3472v\ua7a6\ua49f\ua044\ua928\u7d46\u8e0a\u2475\u8b27\u3474}\ua7e2\ua4b0\ua031\ua90c\u7d78\u8e0a\u2473\u8b39\u347ef\ua7ef\ua4b4\ua07d\ua90c\u7d65\u8e4f\u2468\u8b77\u347e|\ua7a6") + mixinTargetContext);
            }
            AbstractInsnNode abstractInsnNode3 = abstractInsnNode2.clone(map);
            methodNode.instructions.insert(abstractInsnNode, abstractInsnNode3);
            abstractInsnNode = abstractInsnNode3;
        }
    }

    protected AbstractInsnNode findInitialiserInjectionPoint(MixinTargetContext mixinTargetContext, MethodNode methodNode, Deque<AbstractInsnNode> deque) {
        HashSet<String> hashSet = new HashSet<String>();
        for (AbstractInsnNode object2 : deque) {
            if (object2.getOpcode() != (0xF07BC747 ^ 0xF07BC7F2)) continue;
            hashSet.add(MixinApplicatorStandard.fieldKey((FieldInsnNode)object2));
        }
        Object object3 = this.getInitialiserInjectionMode(mixinTargetContext.getEnvironment());
        String string = mixinTargetContext.getTargetClassInfo().getName();
        String string2 = mixinTargetContext.getTargetClassInfo().getSuperName();
        AbstractInsnNode abstractInsnNode = null;
        ListIterator<AbstractInsnNode> listIterator = methodNode.instructions.iterator();
        while (listIterator.hasNext()) {
            String string3;
            AbstractInsnNode abstractInsnNode2 = (AbstractInsnNode)listIterator.next();
            if (abstractInsnNode2.getOpcode() == (0x6FEE6D05 ^ 0x6FEE6DB2) && \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20(".\ua7ef\ua4bb\ua078\ua911\u7d28").equals(((MethodInsnNode)abstractInsnNode2).name)) {
                string3 = ((MethodInsnNode)abstractInsnNode2).owner;
                if (!string3.equals(string) && !string3.equals(string2)) continue;
                abstractInsnNode = abstractInsnNode2;
                if (object3 != InitialiserInjectionMode.SAFE) continue;
                break;
            }
            if (abstractInsnNode2.getOpcode() != (0xE06B53BD ^ 0xE06B5308) || object3 != InitialiserInjectionMode.DEFAULT || !hashSet.contains(string3 = MixinApplicatorStandard.fieldKey((FieldInsnNode)abstractInsnNode2))) continue;
            abstractInsnNode = abstractInsnNode2;
        }
        return abstractInsnNode;
    }

    private InitialiserInjectionMode getInitialiserInjectionMode(MixinEnvironment mixinEnvironment) {
        String string = mixinEnvironment.getOptionValue(MixinEnvironment.Option.INITIALISER_INJECTION_MODE);
        if (string == null) {
            return InitialiserInjectionMode.DEFAULT;
        }
        try {
            return InitialiserInjectionMode.valueOf(string.toUpperCase());
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[0x1E49505 ^ 0x1E49504];
            objectArray[0xD86AEFB3 ^ 0xD86AEFB3] = string;
            this.logger.warn(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("Q\ua7e9\ua4a0\ua07d\ua901\u7d36\u8e44\u2475\u8b23\u3437b\ua7e7\ua4a7\ua062\ua900\u7d36\u8e5f\u2474\u8b32\u346fb\ua7e3\ua4b6\ua065\ua900\u7d72\u8e0a\u246c\u8b36\u347bg\ua7e3\ua4f5\ua033\ua91e\u7d6b\u8e08\u243a\u8b31\u3478`\ua7a6\ua4b8\ua078\ua91d\u7d7f\u8e44\u2434\u8b3e\u3479{\ua7f2\ua4bc\ua070\ua909\u7d7f\u8e59\u247f\u8b25\u345e|\ua7ec\ua4b0\ua072\ua911\u7d7f\u8e45\u2474\u8b1a\u3478v\ua7e3\ua4f9\ua031\ua917\u7d73\u8e5c\u247f\u8b25\u3463{\ua7e8\ua4b2\ua031\ua911\u7d79\u8e0a\u245e\u8b12\u3451S\ua7d3\ua499\ua045"), objectArray);
            return InitialiserInjectionMode.DEFAULT;
        }
    }

    private static String fieldKey(FieldInsnNode fieldInsnNode) {
        Object[] objectArray = new Object[0xFEA20A0D ^ 0xFEA20A0F];
        objectArray[0x1A1B27F6 ^ 0x1A1B27F6] = fieldInsnNode.desc;
        objectArray[0xD3CFA5DD ^ 0xD3CFA5DC] = fieldInsnNode.name;
        return String.format(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("7\ua7f5\ua4ef\ua034\ua916"), objectArray);
    }

    protected void prepareInjections(MixinTargetContext mixinTargetContext) {
        mixinTargetContext.prepareInjections();
    }

    protected void applyInjections(MixinTargetContext mixinTargetContext) {
        mixinTargetContext.applyInjections();
    }

    protected void applyAccessors(MixinTargetContext mixinTargetContext) {
        List<MethodNode> list = mixinTargetContext.generateAccessors();
        for (MethodNode methodNode : list) {
            if (methodNode.name.startsWith(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("."))) continue;
            this.mergeMethod(mixinTargetContext, methodNode);
        }
    }

    protected void checkMethodVisibility(MixinTargetContext mixinTargetContext, MethodNode methodNode) {
        if (Bytecode.hasFlag(methodNode, 0x1C96BBA ^ 0x1C96BB2)) {
            if (!Bytecode.hasFlag(methodNode, 0xDB79C4B5 ^ 0xDB79C4B7)) {
                if (!Bytecode.hasFlag(methodNode, 0x61F0EB40 ^ 0x61F0FB40) && Annotations.getVisible(methodNode, Overwrite.class) == null) {
                    Object[] objectArray = new Object[0x2AF1C4B2 ^ 0x2AF1C4B0];
                    objectArray[0x8C397D37 ^ 0x8C397D37] = mixinTargetContext;
                    objectArray[0xFE8BB1DC ^ 0xFE8BB1DD] = methodNode;
                    throw new InvalidMixinException((IMixinContext)mixinTargetContext, String.format(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("_\ua7ef\ua4ad\ua078\ua90b\u7d36\u8e0f\u2469\u8b77\u3474}\ua7e8\ua4a1\ua070\ua90c\u7d78\u8e59\u243a\u8b39\u3478|\ua7ab\ua4a5\ua063\ua90c\u7d60\u8e4b\u246e\u8b32\u3437a\ua7f2\ua4b4\ua065\ua90c\u7d75\u8e0a\u2477\u8b32\u3463z\ua7e9\ua4b1\ua031\ua940\u7d65"), objectArray));
                }
            }
        }
    }

    protected void applySourceMap(TargetClassContext targetClassContext) {
        this.targetClass.sourceDebug = targetClassContext.getSourceMap().toString();
    }

    protected void checkMethodConstraints(MixinTargetContext mixinTargetContext, MethodNode methodNode) {
        for (Class<? extends Annotation> clazz : CONSTRAINED_ANNOTATIONS) {
            AnnotationNode annotationNode = Annotations.getVisible(methodNode, clazz);
            if (annotationNode == null) continue;
            this.checkConstraints(mixinTargetContext, methodNode, annotationNode);
        }
    }

    protected final void checkConstraints(MixinTargetContext mixinTargetContext, MethodNode methodNode, AnnotationNode annotationNode) {
        try {
            ConstraintParser.Constraint constraint = ConstraintParser.parse(annotationNode);
            try {
                constraint.check(mixinTargetContext.getEnvironment());
            }
            catch (ConstraintViolationException constraintViolationException) {
                Object[] objectArray = new Object[0xD1D85DD3 ^ 0xD1D85DD0];
                objectArray[0x45D77E62 ^ 0x45D77E62] = constraintViolationException.getMessage();
                objectArray[0x3630E56B ^ 0x3630E56A] = methodNode;
                objectArray[0x1ADC074A ^ 0x1ADC0748] = mixinTargetContext;
                String string = String.format(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("Q\ua7e9\ua4bb\ua062\ua911\u7d64\u8e4b\u2473\u8b39\u34632\ua7f0\ua4bc\ua07e\ua909\u7d77\u8e5e\u2473\u8b38\u3479(\ua7a6\ua4f0\ua062\ua945\u7d79\u8e44\u243a\u8b72\u34642\ua7ef\ua4bb\ua031\ua940\u7d65"), objectArray);
                this.logger.warn(string);
                if (!mixinTargetContext.getEnvironment().getOption(MixinEnvironment.Option.IGNORE_CONSTRAINTS)) {
                    throw new InvalidMixinException(mixinTargetContext, string, (Throwable)constraintViolationException);
                }
            }
        }
        catch (InvalidConstraintException invalidConstraintException) {
            throw new InvalidMixinException((IMixinContext)mixinTargetContext, invalidConstraintException.getMessage());
        }
    }

    protected final MethodNode findTargetMethod(MethodNode methodNode) {
        for (MethodNode methodNode2 : this.targetClass.methods) {
            if (!methodNode2.name.equals(methodNode.name) || !methodNode2.desc.equals(methodNode.desc)) continue;
            return methodNode2;
        }
        return null;
    }

    protected final FieldNode findTargetField(FieldNode fieldNode) {
        for (FieldNode fieldNode2 : this.targetClass.fields) {
            if (!fieldNode2.name.equals(fieldNode.name)) continue;
            return fieldNode2;
        }
        return null;
    }

    static {
        int[] nArray = new int[0xB95BF5B8 ^ 0xB95BF5A2];
        nArray[0x10A6BC20 ^ 0x10A6BC20] = 0x3A2B3E7F ^ 0x3A2B3ECE;
        nArray[0xC9E7468B ^ 0xC9E7468A] = 0xAD2AFEE ^ 0xAD2AFFB;
        nArray[0x920B9967 ^ 0x920B9965] = 0xF72BCA9A ^ 0xF72BCA8C;
        nArray[0x50148FE3 ^ 0x50148FE0] = 0x2E8B86FE ^ 0x2E8B86E9;
        nArray[0xC6C7AB1C ^ 0xC6C7AB18] = 0x2A943590 ^ 0x2A943588;
        nArray[0x5FC1E3F ^ 0x5FC1E3A] = 0x461E9501 ^ 0x461E952F;
        nArray[0x739F1C5 ^ 0x739F1C3] = 0xF11B93D7 ^ 0xF11B93F8;
        nArray[0x1C202208 ^ 0x1C20220F] = 0x68271B62 ^ 0x68271B52;
        nArray[0xE4E51F33 ^ 0xE4E51F3B] = 0xECB41959 ^ 0xECB41968;
        nArray[0x9F459075 ^ 0x9F45907C] = 0xBDE840F5 ^ 0xBDE840C7;
        nArray[0x84DA09B1 ^ 0x84DA09BB] = 0x94350BD1 ^ 0x94350BE2;
        nArray[0x432CB3B8 ^ 0x432CB3B3] = 0xD0A9B481 ^ 0xD0A9B4B5;
        nArray[0xA92639CE ^ 0xA92639C2] = 0xC4238F23 ^ 0xC4238F16;
        nArray[0xDBFB8222 ^ 0xDBFB822F] = 0x9B142A94 ^ 0x9B142AA2;
        nArray[0x275C6183 ^ 0x275C618D] = 0xFF080067 ^ 0xFF080050;
        nArray[0xB7CE1762 ^ 0xB7CE176D] = 0xEEE4AA15 ^ 0xEEE4AA2D;
        nArray[0xA8E018FF ^ 0xA8E018EF] = 0x82E03FB9 ^ 0x82E03F80;
        nArray[0xBCEADCB3 ^ 0xBCEADCA2] = 0xE500E7 ^ 0xE500DD;
        nArray[0x8A66A1DA ^ 0x8A66A1C8] = 0xADE893D8 ^ 0xADE89397;
        nArray[0xED7E4D02 ^ 0xED7E4D11] = 0xBA17EFE8 ^ 0xBA17EFB8;
        nArray[0xDAED33E7 ^ 0xDAED33F3] = 0xA11E8616 ^ 0xA11E8647;
        nArray[0x45B62FA2 ^ 0x45B62FB7] = 0x9A04C308 ^ 0x9A04C35A;
        nArray[0x5635AF59 ^ 0x5635AF4F] = 0x5D6D8B9B ^ 0x5D6D8BC8;
        nArray[0xD9663E1D ^ 0xD9663E0A] = 0xAE3EE7B ^ 0xAE3EE2F;
        nArray[0xB1F455B2 ^ 0xB1F455AA] = 0xF5F305CB ^ 0xF5F3059E;
        nArray[0x66BCB5AA ^ 0x66BCB5B3] = 0xACB80CB3 ^ 0xACB80CE5;
        INITIALISER_OPCODE_BLACKLIST = nArray;
    }

    class Range {
        final int start;
        final int end;
        final int marker;

        Range(int n, int n2, int n3) {
            this.start = n;
            this.end = n2;
            this.marker = n3;
        }

        boolean isValid() {
            return (this.start != 0 && this.end != 0 && this.end >= this.start ? 0x52C5B7D2 ^ 0x52C5B7D3 : 0xE5F8A50E ^ 0xE5F8A50E) != 0;
        }

        boolean contains(int n) {
            return (n >= this.start && n <= this.end ? 0xA69D545C ^ 0xA69D545D : 0x845C8D69 ^ 0x845C8D69) != 0;
        }

        boolean excludes(int n) {
            return (n < this.start || n > this.end ? 0x73B19A13 ^ 0x73B19A12 : 0xA53153BF ^ 0xA53153BF) != 0;
        }

        public String toString() {
            Object[] objectArray = new Object[0xE2714621 ^ 0xE2714625];
            objectArray[0xA51A4701 ^ 0xA51A4701] = this.start;
            objectArray[0xECB9C704 ^ 0xECB9C705] = this.end;
            objectArray[0xE335AC6F ^ 0xE335AC6D] = this.marker;
            objectArray[0x1DA0D508 ^ 0x1DA0D50B] = this.isValid();
            return String.format(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("@\ua7e7\ua4bb\ua076\ua900\u7d4d\u8e0f\u247e\u8b7a\u3432v\ua7aa\ua4f0\ua075\ua949\u7d60\u8e4b\u2476\u8b3e\u3473/\ua7a3\ua4a6\ua038"), objectArray);
        }
    }

    static final class InitialiserInjectionMode
    extends Enum<InitialiserInjectionMode> {
        public static final /* enum */ InitialiserInjectionMode DEFAULT = new InitialiserInjectionMode();
        public static final /* enum */ InitialiserInjectionMode SAFE = new InitialiserInjectionMode();
        private static final /* synthetic */ InitialiserInjectionMode[] $VALUES;

        public static InitialiserInjectionMode[] values() {
            return (InitialiserInjectionMode[])$VALUES.clone();
        }

        public static InitialiserInjectionMode valueOf(String string) {
            return Enum.valueOf(InitialiserInjectionMode.class, string);
        }

        static {
            InitialiserInjectionMode[] initialiserInjectionModeArray = new InitialiserInjectionMode[0x3D29F62A ^ 0x3D29F628];
            initialiserInjectionModeArray[0xAAC3FE7C ^ 0xAAC3FE7C] = DEFAULT;
            initialiserInjectionModeArray[0x79F12DBA ^ 0x79F12DBB] = SAFE;
            $VALUES = initialiserInjectionModeArray;
        }
    }

    static final class ApplicatorPass
    extends Enum<ApplicatorPass> {
        public static final /* enum */ ApplicatorPass MAIN = new ApplicatorPass();
        public static final /* enum */ ApplicatorPass PREINJECT = new ApplicatorPass();
        public static final /* enum */ ApplicatorPass INJECT = new ApplicatorPass();
        private static final /* synthetic */ ApplicatorPass[] $VALUES;

        public static ApplicatorPass[] values() {
            return (ApplicatorPass[])$VALUES.clone();
        }

        public static ApplicatorPass valueOf(String string) {
            return Enum.valueOf(ApplicatorPass.class, string);
        }

        static {
            ApplicatorPass[] applicatorPassArray = new ApplicatorPass[0x62948ABC ^ 0x62948ABF];
            applicatorPassArray[0x5C61AA50 ^ 0x5C61AA50] = MAIN;
            applicatorPassArray[0x4ABFC858 ^ 0x4ABFC859] = PREINJECT;
            applicatorPassArray[0x91F16831 ^ 0x91F16833] = INJECT;
            $VALUES = applicatorPassArray;
        }
    }
}

