/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.launch.MixinInitialisationError;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.extensibility.IMixinConfig;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.injection.InjectionPoint;
import org.spongepowered.asm.mixin.refmap.IReferenceMapper;
import org.spongepowered.asm.mixin.refmap.ReferenceMapper;
import org.spongepowered.asm.mixin.refmap.RemappingReferenceMapper;
import org.spongepowered.asm.mixin.transformer.Config;
import org.spongepowered.asm.mixin.transformer.MixinInfo;
import org.spongepowered.asm.mixin.transformer.throwables.InvalidMixinException;
import org.spongepowered.asm.service.IMixinService;
import org.spongepowered.asm.service.MixinService;
import org.spongepowered.asm.util.VersionNumber;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2;

final class MixinConfig
implements Comparable<MixinConfig>,
IMixinConfig {
    private static int configOrder = 0xBF025214 ^ 0xBF025214;
    private static final Set<String> globalMixinList = new HashSet<String>();
    private final Logger logger = LogManager.getLogger((String)\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("\u007f\ua7ef\ua4ad\ua078\ua90b"));
    private final transient Map<String, List<MixinInfo>> mixinMapping = new HashMap<String, List<MixinInfo>>();
    private final transient Set<String> unhandledTargets = new HashSet<String>();
    private final transient List<MixinInfo> mixins = new ArrayList<MixinInfo>();
    private transient Config handle;
    @SerializedName(value="target")
    private String selector;
    @SerializedName(value="minVersion")
    private String version;
    @SerializedName(value="compatibilityLevel")
    private String compatibility;
    @SerializedName(value="required")
    private boolean required;
    @SerializedName(value="priority")
    private int priority = 0x5F12E308 ^ 0x5F12E0E0;
    @SerializedName(value="mixinPriority")
    private int mixinPriority = 0x9822E4E6 ^ 0x9822E70E;
    @SerializedName(value="package")
    private String mixinPackage;
    @SerializedName(value="mixins")
    private List<String> mixinClasses;
    @SerializedName(value="client")
    private List<String> mixinClassesClient;
    @SerializedName(value="server")
    private List<String> mixinClassesServer;
    @SerializedName(value="setSourceFile")
    private boolean setSourceFile = 0x74E3DA9B ^ 0x74E3DA9B;
    @SerializedName(value="refmap")
    private String refMapperConfig;
    @SerializedName(value="verbose")
    private boolean verboseLogging;
    private final transient int order;
    private final transient List<IListener> listeners;
    private transient IMixinService service;
    private transient MixinEnvironment env;
    private transient String name;
    @SerializedName(value="plugin")
    private String pluginClassName;
    @SerializedName(value="injectors")
    private InjectorOptions injectorOptions;
    @SerializedName(value="overwrites")
    private OverwriteOptions overwriteOptions;
    private transient IMixinConfigPlugin plugin;
    private transient IReferenceMapper refMapper;
    private transient boolean prepared;
    private transient boolean visited;

    private MixinConfig() {
        int n = configOrder;
        configOrder = n + (0xB210DE7A ^ 0xB210DE7B);
        this.order = n;
        this.listeners = new ArrayList<IListener>();
        this.injectorOptions = new InjectorOptions();
        this.overwriteOptions = new OverwriteOptions();
        this.prepared = 0x5D37C10F ^ 0x5D37C10F;
        this.visited = 0xFDC22E1 ^ 0xFDC22E1;
    }

    private boolean onLoad(IMixinService iMixinService, String string, MixinEnvironment mixinEnvironment) {
        this.service = iMixinService;
        this.name = string;
        this.env = this.parseSelector(this.selector, mixinEnvironment);
        this.required &= !this.env.getOption(MixinEnvironment.Option.IGNORE_REQUIRED) ? 0x2AFCAF0 ^ 0x2AFCAF1 : 0xC2AD177B ^ 0xC2AD177B;
        this.initCompatibilityLevel();
        this.initInjectionPoints();
        return this.checkVersion();
    }

    private void initCompatibilityLevel() {
        MixinEnvironment.CompatibilityLevel compatibilityLevel;
        if (this.compatibility == null) {
            return;
        }
        MixinEnvironment.CompatibilityLevel compatibilityLevel2 = MixinEnvironment.CompatibilityLevel.valueOf(this.compatibility.trim().toUpperCase());
        if (compatibilityLevel2 == (compatibilityLevel = MixinEnvironment.getCompatibilityLevel())) {
            return;
        }
        if (compatibilityLevel.isAtLeast(compatibilityLevel2) && !compatibilityLevel.canSupport(compatibilityLevel2)) {
            throw new MixinInitialisationError(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("_\ua7ef\ua4ad\ua078\ua90b\u7d36\u8e49\u2475\u8b39\u3471{\ua7e1\ua4f5") + this.name + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2\ua7f4\ua4b0\ua060\ua910\u7d7f\u8e58\u247f\u8b24\u3437q\ua7e9\ua4b8\ua061\ua904\u7d62\u8e43\u2478\u8b3e\u347b{\ua7f2\ua4ac\ua031\ua909\u7d73\u8e5c\u247f\u8b3b\u3437") + (Object)((Object)compatibilityLevel2) + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2\ua7f1\ua4bd\ua078\ua906\u7d7e\u8e0a\u2473\u8b24\u3437f\ua7e9\ua4ba\ua031\ua90a\u7d7a\u8e4e"));
        }
        if (!compatibilityLevel.canElevateTo(compatibilityLevel2)) {
            throw new MixinInitialisationError(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("_\ua7ef\ua4ad\ua078\ua90b\u7d36\u8e49\u2475\u8b39\u3471{\ua7e1\ua4f5") + this.name + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2\ua7f4\ua4b0\ua060\ua910\u7d7f\u8e58\u247f\u8b24\u3437q\ua7e9\ua4b8\ua061\ua904\u7d62\u8e43\u2478\u8b3e\u347b{\ua7f2\ua4ac\ua031\ua909\u7d73\u8e5c\u247f\u8b3b\u3437") + (Object)((Object)compatibilityLevel2) + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2\ua7f1\ua4bd\ua078\ua906\u7d7e\u8e0a\u2473\u8b24\u3437b\ua7f4\ua4ba\ua079\ua90c\u7d74\u8e43\u246e\u8b32\u34732\ua7e4\ua4ac\ua031") + (Object)((Object)compatibilityLevel));
        }
        MixinEnvironment.setCompatibilityLevel(compatibilityLevel2);
    }

    private MixinEnvironment parseSelector(String string, MixinEnvironment mixinEnvironment) {
        if (string != null) {
            String[] stringArray;
            Object object = stringArray = string.split(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("I\ua7a0\ua489\ua06d\ua945\u7d4b"));
            int n = ((String[])object).length;
            for (int i = 0xD572068B ^ 0xD572068B; i < n; ++i) {
                String string2 = object[i];
                string2 = string2.trim();
                Pattern pattern = Pattern.compile(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("L\ua7c6\ua4b0\ua07f\ua913\u7d3e\u8e15\u2420\u8b3e\u3465}\ua7e8\ua4b8\ua074\ua90b\u7d62\u8e03\u2425\u8b0b\u343f:\ua7dd\ua494\ua03c\ua93f\u7d4b\u8e01\u2433\u8b0b\u343e6"));
                Matcher matcher = pattern.matcher(string2);
                if (!matcher.matches()) continue;
                return MixinEnvironment.getEnvironment(MixinEnvironment.Phase.forName(matcher.group(0x1447C070 ^ 0x1447C071)));
            }
            object = MixinEnvironment.Phase.forName(string);
            if (object != null) {
                return MixinEnvironment.getEnvironment((MixinEnvironment.Phase)object);
            }
        }
        return mixinEnvironment;
    }

    private void initInjectionPoints() {
        if (this.injectorOptions.injectionPoints == null) {
            return;
        }
        for (String string : this.injectorOptions.injectionPoints) {
            try {
                Class<?> clazz = this.service.getClassProvider().findClass(string, (0x9353B61D ^ 0x9353B61C) != 0);
                if (InjectionPoint.class.isAssignableFrom(clazz)) {
                    InjectionPoint.register(clazz);
                    continue;
                }
                Object[] objectArray = new Object[0xEC85BE5B ^ 0xEC85BE59];
                objectArray[0x36600530 ^ 0x36600530] = clazz;
                objectArray[0xF96597B6 ^ 0xF96597B7] = this;
                this.logger.error(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("G\ua7e8\ua4b4\ua073\ua909\u7d73\u8e0a\u246e\u8b38\u3437`\ua7e3\ua4b2\ua078\ua916\u7d62\u8e4f\u2468\u8b77\u347e|\ua7ec\ua4b0\ua072\ua911\u7d7f\u8e45\u2474\u8b77\u3467}\ua7ef\ua4bb\ua065\ua945\u7d6d\u8e57\u243a\u8b31\u3478`\ua7a6\ua4ae\ua06c\ua949\u7d36\u8e49\u2476\u8b36\u3464a\ua7a6\ua4b8\ua064\ua916\u7d62\u8e0a\u247f\u8b2f\u3463w\ua7e8\ua4b1\ua031\ua92c\u7d78\u8e40\u247f\u8b34\u3463{\ua7e9\ua4bb\ua041\ua90a\u7d7f\u8e44\u246e"), objectArray);
            }
            catch (Throwable throwable) {
                this.logger.catching(throwable);
            }
        }
    }

    private boolean checkVersion() throws MixinInitialisationError {
        VersionNumber versionNumber;
        VersionNumber versionNumber2;
        if (this.version == null) {
            Object[] objectArray = new Object[0x86F57F6B ^ 0x86F57F6A];
            objectArray[0xA8339860 ^ 0xA8339860] = this.name;
            this.logger.error(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("_\ua7ef\ua4ad\ua078\ua90b\u7d36\u8e49\u2475\u8b39\u3471{\ua7e1\ua4f5\ua06a\ua918\u7d36\u8e4e\u2475\u8b32\u34642\ua7e8\ua4ba\ua065\ua945\u7d65\u8e5a\u247f\u8b34\u347et\ua7ff\ua4f5\ua033\ua908\u7d7f\u8e44\u244c\u8b32\u3465a\ua7ef\ua4ba\ua07f\ua947\u7d36\u8e5a\u2468\u8b38\u3467w\ua7f4\ua4a1\ua068"), objectArray);
        }
        if ((versionNumber2 = VersionNumber.parse(this.version)).compareTo(versionNumber = VersionNumber.parse(this.env.getVersion())) > 0) {
            Object[] objectArray = new Object[0xDB970B0D ^ 0xDB970B0E];
            objectArray[0xC4CEB5CB ^ 0xC4CEB5CB] = this.name;
            objectArray[0x5C91E7D9 ^ 0x5C91E7D8] = versionNumber2;
            objectArray[0x167DB34F ^ 0x167DB34D] = versionNumber;
            this.logger.warn(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("_\ua7ef\ua4ad\ua078\ua90b\u7d36\u8e49\u2475\u8b39\u3471{\ua7e1\ua4f5\ua06a\ua918\u7d36\u8e58\u247f\u8b26\u3462{\ua7f4\ua4b0\ua062\ua945\u7d7b\u8e43\u2462\u8b3e\u34792\ua7f5\ua4a0\ua073\ua916\u7d6f\u8e59\u246e\u8b32\u347a2\ua7f0\ua4b0\ua063\ua916\u7d7f\u8e45\u2474\u8b77\u346co\ua7a6\ua4b7\ua064\ua911\u7d36\u8e51\u2467\u8b77\u3460s\ua7f5\ua4f5\ua077\ua90a\u7d63\u8e44\u247e\u8b79\u3437F\ua7ee\ua4b0\ua031\ua908\u7d7f\u8e52\u2473\u8b39\u3437q\ua7e9\ua4bb\ua077\ua90c\u7d71\u8e0a\u246d\u8b3e\u347b~\ua7a6\ua4bb\ua07e\ua911\u7d36\u8e48\u247f\u8b77\u3476b\ua7f6\ua4b9\ua078\ua900\u7d72\u8e04"), objectArray);
            if (this.required) {
                throw new MixinInitialisationError(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("@\ua7e3\ua4a4\ua064\ua90c\u7d64\u8e4f\u247e\u8b77\u347a{\ua7fe\ua4bc\ua07f\ua945\u7d75\u8e45\u2474\u8b31\u347eu\ua7a6") + this.name + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2\ua7f4\ua4b0\ua060\ua910\u7d7f\u8e58\u247f\u8b24\u3437\u007f\ua7ef\ua4ad\ua078\ua90b\u7d36\u8e59\u246f\u8b35\u3464k\ua7f5\ua4a1\ua074\ua908\u7d36\u8e5c\u247f\u8b25\u3464{\ua7e9\ua4bb\ua031") + versionNumber2);
            }
            return (0x6AEB126F ^ 0x6AEB126F) != 0;
        }
        return (0xEF15E4C8 ^ 0xEF15E4C9) != 0;
    }

    void addListener(IListener iListener) {
        this.listeners.add(iListener);
    }

    void onSelect() {
        if (this.pluginClassName != null) {
            try {
                Class<?> clazz = this.service.getClassProvider().findClass(this.pluginClassName, (0xE1AD26A6 ^ 0xE1AD26A7) != 0);
                this.plugin = (IMixinConfigPlugin)clazz.newInstance();
                if (this.plugin != null) {
                    this.plugin.onLoad(this.mixinPackage);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                this.plugin = null;
            }
        }
        if (!this.mixinPackage.endsWith(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("<"))) {
            this.mixinPackage = this.mixinPackage + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("<");
        }
        int n = 0x4F3F5B56 ^ 0x4F3F5B56;
        if (this.refMapperConfig == null) {
            if (this.plugin != null) {
                this.refMapperConfig = this.plugin.getRefMapperConfig();
            }
            if (this.refMapperConfig == null) {
                n = 0xAED626A3 ^ 0xAED626A2;
                this.refMapperConfig = \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("\u007f\ua7ef\ua4ad\ua078\ua90b\u7d38\u8e58\u247f\u8b31\u347as\ua7f6\ua4fb\ua07b\ua916\u7d79\u8e44");
            }
        }
        this.refMapper = ReferenceMapper.read(this.refMapperConfig);
        this.verboseLogging |= this.env.getOption(MixinEnvironment.Option.DEBUG_VERBOSE);
        if (n == 0 && this.refMapper.isDefault() && !this.env.getOption(MixinEnvironment.Option.DISABLE_REFMAP)) {
            Object[] objectArray = new Object[0xEFE7D48F ^ 0xEFE7D48D];
            objectArray[0xB60DBEC7 ^ 0xB60DBEC7] = this.refMapperConfig;
            objectArray[0xF3986F62 ^ 0xF3986F63] = this;
            this.logger.warn(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("@\ua7e3\ua4b3\ua074\ua917\u7d73\u8e44\u2479\u8b32\u3437\u007f\ua7e7\ua4a5\ua031\ua942\u7d6d\u8e57\u243d\u8b77\u3471}\ua7f4\ua4f5\ua06a\ua918\u7d36\u8e49\u2475\u8b22\u347bv\ua7a6\ua4bb\ua07e\ua911\u7d36\u8e48\u247f\u8b77\u3465w\ua7e7\ua4b1\ua03f\ua945\u7d5f\u8e4c\u243a\u8b23\u347f{\ua7f5\ua4f5\ua078\ua916\u7d36\u8e4b\u243a\u8b33\u3472d\ua7e3\ua4b9\ua07e\ua915\u7d7b\u8e4f\u2474\u8b23\u3437w\ua7e8\ua4a3\ua078\ua917\u7d79\u8e44\u2477\u8b32\u3479f\ua7a6\ua4ac\ua07e\ua910\u7d36\u8e49\u247b\u8b39\u3437{\ua7e1\ua4bb\ua07e\ua917\u7d73\u8e0a\u246e\u8b3f\u347ea\ua7a6\ua4b8\ua074\ua916\u7d65\u8e4b\u247d\u8b32"), objectArray);
        }
        if (this.env.getOption(MixinEnvironment.Option.REFMAP_REMAP)) {
            this.refMapper = RemappingReferenceMapper.of(this.env, this.refMapper);
        }
    }

    void prepare() {
        if (this.prepared) {
            return;
        }
        this.prepared = 0x6B88A7D9 ^ 0x6B88A7D8;
        this.prepareMixins(this.mixinClasses, (0x9838341C ^ 0x9838341C) != 0);
        switch (1.$SwitchMap$org$spongepowered$asm$mixin$MixinEnvironment$Side[this.env.getSide().ordinal()]) {
            case 1: {
                this.prepareMixins(this.mixinClassesClient, (0x44ED7014 ^ 0x44ED7014) != 0);
                break;
            }
            case 2: {
                this.prepareMixins(this.mixinClassesServer, (0x2401D02D ^ 0x2401D02D) != 0);
                break;
            }
            default: {
                this.logger.warn(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("_\ua7ef\ua4ad\ua078\ua90b\u7d36\u8e4f\u2474\u8b21\u347e`\ua7e9\ua4bb\ua07c\ua900\u7d78\u8e5e\u243a\u8b20\u3476a\ua7a6\ua4a0\ua07f\ua904\u7d74\u8e46\u247f\u8b77\u3463}\ua7a6\ua4b1\ua074\ua911\u7d73\u8e49\u246e\u8b77\u3463z\ua7e3\ua4f5\ua072\ua910\u7d64\u8e58\u247f\u8b39\u34632\ua7f5\ua4bc\ua075\ua900\u7d3a\u8e0a\u2469\u8b3e\u3473w\ua7e2\ua4f5\ua07c\ua90c\u7d6e\u8e43\u2474\u8b24\u3437e\ua7ef\ua4b9\ua07d\ua945\u7d78\u8e45\u246e\u8b77\u3475w\ua7a6\ua4b4\ua061\ua915\u7d7a\u8e43\u247f\u8b33"));
            }
        }
    }

    void postInitialise() {
        Object object;
        if (this.plugin != null) {
            object = this.plugin.getMixins();
            this.prepareMixins((List<String>)object, (0x1EA3FC9F ^ 0x1EA3FC9E) != 0);
        }
        object = this.mixins.iterator();
        while (object.hasNext()) {
            MixinInfo mixinInfo = (MixinInfo)object.next();
            try {
                mixinInfo.validate();
                for (IListener iListener : this.listeners) {
                    iListener.onInit(mixinInfo);
                }
            }
            catch (InvalidMixinException invalidMixinException) {
                this.logger.error(invalidMixinException.getMixin() + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("(\ua7a6") + invalidMixinException.getMessage(), (Throwable)invalidMixinException);
                this.removeMixin(mixinInfo);
                object.remove();
            }
            catch (Exception exception) {
                this.logger.error(exception.getMessage(), (Throwable)exception);
                this.removeMixin(mixinInfo);
                object.remove();
            }
        }
    }

    private void removeMixin(MixinInfo mixinInfo) {
        for (List<MixinInfo> list : this.mixinMapping.values()) {
            Iterator<MixinInfo> iterator = list.iterator();
            while (iterator.hasNext()) {
                if (mixinInfo != iterator.next()) continue;
                iterator.remove();
            }
        }
    }

    private void prepareMixins(List<String> list, boolean bl) {
        if (list == null) {
            return;
        }
        for (String string : list) {
            String string2 = this.mixinPackage + string;
            if (string == null || globalMixinList.contains(string2)) continue;
            MixinInfo mixinInfo = null;
            try {
                mixinInfo = new MixinInfo(this.service, this, string, (0x3BA20737 ^ 0x3BA20736) != 0, this.plugin, bl);
                if (mixinInfo.getTargetClasses().size() <= 0) continue;
                globalMixinList.add(string2);
                for (String string3 : mixinInfo.getTargetClasses()) {
                    String string4 = string3.replace((char)(0x1754D709 ^ 0x1754D726), (char)(0x4B81134E ^ 0x4B811360));
                    this.mixinsFor(string4).add(mixinInfo);
                    this.unhandledTargets.add(string4);
                }
                for (IListener iListener : this.listeners) {
                    iListener.onPrepare(mixinInfo);
                }
                this.mixins.add(mixinInfo);
            }
            catch (InvalidMixinException invalidMixinException) {
                if (this.required) {
                    throw invalidMixinException;
                }
                this.logger.error(invalidMixinException.getMessage(), (Throwable)invalidMixinException);
            }
            catch (Exception exception) {
                if (this.required) {
                    throw new InvalidMixinException(mixinInfo, \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("W\ua7f4\ua4a7\ua07e\ua917\u7d36\u8e43\u2474\u8b3e\u3463{\ua7e7\ua4b9\ua078\ua916\u7d7f\u8e44\u247d\u8b77\u347a{\ua7fe\ua4bc\ua07f\ua945") + mixinInfo + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2\ua7ab\ua4f5") + exception.getClass() + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("(\ua7a6") + exception.getMessage(), (Throwable)exception);
                }
                this.logger.error(exception.getMessage(), (Throwable)exception);
            }
        }
    }

    void postApply(String string, ClassNode classNode) {
        this.unhandledTargets.remove(string);
    }

    public Config getHandle() {
        if (this.handle == null) {
            this.handle = new Config(this);
        }
        return this.handle;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public MixinEnvironment getEnvironment() {
        return this.env;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getMixinPackage() {
        return this.mixinPackage;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public int getDefaultMixinPriority() {
        return this.mixinPriority;
    }

    public int getDefaultRequiredInjections() {
        return this.injectorOptions.defaultRequireValue;
    }

    public String getDefaultInjectorGroup() {
        String string = this.injectorOptions.defaultGroup;
        return string != null && !string.isEmpty() ? string : \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("v\ua7e3\ua4b3\ua070\ua910\u7d7a\u8e5e");
    }

    public boolean conformOverwriteVisibility() {
        return this.overwriteOptions.conformAccessModifiers;
    }

    public boolean requireOverwriteAnnotations() {
        return this.overwriteOptions.requireOverwriteAnnotations;
    }

    public int getMaxShiftByValue() {
        return Math.min(Math.max(this.injectorOptions.maxShiftBy, 0x52F90D0D ^ 0x52F90D0D), 0x479CA8E7 ^ 0x479CA8E2);
    }

    public boolean select(MixinEnvironment mixinEnvironment) {
        this.visited = 0x7C8D517A ^ 0x7C8D517B;
        return (this.env == mixinEnvironment ? 0xB192E6DB ^ 0xB192E6DA : 0x3848A303 ^ 0x3848A303) != 0;
    }

    boolean isVisited() {
        return this.visited;
    }

    int getDeclaredMixinCount() {
        Collection[] collectionArray = new Collection[0x673F7412 ^ 0x673F7411];
        collectionArray[0x445F7CDD ^ 0x445F7CDD] = this.mixinClasses;
        collectionArray[0x2AC241C3 ^ 0x2AC241C2] = this.mixinClassesClient;
        collectionArray[0xB495A565 ^ 0xB495A567] = this.mixinClassesServer;
        return MixinConfig.getCollectionSize(collectionArray);
    }

    int getMixinCount() {
        return this.mixins.size();
    }

    public List<String> getClasses() {
        return Collections.unmodifiableList(this.mixinClasses);
    }

    public boolean shouldSetSourceFile() {
        return this.setSourceFile;
    }

    public IReferenceMapper getReferenceMapper() {
        if (this.env.getOption(MixinEnvironment.Option.DISABLE_REFMAP)) {
            return ReferenceMapper.DEFAULT_MAPPER;
        }
        this.refMapper.setContext(this.env.getRefmapObfuscationContext());
        return this.refMapper;
    }

    String remapClassName(String string, String string2) {
        return this.getReferenceMapper().remap(string, string2);
    }

    @Override
    public IMixinConfigPlugin getPlugin() {
        return this.plugin;
    }

    @Override
    public Set<String> getTargets() {
        return Collections.unmodifiableSet(this.mixinMapping.keySet());
    }

    public Set<String> getUnhandledTargets() {
        return Collections.unmodifiableSet(this.unhandledTargets);
    }

    public Level getLoggingLevel() {
        return this.verboseLogging ? Level.INFO : Level.DEBUG;
    }

    public boolean packageMatch(String string) {
        return string.startsWith(this.mixinPackage);
    }

    public boolean hasMixinsFor(String string) {
        return this.mixinMapping.containsKey(string);
    }

    public List<MixinInfo> getMixinsFor(String string) {
        return this.mixinsFor(string);
    }

    private List<MixinInfo> mixinsFor(String string) {
        List<MixinInfo> list = this.mixinMapping.get(string);
        if (list == null) {
            list = new ArrayList<MixinInfo>();
            this.mixinMapping.put(string, list);
        }
        return list;
    }

    public List<String> reloadMixin(String string, byte[] byArray) {
        for (MixinInfo mixinInfo : this.mixins) {
            if (!mixinInfo.getClassName().equals(string)) continue;
            mixinInfo.reloadMixin(byArray);
            return mixinInfo.getTargetClasses();
        }
        return Collections.emptyList();
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(MixinConfig mixinConfig) {
        if (mixinConfig == null) {
            return 0xE2756526 ^ 0xE2756526;
        }
        if (mixinConfig.priority == this.priority) {
            return this.order - mixinConfig.order;
        }
        return this.priority - mixinConfig.priority;
    }

    static Config create(String string, MixinEnvironment mixinEnvironment) {
        try {
            IMixinService iMixinService = MixinService.getService();
            MixinConfig mixinConfig = (MixinConfig)new Gson().fromJson((Reader)new InputStreamReader(iMixinService.getResourceAsStream(string)), MixinConfig.class);
            if (mixinConfig.onLoad(iMixinService, string, mixinEnvironment)) {
                return mixinConfig.getHandle();
            }
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Object[] objectArray = new Object[0x7C2C42D1 ^ 0x7C2C42D0];
            objectArray[0xCD0C8833 ^ 0xCD0C8833] = string;
            throw new IllegalArgumentException(String.format(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("F\ua7ee\ua4b0\ua031\ua916\u7d66\u8e4f\u2479\u8b3e\u3471{\ua7e3\ua4b1\ua031\ua917\u7d73\u8e59\u2475\u8b22\u3465q\ua7e3\ua4f5\ua036\ua940\u7d65\u8e0d\u243a\u8b20\u3476a\ua7a6\ua4bc\ua07f\ua913\u7d77\u8e46\u2473\u8b33\u3437}\ua7f4\ua4f5\ua072\ua90a\u7d63\u8e46\u247e\u8b77\u3479}\ua7f2\ua4f5\ua073\ua900\u7d36\u8e58\u247f\u8b36\u3473"), objectArray), exception);
        }
    }

    private static int getCollectionSize(Collection<?> ... collectionArray) {
        int n = 0x3FB84B31 ^ 0x3FB84B31;
        Collection<?>[] collectionArray2 = collectionArray;
        int n2 = collectionArray2.length;
        for (int i = 0x35D157A3 ^ 0x35D157A3; i < n2; ++i) {
            Collection<?> collection = collectionArray2[i];
            if (collection == null) continue;
            n += collection.size();
        }
        return n;
    }

    static interface IListener {
        public void onPrepare(MixinInfo var1);

        public void onInit(MixinInfo var1);
    }

    static class OverwriteOptions {
        @SerializedName(value="conformVisibility")
        boolean conformAccessModifiers;
        @SerializedName(value="requireAnnotations")
        boolean requireOverwriteAnnotations;

        OverwriteOptions() {
        }
    }

    static class InjectorOptions {
        @SerializedName(value="defaultRequire")
        int defaultRequireValue = 0x7141212A ^ 0x7141212A;
        @SerializedName(value="defaultGroup")
        String defaultGroup = \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("v\ua7e3\ua4b3\ua070\ua910\u7d7a\u8e5e");
        @SerializedName(value="injectionPoints")
        List<String> injectionPoints;
        @SerializedName(value="maxShiftBy")
        int maxShiftBy = 0xF76765CF ^ 0xF76765CF;

        InjectorOptions() {
        }
    }
}

