/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.spongepowered.asm.lib.ClassReader;
import org.spongepowered.asm.lib.ClassVisitor;
import org.spongepowered.asm.lib.FieldVisitor;
import org.spongepowered.asm.lib.MethodVisitor;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.InsnNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.gen.Invoker;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import org.spongepowered.asm.mixin.transformer.MixinConfig;
import org.spongepowered.asm.mixin.transformer.MixinInfo;
import org.spongepowered.asm.mixin.transformer.throwables.MixinTransformerError;
import org.spongepowered.asm.transformers.MixinClassWriter;
import org.spongepowered.asm.transformers.TreeTransformer;
import org.spongepowered.asm.util.Bytecode;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2;

class MixinPostProcessor
extends TreeTransformer
implements MixinConfig.IListener {
    private final Set<String> syntheticInnerClasses = new HashSet<String>();
    private final Map<String, MixinInfo> accessorMixins = new HashMap<String, MixinInfo>();
    private final Set<String> loadable = new HashSet<String>();

    MixinPostProcessor() {
    }

    @Override
    public void onInit(MixinInfo mixinInfo) {
        for (String string : mixinInfo.getSyntheticInnerClasses()) {
            this.registerSyntheticInner(string.replace((char)(0xADCD0B1E ^ 0xADCD0B31), (char)(0xA1081A54 ^ 0xA1081A7A)));
        }
    }

    @Override
    public void onPrepare(MixinInfo mixinInfo) {
        String string = mixinInfo.getClassName();
        if (mixinInfo.isLoadable()) {
            this.registerLoadable(string);
        }
        if (mixinInfo.isAccessor()) {
            this.registerAccessor(mixinInfo);
        }
    }

    void registerSyntheticInner(String string) {
        this.syntheticInnerClasses.add(string);
    }

    void registerLoadable(String string) {
        this.loadable.add(string);
    }

    void registerAccessor(MixinInfo mixinInfo) {
        this.registerLoadable(mixinInfo.getClassName());
        this.accessorMixins.put(mixinInfo.getClassName(), mixinInfo);
    }

    boolean canTransform(String string) {
        return (this.syntheticInnerClasses.contains(string) || this.loadable.contains(string) ? 0xF3C75351 ^ 0xF3C75350 : 0x731D1218 ^ 0x731D1218) != 0;
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public boolean isDelegationExcluded() {
        return (0xA42B086D ^ 0xA42B086C) != 0;
    }

    @Override
    public byte[] transformClassBytes(String string, String string2, byte[] byArray) {
        if (this.syntheticInnerClasses.contains(string2)) {
            return this.processSyntheticInner(byArray);
        }
        if (this.accessorMixins.containsKey(string2)) {
            MixinInfo mixinInfo = this.accessorMixins.get(string2);
            return this.processAccessor(byArray, mixinInfo);
        }
        return byArray;
    }

    private byte[] processSyntheticInner(byte[] byArray) {
        ClassReader classReader = new ClassReader(byArray);
        MixinClassWriter mixinClassWriter = new MixinClassWriter(classReader, 0x867FEEBE ^ 0x867FEEBE);
        ClassVisitor classVisitor = new ClassVisitor(0xF961A5D4 ^ 0xF964A5D4, mixinClassWriter){

            @Override
            public void visit(int n, int n2, String string, String string2, String string3, String[] stringArray) {
                super.visit(n, n2 | 0xF563F2E3 ^ 0xF563F2E2, string, string2, string3, stringArray);
            }

            @Override
            public FieldVisitor visitField(int n, String string, String string2, String string3, Object object) {
                if ((n & (0x5A62FD6A ^ 0x5A62FD6C)) == 0) {
                    n |= 0x393CAD7D ^ 0x393CAD7C;
                }
                return super.visitField(n, string, string2, string3, object);
            }

            @Override
            public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
                if ((n & (0x1DF4A92A ^ 0x1DF4A92C)) == 0) {
                    n |= 0x76947C05 ^ 0x76947C04;
                }
                return super.visitMethod(n, string, string2, string3, stringArray);
            }
        };
        classReader.accept(classVisitor, 0x357BF30E ^ 0x357BF306);
        return mixinClassWriter.toByteArray();
    }

    private byte[] processAccessor(byte[] byArray, MixinInfo mixinInfo) {
        if (!MixinEnvironment.getCompatibilityLevel().isAtLeast(MixinEnvironment.CompatibilityLevel.JAVA_8)) {
            return byArray;
        }
        int n = 0xF9637B28 ^ 0xF9637B28;
        MixinInfo.MixinClassNode mixinClassNode = mixinInfo.getClassNode(0x7D513377 ^ 0x7D513377);
        ClassInfo classInfo = mixinInfo.getTargets().get(0xD6644915 ^ 0xD6644915);
        for (MixinInfo.MixinMethodNode mixinMethodNode : mixinClassNode.mixinMethods) {
            if (!Bytecode.hasFlag(mixinMethodNode, 0xABDC4246 ^ 0xABDC424E)) continue;
            AnnotationNode annotationNode = mixinMethodNode.getVisibleAnnotation(Accessor.class);
            AnnotationNode annotationNode2 = mixinMethodNode.getVisibleAnnotation(Invoker.class);
            if (annotationNode == null && annotationNode2 == null) continue;
            ClassInfo.Method method = MixinPostProcessor.getAccessorMethod(mixinInfo, mixinMethodNode, classInfo);
            MixinPostProcessor.createProxy(mixinMethodNode, classInfo, method);
            n = 0xB9CD720D ^ 0xB9CD720C;
        }
        if (n != 0) {
            return this.writeClass(mixinClassNode);
        }
        return byArray;
    }

    private static ClassInfo.Method getAccessorMethod(MixinInfo mixinInfo, MethodNode methodNode, ClassInfo classInfo) throws MixinTransformerError {
        ClassInfo.Method method = mixinInfo.getClassInfo().findMethod(methodNode, 0x124DB6A6 ^ 0x124DB6AC);
        if (!method.isRenamed()) {
            throw new MixinTransformerError(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("G\ua7e8\ua4b0\ua069\ua915\u7d73\u8e49\u246e\u8b32\u34732\ua7f5\ua4a1\ua070\ua911\u7d73\u8e10\u243a") + mixinInfo + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2\ua7ea\ua4ba\ua070\ua901\u7d73\u8e4e\u243a\u8b35\u3472t\ua7e9\ua4a7\ua074\ua945") + classInfo + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2\ua7f1\ua4b4\ua062\ua945\u7d75\u8e45\u2474\u8b31\u3478`\ua7eb\ua4b0\ua075"));
        }
        return method;
    }

    private static void createProxy(MethodNode methodNode, ClassInfo classInfo, ClassInfo.Method method) {
        methodNode.instructions.clear();
        Type[] typeArray = Type.getArgumentTypes(methodNode.desc);
        Type type = Type.getReturnType(methodNode.desc);
        Bytecode.loadArgs(typeArray, methodNode.instructions, 0xF759CAD3 ^ 0xF759CAD3);
        methodNode.instructions.add(new MethodInsnNode(0x1E00FBA6 ^ 0x1E00FB1E, classInfo.getName(), method.getName(), methodNode.desc, (0xD933F73F ^ 0xD933F73F) != 0));
        methodNode.instructions.add(new InsnNode(type.getOpcode(0x737A69F8 ^ 0x737A6954)));
        methodNode.maxStack = Bytecode.getFirstNonArgLocalIndex(typeArray, (0x636F2DEF ^ 0x636F2DEF) != 0);
        methodNode.maxLocals = 0x9A8C5A3 ^ 0x9A8C5A3;
    }
}

