/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer;

import com.google.common.base.Strings;
import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.ListIterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.FieldInsnNode;
import org.spongepowered.asm.lib.tree.FieldNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.mixin.Dynamic;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.gen.Invoker;
import org.spongepowered.asm.mixin.gen.throwables.InvalidAccessorException;
import org.spongepowered.asm.mixin.refmap.IMixinContext;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import org.spongepowered.asm.mixin.transformer.InterfaceInfo;
import org.spongepowered.asm.mixin.transformer.MethodMapper;
import org.spongepowered.asm.mixin.transformer.MixinInfo;
import org.spongepowered.asm.mixin.transformer.MixinTargetContext;
import org.spongepowered.asm.mixin.transformer.TargetClassContext;
import org.spongepowered.asm.mixin.transformer.meta.MixinRenamed;
import org.spongepowered.asm.mixin.transformer.throwables.InvalidMixinException;
import org.spongepowered.asm.util.Annotations;
import org.spongepowered.asm.util.Bytecode;
import org.spongepowered.asm.util.perf.Profiler;
import org.spongepowered.asm.util.throwables.SyntheticBridgeException;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2;

class MixinPreProcessorStandard {
    private static final Logger logger = LogManager.getLogger((String)\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("\u007f\ua7ef\ua4ad\ua078\ua90b"));
    protected final MixinInfo mixin;
    protected final MixinInfo.MixinClassNode classNode;
    protected final MixinEnvironment env;
    protected final Profiler profiler = MixinEnvironment.getProfiler();
    private final boolean verboseLogging;
    private final boolean strictUnique;
    private boolean prepared;
    private boolean attached;

    MixinPreProcessorStandard(MixinInfo mixinInfo, MixinInfo.MixinClassNode mixinClassNode) {
        this.mixin = mixinInfo;
        this.classNode = mixinClassNode;
        this.env = mixinInfo.getParent().getEnvironment();
        this.verboseLogging = this.env.getOption(MixinEnvironment.Option.DEBUG_VERBOSE);
        this.strictUnique = this.env.getOption(MixinEnvironment.Option.DEBUG_UNIQUE);
    }

    final MixinPreProcessorStandard prepare() {
        if (this.prepared) {
            return this;
        }
        this.prepared = 0xF2F07194 ^ 0xF2F07195;
        Profiler.Section section = this.profiler.begin(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("b\ua7f4\ua4b0\ua061\ua904\u7d64\u8e4f"));
        for (MixinInfo.MixinMethodNode object : this.classNode.mixinMethods) {
            ClassInfo.Method method = this.mixin.getClassInfo().findMethod(object);
            this.prepareMethod(object, method);
        }
        for (FieldNode fieldNode : this.classNode.fields) {
            this.prepareField(fieldNode);
        }
        section.end();
        return this;
    }

    protected void prepareMethod(MixinInfo.MixinMethodNode mixinMethodNode, ClassInfo.Method method) {
        this.prepareShadow(mixinMethodNode, method);
        this.prepareSoftImplements(mixinMethodNode, method);
    }

    protected void prepareShadow(MixinInfo.MixinMethodNode mixinMethodNode, ClassInfo.Method method) {
        AnnotationNode annotationNode = Annotations.getVisible(mixinMethodNode, Shadow.class);
        if (annotationNode == null) {
            return;
        }
        String string = (String)Annotations.getValue(annotationNode, \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("b\ua7f4\ua4b0\ua077\ua90c\u7d6e"), Shadow.class);
        if (mixinMethodNode.name.startsWith(string)) {
            Object[] objectArray = new Object[0x2239609B ^ 0x22396099];
            objectArray[0x6CF0CAC5 ^ 0x6CF0CAC5] = \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("}\ua7f4\ua4bc\ua076\ua90c\u7d78\u8e4b\u2476\u8b19\u3476\u007f\ua7e3");
            objectArray[0x3AD0CFAC ^ 0x3AD0CFAD] = mixinMethodNode.name;
            Annotations.setVisible(mixinMethodNode, MixinRenamed.class, objectArray);
            String string2 = mixinMethodNode.name.substring(string.length());
            mixinMethodNode.name = method.renameTo(string2);
        }
    }

    protected void prepareSoftImplements(MixinInfo.MixinMethodNode mixinMethodNode, ClassInfo.Method method) {
        for (InterfaceInfo interfaceInfo : this.mixin.getSoftImplements()) {
            if (!interfaceInfo.renameMethod(mixinMethodNode)) continue;
            method.renameTo(mixinMethodNode.name);
        }
    }

    protected void prepareField(FieldNode fieldNode) {
    }

    final MixinPreProcessorStandard conform(TargetClassContext targetClassContext) {
        return this.conform(targetClassContext.getClassInfo());
    }

    final MixinPreProcessorStandard conform(ClassInfo classInfo) {
        Profiler.Section section = this.profiler.begin(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("q\ua7e9\ua4bb\ua077\ua90a\u7d64\u8e47"));
        for (MixinInfo.MixinMethodNode mixinMethodNode : this.classNode.mixinMethods) {
            if (!mixinMethodNode.isInjector()) continue;
            ClassInfo.Method method = this.mixin.getClassInfo().findMethod(mixinMethodNode, 0x73E1B9F1 ^ 0x73E1B9FB);
            this.conformInjector(classInfo, mixinMethodNode, method);
        }
        section.end();
        return this;
    }

    private void conformInjector(ClassInfo classInfo, MixinInfo.MixinMethodNode mixinMethodNode, ClassInfo.Method method) {
        MethodMapper methodMapper = classInfo.getMethodMapper();
        methodMapper.remapHandlerMethod(this.mixin, mixinMethodNode, method);
    }

    MixinTargetContext createContextFor(TargetClassContext targetClassContext) {
        MixinTargetContext mixinTargetContext = new MixinTargetContext(this.mixin, this.classNode, targetClassContext);
        this.conform(targetClassContext);
        this.attach(mixinTargetContext);
        return mixinTargetContext;
    }

    final MixinPreProcessorStandard attach(MixinTargetContext mixinTargetContext) {
        if (this.attached) {
            throw new IllegalStateException(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("B\ua7f4\ua4b0\ua061\ua917\u7d79\u8e49\u247f\u8b24\u3464}\ua7f4\ua4f5\ua066\ua904\u7d65\u8e0a\u247b\u8b3b\u3465w\ua7e7\ua4b1\ua068\ua945\u7d77\u8e5e\u246e\u8b36\u3474z\ua7e3\ua4b1"));
        }
        this.attached = 0xA75557D7 ^ 0xA75557D6;
        Profiler.Section section = this.profiler.begin(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("s\ua7f2\ua4a1\ua070\ua906\u7d7e"));
        Profiler.Section section2 = this.profiler.begin(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("\u007f\ua7e3\ua4a1\ua079\ua90a\u7d72\u8e59"));
        this.attachMethods(mixinTargetContext);
        section2 = section2.next(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("t\ua7ef\ua4b0\ua07d\ua901\u7d65"));
        this.attachFields(mixinTargetContext);
        section2 = section2.next(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("f\ua7f4\ua4b4\ua07f\ua916\u7d70\u8e45\u2468\u8b3a"));
        this.transform(mixinTargetContext);
        section2.end();
        section.end();
        return this;
    }

    protected void attachMethods(MixinTargetContext mixinTargetContext) {
        Iterator<MixinInfo.MixinMethodNode> iterator = this.classNode.mixinMethods.iterator();
        while (iterator.hasNext()) {
            MixinInfo.MixinMethodNode mixinMethodNode = iterator.next();
            if (!this.validateMethod(mixinTargetContext, mixinMethodNode)) {
                iterator.remove();
                continue;
            }
            if (this.attachInjectorMethod(mixinTargetContext, mixinMethodNode)) {
                mixinTargetContext.addMixinMethod(mixinMethodNode);
                continue;
            }
            if (this.attachAccessorMethod(mixinTargetContext, mixinMethodNode)) {
                iterator.remove();
                continue;
            }
            if (this.attachShadowMethod(mixinTargetContext, mixinMethodNode)) {
                mixinTargetContext.addShadowMethod(mixinMethodNode);
                iterator.remove();
                continue;
            }
            if (this.attachOverwriteMethod(mixinTargetContext, mixinMethodNode)) {
                mixinTargetContext.addMixinMethod(mixinMethodNode);
                continue;
            }
            if (this.attachUniqueMethod(mixinTargetContext, mixinMethodNode)) {
                iterator.remove();
                continue;
            }
            this.attachMethod(mixinTargetContext, mixinMethodNode);
            mixinTargetContext.addMixinMethod(mixinMethodNode);
        }
    }

    protected boolean validateMethod(MixinTargetContext mixinTargetContext, MixinInfo.MixinMethodNode mixinMethodNode) {
        return (0x9B333BDC ^ 0x9B333BDD) != 0;
    }

    protected boolean attachInjectorMethod(MixinTargetContext mixinTargetContext, MixinInfo.MixinMethodNode mixinMethodNode) {
        return mixinMethodNode.isInjector();
    }

    protected boolean attachAccessorMethod(MixinTargetContext mixinTargetContext, MixinInfo.MixinMethodNode mixinMethodNode) {
        return (this.attachAccessorMethod(mixinTargetContext, mixinMethodNode, SpecialMethod.ACCESSOR) || this.attachAccessorMethod(mixinTargetContext, mixinMethodNode, SpecialMethod.INVOKER) ? 0xEFC173D ^ 0xEFC173C : 0x394008F1 ^ 0x394008F1) != 0;
    }

    protected boolean attachAccessorMethod(MixinTargetContext mixinTargetContext, MixinInfo.MixinMethodNode mixinMethodNode, SpecialMethod specialMethod) {
        AnnotationNode annotationNode = mixinMethodNode.getVisibleAnnotation(specialMethod.annotation);
        if (annotationNode == null) {
            return (0xDCA45740 ^ 0xDCA45740) != 0;
        }
        String string = (Object)((Object)specialMethod) + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2\ua7eb\ua4b0\ua065\ua90d\u7d79\u8e4e\u243a") + mixinMethodNode.name;
        ClassInfo.Method method = this.getSpecialMethod(mixinMethodNode, specialMethod);
        if (MixinEnvironment.getCompatibilityLevel().isAtLeast(MixinEnvironment.CompatibilityLevel.JAVA_8) && method.isStatic()) {
            if (this.mixin.getTargets().size() > (0xBD12F49B ^ 0xBD12F49A)) {
                throw new InvalidAccessorException((IMixinContext)mixinTargetContext, string + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2\ua7ef\ua4bb\ua031\ua908\u7d63\u8e46\u246e\u8b3e\u343af\ua7e7\ua4a7\ua076\ua900\u7d62\u8e0a\u2477\u8b3e\u346f{\ua7e8\ua4f5\ua078\ua916\u7d36\u8e43\u2474\u8b21\u3476~\ua7ef\ua4b1\ua03f\ua945\u7d5b\u8e43\u2462\u8b3e\u34792\ua7eb\ua4a0\ua062\ua911\u7d36\u8e42\u247b\u8b21\u34722\ua7e3\ua4ad\ua070\ua906\u7d62\u8e46\u2463\u8b77\u34262\ua7f2\ua4b4\ua063\ua902\u7d73\u8e5e\u2434"));
            }
            String string2 = mixinTargetContext.getUniqueName(mixinMethodNode, (0x274963CD ^ 0x274963CC) != 0);
            Object[] objectArray = new Object[0x46246C33 ^ 0x46246C37];
            objectArray[0x49943D8F ^ 0x49943D8F] = mixinMethodNode.name;
            objectArray[0x40791E26 ^ 0x40791E27] = mixinMethodNode.desc;
            objectArray[0x934ADCA3 ^ 0x934ADCA1] = string2;
            objectArray[0x7B451428 ^ 0x7B45142B] = this.mixin;
            logger.log(this.mixin.getLoggingLevel(), \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("@\ua7e3\ua4bb\ua070\ua908\u7d7f\u8e44\u247d\u8b77\u3457G\ua7e8\ua4bc\ua060\ua910\u7d73\u8e0a\u2477\u8b32\u3463z\ua7e9\ua4b1\ua031\ua91e\u7d6b\u8e51\u2467\u8b77\u3463}\ua7a6\ua4ae\ua06c\ua945\u7d7f\u8e44\u243a\u8b2c\u346a"), objectArray);
            mixinMethodNode.name = method.renameTo(string2);
        } else {
            if (!method.isAbstract()) {
                throw new InvalidAccessorException((IMixinContext)mixinTargetContext, string + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2\ua7ef\ua4a6\ua031\ua90b\u7d79\u8e5e\u243a\u8b36\u3475a\ua7f2\ua4a7\ua070\ua906\u7d62"));
            }
            if (method.isStatic()) {
                throw new InvalidAccessorException((IMixinContext)mixinTargetContext, string + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2\ua7e5\ua4b4\ua07f\ua90b\u7d79\u8e5e\u243a\u8b35\u34722\ua7f5\ua4a1\ua070\ua911\u7d7f\u8e49"));
            }
        }
        mixinTargetContext.addAccessorMethod(mixinMethodNode, specialMethod.annotation);
        return (0x30A96657 ^ 0x30A96656) != 0;
    }

    protected boolean attachShadowMethod(MixinTargetContext mixinTargetContext, MixinInfo.MixinMethodNode mixinMethodNode) {
        return this.attachSpecialMethod(mixinTargetContext, mixinMethodNode, SpecialMethod.SHADOW);
    }

    protected boolean attachOverwriteMethod(MixinTargetContext mixinTargetContext, MixinInfo.MixinMethodNode mixinMethodNode) {
        return this.attachSpecialMethod(mixinTargetContext, mixinMethodNode, SpecialMethod.OVERWRITE);
    }

    protected boolean attachSpecialMethod(MixinTargetContext mixinTargetContext, MixinInfo.MixinMethodNode mixinMethodNode, SpecialMethod specialMethod) {
        AnnotationNode annotationNode = mixinMethodNode.getVisibleAnnotation(specialMethod.annotation);
        if (annotationNode == null) {
            return (0x1F05FE21 ^ 0x1F05FE21) != 0;
        }
        if (specialMethod.isOverwrite) {
            this.checkMixinNotUnique(mixinMethodNode, specialMethod);
        }
        ClassInfo.Method method = this.getSpecialMethod(mixinMethodNode, specialMethod);
        MethodNode methodNode = mixinTargetContext.findMethod(mixinMethodNode, annotationNode);
        if (methodNode == null) {
            if (specialMethod.isOverwrite) {
                return (0xD838AA4C ^ 0xD838AA4C) != 0;
            }
            methodNode = mixinTargetContext.findRemappedMethod(mixinMethodNode);
            if (methodNode == null) {
                Object[] objectArray = new Object[0x8EB0B410 ^ 0x8EB0B416];
                objectArray[0x339CEF86 ^ 0x339CEF86] = specialMethod;
                objectArray[0xB78ED599 ^ 0xB78ED598] = mixinMethodNode.name;
                objectArray[0x1698821B ^ 0x16988219] = this.mixin;
                objectArray[0xC2269C46 ^ 0xC2269C45] = mixinTargetContext.getTarget();
                objectArray[0x62CA2343 ^ 0x62CA2347] = mixinTargetContext.getReferenceMapper().getStatus();
                objectArray[0x626C834D ^ 0x626C8348] = MixinPreProcessorStandard.getDynamicInfo(mixinMethodNode);
                throw new InvalidMixinException((IMixinInfo)this.mixin, String.format(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("7\ua7f5\ua4f5\ua07c\ua900\u7d62\u8e42\u2475\u8b33\u34377\ua7f5\ua4f5\ua078\ua90b\u7d36\u8e0f\u2469\u8b77\u3460s\ua7f5\ua4f5\ua07f\ua90a\u7d62\u8e0a\u2476\u8b38\u3474s\ua7f2\ua4b0\ua075\ua945\u7d7f\u8e44\u243a\u8b23\u347fw\ua7a6\ua4a1\ua070\ua917\u7d71\u8e4f\u246e\u8b77\u3474~\ua7e7\ua4a6\ua062\ua945\u7d33\u8e59\u2434\u8b77\u3432a\ua7a3\ua4a6"), objectArray));
            }
            mixinMethodNode.name = method.renameTo(methodNode.name);
        }
        if (\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20(".\ua7ef\ua4bb\ua078\ua911\u7d28").equals(methodNode.name)) {
            Object[] objectArray = new Object[0x1B160653 ^ 0x1B160651];
            objectArray[0x3ACF0B4C ^ 0x3ACF0B4C] = mixinMethodNode.name;
            objectArray[0x53FE64B8 ^ 0x53FE64B9] = this.mixin;
            throw new InvalidMixinException((IMixinInfo)this.mixin, String.format(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("\\\ua7ef\ua4b6\ua074\ua945\u7d62\u8e58\u2463\u8b76\u34377\ua7f5\ua4f5\ua078\ua90b\u7d36\u8e0f\u2469\u8b77\u3474s\ua7e8\ua4bb\ua07e\ua911\u7d36\u8e4b\u2476\u8b3e\u3476a\ua7a6\ua4b4\ua031\ua906\u7d79\u8e44\u2469\u8b23\u3465g\ua7e5\ua4a1\ua07e\ua917"), objectArray));
        }
        if (!Bytecode.compareFlags(mixinMethodNode, methodNode, 0xDEFD4A0 ^ 0xDEFD4A8)) {
            Object[] objectArray = new Object[0x596CE36C ^ 0x596CE36F];
            objectArray[0x72A035FC ^ 0x72A035FC] = specialMethod;
            objectArray[0x76524C4D ^ 0x76524C4C] = mixinMethodNode.name;
            objectArray[0x92750DD3 ^ 0x92750DD1] = this.mixin;
            throw new InvalidMixinException((IMixinInfo)this.mixin, String.format(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("A\ua7d2\ua494\ua045\ua92c\u7d55\u8e0a\u2477\u8b38\u3473{\ua7e0\ua4bc\ua074\ua917\u7d36\u8e45\u247c\u8b77\u3432a\ua7a6\ua4b8\ua074\ua911\u7d7e\u8e45\u247e\u8b77\u3432a\ua7a6\ua4bc\ua07f\ua945\u7d33\u8e59\u243a\u8b33\u3478w\ua7f5\ua4f5\ua07f\ua90a\u7d62\u8e0a\u2477\u8b36\u3463q\ua7ee\ua4f5\ua065\ua90d\u7d73\u8e0a\u246e\u8b36\u3465u\ua7e3\ua4a1"), objectArray));
        }
        this.conformVisibility(mixinTargetContext, mixinMethodNode, specialMethod, methodNode);
        if (!methodNode.name.equals(mixinMethodNode.name)) {
            if (specialMethod.isOverwrite) {
                if ((methodNode.access & (0xECC5C3CE ^ 0xECC5C3CC)) == 0) {
                    throw new InvalidMixinException((IMixinInfo)this.mixin, \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("\\\ua7e9\ua4bb\ua03c\ua915\u7d64\u8e43\u246c\u8b36\u3463w\ua7a6\ua4b8\ua074\ua911\u7d7e\u8e45\u247e\u8b77\u3474s\ua7e8\ua4bb\ua07e\ua911\u7d36\u8e48\u247f\u8b77\u3476~\ua7ef\ua4b4\ua062\ua900\u7d72\u8e04\u243a\u8b11\u3478g\ua7e8\ua4b1\ua031") + methodNode.name);
                }
            }
            mixinMethodNode.name = method.renameTo(methodNode.name);
        }
        return (0x8EC7B8BA ^ 0x8EC7B8BB) != 0;
    }

    private void conformVisibility(MixinTargetContext mixinTargetContext, MixinInfo.MixinMethodNode mixinMethodNode, SpecialMethod specialMethod, MethodNode methodNode) {
        Bytecode.Visibility visibility = Bytecode.getVisibility(methodNode);
        Bytecode.Visibility visibility2 = Bytecode.getVisibility(mixinMethodNode);
        if (visibility2.ordinal() >= visibility.ordinal()) {
            if (visibility == Bytecode.Visibility.PRIVATE && visibility2.ordinal() > Bytecode.Visibility.PRIVATE.ordinal()) {
                mixinTargetContext.getTarget().addUpgradedMethod(methodNode);
            }
            return;
        }
        Object[] objectArray = new Object[0x383433C7 ^ 0x383433C2];
        objectArray[0x2F8C3545 ^ 0x2F8C3545] = visibility2;
        objectArray[0x5BFFA290 ^ 0x5BFFA291] = specialMethod;
        objectArray[0xD32C87EA ^ 0xD32C87E8] = mixinMethodNode.name;
        objectArray[0x2A4A8732 ^ 0x2A4A8731] = this.mixin;
        objectArray[0x9913E31A ^ 0x9913E31E] = visibility;
        String string = String.format(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("7\ua7f5\ua4f5\ua034\ua916\u7d36\u8e47\u247f\u8b23\u347f}\ua7e2\ua4f5\ua034\ua916\u7d36\u8e43\u2474\u8b77\u3432a\ua7a6\ua4b6\ua070\ua90b\u7d78\u8e45\u246e\u8b77\u3465w\ua7e2\ua4a0\ua072\ua900\u7d36\u8e5c\u2473\u8b24\u347ep\ua7ef\ua4b9\ua078\ua91c\u7d36\u8e45\u247c\u8b77\u3432a\ua7a6\ua4a1\ua070\ua917\u7d71\u8e4f\u246e\u8b77\u347aw\ua7f2\ua4bd\ua07e\ua901"), objectArray);
        if (specialMethod.isOverwrite && !this.mixin.getParent().conformOverwriteVisibility()) {
            throw new InvalidMixinException((IMixinInfo)this.mixin, string);
        }
        if (visibility2 == Bytecode.Visibility.PRIVATE) {
            if (specialMethod.isOverwrite) {
                Object[] objectArray2 = new Object[0xA92CDB37 ^ 0xA92CDB36];
                objectArray2[0xF1CFE111 ^ 0xF1CFE111] = string;
                logger.warn(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("A\ua7f2\ua4b4\ua065\ua90c\u7d75\u8e0a\u2478\u8b3e\u3479v\ua7ef\ua4bb\ua076\ua945\u7d60\u8e43\u2475\u8b3b\u3476f\ua7ef\ua4ba\ua07f\ua95f\u7d36\u8e51\u2467\u8b7b\u3437d\ua7ef\ua4a6\ua078\ua907\u7d7f\u8e46\u2473\u8b23\u346e2\ua7f1\ua4bc\ua07d\ua909\u7d36\u8e48\u247f\u8b77\u3462b\ua7e1\ua4a7\ua070\ua901\u7d73\u8e4e\u2434"), objectArray2);
            }
            mixinTargetContext.addUpgradedMethod(mixinMethodNode);
            Bytecode.setVisibility((MethodNode)mixinMethodNode, visibility);
        }
    }

    protected ClassInfo.Method getSpecialMethod(MixinInfo.MixinMethodNode mixinMethodNode, SpecialMethod specialMethod) {
        ClassInfo.Method method = this.mixin.getClassInfo().findMethod(mixinMethodNode, 0x6BE579DF ^ 0x6BE579D5);
        this.checkMethodNotUnique(method, specialMethod);
        return method;
    }

    protected void checkMethodNotUnique(ClassInfo.Method method, SpecialMethod specialMethod) {
        if (method.isUnique()) {
            Object[] objectArray = new Object[0x30AA5C4B ^ 0x30AA5C48];
            objectArray[0x14EE37C1 ^ 0x14EE37C1] = specialMethod;
            objectArray[0x4D57A9C7 ^ 0x4D57A9C6] = method.getName();
            objectArray[0xD66FB243 ^ 0xD66FB241] = this.mixin;
            throw new InvalidMixinException((IMixinInfo)this.mixin, String.format(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("7\ua7f5\ua4f5\ua07c\ua900\u7d62\u8e42\u2475\u8b33\u34377\ua7f5\ua4f5\ua078\ua90b\u7d36\u8e0f\u2469\u8b77\u3474s\ua7e8\ua4bb\ua07e\ua911\u7d36\u8e48\u247f\u8b77\u3457G\ua7e8\ua4bc\ua060\ua910\u7d73"), objectArray));
        }
    }

    protected void checkMixinNotUnique(MixinInfo.MixinMethodNode mixinMethodNode, SpecialMethod specialMethod) {
        if (this.mixin.isUnique()) {
            Object[] objectArray = new Object[0xA506CF59 ^ 0xA506CF5A];
            objectArray[0x4E3A368F ^ 0x4E3A368F] = specialMethod;
            objectArray[0x4A8B23AF ^ 0x4A8B23AE] = mixinMethodNode.name;
            objectArray[0xCDF7C8E0 ^ 0xCDF7C8E2] = this.mixin;
            throw new InvalidMixinException((IMixinInfo)this.mixin, String.format(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("7\ua7f5\ua4f5\ua07c\ua900\u7d62\u8e42\u2475\u8b33\u34377\ua7f5\ua4f5\ua077\ua90a\u7d63\u8e44\u247e\u8b77\u347e|\ua7a6\ua4b4\ua031\ua925\u7d43\u8e44\u2473\u8b26\u3462w\ua7a6\ua4b8\ua078\ua91d\u7d7f\u8e44\u243a\u8b72\u3464"), objectArray));
        }
    }

    protected boolean attachUniqueMethod(MixinTargetContext mixinTargetContext, MixinInfo.MixinMethodNode mixinMethodNode) {
        String string;
        MethodNode methodNode;
        ClassInfo.Method method = this.mixin.getClassInfo().findMethod(mixinMethodNode, 0x28ADF711 ^ 0x28ADF71B);
        if (method == null || !method.isUnique() && !this.mixin.isUnique() && !method.isSynthetic()) {
            return (0x8A173286 ^ 0x8A173286) != 0;
        }
        if (method.isSynthetic()) {
            mixinTargetContext.transformDescriptor(mixinMethodNode);
            method.remapTo(mixinMethodNode.desc);
        }
        if ((methodNode = mixinTargetContext.findMethod(mixinMethodNode, null)) == null) {
            return (0xCDC72910 ^ 0xCDC72910) != 0;
        }
        String string2 = string = method.isSynthetic() ? \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("a\ua7ff\ua4bb\ua065\ua90d\u7d73\u8e5e\u2473\u8b34") : \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("R\ua7d3\ua4bb\ua078\ua914\u7d63\u8e4f");
        if (Bytecode.getVisibility(mixinMethodNode).ordinal() < Bytecode.Visibility.PUBLIC.ordinal()) {
            String string3 = mixinTargetContext.getUniqueName(mixinMethodNode, (0x7AFDACD8 ^ 0x7AFDACD8) != 0);
            Object[] objectArray = new Object[0x70883F50 ^ 0x70883F55];
            objectArray[0x91EB9559 ^ 0x91EB9559] = string;
            objectArray[0x2D34D738 ^ 0x2D34D739] = mixinMethodNode.name;
            objectArray[0x93B630F ^ 0x93B630D] = mixinMethodNode.desc;
            objectArray[0x83EF9F78 ^ 0x83EF9F7B] = string3;
            objectArray[0xFE9003EE ^ 0xFE9003EA] = this.mixin;
            logger.log(this.mixin.getLoggingLevel(), \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("@\ua7e3\ua4bb\ua070\ua908\u7d7f\u8e44\u247d\u8b77\u346co\ua7a6\ua4b8\ua074\ua911\u7d7e\u8e45\u247e\u8b77\u346co\ua7fd\ua4a8\ua031\ua911\u7d79\u8e0a\u2461\u8b2a\u3437{\ua7e8\ua4f5\ua06a\ua918"), objectArray);
            mixinMethodNode.name = method.renameTo(string3);
            return (0xBF69E19A ^ 0xBF69E19A) != 0;
        }
        if (this.strictUnique) {
            Object[] objectArray = new Object[0x9D67484E ^ 0x9D674848];
            objectArray[0x85919BA0 ^ 0x85919BA0] = string;
            objectArray[0x2671F773 ^ 0x2671F772] = mixinMethodNode.name;
            objectArray[0x7AD0D1D2 ^ 0x7AD0D1D0] = this.mixin;
            objectArray[0x1020CB8B ^ 0x1020CB88] = methodNode.name;
            objectArray[0x70CB57A9 ^ 0x70CB57AD] = methodNode.desc;
            objectArray[0x26E4A61C ^ 0x26E4A619] = mixinTargetContext.getTarget();
            throw new InvalidMixinException((IMixinInfo)this.mixin, String.format(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("_\ua7e3\ua4a1\ua079\ua90a\u7d72\u8e0a\u2479\u8b38\u3479t\ua7ea\ua4bc\ua072\ua911\u7d3a\u8e0a\u243f\u8b24\u3437\u007f\ua7e3\ua4a1\ua079\ua90a\u7d72\u8e0a\u243f\u8b24\u3437{\ua7e8\ua4f5\ua034\ua916\u7d36\u8e49\u247b\u8b39\u3479}\ua7f2\ua4f5\ua07e\ua913\u7d73\u8e58\u246d\u8b25\u347ef\ua7e3\ua4f5\ua034\ua916\u7d33\u8e59\u243a\u8b3e\u34792\ua7a3\ua4a6"), objectArray));
        }
        AnnotationNode annotationNode = Annotations.getVisible(mixinMethodNode, Unique.class);
        if (annotationNode == null || !Annotations.getValue(annotationNode, \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("a\ua7ef\ua4b9\ua074\ua90b\u7d62"), Boolean.FALSE).booleanValue()) {
            if (Bytecode.hasFlag(mixinMethodNode, 0x6B5D290C ^ 0x6B5D294C)) {
                try {
                    Bytecode.compareBridgeMethods(methodNode, mixinMethodNode);
                    Object[] objectArray = new Object[0x43560E0A ^ 0x43560E0E];
                    objectArray[0xE9CCE95A ^ 0xE9CCE95A] = string;
                    objectArray[0xF2E42A1 ^ 0xF2E42A0] = mixinMethodNode.name;
                    objectArray[0x550CD5AB ^ 0x550CD5A9] = this.mixin;
                    objectArray[0x984FF4F6 ^ 0x984FF4F5] = mixinTargetContext.getTarget();
                    logger.debug(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("V\ua7ef\ua4a6\ua072\ua904\u7d64\u8e4e\u2473\u8b39\u34702\ua7f5\ua4ac\ua065\ua90d\u7d73\u8e5e\u2473\u8b34\u3437p\ua7f4\ua4bc\ua075\ua902\u7d73\u8e0a\u2477\u8b32\u3463z\ua7e9\ua4b1\ua031\ua91e\u7d6b\u8e0a\u2473\u8b39\u3437i\ua7fb\ua4f5\ua073\ua900\u7d75\u8e4b\u246f\u8b24\u34722\ua7e3\ua4ad\ua078\ua916\u7d62\u8e43\u2474\u8b30\u3437\u007f\ua7e3\ua4a1\ua079\ua90a\u7d72\u8e0a\u2473\u8b39\u3437i\ua7fb\ua4f5\ua078\ua916\u7d36\u8e49\u2475\u8b3a\u3467s\ua7f2\ua4bc\ua073\ua909\u7d73"), objectArray);
                    return (0x3D9B9284 ^ 0x3D9B9285) != 0;
                }
                catch (SyntheticBridgeException syntheticBridgeException) {
                    if (this.verboseLogging || this.env.getOption(MixinEnvironment.Option.DEBUG_VERIFY)) {
                        syntheticBridgeException.printAnalysis(mixinTargetContext, methodNode, mixinMethodNode);
                    }
                    throw new InvalidMixinException((IMixinInfo)this.mixin, syntheticBridgeException.getMessage());
                }
            }
            Object[] objectArray = new Object[0x632D9E5C ^ 0x632D9E58];
            objectArray[0xD96A8531 ^ 0xD96A8531] = string;
            objectArray[0x2207A0C3 ^ 0x2207A0C2] = mixinMethodNode.name;
            objectArray[0xC4C6609C ^ 0xC4C6609E] = this.mixin;
            objectArray[0xC5686DE3 ^ 0xC5686DE0] = mixinTargetContext.getTarget();
            logger.warn(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("V\ua7ef\ua4a6\ua072\ua904\u7d64\u8e4e\u2473\u8b39\u34702\ua7fd\ua4a8\ua031\ua915\u7d63\u8e48\u2476\u8b3e\u34742\ua7eb\ua4b0\ua065\ua90d\u7d79\u8e4e\u243a\u8b2c\u346a2\ua7ef\ua4bb\ua031\ua91e\u7d6b\u8e0a\u2478\u8b32\u3474s\ua7f3\ua4a6\ua074\ua945\u7d7f\u8e5e\u243a\u8b36\u347b`\ua7e3\ua4b4\ua075\ua91c\u7d36\u8e4f\u2462\u8b3e\u3464f\ua7f5\ua4f5\ua078\ua90b\u7d36\u8e51\u2467"), objectArray);
            return (0xA198061 ^ 0xA198060) != 0;
        }
        mixinTargetContext.addMixinMethod(mixinMethodNode);
        return (0x33053123 ^ 0x33053122) != 0;
    }

    protected void attachMethod(MixinTargetContext mixinTargetContext, MixinInfo.MixinMethodNode mixinMethodNode) {
        MethodNode methodNode;
        ClassInfo.Method method = this.mixin.getClassInfo().findMethod(mixinMethodNode);
        if (method == null) {
            return;
        }
        ClassInfo.Method method2 = this.mixin.getClassInfo().findMethodInHierarchy(mixinMethodNode, ClassInfo.SearchType.SUPER_CLASSES_ONLY);
        if (method2 != null && method2.isRenamed()) {
            mixinMethodNode.name = method.renameTo(method2.getName());
        }
        if ((methodNode = mixinTargetContext.findMethod(mixinMethodNode, null)) != null) {
            this.conformVisibility(mixinTargetContext, mixinMethodNode, SpecialMethod.MERGE, methodNode);
        }
    }

    protected void attachFields(MixinTargetContext mixinTargetContext) {
        Iterator iterator = this.classNode.fields.iterator();
        while (iterator.hasNext()) {
            int n;
            FieldNode fieldNode = (FieldNode)iterator.next();
            AnnotationNode annotationNode = Annotations.getVisible(fieldNode, Shadow.class);
            int n2 = annotationNode != null ? 0x20AA3FEF ^ 0x20AA3FEE : (n = 0xBA0BB2A3 ^ 0xBA0BB2A3);
            if (!this.validateField(mixinTargetContext, fieldNode, annotationNode)) {
                iterator.remove();
                continue;
            }
            ClassInfo.Field field = this.mixin.getClassInfo().findField(fieldNode);
            mixinTargetContext.transformDescriptor(fieldNode);
            field.remapTo(fieldNode.desc);
            if (field.isUnique() && n != 0) {
                Object[] objectArray = new Object[0xCA7F6E26 ^ 0xCA7F6E27];
                objectArray[0x3F7FEAC8 ^ 0x3F7FEAC8] = fieldNode.name;
                throw new InvalidMixinException((IMixinInfo)this.mixin, String.format(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("R\ua7d5\ua4bd\ua070\ua901\u7d79\u8e5d\u243a\u8b31\u347ew\ua7ea\ua4b1\ua031\ua940\u7d65\u8e0a\u2479\u8b36\u3479|\ua7e9\ua4a1\ua031\ua907\u7d73\u8e0a\u245a\u8b02\u3479{\ua7f7\ua4a0\ua074"), objectArray));
            }
            FieldNode fieldNode2 = mixinTargetContext.findField(fieldNode, annotationNode);
            if (fieldNode2 == null) {
                if (annotationNode == null) continue;
                fieldNode2 = mixinTargetContext.findRemappedField(fieldNode);
                if (fieldNode2 == null) {
                    Object[] objectArray = new Object[0x62D82B1E ^ 0x62D82B1A];
                    objectArray[0x7708A88A ^ 0x7708A88A] = fieldNode.name;
                    objectArray[0x4FE3924 ^ 0x4FE3925] = mixinTargetContext.getTarget();
                    objectArray[0x6B485714 ^ 0x6B485716] = mixinTargetContext.getReferenceMapper().getStatus();
                    objectArray[0x7A184BCF ^ 0x7A184BCC] = MixinPreProcessorStandard.getDynamicInfo(fieldNode);
                    throw new InvalidMixinException((IMixinInfo)this.mixin, String.format(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("A\ua7ee\ua4b4\ua075\ua90a\u7d61\u8e0a\u247c\u8b3e\u3472~\ua7e2\ua4f5\ua034\ua916\u7d36\u8e5d\u247b\u8b24\u3437|\ua7e9\ua4a1\ua031\ua909\u7d79\u8e49\u247b\u8b23\u3472v\ua7a6\ua4bc\ua07f\ua945\u7d62\u8e42\u247f\u8b77\u3463s\ua7f4\ua4b2\ua074\ua911\u7d36\u8e49\u2476\u8b36\u3464a\ua7a6\ua4f0\ua062\ua94b\u7d36\u8e0f\u2469\u8b72\u3464"), objectArray));
                }
                fieldNode.name = field.renameTo(fieldNode2.name);
            }
            if (!Bytecode.compareFlags(fieldNode, fieldNode2, 0x5D1D432A ^ 0x5D1D4322)) {
                Object[] objectArray = new Object[0xA5B8E9C2 ^ 0xA5B8E9C0];
                objectArray[0x16CA1051 ^ 0x16CA1051] = fieldNode.name;
                objectArray[0x9A02FD9E ^ 0x9A02FD9F] = this.mixin;
                throw new InvalidMixinException((IMixinInfo)this.mixin, String.format(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("A\ua7d2\ua494\ua045\ua92c\u7d55\u8e0a\u2477\u8b38\u3473{\ua7e0\ua4bc\ua074\ua917\u7d36\u8e45\u247c\u8b77\u3457A\ua7ee\ua4b4\ua075\ua90a\u7d61\u8e0a\u247c\u8b3e\u3472~\ua7e2\ua4f5\ua034\ua916\u7d36\u8e43\u2474\u8b77\u3432a\ua7a6\ua4b1\ua07e\ua900\u7d65\u8e0a\u2474\u8b38\u34632\ua7eb\ua4b4\ua065\ua906\u7d7e\u8e0a\u246e\u8b3f\u34722\ua7f2\ua4b4\ua063\ua902\u7d73\u8e5e"), objectArray));
            }
            if (field.isUnique()) {
                if ((fieldNode.access & (0xBAB2B99C ^ 0xBAB2B99A)) != 0) {
                    String string = mixinTargetContext.getUniqueName(fieldNode);
                    Object[] objectArray = new Object[0x1B83C364 ^ 0x1B83C360];
                    objectArray[0xDCC9DF79 ^ 0xDCC9DF79] = fieldNode.name;
                    objectArray[0xE0F54A05 ^ 0xE0F54A04] = fieldNode.desc;
                    objectArray[0x21FFAD9E ^ 0x21FFAD9C] = string;
                    objectArray[0xBC1A940D ^ 0xBC1A940E] = this.mixin;
                    logger.log(this.mixin.getLoggingLevel(), \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("@\ua7e3\ua4bb\ua070\ua908\u7d7f\u8e44\u247d\u8b77\u3457G\ua7e8\ua4bc\ua060\ua910\u7d73\u8e0a\u247c\u8b3e\u3472~\ua7e2\ua4f5\ua06a\ua918\u7d6d\u8e57\u243a\u8b23\u34782\ua7fd\ua4a8\ua031\ua90c\u7d78\u8e0a\u2461\u8b2a"), objectArray);
                    fieldNode.name = field.renameTo(string);
                    continue;
                }
                if (this.strictUnique) {
                    Object[] objectArray = new Object[0x2B7D159E ^ 0x2B7D159B];
                    objectArray[0xC86454B8 ^ 0xC86454B8] = fieldNode.name;
                    objectArray[0xE0C46E83 ^ 0xE0C46E82] = this.mixin;
                    objectArray[0x50F5ECB1 ^ 0x50F5ECB3] = fieldNode2.name;
                    objectArray[0xBB0F6490 ^ 0xBB0F6493] = fieldNode2.desc;
                    objectArray[0x3DF2F7A6 ^ 0x3DF2F7A2] = mixinTargetContext.getTarget();
                    throw new InvalidMixinException((IMixinInfo)this.mixin, String.format(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("T\ua7ef\ua4b0\ua07d\ua901\u7d36\u8e49\u2475\u8b39\u3471~\ua7ef\ua4b6\ua065\ua949\u7d36\u8e6a\u244f\u8b39\u347ec\ua7f3\ua4b0\ua031\ua903\u7d7f\u8e4f\u2476\u8b33\u34377\ua7f5\ua4f5\ua078\ua90b\u7d36\u8e0f\u2469\u8b77\u3474s\ua7e8\ua4bb\ua07e\ua911\u7d36\u8e45\u246c\u8b32\u3465e\ua7f4\ua4bc\ua065\ua900\u7d36\u8e0f\u2469\u8b72\u34642\ua7ef\ua4bb\ua031\ua940\u7d65"), objectArray));
                }
                Object[] objectArray = new Object[0xE18466CB ^ 0xE18466C8];
                objectArray[0x681C0DFC ^ 0x681C0DFC] = fieldNode.name;
                objectArray[0x29DD6EA4 ^ 0x29DD6EA5] = this.mixin;
                objectArray[0x4DDD827D ^ 0x4DDD827F] = mixinTargetContext.getTarget();
                logger.warn(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("V\ua7ef\ua4a6\ua072\ua904\u7d64\u8e4e\u2473\u8b39\u34702\ua7c6\ua480\ua07f\ua90c\u7d67\u8e5f\u247f\u8b77\u3467g\ua7e4\ua4b9\ua078\ua906\u7d36\u8e4c\u2473\u8b32\u347bv\ua7a6\ua4ae\ua06c\ua945\u7d7f\u8e44\u243a\u8b2c\u346a2\ua7e4\ua4b0\ua072\ua904\u7d63\u8e59\u247f\u8b77\u347ef\ua7a6\ua4b4\ua07d\ua917\u7d73\u8e4b\u247e\u8b2e\u3437w\ua7fe\ua4bc\ua062\ua911\u7d65\u8e0a\u2473\u8b39\u3437i\ua7fb\ua4fb\ua031\ua92b\u7d79\u8e5e\u247f\u8b77\u3463z\ua7e7\ua4a1\ua031\ua901\u7d73\u8e49\u2476\u8b36\u3465w\ua7e2\ua4f5\ua057\ua92c\u7d53\u8e66\u245e\u8b77\u345e\\\ua7cf\ua481\ua058\ua924\u7d5a\u8e63\u2449\u8b12\u3445A\ua7a6\ua4a2\ua078\ua909\u7d7a\u8e0a\u2454\u8b18\u34432\ua7e4\ua4b0\ua031\ua917\u7d73\u8e47\u2475\u8b21\u3472v\ua7a7"), objectArray);
                iterator.remove();
                continue;
            }
            if (!fieldNode2.desc.equals(fieldNode.desc)) {
                Object[] objectArray = new Object[0x363307B8 ^ 0x363307B9];
                objectArray[0xBF7CD5D4 ^ 0xBF7CD5D4] = fieldNode.name;
                throw new InvalidMixinException((IMixinInfo)this.mixin, String.format(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("F\ua7ee\ua4b0\ua031\ua903\u7d7f\u8e4f\u2476\u8b33\u34377\ua7f5\ua4f5\ua078\ua90b\u7d36\u8e5e\u2472\u8b32\u3437f\ua7e7\ua4a7\ua076\ua900\u7d62\u8e0a\u2479\u8b3b\u3476a\ua7f5\ua4f5\ua079\ua904\u7d65\u8e0a\u247b\u8b77\u3474}\ua7e8\ua4b3\ua07d\ua90c\u7d75\u8e5e\u2473\u8b39\u34702\ua7f5\ua4bc\ua076\ua90b\u7d77\u8e5e\u246f\u8b25\u3472"), objectArray));
            }
            if (!fieldNode2.name.equals(fieldNode.name)) {
                if ((fieldNode2.access & (0xBA237907 ^ 0xBA237905)) == 0) {
                    if ((fieldNode2.access & (0x1957B750 ^ 0x1957A750)) == 0) {
                        throw new InvalidMixinException((IMixinInfo)this.mixin, \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("\\\ua7e9\ua4bb\ua03c\ua915\u7d64\u8e43\u246c\u8b36\u3463w\ua7a6\ua4b3\ua078\ua900\u7d7a\u8e4e\u243a\u8b34\u3476|\ua7e8\ua4ba\ua065\ua945\u7d74\u8e4f\u243a\u8b36\u347b{\ua7e7\ua4a6\ua074\ua901\u7d38\u8e0a\u245c\u8b38\u3462|\ua7e2\ua4f5") + fieldNode2.name);
                    }
                }
                fieldNode.name = field.renameTo(fieldNode2.name);
            }
            iterator.remove();
            if (n == 0) continue;
            boolean bl = field.isDecoratedFinal();
            if (this.verboseLogging) {
                if (Bytecode.hasFlag(fieldNode2, 0x66A9C297 ^ 0x66A9C287) != bl) {
                    String string = bl ? \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("R\ua7d5\ua4bd\ua070\ua901\u7d79\u8e5d\u243a\u8b31\u347ew\ua7ea\ua4b1\ua031\ua91e\u7d6b\u8e10\u2420\u8b2c\u346a2\ua7ef\ua4a6\ua031\ua901\u7d73\u8e49\u2475\u8b25\u3476f\ua7e3\ua4b1\ua031\ua912\u7d7f\u8e5e\u2472\u8b77\u3457T\ua7ef\ua4bb\ua070\ua909\u7d36\u8e48\u246f\u8b23\u3437f\ua7e7\ua4a7\ua076\ua900\u7d62\u8e0a\u2473\u8b24\u3437|\ua7e9\ua4a1\ua031\ua903\u7d7f\u8e44\u247b\u8b3b") : \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("R\ua7d5\ua4bd\ua070\ua901\u7d79\u8e5d\u243a\u8b23\u3476`\ua7e1\ua4b0\ua065\ua945\u7d6d\u8e57\u2420\u8b6d\u346co\ua7a6\ua4bc\ua062\ua945\u7d70\u8e43\u2474\u8b36\u347b2\ua7e4\ua4a0\ua065\ua945\u7d65\u8e42\u247b\u8b33\u3478e\ua7a6\ua4bc\ua062\ua945\u7d78\u8e45\u246e\u8b77\u3473w\ua7e5\ua4ba\ua063\ua904\u7d62\u8e4f\u247e\u8b77\u3460{\ua7f2\ua4bd\ua031\ua925\u7d50\u8e43\u2474\u8b36\u347b");
                    Object[] objectArray = new Object[0x723B6BD4 ^ 0x723B6BD6];
                    objectArray[0x30E6C6DF ^ 0x30E6C6DF] = this.mixin;
                    objectArray[0x5E64D10E ^ 0x5E64D10F] = fieldNode.name;
                    logger.warn(string, objectArray);
                }
            }
            mixinTargetContext.addShadowField(fieldNode, field);
        }
    }

    protected boolean validateField(MixinTargetContext mixinTargetContext, FieldNode fieldNode, AnnotationNode annotationNode) {
        String string;
        if (Bytecode.hasFlag(fieldNode, 0xF0FDD021 ^ 0xF0FDD029)) {
            if (!Bytecode.hasFlag(fieldNode, 0xA1534D88 ^ 0xA1534D8A)) {
                if (!Bytecode.hasFlag(fieldNode, 0x352421F2 ^ 0x352431F2) && annotationNode == null) {
                    Object[] objectArray = new Object[0xCC622D8A ^ 0xCC622D89];
                    objectArray[0xC7E740C2 ^ 0xC7E740C2] = mixinTargetContext;
                    objectArray[0xF2A75275 ^ 0xF2A75274] = fieldNode.name;
                    objectArray[0x9F4E9980 ^ 0x9F4E9982] = fieldNode.desc;
                    throw new InvalidMixinException((IMixinContext)mixinTargetContext, String.format(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("_\ua7ef\ua4ad\ua078\ua90b\u7d36\u8e0f\u2469\u8b77\u3474}\ua7e8\ua4a1\ua070\ua90c\u7d78\u8e59\u243a\u8b39\u3478|\ua7ab\ua4a5\ua063\ua90c\u7d60\u8e4b\u246e\u8b32\u3437a\ua7f2\ua4b4\ua065\ua90c\u7d75\u8e0a\u247c\u8b3e\u3472~\ua7e2\ua4f5\ua034\ua916\u7d2c\u8e0f\u2469"), objectArray));
                }
            }
        }
        if (fieldNode.name.startsWith(string = (String)Annotations.getValue(annotationNode, \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("b\ua7f4\ua4b0\ua077\ua90c\u7d6e"), Shadow.class))) {
            Object[] objectArray = new Object[0xAB3F6501 ^ 0xAB3F6503];
            objectArray[0x85F63D0 ^ 0x85F63D0] = mixinTargetContext;
            objectArray[0x7B9122E7 ^ 0x7B9122E6] = fieldNode.name;
            throw new InvalidMixinException((IMixinContext)mixinTargetContext, String.format(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("R\ua7d5\ua4bd\ua070\ua901\u7d79\u8e5d\u243a\u8b31\u347ew\ua7ea\ua4b1\ua031\ua940\u7d65\u8e04\u243f\u8b24\u3437z\ua7e7\ua4a6\ua031\ua904\u7d36\u8e59\u2472\u8b36\u3473}\ua7f1\ua4f5\ua061\ua917\u7d73\u8e4c\u2473\u8b2f\u34392\ua7d2\ua4bd\ua078\ua916\u7d36\u8e43\u2469\u8b77\u3479}\ua7f2\ua4f5\ua070\ua909\u7d7a\u8e45\u246d\u8b32\u3473<"), objectArray));
        }
        if (\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("a\ua7f3\ua4a5\ua074\ua917\u7d32").equals(fieldNode.name)) {
            if (fieldNode.access != (0x31B020D8 ^ 0x31B020DA)) {
                Object[] objectArray = new Object[0x553E9104 ^ 0x553E9106];
                objectArray[0xD68D6F3A ^ 0xD68D6F3A] = mixinTargetContext;
                objectArray[0x5CACBF9E ^ 0x5CACBF9F] = fieldNode.name;
                throw new InvalidMixinException((IMixinInfo)this.mixin, String.format(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("[\ua7eb\ua4b4\ua076\ua90c\u7d78\u8e4b\u2468\u8b2e\u3437a\ua7f3\ua4a5\ua074\ua917\u7d36\u8e4c\u2473\u8b32\u347bv\ua7a6\ua4f0\ua062\ua94b\u7d33\u8e59\u243a\u8b3a\u3462a\ua7f2\ua4f5\ua073\ua900\u7d36\u8e5a\u2468\u8b3e\u3461s\ua7f2\ua4b0\ua031\ua904\u7d78\u8e4e\u243a\u8b39\u3478|\ua7ab\ua4b3\ua078\ua90b\u7d77\u8e46"), objectArray));
            }
            if (!fieldNode.desc.equals(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("^") + this.mixin.getClassRef() + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20(")"))) {
                Object[] objectArray = new Object[0x5E1123B ^ 0x5E11238];
                objectArray[0xC16B1898 ^ 0xC16B1898] = mixinTargetContext;
                objectArray[0x4C9B2926 ^ 0x4C9B2927] = fieldNode.name;
                objectArray[0x879B0E7B ^ 0x879B0E79] = this.mixin.getClassName();
                throw new InvalidMixinException((IMixinInfo)this.mixin, String.format(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("[\ua7eb\ua4b4\ua076\ua90c\u7d78\u8e4b\u2468\u8b2e\u3437a\ua7f3\ua4a5\ua074\ua917\u7d36\u8e4c\u2473\u8b32\u347bv\ua7a6\ua4f0\ua062\ua94b\u7d33\u8e59\u243a\u8b3a\u3462a\ua7f2\ua4f5\ua079\ua904\u7d60\u8e4f\u243a\u8b23\u347fw\ua7a6\ua4a6\ua070\ua908\u7d73\u8e0a\u246e\u8b2e\u3467w\ua7a6\ua4b4\ua062\ua945\u7d62\u8e42\u247f\u8b77\u3467s\ua7f4\ua4b0\ua07f\ua911\u7d36\u8e47\u2473\u8b2f\u347e|\ua7a6\ua4fd\ua034\ua916\u7d3f"), objectArray));
            }
            return (0xAFE0AD0C ^ 0xAFE0AD0C) != 0;
        }
        return (0x85AA5A53 ^ 0x85AA5A52) != 0;
    }

    protected void transform(MixinTargetContext mixinTargetContext) {
        for (MethodNode methodNode : this.classNode.methods) {
            ListIterator<AbstractInsnNode> listIterator = methodNode.instructions.iterator();
            while (listIterator.hasNext()) {
                AbstractInsnNode abstractInsnNode = (AbstractInsnNode)listIterator.next();
                if (abstractInsnNode instanceof MethodInsnNode) {
                    this.transformMethod((MethodInsnNode)abstractInsnNode);
                    continue;
                }
                if (!(abstractInsnNode instanceof FieldInsnNode)) continue;
                this.transformField((FieldInsnNode)abstractInsnNode);
            }
        }
    }

    protected void transformMethod(MethodInsnNode methodInsnNode) {
        Profiler.Section section = this.profiler.begin(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("\u007f\ua7e3\ua4a1\ua070"));
        ClassInfo classInfo = ClassInfo.forName(methodInsnNode.owner);
        if (classInfo == null) {
            throw new RuntimeException(new ClassNotFoundException(methodInsnNode.owner.replace((char)(0x39C5468C ^ 0x39C546A3), (char)(0xA190B50D ^ 0xA190B523))));
        }
        ClassInfo.Method method = classInfo.findMethodInHierarchy(methodInsnNode, ClassInfo.SearchType.ALL_CLASSES, 0xB2DB3B66 ^ 0xB2DB3B64);
        section.end();
        if (method != null && method.isRenamed()) {
            methodInsnNode.name = method.getName();
        }
    }

    protected void transformField(FieldInsnNode fieldInsnNode) {
        Profiler.Section section = this.profiler.begin(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("\u007f\ua7e3\ua4a1\ua070"));
        ClassInfo classInfo = ClassInfo.forName(fieldInsnNode.owner);
        if (classInfo == null) {
            throw new RuntimeException(new ClassNotFoundException(fieldInsnNode.owner.replace((char)(0x7B24C167 ^ 0x7B24C148), (char)(0x32094FC7 ^ 0x32094FE9))));
        }
        ClassInfo.Field field = classInfo.findField(fieldInsnNode, 0xA1C97EF2 ^ 0xA1C97EF0);
        section.end();
        if (field != null && field.isRenamed()) {
            fieldInsnNode.name = field.getName();
        }
    }

    protected static String getDynamicInfo(MethodNode methodNode) {
        return MixinPreProcessorStandard.getDynamicInfo(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("_\ua7e3\ua4a1\ua079\ua90a\u7d72"), Annotations.getInvisible(methodNode, Dynamic.class));
    }

    protected static String getDynamicInfo(FieldNode fieldNode) {
        return MixinPreProcessorStandard.getDynamicInfo(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("T\ua7ef\ua4b0\ua07d\ua901"), Annotations.getInvisible(fieldNode, Dynamic.class));
    }

    private static String getDynamicInfo(String string, AnnotationNode annotationNode) {
        String string2;
        String string3 = Strings.nullToEmpty((String)((String)Annotations.getValue(annotationNode)));
        Type type = (Type)Annotations.getValue(annotationNode, \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("\u007f\ua7ef\ua4ad\ua078\ua90b"));
        if (type != null) {
            Object[] objectArray = new Object[0x255B2CAF ^ 0x255B2CAD];
            objectArray[0xB341F633 ^ 0xB341F633] = type.getClassName();
            objectArray[0x588C786 ^ 0x588C787] = string3;
            string3 = String.format(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("i\ua7a3\ua4a6\ua06c\ua945\u7d33\u8e59"), objectArray).trim();
        }
        if (string3.length() > 0) {
            Object[] objectArray = new Object[0x3B58B8BA ^ 0x3B58B8B8];
            objectArray[0x783A5597 ^ 0x783A5597] = string;
            objectArray[0x6CD4B945 ^ 0x6CD4B944] = string3;
            string2 = String.format(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2\ua7a3\ua4a6\ua031\ua90c\u7d65\u8e0a\u245a\u8b13\u346e|\ua7e7\ua4b8\ua078\ua906\u7d3e\u8e0f\u2469\u8b7e"), objectArray);
        } else {
            string2 = \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("");
        }
        return string2;
    }

    static final class SpecialMethod
    extends Enum<SpecialMethod> {
        public static final /* enum */ SpecialMethod MERGE = new SpecialMethod((0x74CE6293 ^ 0x74CE6292) != 0);
        public static final /* enum */ SpecialMethod OVERWRITE = new SpecialMethod((0xB9C6B76A ^ 0xB9C6B76B) != 0, Overwrite.class);
        public static final /* enum */ SpecialMethod SHADOW = new SpecialMethod((0xB2150AF8 ^ 0xB2150AF8) != 0, Shadow.class);
        public static final /* enum */ SpecialMethod ACCESSOR = new SpecialMethod((0x2288EA4 ^ 0x2288EA4) != 0, Accessor.class);
        public static final /* enum */ SpecialMethod INVOKER = new SpecialMethod((0x2D7911E9 ^ 0x2D7911E9) != 0, Invoker.class);
        final boolean isOverwrite;
        final Class<? extends Annotation> annotation;
        final String description;
        private static final /* synthetic */ SpecialMethod[] $VALUES;

        public static SpecialMethod[] values() {
            return (SpecialMethod[])$VALUES.clone();
        }

        public static SpecialMethod valueOf(String string) {
            return Enum.valueOf(SpecialMethod.class, string);
        }

        private SpecialMethod(boolean bl, Class<? extends Annotation> clazz) {
            this.isOverwrite = bl;
            this.annotation = clazz;
            this.description = \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("R") + Bytecode.getSimpleName(clazz);
        }

        private SpecialMethod(boolean bl) {
            this.isOverwrite = bl;
            this.annotation = null;
            this.description = \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("}\ua7f0\ua4b0\ua063\ua912\u7d64\u8e43\u246e\u8b32");
        }

        public String toString() {
            return this.description;
        }

        static {
            SpecialMethod[] specialMethodArray = new SpecialMethod[0xB94753E7 ^ 0xB94753E2];
            specialMethodArray[0x28864CDE ^ 0x28864CDE] = MERGE;
            specialMethodArray[0x682422A2 ^ 0x682422A3] = OVERWRITE;
            specialMethodArray[0x65877CC6 ^ 0x65877CC4] = SHADOW;
            specialMethodArray[0xBBD3E14F ^ 0xBBD3E14C] = ACCESSOR;
            specialMethodArray[0x2CDDBDE3 ^ 0x2CDDBDE7] = INVOKER;
            $VALUES = specialMethodArray;
        }
    }
}

