/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.lib.Handle;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.lib.tree.FieldInsnNode;
import org.spongepowered.asm.lib.tree.FieldNode;
import org.spongepowered.asm.lib.tree.InvokeDynamicInsnNode;
import org.spongepowered.asm.lib.tree.LdcInsnNode;
import org.spongepowered.asm.lib.tree.LocalVariableNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.lib.tree.TypeInsnNode;
import org.spongepowered.asm.lib.tree.VarInsnNode;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.SoftOverride;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.gen.AccessorInfo;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.injection.struct.InjectorGroupInfo;
import org.spongepowered.asm.mixin.injection.struct.Target;
import org.spongepowered.asm.mixin.injection.throwables.InjectionError;
import org.spongepowered.asm.mixin.injection.throwables.InjectionValidationException;
import org.spongepowered.asm.mixin.refmap.IMixinContext;
import org.spongepowered.asm.mixin.refmap.IReferenceMapper;
import org.spongepowered.asm.mixin.struct.MemberRef;
import org.spongepowered.asm.mixin.struct.SourceMap;
import org.spongepowered.asm.mixin.transformer.ClassContext;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import org.spongepowered.asm.mixin.transformer.InnerClassGenerator;
import org.spongepowered.asm.mixin.transformer.MixinInfo;
import org.spongepowered.asm.mixin.transformer.TargetClassContext;
import org.spongepowered.asm.mixin.transformer.ext.Extensions;
import org.spongepowered.asm.mixin.transformer.meta.MixinMerged;
import org.spongepowered.asm.mixin.transformer.throwables.InvalidMixinException;
import org.spongepowered.asm.mixin.transformer.throwables.MixinTransformerError;
import org.spongepowered.asm.obfuscation.RemapperChain;
import org.spongepowered.asm.util.Annotations;
import org.spongepowered.asm.util.Bytecode;
import org.spongepowered.asm.util.ClassSignature;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2;

public class MixinTargetContext
extends ClassContext
implements IMixinContext {
    private static final Logger logger = LogManager.getLogger((String)\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("\u007f\ua7ef\ua4ad\ua078\ua90b"));
    private final MixinInfo mixin;
    private final ClassNode classNode;
    private final TargetClassContext targetClass;
    private final String sessionId;
    private final ClassInfo targetClassInfo;
    private final BiMap<String, String> innerClasses = HashBiMap.create();
    private final List<MethodNode> shadowMethods = new ArrayList<MethodNode>();
    private final Map<FieldNode, ClassInfo.Field> shadowFields = new LinkedHashMap<FieldNode, ClassInfo.Field>();
    private final List<MethodNode> mergedMethods = new ArrayList<MethodNode>();
    private final InjectorGroupInfo.Map injectorGroups = new InjectorGroupInfo.Map();
    private final List<InjectionInfo> injectors = new ArrayList<InjectionInfo>();
    private final List<AccessorInfo> accessors = new ArrayList<AccessorInfo>();
    private final boolean inheritsFromMixin;
    private final boolean detachedSuper;
    private final SourceMap.File stratum;
    private int minRequiredClassVersion = MixinEnvironment.CompatibilityLevel.JAVA_6.classVersion();

    MixinTargetContext(MixinInfo mixinInfo, ClassNode classNode, TargetClassContext targetClassContext) {
        this.mixin = mixinInfo;
        this.classNode = classNode;
        this.targetClass = targetClassContext;
        this.targetClassInfo = ClassInfo.forName(this.getTarget().getClassRef());
        this.stratum = targetClassContext.getSourceMap().addFile(this.classNode);
        int n = mixinInfo.getClassInfo().hasMixinInHierarchy() || this.targetClassInfo.hasMixinTargetInHierarchy() ? 0x29E0FF62 ^ 0x29E0FF63 : (int)((this.inheritsFromMixin = 0xEFF01893 ^ 0xEFF01893) ? 1 : 0);
        this.detachedSuper = !this.classNode.superName.equals(this.getTarget().getClassNode().superName) ? 0xF0B8EA07 ^ 0xF0B8EA06 : 0xDF0AC344 ^ 0xDF0AC344;
        this.sessionId = targetClassContext.getSessionId();
        this.requireVersion(classNode.version);
        InnerClassGenerator innerClassGenerator = (InnerClassGenerator)targetClassContext.getExtensions().getGenerator(InnerClassGenerator.class);
        for (String string : this.mixin.getInnerClasses()) {
            this.innerClasses.put((Object)string, (Object)innerClassGenerator.registerInnerClass(this.mixin, string, this));
        }
    }

    void addShadowMethod(MethodNode methodNode) {
        this.shadowMethods.add(methodNode);
    }

    void addShadowField(FieldNode fieldNode, ClassInfo.Field field) {
        this.shadowFields.put(fieldNode, field);
    }

    void addAccessorMethod(MethodNode methodNode, Class<? extends Annotation> clazz) {
        this.accessors.add(AccessorInfo.of(this, methodNode, clazz));
    }

    void addMixinMethod(MethodNode methodNode) {
        Object[] objectArray = new Object[0x6B0216EC ^ 0x6B0216EE];
        objectArray[0x343B77AC ^ 0x343B77AC] = \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("\u007f\ua7ef\ua4ad\ua078\ua90b");
        objectArray[0x9586F754 ^ 0x9586F755] = this.getClassName();
        Annotations.setVisible(methodNode, MixinMerged.class, objectArray);
        this.getTarget().addMixinMethod(methodNode);
    }

    void methodMerged(MethodNode methodNode) {
        this.mergedMethods.add(methodNode);
        this.targetClassInfo.addMethod(methodNode);
        this.getTarget().methodMerged(methodNode);
        Object[] objectArray = new Object[0xF16FEB81 ^ 0xF16FEB87];
        objectArray[0x78C155B3 ^ 0x78C155B3] = \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("\u007f\ua7ef\ua4ad\ua078\ua90b");
        objectArray[0xAB52C2FF ^ 0xAB52C2FE] = this.getClassName();
        objectArray[0x3A2024C5 ^ 0x3A2024C7] = \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("b\ua7f4\ua4bc\ua07e\ua917\u7d7f\u8e5e\u2463");
        objectArray[0x5AC7BF46 ^ 0x5AC7BF45] = this.getPriority();
        objectArray[0xD4E56E7 ^ 0xD4E56E3] = \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("a\ua7e3\ua4a6\ua062\ua90c\u7d79\u8e44\u2453\u8b33");
        objectArray[0x9F35A47D ^ 0x9F35A478] = this.sessionId;
        Annotations.setVisible(methodNode, MixinMerged.class, objectArray);
    }

    public String toString() {
        return this.mixin.toString();
    }

    public MixinEnvironment getEnvironment() {
        return this.mixin.getParent().getEnvironment();
    }

    @Override
    public boolean getOption(MixinEnvironment.Option option) {
        return this.getEnvironment().getOption(option);
    }

    @Override
    public ClassNode getClassNode() {
        return this.classNode;
    }

    @Override
    public String getClassName() {
        return this.mixin.getClassName();
    }

    @Override
    public String getClassRef() {
        return this.mixin.getClassRef();
    }

    public TargetClassContext getTarget() {
        return this.targetClass;
    }

    @Override
    public String getTargetClassRef() {
        return this.getTarget().getClassRef();
    }

    public ClassNode getTargetClassNode() {
        return this.getTarget().getClassNode();
    }

    public ClassInfo getTargetClassInfo() {
        return this.targetClassInfo;
    }

    @Override
    protected ClassInfo getClassInfo() {
        return this.mixin.getClassInfo();
    }

    public ClassSignature getSignature() {
        return this.getClassInfo().getSignature();
    }

    public SourceMap.File getStratum() {
        return this.stratum;
    }

    public int getMinRequiredClassVersion() {
        return this.minRequiredClassVersion;
    }

    public int getDefaultRequiredInjections() {
        return this.mixin.getParent().getDefaultRequiredInjections();
    }

    public String getDefaultInjectorGroup() {
        return this.mixin.getParent().getDefaultInjectorGroup();
    }

    public int getMaxShiftByValue() {
        return this.mixin.getParent().getMaxShiftByValue();
    }

    public InjectorGroupInfo.Map getInjectorGroups() {
        return this.injectorGroups;
    }

    public boolean requireOverwriteAnnotations() {
        return this.mixin.getParent().requireOverwriteAnnotations();
    }

    public ClassInfo findRealType(ClassInfo classInfo) {
        if (classInfo == this.getClassInfo()) {
            return this.targetClassInfo;
        }
        ClassInfo classInfo2 = this.targetClassInfo.findCorrespondingType(classInfo);
        if (classInfo2 == null) {
            throw new InvalidMixinException((IMixinContext)this, \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("@\ua7e3\ua4a6\ua07e\ua909\u7d63\u8e5e\u2473\u8b38\u34792\ua7e3\ua4a7\ua063\ua90a\u7d64\u8e10\u243a\u8b22\u3479s\ua7e4\ua4b9\ua074\ua945\u7d62\u8e45\u243a\u8b31\u347e|\ua7e2\ua4f5\ua072\ua90a\u7d64\u8e58\u247f\u8b24\u3467}\ua7e8\ua4b1\ua078\ua90b\u7d71\u8e0a\u246e\u8b2e\u3467w\ua7a6\ua4b3\ua07e\ua917\u7d36") + classInfo + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2\ua7ef\ua4bb\ua031\ua90d\u7d7f\u8e4f\u2468\u8b36\u3465q\ua7ee\ua4ac\ua031\ua90a\u7d70\u8e0a") + this.targetClassInfo);
        }
        return classInfo2;
    }

    public void transformMethod(MethodNode methodNode) {
        this.validateMethod(methodNode);
        this.transformDescriptor(methodNode);
        this.transformLVT(methodNode);
        this.stratum.applyOffset(methodNode);
        AbstractInsnNode abstractInsnNode = null;
        ListIterator<AbstractInsnNode> listIterator = methodNode.instructions.iterator();
        while (listIterator.hasNext()) {
            AbstractInsnNode abstractInsnNode2 = (AbstractInsnNode)listIterator.next();
            if (abstractInsnNode2 instanceof MethodInsnNode) {
                this.transformMethodRef(methodNode, listIterator, new MemberRef.Method((MethodInsnNode)abstractInsnNode2));
            } else if (abstractInsnNode2 instanceof FieldInsnNode) {
                this.transformFieldRef(methodNode, listIterator, new MemberRef.Field((FieldInsnNode)abstractInsnNode2));
                this.checkFinal(methodNode, listIterator, (FieldInsnNode)abstractInsnNode2);
            } else if (abstractInsnNode2 instanceof TypeInsnNode) {
                this.transformTypeNode(methodNode, listIterator, (TypeInsnNode)abstractInsnNode2, abstractInsnNode);
            } else if (abstractInsnNode2 instanceof LdcInsnNode) {
                this.transformConstantNode(methodNode, listIterator, (LdcInsnNode)abstractInsnNode2);
            } else if (abstractInsnNode2 instanceof InvokeDynamicInsnNode) {
                this.transformInvokeDynamicNode(methodNode, listIterator, (InvokeDynamicInsnNode)abstractInsnNode2);
            }
            abstractInsnNode = abstractInsnNode2;
        }
    }

    private void validateMethod(MethodNode methodNode) {
        ClassInfo.Method method;
        if (!(Annotations.getInvisible(methodNode, SoftOverride.class) == null || (method = this.targetClassInfo.findMethodInHierarchy(methodNode.name, methodNode.desc, ClassInfo.SearchType.SUPER_CLASSES_ONLY, ClassInfo.Traversal.SUPER)) != null && method.isInjected())) {
            throw new InvalidMixinException((IMixinContext)this, \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("_\ua7ef\ua4ad\ua078\ua90b\u7d36\u8e47\u247f\u8b23\u347f}\ua7e2\ua4f5") + methodNode.name + methodNode.desc + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2\ua7ef\ua4a6\ua031\ua911\u7d77\u8e4d\u247d\u8b32\u34732\ua7f1\ua4bc\ua065\ua90d\u7d36\u8e6a\u2449\u8b38\u3471f\ua7c9\ua4a3\ua074\ua917\u7d64\u8e43\u247e\u8b32\u3437p\ua7f3\ua4a1\ua031\ua90b\u7d79\u8e0a\u246c\u8b36\u347b{\ua7e2\ua4f5\ua07c\ua900\u7d62\u8e42\u2475\u8b33\u3437e\ua7e7\ua4a6\ua031\ua903\u7d79\u8e5f\u2474\u8b33\u3437{\ua7e8\ua4f5\ua062\ua910\u7d66\u8e4f\u2468\u8b34\u347bs\ua7f5\ua4a6\ua074\ua916\u7d36\u8e45\u247c\u8b77") + this.getTarget().getClassName());
        }
    }

    private void transformLVT(MethodNode methodNode) {
        if (methodNode.localVariables == null) {
            return;
        }
        for (LocalVariableNode localVariableNode : methodNode.localVariables) {
            if (localVariableNode == null || localVariableNode.desc == null) continue;
            localVariableNode.desc = this.transformSingleDescriptor(Type.getType(localVariableNode.desc));
        }
    }

    private void transformMethodRef(MethodNode methodNode, Iterator<AbstractInsnNode> iterator, MemberRef memberRef) {
        this.transformDescriptor(memberRef);
        if (memberRef.getOwner().equals(this.getClassRef())) {
            memberRef.setOwner(this.getTarget().getClassRef());
            ClassInfo.Method method = this.getClassInfo().findMethod(memberRef.getName(), memberRef.getDesc(), 0x7B4F59F9 ^ 0x7B4F59F3);
            if (method != null && method.isRenamed() && method.getOriginalName().equals(memberRef.getName()) && method.isSynthetic()) {
                memberRef.setName(method.getName());
            }
            this.upgradeMethodRef(methodNode, memberRef, method);
        } else if (this.innerClasses.containsKey((Object)memberRef.getOwner())) {
            memberRef.setOwner((String)this.innerClasses.get((Object)memberRef.getOwner()));
            memberRef.setDesc(this.transformMethodDescriptor(memberRef.getDesc()));
        } else if (this.detachedSuper || this.inheritsFromMixin) {
            if (memberRef.getOpcode() == (0x5A86FDC4 ^ 0x5A86FD73)) {
                this.updateStaticBinding(methodNode, memberRef);
            } else if (memberRef.getOpcode() == (0xC8408557 ^ 0xC84085E1) && ClassInfo.forName(memberRef.getOwner()).isMixin()) {
                this.updateDynamicBinding(methodNode, memberRef);
            }
        }
    }

    private void transformFieldRef(MethodNode methodNode, Iterator<AbstractInsnNode> iterator, MemberRef memberRef) {
        if (\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("a\ua7f3\ua4a5\ua074\ua917\u7d32").equals(memberRef.getName())) {
            if (memberRef instanceof MemberRef.Field) {
                this.processImaginarySuper(methodNode, ((MemberRef.Field)memberRef).insn);
                iterator.remove();
            } else {
                throw new InvalidMixinException((IMixinInfo)this.mixin, \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("Q\ua7e7\ua4bb\ua07f\ua90a\u7d62\u8e0a\u2479\u8b36\u347b~\ua7a6\ua4bc\ua07c\ua904\u7d71\u8e43\u2474\u8b36\u3465k\ua7a6\ua4a6\ua064\ua915\u7d73\u8e58\u243a\u8b31\u3465}\ua7eb\ua4f5\ua07c\ua900\u7d62\u8e42\u2475\u8b33\u3437z\ua7e7\ua4bb\ua075\ua909\u7d73\u8e04"));
            }
        }
        this.transformDescriptor(memberRef);
        if (memberRef.getOwner().equals(this.getClassRef())) {
            memberRef.setOwner(this.getTarget().getClassRef());
            ClassInfo.Field field = this.getClassInfo().findField(memberRef.getName(), memberRef.getDesc(), 0x651F6320 ^ 0x651F632A);
            if (field != null && field.isRenamed() && field.getOriginalName().equals(memberRef.getName()) && field.isStatic()) {
                memberRef.setName(field.getName());
            }
        } else {
            ClassInfo classInfo = ClassInfo.forName(memberRef.getOwner());
            if (classInfo.isMixin()) {
                ClassInfo classInfo2 = this.targetClassInfo.findCorrespondingType(classInfo);
                memberRef.setOwner(classInfo2 != null ? classInfo2.getName() : this.getTarget().getClassRef());
            }
        }
    }

    private void checkFinal(MethodNode methodNode, Iterator<AbstractInsnNode> iterator, FieldInsnNode fieldInsnNode) {
        block14: {
            block13: {
                if (!fieldInsnNode.owner.equals(this.getTarget().getClassRef())) {
                    return;
                }
                int n = fieldInsnNode.getOpcode();
                if (n == (0xECE13C26 ^ 0xECE13C92)) break block13;
                if (n != (0x14AEDDBF ^ 0x14AEDD0D)) break block14;
            }
            return;
        }
        for (Map.Entry<FieldNode, ClassInfo.Field> entry : this.shadowFields.entrySet()) {
            FieldNode fieldNode = entry.getKey();
            if (!fieldNode.desc.equals(fieldInsnNode.desc) || !fieldNode.name.equals(fieldInsnNode.name)) continue;
            ClassInfo.Field field = entry.getValue();
            if (field.isDecoratedFinal()) {
                if (field.isDecoratedMutable()) {
                    if (this.mixin.getParent().getEnvironment().getOption(MixinEnvironment.Option.DEBUG_VERBOSE)) {
                        Object[] objectArray = new Object[0xFB3724AA ^ 0xFB3724A9];
                        objectArray[0xBD795AF5 ^ 0xBD795AF5] = field;
                        objectArray[0xC0C9E98C ^ 0xC0C9E98D] = this.mixin;
                        objectArray[0x5605FED9 ^ 0x5605FEDB] = methodNode.name;
                        logger.warn(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("E\ua7f4\ua4bc\ua065\ua900\u7d36\u8e4b\u2479\u8b34\u3472a\ua7f5\ua4f5\ua065\ua90a\u7d36\u8e6a\u2457\u8b22\u3463s\ua7e4\ua4b9\ua074\ua945\u7d56\u8e6c\u2473\u8b39\u3476~\ua7a6\ua4b3\ua078\ua900\u7d7a\u8e4e\u243a\u8b2c\u346a2\ua7ef\ua4bb\ua031\ua91e\u7d6b\u8e10\u2420\u8b2c\u346a"), objectArray);
                    }
                } else if (\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20(".\ua7ef\ua4bb\ua078\ua911\u7d28").equals(methodNode.name) || \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20(".\ua7e5\ua4b9\ua078\ua90b\u7d7f\u8e5e\u2424").equals(methodNode.name)) {
                    Object[] objectArray = new Object[0x63DBAB7F ^ 0x63DBAB7D];
                    objectArray[0xE3A2AD7E ^ 0xE3A2AD7E] = field;
                    objectArray[0x6C68C0CE ^ 0x6C68C0CF] = this.mixin;
                    logger.warn(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("R\ua7c0\ua4bc\ua07f\ua904\u7d7a\u8e0a\u247c\u8b3e\u3472~\ua7e2\ua4f5\ua06a\ua918\u7d36\u8e43\u2474\u8b77\u346co\ua7a6\ua4a6\ua079\ua90a\u7d63\u8e46\u247e\u8b77\u3475w\ua7a6\ua4b3\ua078\ua90b\u7d77\u8e46"), objectArray);
                } else {
                    Object[] objectArray = new Object[0x44BD94C6 ^ 0x44BD94C5];
                    objectArray[0x5FEC1D82 ^ 0x5FEC1D82] = field;
                    objectArray[0x5877FCB7 ^ 0x5877FCB6] = this.mixin;
                    objectArray[0x2B0D4067 ^ 0x2B0D4065] = methodNode.name;
                    logger.error(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("E\ua7f4\ua4bc\ua065\ua900\u7d36\u8e4b\u2479\u8b34\u3472a\ua7f5\ua4f5\ua075\ua900\u7d62\u8e4f\u2479\u8b23\u3472v\ua7a6\ua4a1\ua07e\ua945\u7d56\u8e6c\u2473\u8b39\u3476~\ua7a6\ua4b3\ua078\ua900\u7d7a\u8e4e\u243a\u8b2c\u346a2\ua7ef\ua4bb\ua031\ua91e\u7d6b\u8e10\u2420\u8b2c\u346a"), objectArray);
                    if (this.mixin.getParent().getEnvironment().getOption(MixinEnvironment.Option.DEBUG_VERIFY)) {
                        throw new InvalidMixinException((IMixinInfo)this.mixin, \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("E\ua7f4\ua4bc\ua065\ua900\u7d36\u8e4b\u2479\u8b34\u3472a\ua7f5\ua4f5\ua075\ua900\u7d62\u8e4f\u2479\u8b23\u3472v\ua7a6\ua4a1\ua07e\ua945\u7d56\u8e6c\u2473\u8b39\u3476~\ua7a6\ua4b3\ua078\ua900\u7d7a\u8e4e\u243a") + field + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2\ua7ef\ua4bb\ua031") + this.mixin + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("(\ua7bc") + methodNode.name);
                    }
                }
            }
            return;
        }
    }

    private void transformTypeNode(MethodNode methodNode, Iterator<AbstractInsnNode> iterator, TypeInsnNode typeInsnNode, AbstractInsnNode abstractInsnNode) {
        if (typeInsnNode.getOpcode() == (0x444AF650 ^ 0x444AF690) && typeInsnNode.desc.equals(this.getTarget().getClassRef())) {
            if (abstractInsnNode.getOpcode() == (0xBBA044E5 ^ 0xBBA044FC) && ((VarInsnNode)abstractInsnNode).var == 0) {
                iterator.remove();
                return;
            }
        }
        if (typeInsnNode.desc.equals(this.getClassRef())) {
            typeInsnNode.desc = this.getTarget().getClassRef();
        } else {
            String string = (String)this.innerClasses.get((Object)typeInsnNode.desc);
            if (string != null) {
                typeInsnNode.desc = string;
            }
        }
        this.transformDescriptor(typeInsnNode);
    }

    private void transformConstantNode(MethodNode methodNode, Iterator<AbstractInsnNode> iterator, LdcInsnNode ldcInsnNode) {
        ldcInsnNode.cst = this.transformConstant(methodNode, iterator, ldcInsnNode.cst);
    }

    private void transformInvokeDynamicNode(MethodNode methodNode, Iterator<AbstractInsnNode> iterator, InvokeDynamicInsnNode invokeDynamicInsnNode) {
        this.requireVersion(0x3A1FFDDE ^ 0x3A1FFDED);
        invokeDynamicInsnNode.desc = this.transformMethodDescriptor(invokeDynamicInsnNode.desc);
        invokeDynamicInsnNode.bsm = this.transformHandle(methodNode, iterator, invokeDynamicInsnNode.bsm);
        for (int i = 0xA30FA9EB ^ 0xA30FA9EB; i < invokeDynamicInsnNode.bsmArgs.length; ++i) {
            invokeDynamicInsnNode.bsmArgs[i] = this.transformConstant(methodNode, iterator, invokeDynamicInsnNode.bsmArgs[i]);
        }
    }

    private Object transformConstant(MethodNode methodNode, Iterator<AbstractInsnNode> iterator, Object object) {
        if (object instanceof Type) {
            Type type = (Type)object;
            String string = this.transformDescriptor(type);
            if (!type.toString().equals(string)) {
                return Type.getType(string);
            }
            return object;
        }
        if (object instanceof Handle) {
            return this.transformHandle(methodNode, iterator, (Handle)object);
        }
        return object;
    }

    private Handle transformHandle(MethodNode methodNode, Iterator<AbstractInsnNode> iterator, Handle handle) {
        MemberRef.Handle handle2 = new MemberRef.Handle(handle);
        if (handle2.isField()) {
            this.transformFieldRef(methodNode, iterator, handle2);
        } else {
            this.transformMethodRef(methodNode, iterator, handle2);
        }
        return handle2.getMethodHandle();
    }

    private void processImaginarySuper(MethodNode methodNode, FieldInsnNode fieldInsnNode) {
        block8: {
            block7: {
                if (fieldInsnNode.getOpcode() != (0x3F8A60F2 ^ 0x3F8A6046)) {
                    if (\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20(".\ua7ef\ua4bb\ua078\ua911\u7d28").equals(methodNode.name)) {
                        throw new InvalidMixinException((IMixinContext)this, \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("[\ua7ea\ua4b9\ua074\ua902\u7d77\u8e46\u243a\u8b3e\u347as\ua7e1\ua4bc\ua07f\ua904\u7d64\u8e53\u243a\u8b24\u3462b\ua7e3\ua4a7\ua031\ua901\u7d73\u8e49\u2476\u8b36\u3465s\ua7f2\ua4bc\ua07e\ua90b\u7d2c\u8e0a\u247c\u8b3e\u3472~\ua7e2\ua4f5") + fieldInsnNode.name + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2\ua7eb\ua4a0\ua062\ua911\u7d36\u8e44\u2475\u8b23\u3437a\ua7f6\ua4b0\ua072\ua90c\u7d70\u8e53\u243a\u8b36\u34792\ua7ef\ua4bb\ua078\ua911\u7d7f\u8e4b\u2476\u8b3e\u3464w\ua7f4"));
                    }
                    throw new InvalidMixinException((IMixinContext)this, \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("[\ua7ea\ua4b9\ua074\ua902\u7d77\u8e46\u243a\u8b3e\u347as\ua7e1\ua4bc\ua07f\ua904\u7d64\u8e53\u243a\u8b24\u3462b\ua7e3\ua4a7\ua031\ua904\u7d75\u8e49\u247f\u8b24\u3464(\ua7a6\ua4b3\ua07e\ua910\u7d78\u8e4e\u243a") + Bytecode.getOpcodeName(fieldInsnNode.getOpcode()) + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2\ua7e9\ua4a5\ua072\ua90a\u7d72\u8e4f\u243a\u8b3e\u34792") + methodNode.name + methodNode.desc);
                }
                if ((methodNode.access & (0x4F35EFF ^ 0x4F35EFD)) != 0) break block7;
                if ((methodNode.access & (0xBC4FA4D6 ^ 0xBC4FA4DE)) == 0) break block8;
            }
            throw new InvalidMixinException((IMixinContext)this, \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("[\ua7ea\ua4b9\ua074\ua902\u7d77\u8e46\u243a\u8b3e\u347as\ua7e1\ua4bc\ua07f\ua904\u7d64\u8e53\u243a\u8b24\u3462b\ua7e3\ua4a7\ua031\ua904\u7d75\u8e49\u247f\u8b24\u3464(\ua7a6\ua4b8\ua074\ua911\u7d7e\u8e45\u247e\u8b77") + methodNode.name + methodNode.desc + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2\ua7ef\ua4a6\ua031\ua915\u7d64\u8e43\u246c\u8b36\u3463w\ua7a6\ua4ba\ua063\ua945\u7d65\u8e5e\u247b\u8b23\u347eq"));
        }
        if (Annotations.getInvisible(methodNode, SoftOverride.class) == null) {
            throw new InvalidMixinException((IMixinContext)this, \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("[\ua7ea\ua4b9\ua074\ua902\u7d77\u8e46\u243a\u8b3e\u347as\ua7e1\ua4bc\ua07f\ua904\u7d64\u8e53\u243a\u8b24\u3462b\ua7e3\ua4a7\ua031\ua904\u7d75\u8e49\u247f\u8b24\u3464(\ua7a6\ua4b8\ua074\ua911\u7d7e\u8e45\u247e\u8b77") + methodNode.name + methodNode.desc + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2\ua7ef\ua4a6\ua031\ua90b\u7d79\u8e5e\u243a\u8b33\u3472q\ua7e9\ua4a7\ua070\ua911\u7d73\u8e4e\u243a\u8b20\u347ef\ua7ee\ua4f5\ua051\ua936\u7d79\u8e4c\u246e\u8b18\u3461w\ua7f4\ua4a7\ua078\ua901\u7d73"));
        }
        ListIterator<AbstractInsnNode> listIterator = methodNode.instructions.iterator(methodNode.instructions.indexOf(fieldInsnNode));
        while (listIterator.hasNext()) {
            AbstractInsnNode abstractInsnNode = (AbstractInsnNode)listIterator.next();
            if (!(abstractInsnNode instanceof MethodInsnNode)) continue;
            MethodInsnNode methodInsnNode = (MethodInsnNode)abstractInsnNode;
            if (!methodInsnNode.owner.equals(this.getClassRef()) || !methodInsnNode.name.equals(methodNode.name) || !methodInsnNode.desc.equals(methodNode.desc)) continue;
            methodInsnNode.setOpcode(0x726E160C ^ 0x726E16BB);
            this.updateStaticBinding(methodNode, new MemberRef.Method(methodInsnNode));
            return;
        }
        throw new InvalidMixinException((IMixinContext)this, \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("[\ua7ea\ua4b9\ua074\ua902\u7d77\u8e46\u243a\u8b3e\u347as\ua7e1\ua4bc\ua07f\ua904\u7d64\u8e53\u243a\u8b24\u3462b\ua7e3\ua4a7\ua031\ua904\u7d75\u8e49\u247f\u8b24\u3464(\ua7a6\ua4b6\ua07e\ua910\u7d7a\u8e4e\u243a\u8b39\u3478f\ua7a6\ua4b3\ua078\ua90b\u7d72\u8e0a\u2453\u8b19\u3441]\ua7cd\ua490\ua031\ua903\u7d79\u8e58\u243a") + methodNode.name + methodNode.desc);
    }

    private void updateStaticBinding(MethodNode methodNode, MemberRef memberRef) {
        this.updateBinding(methodNode, memberRef, ClassInfo.Traversal.SUPER);
    }

    private void updateDynamicBinding(MethodNode methodNode, MemberRef memberRef) {
        this.updateBinding(methodNode, memberRef, ClassInfo.Traversal.ALL);
    }

    private void updateBinding(MethodNode methodNode, MemberRef memberRef, ClassInfo.Traversal traversal) {
        if (\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20(".\ua7ef\ua4bb\ua078\ua911\u7d28").equals(methodNode.name) || memberRef.getOwner().equals(this.getTarget().getClassRef()) || this.getTarget().getClassRef().startsWith(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("."))) {
            return;
        }
        ClassInfo.Method method = this.targetClassInfo.findMethodInHierarchy(memberRef.getName(), memberRef.getDesc(), traversal.getSearchType(), traversal);
        if (method != null) {
            if (method.getOwner().isMixin()) {
                throw new InvalidMixinException((IMixinContext)this, \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a") + memberRef + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2\ua7ef\ua4bb\ua031") + this + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2\ua7f4\ua4b0\ua062\ua90a\u7d7a\u8e5c\u247f\u8b33\u3437") + method.getOwner() + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2\ua7e4\ua4a0\ua065\ua945\u7d7f\u8e59\u243a\u8b3a\u347ej\ua7ef\ua4bb\ua03f"));
            }
            memberRef.setOwner(method.getImplementor().getName());
        } else if (ClassInfo.forName(memberRef.getOwner()).isMixin()) {
            throw new MixinTransformerError(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("W\ua7f4\ua4a7\ua07e\ua917\u7d36\u8e58\u247f\u8b24\u3478~\ua7f0\ua4bc\ua07f\ua902\u7d36") + memberRef + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2\ua7ef\ua4bb\ua031") + this);
        }
    }

    public void transformDescriptor(FieldNode fieldNode) {
        if (!this.inheritsFromMixin && this.innerClasses.size() == 0) {
            return;
        }
        fieldNode.desc = this.transformSingleDescriptor(fieldNode.desc, (0x3722B30 ^ 0x3722B30) != 0);
    }

    public void transformDescriptor(MethodNode methodNode) {
        if (!this.inheritsFromMixin && this.innerClasses.size() == 0) {
            return;
        }
        methodNode.desc = this.transformMethodDescriptor(methodNode.desc);
    }

    public void transformDescriptor(MemberRef memberRef) {
        if (!this.inheritsFromMixin && this.innerClasses.size() == 0) {
            return;
        }
        if (memberRef.isField()) {
            memberRef.setDesc(this.transformSingleDescriptor(memberRef.getDesc(), (0x13112818 ^ 0x13112818) != 0));
        } else {
            memberRef.setDesc(this.transformMethodDescriptor(memberRef.getDesc()));
        }
    }

    public void transformDescriptor(TypeInsnNode typeInsnNode) {
        if (!this.inheritsFromMixin && this.innerClasses.size() == 0) {
            return;
        }
        typeInsnNode.desc = this.transformSingleDescriptor(typeInsnNode.desc, (0x9A71057B ^ 0x9A71057A) != 0);
    }

    private String transformDescriptor(Type type) {
        if (type.getSort() == (0xD5E025EB ^ 0xD5E025E0)) {
            return this.transformMethodDescriptor(type.getDescriptor());
        }
        return this.transformSingleDescriptor(type);
    }

    private String transformSingleDescriptor(Type type) {
        if (type.getSort() < (0x11AEE16 ^ 0x11AEE1F)) {
            return type.toString();
        }
        return this.transformSingleDescriptor(type.toString(), (0xD7DA6029 ^ 0xD7DA6029) != 0);
    }

    private String transformSingleDescriptor(String string, boolean bl) {
        int n;
        String string2 = string;
        while (string2.startsWith(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("I")) || string2.startsWith(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("^"))) {
            if (string2.startsWith(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("I"))) {
                string2 = string2.substring(0xA1C38284 ^ 0xA1C38285);
                continue;
            }
            string2 = string2.substring(0x541B60EB ^ 0x541B60EA, string2.indexOf(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20(")")));
            n = 0xA544353C ^ 0xA544353D;
        }
        if (n == 0) {
            return string;
        }
        String string3 = (String)this.innerClasses.get((Object)string2);
        if (string3 != null) {
            return string.replace(string2, string3);
        }
        if (this.innerClasses.inverse().containsKey((Object)string2)) {
            return string;
        }
        ClassInfo classInfo = ClassInfo.forName(string2);
        if (!classInfo.isMixin()) {
            return string;
        }
        return string.replace(string2, this.findRealType(classInfo).toString());
    }

    private String transformMethodDescriptor(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((char)(0xA9CEEE9B ^ 0xA9CEEEB3));
        Type[] typeArray = Type.getArgumentTypes(string);
        int n = typeArray.length;
        for (int i = 0xC1067248 ^ 0xC1067248; i < n; ++i) {
            Type type = typeArray[i];
            stringBuilder.append(this.transformSingleDescriptor(type));
        }
        return stringBuilder.append((char)(0x1C9D882E ^ 0x1C9D8807)).append(this.transformSingleDescriptor(Type.getReturnType(string))).toString();
    }

    @Override
    public Target getTargetMethod(MethodNode methodNode) {
        return this.getTarget().getTargetMethod(methodNode);
    }

    MethodNode findMethod(MethodNode methodNode, AnnotationNode annotationNode) {
        List list;
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add(methodNode.name);
        if (annotationNode != null && (list = (List)Annotations.getValue(annotationNode, \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("s\ua7ea\ua4bc\ua070\ua916\u7d73\u8e59"))) != null) {
            linkedList.addAll(list);
        }
        return this.getTarget().findMethod(linkedList, methodNode.desc);
    }

    MethodNode findRemappedMethod(MethodNode methodNode) {
        RemapperChain remapperChain = this.getEnvironment().getRemappers();
        String string = remapperChain.mapMethodName(this.getTarget().getClassRef(), methodNode.name, methodNode.desc);
        if (string.equals(methodNode.name)) {
            return null;
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add(string);
        return this.getTarget().findAliasedMethod(linkedList, methodNode.desc);
    }

    FieldNode findField(FieldNode fieldNode, AnnotationNode annotationNode) {
        List list;
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add(fieldNode.name);
        if (annotationNode != null && (list = (List)Annotations.getValue(annotationNode, \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("s\ua7ea\ua4bc\ua070\ua916\u7d73\u8e59"))) != null) {
            linkedList.addAll(list);
        }
        return this.getTarget().findAliasedField(linkedList, fieldNode.desc);
    }

    FieldNode findRemappedField(FieldNode fieldNode) {
        RemapperChain remapperChain = this.getEnvironment().getRemappers();
        String string = remapperChain.mapFieldName(this.getTarget().getClassRef(), fieldNode.name, fieldNode.desc);
        if (string.equals(fieldNode.name)) {
            return null;
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add(string);
        return this.getTarget().findAliasedField(linkedList, fieldNode.desc);
    }

    protected void requireVersion(int n) {
        this.minRequiredClassVersion = Math.max(this.minRequiredClassVersion, n);
        if (n > MixinEnvironment.getCompatibilityLevel().classVersion()) {
            throw new InvalidMixinException((IMixinContext)this, \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("G\ua7e8\ua4a6\ua064\ua915\u7d66\u8e45\u2468\u8b23\u3472v\ua7a6\ua4b8\ua078\ua91d\u7d7f\u8e44\u243a\u8b34\u347bs\ua7f5\ua4a6\ua031\ua913\u7d73\u8e58\u2469\u8b3e\u3478|\ua7a6") + n);
        }
    }

    @Override
    public Extensions getExtensions() {
        return this.targetClass.getExtensions();
    }

    @Override
    public IMixinInfo getMixin() {
        return this.mixin;
    }

    MixinInfo getInfo() {
        return this.mixin;
    }

    @Override
    public int getPriority() {
        return this.mixin.getPriority();
    }

    public Set<String> getInterfaces() {
        return this.mixin.getInterfaces();
    }

    public Collection<MethodNode> getShadowMethods() {
        return this.shadowMethods;
    }

    public List<MethodNode> getMethods() {
        return this.classNode.methods;
    }

    public Set<Map.Entry<FieldNode, ClassInfo.Field>> getShadowFields() {
        return this.shadowFields.entrySet();
    }

    public List<FieldNode> getFields() {
        return this.classNode.fields;
    }

    public Level getLoggingLevel() {
        return this.mixin.getLoggingLevel();
    }

    public boolean shouldSetSourceFile() {
        return this.mixin.getParent().shouldSetSourceFile();
    }

    public String getSourceFile() {
        return this.classNode.sourceFile;
    }

    @Override
    public IReferenceMapper getReferenceMapper() {
        return this.mixin.getParent().getReferenceMapper();
    }

    public void preApply(String string, ClassNode classNode) {
        this.mixin.preApply(string, classNode);
    }

    public void postApply(String string, ClassNode classNode) {
        try {
            this.injectorGroups.validateAll();
        }
        catch (InjectionValidationException injectionValidationException) {
            InjectorGroupInfo injectorGroupInfo = injectionValidationException.getGroup();
            Object[] objectArray = new Object[0x69557146 ^ 0x69557145];
            objectArray[0xEBE2D257 ^ 0xEBE2D257] = injectorGroupInfo;
            objectArray[0x8AE5A63F ^ 0x8AE5A63E] = this.mixin;
            objectArray[0xA6DE3AC3 ^ 0xA6DE3AC1] = injectionValidationException.getMessage();
            throw new InjectionError(String.format(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("Q\ua7f4\ua4bc\ua065\ua90c\u7d75\u8e4b\u2476\u8b77\u347e|\ua7ec\ua4b0\ua072\ua911\u7d7f\u8e45\u2474\u8b77\u3471s\ua7ef\ua4b9\ua064\ua917\u7d73\u8e10\u243a\u8b14\u3476~\ua7ea\ua4b7\ua070\ua906\u7d7d\u8e0a\u247d\u8b25\u3478g\ua7f6\ua4f5\ua034\ua916\u7d36\u8e43\u2474\u8b77\u3432a\ua7a6\ua4b3\ua070\ua90c\u7d7a\u8e4f\u247e\u8b77\u347e|\ua7ec\ua4b0\ua072\ua911\u7d7f\u8e45\u2474\u8b77\u3474z\ua7e3\ua4b6\ua07a\ua95f\u7d36\u8e0f\u2469"), objectArray));
        }
        this.mixin.postApply(string, classNode);
    }

    public String getUniqueName(MethodNode methodNode, boolean bl) {
        return this.getTarget().getUniqueName(methodNode, bl);
    }

    public String getUniqueName(FieldNode fieldNode) {
        return this.getTarget().getUniqueName(fieldNode);
    }

    public void prepareInjections() {
        this.injectors.clear();
        for (MethodNode methodNode : this.mergedMethods) {
            InjectionInfo injectionInfo = InjectionInfo.parse(this, methodNode);
            if (injectionInfo == null) continue;
            if (injectionInfo.isValid()) {
                injectionInfo.prepare();
                this.injectors.add(injectionInfo);
            }
            methodNode.visibleAnnotations.remove(injectionInfo.getAnnotation());
        }
    }

    public void applyInjections() {
        for (InjectionInfo injectionInfo : this.injectors) {
            injectionInfo.inject();
        }
        for (InjectionInfo injectionInfo : this.injectors) {
            injectionInfo.postInject();
        }
        this.injectors.clear();
    }

    public List<MethodNode> generateAccessors() {
        for (AccessorInfo object : this.accessors) {
            object.locate();
        }
        ArrayList arrayList = new ArrayList();
        for (AccessorInfo accessorInfo : this.accessors) {
            MethodNode methodNode = accessorInfo.generate();
            this.getTarget().addMixinMethod(methodNode);
            arrayList.add(methodNode);
        }
        return arrayList;
    }
}

