/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer;

import java.io.OutputStream;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.lib.tree.FieldNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.mixin.Debug;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.injection.struct.Target;
import org.spongepowered.asm.mixin.struct.SourceMap;
import org.spongepowered.asm.mixin.transformer.ClassContext;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import org.spongepowered.asm.mixin.transformer.MixinApplicatorInterface;
import org.spongepowered.asm.mixin.transformer.MixinApplicatorStandard;
import org.spongepowered.asm.mixin.transformer.MixinInfo;
import org.spongepowered.asm.mixin.transformer.ext.Extensions;
import org.spongepowered.asm.mixin.transformer.ext.ITargetClassContext;
import org.spongepowered.asm.util.Annotations;
import org.spongepowered.asm.util.Bytecode;
import org.spongepowered.asm.util.ClassSignature;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2;

class TargetClassContext
extends ClassContext
implements ITargetClassContext {
    private static final Logger logger = LogManager.getLogger((String)\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("\u007f\ua7ef\ua4ad\ua078\ua90b"));
    private final MixinEnvironment env;
    private final Extensions extensions;
    private final String sessionId;
    private final String className;
    private final ClassNode classNode;
    private final ClassInfo classInfo;
    private final SourceMap sourceMap;
    private final ClassSignature signature;
    private final SortedSet<MixinInfo> mixins;
    private final Map<String, Target> targetMethods = new HashMap<String, Target>();
    private final Set<MethodNode> mixinMethods = new HashSet<MethodNode>();
    private int nextUniqueMethodIndex;
    private int nextUniqueFieldIndex;
    private boolean applied;
    private boolean forceExport;

    TargetClassContext(MixinEnvironment mixinEnvironment, Extensions extensions, String string, String string2, ClassNode classNode, SortedSet<MixinInfo> sortedSet) {
        this.env = mixinEnvironment;
        this.extensions = extensions;
        this.sessionId = string;
        this.className = string2;
        this.classNode = classNode;
        this.classInfo = ClassInfo.fromClassNode(classNode);
        this.signature = this.classInfo.getSignature();
        this.mixins = sortedSet;
        this.sourceMap = new SourceMap(classNode.sourceFile);
        this.sourceMap.addFile(this.classNode);
    }

    public String toString() {
        return this.className;
    }

    boolean isApplied() {
        return this.applied;
    }

    boolean isExportForced() {
        return this.forceExport;
    }

    Extensions getExtensions() {
        return this.extensions;
    }

    String getSessionId() {
        return this.sessionId;
    }

    @Override
    String getClassRef() {
        return this.classNode.name;
    }

    String getClassName() {
        return this.className;
    }

    @Override
    public ClassNode getClassNode() {
        return this.classNode;
    }

    List<MethodNode> getMethods() {
        return this.classNode.methods;
    }

    List<FieldNode> getFields() {
        return this.classNode.fields;
    }

    @Override
    public ClassInfo getClassInfo() {
        return this.classInfo;
    }

    SortedSet<MixinInfo> getMixins() {
        return this.mixins;
    }

    SourceMap getSourceMap() {
        return this.sourceMap;
    }

    void mergeSignature(ClassSignature classSignature) {
        this.signature.merge(classSignature);
    }

    void addMixinMethod(MethodNode methodNode) {
        this.mixinMethods.add(methodNode);
    }

    void methodMerged(MethodNode methodNode) {
        if (!this.mixinMethods.remove(methodNode)) {
            Object[] objectArray = new Object[0xCAB268FD ^ 0xCAB268FE];
            objectArray[0x72648162 ^ 0x72648162] = methodNode.name;
            objectArray[0xB61435BF ^ 0xB61435BE] = methodNode.desc;
            objectArray[0xBA39A228 ^ 0xBA39A22A] = this;
            logger.debug(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("G\ua7e8\ua4b0\ua069\ua915\u7d73\u8e49\u246e\u8b32\u3473(\ua7a6\ua498\ua074\ua917\u7d71\u8e4f\u247e\u8b77\u3462|\ua7f4\ua4b0\ua076\ua90c\u7d65\u8e5e\u247f\u8b25\u3472v\ua7a6\ua4b8\ua074\ua911\u7d7e\u8e45\u247e\u8b77\u346co\ua7fd\ua4a8\ua031\ua90c\u7d78\u8e0a\u2461\u8b2a"), objectArray);
        }
    }

    MethodNode findMethod(Deque<String> deque, String string) {
        return this.findAliasedMethod(deque, string, (0x664653 ^ 0x664652) != 0);
    }

    MethodNode findAliasedMethod(Deque<String> deque, String string) {
        return this.findAliasedMethod(deque, string, (0x3C18AC42 ^ 0x3C18AC42) != 0);
    }

    private MethodNode findAliasedMethod(Deque<String> deque, String string, boolean bl) {
        String string2 = deque.poll();
        if (string2 == null) {
            return null;
        }
        for (MethodNode methodNode : this.classNode.methods) {
            if (!methodNode.name.equals(string2) || !methodNode.desc.equals(string)) continue;
            return methodNode;
        }
        if (bl) {
            for (MethodNode methodNode : this.mixinMethods) {
                if (!methodNode.name.equals(string2) || !methodNode.desc.equals(string)) continue;
                return methodNode;
            }
        }
        return this.findAliasedMethod(deque, string);
    }

    FieldNode findAliasedField(Deque<String> deque, String string) {
        String string2 = deque.poll();
        if (string2 == null) {
            return null;
        }
        for (FieldNode fieldNode : this.classNode.fields) {
            if (!fieldNode.name.equals(string2) || !fieldNode.desc.equals(string)) continue;
            return fieldNode;
        }
        return this.findAliasedField(deque, string);
    }

    Target getTargetMethod(MethodNode methodNode) {
        if (!this.classNode.methods.contains(methodNode)) {
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b23\u3476`\ua7e1\ua4b0\ua065\ua945\u7d7b\u8e4f\u246e\u8b3f\u3478v\ua7a6\ua4a6\ua064\ua915\u7d66\u8e46\u2473\u8b32\u34732\ua7f2\ua4ba\ua031\ua902\u7d73\u8e5e\u244e\u8b36\u3465u\ua7e3\ua4a1\ua05c\ua900\u7d62\u8e42\u2475\u8b33\u343f;"));
        }
        String string = methodNode.name + methodNode.desc;
        Target target = this.targetMethods.get(string);
        if (target == null) {
            target = new Target(this.classNode, methodNode);
            this.targetMethods.put(string, target);
        }
        return target;
    }

    String getUniqueName(MethodNode methodNode, boolean bl) {
        int n = this.nextUniqueMethodIndex;
        this.nextUniqueMethodIndex = n + (0xED2FF7B9 ^ 0xED2FF7B8);
        String string = Integer.toHexString(n);
        String string2 = bl ? \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("7\ua7b4\ua4f1\ua062\ua93a\u7d32\u8e47\u247e\u8b73\u3432#\ua7a2\ua4a6\ua035\ua940\u7d25\u8e0e\u2469") : \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("\u007f\ua7e2\ua4f0\ua062\ua941\u7d33\u8e59\u243e\u8b72\u3464");
        Object[] objectArray = new Object[0xDA31DB7 ^ 0xDA31DB4];
        objectArray[0xA95DD698 ^ 0xA95DD698] = this.sessionId.substring(0xCD7128E ^ 0xCD71290);
        objectArray[0xF3A7D57C ^ 0xF3A7D57D] = methodNode.name;
        objectArray[0xF712CFB3 ^ 0xF712CFB1] = string;
        return String.format(string2, objectArray);
    }

    String getUniqueName(FieldNode fieldNode) {
        int n = this.nextUniqueFieldIndex;
        this.nextUniqueFieldIndex = n + (0x29421D71 ^ 0x29421D70);
        String string = Integer.toHexString(n);
        Object[] objectArray = new Object[0x6191BDF9 ^ 0x6191BDFA];
        objectArray[0xC0578FFF ^ 0xC0578FFF] = this.sessionId.substring(0xDA245E22 ^ 0xDA245E3C);
        objectArray[0x5C9AD019 ^ 0x5C9AD018] = fieldNode.name;
        objectArray[0x4430D23 ^ 0x4430D21] = string;
        return String.format(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("t\ua7e2\ua4f0\ua062\ua941\u7d33\u8e59\u243e\u8b72\u3464"), objectArray);
    }

    void applyMixins() {
        if (this.applied) {
            throw new IllegalStateException(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("_\ua7ef\ua4ad\ua078\ua90b\u7d65\u8e0a\u247b\u8b3b\u3465w\ua7e7\ua4b1\ua068\ua945\u7d77\u8e5a\u246a\u8b3b\u347ew\ua7e2\ua4f5\ua065\ua90a\u7d36\u8e5e\u247b\u8b25\u3470w\ua7f2\ua4f5\ua072\ua909\u7d77\u8e59\u2469\u8b77") + this.className);
        }
        this.applied = 0x17247567 ^ 0x17247566;
        MixinApplicatorStandard mixinApplicatorStandard = this.createApplicator();
        mixinApplicatorStandard.apply(this.mixins);
        this.applySignature();
        this.upgradeMethods();
        this.checkMerges();
    }

    private MixinApplicatorStandard createApplicator() {
        if (this.classInfo.isInterface()) {
            return new MixinApplicatorInterface(this);
        }
        return new MixinApplicatorStandard(this);
    }

    private void applySignature() {
        this.getClassNode().signature = this.signature.toString();
    }

    private void checkMerges() {
        for (MethodNode methodNode : this.mixinMethods) {
            if (methodNode.name.startsWith(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("."))) continue;
            Object[] objectArray = new Object[0xB12BC4E3 ^ 0xB12BC4E0];
            objectArray[0xFA01F930 ^ 0xFA01F930] = methodNode.name;
            objectArray[0x274E5CC4 ^ 0x274E5CC5] = methodNode.desc;
            objectArray[0x8D30A1A5 ^ 0x8D30A1A7] = this;
            logger.debug(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("G\ua7e8\ua4b0\ua069\ua915\u7d73\u8e49\u246e\u8b32\u3473(\ua7a6\ua487\ua074\ua902\u7d7f\u8e59\u246e\u8b32\u3465w\ua7e2\ua4f5\ua07c\ua900\u7d62\u8e42\u2475\u8b33\u3437i\ua7fb\ua4ae\ua06c\ua945\u7d7f\u8e44\u243a\u8b2c\u346a2\ua7f1\ua4b4\ua062\ua945\u7d78\u8e45\u246e\u8b77\u347aw\ua7f4\ua4b2\ua074\ua901"), objectArray);
        }
    }

    void processDebugTasks() {
        if (!this.env.getOption(MixinEnvironment.Option.DEBUG_VERBOSE)) {
            return;
        }
        AnnotationNode annotationNode = Annotations.getVisible(this.classNode, Debug.class);
        if (annotationNode != null) {
            this.forceExport = Boolean.TRUE.equals(Annotations.getValue(annotationNode, \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("w\ua7fe\ua4a5\ua07e\ua917\u7d62")));
            if (Boolean.TRUE.equals(Annotations.getValue(annotationNode, \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("b\ua7f4\ua4bc\ua07f\ua911")))) {
                Bytecode.textify(this.classNode, (OutputStream)System.err);
            }
        }
        for (MethodNode methodNode : this.classNode.methods) {
            AnnotationNode annotationNode2 = Annotations.getVisible(methodNode, Debug.class);
            if (annotationNode2 == null || !Boolean.TRUE.equals(Annotations.getValue(annotationNode2, \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("b\ua7f4\ua4bc\ua07f\ua911")))) continue;
            Bytecode.textify(methodNode, (OutputStream)System.err);
        }
    }
}

