/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer.ext;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.transformer.MixinTransformer;
import org.spongepowered.asm.mixin.transformer.ext.IClassGenerator;
import org.spongepowered.asm.mixin.transformer.ext.IExtension;
import org.spongepowered.asm.mixin.transformer.ext.ITargetClassContext;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2;

public final class Extensions {
    private final MixinTransformer transformer;
    private final List<IExtension> extensions = new ArrayList<IExtension>();
    private final Map<Class<? extends IExtension>, IExtension> extensionMap = new HashMap<Class<? extends IExtension>, IExtension>();
    private final List<IClassGenerator> generators = new ArrayList<IClassGenerator>();
    private final List<IClassGenerator> generatorsView = Collections.unmodifiableList(this.generators);
    private final Map<Class<? extends IClassGenerator>, IClassGenerator> generatorMap = new HashMap<Class<? extends IClassGenerator>, IClassGenerator>();
    private List<IExtension> activeExtensions = Collections.emptyList();

    public Extensions(MixinTransformer mixinTransformer) {
        this.transformer = mixinTransformer;
    }

    public MixinTransformer getTransformer() {
        return this.transformer;
    }

    public void add(IExtension iExtension) {
        this.extensions.add(iExtension);
        this.extensionMap.put(iExtension.getClass(), iExtension);
    }

    public List<IExtension> getExtensions() {
        return Collections.unmodifiableList(this.extensions);
    }

    public List<IExtension> getActiveExtensions() {
        return this.activeExtensions;
    }

    public <T extends IExtension> T getExtension(Class<? extends IExtension> clazz) {
        return (T)Extensions.lookup(clazz, this.extensionMap, this.extensions);
    }

    public void select(MixinEnvironment mixinEnvironment) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (IExtension iExtension : this.extensions) {
            if (!iExtension.checkActive(mixinEnvironment)) continue;
            builder.add((Object)iExtension);
        }
        this.activeExtensions = builder.build();
    }

    public void preApply(ITargetClassContext iTargetClassContext) {
        for (IExtension iExtension : this.activeExtensions) {
            iExtension.preApply(iTargetClassContext);
        }
    }

    public void postApply(ITargetClassContext iTargetClassContext) {
        for (IExtension iExtension : this.activeExtensions) {
            iExtension.postApply(iTargetClassContext);
        }
    }

    public void export(MixinEnvironment mixinEnvironment, String string, boolean bl, byte[] byArray) {
        for (IExtension iExtension : this.activeExtensions) {
            iExtension.export(mixinEnvironment, string, bl, byArray);
        }
    }

    public void add(IClassGenerator iClassGenerator) {
        this.generators.add(iClassGenerator);
        this.generatorMap.put(iClassGenerator.getClass(), iClassGenerator);
    }

    public List<IClassGenerator> getGenerators() {
        return this.generatorsView;
    }

    public <T extends IClassGenerator> T getGenerator(Class<? extends IClassGenerator> clazz) {
        return (T)Extensions.lookup(clazz, this.generatorMap, this.generators);
    }

    private static <T> T lookup(Class<? extends T> clazz, Map<Class<? extends T>, T> map, List<T> list) {
        T t = map.get(clazz);
        if (t == null) {
            for (T t2 : list) {
                if (!clazz.isAssignableFrom(t2.getClass())) continue;
                t = t2;
                break;
            }
            if (t == null) {
                throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("W\ua7fe\ua4a1\ua074\ua90b\u7d65\u8e43\u2475\u8b39\u3437t\ua7e9\ua4a7\ua031\ua959") + clazz.getName() + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20(",\ua7a6\ua4b6\ua07e\ua910\u7d7a\u8e4e\u243a\u8b39\u3478f\ua7a6\ua4b7\ua074\ua945\u7d70\u8e45\u246f\u8b39\u3473"));
            }
            map.put(clazz, t);
        }
        return t;
    }
}

