/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.util;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.lib.tree.FieldNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2;

public final class Annotations {
    private Annotations() {
    }

    public static void setVisible(FieldNode fieldNode, Class<? extends Annotation> clazz, Object ... objectArray) {
        AnnotationNode annotationNode = Annotations.createNode(Type.getDescriptor(clazz), objectArray);
        fieldNode.visibleAnnotations = Annotations.add(fieldNode.visibleAnnotations, annotationNode);
    }

    public static void setInvisible(FieldNode fieldNode, Class<? extends Annotation> clazz, Object ... objectArray) {
        AnnotationNode annotationNode = Annotations.createNode(Type.getDescriptor(clazz), objectArray);
        fieldNode.invisibleAnnotations = Annotations.add(fieldNode.invisibleAnnotations, annotationNode);
    }

    public static void setVisible(MethodNode methodNode, Class<? extends Annotation> clazz, Object ... objectArray) {
        AnnotationNode annotationNode = Annotations.createNode(Type.getDescriptor(clazz), objectArray);
        methodNode.visibleAnnotations = Annotations.add(methodNode.visibleAnnotations, annotationNode);
    }

    public static void setInvisible(MethodNode methodNode, Class<? extends Annotation> clazz, Object ... objectArray) {
        AnnotationNode annotationNode = Annotations.createNode(Type.getDescriptor(clazz), objectArray);
        methodNode.invisibleAnnotations = Annotations.add(methodNode.invisibleAnnotations, annotationNode);
    }

    private static AnnotationNode createNode(String string, Object ... objectArray) {
        AnnotationNode annotationNode = new AnnotationNode(string);
        int n = 0x2E278322 ^ 0x2E278322;
        while (true) {
            if (n >= objectArray.length - (0xB1E5DC69 ^ 0xB1E5DC68)) break;
            if (!(objectArray[n] instanceof String)) {
                throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("S\ua7e8\ua4bb\ua07e\ua911\u7d77\u8e5e\u2473\u8b38\u34792\ua7ed\ua4b0\ua068\ua916\u7d36\u8e47\u246f\u8b24\u34632\ua7e4\ua4b0\ua031\ua916\u7d62\u8e58\u2473\u8b39\u3470a\ua7aa\ua4f5\ua077\ua90a\u7d63\u8e44\u247e\u8b77") + objectArray[n].getClass().getSimpleName() + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2\ua7f1\ua4bc\ua065\ua90d\u7d36") + objectArray[n].toString() + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2\ua7e7\ua4a1\ua031\ua90c\u7d78\u8e4e\u247f\u8b2f\u3437") + n + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2\ua7e5\ua4a7\ua074\ua904\u7d62\u8e43\u2474\u8b30\u3437") + string);
            }
            annotationNode.visit((String)objectArray[n], objectArray[n + (0xC9C10B4E ^ 0xC9C10B4F)]);
            n += 2;
        }
        return annotationNode;
    }

    private static List<AnnotationNode> add(List<AnnotationNode> list, AnnotationNode annotationNode) {
        if (list == null) {
            list = new ArrayList<AnnotationNode>(0xD2CCBB72 ^ 0xD2CCBB73);
        } else {
            list.remove(Annotations.get(list, annotationNode.desc));
        }
        list.add(annotationNode);
        return list;
    }

    public static AnnotationNode getVisible(FieldNode fieldNode, Class<? extends Annotation> clazz) {
        return Annotations.get(fieldNode.visibleAnnotations, Type.getDescriptor(clazz));
    }

    public static AnnotationNode getInvisible(FieldNode fieldNode, Class<? extends Annotation> clazz) {
        return Annotations.get(fieldNode.invisibleAnnotations, Type.getDescriptor(clazz));
    }

    public static AnnotationNode getVisible(MethodNode methodNode, Class<? extends Annotation> clazz) {
        return Annotations.get(methodNode.visibleAnnotations, Type.getDescriptor(clazz));
    }

    public static AnnotationNode getInvisible(MethodNode methodNode, Class<? extends Annotation> clazz) {
        return Annotations.get(methodNode.invisibleAnnotations, Type.getDescriptor(clazz));
    }

    public static AnnotationNode getSingleVisible(MethodNode methodNode, Class<? extends Annotation> ... classArray) {
        return Annotations.getSingle(methodNode.visibleAnnotations, classArray);
    }

    public static AnnotationNode getSingleInvisible(MethodNode methodNode, Class<? extends Annotation> ... classArray) {
        return Annotations.getSingle(methodNode.invisibleAnnotations, classArray);
    }

    public static AnnotationNode getVisible(ClassNode classNode, Class<? extends Annotation> clazz) {
        return Annotations.get(classNode.visibleAnnotations, Type.getDescriptor(clazz));
    }

    public static AnnotationNode getInvisible(ClassNode classNode, Class<? extends Annotation> clazz) {
        return Annotations.get(classNode.invisibleAnnotations, Type.getDescriptor(clazz));
    }

    public static AnnotationNode getVisibleParameter(MethodNode methodNode, Class<? extends Annotation> clazz, int n) {
        return Annotations.getParameter(methodNode.visibleParameterAnnotations, Type.getDescriptor(clazz), n);
    }

    public static AnnotationNode getInvisibleParameter(MethodNode methodNode, Class<? extends Annotation> clazz, int n) {
        return Annotations.getParameter(methodNode.invisibleParameterAnnotations, Type.getDescriptor(clazz), n);
    }

    public static AnnotationNode getParameter(List<AnnotationNode>[] listArray, String string, int n) {
        if (listArray == null || n < 0 || n >= listArray.length) {
            return null;
        }
        return Annotations.get(listArray[n], string);
    }

    public static AnnotationNode get(List<AnnotationNode> list, String string) {
        if (list == null) {
            return null;
        }
        for (AnnotationNode annotationNode : list) {
            if (!string.equals(annotationNode.desc)) continue;
            return annotationNode;
        }
        return null;
    }

    private static AnnotationNode getSingle(List<AnnotationNode> list, Class<? extends Annotation>[] classArray) {
        ArrayList<AnnotationNode> arrayList = new ArrayList<AnnotationNode>();
        Class<? extends Annotation>[] classArray2 = classArray;
        int n = classArray2.length;
        for (int i = 0xD26F6BAE ^ 0xD26F6BAE; i < n; ++i) {
            Class<? extends Annotation> clazz = classArray2[i];
            AnnotationNode annotationNode = Annotations.get(list, Type.getDescriptor(clazz));
            if (annotationNode == null) continue;
            arrayList.add(annotationNode);
        }
        int n2 = arrayList.size();
        if (n2 > (0x58F2DD6A ^ 0x58F2DD6B)) {
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("Q\ua7e9\ua4bb\ua077\ua909\u7d7f\u8e49\u246e\u8b3e\u3479u\ua7a6\ua4b4\ua07f\ua90b\u7d79\u8e5e\u247b\u8b23\u347e}\ua7e8\ua4a6\ua031\ua903\u7d79\u8e5f\u2474\u8b33\u342d2") + Lists.transform(arrayList, (Function)new Function<AnnotationNode, String>(){

                public String apply(AnnotationNode annotationNode) {
                    return annotationNode.desc;
                }
            }));
        }
        return n2 == 0 ? null : (AnnotationNode)arrayList.get(0x967B72C2 ^ 0x967B72C2);
    }

    public static <T> T getValue(AnnotationNode annotationNode) {
        return Annotations.getValue(annotationNode, \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("d\ua7e7\ua4b9\ua064\ua900"));
    }

    public static <T> T getValue(AnnotationNode annotationNode, String string, T t) {
        T t2 = Annotations.getValue(annotationNode, string);
        return t2 != null ? t2 : t;
    }

    public static <T> T getValue(AnnotationNode annotationNode, String string, Class<?> clazz) {
        Preconditions.checkNotNull(clazz, (Object)\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("s\ua7e8\ua4bb\ua07e\ua911\u7d77\u8e5e\u2473\u8b38\u3479Q\ua7ea\ua4b4\ua062\ua916\u7d36\u8e49\u247b\u8b39\u3479}\ua7f2\ua4f5\ua073\ua900\u7d36\u8e44\u246f\u8b3b\u347b"));
        Object object = Annotations.getValue(annotationNode, string);
        if (object == null) {
            try {
                object = clazz.getDeclaredMethod(string, new Class[0x88A1C1D4 ^ 0x88A1C1D4]).getDefaultValue();
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return object;
    }

    public static <T> T getValue(AnnotationNode annotationNode, String string) {
        int n = 0xA63E668F ^ 0xA63E668F;
        if (annotationNode == null || annotationNode.values == null) {
            return null;
        }
        for (Object object : annotationNode.values) {
            if (n != 0) {
                return (T)object;
            }
            if (!object.equals(string)) continue;
            n = 0x5AACBE0E ^ 0x5AACBE0F;
        }
        return null;
    }

    public static <T extends Enum<T>> T getValue(AnnotationNode annotationNode, String string, Class<T> clazz, T t) {
        String[] stringArray = (String[])Annotations.getValue(annotationNode, string);
        if (stringArray == null) {
            return t;
        }
        return Annotations.toEnumValue(clazz, stringArray);
    }

    public static <T> List<T> getValue(AnnotationNode annotationNode, String string, boolean bl) {
        T t = Annotations.getValue(annotationNode, string);
        if (t instanceof List) {
            return (List)t;
        }
        if (t != null) {
            ArrayList<T> arrayList = new ArrayList<T>();
            arrayList.add(t);
            return arrayList;
        }
        return Collections.emptyList();
    }

    public static <T extends Enum<T>> List<T> getValue(AnnotationNode annotationNode, String string, boolean bl, Class<T> clazz) {
        T t = Annotations.getValue(annotationNode, string);
        if (t instanceof List) {
            ListIterator<T> listIterator = ((List)t).listIterator();
            while (listIterator.hasNext()) {
                listIterator.set(Annotations.toEnumValue(clazz, (String[])listIterator.next()));
            }
            return (List)t;
        }
        if (t instanceof String[]) {
            ArrayList<T> arrayList = new ArrayList<T>();
            arrayList.add(Annotations.toEnumValue(clazz, (String[])t));
            return arrayList;
        }
        return Collections.emptyList();
    }

    private static <T extends Enum<T>> T toEnumValue(Class<T> clazz, String[] stringArray) {
        if (!clazz.getName().equals(Type.getType(stringArray[0xF503FCF5 ^ 0xF503FCF5]).getClassName())) {
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("F\ua7ee\ua4b0\ua031\ua916\u7d63\u8e5a\u246a\u8b3b\u347ew\ua7e2\ua4f5\ua074\ua90b\u7d63\u8e47\u243a\u8b34\u347bs\ua7f5\ua4a6\ua031\ua901\u7d79\u8e4f\u2469\u8b77\u3479}\ua7f2\ua4f5\ua07c\ua904\u7d62\u8e49\u2472\u8b77\u3463z\ua7e3\ua4f5\ua062\ua911\u7d79\u8e58\u247f\u8b33\u3437w\ua7e8\ua4a0\ua07c\ua945\u7d60\u8e4b\u2476\u8b22\u3472"));
        }
        return Enum.valueOf(clazz, stringArray[0xBFD2FEB6 ^ 0xBFD2FEB7]);
    }
}

