/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.util;

import com.google.common.base.Joiner;
import com.google.common.primitives.Ints;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.lib.ClassReader;
import org.spongepowered.asm.lib.ClassWriter;
import org.spongepowered.asm.lib.MethodVisitor;
import org.spongepowered.asm.lib.Opcodes;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.lib.tree.FieldInsnNode;
import org.spongepowered.asm.lib.tree.FieldNode;
import org.spongepowered.asm.lib.tree.FrameNode;
import org.spongepowered.asm.lib.tree.InsnList;
import org.spongepowered.asm.lib.tree.IntInsnNode;
import org.spongepowered.asm.lib.tree.JumpInsnNode;
import org.spongepowered.asm.lib.tree.LabelNode;
import org.spongepowered.asm.lib.tree.LdcInsnNode;
import org.spongepowered.asm.lib.tree.LineNumberNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.lib.tree.TypeInsnNode;
import org.spongepowered.asm.lib.tree.VarInsnNode;
import org.spongepowered.asm.lib.util.CheckClassAdapter;
import org.spongepowered.asm.lib.util.TraceClassVisitor;
import org.spongepowered.asm.mixin.Debug;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.util.Constants;
import org.spongepowered.asm.util.throwables.SyntheticBridgeException;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2;

public final class Bytecode {
    public static final int[] CONSTANTS_INT;
    public static final int[] CONSTANTS_FLOAT;
    public static final int[] CONSTANTS_DOUBLE;
    public static final int[] CONSTANTS_LONG;
    public static final int[] CONSTANTS_ALL;
    private static final Object[] CONSTANTS_VALUES;
    private static final String[] CONSTANTS_TYPES;
    private static final String[] BOXING_TYPES;
    private static final String[] UNBOXING_METHODS;
    private static final Class<?>[] MERGEABLE_MIXIN_ANNOTATIONS;
    private static Pattern mergeableAnnotationPattern;
    private static final Logger logger;

    private Bytecode() {
    }

    public static MethodNode findMethod(ClassNode classNode, String string, String string2) {
        for (MethodNode methodNode : classNode.methods) {
            if (!methodNode.name.equals(string) || !methodNode.desc.equals(string2)) continue;
            return methodNode;
        }
        return null;
    }

    public static AbstractInsnNode findInsn(MethodNode methodNode, int n) {
        ListIterator<AbstractInsnNode> listIterator = methodNode.instructions.iterator();
        while (listIterator.hasNext()) {
            AbstractInsnNode abstractInsnNode = (AbstractInsnNode)listIterator.next();
            if (abstractInsnNode.getOpcode() != n) continue;
            return abstractInsnNode;
        }
        return null;
    }

    public static MethodInsnNode findSuperInit(MethodNode methodNode, String string) {
        if (!\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20(".\ua7ef\ua4bb\ua078\ua911\u7d28").equals(methodNode.name)) {
            return null;
        }
        int n = 0xAB3C6AA4 ^ 0xAB3C6AA4;
        ListIterator<AbstractInsnNode> listIterator = methodNode.instructions.iterator();
        while (listIterator.hasNext()) {
            AbstractInsnNode abstractInsnNode = (AbstractInsnNode)listIterator.next();
            if (abstractInsnNode instanceof TypeInsnNode) {
                if (abstractInsnNode.getOpcode() == (0x1CD480C7 ^ 0x1CD4807C)) {
                    ++n;
                    continue;
                }
            }
            if (!(abstractInsnNode instanceof MethodInsnNode)) continue;
            if (abstractInsnNode.getOpcode() != (0x4C42C4B4 ^ 0x4C42C403)) continue;
            MethodInsnNode methodInsnNode = (MethodInsnNode)abstractInsnNode;
            if (!\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20(".\ua7ef\ua4bb\ua078\ua911\u7d28").equals(methodInsnNode.name)) continue;
            if (n > 0) {
                --n;
                continue;
            }
            if (!methodInsnNode.owner.equals(string)) continue;
            return methodInsnNode;
        }
        return null;
    }

    public static void textify(ClassNode classNode, OutputStream outputStream) {
        classNode.accept(new TraceClassVisitor(new PrintWriter(outputStream)));
    }

    public static void textify(MethodNode methodNode, OutputStream outputStream) {
        TraceClassVisitor traceClassVisitor = new TraceClassVisitor(new PrintWriter(outputStream));
        MethodVisitor methodVisitor = traceClassVisitor.visitMethod(methodNode.access, methodNode.name, methodNode.desc, methodNode.signature, methodNode.exceptions.toArray(new String[0xDFE92531 ^ 0xDFE92531]));
        methodNode.accept(methodVisitor);
        traceClassVisitor.visitEnd();
    }

    public static void dumpClass(ClassNode classNode) {
        ClassWriter classWriter = new ClassWriter(0x42E317D5 ^ 0x42E317D6);
        classNode.accept(classWriter);
        Bytecode.dumpClass(classWriter.toByteArray());
    }

    public static void dumpClass(byte[] byArray) {
        ClassReader classReader = new ClassReader(byArray);
        CheckClassAdapter.verify(classReader, (0xF290BEE ^ 0xF290BEF) != 0, new PrintWriter(System.out));
    }

    public static void printMethodWithOpcodeIndices(MethodNode methodNode) {
        Object[] objectArray = new Object[0x72532C9 ^ 0x72532CB];
        objectArray[0x25FC2D60 ^ 0x25FC2D60] = methodNode.name;
        objectArray[0xDF0EDE4B ^ 0xDF0EDE4A] = methodNode.desc;
        System.err.printf(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("7\ua7f5\ua4f0\ua062\ua96f"), objectArray);
        int n = 0xE2648F86 ^ 0xE2648F86;
        ListIterator<AbstractInsnNode> listIterator = methodNode.instructions.iterator();
        while (listIterator.hasNext()) {
            Object[] objectArray2 = new Object[0x58F6EDD ^ 0x58F6EDF];
            objectArray2[0xA93C28F1 ^ 0xA93C28F1] = n++;
            objectArray2[0xEA5532BF ^ 0xEA5532BE] = Bytecode.describeNode((AbstractInsnNode)listIterator.next());
            System.err.printf(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("I\ua7a3\ua4e1\ua075\ua938\u7d36\u8e0f\u2469\u8b5d"), objectArray2);
        }
    }

    public static void printMethod(MethodNode methodNode) {
        Object[] objectArray = new Object[0xF7B5782D ^ 0xF7B5782F];
        objectArray[0x6E790D2D ^ 0x6E790D2D] = methodNode.name;
        objectArray[0xFA40CAE3 ^ 0xFA40CAE2] = methodNode.desc;
        System.err.printf(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("7\ua7f5\ua4f0\ua062\ua96f"), objectArray);
        ListIterator<AbstractInsnNode> listIterator = methodNode.instructions.iterator();
        while (listIterator.hasNext()) {
            System.err.print(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2\ua7a6"));
            Bytecode.printNode((AbstractInsnNode)listIterator.next());
        }
    }

    public static void printNode(AbstractInsnNode abstractInsnNode) {
        Object[] objectArray = new Object[0xF422ECF2 ^ 0xF422ECF3];
        objectArray[0x427C8A89 ^ 0x427C8A89] = Bytecode.describeNode(abstractInsnNode);
        System.err.printf(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("7\ua7f5\ua4df"), objectArray);
    }

    public static String describeNode(AbstractInsnNode abstractInsnNode) {
        if (abstractInsnNode == null) {
            Object[] objectArray = new Object[0xB83EC5E5 ^ 0xB83EC5E4];
            objectArray[0x925D2AF3 ^ 0x925D2AF3] = \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("|\ua7f3\ua4b9\ua07d");
            return String.format(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2\ua7a6\ua4f5\ua034\ua948\u7d27\u8e1e\u2469\u8b77"), objectArray);
        }
        if (abstractInsnNode instanceof LabelNode) {
            Object[] objectArray = new Object[0x9EFB1CFB ^ 0x9EFB1CFA];
            objectArray[0x54AEF382 ^ 0x54AEF382] = ((LabelNode)abstractInsnNode).getLabel();
            return String.format(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("I\ua7a3\ua4a6\ua04c"), objectArray);
        }
        Object[] objectArray = new Object[0x6E9B8DF3 ^ 0x6E9B8DF2];
        objectArray[0x57D1C1AC ^ 0x57D1C1AC] = abstractInsnNode.getClass().getSimpleName().replace(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("\\\ua7e9\ua4b1\ua074"), \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20(""));
        String string = String.format(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2\ua7a6\ua4f5\ua034\ua948\u7d27\u8e1e\u2469\u8b77"), objectArray);
        if (abstractInsnNode instanceof JumpInsnNode) {
            Object[] objectArray2 = new Object[0x338CAC25 ^ 0x338CAC27];
            objectArray2[0xF49B792B ^ 0xF49B792B] = Bytecode.getOpcodeName(abstractInsnNode);
            objectArray2[0xF3896962 ^ 0xF3896963] = ((JumpInsnNode)abstractInsnNode).label.getLabel();
            string = string + String.format(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("I\ua7a3\ua4a6\ua04c\ua945\u7d4d\u8e0f\u2469\u8b0a"), objectArray2);
        } else if (abstractInsnNode instanceof VarInsnNode) {
            Object[] objectArray3 = new Object[0xEE7CCACA ^ 0xEE7CCAC8];
            objectArray3[0xD1217A5A ^ 0xD1217A5A] = Bytecode.getOpcodeName(abstractInsnNode);
            objectArray3[0xCE29FAE0 ^ 0xCE29FAE1] = ((VarInsnNode)abstractInsnNode).var;
            string = string + String.format(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("I\ua7a3\ua4a6\ua04c\ua945\u7d33\u8e4e"), objectArray3);
        } else if (abstractInsnNode instanceof MethodInsnNode) {
            MethodInsnNode methodInsnNode = (MethodInsnNode)abstractInsnNode;
            Object[] objectArray4 = new Object[0x3B6E5A32 ^ 0x3B6E5A36];
            objectArray4[0x1382D60E ^ 0x1382D60E] = Bytecode.getOpcodeName(abstractInsnNode);
            objectArray4[0xE1118221 ^ 0xE1118220] = methodInsnNode.owner;
            objectArray4[0xF14C18AC ^ 0xF14C18AE] = methodInsnNode.name;
            objectArray4[0xBADD282B ^ 0xBADD2828] = methodInsnNode.desc;
            string = string + String.format(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("I\ua7a3\ua4a6\ua04c\ua945\u7d33\u8e59\u243a\u8b72\u34642\ua7a3\ua4a6"), objectArray4);
        } else if (abstractInsnNode instanceof FieldInsnNode) {
            FieldInsnNode fieldInsnNode = (FieldInsnNode)abstractInsnNode;
            Object[] objectArray5 = new Object[0xD09FA748 ^ 0xD09FA74C];
            objectArray5[0x2F76779A ^ 0x2F76779A] = Bytecode.getOpcodeName(abstractInsnNode);
            objectArray5[0xFC03F00F ^ 0xFC03F00E] = fieldInsnNode.owner;
            objectArray5[0xF468C42F ^ 0xF468C42D] = fieldInsnNode.name;
            objectArray5[0xC1E17C07 ^ 0xC1E17C04] = fieldInsnNode.desc;
            string = string + String.format(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("I\ua7a3\ua4a6\ua04c\ua945\u7d33\u8e59\u243a\u8b72\u34642\ua7a3\ua4a6"), objectArray5);
        } else if (abstractInsnNode instanceof LineNumberNode) {
            LineNumberNode lineNumberNode = (LineNumberNode)abstractInsnNode;
            Object[] objectArray6 = new Object[0x2D632524 ^ 0x2D632526];
            objectArray6[0x676BFCD8 ^ 0x676BFCD8] = lineNumberNode.line;
            objectArray6[0x6F2351D9 ^ 0x6F2351D8] = lineNumberNode.start.getLabel();
            string = string + String.format(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("^\ua7cf\ua49b\ua054\ua958\u7d4d\u8e0f\u247e\u8b0a\u3437^\ua7c7\ua497\ua054\ua929\u7d2b\u8e71\u243f\u8b24\u344a"), objectArray6);
        } else if (abstractInsnNode instanceof LdcInsnNode) {
            string = string + ((LdcInsnNode)abstractInsnNode).cst;
        } else if (abstractInsnNode instanceof IntInsnNode) {
            string = string + ((IntInsnNode)abstractInsnNode).operand;
        } else if (abstractInsnNode instanceof FrameNode) {
            Object[] objectArray7 = new Object[0x57493878 ^ 0x57493879];
            objectArray7[0x7BEAF119 ^ 0x7BEAF119] = Bytecode.getOpcodeName(((FrameNode)abstractInsnNode).type, \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("Z\ua7d9\ua49c\ua05f\ua933\u7d59\u8e61\u245f\u8b1e\u3459F\ua7c3\ua487\ua057\ua924\u7d55\u8e6f"), 0x4B5232C9 ^ 0xB4ADCD36);
            string = string + String.format(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("I\ua7a3\ua4a6\ua04c\ua945"), objectArray7);
        } else {
            Object[] objectArray8 = new Object[0x862FFB78 ^ 0x862FFB79];
            objectArray8[0xA6DB90DC ^ 0xA6DB90DC] = Bytecode.getOpcodeName(abstractInsnNode);
            string = string + String.format(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("I\ua7a3\ua4a6\ua04c\ua945"), objectArray8);
        }
        return string;
    }

    public static String getOpcodeName(AbstractInsnNode abstractInsnNode) {
        return abstractInsnNode != null ? Bytecode.getOpcodeName(abstractInsnNode.getOpcode()) : \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("");
    }

    public static String getOpcodeName(int n) {
        return Bytecode.getOpcodeName(n, \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("G\ua7c8\ua49c\ua05f\ua92c\u7d42\u8e63\u245b\u8b1b\u345eH\ua7c3\ua491\ua04e\ua931\u7d5e\u8e63\u2449"), 0xD6A962D8 ^ 0xD6A962D9);
    }

    private static String getOpcodeName(int n, String string, int n2) {
        if (n >= n2) {
            int n3 = 0x42D6DB71 ^ 0x42D6DB71;
            try {
                Field[] fieldArray = Opcodes.class.getDeclaredFields();
                int n4 = fieldArray.length;
                for (int i = 0xF6FF8A5F ^ 0xF6FF8A5F; i < n4; ++i) {
                    Field field = fieldArray[i];
                    if (n3 == 0 && !field.getName().equals(string)) continue;
                    n3 = 0xF57D35CB ^ 0xF57D35CA;
                    if (field.getType() != Integer.TYPE || field.getInt(null) != n) continue;
                    return field.getName();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n >= 0 ? String.valueOf(n) : \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("G\ua7c8\ua49e\ua05f\ua92a\u7d41\u8e64");
    }

    public static boolean methodHasLineNumbers(MethodNode methodNode) {
        ListIterator<AbstractInsnNode> listIterator = methodNode.instructions.iterator();
        while (listIterator.hasNext()) {
            if (!(listIterator.next() instanceof LineNumberNode)) continue;
            return (0x3C0996E7 ^ 0x3C0996E6) != 0;
        }
        return (0xD8D20188 ^ 0xD8D20188) != 0;
    }

    public static boolean methodIsStatic(MethodNode methodNode) {
        return ((methodNode.access & (0xDDA4914D ^ 0xDDA49145)) == (0x8F9E1E9C ^ 0x8F9E1E94) ? 0xFC9AB456 ^ 0xFC9AB457 : 0x241D5D89 ^ 0x241D5D89) != 0;
    }

    public static boolean fieldIsStatic(FieldNode fieldNode) {
        return ((fieldNode.access & (0xFB0186CD ^ 0xFB0186C5)) == (0x4F537E61 ^ 0x4F537E69) ? 0xF5C174C5 ^ 0xF5C174C4 : 0x7C68AD20 ^ 0x7C68AD20) != 0;
    }

    public static int getFirstNonArgLocalIndex(MethodNode methodNode) {
        return Bytecode.getFirstNonArgLocalIndex(Type.getArgumentTypes(methodNode.desc), ((methodNode.access & (0x93FA5D37 ^ 0x93FA5D3F)) == 0 ? 0xDF068AC7 ^ 0xDF068AC6 : 0x3DB767D8 ^ 0x3DB767D8) != 0);
    }

    public static int getFirstNonArgLocalIndex(Type[] typeArray, boolean bl) {
        return Bytecode.getArgsSize(typeArray) + (bl ? 0x95575A32 ^ 0x95575A33 : 0x1A9DACDB ^ 0x1A9DACDB);
    }

    public static int getArgsSize(Type[] typeArray) {
        int n = 0x86604A2E ^ 0x86604A2E;
        Type[] typeArray2 = typeArray;
        int n2 = typeArray2.length;
        for (int i = 0x5A205036 ^ 0x5A205036; i < n2; ++i) {
            Type type = typeArray2[i];
            n += type.getSize();
        }
        return n;
    }

    public static void loadArgs(Type[] typeArray, InsnList insnList, int n) {
        Bytecode.loadArgs(typeArray, insnList, n, 0x11756E5B ^ 0xEE8A91A4);
    }

    public static void loadArgs(Type[] typeArray, InsnList insnList, int n, int n2) {
        Bytecode.loadArgs(typeArray, insnList, n, n2, null);
    }

    public static void loadArgs(Type[] typeArray, InsnList insnList, int n, int n2, Type[] typeArray2) {
        int n3 = n;
        int n4 = 0xFA3A64DE ^ 0xFA3A64DE;
        Type[] typeArray3 = typeArray;
        int n5 = typeArray3.length;
        for (int i = 0xCA671B6A ^ 0xCA671B6A; i < n5; ++i) {
            Type type = typeArray3[i];
            insnList.add(new VarInsnNode(type.getOpcode(0x61A2B014 ^ 0x61A2B001), n3));
            if (typeArray2 != null && n4 < typeArray2.length && typeArray2[n4] != null) {
                insnList.add(new TypeInsnNode(0x836765A1 ^ 0x83676561, typeArray2[n4].getInternalName()));
            }
            if (n2 >= n && (n3 += type.getSize()) >= n2) {
                return;
            }
            ++n4;
        }
    }

    public static Map<LabelNode, LabelNode> cloneLabels(InsnList insnList) {
        HashMap<LabelNode, LabelNode> hashMap = new HashMap<LabelNode, LabelNode>();
        ListIterator<AbstractInsnNode> listIterator = insnList.iterator();
        while (listIterator.hasNext()) {
            AbstractInsnNode abstractInsnNode = (AbstractInsnNode)listIterator.next();
            if (!(abstractInsnNode instanceof LabelNode)) continue;
            hashMap.put((LabelNode)abstractInsnNode, new LabelNode(((LabelNode)abstractInsnNode).getLabel()));
        }
        return hashMap;
    }

    public static String generateDescriptor(Object object, Object ... objectArray) {
        StringBuilder stringBuilder = new StringBuilder().append((char)(0x604EEED9 ^ 0x604EEEF1));
        Object[] objectArray2 = objectArray;
        int n = objectArray2.length;
        for (int i = 0xD2BC7E32 ^ 0xD2BC7E32; i < n; ++i) {
            Object object2 = objectArray2[i];
            stringBuilder.append(Bytecode.toDescriptor(object2));
        }
        return stringBuilder.append((char)(0xC2FFD20D ^ 0xC2FFD224)).append(object != null ? Bytecode.toDescriptor(object) : \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("D")).toString();
    }

    private static String toDescriptor(Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Type) {
            return object.toString();
        }
        if (object instanceof Class) {
            return Type.getDescriptor((Class)object);
        }
        return object == null ? \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("") : object.toString();
    }

    public static String getDescriptor(Type[] typeArray) {
        return \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20(":") + Joiner.on((String)\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("")).join((Object[])typeArray) + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20(";");
    }

    public static String getDescriptor(Type[] typeArray, Type type) {
        return Bytecode.getDescriptor(typeArray) + type.toString();
    }

    public static String changeDescriptorReturnType(String string, String string2) {
        if (string == null) {
            return null;
        }
        if (string2 == null) {
            return string;
        }
        return string.substring(0x2321E1F3 ^ 0x2321E1F3, string.lastIndexOf(0x39164CBC ^ 0x39164C95) + (0xAC0C935C ^ 0xAC0C935D)) + string2;
    }

    public static String getSimpleName(Class<? extends Annotation> clazz) {
        return clazz.getSimpleName();
    }

    public static String getSimpleName(AnnotationNode annotationNode) {
        return Bytecode.getSimpleName(annotationNode.desc);
    }

    public static String getSimpleName(String string) {
        int n = Math.max(string.lastIndexOf(0xDD14602A ^ 0xDD146005), 0x69D81CFF ^ 0x69D81CFF);
        return string.substring(n + (0x96A6505C ^ 0x96A6505D)).replace(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20(")"), \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20(""));
    }

    public static boolean isConstant(AbstractInsnNode abstractInsnNode) {
        if (abstractInsnNode == null) {
            return (0xC01D5127 ^ 0xC01D5127) != 0;
        }
        return Ints.contains((int[])CONSTANTS_ALL, (int)abstractInsnNode.getOpcode());
    }

    public static Object getConstant(AbstractInsnNode abstractInsnNode) {
        block5: {
            block7: {
                int n;
                block6: {
                    if (abstractInsnNode == null) {
                        return null;
                    }
                    if (abstractInsnNode instanceof LdcInsnNode) {
                        return ((LdcInsnNode)abstractInsnNode).cst;
                    }
                    if (!(abstractInsnNode instanceof IntInsnNode)) break block5;
                    n = ((IntInsnNode)abstractInsnNode).operand;
                    if (abstractInsnNode.getOpcode() == (0x422834FF ^ 0x422834EF)) break block6;
                    if (abstractInsnNode.getOpcode() != (0x521A24AF ^ 0x521A24BE)) break block7;
                }
                return n;
            }
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("[\ua7e8\ua4a1\ua058\ua90b\u7d65\u8e44\u2454\u8b38\u3473w\ua7a6\ua4a2\ua078\ua911\u7d7e\u8e0a\u2473\u8b39\u3461s\ua7ea\ua4bc\ua075\ua945\u7d79\u8e5a\u2479\u8b38\u3473w\ua7a6") + abstractInsnNode.getOpcode() + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2\ua7ef\ua4bb\ua031\ua902\u7d73\u8e5e\u2459\u8b38\u3479a\ua7f2\ua4b4\ua07f\ua911"));
        }
        int n = Ints.indexOf((int[])CONSTANTS_ALL, (int)abstractInsnNode.getOpcode());
        return n < 0 ? null : CONSTANTS_VALUES[n];
    }

    public static Type getConstantType(AbstractInsnNode abstractInsnNode) {
        if (abstractInsnNode == null) {
            return null;
        }
        if (abstractInsnNode instanceof LdcInsnNode) {
            Object object = ((LdcInsnNode)abstractInsnNode).cst;
            if (object instanceof Integer) {
                return Type.getType(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("["));
            }
            if (object instanceof Float) {
                return Type.getType(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("T"));
            }
            if (object instanceof Long) {
                return Type.getType(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("X"));
            }
            if (object instanceof Double) {
                return Type.getType(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("V"));
            }
            if (object instanceof String) {
                return Type.getType(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("^\ua7ec\ua4b4\ua067\ua904\u7d39\u8e46\u247b\u8b39\u3470=\ua7d5\ua4a1\ua063\ua90c\u7d78\u8e4d\u2421"));
            }
            if (object instanceof Type) {
                return Type.getType(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("^\ua7ec\ua4b4\ua067\ua904\u7d39\u8e46\u247b\u8b39\u3470=\ua7c5\ua4b9\ua070\ua916\u7d65\u8e11"));
            }
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("^\ua7e2\ua4b6\ua058\ua90b\u7d65\u8e44\u2454\u8b38\u3473w\ua7a6\ua4a2\ua078\ua911\u7d7e\u8e0a\u2473\u8b39\u3461s\ua7ea\ua4bc\ua075\ua945\u7d66\u8e4b\u2463\u8b3b\u3478s\ua7e2\ua4f5\ua065\ua91c\u7d66\u8e4f\u243a") + object.getClass() + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2\ua7ef\ua4bb\ua031\ua902\u7d73\u8e5e\u2459\u8b38\u3479a\ua7f2\ua4b4\ua07f\ua911"));
        }
        int n = Ints.indexOf((int[])CONSTANTS_ALL, (int)abstractInsnNode.getOpcode());
        return n < 0 ? null : Type.getType(CONSTANTS_TYPES[n]);
    }

    public static boolean hasFlag(ClassNode classNode, int n) {
        return ((classNode.access & n) == n ? 0x3A771A55 ^ 0x3A771A54 : 0x980C0069 ^ 0x980C0069) != 0;
    }

    public static boolean hasFlag(MethodNode methodNode, int n) {
        return ((methodNode.access & n) == n ? 0x765FB1C ^ 0x765FB1D : 0xD2F67F9B ^ 0xD2F67F9B) != 0;
    }

    public static boolean hasFlag(FieldNode fieldNode, int n) {
        return ((fieldNode.access & n) == n ? 0xC0AF2B0C ^ 0xC0AF2B0D : 0x2482ECFA ^ 0x2482ECFA) != 0;
    }

    public static boolean compareFlags(MethodNode methodNode, MethodNode methodNode2, int n) {
        return (Bytecode.hasFlag(methodNode, n) == Bytecode.hasFlag(methodNode2, n) ? 0x3A76BF9B ^ 0x3A76BF9A : 0x47D659B5 ^ 0x47D659B5) != 0;
    }

    public static boolean compareFlags(FieldNode fieldNode, FieldNode fieldNode2, int n) {
        return (Bytecode.hasFlag(fieldNode, n) == Bytecode.hasFlag(fieldNode2, n) ? 0xDEB94B6D ^ 0xDEB94B6C : 0x1C5B38C2 ^ 0x1C5B38C2) != 0;
    }

    public static Visibility getVisibility(MethodNode methodNode) {
        return Bytecode.getVisibility(methodNode.access & (0xC45E0CCE ^ 0xC45E0CC9));
    }

    public static Visibility getVisibility(FieldNode fieldNode) {
        return Bytecode.getVisibility(fieldNode.access & (0x93E7BB64 ^ 0x93E7BB63));
    }

    private static Visibility getVisibility(int n) {
        if ((n & (0xAF511882 ^ 0xAF511886)) != 0) {
            return Visibility.PROTECTED;
        }
        if ((n & (0xCC32FB8F ^ 0xCC32FB8D)) != 0) {
            return Visibility.PRIVATE;
        }
        if ((n & (0x5ED97F1E ^ 0x5ED97F1F)) != 0) {
            return Visibility.PUBLIC;
        }
        return Visibility.PACKAGE;
    }

    public static void setVisibility(MethodNode methodNode, Visibility visibility) {
        methodNode.access = Bytecode.setVisibility(methodNode.access, visibility.access);
    }

    public static void setVisibility(FieldNode fieldNode, Visibility visibility) {
        fieldNode.access = Bytecode.setVisibility(fieldNode.access, visibility.access);
    }

    public static void setVisibility(MethodNode methodNode, int n) {
        methodNode.access = Bytecode.setVisibility(methodNode.access, n);
    }

    public static void setVisibility(FieldNode fieldNode, int n) {
        fieldNode.access = Bytecode.setVisibility(fieldNode.access, n);
    }

    private static int setVisibility(int n, int n2) {
        return n & (0x336C42EE ^ 0xCC93BD16) | n2 & (0x2C6894A4 ^ 0x2C6894A3);
    }

    public static int getMaxLineNumber(ClassNode classNode, int n, int n2) {
        int n3 = 0x92830286 ^ 0x92830286;
        for (MethodNode methodNode : classNode.methods) {
            ListIterator<AbstractInsnNode> listIterator = methodNode.instructions.iterator();
            while (listIterator.hasNext()) {
                AbstractInsnNode abstractInsnNode = (AbstractInsnNode)listIterator.next();
                if (!(abstractInsnNode instanceof LineNumberNode)) continue;
                n3 = Math.max(n3, ((LineNumberNode)abstractInsnNode).line);
            }
        }
        return Math.max(n, n3 + n2);
    }

    public static String getBoxingType(Type type) {
        return type == null ? null : BOXING_TYPES[type.getSort()];
    }

    public static String getUnboxingMethod(Type type) {
        return type == null ? null : UNBOXING_METHODS[type.getSort()];
    }

    public static void mergeAnnotations(ClassNode classNode, ClassNode classNode2) {
        classNode2.visibleAnnotations = Bytecode.mergeAnnotations(classNode.visibleAnnotations, classNode2.visibleAnnotations, \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("q\ua7ea\ua4b4\ua062\ua916"), classNode.name);
        classNode2.invisibleAnnotations = Bytecode.mergeAnnotations(classNode.invisibleAnnotations, classNode2.invisibleAnnotations, \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("q\ua7ea\ua4b4\ua062\ua916"), classNode.name);
    }

    public static void mergeAnnotations(MethodNode methodNode, MethodNode methodNode2) {
        methodNode2.visibleAnnotations = Bytecode.mergeAnnotations(methodNode.visibleAnnotations, methodNode2.visibleAnnotations, \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("\u007f\ua7e3\ua4a1\ua079\ua90a\u7d72"), methodNode.name);
        methodNode2.invisibleAnnotations = Bytecode.mergeAnnotations(methodNode.invisibleAnnotations, methodNode2.invisibleAnnotations, \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("\u007f\ua7e3\ua4a1\ua079\ua90a\u7d72"), methodNode.name);
    }

    public static void mergeAnnotations(FieldNode fieldNode, FieldNode fieldNode2) {
        fieldNode2.visibleAnnotations = Bytecode.mergeAnnotations(fieldNode.visibleAnnotations, fieldNode2.visibleAnnotations, \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("t\ua7ef\ua4b0\ua07d\ua901"), fieldNode.name);
        fieldNode2.invisibleAnnotations = Bytecode.mergeAnnotations(fieldNode.invisibleAnnotations, fieldNode2.invisibleAnnotations, \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("t\ua7ef\ua4b0\ua07d\ua901"), fieldNode.name);
    }

    private static List<AnnotationNode> mergeAnnotations(List<AnnotationNode> list, List<AnnotationNode> list2, String string, String string2) {
        try {
            if (list == null) {
                return list2;
            }
            if (list2 == null) {
                list2 = new ArrayList<AnnotationNode>();
            }
            for (AnnotationNode annotationNode : list) {
                if (!Bytecode.isMergeableAnnotation(annotationNode)) continue;
                Iterator<AnnotationNode> iterator = list2.iterator();
                while (iterator.hasNext()) {
                    if (!iterator.next().desc.equals(annotationNode.desc)) continue;
                    iterator.remove();
                    break;
                }
                list2.add(annotationNode);
            }
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[0xC5657B14 ^ 0xC5657B16];
            objectArray[0x481CEA33 ^ 0x481CEA33] = string;
            objectArray[0x404F5FFE ^ 0x404F5FFF] = string2;
            logger.warn(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("W\ua7fe\ua4b6\ua074\ua915\u7d62\u8e43\u2475\u8b39\u3437w\ua7e8\ua4b6\ua07e\ua910\u7d78\u8e5e\u247f\u8b25\u3472v\ua7a6\ua4a2\ua079\ua90c\u7d7a\u8e59\u246e\u8b77\u347aw\ua7f4\ua4b2\ua078\ua90b\u7d71\u8e0a\u247b\u8b39\u3479}\ua7f2\ua4b4\ua065\ua90c\u7d79\u8e44\u2469\u8b77\u3471}\ua7f4\ua4f5\ua06a\ua918\u7d36\u8e51\u2467"), objectArray);
        }
        return list2;
    }

    private static boolean isMergeableAnnotation(AnnotationNode annotationNode) {
        if (annotationNode.desc.startsWith(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("^") + Constants.MIXIN_PACKAGE_REF)) {
            return mergeableAnnotationPattern.matcher(annotationNode.desc).matches();
        }
        return (0x907EC5FA ^ 0x907EC5FB) != 0;
    }

    private static Pattern getMergeableAnnotationPattern() {
        StringBuilder stringBuilder = new StringBuilder(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("L\ua7ca\ua4fd"));
        for (int i = 0xDB2909B7 ^ 0xDB2909B7; i < MERGEABLE_MIXIN_ANNOTATIONS.length; ++i) {
            if (i > 0) {
                stringBuilder.append((char)(0x64417A6F ^ 0x64417A13));
            }
            stringBuilder.append(MERGEABLE_MIXIN_ANNOTATIONS[i].getName().replace((char)(0x410D5DD0 ^ 0x410D5DFE), (char)(0x26ABB3A2 ^ 0x26ABB38D)));
        }
        return Pattern.compile(stringBuilder.append(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20(";\ua7bd\ua4f1")).toString());
    }

    public static void compareBridgeMethods(MethodNode methodNode, MethodNode methodNode2) {
        ListIterator<AbstractInsnNode> listIterator = methodNode.instructions.iterator();
        ListIterator<AbstractInsnNode> listIterator2 = methodNode2.instructions.iterator();
        int n = 0x1C26AC29 ^ 0x1C26AC29;
        while (listIterator.hasNext() && listIterator2.hasNext()) {
            AbstractInsnNode abstractInsnNode = listIterator.next();
            AbstractInsnNode abstractInsnNode2 = listIterator2.next();
            if (!(abstractInsnNode instanceof LabelNode)) {
                AbstractInsnNode abstractInsnNode3;
                AbstractInsnNode abstractInsnNode4;
                if (abstractInsnNode instanceof MethodInsnNode) {
                    abstractInsnNode4 = (MethodInsnNode)abstractInsnNode;
                    abstractInsnNode3 = (MethodInsnNode)abstractInsnNode2;
                    if (!((MethodInsnNode)abstractInsnNode4).name.equals(abstractInsnNode3.name)) {
                        throw new SyntheticBridgeException(SyntheticBridgeException.Problem.BAD_INVOKE_NAME, methodNode.name, methodNode.desc, n, abstractInsnNode, abstractInsnNode2);
                    }
                    if (!((MethodInsnNode)abstractInsnNode4).desc.equals(abstractInsnNode3.desc)) {
                        throw new SyntheticBridgeException(SyntheticBridgeException.Problem.BAD_INVOKE_DESC, methodNode.name, methodNode.desc, n, abstractInsnNode, abstractInsnNode2);
                    }
                } else {
                    if (abstractInsnNode.getOpcode() != abstractInsnNode2.getOpcode()) {
                        throw new SyntheticBridgeException(SyntheticBridgeException.Problem.BAD_INSN, methodNode.name, methodNode.desc, n, abstractInsnNode, abstractInsnNode2);
                    }
                    if (abstractInsnNode instanceof VarInsnNode) {
                        abstractInsnNode4 = (VarInsnNode)abstractInsnNode;
                        abstractInsnNode3 = (VarInsnNode)abstractInsnNode2;
                        if (((VarInsnNode)abstractInsnNode4).var != ((VarInsnNode)abstractInsnNode3).var) {
                            throw new SyntheticBridgeException(SyntheticBridgeException.Problem.BAD_LOAD, methodNode.name, methodNode.desc, n, abstractInsnNode, abstractInsnNode2);
                        }
                    } else if (abstractInsnNode instanceof TypeInsnNode) {
                        abstractInsnNode4 = (TypeInsnNode)abstractInsnNode;
                        abstractInsnNode3 = (TypeInsnNode)abstractInsnNode2;
                        if (abstractInsnNode4.getOpcode() == (0xA4DA41BE ^ 0xA4DA417E) && !((TypeInsnNode)abstractInsnNode4).desc.equals(((TypeInsnNode)abstractInsnNode3).desc)) {
                            throw new SyntheticBridgeException(SyntheticBridgeException.Problem.BAD_CAST, methodNode.name, methodNode.desc, n, abstractInsnNode, abstractInsnNode2);
                        }
                    }
                }
            }
            ++n;
        }
        if (listIterator.hasNext() || listIterator2.hasNext()) {
            throw new SyntheticBridgeException(SyntheticBridgeException.Problem.BAD_LENGTH, methodNode.name, methodNode.desc, n, null, null);
        }
    }

    static {
        int[] nArray = new int[0xAE3EA381 ^ 0xAE3EA386];
        nArray[0xE1E48971 ^ 0xE1E48971] = 0x941F8B24 ^ 0x941F8B26;
        nArray[0x30B16200 ^ 0x30B16201] = 0x241A88C3 ^ 0x241A88C0;
        nArray[0xBCC36954 ^ 0xBCC36956] = 0xCC0863D4 ^ 0xCC0863D0;
        nArray[0xDE345276 ^ 0xDE345275] = 0x9EB86D9F ^ 0x9EB86D9A;
        nArray[0x629E08A0 ^ 0x629E08A4] = 0x81F7E75E ^ 0x81F7E758;
        nArray[0x5580014E ^ 0x5580014B] = 0xB16150A4 ^ 0xB16150A3;
        nArray[0x911CC788 ^ 0x911CC78E] = 0x3CD4568F ^ 0x3CD45687;
        CONSTANTS_INT = nArray;
        int[] nArray2 = new int[0xB2529D9B ^ 0xB2529D98];
        nArray2[0xBE943F1F ^ 0xBE943F1F] = 0xA2E1C037 ^ 0xA2E1C03C;
        nArray2[0xD7C762BC ^ 0xD7C762BD] = 0x9BD056D7 ^ 0x9BD056DB;
        nArray2[0x118A423D ^ 0x118A423F] = 0x5364F845 ^ 0x5364F848;
        CONSTANTS_FLOAT = nArray2;
        int[] nArray3 = new int[0x5E63B968 ^ 0x5E63B96A];
        nArray3[0x37954F29 ^ 0x37954F29] = 0x43846574 ^ 0x4384657A;
        nArray3[0x62013EC5 ^ 0x62013EC4] = 0x26E28CC9 ^ 0x26E28CC6;
        CONSTANTS_DOUBLE = nArray3;
        int[] nArray4 = new int[0xF3B717EA ^ 0xF3B717E8];
        nArray4[0x6A666AA7 ^ 0x6A666AA7] = 0xA81D1CC ^ 0xA81D1C5;
        nArray4[0xFD4343CD ^ 0xFD4343CC] = 0x72C48A0E ^ 0x72C48A04;
        CONSTANTS_LONG = nArray4;
        int[] nArray5 = new int[0xA853FEA2 ^ 0xA853FEB0];
        nArray5[0x1AF9F465 ^ 0x1AF9F465] = 0xFBDDA147 ^ 0xFBDDA146;
        nArray5[0xC5528B27 ^ 0xC5528B26] = 0x83B30624 ^ 0x83B30626;
        nArray5[0x2700E4B4 ^ 0x2700E4B6] = 0x2C6B8B72 ^ 0x2C6B8B71;
        nArray5[0x59419694 ^ 0x59419697] = 0x488EE18B ^ 0x488EE18F;
        nArray5[0xCF82B102 ^ 0xCF82B106] = 0x8020F897 ^ 0x8020F892;
        nArray5[0xA0097F88 ^ 0xA0097F8D] = 0xD9056EB2 ^ 0xD9056EB4;
        nArray5[0xE6A7B547 ^ 0xE6A7B541] = 0xF2253F39 ^ 0xF2253F3E;
        nArray5[0x78AE967A ^ 0x78AE967D] = 0x52AF82E0 ^ 0x52AF82E8;
        nArray5[0xDF95BE6E ^ 0xDF95BE66] = 0x76C54E0F ^ 0x76C54E06;
        nArray5[0x7399A4F9 ^ 0x7399A4F0] = 0xD5DA61FB ^ 0xD5DA61F1;
        nArray5[0x5485B308 ^ 0x5485B302] = 0xEB6ED919 ^ 0xEB6ED912;
        nArray5[0xCCEB8606 ^ 0xCCEB860D] = 0x10A0F94C ^ 0x10A0F940;
        nArray5[0x8C8111E0 ^ 0x8C8111EC] = 0xFB292B43 ^ 0xFB292B4E;
        nArray5[0x300EE5F1 ^ 0x300EE5FC] = 0xCF9481B4 ^ 0xCF9481BA;
        nArray5[0x32960 ^ 0x3296E] = 0xF73F3138 ^ 0xF73F3137;
        nArray5[0x676BA878 ^ 0x676BA877] = 0xDDA0159E ^ 0xDDA0158E;
        nArray5[0xB231599A ^ 0xB231598A] = 0x1C3F779F ^ 0x1C3F778E;
        nArray5[0xD168D756 ^ 0xD168D747] = 0x830D7ED3 ^ 0x830D7EC1;
        CONSTANTS_ALL = nArray5;
        Object[] objectArray = new Object[0x6683F6AE ^ 0x6683F6A1];
        objectArray[0xBED83706 ^ 0xBED83706] = null;
        objectArray[0x7A40F42A ^ 0x7A40F42B] = 0xB317CF28 ^ 0x4CE830D7;
        objectArray[0x21330190 ^ 0x21330192] = 0xE21EFF8D ^ 0xE21EFF8D;
        objectArray[0xB37B925C ^ 0xB37B925F] = 0x83ADBB99 ^ 0x83ADBB98;
        objectArray[0x3702754B ^ 0x3702754F] = 0xD523FAEA ^ 0xD523FAE8;
        objectArray[0x86CCA404 ^ 0x86CCA401] = 0x7DDBDB7C ^ 0x7DDBDB7F;
        objectArray[0xBC64DE1 ^ 0xBC64DE7] = 0xFC54BFD5 ^ 0xFC54BFD1;
        objectArray[0x5041210B ^ 0x5041210C] = 0x93FF9FC0 ^ 0x93FF9FC5;
        objectArray[0x21692D17 ^ 0x21692D1F] = 0x5B17E68DECD59D99L ^ 0x5B17E68DECD59D99L;
        objectArray[0xCC730C2F ^ 0xCC730C26] = 0x560415E0ACCB2679L ^ 0x560415E0ACCB2678L;
        objectArray[0x309E2C36 ^ 0x309E2C3C] = Float.valueOf(0.0f);
        objectArray[0xA192ED18 ^ 0xA192ED13] = Float.valueOf(1.0f);
        objectArray[0xCD281BA3 ^ 0xCD281BAF] = Float.valueOf(2.0f);
        objectArray[0x178946FA ^ 0x178946F7] = 0.0;
        objectArray[0x41C119BC ^ 0x41C119B2] = 1.0;
        CONSTANTS_VALUES = objectArray;
        String[] stringArray = new String[0x4FEA5CCD ^ 0x4FEA5CDC];
        stringArray[0x3A5CAC7F ^ 0x3A5CAC7F] = null;
        stringArray[0xD5D71B7D ^ 0xD5D71B7C] = \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("[");
        stringArray[0x666B96D7 ^ 0x666B96D5] = \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("[");
        stringArray[0xF702EE6B ^ 0xF702EE68] = \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("[");
        stringArray[0x35684344 ^ 0x35684340] = \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("[");
        stringArray[0xF999A15 ^ 0xF999A10] = \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("[");
        stringArray[0xBC2CD2B7 ^ 0xBC2CD2B1] = \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("[");
        stringArray[0x44A8141C ^ 0x44A8141B] = \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("[");
        stringArray[0xDC7FB1A2 ^ 0xDC7FB1AA] = \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("X");
        stringArray[0xA0DB8A58 ^ 0xA0DB8A51] = \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("X");
        stringArray[0xD6DEA0E9 ^ 0xD6DEA0E3] = \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("T");
        stringArray[0xAB077060 ^ 0xAB07706B] = \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("T");
        stringArray[0xB2BBD55A ^ 0xB2BBD556] = \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("T");
        stringArray[0x2E4AB3FD ^ 0x2E4AB3F0] = \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("V");
        stringArray[0x926F23C6 ^ 0x926F23C8] = \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("V");
        stringArray[0xD948626D ^ 0xD9486262] = \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("[");
        stringArray[0x9B5EED20 ^ 0x9B5EED30] = \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("[");
        CONSTANTS_TYPES = stringArray;
        String[] stringArray2 = new String[0x8CE3DA00 ^ 0x8CE3DA0C];
        stringArray2[0x7F7F49EA ^ 0x7F7F49EA] = null;
        stringArray2[0x69AB7AC3 ^ 0x69AB7AC2] = \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438P\ua7e9\ua4ba\ua07d\ua900\u7d77\u8e44");
        stringArray2[0x4B58CA47 ^ 0x4B58CA45] = \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438Q\ua7ee\ua4b4\ua063\ua904\u7d75\u8e5e\u247f\u8b25");
        stringArray2[0x2D9D65A3 ^ 0x2D9D65A0] = \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438P\ua7ff\ua4a1\ua074");
        stringArray2[0xA8283178 ^ 0xA828317C] = \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438A\ua7ee\ua4ba\ua063\ua911");
        stringArray2[0xE5D09B5D ^ 0xE5D09B58] = \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438[\ua7e8\ua4a1\ua074\ua902\u7d73\u8e58");
        stringArray2[0xE5BB984C ^ 0xE5BB984A] = \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438T\ua7ea\ua4ba\ua070\ua911");
        stringArray2[0x4561FE4D ^ 0x4561FE4A] = \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438^\ua7e9\ua4bb\ua076");
        stringArray2[0xAD225C81 ^ 0xAD225C89] = \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438V\ua7e9\ua4a0\ua073\ua909\u7d73");
        stringArray2[0x6C4CA34 ^ 0x6C4CA3D] = null;
        stringArray2[0x7FB31B0C ^ 0x7FB31B06] = null;
        stringArray2[0xD8358D77 ^ 0xD8358D7C] = null;
        BOXING_TYPES = stringArray2;
        String[] stringArray3 = new String[0x3E2E435E ^ 0x3E2E4352];
        stringArray3[0xC650D7C7 ^ 0xC650D7C7] = null;
        stringArray3[0x27C4EA78 ^ 0x27C4EA79] = \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("p\ua7e9\ua4ba\ua07d\ua900\u7d77\u8e44\u244c\u8b36\u347bg\ua7e3");
        stringArray3[0x8D49A52A ^ 0x8D49A528] = \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("q\ua7ee\ua4b4\ua063\ua933\u7d77\u8e46\u246f\u8b32");
        stringArray3[0x1D4AD691 ^ 0x1D4AD692] = \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("p\ua7ff\ua4a1\ua074\ua933\u7d77\u8e46\u246f\u8b32");
        stringArray3[0xE21717E9 ^ 0xE21717ED] = \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("a\ua7ee\ua4ba\ua063\ua911\u7d40\u8e4b\u2476\u8b22\u3472");
        stringArray3[0x3AA5EAFF ^ 0x3AA5EAFA] = \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("{\ua7e8\ua4a1\ua047\ua904\u7d7a\u8e5f\u247f");
        stringArray3[0x302DEDF4 ^ 0x302DEDF2] = \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("t\ua7ea\ua4ba\ua070\ua911\u7d40\u8e4b\u2476\u8b22\u3472");
        stringArray3[0x1102963C ^ 0x1102963B] = \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("~\ua7e9\ua4bb\ua076\ua933\u7d77\u8e46\u246f\u8b32");
        stringArray3[0x13D04F89 ^ 0x13D04F81] = \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("v\ua7e9\ua4a0\ua073\ua909\u7d73\u8e7c\u247b\u8b3b\u3462w");
        stringArray3[0xC30D0877 ^ 0xC30D087E] = null;
        stringArray3[0xEC5920D2 ^ 0xEC5920D8] = null;
        stringArray3[0x9046CBEF ^ 0x9046CBE4] = null;
        UNBOXING_METHODS = stringArray3;
        Class[] classArray = new Class[0xAC91118D ^ 0xAC911189];
        classArray[0xFB59C31 ^ 0xFB59C31] = Overwrite.class;
        classArray[0xAFA47A03 ^ 0xAFA47A02] = Intrinsic.class;
        classArray[0xE087DC5D ^ 0xE087DC5F] = Final.class;
        classArray[0x7902A2A9 ^ 0x7902A2AA] = Debug.class;
        MERGEABLE_MIXIN_ANNOTATIONS = classArray;
        mergeableAnnotationPattern = Bytecode.getMergeableAnnotationPattern();
        logger = LogManager.getLogger((String)\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("\u007f\ua7ef\ua4ad\ua078\ua90b"));
    }

    public static final class Visibility
    extends Enum<Visibility> {
        public static final /* enum */ Visibility PRIVATE = new Visibility(0x14329E04 ^ 0x14329E06);
        public static final /* enum */ Visibility PROTECTED = new Visibility(0x7839BEBA ^ 0x7839BEBE);
        public static final /* enum */ Visibility PACKAGE = new Visibility(0xF3BB5DC8 ^ 0xF3BB5DC8);
        public static final /* enum */ Visibility PUBLIC = new Visibility(0x2B270524 ^ 0x2B270525);
        static final int MASK = 7;
        final int access;
        private static final /* synthetic */ Visibility[] $VALUES;

        public static Visibility[] values() {
            return (Visibility[])$VALUES.clone();
        }

        public static Visibility valueOf(String string) {
            return Enum.valueOf(Visibility.class, string);
        }

        private Visibility(int n2) {
            this.access = n2;
        }

        static {
            Visibility[] visibilityArray = new Visibility[0xDFEAC622 ^ 0xDFEAC626];
            visibilityArray[0x825D44D2 ^ 0x825D44D2] = PRIVATE;
            visibilityArray[0xD0879AA5 ^ 0xD0879AA4] = PROTECTED;
            visibilityArray[0x8AC73BE6 ^ 0x8AC73BE4] = PACKAGE;
            visibilityArray[0x5DF901A9 ^ 0x5DF901AA] = PUBLIC;
            $VALUES = visibilityArray;
        }
    }
}

