/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.util;

import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.spongepowered.asm.lib.signature.SignatureReader;
import org.spongepowered.asm.lib.signature.SignatureVisitor;
import org.spongepowered.asm.lib.signature.SignatureWriter;
import org.spongepowered.asm.lib.tree.ClassNode;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2;

public class ClassSignature {
    protected static final String OBJECT = "java/lang/Object";
    private final Map<TypeVar, TokenHandle> types = new LinkedHashMap<TypeVar, TokenHandle>();
    private Token superClass = new Token(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438]\ua7e4\ua4bf\ua074\ua906\u7d62"));
    private final List<Token> interfaces = new ArrayList<Token>();
    private final Deque<String> rawInterfaces = new LinkedList<String>();

    ClassSignature() {
    }

    private ClassSignature read(String string) {
        if (string != null) {
            try {
                new SignatureReader(string).accept(new SignatureParser());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return this;
    }

    protected TypeVar getTypeVar(String string) {
        for (TypeVar typeVar : this.types.keySet()) {
            if (!typeVar.matches(string)) continue;
            return typeVar;
        }
        return null;
    }

    protected TokenHandle getType(String string) {
        for (TypeVar typeVar : this.types.keySet()) {
            if (!typeVar.matches(string)) continue;
            return this.types.get(typeVar);
        }
        TokenHandle tokenHandle = new TokenHandle();
        this.types.put(new TypeVar(string), tokenHandle);
        return tokenHandle;
    }

    protected String getTypeVar(TokenHandle tokenHandle) {
        for (Map.Entry<TypeVar, TokenHandle> entry : this.types.entrySet()) {
            TypeVar typeVar = entry.getKey();
            TokenHandle tokenHandle2 = entry.getValue();
            if (tokenHandle != tokenHandle2 && tokenHandle.asToken() != tokenHandle2.asToken()) continue;
            return \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("F") + typeVar + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20(")");
        }
        return tokenHandle.token.asType();
    }

    protected void addTypeVar(TypeVar typeVar, TokenHandle tokenHandle) throws IllegalArgumentException {
        if (this.types.containsKey(typeVar)) {
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("F\ua7ff\ua4a5\ua074\ua933\u7d77\u8e58\u243a") + typeVar + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2\ua7ef\ua4a6\ua031\ua904\u7d7a\u8e58\u247f\u8b36\u3473k\ua7a6\ua4a5\ua063\ua900\u7d65\u8e4f\u2474\u8b23\u3437}\ua7e8\ua4f5") + this);
        }
        this.types.put(typeVar, tokenHandle);
    }

    protected void setSuperClass(Token token) {
        this.superClass = token;
    }

    public String getSuperClass() {
        return this.superClass.asType((0xCBB6BF9A ^ 0xCBB6BF9B) != 0);
    }

    protected void addInterface(Token token) {
        if (!token.isRaw()) {
            String string = token.asType((0x35CF1F85 ^ 0x35CF1F84) != 0);
            ListIterator<Token> listIterator = this.interfaces.listIterator();
            while (listIterator.hasNext()) {
                Token token2 = listIterator.next();
                if (!token2.isRaw()) continue;
                if (!token2.asType((0x1E84B0DA ^ 0x1E84B0DB) != 0).equals(string)) continue;
                listIterator.set(token);
                return;
            }
        }
        this.interfaces.add(token);
    }

    public void addInterface(String string) {
        this.rawInterfaces.add(string);
    }

    protected void addRawInterface(String string) {
        Token token = new Token(string);
        String string2 = token.asType((0xBB4046C6 ^ 0xBB4046C7) != 0);
        for (Token token2 : this.interfaces) {
            if (!token2.asType((0x250FC592 ^ 0x250FC593) != 0).equals(string2)) continue;
            return;
        }
        this.interfaces.add(token);
    }

    public void merge(ClassSignature classSignature) {
        try {
            Iterator<Token> iterator = new HashSet<String>();
            for (TypeVar typeVar : this.types.keySet()) {
                iterator.add((Token)((Object)typeVar.toString()));
            }
            classSignature.conform((Set<String>)((Object)iterator));
        }
        catch (IllegalStateException illegalStateException) {
            illegalStateException.printStackTrace();
            return;
        }
        for (Map.Entry entry : classSignature.types.entrySet()) {
            this.addTypeVar((TypeVar)entry.getKey(), (TokenHandle)entry.getValue());
        }
        for (Token token : classSignature.interfaces) {
            this.addInterface(token);
        }
    }

    private void conform(Set<String> set) {
        for (TypeVar typeVar : this.types.keySet()) {
            String string = this.findUniqueName(typeVar.getOriginalName(), set);
            typeVar.rename(string);
            set.add(string);
        }
    }

    private String findUniqueName(String string, Set<String> set) {
        String string2;
        if (!set.contains(string)) {
            return string;
        }
        if (string.length() == (0x962C51E7 ^ 0x962C51E6)) {
            string2 = this.findOffsetName(string.charAt(0x33204DC6 ^ 0x33204DC6), set);
            if (string2 != null) {
                return string2;
            }
        }
        if ((string2 = this.findOffsetName((char)(0x17DE05B5 ^ 0x17DE05E1), set, \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20(""), string)) != null) {
            return string2;
        }
        string2 = this.findOffsetName((char)(0xEBBA3E94 ^ 0xEBBA3EC0), set, string, \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20(""));
        if (string2 != null) {
            return string2;
        }
        string2 = this.findOffsetName((char)(0x1AE60F26 ^ 0x1AE60F72), set, \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("F"), string);
        if (string2 != null) {
            return string2;
        }
        string2 = this.findOffsetName((char)(0x9957D85C ^ 0x9957D808), set, \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20(""), string + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("F\ua7ff\ua4a5\ua074"));
        if (string2 != null) {
            return string2;
        }
        throw new IllegalStateException(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("T\ua7e7\ua4bc\ua07d\ua900\u7d72\u8e0a\u246e\u8b38\u3437q\ua7e9\ua4bb\ua077\ua90a\u7d64\u8e47\u243a\u8b23\u346eb\ua7e3\ua4f5\ua067\ua904\u7d64\u8e10\u243a") + string);
    }

    private String findOffsetName(char c, Set<String> set) {
        return this.findOffsetName(c, set, \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20(""), \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20(""));
    }

    private String findOffsetName(char c, Set<String> set, String string, String string2) {
        Object[] objectArray = new Object[0x8F0CBDC9 ^ 0x8F0CBDCA];
        objectArray[0xF21F4E64 ^ 0xF21F4E64] = string;
        objectArray[0xFFDF2199 ^ 0xFFDF2198] = Character.valueOf(c);
        objectArray[0xDE4729D9 ^ 0xDE4729DB] = string2;
        String string3 = String.format(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("7\ua7f5\ua4f0\ua062\ua940\u7d65"), objectArray);
        if (!set.contains(string3)) {
            return string3;
        }
        if (c > (0x739351F0 ^ 0x739351B0)) {
            if (c < (0xC953667A ^ 0xC9536621)) {
                int n = c - (0x8336C0DA ^ 0x8336C09A);
                while (true) {
                    if (n + (0x337BDCEE ^ 0x337BDCAF) == c) break;
                    Object[] objectArray2 = new Object[0x756275C6 ^ 0x756275C5];
                    objectArray2[0x1A06B928 ^ 0x1A06B928] = string;
                    objectArray2[0x19B711BF ^ 0x19B711BE] = Character.valueOf((char)(n + (0xF618C0E7 ^ 0xF618C0A6)));
                    objectArray2[0x50EC20A ^ 0x50EC208] = string2;
                    string3 = String.format(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("7\ua7f5\ua4f0\ua062\ua940\u7d65"), objectArray2);
                    if (!set.contains(string3)) {
                        return string3;
                    }
                    ++n;
                    n %= 0xB73188DC ^ 0xB73188C6;
                }
            }
        }
        return null;
    }

    public SignatureVisitor getRemapper() {
        return new SignatureRemapper();
    }

    public String toString() {
        while (this.rawInterfaces.size() > 0) {
            this.addRawInterface(this.rawInterfaces.remove());
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (this.types.size() > 0) {
            int n = 0x49655383 ^ 0x49655383;
            StringBuilder object = new StringBuilder();
            for (Map.Entry<TypeVar, TokenHandle> entry : this.types.entrySet()) {
                String string = entry.getValue().asBound();
                if (string.isEmpty()) continue;
                object.append(entry.getKey()).append((char)(0x11218880 ^ 0x112188BA)).append(string);
                n = 0xC7D067BF ^ 0xC7D067BE;
            }
            if (n != 0) {
                stringBuilder.append((char)(0xA940267E ^ 0xA9402642)).append((CharSequence)object).append((char)(0xA66ABD6 ^ 0xA66ABE8));
            }
        }
        stringBuilder.append(this.superClass.asType());
        for (Token token : this.interfaces) {
            stringBuilder.append(token.asType());
        }
        return stringBuilder.toString();
    }

    public ClassSignature wake() {
        return this;
    }

    public static ClassSignature of(String string) {
        return new ClassSignature().read(string);
    }

    public static ClassSignature of(ClassNode classNode) {
        if (classNode.signature != null) {
            return ClassSignature.of(classNode.signature);
        }
        return ClassSignature.generate(classNode);
    }

    public static ClassSignature ofLazy(ClassNode classNode) {
        if (classNode.signature != null) {
            return new Lazy(classNode.signature);
        }
        return ClassSignature.generate(classNode);
    }

    private static ClassSignature generate(ClassNode classNode) {
        ClassSignature classSignature = new ClassSignature();
        classSignature.setSuperClass(new Token(classNode.superName != null ? classNode.superName : \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438]\ua7e4\ua4bf\ua074\ua906\u7d62")));
        for (String string : classNode.interfaces) {
            classSignature.addInterface(new Token(string));
        }
        return classSignature;
    }

    class SignatureRemapper
    extends SignatureWriter {
        private final Set<String> localTypeVars = new HashSet<String>();

        SignatureRemapper() {
        }

        @Override
        public void visitFormalTypeParameter(String string) {
            this.localTypeVars.add(string);
            super.visitFormalTypeParameter(string);
        }

        @Override
        public void visitTypeVariable(String string) {
            TypeVar typeVar;
            if (!this.localTypeVars.contains(string) && (typeVar = ClassSignature.this.getTypeVar(string)) != null) {
                super.visitTypeVariable(typeVar.toString());
                return;
            }
            super.visitTypeVariable(string);
        }
    }

    class SignatureParser
    extends SignatureVisitor {
        private FormalParamElement param;

        SignatureParser() {
            super(0x7C38B033 ^ 0x7C3DB033);
        }

        @Override
        public void visitFormalTypeParameter(String string) {
            this.param = new FormalParamElement(string);
        }

        @Override
        public SignatureVisitor visitClassBound() {
            return this.param.visitClassBound();
        }

        @Override
        public SignatureVisitor visitInterfaceBound() {
            return this.param.visitInterfaceBound();
        }

        @Override
        public SignatureVisitor visitSuperclass() {
            return new SuperClassElement();
        }

        @Override
        public SignatureVisitor visitInterface() {
            return new InterfaceElement();
        }

        class InterfaceElement
        extends TokenElement {
            InterfaceElement() {
            }

            @Override
            public void visitEnd() {
                ClassSignature.this.addInterface(this.token);
            }
        }

        class SuperClassElement
        extends TokenElement {
            SuperClassElement() {
            }

            @Override
            public void visitEnd() {
                ClassSignature.this.setSuperClass(this.token);
            }
        }

        class BoundElement
        extends TokenElement {
            private final TokenElement type;
            private final boolean classBound;

            BoundElement(TokenElement tokenElement, boolean bl) {
                this.type = tokenElement;
                this.classBound = bl;
            }

            @Override
            public void visitClassType(String string) {
                this.token = this.type.token.addBound(string, this.classBound);
            }

            @Override
            public void visitTypeArgument() {
                this.token.addTypeArgument((char)(0xC94310C2 ^ 0xC94310E8));
            }

            @Override
            public SignatureVisitor visitTypeArgument(char c) {
                return new TypeArgElement(this, c);
            }
        }

        class TypeArgElement
        extends TokenElement {
            private final TokenElement type;
            private final char wildcard;

            TypeArgElement(TokenElement tokenElement, char c) {
                this.type = tokenElement;
                this.wildcard = c;
            }

            @Override
            public SignatureVisitor visitArrayType() {
                this.type.setArray();
                return this;
            }

            @Override
            public void visitBaseType(char c) {
                this.token = this.type.addTypeArgument(c).asToken();
            }

            @Override
            public void visitTypeVariable(String string) {
                TokenHandle tokenHandle = ClassSignature.this.getType(string);
                this.token = this.type.addTypeArgument(tokenHandle).setWildcard(this.wildcard).asToken();
            }

            @Override
            public void visitClassType(String string) {
                this.token = this.type.addTypeArgument(string).setWildcard(this.wildcard).asToken();
            }

            @Override
            public void visitTypeArgument() {
                this.token.addTypeArgument((char)(0x8A86181 ^ 0x8A861AB));
            }

            @Override
            public SignatureVisitor visitTypeArgument(char c) {
                return new TypeArgElement(this, c);
            }

            @Override
            public void visitEnd() {
            }
        }

        class FormalParamElement
        extends TokenElement {
            private final TokenHandle handle;

            FormalParamElement(String string) {
                this.handle = ClassSignature.this.getType(string);
                this.token = this.handle.asToken();
            }
        }

        abstract class TokenElement
        extends SignatureElement {
            protected Token token;
            private boolean array;

            TokenElement() {
            }

            public Token getToken() {
                if (this.token == null) {
                    this.token = new Token();
                }
                return this.token;
            }

            protected void setArray() {
                this.array = 0x855C67D3 ^ 0x855C67D2;
            }

            private boolean getArray() {
                boolean bl = this.array;
                this.array = 0x4577FE19 ^ 0x4577FE19;
                return bl;
            }

            @Override
            public void visitClassType(String string) {
                this.getToken().setType(string);
            }

            @Override
            public SignatureVisitor visitClassBound() {
                this.getToken();
                return new BoundElement(this, (0x90A6CE0 ^ 0x90A6CE1) != 0);
            }

            @Override
            public SignatureVisitor visitInterfaceBound() {
                this.getToken();
                return new BoundElement(this, (0xAD877DE7 ^ 0xAD877DE7) != 0);
            }

            @Override
            public void visitInnerClassType(String string) {
                this.token.addInnerClass(string);
            }

            @Override
            public SignatureVisitor visitArrayType() {
                this.setArray();
                return this;
            }

            @Override
            public SignatureVisitor visitTypeArgument(char c) {
                return new TypeArgElement(this, c);
            }

            Token addTypeArgument() {
                return this.token.addTypeArgument((char)(0xFEC46F98 ^ 0xFEC46FB2)).asToken();
            }

            IToken addTypeArgument(char c) {
                return this.token.addTypeArgument(c).setArray(this.getArray());
            }

            IToken addTypeArgument(String string) {
                return this.token.addTypeArgument(string).setArray(this.getArray());
            }

            IToken addTypeArgument(Token token) {
                return this.token.addTypeArgument(token).setArray(this.getArray());
            }

            IToken addTypeArgument(TokenHandle tokenHandle) {
                return this.token.addTypeArgument(tokenHandle).setArray(this.getArray());
            }
        }

        abstract class SignatureElement
        extends SignatureVisitor {
            public SignatureElement() {
                super(0x9E6DDB2C ^ 0x9E68DB2C);
            }
        }
    }

    class TokenHandle
    implements IToken {
        final Token token;
        boolean array;
        char wildcard;

        TokenHandle() {
            this(new Token());
        }

        TokenHandle(Token token) {
            this.token = token;
        }

        @Override
        public IToken setArray(boolean bl) {
            this.array |= bl;
            return this;
        }

        @Override
        public IToken setWildcard(char c) {
            if (\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("9\ua7ab").indexOf(c) > (0x75752671 ^ 0x8A8AD98E)) {
                this.wildcard = c;
            }
            return this;
        }

        @Override
        public String asBound() {
            return this.token.asBound();
        }

        @Override
        public String asType() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.wildcard > '\u0000') {
                stringBuilder.append(this.wildcard);
            }
            if (this.array) {
                stringBuilder.append((char)(0x546E09C4 ^ 0x546E099F));
            }
            return stringBuilder.append(ClassSignature.this.getTypeVar(this)).toString();
        }

        @Override
        public Token asToken() {
            return this.token;
        }

        public String toString() {
            return this.token.toString();
        }

        public TokenHandle clone() {
            return new TokenHandle(this.token);
        }
    }

    static class Token
    implements IToken {
        static final String SYMBOLS = "+-*";
        private final boolean inner;
        private boolean array;
        private char symbol = (char)(0xEE95A4C8 ^ 0xEE95A4C8);
        private String type;
        private List<Token> classBound;
        private List<Token> ifaceBound;
        private List<IToken> signature;
        private List<IToken> suffix;
        private Token tail;

        Token() {
            this((0xEC8C31CC ^ 0xEC8C31CC) != 0);
        }

        Token(String string) {
            this(string, (0xE6FB3653 ^ 0xE6FB3653) != 0);
        }

        Token(char c) {
            this();
            this.symbol = c;
        }

        Token(boolean bl) {
            this(null, bl);
        }

        Token(String string, boolean bl) {
            this.inner = bl;
            this.type = string;
        }

        Token setSymbol(char c) {
            if (this.symbol == '\u0000') {
                if (\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("9\ua7ab\ua4ff").indexOf(c) > (0x3D659296 ^ 0xC29A6D69)) {
                    this.symbol = c;
                }
            }
            return this;
        }

        Token setType(String string) {
            if (this.type == null) {
                this.type = string;
            }
            return this;
        }

        boolean hasClassBound() {
            return (this.classBound != null ? 0x3EE0585D ^ 0x3EE0585C : 0x138943DC ^ 0x138943DC) != 0;
        }

        boolean hasInterfaceBound() {
            return (this.ifaceBound != null ? 0x458D1764 ^ 0x458D1765 : 0xA8010001 ^ 0xA8010001) != 0;
        }

        @Override
        public IToken setArray(boolean bl) {
            this.array |= bl;
            return this;
        }

        @Override
        public IToken setWildcard(char c) {
            if (\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("9\ua7ab").indexOf(c) == (0xF0ABF4F2 ^ 0xF540B0D)) {
                return this;
            }
            return this.setSymbol(c);
        }

        private List<Token> getClassBound() {
            if (this.classBound == null) {
                this.classBound = new ArrayList<Token>();
            }
            return this.classBound;
        }

        private List<Token> getIfaceBound() {
            if (this.ifaceBound == null) {
                this.ifaceBound = new ArrayList<Token>();
            }
            return this.ifaceBound;
        }

        private List<IToken> getSignature() {
            if (this.signature == null) {
                this.signature = new ArrayList<IToken>();
            }
            return this.signature;
        }

        private List<IToken> getSuffix() {
            if (this.suffix == null) {
                this.suffix = new ArrayList<IToken>();
            }
            return this.suffix;
        }

        IToken addTypeArgument(char c) {
            if (this.tail != null) {
                return this.tail.addTypeArgument(c);
            }
            Token token = new Token(c);
            this.getSignature().add(token);
            return token;
        }

        IToken addTypeArgument(String string) {
            if (this.tail != null) {
                return this.tail.addTypeArgument(string);
            }
            Token token = new Token(string);
            this.getSignature().add(token);
            return token;
        }

        IToken addTypeArgument(Token token) {
            if (this.tail != null) {
                return this.tail.addTypeArgument(token);
            }
            this.getSignature().add(token);
            return token;
        }

        IToken addTypeArgument(TokenHandle tokenHandle) {
            if (this.tail != null) {
                return this.tail.addTypeArgument(tokenHandle);
            }
            TokenHandle tokenHandle2 = tokenHandle.clone();
            this.getSignature().add(tokenHandle2);
            return tokenHandle2;
        }

        Token addBound(String string, boolean bl) {
            if (bl) {
                return this.addClassBound(string);
            }
            return this.addInterfaceBound(string);
        }

        Token addClassBound(String string) {
            Token token = new Token(string);
            this.getClassBound().add(token);
            return token;
        }

        Token addInterfaceBound(String string) {
            Token token = new Token(string);
            this.getIfaceBound().add(token);
            return token;
        }

        Token addInnerClass(String string) {
            this.tail = new Token(string, (0x554BDA27 ^ 0x554BDA26) != 0);
            this.getSuffix().add(this.tail);
            return this.tail;
        }

        public String toString() {
            return this.asType();
        }

        @Override
        public String asBound() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.type != null) {
                stringBuilder.append(this.type);
            }
            if (this.classBound != null) {
                for (Token token : this.classBound) {
                    stringBuilder.append(token.asType());
                }
            }
            if (this.ifaceBound != null) {
                for (Token token : this.ifaceBound) {
                    stringBuilder.append((char)(0x8862DA90 ^ 0x8862DAAA)).append(token.asType());
                }
            }
            return stringBuilder.toString();
        }

        @Override
        public String asType() {
            return this.asType((0xA76D7A92 ^ 0xA76D7A92) != 0);
        }

        public String asType(boolean bl) {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.array) {
                stringBuilder.append((char)(0x947A5A39 ^ 0x947A5A62));
            }
            if (this.symbol != '\u0000') {
                stringBuilder.append(this.symbol);
            }
            if (this.type == null) {
                return stringBuilder.toString();
            }
            if (!this.inner) {
                stringBuilder.append((char)(0xCB378333 ^ 0xCB37837F));
            }
            stringBuilder.append(this.type);
            if (!bl) {
                if (this.signature != null) {
                    stringBuilder.append((char)(0x2D9D4381 ^ 0x2D9D43BD));
                    for (IToken iToken : this.signature) {
                        stringBuilder.append(iToken.asType());
                    }
                    stringBuilder.append((char)(0x4C5CD0E7 ^ 0x4C5CD0D9));
                }
                if (this.suffix != null) {
                    for (IToken iToken : this.suffix) {
                        stringBuilder.append((char)(0x966F2C3C ^ 0x966F2C12)).append(iToken.asType());
                    }
                }
            }
            if (!this.inner) {
                stringBuilder.append((char)(0xAB9B5CBB ^ 0xAB9B5C80));
            }
            return stringBuilder.toString();
        }

        boolean isRaw() {
            return (this.signature == null ? 0x76970EFF ^ 0x76970EFE : 0x63D5DFDE ^ 0x63D5DFDE) != 0;
        }

        String getClassType() {
            return this.type != null ? this.type : \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438]\ua7e4\ua4bf\ua074\ua906\u7d62");
        }

        @Override
        public Token asToken() {
            return this;
        }
    }

    static interface IToken {
        public static final String WILDCARDS = "+-";

        public String asType();

        public String asBound();

        public Token asToken();

        public IToken setArray(boolean var1);

        public IToken setWildcard(char var1);
    }

    static class TypeVar
    implements Comparable<TypeVar> {
        private final String originalName;
        private String currentName;

        TypeVar(String string) {
            this.currentName = this.originalName = string;
        }

        @Override
        public int compareTo(TypeVar typeVar) {
            return this.currentName.compareTo(typeVar.currentName);
        }

        public String toString() {
            return this.currentName;
        }

        String getOriginalName() {
            return this.originalName;
        }

        void rename(String string) {
            this.currentName = string;
        }

        public boolean matches(String string) {
            return this.originalName.equals(string);
        }

        public boolean equals(Object object) {
            return this.currentName.equals(object);
        }

        public int hashCode() {
            return this.currentName.hashCode();
        }
    }

    static class Lazy
    extends ClassSignature {
        private final String sig;
        private ClassSignature generated;

        Lazy(String string) {
            this.sig = string;
        }

        @Override
        public ClassSignature wake() {
            if (this.generated == null) {
                this.generated = ClassSignature.of(this.sig);
            }
            return this.generated;
        }
    }
}

