/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.spongepowered.asm.lib.Opcodes;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.lib.tree.FrameNode;
import org.spongepowered.asm.lib.tree.InsnList;
import org.spongepowered.asm.lib.tree.LabelNode;
import org.spongepowered.asm.lib.tree.LineNumberNode;
import org.spongepowered.asm.lib.tree.LocalVariableNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.lib.tree.VarInsnNode;
import org.spongepowered.asm.lib.tree.analysis.Analyzer;
import org.spongepowered.asm.lib.tree.analysis.AnalyzerException;
import org.spongepowered.asm.lib.tree.analysis.BasicValue;
import org.spongepowered.asm.lib.tree.analysis.Frame;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import org.spongepowered.asm.util.asm.MixinVerifier;
import org.spongepowered.asm.util.throwables.LVTGeneratorException;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2;

public final class Locals {
    private static final Map<String, List<LocalVariableNode>> calculatedLocalVariables = new HashMap<String, List<LocalVariableNode>>();

    private Locals() {
    }

    public static void loadLocals(Type[] typeArray, InsnList insnList, int n, int n2) {
        while (n < typeArray.length && n2 > 0) {
            if (typeArray[n] != null) {
                insnList.add(new VarInsnNode(typeArray[n].getOpcode(0x7D4F0F17 ^ 0x7D4F0F02), n));
                --n2;
            }
            ++n;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LocalVariableNode[] getLocalsAt(ClassNode classNode, MethodNode methodNode, AbstractInsnNode abstractInsnNode) {
        Object object;
        int n;
        int n2 = 0x87BA815 ^ 0x87BA815;
        while (true) {
            if (n2 >= (0x9790744C ^ 0x9790744F) || !(abstractInsnNode instanceof LabelNode) && !(abstractInsnNode instanceof LineNumberNode)) break;
            abstractInsnNode = Locals.nextNode(methodNode.instructions, abstractInsnNode);
            ++n2;
        }
        ClassInfo classInfo = ClassInfo.forName(classNode.name);
        if (classInfo == null) {
            throw new LVTGeneratorException(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("Q\ua7e9\ua4a0\ua07d\ua901\u7d36\u8e44\u2475\u8b23\u3437~\ua7e9\ua4b4\ua075\ua945\u7d75\u8e46\u247b\u8b24\u34642\ua7eb\ua4b0\ua065\ua904\u7d72\u8e4b\u246e\u8b36\u3437t\ua7e9\ua4a7\ua031") + classNode.name + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2\ua7e1\ua4b0\ua07f\ua900\u7d64\u8e4b\u246e\u8b3e\u3479u\ua7a6\ua499\ua047\ua931\u7d36\u8e4c\u2475\u8b25\u3437") + methodNode.name);
        }
        ClassInfo.Method method = classInfo.findMethod(methodNode);
        if (method == null) {
            throw new LVTGeneratorException(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("Q\ua7e9\ua4a0\ua07d\ua901\u7d36\u8e44\u2475\u8b23\u3437~\ua7e9\ua4b6\ua070\ua911\u7d73\u8e0a\u2477\u8b32\u3463z\ua7e9\ua4b1\ua031\ua908\u7d73\u8e5e\u247b\u8b33\u3476f\ua7e7\ua4f5\ua077\ua90a\u7d64\u8e0a") + methodNode.name + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2\ua7e1\ua4b0\ua07f\ua900\u7d64\u8e4b\u246e\u8b3e\u3479u\ua7a6\ua499\ua047\ua931\u7d36\u8e43\u2474\u8b77") + classNode.name);
        }
        List<ClassInfo.FrameData> list = method.getFrames();
        LocalVariableNode[] localVariableNodeArray = new LocalVariableNode[methodNode.maxLocals];
        int n3 = 0x8BD45731 ^ 0x8BD45731;
        int n4 = 0xE848A6EC ^ 0xE848A6EC;
        if ((methodNode.access & (0x74C72AD8 ^ 0x74C72AD0)) == 0) {
            int n5 = n3++;
            localVariableNodeArray[n5] = new LocalVariableNode(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("f\ua7ee\ua4bc\ua062"), classNode.name, null, null, null, 0x74835A1E ^ 0x74835A1E);
        }
        Type[] typeArray = Type.getArgumentTypes(methodNode.desc);
        int n6 = typeArray.length;
        for (n = 0x970DE28F ^ 0x970DE28F; n < n6; ++n) {
            object = typeArray[n];
            localVariableNodeArray[n3] = new LocalVariableNode(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("s\ua7f4\ua4b2") + n4++, ((Type)object).toString(), null, null, null, n3);
            n3 += ((Type)object).getSize();
        }
        int n7 = n3;
        n6 = 0xB7C45CF3 ^ 0x483BA30C;
        n = 0x5CE7F05F ^ 0x5CE7F05F;
        object = methodNode.instructions.iterator();
        while (object.hasNext()) {
            AbstractInsnNode abstractInsnNode2;
            AbstractInsnNode abstractInsnNode3 = (AbstractInsnNode)object.next();
            if (abstractInsnNode3 instanceof FrameNode) {
                abstractInsnNode2 = (FrameNode)abstractInsnNode3;
                ClassInfo.FrameData frameData = ++n6 < list.size() ? list.get(n6) : null;
                n = frameData != null && frameData.type == 0 ? Math.min(n, frameData.locals) : abstractInsnNode2.local.size();
                int n8 = 0x13420D5 ^ 0x13420D5;
                int n9 = 0x8ADC57A2 ^ 0x8ADC57A2;
                while (n9 < localVariableNodeArray.length) {
                    Object object2;
                    Object object3 = object2 = n8 < abstractInsnNode2.local.size() ? abstractInsnNode2.local.get(n8) : null;
                    if (object2 instanceof String) {
                        localVariableNodeArray[n9] = Locals.getLocalVariableAt(classNode, methodNode, abstractInsnNode, n9);
                    } else if (object2 instanceof Integer) {
                        int n10;
                        int n11;
                        int n12;
                        int n13 = object2 == Opcodes.UNINITIALIZED_THIS || object2 == Opcodes.NULL ? 0x66744084 ^ 0x66744085 : (n12 = 0xE97F94D3 ^ 0xE97F94D3);
                        int n14 = object2 == Opcodes.INTEGER || object2 == Opcodes.FLOAT ? 0xDF275333 ^ 0xDF275332 : (n11 = 0x4681C797 ^ 0x4681C797);
                        int n15 = object2 == Opcodes.DOUBLE || object2 == Opcodes.LONG ? 0xB51E0547 ^ 0xB51E0546 : (n10 = 0xFA06F5AD ^ 0xFA06F5AD);
                        if (object2 != Opcodes.TOP) {
                            if (n12 != 0) {
                                localVariableNodeArray[n9] = null;
                            } else {
                                if (n11 == 0 && n10 == 0) throw new LVTGeneratorException(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("G\ua7e8\ua4a7\ua074\ua906\u7d79\u8e4d\u2474\u8b3e\u3464w\ua7e2\ua4f5\ua07d\ua90a\u7d75\u8e4b\u2476\u8b24\u3437}\ua7f6\ua4b6\ua07e\ua901\u7d73\u8e0a") + object2 + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2\ua7ef\ua4bb\ua031\ua909\u7d79\u8e49\u247b\u8b3b\u34642\ua7e7\ua4a7\ua063\ua904\u7d6f\u8e0a\u247b\u8b23\u3437b\ua7e9\ua4a6\ua078\ua911\u7d7f\u8e45\u2474\u8b77") + n8 + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2\ua7ef\ua4bb\ua031") + classNode.name + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("<") + methodNode.name + methodNode.desc);
                                localVariableNodeArray[n9] = Locals.getLocalVariableAt(classNode, methodNode, abstractInsnNode, n9);
                                if (n10 != 0) {
                                    localVariableNodeArray[++n9] = null;
                                }
                            }
                        }
                    } else {
                        if (object2 != null) throw new LVTGeneratorException(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b21\u3476~\ua7f3\ua4b0\ua031") + object2 + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2\ua7ef\ua4bb\ua031\ua909\u7d79\u8e49\u247b\u8b3b\u34642\ua7e7\ua4a7\ua063\ua904\u7d6f\u8e0a\u247b\u8b23\u3437b\ua7e9\ua4a6\ua078\ua911\u7d7f\u8e45\u2474\u8b77") + n8 + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2\ua7ef\ua4bb\ua031") + classNode.name + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("<") + methodNode.name + methodNode.desc);
                        if (n9 >= n7 && n9 >= n && n > 0) {
                            localVariableNodeArray[n9] = null;
                        }
                    }
                    ++n9;
                    ++n8;
                }
            } else if (abstractInsnNode3 instanceof VarInsnNode) {
                abstractInsnNode2 = (VarInsnNode)abstractInsnNode3;
                localVariableNodeArray[((VarInsnNode)abstractInsnNode2).var] = Locals.getLocalVariableAt(classNode, methodNode, abstractInsnNode, ((VarInsnNode)abstractInsnNode2).var);
            }
            if (abstractInsnNode3 != abstractInsnNode) continue;
            break;
        }
        for (int i = 0x1F8B89DB ^ 0x1F8B89DB; i < localVariableNodeArray.length; ++i) {
            if (localVariableNodeArray[i] == null || localVariableNodeArray[i].desc != null) continue;
            localVariableNodeArray[i] = null;
        }
        return localVariableNodeArray;
    }

    public static LocalVariableNode getLocalVariableAt(ClassNode classNode, MethodNode methodNode, AbstractInsnNode abstractInsnNode, int n) {
        return Locals.getLocalVariableAt(classNode, methodNode, methodNode.instructions.indexOf(abstractInsnNode), n);
    }

    private static LocalVariableNode getLocalVariableAt(ClassNode classNode, MethodNode methodNode, int n, int n2) {
        LocalVariableNode localVariableNode = null;
        LocalVariableNode localVariableNode2 = null;
        for (LocalVariableNode localVariableNode3 : Locals.getLocalVariableTable(classNode, methodNode)) {
            if (localVariableNode3.index != n2) continue;
            if (Locals.isOpcodeInRange(methodNode.instructions, localVariableNode3, n)) {
                localVariableNode = localVariableNode3;
                continue;
            }
            if (localVariableNode != null) continue;
            localVariableNode2 = localVariableNode3;
        }
        if (localVariableNode == null && !methodNode.localVariables.isEmpty()) {
            for (LocalVariableNode localVariableNode3 : Locals.getGeneratedLocalVariableTable(classNode, methodNode)) {
                if (localVariableNode3.index != n2 || !Locals.isOpcodeInRange(methodNode.instructions, localVariableNode3, n)) continue;
                localVariableNode = localVariableNode3;
            }
        }
        return localVariableNode != null ? localVariableNode : localVariableNode2;
    }

    private static boolean isOpcodeInRange(InsnList insnList, LocalVariableNode localVariableNode, int n) {
        return (insnList.indexOf(localVariableNode.start) < n && insnList.indexOf(localVariableNode.end) > n ? 0xF451BB70 ^ 0xF451BB71 : 0xEDA89A9 ^ 0xEDA89A9) != 0;
    }

    public static List<LocalVariableNode> getLocalVariableTable(ClassNode classNode, MethodNode methodNode) {
        if (methodNode.localVariables.isEmpty()) {
            return Locals.getGeneratedLocalVariableTable(classNode, methodNode);
        }
        return methodNode.localVariables;
    }

    public static List<LocalVariableNode> getGeneratedLocalVariableTable(ClassNode classNode, MethodNode methodNode) {
        Object[] objectArray = new Object[0x80A9111E ^ 0x80A9111D];
        objectArray[0xFED0F0D ^ 0xFED0F0D] = classNode.name;
        objectArray[0x94293601 ^ 0x94293600] = methodNode.name;
        objectArray[0x2EE9450F ^ 0x2EE9450D] = methodNode.desc;
        String string = String.format(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("7\ua7f5\ua4fb\ua034\ua916\u7d33\u8e59"), objectArray);
        List<LocalVariableNode> list = calculatedLocalVariables.get(string);
        if (list != null) {
            return list;
        }
        list = Locals.generateLocalVariableTable(classNode, methodNode);
        calculatedLocalVariables.put(string, list);
        return list;
    }

    public static List<LocalVariableNode> generateLocalVariableTable(ClassNode classNode, MethodNode methodNode) {
        int n;
        ArrayList<Type> arrayList = null;
        if (classNode.interfaces != null) {
            arrayList = new ArrayList<Type>();
            for (String object2 : classNode.interfaces) {
                arrayList.add(Type.getObjectType(object2));
            }
        }
        Object object3 = null;
        if (classNode.superName != null) {
            object3 = Type.getObjectType(classNode.superName);
        }
        Analyzer<BasicValue> analyzer = new Analyzer<BasicValue>(new MixinVerifier(Type.getObjectType(classNode.name), (Type)object3, arrayList, (0x63574D5A ^ 0x63574D5A) != 0));
        try {
            analyzer.analyze(classNode.name, methodNode);
        }
        catch (AnalyzerException frameArray) {
            frameArray.printStackTrace();
        }
        Frame<BasicValue>[] frameArray = analyzer.getFrames();
        int n2 = methodNode.instructions.size();
        ArrayList<LocalVariableNode> arrayList2 = new ArrayList<LocalVariableNode>();
        LocalVariableNode[] localVariableNodeArray = new LocalVariableNode[methodNode.maxLocals];
        BasicValue[] basicValueArray = new BasicValue[methodNode.maxLocals];
        LabelNode[] labelNodeArray = new LabelNode[n2];
        String[] stringArray = new String[methodNode.maxLocals];
        for (int labelNode = 0xB0C0F446 ^ 0xB0C0F446; labelNode < n2; ++labelNode) {
            Frame<BasicValue> n3 = frameArray[labelNode];
            if (n3 == null) continue;
            LabelNode labelNode2 = null;
            for (int i = 0x947A09EA ^ 0x947A09EA; i < n3.getLocals(); ++i) {
                Object object;
                BasicValue basicValue = n3.getLocal(i);
                if (basicValue == null && basicValueArray[i] == null || basicValue != null && basicValue.equals(basicValueArray[i])) continue;
                if (labelNode2 == null) {
                    object = methodNode.instructions.get(labelNode);
                    if (object instanceof LabelNode) {
                        labelNode2 = (LabelNode)object;
                    } else {
                        labelNodeArray[labelNode] = labelNode2 = new LabelNode();
                    }
                }
                if (basicValue == null && basicValueArray[i] != null) {
                    arrayList2.add(localVariableNodeArray[i]);
                    localVariableNodeArray[i].end = labelNode2;
                    localVariableNodeArray[i] = null;
                } else if (basicValue != null) {
                    if (basicValueArray[i] != null) {
                        arrayList2.add(localVariableNodeArray[i]);
                        localVariableNodeArray[i].end = labelNode2;
                        localVariableNodeArray[i] = null;
                    }
                    object = basicValue.getType() != null ? basicValue.getType().getDescriptor() : stringArray[i];
                    localVariableNodeArray[i] = new LocalVariableNode(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("d\ua7e7\ua4a7") + i, (String)object, null, labelNode2, null, i);
                    if (object != null) {
                        stringArray[i] = object;
                    }
                }
                basicValueArray[i] = basicValue;
            }
        }
        LabelNode labelNode = null;
        for (n = 0x9566D3F2 ^ 0x9566D3F2; n < localVariableNodeArray.length; ++n) {
            if (localVariableNodeArray[n] == null) continue;
            if (labelNode == null) {
                labelNode = new LabelNode();
                methodNode.instructions.add(labelNode);
            }
            localVariableNodeArray[n].end = labelNode;
            arrayList2.add(localVariableNodeArray[n]);
        }
        for (n = n2 - (0xE9C77BC5 ^ 0xE9C77BC4); n >= 0; --n) {
            if (labelNodeArray[n] == null) continue;
            methodNode.instructions.insert(methodNode.instructions.get(n), labelNodeArray[n]);
        }
        return arrayList2;
    }

    private static AbstractInsnNode nextNode(InsnList insnList, AbstractInsnNode abstractInsnNode) {
        int n = insnList.indexOf(abstractInsnNode) + (0x9D172E56 ^ 0x9D172E57);
        if (n > 0 && n < insnList.size()) {
            return insnList.get(n);
        }
        return abstractInsnNode;
    }
}

