/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.util;

import com.google.common.base.Strings;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2;

public class PrettyPrinter {
    private final HorizontalRule horizontalRule;
    private final List<Object> lines;
    private Table table;
    private boolean recalcWidth;
    protected int width;
    protected int wrapWidth;
    protected int kvKeyWidth;
    protected String kvFormat;

    public PrettyPrinter() {
        this(0x5E3123A7 ^ 0x5E3123C3);
    }

    public PrettyPrinter(int n) {
        char[] cArray = new char[0xD5266B17 ^ 0xD5266B16];
        cArray[0x7A2F3B5D ^ 0x7A2F3B5D] = 0x90E5358F ^ 0x90E535A5;
        this.horizontalRule = new HorizontalRule(cArray);
        this.lines = new ArrayList<Object>();
        this.recalcWidth = 0xDF5EB9B6 ^ 0xDF5EB9B6;
        this.width = 0xA1ADCD17 ^ 0xA1ADCD73;
        this.wrapWidth = 0x5238E76D ^ 0x5238E73D;
        this.kvKeyWidth = 0x2D46F948 ^ 0x2D46F942;
        this.kvFormat = PrettyPrinter.makeKvFormat(this.kvKeyWidth);
        this.width = n;
    }

    public PrettyPrinter wrapTo(int n) {
        this.wrapWidth = n;
        return this;
    }

    public int wrapTo() {
        return this.wrapWidth;
    }

    public PrettyPrinter table() {
        this.table = new Table();
        return this;
    }

    public PrettyPrinter table(String ... stringArray) {
        this.table = new Table();
        String[] stringArray2 = stringArray;
        int n = stringArray2.length;
        for (int i = 0xBDB7E524 ^ 0xBDB7E524; i < n; ++i) {
            String string = stringArray2[i];
            this.table.addColumn(string);
        }
        return this;
    }

    public PrettyPrinter table(Object ... objectArray) {
        this.table = new Table();
        Column column = null;
        Object[] objectArray2 = objectArray;
        int n = objectArray2.length;
        for (int i = 0x319EEFAC ^ 0x319EEFAC; i < n; ++i) {
            Object object = objectArray2[i];
            if (object instanceof String) {
                column = this.table.addColumn((String)object);
                continue;
            }
            if (object instanceof Integer && column != null) {
                int n2 = (Integer)object;
                if (n2 > 0) {
                    column.setWidth(n2);
                    continue;
                }
                if (n2 >= 0) continue;
                column.setMaxWidth(-n2);
                continue;
            }
            if (object instanceof Alignment && column != null) {
                column.setAlignment((Alignment)((Object)object));
                continue;
            }
            if (object == null) continue;
            column = this.table.addColumn(object.toString());
        }
        return this;
    }

    public PrettyPrinter spacing(int n) {
        if (this.table == null) {
            this.table = new Table();
        }
        this.table.setColSpacing(n);
        return this;
    }

    public PrettyPrinter th() {
        return this.th((0xA87CF9A ^ 0xA87CF9A) != 0);
    }

    private PrettyPrinter th(boolean bl) {
        if (this.table == null) {
            this.table = new Table();
        }
        if (!bl || this.table.addHeader) {
            this.table.headerAdded();
            this.addLine(this.table);
        }
        return this;
    }

    public PrettyPrinter tr(Object ... objectArray) {
        this.th((0xBF36158F ^ 0xBF36158E) != 0);
        this.addLine(this.table.addRow(objectArray));
        this.recalcWidth = 0x7223369A ^ 0x7223369B;
        return this;
    }

    public PrettyPrinter add() {
        this.addLine(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20(""));
        return this;
    }

    public PrettyPrinter add(String string) {
        this.addLine(string);
        this.width = Math.max(this.width, string.length());
        return this;
    }

    public PrettyPrinter add(String string, Object ... objectArray) {
        String string2 = String.format(string, objectArray);
        this.addLine(string2);
        this.width = Math.max(this.width, string2.length());
        return this;
    }

    public PrettyPrinter add(Object[] objectArray) {
        return this.add(objectArray, \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("7\ua7f5"));
    }

    public PrettyPrinter add(Object[] objectArray, String string) {
        Object[] objectArray2 = objectArray;
        int n = objectArray2.length;
        for (int i = 0x3E5EBBA ^ 0x3E5EBBA; i < n; ++i) {
            Object object = objectArray2[i];
            Object[] objectArray3 = new Object[0xEF1B4D ^ 0xEF1B4C];
            objectArray3[0xC1AF8FBF ^ 0xC1AF8FBF] = object;
            this.add(string, objectArray3);
        }
        return this;
    }

    public PrettyPrinter addIndexed(Object[] objectArray) {
        int n = String.valueOf(objectArray.length - (0x2ACD8609 ^ 0x2ACD8608)).length();
        String string = \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("I\ua7a3") + n + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("v\ua7db\ua4f5\ua034\ua916");
        for (int i = 0xE1EFA03F ^ 0xE1EFA03F; i < objectArray.length; ++i) {
            Object[] objectArray2 = new Object[0xDB09FE71 ^ 0xDB09FE73];
            objectArray2[0x7327C427 ^ 0x7327C427] = i;
            objectArray2[0xB0ACC328 ^ 0xB0ACC329] = objectArray[i];
            this.add(string, objectArray2);
        }
        return this;
    }

    public PrettyPrinter addWithIndices(Collection<?> collection) {
        return this.addIndexed(collection.toArray());
    }

    public PrettyPrinter add(IPrettyPrintable iPrettyPrintable) {
        if (iPrettyPrintable != null) {
            iPrettyPrintable.print(this);
        }
        return this;
    }

    public PrettyPrinter add(Throwable throwable) {
        return this.add(throwable, 0x53D53989 ^ 0x53D5398D);
    }

    public PrettyPrinter add(Throwable throwable, int n) {
        while (throwable != null) {
            Object[] objectArray = new Object[0xE8748DCF ^ 0xE8748DCD];
            objectArray[0x8F818669 ^ 0x8F818669] = throwable.getClass().getName();
            objectArray[0x6DD6692A ^ 0x6DD6692B] = throwable.getMessage();
            this.add(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("7\ua7f5\ua4ef\ua031\ua940\u7d65"), objectArray);
            this.add(throwable.getStackTrace(), n);
            throwable = throwable.getCause();
        }
        return this;
    }

    public PrettyPrinter add(StackTraceElement[] stackTraceElementArray, int n) {
        String string = Strings.repeat((String)\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2"), (int)n);
        StackTraceElement[] stackTraceElementArray2 = stackTraceElementArray;
        int n2 = stackTraceElementArray2.length;
        for (int i = 0xE2F7CF7C ^ 0xE2F7CF7C; i < n2; ++i) {
            StackTraceElement stackTraceElement = stackTraceElementArray2[i];
            Object[] objectArray = new Object[0x96597908 ^ 0x9659790A];
            objectArray[0xE7265A78 ^ 0xE7265A78] = string;
            objectArray[0xCF53BF1F ^ 0xCF53BF1E] = stackTraceElement;
            this.add(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("7\ua7f5\ua4f0\ua062"), objectArray);
        }
        return this;
    }

    public PrettyPrinter add(Object object) {
        return this.add(object, 0x18B30697 ^ 0x18B30697);
    }

    public PrettyPrinter add(Object object, int n) {
        String string = Strings.repeat((String)\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2"), (int)n);
        return this.append(object, n, string);
    }

    private PrettyPrinter append(Object object, int n, String string) {
        if (object instanceof String) {
            Object[] objectArray = new Object[0xE44E18D3 ^ 0xE44E18D1];
            objectArray[0x4763A4E4 ^ 0x4763A4E4] = string;
            objectArray[0xAE21AB3B ^ 0xAE21AB3A] = object;
            return this.add(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("7\ua7f5\ua4f0\ua062"), objectArray);
        }
        if (object instanceof Iterable) {
            for (Object t : (Iterable)object) {
                this.append(t, n, string);
            }
            return this;
        }
        if (object instanceof Map) {
            this.kvWidth(n);
            return this.add((Map)object);
        }
        if (object instanceof IPrettyPrintable) {
            return this.add((IPrettyPrintable)object);
        }
        if (object instanceof Throwable) {
            return this.add((Throwable)object, n);
        }
        if (object.getClass().isArray()) {
            return this.add((Object[])object, n + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("7\ua7f5"));
        }
        Object[] objectArray = new Object[0x936A6053 ^ 0x936A6051];
        objectArray[0x27C72114 ^ 0x27C72114] = string;
        objectArray[0x96F1AB1C ^ 0x96F1AB1D] = object;
        return this.add(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("7\ua7f5\ua4f0\ua062"), objectArray);
    }

    public PrettyPrinter addWrapped(String string, Object ... objectArray) {
        return this.addWrapped(this.wrapWidth, string, objectArray);
    }

    public PrettyPrinter addWrapped(int n, String string, Object ... objectArray) {
        String string2 = \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("");
        String string3 = String.format(string, objectArray).replace(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("\u001b"), \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2\ua7a6\ua4f5\ua031"));
        Matcher matcher = Pattern.compile(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("L\ua7ae\ua489\ua062\ua94e\u7d3f\u8e02\u2434\u8b7d\u343e6")).matcher(string3);
        if (matcher.matches()) {
            string2 = matcher.group(0x29ADB956 ^ 0x29ADB957);
        }
        try {
            for (String string4 : this.getWrapped(n, string3, string2)) {
                this.addLine(string4);
            }
        }
        catch (Exception exception) {
            this.add(string3);
        }
        return this;
    }

    private List<String> getWrapped(int n, String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        while (string.length() > n) {
            int n2 = string.lastIndexOf(0x79BEE56F ^ 0x79BEE54F, n);
            if (n2 < (0x94FA2A28 ^ 0x94FA2A22)) {
                n2 = n;
            }
            String string3 = string.substring(0xDE0DB217 ^ 0xDE0DB217, n2);
            arrayList.add(string3);
            string = string2 + string.substring(n2 + (0xAE8774CA ^ 0xAE8774CB));
        }
        if (string.length() > 0) {
            arrayList.add(string);
        }
        return arrayList;
    }

    public PrettyPrinter kv(String string, String string2, Object ... objectArray) {
        return this.kv(string, String.format(string2, objectArray));
    }

    public PrettyPrinter kv(String string, Object object) {
        this.addLine(new KeyValue(string, object));
        return this.kvWidth(string.length());
    }

    public PrettyPrinter kvWidth(int n) {
        if (n > this.kvKeyWidth) {
            this.kvKeyWidth = n;
            this.kvFormat = PrettyPrinter.makeKvFormat(n);
        }
        this.recalcWidth = 0xB907BAEC ^ 0xB907BAED;
        return this;
    }

    public PrettyPrinter add(Map<?, ?> map) {
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            String string = entry.getKey() == null ? \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("|\ua7f3\ua4b9\ua07d") : entry.getKey().toString();
            this.kv(string, entry.getValue());
        }
        return this;
    }

    public PrettyPrinter hr() {
        return this.hr((char)(0xC4A0E546 ^ 0xC4A0E56C));
    }

    public PrettyPrinter hr(char c) {
        char[] cArray = new char[0x29D48B1D ^ 0x29D48B1C];
        cArray[0xC36A5DDB ^ 0xC36A5DDB] = c;
        this.addLine(new HorizontalRule(cArray));
        return this;
    }

    public PrettyPrinter centre() {
        if (!this.lines.isEmpty()) {
            Object object = this.lines.get(this.lines.size() - (0xE71F2526 ^ 0xE71F2527));
            if (object instanceof String) {
                this.addLine(new CentredText(this.lines.remove(this.lines.size() - (0x84C3310 ^ 0x84C3311))));
            }
        }
        return this;
    }

    private void addLine(Object object) {
        if (object == null) {
            return;
        }
        this.lines.add(object);
        this.recalcWidth |= object instanceof IVariableWidthEntry;
    }

    public PrettyPrinter trace() {
        return this.trace(PrettyPrinter.getDefaultLoggerName());
    }

    public PrettyPrinter trace(Level level) {
        return this.trace(PrettyPrinter.getDefaultLoggerName(), level);
    }

    public PrettyPrinter trace(String string) {
        return this.trace(System.err, LogManager.getLogger((String)string));
    }

    public PrettyPrinter trace(String string, Level level) {
        return this.trace(System.err, LogManager.getLogger((String)string), level);
    }

    public PrettyPrinter trace(Logger logger) {
        return this.trace(System.err, logger);
    }

    public PrettyPrinter trace(Logger logger, Level level) {
        return this.trace(System.err, logger, level);
    }

    public PrettyPrinter trace(PrintStream printStream) {
        return this.trace(printStream, PrettyPrinter.getDefaultLoggerName());
    }

    public PrettyPrinter trace(PrintStream printStream, Level level) {
        return this.trace(printStream, PrettyPrinter.getDefaultLoggerName(), level);
    }

    public PrettyPrinter trace(PrintStream printStream, String string) {
        return this.trace(printStream, LogManager.getLogger((String)string));
    }

    public PrettyPrinter trace(PrintStream printStream, String string, Level level) {
        return this.trace(printStream, LogManager.getLogger((String)string), level);
    }

    public PrettyPrinter trace(PrintStream printStream, Logger logger) {
        return this.trace(printStream, logger, Level.DEBUG);
    }

    public PrettyPrinter trace(PrintStream printStream, Logger logger, Level level) {
        this.log(logger, level);
        this.print(printStream);
        return this;
    }

    public PrettyPrinter print() {
        return this.print(System.err);
    }

    public PrettyPrinter print(PrintStream printStream) {
        this.updateWidth();
        this.printSpecial(printStream, this.horizontalRule);
        for (Object object : this.lines) {
            if (object instanceof ISpecialEntry) {
                this.printSpecial(printStream, (ISpecialEntry)object);
                continue;
            }
            this.printString(printStream, object.toString());
        }
        this.printSpecial(printStream, this.horizontalRule);
        return this;
    }

    private void printSpecial(PrintStream printStream, ISpecialEntry iSpecialEntry) {
        Object[] objectArray = new Object[0x5E868D11 ^ 0x5E868D10];
        objectArray[0x451FEA8C ^ 0x451FEA8C] = iSpecialEntry.toString();
        printStream.printf(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("=\ua7ac\ua4f0\ua062\ua94f\u7d39\u8e20"), objectArray);
    }

    private void printString(PrintStream printStream, String string) {
        if (string != null) {
            Object[] objectArray = new Object[0x43990029 ^ 0x43990028];
            objectArray[0xA6581323 ^ 0xA6581323] = string;
            printStream.printf(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("=\ua7ac\ua4f5\ua034\ua948") + this.width + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("a\ua7a6\ua4ff\ua03e\ua96f"), objectArray);
        }
    }

    public PrettyPrinter log(Logger logger) {
        return this.log(logger, Level.INFO);
    }

    public PrettyPrinter log(Logger logger, Level level) {
        this.updateWidth();
        this.logSpecial(logger, level, this.horizontalRule);
        for (Object object : this.lines) {
            if (object instanceof ISpecialEntry) {
                this.logSpecial(logger, level, (ISpecialEntry)object);
                continue;
            }
            this.logString(logger, level, object.toString());
        }
        this.logSpecial(logger, level, this.horizontalRule);
        return this;
    }

    private void logSpecial(Logger logger, Level level, ISpecialEntry iSpecialEntry) {
        Object[] objectArray = new Object[0x90A8D72D ^ 0x90A8D72C];
        objectArray[0xCFC2C5A9 ^ 0xCFC2C5A9] = iSpecialEntry.toString();
        logger.log(level, \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("=\ua7ac\ua4ae\ua06c\ua94f\u7d39"), objectArray);
    }

    private void logString(Logger logger, Level level, String string) {
        if (string != null) {
            Object[] objectArray = new Object[0x7737EC4C ^ 0x7737EC4D];
            objectArray[0x485EA79 ^ 0x485EA79] = string;
            logger.log(level, String.format(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("=\ua7ac\ua4f5\ua034\ua948") + this.width + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("a\ua7a6\ua4ff\ua03e"), objectArray));
        }
    }

    private void updateWidth() {
        if (this.recalcWidth) {
            this.recalcWidth = 0xF89F62E4 ^ 0xF89F62E4;
            for (Object object : this.lines) {
                if (!(object instanceof IVariableWidthEntry)) continue;
                this.width = Math.min(0x7817FAAD ^ 0x7817EAAD, Math.max(this.width, ((IVariableWidthEntry)object).getWidth()));
            }
        }
    }

    private static String makeKvFormat(int n) {
        Object[] objectArray = new Object[0xCEFCC51E ^ 0xCEFCC51F];
        objectArray[0xD15433CA ^ 0xD15433CA] = n;
        return String.format(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("7\ua7a3\ua4f0\ua075\ua916\u7d36\u8e10\u243a\u8b72\u3432a"), objectArray);
    }

    private static String getDefaultLoggerName() {
        String string = new Throwable().getStackTrace()[0x401B642D ^ 0x401B642F].getClassName();
        int n = string.lastIndexOf(0x46FB63E7 ^ 0x46FB63C9);
        return n == (0x764B50FA ^ 0x89B4AF05) ? string : string.substring(n + (0x88DD22DA ^ 0x88DD22DB));
    }

    public static void dumpStack() {
        new PrettyPrinter().add(new Exception(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("A\ua7f2\ua4b4\ua072\ua90e\u7d36\u8e5e\u2468\u8b36\u3474w"))).print(System.err);
    }

    public static void print(Throwable throwable) {
        new PrettyPrinter().add(throwable).print(System.err);
    }

    static class Row
    implements IVariableWidthEntry {
        final Table table;
        final String[] args;

        public Row(Table table, Object ... objectArray) {
            this.table = table.grow(objectArray.length);
            this.args = new String[objectArray.length];
            for (int i = 0x7E482B6D ^ 0x7E482B6D; i < objectArray.length; ++i) {
                this.args[i] = objectArray[i].toString();
                this.table.columns.get(i).setMinWidth(this.args[i].length());
            }
        }

        public String toString() {
            Object[] objectArray = new Object[this.table.columns.size()];
            for (int i = 0x9BAD6E0B ^ 0x9BAD6E0B; i < objectArray.length; ++i) {
                Column column = this.table.columns.get(i);
                if (i >= this.args.length) {
                    objectArray[i] = \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("");
                    continue;
                }
                objectArray[i] = this.args[i].length() > column.getMaxWidth() ? this.args[i].substring(0xFA701DC7 ^ 0xFA701DC7, column.getMaxWidth()) : this.args[i];
            }
            return String.format(this.table.format, objectArray);
        }

        @Override
        public int getWidth() {
            return this.toString().length();
        }
    }

    static class Column {
        private final Table table;
        private Alignment align = Alignment.LEFT;
        private int minWidth = 0x53F732A1 ^ 0x53F732A0;
        private int maxWidth = 0x91133201 ^ 0xEEECCDFE;
        private int size = 0xA643B5B9 ^ 0xA643B5B9;
        private String title = \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("");
        private String format = \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("7\ua7f5");

        Column(Table table) {
            this.table = table;
        }

        Column(Table table, String string) {
            this(table);
            this.title = string;
            this.minWidth = string.length();
            this.updateFormat();
        }

        Column(Table table, Alignment alignment, int n, String string) {
            this(table, string);
            this.align = alignment;
            this.size = n;
        }

        void setAlignment(Alignment alignment) {
            this.align = alignment;
            this.updateFormat();
        }

        void setWidth(int n) {
            if (n > this.size) {
                this.size = n;
                this.updateFormat();
            }
        }

        void setMinWidth(int n) {
            if (n > this.minWidth) {
                this.minWidth = n;
                this.updateFormat();
            }
        }

        void setMaxWidth(int n) {
            this.size = Math.min(this.size, this.maxWidth);
            this.maxWidth = Math.max(0x7B0CF15F ^ 0x7B0CF15E, n);
            this.updateFormat();
        }

        void setTitle(String string) {
            this.title = string;
            this.setWidth(string.length());
        }

        private void updateFormat() {
            int n = Math.min(this.maxWidth, this.size == 0 ? this.minWidth : this.size);
            this.format = \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("7") + (this.align == Alignment.RIGHT ? \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("") : \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("?")) + n + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("a");
            this.table.updateFormat();
        }

        int getMaxWidth() {
            return this.maxWidth;
        }

        String getTitle() {
            return this.title;
        }

        String getFormat() {
            return this.format;
        }

        public String toString() {
            if (this.title.length() > this.maxWidth) {
                return this.title.substring(0xCACD231F ^ 0xCACD231F, this.maxWidth);
            }
            return this.title;
        }
    }

    static class Table
    implements IVariableWidthEntry {
        final List<Column> columns = new ArrayList<Column>();
        final List<Row> rows = new ArrayList<Row>();
        String format = \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("7\ua7f5");
        int colSpacing = 0xE45357D6 ^ 0xE45357D4;
        boolean addHeader = 0x54AE2E51 ^ 0x54AE2E50;

        Table() {
        }

        void headerAdded() {
            this.addHeader = 0x3F19AD93 ^ 0x3F19AD93;
        }

        void setColSpacing(int n) {
            this.colSpacing = Math.max(0x7F2E5616 ^ 0x7F2E5616, n);
            this.updateFormat();
        }

        Table grow(int n) {
            while (this.columns.size() < n) {
                this.columns.add(new Column(this));
            }
            this.updateFormat();
            return this;
        }

        Column add(Column column) {
            this.columns.add(column);
            return column;
        }

        Row add(Row row) {
            this.rows.add(row);
            return row;
        }

        Column addColumn(String string) {
            return this.add(new Column(this, string));
        }

        Column addColumn(Alignment alignment, int n, String string) {
            return this.add(new Column(this, alignment, n, string));
        }

        Row addRow(Object ... objectArray) {
            return this.add(new Row(this, objectArray));
        }

        void updateFormat() {
            String string = Strings.repeat((String)\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2"), (int)this.colSpacing);
            StringBuilder stringBuilder = new StringBuilder();
            int n = 0xC9467A61 ^ 0xC9467A61;
            for (Column column : this.columns) {
                if (n != 0) {
                    stringBuilder.append(string);
                }
                n = 0xF3E1C310 ^ 0xF3E1C311;
                stringBuilder.append(column.getFormat());
            }
            this.format = stringBuilder.toString();
        }

        String getFormat() {
            return this.format;
        }

        Object[] getTitles() {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Column column : this.columns) {
                arrayList.add(column.getTitle());
            }
            return arrayList.toArray();
        }

        public String toString() {
            int n = 0xCC168607 ^ 0xCC168607;
            String[] stringArray = new String[this.columns.size()];
            for (int i = 0x240C2BA8 ^ 0x240C2BA8; i < this.columns.size(); ++i) {
                stringArray[i] = this.columns.get(i).toString();
                n |= !stringArray[i].isEmpty() ? 0x9423C653 ^ 0x9423C652 : 0xD225F76D ^ 0xD225F76D;
            }
            return n != 0 ? String.format(this.format, stringArray) : null;
        }

        @Override
        public int getWidth() {
            String string = this.toString();
            return string != null ? string.length() : 0xFA8C0743 ^ 0xFA8C0743;
        }
    }

    public static final class Alignment
    extends Enum<Alignment> {
        public static final /* enum */ Alignment LEFT = new Alignment();
        public static final /* enum */ Alignment RIGHT = new Alignment();
        private static final /* synthetic */ Alignment[] $VALUES;

        public static Alignment[] values() {
            return (Alignment[])$VALUES.clone();
        }

        public static Alignment valueOf(String string) {
            return Enum.valueOf(Alignment.class, string);
        }

        static {
            Alignment[] alignmentArray = new Alignment[0x916096A0 ^ 0x916096A2];
            alignmentArray[0x52E757E3 ^ 0x52E757E3] = LEFT;
            alignmentArray[0x7A0EFEAE ^ 0x7A0EFEAF] = RIGHT;
            $VALUES = alignmentArray;
        }
    }

    class CentredText {
        private final Object centred;

        public CentredText(Object object) {
            this.centred = object;
        }

        public String toString() {
            String string = this.centred.toString();
            Object[] objectArray = new Object[0xDDE729D6 ^ 0xDDE729D7];
            objectArray[0xA0E1EB12 ^ 0xA0E1EB12] = string;
            return String.format(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("7") + ((PrettyPrinter.this.width - string.length()) / (0x514B4240 ^ 0x514B4242) + string.length()) + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("a"), objectArray);
        }
    }

    class HorizontalRule
    implements ISpecialEntry {
        private final char[] hrChars;

        public HorizontalRule(char ... cArray) {
            this.hrChars = cArray;
        }

        public String toString() {
            return Strings.repeat((String)new String(this.hrChars), (int)(PrettyPrinter.this.width + (0x96E22032 ^ 0x96E22030)));
        }
    }

    class KeyValue
    implements IVariableWidthEntry {
        private final String key;
        private final Object value;

        public KeyValue(String string, Object object) {
            this.key = string;
            this.value = object;
        }

        public String toString() {
            Object[] objectArray = new Object[0x9AD43DA7 ^ 0x9AD43DA5];
            objectArray[0x3B33AC5 ^ 0x3B33AC5] = this.key;
            objectArray[0x36F3D069 ^ 0x36F3D068] = this.value;
            return String.format(PrettyPrinter.this.kvFormat, objectArray);
        }

        @Override
        public int getWidth() {
            return this.toString().length();
        }
    }

    static interface ISpecialEntry {
    }

    static interface IVariableWidthEntry {
        public int getWidth();
    }

    public static interface IPrettyPrintable {
        public void print(PrettyPrinter var1);
    }
}

