/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.util.perf;

import com.google.common.base.Joiner;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import org.spongepowered.asm.util.PrettyPrinter;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2;

public final class Profiler {
    public static final int ROOT = 1;
    public static final int FINE = 2;
    private final Map<String, Section> sections = new TreeMap<String, Section>();
    private final List<String> phases = new ArrayList<String>();
    private final Deque<Section> stack = new LinkedList<Section>();
    private boolean active;

    public Profiler() {
        this.phases.add(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("[\ua7e8\ua4bc\ua065\ua90c\u7d77\u8e46"));
    }

    public void setActive(boolean bl) {
        if (!this.active && bl || !bl) {
            this.reset();
        }
        this.active = bl;
    }

    public void reset() {
        for (Section section : this.sections.values()) {
            section.invalidate();
        }
        this.sections.clear();
        this.phases.clear();
        this.phases.add(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("[\ua7e8\ua4bc\ua065\ua90c\u7d77\u8e46"));
        this.stack.clear();
    }

    public Section get(String string) {
        Section section = this.sections.get(string);
        if (section == null) {
            section = this.active ? new LiveSection(string, this.phases.size() - (0xA0791B27 ^ 0xA0791B26)) : new Section(string);
            this.sections.put(string, section);
        }
        return section;
    }

    private Section getSubSection(String string, String string2, Section section) {
        Section section2 = this.sections.get(string);
        if (section2 == null) {
            section2 = new SubSection(string, this.phases.size() - (0x9B5A5A7D ^ 0x9B5A5A7C), string2, section);
            this.sections.put(string, section2);
        }
        return section2;
    }

    boolean isHead(Section section) {
        return (this.stack.peek() == section ? 0x7D60F34D ^ 0x7D60F34C : 0xD50A9796 ^ 0xD50A9796) != 0;
    }

    public Section begin(String ... stringArray) {
        return this.begin(0x5523B040 ^ 0x5523B040, stringArray);
    }

    public Section begin(int n, String ... stringArray) {
        return this.begin(n, Joiner.on((char)(0x1F656E7B ^ 0x1F656E55)).join((Object[])stringArray));
    }

    public Section begin(String string) {
        return this.begin(0x76F3A4C1 ^ 0x76F3A4C1, string);
    }

    public Section begin(int n, String string) {
        int n2 = (n & (0xFA6849E3 ^ 0xFA6849E2)) != 0 ? 0xA390B6A8 ^ 0xA390B6A9 : 0x37EFABB0 ^ 0x37EFABB0;
        int n3 = (n & (0x9BD9F24C ^ 0x9BD9F24E)) != 0 ? 0x1DF347B9 ^ 0x1DF347B8 : 0x9E71CD59 ^ 0x9E71CD59;
        String string2 = string;
        Section section = this.stack.peek();
        if (section != null) {
            string2 = section.getName() + (n2 != 0 ? \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2\ua7ab\ua4eb\ua031") : \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("<")) + string2;
            if (section.isRoot() && n2 == 0) {
                int n4 = section.getName().lastIndexOf(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2\ua7ab\ua4eb\ua031"));
                string = (n4 > (0x51C9F057 ^ 0xAE360FA8) ? section.getName().substring(n4 + (0x1825006B ^ 0x1825006F)) : section.getName()) + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("<") + string;
                n2 = 0x293661DC ^ 0x293661DD;
            }
        }
        Section section2 = this.get(n2 != 0 ? string : string2);
        if (n2 != 0 && section != null && this.active) {
            section2 = this.getSubSection(string2, section.getName(), section2);
        }
        section2.setFine(n3 != 0).setRoot(n2 != 0);
        this.stack.push(section2);
        return section2.start();
    }

    void end(Section section) {
        block5: {
            try {
                Section section2;
                Section section3 = section2 = this.stack.pop();
                while (section3 != section) {
                    if (section3 == null && this.active) {
                        if (section2 == null) {
                            throw new IllegalStateException(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("S\ua7f2\ua4a1\ua074\ua908\u7d66\u8e5e\u247f\u8b33\u3437f\ua7e9\ua4f5\ua061\ua90a\u7d66\u8e0a") + section + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2\ua7e4\ua4a0\ua065\ua945\u7d62\u8e42\u247f\u8b77\u3464f\ua7e7\ua4b6\ua07a\ua945\u7d7f\u8e59\u243a\u8b32\u347ab\ua7f2\ua4ac"));
                        }
                        throw new IllegalStateException(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("S\ua7f2\ua4a1\ua074\ua908\u7d66\u8e5e\u247f\u8b33\u3437f\ua7e9\ua4f5\ua061\ua90a\u7d66\u8e0a") + section + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2\ua7f1\ua4bd\ua078\ua906\u7d7e\u8e0a\u246d\u8b36\u34642\ua7e8\ua4ba\ua065\ua945\u7d7f\u8e44\u243a\u8b23\u347fw\ua7a6\ua4a6\ua065\ua904\u7d75\u8e41\u2436\u8b77\u347fw\ua7e7\ua4b1\ua031\ua912\u7d77\u8e59\u243a") + section2);
                    }
                    section3 = this.stack.pop();
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                if (!this.active) break block5;
                throw new IllegalStateException(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("S\ua7f2\ua4a1\ua074\ua908\u7d66\u8e5e\u247f\u8b33\u3437f\ua7e9\ua4f5\ua061\ua90a\u7d66\u8e0a") + section + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2\ua7e4\ua4a0\ua065\ua945\u7d62\u8e42\u247f\u8b77\u3464f\ua7e7\ua4b6\ua07a\ua945\u7d7f\u8e59\u243a\u8b32\u347ab\ua7f2\ua4ac"));
            }
        }
    }

    public void mark(String string) {
        long l = 0xD5111DB962869DA7L ^ 0xD5111DB962869DA7L;
        for (Section section : this.sections.values()) {
            l += section.getTime();
        }
        if (l == (0x23710D5B6BB919A8L ^ 0x23710D5B6BB919A8L)) {
            int n = this.phases.size();
            this.phases.set(n - (0x6ADC7475 ^ 0x6ADC7474), string);
            return;
        }
        this.phases.add(string);
        for (Section section : this.sections.values()) {
            section.mark();
        }
    }

    public Collection<Section> getSections() {
        return Collections.unmodifiableCollection(this.sections.values());
    }

    public PrettyPrinter printer(boolean bl, boolean bl2) {
        PrettyPrinter prettyPrinter = new PrettyPrinter();
        int n = this.phases.size() + (0xCFA1FB1D ^ 0xCFA1FB19);
        int[] nArray = new int[0xCDEE4A1D ^ 0xCDEE4A18];
        nArray[0x53821F47 ^ 0x53821F47] = 0xCF9F69A8 ^ 0xCF9F69A8;
        nArray[0xE1524C0C ^ 0xE1524C0D] = 0x22FB3A81 ^ 0x22FB3A80;
        nArray[0x7AACAA69 ^ 0x7AACAA6B] = 0x39EB1E6F ^ 0x39EB1E6D;
        nArray[0xBC8A74A0 ^ 0xBC8A74A3] = n - (0x76E90FA5 ^ 0x76E90FA7);
        nArray[0x60784924 ^ 0x60784920] = n - (0xE2DEF314 ^ 0xE2DEF315);
        int[] nArray2 = nArray;
        Object[] objectArray = new Object[n * (0xB04B8AB4 ^ 0xB04B8AB6)];
        int n2 = 0xCB11C46E ^ 0xCB11C46E;
        int n3 = 0x3424CDD9 ^ 0x3424CDD9;
        while (n2 < n) {
            objectArray[n3 + (0xA3D90245 ^ 0xA3D90244)] = PrettyPrinter.Alignment.RIGHT;
            if (n2 == nArray2[0x1148EA9 ^ 0x1148EA9]) {
                objectArray[n3] = (bl2 ? \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("") : \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2\ua7a6")) + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("A\ua7e3\ua4b6\ua065\ua90c\u7d79\u8e44");
                objectArray[n3 + (0x3D11239F ^ 0x3D11239E)] = PrettyPrinter.Alignment.LEFT;
            } else {
                objectArray[n3] = n2 == nArray2[0x3E1E84E6 ^ 0x3E1E84E7] ? \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2\ua7a6\ua4f5\ua031\ua931\u7d59\u8e7e\u245b\u8b1b") : (n2 == nArray2[0xDAB8F5C6 ^ 0xDAB8F5C5] ? \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2\ua7a6\ua4f5\ua031\ua926\u7d79\u8e5f\u2474\u8b23") : (n2 == nArray2[0xFBCA2236 ^ 0xFBCA2232] ? \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("S\ua7f0\ua4b2\ua03f\ua945") : (n2 - nArray2[0xC1B7654F ^ 0xC1B7654D] < this.phases.size() ? this.phases.get(n2 - nArray2[0xBF2A32A7 ^ 0xBF2A32A5]) : \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20(""))));
            }
            n3 = ++n2 * (0x5C1C2852 ^ 0x5C1C2850);
        }
        prettyPrinter.table(objectArray).th().hr().add();
        for (Section section : this.sections.values()) {
            if (section.isFine() && !bl || bl2 && section.getDelegate() != section) continue;
            this.printSectionRow(prettyPrinter, n, nArray2, section, bl2);
            if (!bl2) continue;
            for (Section section2 : this.sections.values()) {
                Section section3 = section2.getDelegate();
                if (section2.isFine() && !bl || section3 != section || section3 == section2) continue;
                this.printSectionRow(prettyPrinter, n, nArray2, section2, bl2);
            }
        }
        return prettyPrinter.add();
    }

    private void printSectionRow(PrettyPrinter prettyPrinter, int n, int[] nArray, Section section, boolean bl) {
        long[] lArray;
        int n2 = section.getDelegate() != section ? 0xC69A21F4 ^ 0xC69A21F5 : 0xAB619C0 ^ 0xAB619C0;
        Object[] objectArray = new Object[n];
        int n3 = 0xF028EC55 ^ 0xF028EC54;
        if (bl) {
            objectArray[0xE08D280C ^ 0xE08D280C] = n2 != 0 ? \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2\ua7a6\ua4eb\ua031") + section.getBaseName() : section.getName();
        } else {
            objectArray[0xFD5E4DE7 ^ 0xFD5E4DE7] = (n2 != 0 ? \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("9\ua7a6") : \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2\ua7a6")) + section.getName();
        }
        long[] lArray2 = lArray = section.getTimes();
        int n4 = lArray2.length;
        for (int i = 0xC9AFA33 ^ 0xC9AFA33; i < n4; ++i) {
            long l = lArray2[i];
            if (n3 == nArray[0xDF25529 ^ 0xDF25528]) {
                objectArray[n3++] = section.getTotalTime() + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2\ua7eb\ua4a6");
            }
            if (n3 < nArray[0xFC441C01 ^ 0xFC441C03] || n3 >= objectArray.length) continue;
            objectArray[n3++] = l + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2\ua7eb\ua4a6");
        }
        objectArray[nArray[0xBE68FBF7 ^ 0xBE68FBF4]] = section.getTotalCount();
        objectArray[nArray[0x6C57F7FC ^ 0x6C57F7F8]] = new DecimalFormat(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2\ua7a6\ua4f5\ua032\ua946\u7d35\u8e1a\u2434\u8b67\u3427\"\ua7a6\ua4b8\ua062")).format(section.getTotalAverageTime());
        for (int i = 0x3F1E3FC7 ^ 0x3F1E3FC7; i < objectArray.length; ++i) {
            if (objectArray[i] != null) continue;
            objectArray[i] = \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("?");
        }
        prettyPrinter.tr(objectArray);
    }

    class SubSection
    extends LiveSection {
        private final String baseName;
        private final Section root;

        SubSection(String string, int n, String string2, Section section) {
            super(string, n);
            this.baseName = string2;
            this.root = section;
        }

        @Override
        Section invalidate() {
            this.root.invalidate();
            return super.invalidate();
        }

        @Override
        public String getBaseName() {
            return this.baseName;
        }

        @Override
        public void setInfo(String string) {
            this.root.setInfo(string);
            super.setInfo(string);
        }

        @Override
        Section getDelegate() {
            return this.root;
        }

        @Override
        Section start() {
            this.root.start();
            return super.start();
        }

        @Override
        public Section end() {
            this.root.stop();
            return super.end();
        }

        @Override
        public Section next(String string) {
            super.stop();
            return this.root.next(string);
        }
    }

    class LiveSection
    extends Section {
        private int cursor;
        private long[] times;
        private long start;
        private long time;
        private long markedTime;
        private int count;
        private int markedCount;

        LiveSection(String string, int n) {
            super(string);
            this.cursor = 0x4B3B94D0 ^ 0x4B3B94D0;
            this.times = new long[0x9147110E ^ 0x9147110E];
            this.start = 0x399E92F6473FAE89L ^ 0x399E92F6473FAE89L;
            this.cursor = n;
        }

        @Override
        Section start() {
            this.start = System.currentTimeMillis();
            return this;
        }

        @Override
        protected Section stop() {
            if (this.start > (0x7FF7F8D71EB50717L ^ 0x7FF7F8D71EB50717L)) {
                this.time += System.currentTimeMillis() - this.start;
            }
            this.start = 0x15EFB05C2B5F5EB5L ^ 0x15EFB05C2B5F5EB5L;
            this.count += 0xDBA01D7 ^ 0xDBA01D6;
            return this;
        }

        @Override
        public Section end() {
            this.stop();
            if (!this.invalidated) {
                Profiler.this.end(this);
            }
            return this;
        }

        @Override
        void mark() {
            if (this.cursor >= this.times.length) {
                this.times = Arrays.copyOf(this.times, this.cursor + (0x822EEE52 ^ 0x822EEE56));
            }
            this.times[this.cursor] = this.time;
            this.markedTime += this.time;
            this.markedCount += this.count;
            this.time = 0x4F81A90A694ECF80L ^ 0x4F81A90A694ECF80L;
            this.count = 0x91DDB671 ^ 0x91DDB671;
            this.cursor += 0xBB78277B ^ 0xBB78277A;
        }

        @Override
        public long getTime() {
            return this.time;
        }

        @Override
        public long getTotalTime() {
            return this.time + this.markedTime;
        }

        @Override
        public double getSeconds() {
            return (double)this.time * 0.001;
        }

        @Override
        public double getTotalSeconds() {
            return (double)(this.time + this.markedTime) * 0.001;
        }

        @Override
        public long[] getTimes() {
            long[] lArray = new long[this.cursor + (0xFA74D09E ^ 0xFA74D09F)];
            System.arraycopy(this.times, 0xF741B293 ^ 0xF741B293, lArray, 0xA80CD4CD ^ 0xA80CD4CD, Math.min(this.times.length, this.cursor));
            lArray[this.cursor] = this.time;
            return lArray;
        }

        @Override
        public int getCount() {
            return this.count;
        }

        @Override
        public int getTotalCount() {
            return this.count + this.markedCount;
        }

        @Override
        public double getAverageTime() {
            return this.count > 0 ? (double)this.time / (double)this.count : 0.0;
        }

        @Override
        public double getTotalAverageTime() {
            return this.count > 0 ? (double)(this.time + this.markedTime) / (double)(this.count + this.markedCount) : 0.0;
        }
    }

    public class Section {
        static final String SEPARATOR_ROOT = " -> ";
        static final String SEPARATOR_CHILD = ".";
        private final String name;
        private boolean root;
        private boolean fine;
        protected boolean invalidated;
        private String info;

        Section(String string) {
            this.name = string;
            this.info = string;
        }

        Section getDelegate() {
            return this;
        }

        Section invalidate() {
            this.invalidated = 0x7C9D525C ^ 0x7C9D525D;
            return this;
        }

        Section setRoot(boolean bl) {
            this.root = bl;
            return this;
        }

        public boolean isRoot() {
            return this.root;
        }

        Section setFine(boolean bl) {
            this.fine = bl;
            return this;
        }

        public boolean isFine() {
            return this.fine;
        }

        public String getName() {
            return this.name;
        }

        public String getBaseName() {
            return this.name;
        }

        public void setInfo(String string) {
            this.info = string;
        }

        public String getInfo() {
            return this.info;
        }

        Section start() {
            return this;
        }

        protected Section stop() {
            return this;
        }

        public Section end() {
            if (!this.invalidated) {
                Profiler.this.end(this);
            }
            return this;
        }

        public Section next(String string) {
            this.end();
            return Profiler.this.begin(string);
        }

        void mark() {
        }

        public long getTime() {
            return 0x38D12ECE0D58D2D9L ^ 0x38D12ECE0D58D2D9L;
        }

        public long getTotalTime() {
            return 0xD782117D69192A10L ^ 0xD782117D69192A10L;
        }

        public double getSeconds() {
            return 0.0;
        }

        public double getTotalSeconds() {
            return 0.0;
        }

        public long[] getTimes() {
            return new long[0xDAEE92FF ^ 0xDAEE92FE];
        }

        public int getCount() {
            return 0x49E38DF3 ^ 0x49E38DF3;
        }

        public int getTotalCount() {
            return 0xDB7B5CA6 ^ 0xDB7B5CA6;
        }

        public double getAverageTime() {
            return 0.0;
        }

        public double getTotalAverageTime() {
            return 0.0;
        }

        public final String toString() {
            return this.name;
        }
    }
}

