/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.tools.obfuscation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.processing.Messager;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.tools.Diagnostic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.tools.obfuscation.AnnotatedMixinElementHandlerAccessor;
import org.spongepowered.tools.obfuscation.AnnotatedMixinElementHandlerInjector;
import org.spongepowered.tools.obfuscation.AnnotatedMixinElementHandlerOverwrite;
import org.spongepowered.tools.obfuscation.AnnotatedMixinElementHandlerShadow;
import org.spongepowered.tools.obfuscation.AnnotatedMixinElementHandlerSoftImplements;
import org.spongepowered.tools.obfuscation.ObfuscationData;
import org.spongepowered.tools.obfuscation.interfaces.IMixinAnnotationProcessor;
import org.spongepowered.tools.obfuscation.interfaces.IMixinValidator;
import org.spongepowered.tools.obfuscation.interfaces.IObfuscationManager;
import org.spongepowered.tools.obfuscation.interfaces.ITypeHandleProvider;
import org.spongepowered.tools.obfuscation.mapping.IMappingConsumer;
import org.spongepowered.tools.obfuscation.mirror.AnnotationHandle;
import org.spongepowered.tools.obfuscation.mirror.TypeHandle;
import org.spongepowered.tools.obfuscation.mirror.TypeUtils;
import org.spongepowered.tools.obfuscation.struct.InjectorRemap;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2;

class AnnotatedMixin {
    private final AnnotationHandle annotation;
    private final Messager messager;
    private final ITypeHandleProvider typeProvider;
    private final IObfuscationManager obf;
    private final IMappingConsumer mappings;
    private final TypeElement mixin;
    private final List<ExecutableElement> methods;
    private final TypeHandle handle;
    private final List<TypeHandle> targets = new ArrayList<TypeHandle>();
    private final TypeHandle primaryTarget;
    private final String classRef;
    private final boolean remap;
    private final boolean virtual;
    private final AnnotatedMixinElementHandlerOverwrite overwrites;
    private final AnnotatedMixinElementHandlerShadow shadows;
    private final AnnotatedMixinElementHandlerInjector injectors;
    private final AnnotatedMixinElementHandlerAccessor accessors;
    private final AnnotatedMixinElementHandlerSoftImplements softImplements;
    private boolean validated = 0xD406AD07 ^ 0xD406AD07;

    public AnnotatedMixin(IMixinAnnotationProcessor iMixinAnnotationProcessor, TypeElement typeElement) {
        this.typeProvider = iMixinAnnotationProcessor.getTypeProvider();
        this.obf = iMixinAnnotationProcessor.getObfuscationManager();
        this.mappings = this.obf.createMappingConsumer();
        this.messager = iMixinAnnotationProcessor;
        this.mixin = typeElement;
        this.handle = new TypeHandle(typeElement);
        ElementKind[] elementKindArray = new ElementKind[0x37868460 ^ 0x37868461];
        elementKindArray[0x28C78A95 ^ 0x28C78A95] = ElementKind.METHOD;
        this.methods = new ArrayList(this.handle.getEnclosedElements(elementKindArray));
        this.virtual = this.handle.getAnnotation(Pseudo.class).exists();
        this.annotation = this.handle.getAnnotation(Mixin.class);
        this.classRef = TypeUtils.getInternalName(typeElement);
        this.primaryTarget = this.initTargets();
        this.remap = this.annotation.getBoolean(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("`\ua7e3\ua4b8\ua070\ua915"), (0x653C4EF8 ^ 0x653C4EF9) != 0) && this.targets.size() > 0 ? 0x5AFD90A7 ^ 0x5AFD90A6 : 0x94A4DDCB ^ 0x94A4DDCB;
        this.overwrites = new AnnotatedMixinElementHandlerOverwrite(iMixinAnnotationProcessor, this);
        this.shadows = new AnnotatedMixinElementHandlerShadow(iMixinAnnotationProcessor, this);
        this.injectors = new AnnotatedMixinElementHandlerInjector(iMixinAnnotationProcessor, this);
        this.accessors = new AnnotatedMixinElementHandlerAccessor(iMixinAnnotationProcessor, this);
        this.softImplements = new AnnotatedMixinElementHandlerSoftImplements(iMixinAnnotationProcessor, this);
    }

    AnnotatedMixin runValidators(IMixinValidator.ValidationPass validationPass, Collection<IMixinValidator> collection) {
        for (IMixinValidator iMixinValidator : collection) {
            if (!iMixinValidator.validate(validationPass, this.mixin, this.annotation, this.targets)) break;
        }
        if (validationPass == IMixinValidator.ValidationPass.FINAL && !this.validated) {
            this.validated = 0xB9FB7946 ^ 0xB9FB7947;
            this.runFinalValidation();
        }
        return this;
    }

    private TypeHandle initTargets() {
        TypeHandle typeHandle;
        TypeHandle typeHandle2 = null;
        try {
            for (Object object : this.annotation.getList()) {
                typeHandle = new TypeHandle((DeclaredType)object);
                if (this.targets.contains(typeHandle)) continue;
                this.addTarget(typeHandle);
                if (typeHandle2 != null) continue;
                typeHandle2 = typeHandle;
            }
        }
        catch (Exception exception) {
            this.printMessage(Diagnostic.Kind.WARNING, \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("W\ua7f4\ua4a7\ua07e\ua917\u7d36\u8e5a\u2468\u8b38\u3474w\ua7f5\ua4a6\ua078\ua90b\u7d71\u8e0a\u246a\u8b22\u3475~\ua7ef\ua4b6\ua031\ua911\u7d77\u8e58\u247d\u8b32\u3463a\ua7bc\ua4f5") + exception.getClass().getName() + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("(\ua7a6") + exception.getMessage(), this);
        }
        try {
            for (Object object : this.annotation.getList(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("f\ua7e7\ua4a7\ua076\ua900\u7d62\u8e59"))) {
                typeHandle = this.typeProvider.getTypeHandle((String)object);
                if (this.targets.contains(typeHandle)) continue;
                if (this.virtual) {
                    typeHandle = this.typeProvider.getSimulatedHandle((String)object, this.mixin.asType());
                } else {
                    if (typeHandle == null) {
                        this.printMessage(Diagnostic.Kind.ERROR, \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("_\ua7ef\ua4ad\ua078\ua90b\u7d36\u8e5e\u247b\u8b25\u3470w\ua7f2\ua4f5") + (String)object + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2\ua7e5\ua4ba\ua064\ua909\u7d72\u8e0a\u2474\u8b38\u34632\ua7e4\ua4b0\ua031\ua903\u7d79\u8e5f\u2474\u8b33"), this);
                        return null;
                    }
                    if (typeHandle.isPublic()) {
                        this.printMessage(Diagnostic.Kind.WARNING, \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("_\ua7ef\ua4ad\ua078\ua90b\u7d36\u8e5e\u247b\u8b25\u3470w\ua7f2\ua4f5") + (String)object + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2\ua7ef\ua4a6\ua031\ua915\u7d63\u8e48\u2476\u8b3e\u34742\ua7e7\ua4bb\ua075\ua945\u7d7b\u8e5f\u2469\u8b23\u3437p\ua7e3\ua4f5\ua062\ua915\u7d73\u8e49\u2473\u8b31\u347ew\ua7e2\ua4f5\ua078\ua90b\u7d36\u8e5c\u247b\u8b3b\u3462w"), this);
                        return null;
                    }
                }
                this.addSoftTarget(typeHandle, (String)object);
                if (typeHandle2 != null) continue;
                typeHandle2 = typeHandle;
            }
        }
        catch (Exception exception) {
            this.printMessage(Diagnostic.Kind.WARNING, \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("W\ua7f4\ua4a7\ua07e\ua917\u7d36\u8e5a\u2468\u8b38\u3474w\ua7f5\ua4a6\ua078\ua90b\u7d71\u8e0a\u246a\u8b25\u347ed\ua7e7\ua4a1\ua074\ua945\u7d62\u8e4b\u2468\u8b30\u3472f\ua7f5\ua4ef\ua031") + exception.getClass().getName() + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("(\ua7a6") + exception.getMessage(), this);
        }
        if (typeHandle2 == null) {
            this.printMessage(Diagnostic.Kind.ERROR, \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("_\ua7ef\ua4ad\ua078\ua90b\u7d36\u8e42\u247b\u8b24\u3437|\ua7e9\ua4f5\ua065\ua904\u7d64\u8e4d\u247f\u8b23\u3464"), this);
        }
        return typeHandle2;
    }

    private void printMessage(Diagnostic.Kind kind, CharSequence charSequence, AnnotatedMixin annotatedMixin) {
        this.messager.printMessage(kind, charSequence, this.mixin, this.annotation.asMirror());
    }

    private void addSoftTarget(TypeHandle typeHandle, String string) {
        ObfuscationData<String> obfuscationData = this.obf.getDataProvider().getObfClass(typeHandle);
        if (!obfuscationData.isEmpty()) {
            this.obf.getReferenceManager().addClassMapping(this.classRef, string, obfuscationData);
        }
        this.addTarget(typeHandle);
    }

    private void addTarget(TypeHandle typeHandle) {
        this.targets.add(typeHandle);
    }

    public String toString() {
        return this.mixin.getSimpleName().toString();
    }

    public AnnotationHandle getAnnotation() {
        return this.annotation;
    }

    public TypeElement getMixin() {
        return this.mixin;
    }

    public TypeHandle getHandle() {
        return this.handle;
    }

    public String getClassRef() {
        return this.classRef;
    }

    public boolean isInterface() {
        return (this.mixin.getKind() == ElementKind.INTERFACE ? 0x96ABAA9F ^ 0x96ABAA9E : 0xFE9B72CE ^ 0xFE9B72CE) != 0;
    }

    @Deprecated
    public TypeHandle getPrimaryTarget() {
        return this.primaryTarget;
    }

    public List<TypeHandle> getTargets() {
        return this.targets;
    }

    public boolean isMultiTarget() {
        return (this.targets.size() > (0x50565CD8 ^ 0x50565CD9) ? 0x3A1A3C65 ^ 0x3A1A3C64 : 0xBBCC7E06 ^ 0xBBCC7E06) != 0;
    }

    public boolean remap() {
        return this.remap;
    }

    public IMappingConsumer getMappings() {
        return this.mappings;
    }

    private void runFinalValidation() {
        for (ExecutableElement executableElement : this.methods) {
            this.overwrites.registerMerge(executableElement);
        }
    }

    public void registerOverwrite(ExecutableElement executableElement, AnnotationHandle annotationHandle, boolean bl) {
        this.methods.remove(executableElement);
        this.overwrites.registerOverwrite(new AnnotatedMixinElementHandlerOverwrite.AnnotatedElementOverwrite(executableElement, annotationHandle, bl));
    }

    public void registerShadow(VariableElement variableElement, AnnotationHandle annotationHandle, boolean bl) {
        AnnotatedMixinElementHandlerShadow annotatedMixinElementHandlerShadow = this.shadows;
        annotatedMixinElementHandlerShadow.getClass();
        this.shadows.registerShadow(new AnnotatedMixinElementHandlerShadow.AnnotatedElementShadowField(annotatedMixinElementHandlerShadow, variableElement, annotationHandle, bl));
    }

    public void registerShadow(ExecutableElement executableElement, AnnotationHandle annotationHandle, boolean bl) {
        this.methods.remove(executableElement);
        AnnotatedMixinElementHandlerShadow annotatedMixinElementHandlerShadow = this.shadows;
        annotatedMixinElementHandlerShadow.getClass();
        this.shadows.registerShadow(new AnnotatedMixinElementHandlerShadow.AnnotatedElementShadowMethod(annotatedMixinElementHandlerShadow, executableElement, annotationHandle, bl));
    }

    public void registerInjector(ExecutableElement executableElement, AnnotationHandle annotationHandle, InjectorRemap injectorRemap) {
        this.methods.remove(executableElement);
        this.injectors.registerInjector(new AnnotatedMixinElementHandlerInjector.AnnotatedElementInjector(executableElement, annotationHandle, injectorRemap));
        List<AnnotationHandle> list = annotationHandle.getAnnotationList(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("s\ua7f2"));
        for (AnnotationHandle object2 : list) {
            this.registerInjectionPoint(executableElement, annotationHandle, object2, injectorRemap, \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("R\ua7c7\ua4a1\ua039\ua940\u7d65\u8e03"));
        }
        List<AnnotationHandle> list2 = annotationHandle.getAnnotationList(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("a\ua7ea\ua4bc\ua072\ua900"));
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            AnnotationHandle annotationHandle2;
            AnnotationHandle annotationHandle3 = (AnnotationHandle)iterator.next();
            String string = annotationHandle3.getValue(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("{\ua7e2"), \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20(""));
            AnnotationHandle annotationHandle4 = annotationHandle3.getAnnotation(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("t\ua7f4\ua4ba\ua07c"));
            if (annotationHandle4 != null) {
                this.registerInjectionPoint(executableElement, annotationHandle, annotationHandle4, injectorRemap, \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("R\ua7d5\ua4b9\ua078\ua906\u7d73\u8e71") + string + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("O\ua7ae\ua4b3\ua063\ua90a\u7d7b\u8e17\u245a\u8b16\u3463:\ua7a3\ua4a6\ua038\ua94c"));
            }
            if ((annotationHandle2 = annotationHandle3.getAnnotation(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("f\ua7e9"))) == null) continue;
            this.registerInjectionPoint(executableElement, annotationHandle, annotationHandle2, injectorRemap, \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("R\ua7d5\ua4b9\ua078\ua906\u7d73\u8e71") + string + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("O\ua7ae\ua4a1\ua07e\ua958\u7d56\u8e6b\u246e\u8b7f\u3432a\ua7af\ua4fc"));
        }
    }

    public void registerInjectionPoint(ExecutableElement executableElement, AnnotationHandle annotationHandle, AnnotationHandle annotationHandle2, InjectorRemap injectorRemap, String string) {
        this.injectors.registerInjectionPoint(new AnnotatedMixinElementHandlerInjector.AnnotatedElementInjectionPoint(executableElement, annotationHandle, annotationHandle2, injectorRemap), string);
    }

    public void registerAccessor(ExecutableElement executableElement, AnnotationHandle annotationHandle, boolean bl) {
        this.methods.remove(executableElement);
        this.accessors.registerAccessor(new AnnotatedMixinElementHandlerAccessor.AnnotatedElementAccessor(executableElement, annotationHandle, bl));
    }

    public void registerInvoker(ExecutableElement executableElement, AnnotationHandle annotationHandle, boolean bl) {
        this.methods.remove(executableElement);
        this.accessors.registerAccessor(new AnnotatedMixinElementHandlerAccessor.AnnotatedElementInvoker(executableElement, annotationHandle, bl));
    }

    public void registerSoftImplements(AnnotationHandle annotationHandle) {
        this.softImplements.process(annotationHandle);
    }
}

