/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.tools.obfuscation.mirror;

import com.google.common.collect.ImmutableList;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2;

public final class AnnotationHandle {
    public static final AnnotationHandle MISSING = new AnnotationHandle(null);
    private final AnnotationMirror annotation;

    private AnnotationHandle(AnnotationMirror annotationMirror) {
        this.annotation = annotationMirror;
    }

    public AnnotationMirror asMirror() {
        return this.annotation;
    }

    public boolean exists() {
        return (this.annotation != null ? 0x48057D63 ^ 0x48057D62 : 0xD0BA1E78 ^ 0xD0BA1E78) != 0;
    }

    public String toString() {
        if (this.annotation == null) {
            return \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("R\ua7fd\ua480\ua07f\ua90e\u7d78\u8e45\u246d\u8b39\u3456|\ua7e8\ua4ba\ua065\ua904\u7d62\u8e43\u2475\u8b39\u346a");
        }
        return \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("R") + this.annotation.getAnnotationType().asElement().getSimpleName();
    }

    public <T> T getValue(String string, T t) {
        if (this.annotation == null) {
            return t;
        }
        AnnotationValue annotationValue = this.getAnnotationValue(string);
        if (t instanceof Enum && annotationValue != null) {
            VariableElement variableElement = (VariableElement)annotationValue.getValue();
            if (variableElement == null) {
                return t;
            }
            return (T)Enum.valueOf(t.getClass(), variableElement.getSimpleName().toString());
        }
        return (T)(annotationValue != null ? annotationValue.getValue() : t);
    }

    public <T> T getValue() {
        return this.getValue(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("d\ua7e7\ua4b9\ua064\ua900"), null);
    }

    public <T> T getValue(String string) {
        return this.getValue(string, null);
    }

    public boolean getBoolean(String string, boolean bl) {
        return this.getValue(string, bl);
    }

    public AnnotationHandle getAnnotation(String string) {
        Object object;
        Object t = this.getValue(string);
        if (t instanceof AnnotationMirror) {
            return AnnotationHandle.of((AnnotationMirror)t);
        }
        if (t instanceof AnnotationValue && (object = ((AnnotationValue)t).getValue()) instanceof AnnotationMirror) {
            return AnnotationHandle.of((AnnotationMirror)object);
        }
        return null;
    }

    public <T> List<T> getList() {
        return this.getList(\u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("d\ua7e7\ua4b9\ua064\ua900"));
    }

    public <T> List<T> getList(String string) {
        List<AnnotationValue> list = this.getValue(string, Collections.emptyList());
        return AnnotationHandle.unwrapAnnotationValueList(list);
    }

    public List<AnnotationHandle> getAnnotationList(String string) {
        Object var2_2 = this.getValue(string, null);
        if (var2_2 == null) {
            return Collections.emptyList();
        }
        if (var2_2 instanceof AnnotationMirror) {
            return ImmutableList.of((Object)AnnotationHandle.of(var2_2));
        }
        List list = var2_2;
        ArrayList<AnnotationHandle> arrayList = new ArrayList<AnnotationHandle>(list.size());
        for (AnnotationValue annotationValue : list) {
            arrayList.add(new AnnotationHandle((AnnotationMirror)annotationValue.getValue()));
        }
        return Collections.unmodifiableList(arrayList);
    }

    protected AnnotationValue getAnnotationValue(String string) {
        for (ExecutableElement executableElement : this.annotation.getElementValues().keySet()) {
            if (!executableElement.getSimpleName().contentEquals(string)) continue;
            return this.annotation.getElementValues().get(executableElement);
        }
        return null;
    }

    protected static <T> List<T> unwrapAnnotationValueList(List<AnnotationValue> list) {
        if (list == null) {
            return Collections.emptyList();
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
        for (AnnotationValue annotationValue : list) {
            arrayList.add(annotationValue.getValue());
        }
        return arrayList;
    }

    protected static AnnotationMirror getAnnotation(Element element, Class<? extends Annotation> clazz) {
        if (element == null) {
            return null;
        }
        List<? extends AnnotationMirror> list = element.getAnnotationMirrors();
        if (list == null) {
            return null;
        }
        for (AnnotationMirror annotationMirror : list) {
            TypeElement typeElement;
            Element element2 = annotationMirror.getAnnotationType().asElement();
            if (!(element2 instanceof TypeElement) || !(typeElement = (TypeElement)element2).getQualifiedName().contentEquals(clazz.getName())) continue;
            return annotationMirror;
        }
        return null;
    }

    public static AnnotationHandle of(AnnotationMirror annotationMirror) {
        return new AnnotationHandle(annotationMirror);
    }

    public static AnnotationHandle of(Element element, Class<? extends Annotation> clazz) {
        return new AnnotationHandle(AnnotationHandle.getAnnotation(element, clazz));
    }
}

