/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.tools.obfuscation.mirror;

import com.google.common.collect.ImmutableList;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.spongepowered.asm.mixin.injection.struct.MemberInfo;
import org.spongepowered.asm.obfuscation.mapping.common.MappingMethod;
import org.spongepowered.tools.obfuscation.mirror.AnnotationHandle;
import org.spongepowered.tools.obfuscation.mirror.FieldHandle;
import org.spongepowered.tools.obfuscation.mirror.MethodHandle;
import org.spongepowered.tools.obfuscation.mirror.TypeReference;
import org.spongepowered.tools.obfuscation.mirror.TypeUtils;
import org.spongepowered.tools.obfuscation.mirror.mapping.ResolvableMappingMethod;

public class TypeHandle {
    private final String name;
    private final PackageElement pkg;
    private final TypeElement element;
    private TypeReference reference;

    public TypeHandle(PackageElement packageElement, String string) {
        this.name = string.replace((char)(0xC17CFAFC ^ 0xC17CFAD2), (char)(0x2B07B75E ^ 0x2B07B771));
        this.pkg = packageElement;
        this.element = null;
    }

    public TypeHandle(TypeElement typeElement) {
        this.pkg = TypeUtils.getPackage(typeElement);
        this.name = TypeUtils.getInternalName(typeElement);
        this.element = typeElement;
    }

    public TypeHandle(DeclaredType declaredType) {
        this((TypeElement)declaredType.asElement());
    }

    public final String toString() {
        return this.name.replace((char)(0xF6A71D5 ^ 0xF6A71FA), (char)(0xDF5BA837 ^ 0xDF5BA819));
    }

    public final String getName() {
        return this.name;
    }

    public final PackageElement getPackage() {
        return this.pkg;
    }

    public final TypeElement getElement() {
        return this.element;
    }

    protected TypeElement getTargetElement() {
        return this.element;
    }

    public AnnotationHandle getAnnotation(Class<? extends Annotation> clazz) {
        return AnnotationHandle.of(this.getTargetElement(), clazz);
    }

    public final List<? extends Element> getEnclosedElements() {
        return TypeHandle.getEnclosedElements(this.getTargetElement());
    }

    public <T extends Element> List<T> getEnclosedElements(ElementKind ... elementKindArray) {
        return TypeHandle.getEnclosedElements(this.getTargetElement(), elementKindArray);
    }

    public TypeMirror getType() {
        return this.getTargetElement() != null ? this.getTargetElement().asType() : null;
    }

    public TypeHandle getSuperclass() {
        TypeElement typeElement = this.getTargetElement();
        if (typeElement == null) {
            return null;
        }
        TypeMirror typeMirror = typeElement.getSuperclass();
        if (typeMirror == null || typeMirror.getKind() == TypeKind.NONE) {
            return null;
        }
        return new TypeHandle((DeclaredType)typeMirror);
    }

    public List<TypeHandle> getInterfaces() {
        if (this.getTargetElement() == null) {
            return Collections.emptyList();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (TypeMirror typeMirror : this.getTargetElement().getInterfaces()) {
            builder.add((Object)new TypeHandle((DeclaredType)typeMirror));
        }
        return builder.build();
    }

    public boolean isPublic() {
        return (this.getTargetElement() != null && this.getTargetElement().getModifiers().contains((Object)Modifier.PUBLIC) ? 0xFE69480E ^ 0xFE69480F : 0x79EFACC ^ 0x79EFACC) != 0;
    }

    public boolean isImaginary() {
        return (this.getTargetElement() == null ? 0x3E87A02C ^ 0x3E87A02D : 0x670E566 ^ 0x670E566) != 0;
    }

    public boolean isSimulated() {
        return (0xCAE2290D ^ 0xCAE2290D) != 0;
    }

    public final TypeReference getReference() {
        if (this.reference == null) {
            this.reference = new TypeReference(this);
        }
        return this.reference;
    }

    public MappingMethod getMappingMethod(String string, String string2) {
        return new ResolvableMappingMethod(this, string, string2);
    }

    public String findDescriptor(MemberInfo memberInfo) {
        String string = memberInfo.desc;
        if (string == null) {
            ElementKind[] elementKindArray = new ElementKind[0x837074CB ^ 0x837074CA];
            elementKindArray[0xE4CE7D9 ^ 0xE4CE7D9] = ElementKind.METHOD;
            for (ExecutableElement executableElement : this.getEnclosedElements(elementKindArray)) {
                if (!executableElement.getSimpleName().toString().equals(memberInfo.name)) continue;
                string = TypeUtils.getDescriptor(executableElement);
                break;
            }
        }
        return string;
    }

    public final FieldHandle findField(VariableElement variableElement) {
        return this.findField(variableElement, (0x6589D18A ^ 0x6589D18B) != 0);
    }

    public final FieldHandle findField(VariableElement variableElement, boolean bl) {
        return this.findField(variableElement.getSimpleName().toString(), TypeUtils.getTypeName(variableElement.asType()), bl);
    }

    public final FieldHandle findField(String string, String string2) {
        return this.findField(string, string2, (0xDC2F1ED0 ^ 0xDC2F1ED1) != 0);
    }

    public FieldHandle findField(String string, String string2, boolean bl) {
        String string3 = TypeUtils.stripGenerics(string2);
        ElementKind[] elementKindArray = new ElementKind[0xDAB5011B ^ 0xDAB5011A];
        elementKindArray[0x4B0A8E7C ^ 0x4B0A8E7C] = ElementKind.FIELD;
        for (VariableElement variableElement : this.getEnclosedElements(elementKindArray)) {
            if (TypeHandle.compareElement(variableElement, string, string2, bl)) {
                return new FieldHandle(this.getTargetElement(), variableElement);
            }
            if (!TypeHandle.compareElement(variableElement, string, string3, bl)) continue;
            return new FieldHandle(this.getTargetElement(), variableElement, (0x5D09F6AB ^ 0x5D09F6AA) != 0);
        }
        return null;
    }

    public final MethodHandle findMethod(ExecutableElement executableElement) {
        return this.findMethod(executableElement, (0xEAF853EF ^ 0xEAF853EE) != 0);
    }

    public final MethodHandle findMethod(ExecutableElement executableElement, boolean bl) {
        return this.findMethod(executableElement.getSimpleName().toString(), TypeUtils.getJavaSignature(executableElement), bl);
    }

    public final MethodHandle findMethod(String string, String string2) {
        return this.findMethod(string, string2, (0x61FBAB96 ^ 0x61FBAB97) != 0);
    }

    public MethodHandle findMethod(String string, String string2, boolean bl) {
        String string3 = TypeUtils.stripGenerics(string2);
        return TypeHandle.findMethod(this, string, string2, string3, bl);
    }

    protected static MethodHandle findMethod(TypeHandle typeHandle, String string, String string2, String string3, boolean bl) {
        ElementKind[] elementKindArray = new ElementKind[0x1A4E0E1E ^ 0x1A4E0E1C];
        elementKindArray[0x83496875 ^ 0x83496875] = ElementKind.CONSTRUCTOR;
        elementKindArray[0x78996ED1 ^ 0x78996ED0] = ElementKind.METHOD;
        for (ExecutableElement executableElement : TypeHandle.getEnclosedElements(typeHandle.getTargetElement(), elementKindArray)) {
            if (!TypeHandle.compareElement(executableElement, string, string2, bl) && !TypeHandle.compareElement(executableElement, string, string3, bl)) continue;
            return new MethodHandle(typeHandle, executableElement);
        }
        return null;
    }

    protected static boolean compareElement(Element element, String string, String string2, boolean bl) {
        try {
            boolean bl2;
            String string3 = element.getSimpleName().toString();
            String string4 = TypeUtils.getJavaSignature(element);
            String string5 = TypeUtils.stripGenerics(string4);
            boolean bl3 = bl2 = bl ? string.equals(string3) : string.equalsIgnoreCase(string3);
            return (bl2 && (string2.length() == 0 || string2.equals(string4) || string2.equals(string5)) ? 0x9D188755 ^ 0x9D188754 : 0xB7341891 ^ 0xB7341891) != 0;
        }
        catch (NullPointerException nullPointerException) {
            return (0xCEAB3907 ^ 0xCEAB3907) != 0;
        }
    }

    protected static <T extends Element> List<T> getEnclosedElements(TypeElement typeElement, ElementKind ... elementKindArray) {
        block7: {
            block6: {
                if (elementKindArray == null) break block6;
                if (elementKindArray.length >= (0x7802B8B6 ^ 0x7802B8B7)) break block7;
            }
            return TypeHandle.getEnclosedElements(typeElement);
        }
        if (typeElement == null) {
            return Collections.emptyList();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        block0: for (Element element : typeElement.getEnclosedElements()) {
            ElementKind[] elementKindArray2 = elementKindArray;
            int n = elementKindArray2.length;
            for (int i = 0x8B032A3D ^ 0x8B032A3D; i < n; ++i) {
                ElementKind elementKind = elementKindArray2[i];
                if (element.getKind() != elementKind) continue;
                builder.add((Object)element);
                continue block0;
            }
        }
        return builder.build();
    }

    protected static List<? extends Element> getEnclosedElements(TypeElement typeElement) {
        return typeElement != null ? typeElement.getEnclosedElements() : Collections.emptyList();
    }
}

