/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.tools.obfuscation.service;

import java.util.Collection;
import java.util.HashSet;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import javax.tools.Diagnostic;
import org.spongepowered.tools.obfuscation.ObfuscationType;
import org.spongepowered.tools.obfuscation.interfaces.IMixinAnnotationProcessor;
import org.spongepowered.tools.obfuscation.service.IObfuscationService;
import org.spongepowered.tools.obfuscation.service.ObfuscationTypeDescriptor;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2;

public final class ObfuscationServices {
    private static ObfuscationServices instance;
    private final ServiceLoader<IObfuscationService> serviceLoader;
    private final Set<IObfuscationService> services = new HashSet<IObfuscationService>();

    private ObfuscationServices() {
        this.serviceLoader = ServiceLoader.load(IObfuscationService.class, this.getClass().getClassLoader());
    }

    public static ObfuscationServices getInstance() {
        if (instance == null) {
            instance = new ObfuscationServices();
        }
        return instance;
    }

    public void initProviders(IMixinAnnotationProcessor iMixinAnnotationProcessor) {
        try {
            for (IObfuscationService iObfuscationService : this.serviceLoader) {
                if (this.services.contains(iObfuscationService)) continue;
                this.services.add(iObfuscationService);
                String string = iObfuscationService.getClass().getSimpleName();
                Collection<ObfuscationTypeDescriptor> collection = iObfuscationService.getObfuscationTypes();
                if (collection == null) continue;
                for (ObfuscationTypeDescriptor obfuscationTypeDescriptor : collection) {
                    try {
                        ObfuscationType obfuscationType = ObfuscationType.create(obfuscationTypeDescriptor, iMixinAnnotationProcessor);
                        iMixinAnnotationProcessor.printMessage(Diagnostic.Kind.NOTE, string + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("2\ua7f5\ua4a0\ua061\ua915\u7d79\u8e58\u246e\u8b24\u3437f\ua7ff\ua4a5\ua074\ua95f\u7d36\u8e08") + obfuscationType + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("0"));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }
        catch (ServiceConfigurationError serviceConfigurationError) {
            iMixinAnnotationProcessor.printMessage(Diagnostic.Kind.ERROR, serviceConfigurationError.getClass().getSimpleName() + \u7eb3\u897f\u59b2.\u6211\u7684\u8fc7\u5f80\u76f8\u5f53\u5355\u8c03\u4f30\u8ba1\u4f60\u542c\u4e0a\u4e00\u4f1a\u513f\u5c31\u4f1a\u50cf\u70ae\u9c80\u5438\u6c34\u90a3\u6837\u6253\u54c8\u6b20("(\ua7a6") + serviceConfigurationError.getMessage());
            serviceConfigurationError.printStackTrace();
        }
    }

    public Set<String> getSupportedOptions() {
        HashSet<String> hashSet = new HashSet<String>();
        for (IObfuscationService iObfuscationService : this.serviceLoader) {
            Set<String> set = iObfuscationService.getSupportedOptions();
            if (set == null) continue;
            hashSet.addAll(set);
        }
        return hashSet;
    }

    public IObfuscationService getService(Class<? extends IObfuscationService> clazz) {
        for (IObfuscationService iObfuscationService : this.serviceLoader) {
            if (!clazz.getName().equals(iObfuscationService.getClass().getName())) continue;
            return iObfuscationService;
        }
        return null;
    }
}

