/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.launch.platform;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.launch.platform.MainAttributes;
import org.spongepowered.asm.launch.platform.MixinContainer;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.Mixins;
import org.spongepowered.asm.service.MixinService;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2;

public class MixinPlatformManager {
    private static final String DEFAULT_MAIN_CLASS = "net.minecraft.client.main.Main";
    private static final String MIXIN_TWEAKER_CLASS = "org.spongepowered.asm.launch.MixinTweaker";
    private static final Logger logger = LogManager.getLogger((String)\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("\u007f\ua7ef\ua4ad\ua078\ua90b"));
    private final Map<URI, MixinContainer> containers = new LinkedHashMap<URI, MixinContainer>();
    private MixinContainer primaryContainer;
    private boolean prepared = 0x89E40CCA ^ 0x89E40CCA;
    private boolean injected;

    public void init() {
        logger.debug(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("[\ua7e8\ua4bc\ua065\ua90c\u7d77\u8e46\u2473\u8b24\u347e|\ua7e1\ua4f5\ua05c\ua90c\u7d6e\u8e43\u2474\u8b77\u3447~\ua7e7\ua4a1\ua077\ua90a\u7d64\u8e47\u243a\u8b1a\u3476|\ua7e7\ua4b2\ua074\ua917"));
        URI uRI = null;
        try {
            uRI = this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI();
            if (uRI != null) {
                Object[] objectArray = new Object[0xDEDB6B34 ^ 0xDEDB6B35];
                objectArray[0xD08C45FE ^ 0xD08C45FE] = uRI;
                logger.debug(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("_\ua7ef\ua4ad\ua078\ua90b\u7d36\u8e5a\u2476\u8b36\u3463t\ua7e9\ua4a7\ua07c\ua95f\u7d36\u8e5a\u2468\u8b3e\u347as\ua7f4\ua4ac\ua031\ua906\u7d79\u8e44\u246e\u8b36\u347e|\ua7e3\ua4a7\ua031\ua90c\u7d65\u8e0a\u2461\u8b2a"), objectArray);
                this.primaryContainer = this.addContainer(uRI);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
        this.scanClasspath();
    }

    public Collection<String> getPhaseProviderClasses() {
        Collection<String> collection = this.primaryContainer.getPhaseProviders();
        if (collection != null) {
            return Collections.unmodifiableCollection(collection);
        }
        return Collections.emptyList();
    }

    public final MixinContainer addContainer(URI uRI) {
        MixinContainer mixinContainer = this.containers.get(uRI);
        if (mixinContainer != null) {
            return mixinContainer;
        }
        Object[] objectArray = new Object[0x3CA294D ^ 0x3CA294C];
        objectArray[0xC5F596F8 ^ 0xC5F596F8] = uRI;
        logger.debug(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("S\ua7e2\ua4b1\ua078\ua90b\u7d71\u8e0a\u2477\u8b3e\u346f{\ua7e8\ua4f5\ua061\ua909\u7d77\u8e5e\u247c\u8b38\u3465\u007f\ua7a6\ua4b4\ua076\ua900\u7d78\u8e5e\u2469\u8b77\u3471}\ua7f4\ua4f5\ua072\ua90a\u7d78\u8e5e\u247b\u8b3e\u3479w\ua7f4\ua4f5\ua06a\ua918"), objectArray);
        MixinContainer mixinContainer2 = new MixinContainer(this, uRI);
        this.containers.put(uRI, mixinContainer2);
        if (this.prepared) {
            mixinContainer2.prepare();
        }
        return mixinContainer2;
    }

    public final void prepare(List<String> list) {
        this.prepared = 0x16B16329 ^ 0x16B16328;
        for (MixinContainer mixinContainer : this.containers.values()) {
            mixinContainer.prepare();
        }
        if (list != null) {
            this.parseArgs(list);
        } else {
            String string = System.getProperty(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("a\ua7f3\ua4bb\ua03f\ua90f\u7d77\u8e5c\u247b\u8b79\u3474}\ua7eb\ua4b8\ua070\ua90b\u7d72"));
            if (string != null) {
                this.parseArgs(Arrays.asList(string.split(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2"))));
            }
        }
    }

    private void parseArgs(List<String> list) {
        int n = 0xDBF64F36 ^ 0xDBF64F36;
        for (String string : list) {
            if (n != 0) {
                this.addConfig(string);
            }
            n = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("?\ua7ab\ua4b8\ua078\ua91d\u7d7f\u8e44").equals(string) ? 1 : 0;
        }
    }

    public final void inject() {
        if (this.injected) {
            return;
        }
        this.injected = 0xA418371 ^ 0xA418370;
        if (this.primaryContainer != null) {
            this.primaryContainer.initPrimaryContainer();
        }
        this.scanClasspath();
        Object[] objectArray = new Object[0x2B078C96 ^ 0x2B078C97];
        objectArray[0x7BBDA0E ^ 0x7BBDA0E] = this.containers.size();
        logger.debug(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("{\ua7e8\ua4bf\ua074\ua906\u7d62\u8e02\u2433\u8b77\u3465g\ua7e8\ua4bb\ua078\ua90b\u7d71\u8e0a\u246d\u8b3e\u3463z\ua7a6\ua4ae\ua06c\ua945\u7d77\u8e4d\u247f\u8b39\u3463a"), objectArray);
        for (MixinContainer mixinContainer : this.containers.values()) {
            try {
                mixinContainer.inject();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void scanClasspath() {
        URL[] uRLArray;
        URL[] uRLArray2 = uRLArray = MixinService.getService().getClassProvider().getClassPath();
        int n = uRLArray2.length;
        for (int i = 0x19045F0F ^ 0x19045F0F; i < n; ++i) {
            URL uRL = uRLArray2[i];
            try {
                URI uRI = uRL.toURI();
                if (this.containers.containsKey(uRI)) continue;
                Object[] objectArray = new Object[0x4BD4FAB6 ^ 0x4BD4FAB7];
                objectArray[0x31ED2EB7 ^ 0x31ED2EB7] = uRI;
                logger.debug(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("A\ua7e5\ua4b4\ua07f\ua90b\u7d7f\u8e44\u247d\u8b77\u346co\ua7a6\ua4b3\ua07e\ua917\u7d36\u8e47\u2473\u8b2f\u347e|\ua7a6\ua4a1\ua066\ua900\u7d77\u8e41\u247f\u8b25"), objectArray);
                if (!\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("t\ua7ef\ua4b9\ua074").equals(uRI.getScheme()) || !new File(uRI).exists()) continue;
                MainAttributes mainAttributes = MainAttributes.of(uRI);
                String string = mainAttributes.get(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("F\ua7f1\ua4b0\ua070\ua90e\u7d55\u8e46\u247b\u8b24\u3464"));
                if (!\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("}\ua7f4\ua4b2\ua03f\ua916\u7d66\u8e45\u2474\u8b30\u3472b\ua7e9\ua4a2\ua074\ua917\u7d73\u8e4e\u2434\u8b36\u3464\u007f\ua7a8\ua4b9\ua070\ua910\u7d78\u8e49\u2472\u8b79\u345a{\ua7fe\ua4bc\ua07f\ua931\u7d61\u8e4f\u247b\u8b3c\u3472`").equals(string)) continue;
                Object[] objectArray2 = new Object[0xA26A24F6 ^ 0xA26A24F7];
                objectArray2[0xB587B4 ^ 0xB587B4] = uRI;
                logger.debug(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("i\ua7fb\ua4f5\ua072\ua90a\u7d78\u8e5e\u247b\u8b3e\u3479a\ua7a6\ua4b4\ua031\ua908\u7d7f\u8e52\u2473\u8b39\u3437f\ua7f1\ua4b0\ua070\ua90e\u7d73\u8e58\u2436\u8b77\u3476v\ua7e2\ua4bc\ua07f\ua902\u7d36\u8e4b\u247d\u8b32\u3479f\ua7f5"), objectArray2);
                this.addContainer(uRI);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public String getLaunchTarget() {
        for (MixinContainer mixinContainer : this.containers.values()) {
            String string = mixinContainer.getLaunchTarget();
            if (string == null) continue;
            return string;
        }
        return \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("|\ua7e3\ua4a1\ua03f\ua908\u7d7f\u8e44\u247f\u8b34\u3465s\ua7e0\ua4a1\ua03f\ua906\u7d7a\u8e43\u247f\u8b39\u3463<\ua7eb\ua4b4\ua078\ua90b\u7d38\u8e67\u247b\u8b3e\u3479");
    }

    final void setCompatibilityLevel(String string) {
        try {
            MixinEnvironment.CompatibilityLevel compatibilityLevel = MixinEnvironment.CompatibilityLevel.valueOf(string.toUpperCase());
            Object[] objectArray = new Object[0xE613C0AE ^ 0xE613C0AF];
            objectArray[0x3338E69 ^ 0x3338E69] = compatibilityLevel;
            logger.debug(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("A\ua7e3\ua4a1\ua065\ua90c\u7d78\u8e4d\u243a\u8b3a\u347ej\ua7ef\ua4bb\ua031\ua906\u7d79\u8e47\u246a\u8b36\u3463{\ua7e4\ua4bc\ua07d\ua90c\u7d62\u8e53\u243a\u8b3b\u3472d\ua7e3\ua4b9\ua02b\ua945\u7d6d\u8e57"), objectArray);
            MixinEnvironment.setCompatibilityLevel(compatibilityLevel);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Object[] objectArray = new Object[0x5805B831 ^ 0x5805B830];
            objectArray[0xF318F790 ^ 0xF318F790] = string;
            logger.warn(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b34\u3478\u007f\ua7f6\ua4b4\ua065\ua90c\u7d74\u8e43\u2476\u8b3e\u3463k\ua7a6\ua4b9\ua074\ua913\u7d73\u8e46\u243a\u8b24\u3467w\ua7e5\ua4bc\ua077\ua90c\u7d73\u8e4e\u2420\u8b77\u346co"), objectArray);
        }
    }

    final void addConfig(String string) {
        if (string.endsWith(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("<\ua7ec\ua4a6\ua07e\ua90b"))) {
            Object[] objectArray = new Object[0x998F559B ^ 0x998F559A];
            objectArray[0x753B24E5 ^ 0x753B24E5] = string;
            logger.debug(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("@\ua7e3\ua4b2\ua078\ua916\u7d62\u8e4f\u2468\u8b3e\u3479u\ua7a6\ua4b8\ua078\ua91d\u7d7f\u8e44\u243a\u8b34\u3478|\ua7e0\ua4bc\ua076\ua95f\u7d36\u8e51\u2467"), objectArray);
            Mixins.addConfiguration(string);
        } else if (string.contains(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("<\ua7ec\ua4a6\ua07e\ua90b\u7d56"))) {
            int n = string.indexOf(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("<\ua7ec\ua4a6\ua07e\ua90b\u7d56"));
            String string2 = string.substring(n + (0x41EE26ED ^ 0x41EE26EB));
            string = string.substring(0xCB695352 ^ 0xCB695352, n + (0x3E4461D7 ^ 0x3E4461D2));
            MixinEnvironment.Phase phase = MixinEnvironment.Phase.forName(string2);
            if (phase != null) {
                Object[] objectArray = new Object[0xA7B5777F ^ 0xA7B5777E];
                objectArray[0x7AA9DB17 ^ 0x7AA9DB17] = string;
                logger.warn(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("A\ua7e3\ua4a1\ua065\ua90c\u7d78\u8e4d\u243a\u8b34\u3478|\ua7e0\ua4bc\ua076\ua945\u7d66\u8e42\u247b\u8b24\u34722\ua7f0\ua4bc\ua070\ua945\u7d7b\u8e4b\u2474\u8b3e\u3471w\ua7f5\ua4a1\ua031\ua90c\u7d65\u8e0a\u247e\u8b32\u3467`\ua7e3\ua4b6\ua070\ua911\u7d73\u8e4e\u2420\u8b77\u346co\ua7a8\ua4f5\ua042\ua915\u7d73\u8e49\u2473\u8b31\u346e2\ua7f2\ua4b4\ua063\ua902\u7d73\u8e5e\u243a\u8b3e\u34792\ua7e5\ua4ba\ua07f\ua903\u7d7f\u8e4d\u243a\u8b3e\u3479a\ua7f2\ua4b0\ua070\ua901"), objectArray);
                Object[] objectArray2 = new Object[0x845D382F ^ 0x845D382E];
                objectArray2[0xA6D24CDA ^ 0xA6D24CDA] = string;
                logger.debug(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("@\ua7e3\ua4b2\ua078\ua916\u7d62\u8e4f\u2468\u8b3e\u3479u\ua7a6\ua4b8\ua078\ua91d\u7d7f\u8e44\u243a\u8b34\u3478|\ua7e0\ua4bc\ua076\ua95f\u7d36\u8e51\u2467"), objectArray2);
                MixinEnvironment.getEnvironment(phase).addConfiguration(string);
            }
        }
    }

    final void addTokenProvider(String string) {
        if (string.contains(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("R"))) {
            String[] stringArray = string.split(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("R"), 0x500D4710 ^ 0x500D4712);
            MixinEnvironment.Phase phase = MixinEnvironment.Phase.forName(stringArray[0x99E83246 ^ 0x99E83247]);
            if (phase != null) {
                Object[] objectArray = new Object[0xB20942F3 ^ 0xB20942F2];
                objectArray[0x9C2040DF ^ 0x9C2040DF] = stringArray[0x155DFF78 ^ 0x155DFF78];
                logger.debug(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("@\ua7e3\ua4b2\ua078\ua916\u7d62\u8e4f\u2468\u8b3e\u3479u\ua7a6\ua4a1\ua07e\ua90e\u7d73\u8e44\u243a\u8b27\u3465}\ua7f0\ua4bc\ua075\ua900\u7d64\u8e0a\u2479\u8b3b\u3476a\ua7f5\ua4ef\ua031\ua91e\u7d6b"), objectArray);
                MixinEnvironment.getEnvironment(phase).registerTokenProviderClass(stringArray[0x318357D ^ 0x318357D]);
            }
            return;
        }
        MixinEnvironment.getDefaultEnvironment().registerTokenProviderClass(string);
    }
}

