/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.lib;

public class ByteVector {
    byte[] data;
    int length;

    public ByteVector() {
        this.data = new byte[0xF7ECF324 ^ 0xF7ECF364];
    }

    public ByteVector(int n) {
        this.data = new byte[n];
    }

    public ByteVector putByte(int n) {
        int n2 = this.length;
        if (n2 + (0x200B891 ^ 0x200B890) > this.data.length) {
            this.enlarge(0x68710225 ^ 0x68710224);
        }
        this.data[n2++] = (byte)n;
        this.length = n2;
        return this;
    }

    ByteVector put11(int n, int n2) {
        int n3 = this.length;
        if (n3 + (0xB88CDD57 ^ 0xB88CDD55) > this.data.length) {
            this.enlarge(0x324211C7 ^ 0x324211C5);
        }
        byte[] byArray = this.data;
        byArray[n3++] = (byte)n;
        byArray[n3++] = (byte)n2;
        this.length = n3;
        return this;
    }

    public ByteVector putShort(int n) {
        int n2 = this.length;
        if (n2 + (0x5A0EDECA ^ 0x5A0EDEC8) > this.data.length) {
            this.enlarge(0x93A857 ^ 0x93A855);
        }
        byte[] byArray = this.data;
        int n3 = n2++;
        byArray[n3] = (byte)(n >>> (0xD2DA86B0 ^ 0xD2DA86B8));
        byArray[n2++] = (byte)n;
        this.length = n2;
        return this;
    }

    ByteVector put12(int n, int n2) {
        int n3 = this.length;
        if (n3 + (0x412B38AB ^ 0x412B38A8) > this.data.length) {
            this.enlarge(0xF43EFCE0 ^ 0xF43EFCE3);
        }
        byte[] byArray = this.data;
        byArray[n3++] = (byte)n;
        int n4 = n3++;
        byArray[n4] = (byte)(n2 >>> (0x72ED59D4 ^ 0x72ED59DC));
        byArray[n3++] = (byte)n2;
        this.length = n3;
        return this;
    }

    public ByteVector putInt(int n) {
        int n2 = this.length;
        if (n2 + (0xDE6B69D2 ^ 0xDE6B69D6) > this.data.length) {
            this.enlarge(0x253F8F00 ^ 0x253F8F04);
        }
        byte[] byArray = this.data;
        int n3 = n2++;
        byArray[n3] = (byte)(n >>> (0x62E3063E ^ 0x62E30626));
        int n4 = n2++;
        byArray[n4] = (byte)(n >>> (0x6AF1FCA6 ^ 0x6AF1FCB6));
        int n5 = n2++;
        byArray[n5] = (byte)(n >>> (0x8605EE43 ^ 0x8605EE4B));
        byArray[n2++] = (byte)n;
        this.length = n2;
        return this;
    }

    public ByteVector putLong(long l) {
        int n = this.length;
        if (n + (0xFAF68C7 ^ 0xFAF68CF) > this.data.length) {
            this.enlarge(0xAB0456A7 ^ 0xAB0456AF);
        }
        byte[] byArray = this.data;
        int n2 = (int)(l >>> (0x38187E4 ^ 0x38187C4));
        int n3 = n++;
        byArray[n3] = (byte)(n2 >>> (0xD6E6868D ^ 0xD6E68695));
        int n4 = n++;
        byArray[n4] = (byte)(n2 >>> (0x25C3FFC0 ^ 0x25C3FFD0));
        int n5 = n++;
        byArray[n5] = (byte)(n2 >>> (0xCE25CA60 ^ 0xCE25CA68));
        byArray[n++] = (byte)n2;
        n2 = (int)l;
        int n6 = n++;
        byArray[n6] = (byte)(n2 >>> (0x84B457AA ^ 0x84B457B2));
        int n7 = n++;
        byArray[n7] = (byte)(n2 >>> (0xE26498ED ^ 0xE26498FD));
        int n8 = n++;
        byArray[n8] = (byte)(n2 >>> (0xCACF895A ^ 0xCACF8952));
        byArray[n++] = (byte)n2;
        this.length = n;
        return this;
    }

    public ByteVector putUTF8(String string) {
        int n = string.length();
        if (n > (0x4BB13DD ^ 0x4BBEC22)) {
            throw new IllegalArgumentException();
        }
        int n2 = this.length;
        if (n2 + (0xF705E8B6 ^ 0xF705E8B4) + n > this.data.length) {
            this.enlarge((0x9EBDB206 ^ 0x9EBDB204) + n);
        }
        byte[] byArray = this.data;
        int n3 = n2++;
        byArray[n3] = (byte)(n >>> (0x2517685C ^ 0x25176854));
        byArray[n2++] = (byte)n;
        for (int i = 0xB0407C04 ^ 0xB0407C04; i < n; ++i) {
            char c;
            block7: {
                block6: {
                    c = string.charAt(i);
                    if (c < (0x3D4989CC ^ 0x3D4989CD)) break block6;
                    if (c <= (0xF5341A6F ^ 0xF5341A10)) break block7;
                }
                this.length = n2;
                return this.encodeUTF8(string, i, 0x19A90634 ^ 0x19A9F9CB);
            }
            byArray[n2++] = (byte)c;
        }
        this.length = n2;
        return this;
    }

    ByteVector encodeUTF8(String string, int n, int n2) {
        char c;
        int n3;
        int n4 = string.length();
        int n5 = n;
        for (n3 = n; n3 < n4; ++n3) {
            c = string.charAt(n3);
            if (c >= (0x748F54CB ^ 0x748F54CA)) {
                if (c <= (0xD958FACD ^ 0xD958FAB2)) {
                    ++n5;
                    continue;
                }
            }
            if (c > (0x89BA371D ^ 0x89BA30E2)) {
                n5 += 3;
                continue;
            }
            n5 += 2;
        }
        if (n5 > n2) {
            throw new IllegalArgumentException();
        }
        n3 = this.length - n - (0xD380A521 ^ 0xD380A523);
        if (n3 >= 0) {
            this.data[n3] = (byte)(n5 >>> (0x956E8CC4 ^ 0x956E8CCC));
            this.data[n3 + (0xDF0B1740 ^ 0xDF0B1741)] = (byte)n5;
        }
        if (this.length + n5 - n > this.data.length) {
            this.enlarge(n5 - n);
        }
        int n6 = this.length;
        for (int i = n; i < n4; ++i) {
            c = string.charAt(i);
            if (c >= (0x4449BC78 ^ 0x4449BC79)) {
                if (c <= (0x6E753DF7 ^ 0x6E753D88)) {
                    this.data[n6++] = (byte)c;
                    continue;
                }
            }
            if (c > (0xE49B1DD5 ^ 0xE49B1A2A)) {
                int n7 = n6++;
                this.data[n7] = (byte)(0x5426DD86 ^ 0x5426DD66 | c >> (0xA22D87AE ^ 0xA22D87A2) & (0x80B7E267 ^ 0x80B7E268));
                int n8 = n6++;
                this.data[n8] = (byte)(0x1A88074A ^ 0x1A8807CA | c >> (0x6D71E6CF ^ 0x6D71E6C9) & (0xE0599F67 ^ 0xE0599F58));
                int n9 = n6++;
                this.data[n9] = (byte)(0xFB7C4F0B ^ 0xFB7C4F8B | c & (0x1F0CB17B ^ 0x1F0CB144));
                continue;
            }
            int n10 = n6++;
            this.data[n10] = (byte)(0xA380E6FF ^ 0xA380E63F | c >> (0xB1DB6CB5 ^ 0xB1DB6CB3) & (0x3670E6E3 ^ 0x3670E6FC));
            int n11 = n6++;
            this.data[n11] = (byte)(0x47C5C610 ^ 0x47C5C690 | c & (0xAA72697F ^ 0xAA726940));
        }
        this.length = n6;
        return this;
    }

    public ByteVector putByteArray(byte[] byArray, int n, int n2) {
        if (this.length + n2 > this.data.length) {
            this.enlarge(n2);
        }
        if (byArray != null) {
            System.arraycopy(byArray, n, this.data, this.length, n2);
        }
        this.length += n2;
        return this;
    }

    private void enlarge(int n) {
        int n2 = (0x7AEEF029 ^ 0x7AEEF02B) * this.data.length;
        int n3 = this.length + n;
        byte[] byArray = new byte[n2 > n3 ? n2 : n3];
        System.arraycopy(this.data, 0x7C929473 ^ 0x7C929473, byArray, 0x72EE5EA2 ^ 0x72EE5EA2, this.length);
        this.data = byArray;
    }
}

