/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.lib;

final class Item {
    int index;
    int type;
    int intVal;
    long longVal;
    String strVal1;
    String strVal2;
    String strVal3;
    int hashCode;
    Item next;

    Item() {
    }

    Item(int n) {
        this.index = n;
    }

    Item(int n, Item item) {
        this.index = n;
        this.type = item.type;
        this.intVal = item.intVal;
        this.longVal = item.longVal;
        this.strVal1 = item.strVal1;
        this.strVal2 = item.strVal2;
        this.strVal3 = item.strVal3;
        this.hashCode = item.hashCode;
    }

    void set(int n) {
        this.type = 0xD04ACAFF ^ 0xD04ACAFC;
        this.intVal = n;
        this.hashCode = (0xD6EFC08A ^ 0xA9103F75) & this.type + n;
    }

    void set(long l) {
        this.type = 0xBB90A4F6 ^ 0xBB90A4F3;
        this.longVal = l;
        this.hashCode = (0x8F938693 ^ 0xF06C796C) & this.type + (int)l;
    }

    void set(float f) {
        this.type = 0xA804EE45 ^ 0xA804EE41;
        this.intVal = Float.floatToRawIntBits(f);
        this.hashCode = (0x556AB2FB ^ 0x2A954D04) & this.type + (int)f;
    }

    void set(double d) {
        this.type = 0xFC7508C7 ^ 0xFC7508C1;
        this.longVal = Double.doubleToRawLongBits(d);
        this.hashCode = (0x7A4510D2 ^ 0x5BAEF2D) & this.type + (int)d;
    }

    void set(int n, String string, String string2, String string3) {
        this.type = n;
        this.strVal1 = string;
        this.strVal2 = string2;
        this.strVal3 = string3;
        switch (n) {
            case 7: {
                this.intVal = 0x5FD3E5A9 ^ 0x5FD3E5A9;
            }
            case 1: 
            case 8: 
            case 16: 
            case 30: {
                this.hashCode = (0xEBDADBD8 ^ 0x94252427) & n + string.hashCode();
                return;
            }
            case 12: {
                this.hashCode = (0x30CD0032 ^ 0x4F32FFCD) & n + string.hashCode() * string2.hashCode();
                return;
            }
        }
        this.hashCode = (0xB9ADFA7C ^ 0xC6520583) & n + string.hashCode() * string2.hashCode() * string3.hashCode();
    }

    void set(String string, String string2, int n) {
        this.type = 0x3145360F ^ 0x3145361D;
        this.longVal = n;
        this.strVal1 = string;
        this.strVal2 = string2;
        this.hashCode = (0x877AD5A8 ^ 0xF8852A57) & (0xD1691753 ^ 0xD1691741) + n * this.strVal1.hashCode() * this.strVal2.hashCode();
    }

    void set(int n, int n2) {
        this.type = 0x5DDE7F0A ^ 0x5DDE7F2B;
        this.intVal = n;
        this.hashCode = n2;
    }

    boolean isEqualTo(Item item) {
        switch (this.type) {
            case 1: 
            case 7: 
            case 8: 
            case 16: 
            case 30: {
                return item.strVal1.equals(this.strVal1);
            }
            case 5: 
            case 6: 
            case 32: {
                return (item.longVal == this.longVal ? 0xE385CCC4 ^ 0xE385CCC5 : 0x8E513030 ^ 0x8E513030) != 0;
            }
            case 3: 
            case 4: {
                return (item.intVal == this.intVal ? 0x441108F7 ^ 0x441108F6 : 0x2E65AAF6 ^ 0x2E65AAF6) != 0;
            }
            case 31: {
                return (item.intVal == this.intVal && item.strVal1.equals(this.strVal1) ? 0x4ACB4852 ^ 0x4ACB4853 : 0x86691376 ^ 0x86691376) != 0;
            }
            case 12: {
                return (item.strVal1.equals(this.strVal1) && item.strVal2.equals(this.strVal2) ? 0xBF53DC7C ^ 0xBF53DC7D : 0x6E451441 ^ 0x6E451441) != 0;
            }
            case 18: {
                return (item.longVal == this.longVal && item.strVal1.equals(this.strVal1) && item.strVal2.equals(this.strVal2) ? 0x71D1524 ^ 0x71D1525 : 0x466C1824 ^ 0x466C1824) != 0;
            }
        }
        return (item.strVal1.equals(this.strVal1) && item.strVal2.equals(this.strVal2) && item.strVal3.equals(this.strVal3) ? 0x35BE055 ^ 0x35BE054 : 0xF9E1020E ^ 0xF9E1020E) != 0;
    }
}

