/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.lib.signature;

import org.spongepowered.asm.lib.signature.SignatureVisitor;

public class SignatureWriter
extends SignatureVisitor {
    private final StringBuilder buf = new StringBuilder();
    private boolean hasFormals;
    private boolean hasParameters;
    private int argumentStack;

    public SignatureWriter() {
        super(0x1A71F86A ^ 0x1A74F86A);
    }

    public void visitFormalTypeParameter(String string) {
        if (!this.hasFormals) {
            this.hasFormals = 0x185FB081 ^ 0x185FB080;
            this.buf.append((char)(0x8584C103 ^ 0x8584C13F));
        }
        this.buf.append(string);
        this.buf.append((char)(0x6D8130A7 ^ 0x6D81309D));
    }

    public SignatureVisitor visitClassBound() {
        return this;
    }

    public SignatureVisitor visitInterfaceBound() {
        this.buf.append((char)(0x4D3BA342 ^ 0x4D3BA378));
        return this;
    }

    public SignatureVisitor visitSuperclass() {
        this.endFormals();
        return this;
    }

    public SignatureVisitor visitInterface() {
        return this;
    }

    public SignatureVisitor visitParameterType() {
        this.endFormals();
        if (!this.hasParameters) {
            this.hasParameters = 0xAF17F005 ^ 0xAF17F004;
            this.buf.append((char)(0xDD67A6CE ^ 0xDD67A6E6));
        }
        return this;
    }

    public SignatureVisitor visitReturnType() {
        this.endFormals();
        if (!this.hasParameters) {
            this.buf.append((char)(0xA93501A0 ^ 0xA9350188));
        }
        this.buf.append((char)(0x8FEB17F0 ^ 0x8FEB17D9));
        return this;
    }

    public SignatureVisitor visitExceptionType() {
        this.buf.append((char)(0x720F04EB ^ 0x720F04B5));
        return this;
    }

    public void visitBaseType(char c) {
        this.buf.append(c);
    }

    public void visitTypeVariable(String string) {
        this.buf.append((char)(0xF32B9B2E ^ 0xF32B9B7A));
        this.buf.append(string);
        this.buf.append((char)(0x58733249 ^ 0x58733272));
    }

    public SignatureVisitor visitArrayType() {
        this.buf.append((char)(0x595C31FF ^ 0x595C31A4));
        return this;
    }

    public void visitClassType(String string) {
        this.buf.append((char)(0x4FE6FA51 ^ 0x4FE6FA1D));
        this.buf.append(string);
        this.argumentStack *= 0x1C97134E ^ 0x1C97134C;
    }

    public void visitInnerClassType(String string) {
        this.endArguments();
        this.buf.append((char)(0xC833E47D ^ 0xC833E453));
        this.buf.append(string);
        this.argumentStack *= 0x44047700 ^ 0x44047702;
    }

    public void visitTypeArgument() {
        if (this.argumentStack % (0xF3CE6DE3 ^ 0xF3CE6DE1) == 0) {
            this.argumentStack += 0xC69FDB24 ^ 0xC69FDB25;
            this.buf.append((char)(0xA3BC791D ^ 0xA3BC7921));
        }
        this.buf.append((char)(0xD7748D8B ^ 0xD7748DA1));
    }

    public SignatureVisitor visitTypeArgument(char c) {
        if (this.argumentStack % (0xD13A053C ^ 0xD13A053E) == 0) {
            this.argumentStack += 0xC4AC3096 ^ 0xC4AC3097;
            this.buf.append((char)(0x2B0A7848 ^ 0x2B0A7874));
        }
        if (c != (0x7F6F4367 ^ 0x7F6F435A)) {
            this.buf.append(c);
        }
        return this;
    }

    public void visitEnd() {
        this.endArguments();
        this.buf.append((char)(0x268360C7 ^ 0x268360FC));
    }

    public String toString() {
        return this.buf.toString();
    }

    private void endFormals() {
        if (this.hasFormals) {
            this.hasFormals = 0x991F3269 ^ 0x991F3269;
            this.buf.append((char)(0x41220079 ^ 0x41220047));
        }
    }

    private void endArguments() {
        if (this.argumentStack % (0x2EEC716F ^ 0x2EEC716D) != 0) {
            this.buf.append((char)(0xA41FB00B ^ 0xA41FB035));
        }
        this.argumentStack /= 0xFA799413 ^ 0xFA799411;
    }
}

