/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.lib.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.spongepowered.asm.lib.AnnotationVisitor;
import org.spongepowered.asm.lib.Attribute;
import org.spongepowered.asm.lib.ClassVisitor;
import org.spongepowered.asm.lib.FieldVisitor;
import org.spongepowered.asm.lib.MethodVisitor;
import org.spongepowered.asm.lib.TypePath;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.FieldNode;
import org.spongepowered.asm.lib.tree.InnerClassNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.lib.tree.TypeAnnotationNode;

public class ClassNode
extends ClassVisitor {
    public int version;
    public int access;
    public String name;
    public String signature;
    public String superName;
    public List<String> interfaces = new ArrayList<String>();
    public String sourceFile;
    public String sourceDebug;
    public String outerClass;
    public String outerMethod;
    public String outerMethodDesc;
    public List<AnnotationNode> visibleAnnotations;
    public List<AnnotationNode> invisibleAnnotations;
    public List<TypeAnnotationNode> visibleTypeAnnotations;
    public List<TypeAnnotationNode> invisibleTypeAnnotations;
    public List<Attribute> attrs;
    public List<InnerClassNode> innerClasses = new ArrayList<InnerClassNode>();
    public List<FieldNode> fields = new ArrayList<FieldNode>();
    public List<MethodNode> methods = new ArrayList<MethodNode>();

    public ClassNode() {
        this(0xA9B16CF6 ^ 0xA9B46CF6);
        if (this.getClass() != ClassNode.class) {
            throw new IllegalStateException();
        }
    }

    public ClassNode(int n) {
        super(n);
    }

    public void visit(int n, int n2, String string, String string2, String string3, String[] stringArray) {
        this.version = n;
        this.access = n2;
        this.name = string;
        this.signature = string2;
        this.superName = string3;
        if (stringArray != null) {
            this.interfaces.addAll(Arrays.asList(stringArray));
        }
    }

    public void visitSource(String string, String string2) {
        this.sourceFile = string;
        this.sourceDebug = string2;
    }

    public void visitOuterClass(String string, String string2, String string3) {
        this.outerClass = string;
        this.outerMethod = string2;
        this.outerMethodDesc = string3;
    }

    public AnnotationVisitor visitAnnotation(String string, boolean bl) {
        AnnotationNode annotationNode = new AnnotationNode(string);
        if (bl) {
            if (this.visibleAnnotations == null) {
                this.visibleAnnotations = new ArrayList<AnnotationNode>(0xB6437266 ^ 0xB6437267);
            }
            this.visibleAnnotations.add(annotationNode);
        } else {
            if (this.invisibleAnnotations == null) {
                this.invisibleAnnotations = new ArrayList<AnnotationNode>(0xE9D0F761 ^ 0xE9D0F760);
            }
            this.invisibleAnnotations.add(annotationNode);
        }
        return annotationNode;
    }

    public AnnotationVisitor visitTypeAnnotation(int n, TypePath typePath, String string, boolean bl) {
        TypeAnnotationNode typeAnnotationNode = new TypeAnnotationNode(n, typePath, string);
        if (bl) {
            if (this.visibleTypeAnnotations == null) {
                this.visibleTypeAnnotations = new ArrayList<TypeAnnotationNode>(0x6F9EEE00 ^ 0x6F9EEE01);
            }
            this.visibleTypeAnnotations.add(typeAnnotationNode);
        } else {
            if (this.invisibleTypeAnnotations == null) {
                this.invisibleTypeAnnotations = new ArrayList<TypeAnnotationNode>(0xB59C26ED ^ 0xB59C26EC);
            }
            this.invisibleTypeAnnotations.add(typeAnnotationNode);
        }
        return typeAnnotationNode;
    }

    public void visitAttribute(Attribute attribute) {
        if (this.attrs == null) {
            this.attrs = new ArrayList<Attribute>(0xABDA7246 ^ 0xABDA7247);
        }
        this.attrs.add(attribute);
    }

    public void visitInnerClass(String string, String string2, String string3, int n) {
        InnerClassNode innerClassNode = new InnerClassNode(string, string2, string3, n);
        this.innerClasses.add(innerClassNode);
    }

    public FieldVisitor visitField(int n, String string, String string2, String string3, Object object) {
        FieldNode fieldNode = new FieldNode(n, string, string2, string3, object);
        this.fields.add(fieldNode);
        return fieldNode;
    }

    public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
        MethodNode methodNode = new MethodNode(n, string, string2, string3, stringArray);
        this.methods.add(methodNode);
        return methodNode;
    }

    public void visitEnd() {
    }

    public void check(int n) {
        if (n == (0x8F2261A8 ^ 0x8F2661A8)) {
            if (this.visibleTypeAnnotations != null && this.visibleTypeAnnotations.size() > 0) {
                throw new RuntimeException();
            }
            if (this.invisibleTypeAnnotations != null && this.invisibleTypeAnnotations.size() > 0) {
                throw new RuntimeException();
            }
            for (FieldNode object : this.fields) {
                object.check(n);
            }
            for (MethodNode methodNode : this.methods) {
                methodNode.check(n);
            }
        }
    }

    public void accept(ClassVisitor classVisitor) {
        AnnotationNode annotationNode;
        int n;
        String[] stringArray = new String[this.interfaces.size()];
        this.interfaces.toArray(stringArray);
        classVisitor.visit(this.version, this.access, this.name, this.signature, this.superName, stringArray);
        if (this.sourceFile != null || this.sourceDebug != null) {
            classVisitor.visitSource(this.sourceFile, this.sourceDebug);
        }
        if (this.outerClass != null) {
            classVisitor.visitOuterClass(this.outerClass, this.outerMethod, this.outerMethodDesc);
        }
        int n2 = this.visibleAnnotations == null ? 0xCCD618F8 ^ 0xCCD618F8 : this.visibleAnnotations.size();
        for (n = 0x1CD7F4E1 ^ 0x1CD7F4E1; n < n2; ++n) {
            annotationNode = this.visibleAnnotations.get(n);
            annotationNode.accept(classVisitor.visitAnnotation(annotationNode.desc, (0xD15B0420 ^ 0xD15B0421) != 0));
        }
        n2 = this.invisibleAnnotations == null ? 0xBD2434D4 ^ 0xBD2434D4 : this.invisibleAnnotations.size();
        for (n = 0x7A5F4B92 ^ 0x7A5F4B92; n < n2; ++n) {
            annotationNode = this.invisibleAnnotations.get(n);
            annotationNode.accept(classVisitor.visitAnnotation(annotationNode.desc, (0xECE8B91B ^ 0xECE8B91B) != 0));
        }
        n2 = this.visibleTypeAnnotations == null ? 0x4286337B ^ 0x4286337B : this.visibleTypeAnnotations.size();
        for (n = 0x80D6EB5B ^ 0x80D6EB5B; n < n2; ++n) {
            annotationNode = this.visibleTypeAnnotations.get(n);
            annotationNode.accept(classVisitor.visitTypeAnnotation(((TypeAnnotationNode)annotationNode).typeRef, ((TypeAnnotationNode)annotationNode).typePath, ((TypeAnnotationNode)annotationNode).desc, (0x7F21F7EC ^ 0x7F21F7ED) != 0));
        }
        n2 = this.invisibleTypeAnnotations == null ? 0x7CC3434D ^ 0x7CC3434D : this.invisibleTypeAnnotations.size();
        for (n = 0x82E71942 ^ 0x82E71942; n < n2; ++n) {
            annotationNode = this.invisibleTypeAnnotations.get(n);
            annotationNode.accept(classVisitor.visitTypeAnnotation(((TypeAnnotationNode)annotationNode).typeRef, ((TypeAnnotationNode)annotationNode).typePath, ((TypeAnnotationNode)annotationNode).desc, (0x149481DF ^ 0x149481DF) != 0));
        }
        n2 = this.attrs == null ? 0x9F9949E3 ^ 0x9F9949E3 : this.attrs.size();
        for (n = 0xEC1CB8EC ^ 0xEC1CB8EC; n < n2; ++n) {
            classVisitor.visitAttribute(this.attrs.get(n));
        }
        for (n = 0xF7F04665 ^ 0xF7F04665; n < this.innerClasses.size(); ++n) {
            this.innerClasses.get(n).accept(classVisitor);
        }
        for (n = 0xEABB49F9 ^ 0xEABB49F9; n < this.fields.size(); ++n) {
            this.fields.get(n).accept(classVisitor);
        }
        for (n = 0x21D812D1 ^ 0x21D812D1; n < this.methods.size(); ++n) {
            this.methods.get(n).accept(classVisitor);
        }
        classVisitor.visitEnd();
    }
}

