/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.lib.tree.analysis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.spongepowered.asm.lib.Opcodes;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.IincInsnNode;
import org.spongepowered.asm.lib.tree.InsnList;
import org.spongepowered.asm.lib.tree.JumpInsnNode;
import org.spongepowered.asm.lib.tree.LabelNode;
import org.spongepowered.asm.lib.tree.LookupSwitchInsnNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.lib.tree.TableSwitchInsnNode;
import org.spongepowered.asm.lib.tree.TryCatchBlockNode;
import org.spongepowered.asm.lib.tree.VarInsnNode;
import org.spongepowered.asm.lib.tree.analysis.AnalyzerException;
import org.spongepowered.asm.lib.tree.analysis.Frame;
import org.spongepowered.asm.lib.tree.analysis.Interpreter;
import org.spongepowered.asm.lib.tree.analysis.Subroutine;
import org.spongepowered.asm.lib.tree.analysis.Value;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Analyzer<V extends Value>
implements Opcodes {
    private final Interpreter<V> interpreter;
    private int n;
    private InsnList insns;
    private List<TryCatchBlockNode>[] handlers;
    private Frame<V>[] frames;
    private Subroutine[] subroutines;
    private boolean[] queued;
    private int[] queue;
    private int top;

    public Analyzer(Interpreter<V> interpreter) {
        this.interpreter = interpreter;
    }

    public Frame<V>[] analyze(String string, MethodNode methodNode) throws AnalyzerException {
        int n;
        Type[] typeArray;
        Object object;
        if ((methodNode.access & (0x1B7CF64D ^ 0x1B7CF34D)) != 0) {
            this.frames = new Frame[0x2876FF92 ^ 0x2876FF92];
            return this.frames;
        }
        this.n = methodNode.instructions.size();
        this.insns = methodNode.instructions;
        this.handlers = new List[this.n];
        this.frames = new Frame[this.n];
        this.subroutines = new Subroutine[this.n];
        this.queued = new boolean[this.n];
        this.queue = new int[this.n];
        this.top = 0xEA685F62 ^ 0xEA685F62;
        for (int i = 0xF87AC0AB ^ 0xF87AC0AB; i < methodNode.tryCatchBlocks.size(); ++i) {
            object = methodNode.tryCatchBlocks.get(i);
            int n2 = this.insns.indexOf(((TryCatchBlockNode)object).start);
            int n3 = this.insns.indexOf(((TryCatchBlockNode)object).end);
            for (int j = n2; j < n3; ++j) {
                typeArray = this.handlers[j];
                if (typeArray == null) {
                    typeArray = new ArrayList<TryCatchBlockNode>();
                    this.handlers[j] = typeArray;
                }
                typeArray.add((TryCatchBlockNode)object);
            }
        }
        Subroutine subroutine = new Subroutine(null, methodNode.maxLocals, null);
        object = new ArrayList();
        HashMap<LabelNode, Subroutine> hashMap = new HashMap<LabelNode, Subroutine>();
        this.findSubroutine(0x2001D235 ^ 0x2001D235, subroutine, (List<AbstractInsnNode>)object);
        while (!object.isEmpty()) {
            JumpInsnNode jumpInsnNode = (JumpInsnNode)object.remove(0x72ABEB84 ^ 0x72ABEB84);
            Subroutine subroutine2 = (Subroutine)hashMap.get(jumpInsnNode.label);
            if (subroutine2 == null) {
                subroutine2 = new Subroutine(jumpInsnNode.label, methodNode.maxLocals, jumpInsnNode);
                hashMap.put(jumpInsnNode.label, subroutine2);
                this.findSubroutine(this.insns.indexOf(jumpInsnNode.label), subroutine2, (List<AbstractInsnNode>)object);
                continue;
            }
            subroutine2.callers.add(jumpInsnNode);
        }
        for (int i = 0xABFD965A ^ 0xABFD965A; i < this.n; ++i) {
            if (this.subroutines[i] == null || this.subroutines[i].start != null) continue;
            this.subroutines[i] = null;
        }
        Frame<V> frame = this.newFrame(methodNode.maxLocals, methodNode.maxStack);
        Frame<V> frame2 = this.newFrame(methodNode.maxLocals, methodNode.maxStack);
        frame.setReturn(this.interpreter.newValue(Type.getReturnType(methodNode.desc)));
        typeArray = Type.getArgumentTypes(methodNode.desc);
        int n4 = 0xE44ACB30 ^ 0xE44ACB30;
        if ((methodNode.access & (0xAE12A56B ^ 0xAE12A563)) == 0) {
            Type type = Type.getObjectType(string);
            frame.setLocal(n4++, this.interpreter.newValue(type));
        }
        for (n = 0xB87853DD ^ 0xB87853DD; n < typeArray.length; ++n) {
            frame.setLocal(n4++, this.interpreter.newValue(typeArray[n]));
            if (typeArray[n].getSize() != (0xAB71CA8F ^ 0xAB71CA8D)) continue;
            frame.setLocal(n4++, this.interpreter.newValue(null));
        }
        while (n4 < methodNode.maxLocals) {
            frame.setLocal(n4++, this.interpreter.newValue(null));
        }
        this.merge(0x6FCF11C8 ^ 0x6FCF11C8, frame, null);
        this.init(string, methodNode);
        while (this.top > 0) {
            n = this.queue[this.top -= 0x235C6D85 ^ 0x235C6D84];
            Frame<V> frame3 = this.frames[n];
            Subroutine subroutine3 = this.subroutines[n];
            this.queued[n] = 0x8F8F0626 ^ 0x8F8F0626;
            AbstractInsnNode abstractInsnNode = null;
            try {
                Object object2;
                int n5;
                Object object3;
                block28: {
                    block34: {
                        block35: {
                            block36: {
                                int n6;
                                block33: {
                                    block32: {
                                        int n7;
                                        block31: {
                                            block30: {
                                                block29: {
                                                    block27: {
                                                        block26: {
                                                            abstractInsnNode = methodNode.instructions.get(n);
                                                            n6 = abstractInsnNode.getOpcode();
                                                            int n8 = abstractInsnNode.getType();
                                                            if (n8 == (0xD3943DAA ^ 0xD3943DA2)) break block26;
                                                            if (n8 == (0x8E8539F0 ^ 0x8E8539FF)) break block26;
                                                            if (n8 != (0x5DA085D5 ^ 0x5DA085DB)) break block27;
                                                        }
                                                        this.merge(n + (0x768A4FEE ^ 0x768A4FEF), frame3, subroutine3);
                                                        this.newControlFlowEdge(n, n + (0xC63F37B9 ^ 0xC63F37B8));
                                                        break block28;
                                                    }
                                                    frame.init(frame3).execute(abstractInsnNode, this.interpreter);
                                                    Subroutine subroutine4 = subroutine3 = subroutine3 == null ? null : subroutine3.copy();
                                                    if (!(abstractInsnNode instanceof JumpInsnNode)) break block29;
                                                    object3 = (JumpInsnNode)abstractInsnNode;
                                                    if (n6 != (0x9009FB73 ^ 0x9009FBD4)) {
                                                        if (n6 != (0xABBC433A ^ 0xABBC4392)) {
                                                            this.merge(n + (0x90517C33 ^ 0x90517C32), frame, subroutine3);
                                                            this.newControlFlowEdge(n, n + (0x82B403B9 ^ 0x82B403B8));
                                                        }
                                                    }
                                                    n5 = this.insns.indexOf(((JumpInsnNode)object3).label);
                                                    if (n6 == (0x7BA80C78 ^ 0x7BA80CD0)) {
                                                        this.merge(n5, frame, new Subroutine(((JumpInsnNode)object3).label, methodNode.maxLocals, (JumpInsnNode)object3));
                                                    } else {
                                                        this.merge(n5, frame, subroutine3);
                                                    }
                                                    this.newControlFlowEdge(n, n5);
                                                    break block28;
                                                }
                                                if (!(abstractInsnNode instanceof LookupSwitchInsnNode)) break block30;
                                                object3 = (LookupSwitchInsnNode)abstractInsnNode;
                                                n5 = this.insns.indexOf(((LookupSwitchInsnNode)object3).dflt);
                                                this.merge(n5, frame, subroutine3);
                                                this.newControlFlowEdge(n, n5);
                                                for (n7 = 0xF9DCB789 ^ 0xF9DCB789; n7 < ((LookupSwitchInsnNode)object3).labels.size(); ++n7) {
                                                    object2 = ((LookupSwitchInsnNode)object3).labels.get(n7);
                                                    n5 = this.insns.indexOf((AbstractInsnNode)object2);
                                                    this.merge(n5, frame, subroutine3);
                                                    this.newControlFlowEdge(n, n5);
                                                }
                                                break block28;
                                            }
                                            if (!(abstractInsnNode instanceof TableSwitchInsnNode)) break block31;
                                            object3 = (TableSwitchInsnNode)abstractInsnNode;
                                            n5 = this.insns.indexOf(((TableSwitchInsnNode)object3).dflt);
                                            this.merge(n5, frame, subroutine3);
                                            this.newControlFlowEdge(n, n5);
                                            for (n7 = 0xAE4F808C ^ 0xAE4F808C; n7 < ((TableSwitchInsnNode)object3).labels.size(); ++n7) {
                                                object2 = ((TableSwitchInsnNode)object3).labels.get(n7);
                                                n5 = this.insns.indexOf((AbstractInsnNode)object2);
                                                this.merge(n5, frame, subroutine3);
                                                this.newControlFlowEdge(n, n5);
                                            }
                                            break block28;
                                        }
                                        if (n6 != (0x1C403EEC ^ 0x1C403E45)) break block32;
                                        if (subroutine3 == null) {
                                            throw new AnalyzerException(abstractInsnNode, \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("@\ua7c3\ua481\ua031\ua90c\u7d78\u8e59\u246e\u8b25\u3462q\ua7f2\ua4bc\ua07e\ua90b\u7d36\u8e45\u246f\u8b23\u3464{\ua7e2\ua4b0\ua031\ua90a\u7d70\u8e0a\u247b\u8b77\u3464g\ua7e4\ua4f5\ua063\ua90a\u7d63\u8e5e\u2473\u8b39\u3472"));
                                        }
                                        for (int i = 0x2F7AEF1C ^ 0x2F7AEF1C; i < subroutine3.callers.size(); ++i) {
                                            JumpInsnNode jumpInsnNode = subroutine3.callers.get(i);
                                            n7 = this.insns.indexOf(jumpInsnNode);
                                            if (this.frames[n7] == null) continue;
                                            this.merge(n7 + (0xB27C40FB ^ 0xB27C40FA), this.frames[n7], frame, this.subroutines[n7], subroutine3.access);
                                            this.newControlFlowEdge(n, n7 + (0x4203163C ^ 0x4203163D));
                                        }
                                        break block28;
                                    }
                                    if (n6 == (0x1FEDC028 ^ 0x1FEDC097)) break block28;
                                    if (n6 < (0x1BEF0514 ^ 0x1BEF05B8)) break block33;
                                    if (n6 <= (0x77A321B ^ 0x77A32AA)) break block28;
                                }
                                if (subroutine3 == null) break block34;
                                if (!(abstractInsnNode instanceof VarInsnNode)) break block35;
                                int n9 = ((VarInsnNode)abstractInsnNode).var;
                                subroutine3.access[n9] = 0xCBE6ED68 ^ 0xCBE6ED69;
                                if (n6 == (0xC68F0A50 ^ 0xC68F0A46)) break block36;
                                if (n6 == (0x375875B5 ^ 0x375875AD)) break block36;
                                if (n6 == (0x2045C58F ^ 0x2045C5B8)) break block36;
                                if (n6 != (0xF0EB315B ^ 0xF0EB3162)) break block34;
                            }
                            subroutine3.access[n9 + (0xA60FCFC7 ^ 0xA60FCFC6)] = 0xC7516522 ^ 0xC7516523;
                            break block34;
                        }
                        if (abstractInsnNode instanceof IincInsnNode) {
                            int n10 = ((IincInsnNode)abstractInsnNode).var;
                            subroutine3.access[n10] = 0xF496E23A ^ 0xF496E23B;
                        }
                    }
                    this.merge(n + (0xB34C9165 ^ 0xB34C9164), frame, subroutine3);
                    this.newControlFlowEdge(n, n + (0xE0744528 ^ 0xE0744529));
                }
                if ((object3 = this.handlers[n]) == null) continue;
                for (n5 = 0xFB734846 ^ 0xFB734846; n5 < object3.size(); ++n5) {
                    TryCatchBlockNode tryCatchBlockNode = (TryCatchBlockNode)object3.get(n5);
                    object2 = tryCatchBlockNode.type == null ? Type.getObjectType(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438F\ua7ee\ua4a7\ua07e\ua912\u7d77\u8e48\u2476\u8b32")) : Type.getObjectType(tryCatchBlockNode.type);
                    int n11 = this.insns.indexOf(tryCatchBlockNode.handler);
                    if (!this.newControlFlowExceptionEdge(n, tryCatchBlockNode)) continue;
                    frame2.init(frame3);
                    frame2.clearStack();
                    frame2.push(this.interpreter.newValue((Type)object2));
                    this.merge(n11, frame2, subroutine3);
                }
            }
            catch (AnalyzerException analyzerException) {
                throw new AnalyzerException(analyzerException.node, \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("W\ua7f4\ua4a7\ua07e\ua917\u7d36\u8e4b\u246e\u8b77\u347e|\ua7f5\ua4a1\ua063\ua910\u7d75\u8e5e\u2473\u8b38\u34792") + n + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("(\ua7a6") + analyzerException.getMessage(), analyzerException);
            }
            catch (Exception exception) {
                throw new AnalyzerException(abstractInsnNode, \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("W\ua7f4\ua4a7\ua07e\ua917\u7d36\u8e4b\u246e\u8b77\u347e|\ua7f5\ua4a1\ua063\ua910\u7d75\u8e5e\u2473\u8b38\u34792") + n + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("(\ua7a6") + exception.getMessage(), exception);
            }
        }
        return this.frames;
    }

    private void findSubroutine(int n, Subroutine subroutine, List<AbstractInsnNode> list) throws AnalyzerException {
        while (true) {
            Object object;
            int n2;
            Object object2;
            if (n < 0 || n >= this.n) {
                throw new AnalyzerException(null, \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("W\ua7fe\ua4b0\ua072\ua910\u7d62\u8e43\u2475\u8b39\u3437q\ua7e7\ua4bb\ua031\ua903\u7d77\u8e46\u2476\u8b77\u3478t\ua7e0\ua4f5\ua074\ua90b\u7d72\u8e0a\u2475\u8b31\u3437f\ua7ee\ua4b0\ua031\ua906\u7d79\u8e4e\u247f"));
            }
            if (this.subroutines[n] != null) {
                return;
            }
            this.subroutines[n] = subroutine.copy();
            AbstractInsnNode abstractInsnNode = this.insns.get(n);
            if (abstractInsnNode instanceof JumpInsnNode) {
                if (abstractInsnNode.getOpcode() == (0xA55722C5 ^ 0xA557226D)) {
                    list.add(abstractInsnNode);
                } else {
                    object2 = (JumpInsnNode)abstractInsnNode;
                    this.findSubroutine(this.insns.indexOf(((JumpInsnNode)object2).label), subroutine, list);
                }
            } else if (abstractInsnNode instanceof TableSwitchInsnNode) {
                object2 = (TableSwitchInsnNode)abstractInsnNode;
                this.findSubroutine(this.insns.indexOf(((TableSwitchInsnNode)object2).dflt), subroutine, list);
                for (n2 = ((TableSwitchInsnNode)object2).labels.size() - (0x5A6CB8F9 ^ 0x5A6CB8F8); n2 >= 0; --n2) {
                    object = ((TableSwitchInsnNode)object2).labels.get(n2);
                    this.findSubroutine(this.insns.indexOf((AbstractInsnNode)object), subroutine, list);
                }
            } else if (abstractInsnNode instanceof LookupSwitchInsnNode) {
                object2 = (LookupSwitchInsnNode)abstractInsnNode;
                this.findSubroutine(this.insns.indexOf(((LookupSwitchInsnNode)object2).dflt), subroutine, list);
                for (n2 = ((LookupSwitchInsnNode)object2).labels.size() - (0x811DA87E ^ 0x811DA87F); n2 >= 0; --n2) {
                    object = ((LookupSwitchInsnNode)object2).labels.get(n2);
                    this.findSubroutine(this.insns.indexOf((AbstractInsnNode)object), subroutine, list);
                }
            }
            object2 = this.handlers[n];
            if (object2 != null) {
                for (n2 = 0x902D95DF ^ 0x902D95DF; n2 < object2.size(); ++n2) {
                    object = (TryCatchBlockNode)object2.get(n2);
                    this.findSubroutine(this.insns.indexOf(((TryCatchBlockNode)object).handler), subroutine, list);
                }
            }
            switch (abstractInsnNode.getOpcode()) {
                case 167: 
                case 169: 
                case 170: 
                case 171: 
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 191: {
                    return;
                }
            }
            ++n;
        }
    }

    public Frame<V>[] getFrames() {
        return this.frames;
    }

    public List<TryCatchBlockNode> getHandlers(int n) {
        return this.handlers[n];
    }

    protected void init(String string, MethodNode methodNode) throws AnalyzerException {
    }

    protected Frame<V> newFrame(int n, int n2) {
        return new Frame(n, n2);
    }

    protected Frame<V> newFrame(Frame<? extends V> frame) {
        return new Frame<V>(frame);
    }

    protected void newControlFlowEdge(int n, int n2) {
    }

    protected boolean newControlFlowExceptionEdge(int n, int n2) {
        return (0x60A9B134 ^ 0x60A9B135) != 0;
    }

    protected boolean newControlFlowExceptionEdge(int n, TryCatchBlockNode tryCatchBlockNode) {
        return this.newControlFlowExceptionEdge(n, this.insns.indexOf(tryCatchBlockNode.handler));
    }

    private void merge(int n, Frame<V> frame, Subroutine subroutine) throws AnalyzerException {
        int n2;
        Frame<V> frame2 = this.frames[n];
        Subroutine subroutine2 = this.subroutines[n];
        if (frame2 == null) {
            this.frames[n] = this.newFrame(frame);
            n2 = 0x30BCE43A ^ 0x30BCE43B;
        } else {
            n2 = frame2.merge(frame, this.interpreter);
        }
        if (subroutine2 == null) {
            if (subroutine != null) {
                this.subroutines[n] = subroutine.copy();
                n2 = 0x2051B112 ^ 0x2051B113;
            }
        } else if (subroutine != null) {
            n2 |= subroutine2.merge(subroutine);
        }
        if (n2 != 0 && !this.queued[n]) {
            this.queued[n] = 0xBA77C317 ^ 0xBA77C316;
            int n3 = this.top;
            this.top = n3 + (0x3A2CD901 ^ 0x3A2CD900);
            this.queue[n3] = n;
        }
    }

    private void merge(int n, Frame<V> frame, Frame<V> frame2, Subroutine subroutine, boolean[] blArray) throws AnalyzerException {
        int n2;
        Frame<V> frame3 = this.frames[n];
        Subroutine subroutine2 = this.subroutines[n];
        frame2.merge(frame, blArray);
        if (frame3 == null) {
            this.frames[n] = this.newFrame(frame2);
            n2 = 0xCA543FB6 ^ 0xCA543FB7;
        } else {
            n2 = frame3.merge(frame2, this.interpreter);
        }
        if (subroutine2 != null && subroutine != null) {
            n2 |= subroutine2.merge(subroutine);
        }
        if (n2 != 0 && !this.queued[n]) {
            this.queued[n] = 0xC3A95AE8 ^ 0xC3A95AE9;
            int n3 = this.top;
            this.top = n3 + (0x5724C348 ^ 0x5724C349);
            this.queue[n3] = n;
        }
    }
}

