/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.lib.util;

import org.spongepowered.asm.lib.signature.SignatureVisitor;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2;

public final class TraceSignatureVisitor
extends SignatureVisitor {
    private final StringBuilder declaration;
    private boolean isInterface;
    private boolean seenFormalParameter;
    private boolean seenInterfaceBound;
    private boolean seenParameter;
    private boolean seenInterface;
    private StringBuilder returnType;
    private StringBuilder exceptions;
    private int argumentStack;
    private int arrayStack;
    private String separator = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("");

    public TraceSignatureVisitor(int n) {
        super(0xAB34489E ^ 0xAB31489E);
        this.isInterface = (n & (0x4333F941 ^ 0x4333FB41)) != 0 ? 0x939BFB9A ^ 0x939BFB9B : 0xCC886304 ^ 0xCC886304;
        this.declaration = new StringBuilder();
    }

    private TraceSignatureVisitor(StringBuilder stringBuilder) {
        super(0xD3578C57 ^ 0xD3528C57);
        this.declaration = stringBuilder;
    }

    public void visitFormalTypeParameter(String string) {
        this.declaration.append(this.seenFormalParameter ? \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b(">\ua7a6") : \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b(".")).append(string);
        this.seenFormalParameter = 0x89C97ACE ^ 0x89C97ACF;
        this.seenInterfaceBound = 0x810AB974 ^ 0x810AB974;
    }

    public SignatureVisitor visitClassBound() {
        this.separator = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2\ua7e3\ua4ad\ua065\ua900\u7d78\u8e4e\u2469\u8b77");
        this.startType();
        return this;
    }

    public SignatureVisitor visitInterfaceBound() {
        this.separator = this.seenInterfaceBound ? \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b(">\ua7a6") : \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2\ua7e3\ua4ad\ua065\ua900\u7d78\u8e4e\u2469\u8b77");
        this.seenInterfaceBound = 0x604D660F ^ 0x604D660E;
        this.startType();
        return this;
    }

    public SignatureVisitor visitSuperclass() {
        this.endFormals();
        this.separator = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2\ua7e3\ua4ad\ua065\ua900\u7d78\u8e4e\u2469\u8b77");
        this.startType();
        return this;
    }

    public SignatureVisitor visitInterface() {
        this.separator = this.seenInterface ? \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b(">\ua7a6") : (this.isInterface ? \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2\ua7e3\ua4ad\ua065\ua900\u7d78\u8e4e\u2469\u8b77") : \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2\ua7ef\ua4b8\ua061\ua909\u7d73\u8e47\u247f\u8b39\u3463a\ua7a6"));
        this.seenInterface = 0x42CB07D4 ^ 0x42CB07D5;
        this.startType();
        return this;
    }

    public SignatureVisitor visitParameterType() {
        this.endFormals();
        if (this.seenParameter) {
            this.declaration.append(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b(">\ua7a6"));
        } else {
            this.seenParameter = 0x7B8F7795 ^ 0x7B8F7794;
            this.declaration.append((char)(0x9FD5F168 ^ 0x9FD5F140));
        }
        this.startType();
        return this;
    }

    public SignatureVisitor visitReturnType() {
        this.endFormals();
        if (this.seenParameter) {
            this.seenParameter = 0x4F1FAD53 ^ 0x4F1FAD53;
        } else {
            this.declaration.append((char)(0x84839336 ^ 0x8483931E));
        }
        this.declaration.append((char)(0xFCF51680 ^ 0xFCF516A9));
        this.returnType = new StringBuilder();
        return new TraceSignatureVisitor(this.returnType);
    }

    public SignatureVisitor visitExceptionType() {
        if (this.exceptions == null) {
            this.exceptions = new StringBuilder();
        } else {
            this.exceptions.append(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b(">\ua7a6"));
        }
        return new TraceSignatureVisitor(this.exceptions);
    }

    public void visitBaseType(char c) {
        switch (c) {
            case 'V': {
                this.declaration.append(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("d\ua7e9\ua4bc\ua075"));
                break;
            }
            case 'B': {
                this.declaration.append(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("p\ua7ff\ua4a1\ua074"));
                break;
            }
            case 'J': {
                this.declaration.append(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("~\ua7e9\ua4bb\ua076"));
                break;
            }
            case 'Z': {
                this.declaration.append(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("p\ua7e9\ua4ba\ua07d\ua900\u7d77\u8e44"));
                break;
            }
            case 'I': {
                this.declaration.append(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("{\ua7e8\ua4a1"));
                break;
            }
            case 'S': {
                this.declaration.append(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("a\ua7ee\ua4ba\ua063\ua911"));
                break;
            }
            case 'C': {
                this.declaration.append(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("q\ua7ee\ua4b4\ua063"));
                break;
            }
            case 'F': {
                this.declaration.append(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("t\ua7ea\ua4ba\ua070\ua911"));
                break;
            }
            default: {
                this.declaration.append(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("v\ua7e9\ua4a0\ua073\ua909\u7d73"));
            }
        }
        this.endType();
    }

    public void visitTypeVariable(String string) {
        this.declaration.append(string);
        this.endType();
    }

    public SignatureVisitor visitArrayType() {
        this.startType();
        this.arrayStack |= 0x9B3760DA ^ 0x9B3760DB;
        return this;
    }

    public void visitClassType(String string) {
        if (\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438]\ua7e4\ua4bf\ua074\ua906\u7d62").equals(string)) {
            int n;
            int n2 = this.argumentStack % (0x28774887 ^ 0x28774885) != 0 || this.seenParameter ? 0x940085B7 ^ 0x940085B6 : (n = 0x5CD56155 ^ 0x5CD56155);
            if (n != 0) {
                this.declaration.append(this.separator).append(string.replace((char)(0xD01CDA2F ^ 0xD01CDA00), (char)(0xF826F7BF ^ 0xF826F791)));
            }
        } else {
            this.declaration.append(this.separator).append(string.replace((char)(0xC393C672 ^ 0xC393C65D), (char)(0xF66C46 ^ 0xF66C68)));
        }
        this.separator = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("");
        this.argumentStack *= 0xC6D565C9 ^ 0xC6D565CB;
    }

    public void visitInnerClassType(String string) {
        if (this.argumentStack % (0xF3176B10 ^ 0xF3176B12) != 0) {
            this.declaration.append((char)(0xE23C80DE ^ 0xE23C80E0));
        }
        this.argumentStack /= 0xD2CD0A99 ^ 0xD2CD0A9B;
        this.declaration.append((char)(0xE170097F ^ 0xE1700951));
        this.declaration.append(this.separator).append(string.replace((char)(0x3AE5B402 ^ 0x3AE5B42D), (char)(0xF2B2DD4D ^ 0xF2B2DD63)));
        this.separator = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("");
        this.argumentStack *= 0x2B0AD24F ^ 0x2B0AD24D;
    }

    public void visitTypeArgument() {
        if (this.argumentStack % (0x3A24C4FA ^ 0x3A24C4F8) == 0) {
            this.argumentStack += 0x4856DE9C ^ 0x4856DE9D;
            this.declaration.append((char)(0xD2A1AEC5 ^ 0xD2A1AEF9));
        } else {
            this.declaration.append(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b(">\ua7a6"));
        }
        this.declaration.append((char)(0x105288DF ^ 0x105288E0));
    }

    public SignatureVisitor visitTypeArgument(char c) {
        if (this.argumentStack % (0xA99A67FC ^ 0xA99A67FE) == 0) {
            this.argumentStack += 0x267850B1 ^ 0x267850B0;
            this.declaration.append((char)(0x3987548 ^ 0x3987574));
        } else {
            this.declaration.append(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b(">\ua7a6"));
        }
        if (c == (0x2575EE09 ^ 0x2575EE22)) {
            this.declaration.append(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("-\ua7a6\ua4b0\ua069\ua911\u7d73\u8e44\u247e\u8b24\u3437"));
        } else if (c == (0xE39A8279 ^ 0xE39A8254)) {
            this.declaration.append(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("-\ua7a6\ua4a6\ua064\ua915\u7d73\u8e58\u243a"));
        }
        this.startType();
        return this;
    }

    public void visitEnd() {
        if (this.argumentStack % (0xA350908 ^ 0xA35090A) != 0) {
            this.declaration.append((char)(0x5A0C1129 ^ 0x5A0C1117));
        }
        this.argumentStack /= 0x1256DB00 ^ 0x1256DB02;
        this.endType();
    }

    public String getDeclaration() {
        return this.declaration.toString();
    }

    public String getReturnType() {
        return this.returnType == null ? null : this.returnType.toString();
    }

    public String getExceptions() {
        return this.exceptions == null ? null : this.exceptions.toString();
    }

    private void endFormals() {
        if (this.seenFormalParameter) {
            this.declaration.append((char)(0xA5CD6315 ^ 0xA5CD632B));
            this.seenFormalParameter = 0xF685D281 ^ 0xF685D281;
        }
    }

    private void startType() {
        this.arrayStack *= 0xB62C2502 ^ 0xB62C2500;
    }

    private void endType() {
        if (this.arrayStack % (0x268DAA8B ^ 0x268DAA89) == 0) {
            this.arrayStack /= 0x595EFC65 ^ 0x595EFC67;
        } else {
            while (true) {
                if (this.arrayStack % (0x65B1A7FF ^ 0x65B1A7FD) == 0) break;
                this.arrayStack /= 0xC82B0A00 ^ 0xC82B0A02;
                this.declaration.append(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("I\ua7db"));
            }
        }
    }
}

