/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.gen;

import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.InsnNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.lib.tree.VarInsnNode;
import org.spongepowered.asm.mixin.gen.AccessorGenerator;
import org.spongepowered.asm.mixin.gen.AccessorInfo;
import org.spongepowered.asm.util.Bytecode;

public class AccessorGeneratorMethodProxy
extends AccessorGenerator {
    private final MethodNode targetMethod;
    private final Type[] argTypes;
    private final Type returnType;
    private final boolean isInstanceMethod;

    public AccessorGeneratorMethodProxy(AccessorInfo accessorInfo) {
        super(accessorInfo);
        this.targetMethod = accessorInfo.getTargetMethod();
        this.argTypes = accessorInfo.getArgTypes();
        this.returnType = accessorInfo.getReturnType();
        this.isInstanceMethod = !Bytecode.hasFlag(this.targetMethod, 0x3BD717C6 ^ 0x3BD717CE) ? 0xFD564495 ^ 0xFD564494 : 0x4567808 ^ 0x4567808;
    }

    @Override
    public MethodNode generate() {
        int n = Bytecode.getArgsSize(this.argTypes) + this.returnType.getSize() + (this.isInstanceMethod ? 0xF5DB2BCD ^ 0xF5DB2BCC : 0xD3A3C1C5 ^ 0xD3A3C1C5);
        MethodNode methodNode = this.createMethod(n, n);
        if (this.isInstanceMethod) {
            methodNode.instructions.add(new VarInsnNode(0xD4256A1 ^ 0xD4256B8, 0xA609F340 ^ 0xA609F340));
        }
        Bytecode.loadArgs(this.argTypes, methodNode.instructions, this.isInstanceMethod ? 0x5F1034D4 ^ 0x5F1034D5 : 0x1CC2B1BA ^ 0x1CC2B1BA);
        boolean bl = Bytecode.hasFlag(this.targetMethod, 0xA89F8A36 ^ 0xA89F8A34);
        int n2 = this.isInstanceMethod ? (bl ? 0xBCA3860 ^ 0xBCA38D7 : 0x2AFBC6F3 ^ 0x2AFBC645) : 0xC3DEC71B ^ 0xC3DEC7A3;
        methodNode.instructions.add(new MethodInsnNode(n2, this.info.getClassNode().name, this.targetMethod.name, this.targetMethod.desc, (0x87A52B62 ^ 0x87A52B62) != 0));
        methodNode.instructions.add(new InsnNode(this.returnType.getOpcode(0x30387F30 ^ 0x30387F9C)));
        return methodNode;
    }
}

