/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.injection.callback;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.InsnList;
import org.spongepowered.asm.lib.tree.InsnNode;
import org.spongepowered.asm.lib.tree.JumpInsnNode;
import org.spongepowered.asm.lib.tree.LabelNode;
import org.spongepowered.asm.lib.tree.LdcInsnNode;
import org.spongepowered.asm.lib.tree.LocalVariableNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.lib.tree.TypeInsnNode;
import org.spongepowered.asm.lib.tree.VarInsnNode;
import org.spongepowered.asm.mixin.injection.Coerce;
import org.spongepowered.asm.mixin.injection.InjectionPoint;
import org.spongepowered.asm.mixin.injection.Surrogate;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.asm.mixin.injection.code.Injector;
import org.spongepowered.asm.mixin.injection.points.BeforeReturn;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.injection.struct.InjectionNodes;
import org.spongepowered.asm.mixin.injection.struct.Target;
import org.spongepowered.asm.mixin.injection.throwables.InjectionError;
import org.spongepowered.asm.mixin.injection.throwables.InvalidInjectionException;
import org.spongepowered.asm.util.Annotations;
import org.spongepowered.asm.util.Bytecode;
import org.spongepowered.asm.util.Locals;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.asm.util.SignaturePrinter;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2;

public class CallbackInjector
extends Injector {
    private final boolean cancellable;
    private final LocalCapture localCapture;
    private final String identifier;
    private final Map<Integer, String> ids = new HashMap<Integer, String>();
    private int totalInjections = 0x5BB0BAAA ^ 0x5BB0BAAA;
    private int callbackInfoVar = 0xAAF4340C ^ 0x550BCBF3;
    private String lastId;
    private String lastDesc;
    private Target lastTarget;
    private String callbackInfoClass;

    public CallbackInjector(InjectionInfo injectionInfo, boolean bl, LocalCapture localCapture, String string) {
        super(injectionInfo);
        this.cancellable = bl;
        this.localCapture = localCapture;
        this.identifier = string;
    }

    @Override
    protected void sanityCheck(Target target, List<InjectionPoint> list) {
        super.sanityCheck(target, list);
        if (target.isStatic != this.isStatic) {
            throw new InvalidInjectionException(this.info, \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("5\ua7f5\ua4a1\ua070\ua911\u7d7f\u8e49\u243d\u8b77\u347a}\ua7e2\ua4bc\ua077\ua90c\u7d73\u8e58\u243a\u8b38\u34712\ua7e5\ua4b4\ua07d\ua909\u7d74\u8e4b\u2479\u8b3c\u3437\u007f\ua7e3\ua4a1\ua079\ua90a\u7d72\u8e0a\u247e\u8b38\u3472a\ua7a6\ua4bb\ua07e\ua911\u7d36\u8e47\u247b\u8b23\u3474z\ua7a6\ua4a1\ua070\ua917\u7d71\u8e4f\u246e\u8b77\u347e|\ua7a6") + this);
        }
        if (\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b(".\ua7ef\ua4bb\ua078\ua911\u7d28").equals(target.method.name)) {
            for (InjectionPoint injectionPoint : list) {
                if (injectionPoint.getClass().equals(BeforeReturn.class)) continue;
                throw new InvalidInjectionException(this.info, \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("T\ua7e9\ua4a0\ua07f\ua901\u7d36\u8e43\u2474\u8b3d\u3472q\ua7f2\ua4bc\ua07e\ua90b\u7d36\u8e5a\u2475\u8b3e\u3479f\ua7a6\ua4a1\ua068\ua915\u7d73\u8e0a") + injectionPoint.getClass().getSimpleName() + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2\ua7f2\ua4b4\ua063\ua902\u7d73\u8e5e\u246e\u8b3e\u3479u\ua7a6\ua4b4\ua031\ua906\u7d62\u8e45\u2468\u8b77\u347e|\ua7a6") + this + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("<\ua7a6\ua49a\ua07f\ua909\u7d6f\u8e0a\u2448\u8b12\u3443G\ua7d4\ua49b\ua031\ua904\u7d7a\u8e46\u2475\u8b20\u3472v\ua7a6\ua4b3\ua07e\ua917\u7d36\u8e4b\u243a\u8b34\u3463}\ua7f4\ua4f5\ua065\ua904\u7d64\u8e4d\u247f\u8b23"));
            }
        }
    }

    @Override
    protected void addTargetNode(Target target, List<InjectionNodes.InjectionNode> list, AbstractInsnNode abstractInsnNode, Set<InjectionPoint> set) {
        InjectionNodes.InjectionNode injectionNode = target.addInjectionNode(abstractInsnNode);
        for (InjectionPoint injectionPoint : set) {
            String string = injectionPoint.getId();
            if (Strings.isNullOrEmpty((String)string)) continue;
            String string2 = this.ids.get(injectionNode.getId());
            if (string2 != null && !string2.equals(string)) {
                Object[] objectArray = new Object[0x365E27B6 ^ 0x365E27B3];
                objectArray[0x198EB82F ^ 0x198EB82F] = Bytecode.getOpcodeName(abstractInsnNode);
                objectArray[0xF883E928 ^ 0xF883E929] = target.toString();
                objectArray[0x34B3F00F ^ 0x34B3F00D] = string;
                objectArray[0xA35D4798 ^ 0xA35D479B] = this.info;
                objectArray[0x16B5467B ^ 0x16B5467F] = string2;
                Injector.logger.warn(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("Q\ua7e9\ua4bb\ua077\ua909\u7d7f\u8e49\u246e\u8b3e\u3479u\ua7a6\ua4bc\ua075\ua945\u7d70\u8e45\u2468\u8b77\u346co\ua7a6\ua4bc\ua07f\ua916\u7d78\u8e0a\u2473\u8b39\u3437i\ua7fb\ua4f9\ua031\ua903\u7d79\u8e5f\u2474\u8b33\u3437{\ua7e2\ua4f5\ua06a\ua918\u7d36\u8e45\u2474\u8b77\u346co\ua7aa\ua4f5\ua061\ua917\u7d73\u8e5c\u2473\u8b38\u3462a\ua7ea\ua4ac\ua031\ua901\u7d73\u8e4c\u2473\u8b39\u3472v\ua7a6\ua4b4\ua062\ua945\u7d6d\u8e57"), objectArray);
                break;
            }
            this.ids.put(injectionNode.getId(), string);
        }
        list.add(injectionNode);
        this.totalInjections += 0x11DC3C2 ^ 0x11DC3C3;
    }

    @Override
    protected void inject(Target target, InjectionNodes.InjectionNode injectionNode) {
        LocalVariableNode[] localVariableNodeArray = null;
        if (this.localCapture.isCaptureLocals() || this.localCapture.isPrintLocals()) {
            localVariableNodeArray = Locals.getLocalsAt(this.classNode, target.method, injectionNode.getCurrentTarget());
        }
        this.inject(new Callback(this.methodNode, target, injectionNode, localVariableNodeArray, this.localCapture.isCaptureLocals()));
    }

    private void inject(Callback callback) {
        MethodNode methodNode;
        block18: {
            block17: {
                if (this.localCapture.isPrintLocals()) {
                    this.printLocals(callback);
                    this.info.addCallbackInvocation(this.methodNode);
                    return;
                }
                methodNode = this.methodNode;
                if (!callback.checkDescriptor(this.methodNode.desc)) {
                    if (this.info.getTargets().size() > (0xC9B7DC7F ^ 0xC9B7DC7E)) {
                        return;
                    }
                    if (callback.canCaptureLocals) {
                        MethodNode methodNode2 = Bytecode.findMethod(this.classNode, this.methodNode.name, callback.getDescriptor());
                        if (methodNode2 != null && Annotations.getVisible(methodNode2, Surrogate.class) != null) {
                            methodNode = methodNode2;
                        } else {
                            String string = this.generateBadLVTMessage(callback);
                            switch (1.$SwitchMap$org$spongepowered$asm$mixin$injection$callback$LocalCapture[this.localCapture.ordinal()]) {
                                case 1: {
                                    Object[] objectArray = new Object[0x5553B508 ^ 0x5553B509];
                                    objectArray[0x60286A40 ^ 0x60286A40] = string;
                                    Injector.logger.error(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("[\ua7e8\ua4bf\ua074\ua906\u7d62\u8e43\u2475\u8b39\u3437w\ua7f4\ua4a7\ua07e\ua917\u7d2c\u8e0a\u2461\u8b2a"), objectArray);
                                    methodNode = this.generateErrorMethod(callback, \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("}\ua7f4\ua4b2\ua03e\ua916\u7d66\u8e45\u2474\u8b30\u3472b\ua7e9\ua4a2\ua074\ua917\u7d73\u8e4e\u2435\u8b36\u3464\u007f\ua7a9\ua4b8\ua078\ua91d\u7d7f\u8e44\u2435\u8b3e\u3479x\ua7e3\ua4b6\ua065\ua90c\u7d79\u8e44\u2435\u8b23\u347f`\ua7e9\ua4a2\ua070\ua907\u7d7a\u8e4f\u2469\u8b78\u345e|\ua7ec\ua4b0\ua072\ua911\u7d7f\u8e45\u2474\u8b12\u3465`\ua7e9\ua4a7"), string);
                                    break;
                                }
                                case 2: {
                                    Object[] objectArray = new Object[0xEEE3C1B ^ 0xEEE3C1A];
                                    objectArray[0xA9E4FB57 ^ 0xA9E4FB57] = string;
                                    Injector.logger.warn(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("[\ua7e8\ua4bf\ua074\ua906\u7d62\u8e43\u2475\u8b39\u3437e\ua7e7\ua4a7\ua07f\ua90c\u7d78\u8e4d\u2420\u8b77\u346co"), objectArray);
                                    return;
                                }
                                default: {
                                    Object[] objectArray = new Object[0xDB7DEB12 ^ 0xDB7DEB13];
                                    objectArray[0x32690FC7 ^ 0x32690FC7] = string;
                                    Injector.logger.error(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("Q\ua7f4\ua4bc\ua065\ua90c\u7d75\u8e4b\u2476\u8b77\u347e|\ua7ec\ua4b0\ua072\ua911\u7d7f\u8e45\u2474\u8b77\u3471s\ua7ef\ua4b9\ua064\ua917\u7d73\u8e10\u243a\u8b2c\u346a"), objectArray);
                                    throw new InjectionError(string);
                                }
                            }
                        }
                    } else {
                        String string = this.methodNode.desc.replace(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("^\ua7e9\ua4a7\ua076\ua94a\u7d65\u8e5a\u2475\u8b39\u3470w\ua7f6\ua4ba\ua066\ua900\u7d64\u8e4f\u247e\u8b78\u3476a\ua7eb\ua4fa\ua07c\ua90c\u7d6e\u8e43\u2474\u8b78\u347e|\ua7ec\ua4b0\ua072\ua911\u7d7f\u8e45\u2474\u8b78\u3474s\ua7ea\ua4b9\ua073\ua904\u7d75\u8e41\u2435\u8b14\u3476~\ua7ea\ua4b7\ua070\ua906\u7d7d\u8e63\u2474\u8b31\u3478)"), \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("^\ua7e9\ua4a7\ua076\ua94a\u7d65\u8e5a\u2475\u8b39\u3470w\ua7f6\ua4ba\ua066\ua900\u7d64\u8e4f\u247e\u8b78\u3476a\ua7eb\ua4fa\ua07c\ua90c\u7d6e\u8e43\u2474\u8b78\u347e|\ua7ec\ua4b0\ua072\ua911\u7d7f\u8e45\u2474\u8b78\u3474s\ua7ea\ua4b9\ua073\ua904\u7d75\u8e41\u2435\u8b14\u3476~\ua7ea\ua4b7\ua070\ua906\u7d7d\u8e63\u2474\u8b31\u3478@\ua7e3\ua4a1\ua064\ua917\u7d78\u8e4b\u2478\u8b3b\u3472)"));
                        if (callback.checkDescriptor(string)) {
                            throw new InvalidInjectionException(this.info, \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b33\u3472a\ua7e5\ua4a7\ua078\ua915\u7d62\u8e45\u2468\u8b77\u3478|\ua7a6") + this.info + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("3\ua7a6\ua496\ua070\ua909\u7d7a\u8e48\u247b\u8b34\u347c[\ua7e8\ua4b3\ua07e\ua937\u7d73\u8e5e\u246f\u8b25\u3479s\ua7e4\ua4b9\ua074\ua945\u7d7f\u8e59\u243a\u8b25\u3472c\ua7f3\ua4bc\ua063\ua900\u7d72\u8e0b"));
                        }
                        MethodNode methodNode3 = Bytecode.findMethod(this.classNode, this.methodNode.name, callback.getDescriptor());
                        if (methodNode3 != null && Annotations.getVisible(methodNode3, Surrogate.class) != null) {
                            methodNode = methodNode3;
                        } else {
                            throw new InvalidInjectionException(this.info, \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b33\u3472a\ua7e5\ua4a7\ua078\ua915\u7d62\u8e45\u2468\u8b77\u3478|\ua7a6") + this.info + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("3\ua7a6\ua490\ua069\ua915\u7d73\u8e49\u246e\u8b32\u34732") + callback.getDescriptor() + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2\ua7e4\ua4a0\ua065\ua945\u7d70\u8e45\u246f\u8b39\u34732") + this.methodNode.desc);
                        }
                    }
                }
                this.dupReturnValue(callback);
                if (this.cancellable) break block17;
                if (this.totalInjections <= (0x386A391A ^ 0x386A391B)) break block18;
            }
            this.createCallbackInfo(callback, (0xC1F4A019 ^ 0xC1F4A018) != 0);
        }
        this.invokeCallback(callback, methodNode);
        this.injectCancellationCode(callback);
        callback.inject();
        this.info.notifyInjected(callback.target);
    }

    private String generateBadLVTMessage(Callback callback) {
        int n = callback.target.indexOf(callback.node);
        List<String> list = CallbackInjector.summariseLocals(this.methodNode.desc, callback.target.arguments.length + (0x4C3A220 ^ 0x4C3A221));
        List<String> list2 = CallbackInjector.summariseLocals(callback.getDescriptorWithAllLocals(), callback.frameSize);
        Object[] objectArray = new Object[0xF6B5A4AB ^ 0xF6B5A4AE];
        objectArray[0x59ADF2B5 ^ 0x59ADF2B5] = callback.target;
        objectArray[0xEE08DC73 ^ 0xEE08DC72] = n;
        objectArray[0xD853597C ^ 0xD853597E] = this;
        objectArray[0x3926E71E ^ 0x3926E71D] = list;
        objectArray[0x665FD4E2 ^ 0x665FD4E6] = list2;
        return String.format(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("^\ua7d0\ua481\ua031\ua90c\u7d78\u8e0a\u243f\u8b24\u3437z\ua7e7\ua4a6\ua031\ua90c\u7d78\u8e49\u2475\u8b3a\u3467s\ua7f2\ua4bc\ua073\ua909\u7d73\u8e0a\u2479\u8b3f\u3476|\ua7e1\ua4b0\ua062\ua945\u7d77\u8e5e\u243a\u8b38\u3467q\ua7e9\ua4b1\ua074\ua945\u7d33\u8e4e\u243a\u8b3e\u34792\ua7e5\ua4b4\ua07d\ua909\u7d74\u8e4b\u2479\u8b3c\u34377\ua7f5\ua4fb\ua01b\ua920\u7d6e\u8e5a\u247f\u8b34\u3463w\ua7e2\ua4ef\ua031\ua940\u7d65\u8e20\u243a\u8b77\u3437T\ua7e9\ua4a0\ua07f\ua901\u7d2c\u8e0a\u243f\u8b24"), objectArray);
    }

    private MethodNode generateErrorMethod(Callback callback, String string, String string2) {
        MethodNode methodNode = this.info.addMethod(this.methodNode.access, this.methodNode.name + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("6\ua7eb\ua4bc\ua062\ua916\u7d7f\u8e44\u247d"), callback.getDescriptor());
        methodNode.maxLocals = Bytecode.getFirstNonArgLocalIndex(Type.getArgumentTypes(callback.getDescriptor()), (!this.isStatic ? 0x12C0678 ^ 0x12C0679 : 0xA68DE46D ^ 0xA68DE46D) != 0);
        methodNode.maxStack = 0x33E8B580 ^ 0x33E8B583;
        InsnList insnList = methodNode.instructions;
        insnList.add(new TypeInsnNode(0x5024B40F ^ 0x5024B4B4, string));
        insnList.add(new InsnNode(0xC27C6B83 ^ 0xC27C6BDA));
        insnList.add(new LdcInsnNode(string2));
        insnList.add(new MethodInsnNode(0xEF4C0B3C ^ 0xEF4C0B8B, string, \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b(".\ua7ef\ua4bb\ua078\ua911\u7d28"), \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b(":\ua7ca\ua4bf\ua070\ua913\u7d77\u8e05\u2476\u8b36\u3479u\ua7a9\ua486\ua065\ua917\u7d7f\u8e44\u247d\u8b6c\u343eD"), (0xBAD62A72 ^ 0xBAD62A72) != 0));
        insnList.add(new InsnNode(0x93348CC6 ^ 0x93348C79));
        return methodNode;
    }

    /*
     * Unable to fully structure code
     */
    private void printLocals(Callback var1_1) {
        block4: {
            var2_2 = Type.getArgumentTypes(var1_1.getDescriptorWithAllLocals());
            var3_3 = new SignaturePrinter(var1_1.target.method, var1_1.argNames);
            var4_4 = new SignaturePrinter(this.methodNode.name, var1_1.target.returnType, var2_2, var1_1.argNames);
            var4_4.setModifiers(this.methodNode);
            var5_5 = new PrettyPrinter();
            var5_5.kv(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("F\ua7e7\ua4a7\ua076\ua900\u7d62\u8e0a\u2459\u8b3b\u3476a\ua7f5"), this.classNode.name.replace((char)(-1149156730 ^ -1149156695), (char)(-1594673294 ^ -1594673316)));
            var5_5.kv(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("F\ua7e7\ua4a7\ua076\ua900\u7d62\u8e0a\u2457\u8b32\u3463z\ua7e9\ua4b1"), var3_3);
            var5_5.kv(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("F\ua7e7\ua4a7\ua076\ua900\u7d62\u8e0a\u2457\u8b36\u346f2\ua7ca\ua49a\ua052\ua924\u7d5a\u8e79"), var1_1.target.getMaxLocals());
            var5_5.kv(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("[\ua7e8\ua4bc\ua065\ua90c\u7d77\u8e46\u243a\u8b11\u3465s\ua7eb\ua4b0\ua031\ua936\u7d7f\u8e50\u247f"), var1_1.frameSize);
            var5_5.kv(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("Q\ua7e7\ua4b9\ua07d\ua907\u7d77\u8e49\u2471\u8b77\u3459s\ua7eb\ua4b0"), this.methodNode.name);
            v0 = new Object[-680429411 ^ -680429409];
            v0[-2069884778 ^ -2069884778] = var1_1.node.getClass().getSimpleName();
            v0[1994683290 ^ 1994683291] = Bytecode.getOpcodeName(var1_1.node.getCurrentTarget().getOpcode());
            var5_5.kv(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("[\ua7e8\ua4a6\ua065\ua917\u7d63\u8e49\u246e\u8b3e\u3478|"), \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("7\ua7f5\ua4f5\ua034\ua916"), v0);
            var5_5.hr();
            if (var1_1.locals.length <= var1_1.frameSize) break block4;
            v1 = new Object[-1770175974 ^ -1770175975];
            v1[-1079127431 ^ -1079127431] = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("^\ua7c9\ua496\ua050\ua929");
            v1[1264207043 ^ 1264207042] = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("F\ua7df\ua485\ua054");
            v1[-1076915295 ^ -1076915293] = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("\\\ua7c7\ua498\ua054");
            var5_5.add(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2\ua7a6\ua4f0\ua062\ua945\u7d36\u8e0f\u2428\u8b67\u34642\ua7a6\ua4f0\ua062"), v1);
            for (var6_6 = -1421682651 ^ -1421682651; var6_6 < var1_1.locals.length; ++var6_6) {
                v2 = var7_7 = var6_6 == var1_1.frameSize ? \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b(",") : \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2");
                if (var1_1.locals[var6_6] != null) {
                    v3 = new Object[1130835153 ^ 1130835156];
                    v3[1902206970 ^ 1902206970] = var7_7;
                    v3[-2027447429 ^ -2027447430] = var6_6;
                    v3[1957536371 ^ 1957536369] = SignaturePrinter.getTypeName(var1_1.localTypes[var6_6], (boolean)(1740107812 ^ 1740107812));
                    v3[-316059931 ^ -316059930] = CallbackInjector.meltSnowman(var6_6, var1_1.locals[var6_6].name);
                    v3[1673906651 ^ 1673906655] = var6_6 >= var1_1.frameSize ? \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b(".\ua7e5\ua4b4\ua061\ua911\u7d63\u8e58\u247f\u8b69") : \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("");
                    var5_5.add(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("7\ua7f5\ua4f5\ua04a\ua940\u7d25\u8e4e\u2447\u8b77\u34377\ua7b4\ua4e5\ua062\ua945\u7d36\u8e0f\u2437\u8b62\u3427a\ua7a6\ua4f0\ua062"), v3);
                    continue;
                }
                if (var6_6 <= 0) ** GOTO lbl-1000
                if (var1_1.localTypes[var6_6 - (-541341988 ^ -541341987)] == null) ** GOTO lbl-1000
                if (var1_1.localTypes[var6_6 - (-1838520905 ^ -1838520906)].getSize() > (-779902701 ^ -779902702)) {
                    v4 = -2121637683 ^ -2121637684;
                } else lbl-1000:
                // 3 sources

                {
                    v4 = -523593310 ^ -523593310;
                }
                var8_8 = v4;
                v5 = new Object[-1402456435 ^ -1402456434];
                v5[1496506467 ^ 1496506467] = var7_7;
                v5[1957507716 ^ 1957507717] = var6_6;
                v5[-1512254740 ^ -1512254738] = var8_8 != 0 ? \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b(".\ua7f2\ua4ba\ua061\ua95b") : \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("?");
                var5_5.add(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("7\ua7f5\ua4f5\ua04a\ua940\u7d25\u8e4e\u2447\u8b77\u34377\ua7b4\ua4e5\ua062"), v5);
            }
            var5_5.hr();
        }
        var5_5.add().add(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("=\ua7ac\ua4ff")).add(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2\ua7ac\ua4f5\ua054\ua91d\u7d66\u8e4f\u2479\u8b23\u3472v\ua7a6\ua4b6\ua070\ua909\u7d7a\u8e48\u247b\u8b34\u347c2\ua7f5\ua4bc\ua076\ua90b\u7d77\u8e5e\u246f\u8b25\u3472")).add(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2\ua7ac\ua4f5\ua03e"));
        v6 = new Object[-986113171 ^ -986113172];
        v6[201298220 ^ 201298220] = var4_4;
        var5_5.add(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("7\ua7f5\ua4f5\ua06a"), v6);
        var5_5.add(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2\ua7a6\ua4f5\ua031\ua94a\u7d39\u8e0a\u2457\u8b32\u3463z\ua7e9\ua4b1\ua031\ua907\u7d79\u8e4e\u2463")).add(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("o")).add().print(System.err);
    }

    private void createCallbackInfo(Callback callback, boolean bl) {
        if (callback.target != this.lastTarget) {
            this.lastId = null;
            this.lastDesc = null;
        }
        this.lastTarget = callback.target;
        String string = this.getIdentifier(callback);
        String string2 = callback.getCallbackInfoConstructorDescriptor();
        if (string.equals(this.lastId) && string2.equals(this.lastDesc) && !callback.isAtReturn && !this.cancellable) {
            return;
        }
        this.instanceCallbackInfo(callback, string, string2, bl);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void loadOrCreateCallbackInfo(Callback callback) {
        if (!this.cancellable) {
            if (this.totalInjections <= (0x684FC160 ^ 0x684FC161)) {
                this.createCallbackInfo(callback, (0x21006A27 ^ 0x21006A27) != 0);
                return;
            }
        }
        callback.add(new VarInsnNode(0x904DEEF9 ^ 0x904DEEE0, this.callbackInfoVar), (0xEA772201 ^ 0xEA772201) != 0, (0xB07D06FB ^ 0xB07D06FA) != 0);
    }

    private void dupReturnValue(Callback callback) {
        if (!callback.isAtReturn) {
            return;
        }
        callback.add(new InsnNode(0xD59EE739 ^ 0xD59EE760));
        callback.add(new VarInsnNode(callback.target.returnType.getOpcode(0x35F1C776 ^ 0x35F1C740), callback.marshalVar()));
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected void instanceCallbackInfo(Callback var1_1, String var2_2, String var3_3, boolean var4_4) {
        this.lastId = var2_2;
        this.lastDesc = var3_3;
        this.callbackInfoVar = var1_1.marshalVar();
        this.callbackInfoClass = var1_1.target.getCallbackInfoClass();
        if (!var4_4) ** GOTO lbl-1000
        if (this.totalInjections > (-1247267564 ^ -1247267563) && !var1_1.isAtReturn && !this.cancellable) {
            v0 = -672854525 ^ -672854526;
        } else lbl-1000:
        // 2 sources

        {
            v0 = -1774992954 ^ -1774992954;
        }
        var5_5 = v0;
        var1_1.add(new TypeInsnNode(1440874532 ^ 1440874655, this.callbackInfoClass), (boolean)(692060641 ^ 692060640), (boolean)(!var4_4 ? -374230008 ^ -374230007 : -1242686603 ^ -1242686603), var5_5);
        var1_1.add(new InsnNode(686245566 ^ 686245607), (boolean)(-1076794770 ^ -1076794769), (boolean)(-367085076 ^ -367085075), var5_5);
        var1_1.add(new LdcInsnNode(var2_2), (boolean)(-1770862670 ^ -1770862669), (boolean)(!var4_4 ? 1736810156 ^ 1736810157 : -336741062 ^ -336741062), var5_5);
        var1_1.add(new InsnNode(this.cancellable ? -2140731341 ^ -2140731337 : 1239769757 ^ 1239769758), (boolean)(-1506512426 ^ -1506512425), (boolean)(!var4_4 ? 1719672577 ^ 1719672576 : 1503478196 ^ 1503478196), var5_5);
        if (var1_1.isAtReturn) {
            var1_1.add(new VarInsnNode(var1_1.target.returnType.getOpcode(414825448 ^ 414825469), var1_1.marshalVar()), (boolean)(1947355202 ^ 1947355203), (boolean)(!var4_4 ? -453536937 ^ -453536938 : -1895672500 ^ -1895672500));
            var1_1.add(new MethodInsnNode(1176037920 ^ 1176038039, this.callbackInfoClass, \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b(".\ua7ef\ua4bb\ua078\ua911\u7d28"), var3_3, (boolean)(814248540 ^ 814248540)));
        } else {
            var1_1.add(new MethodInsnNode(-1366667263 ^ -1366667082, this.callbackInfoClass, \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b(".\ua7ef\ua4bb\ua078\ua911\u7d28"), var3_3, (boolean)(-1505655122 ^ -1505655122)), (boolean)(-1211741182 ^ -1211741182), (boolean)(-2089865052 ^ -2089865052), var5_5);
        }
        if (var4_4) {
            var1_1.target.addLocalVariable(this.callbackInfoVar, \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("q\ua7e7\ua4b9\ua07d\ua907\u7d77\u8e49\u2471\u8b1e\u3479t\ua7e9") + this.callbackInfoVar, \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("^") + this.callbackInfoClass + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b(")"));
            var1_1.add(new VarInsnNode(-1599642647 ^ -1599642669, this.callbackInfoVar), (boolean)(1054286584 ^ 1054286584), (boolean)(2015755756 ^ 2015755756), var5_5);
        }
    }

    private void invokeCallback(Callback callback, MethodNode methodNode) {
        if (!this.isStatic) {
            callback.add(new VarInsnNode(0x6C9537B7 ^ 0x6C9537AE, 0x85F85287 ^ 0x85F85287), (0x86C23C1D ^ 0x86C23C1D) != 0, (0x2288743F ^ 0x2288743E) != 0);
        }
        if (callback.captureArgs()) {
            Bytecode.loadArgs(callback.target.arguments, callback, this.isStatic ? 0x18AD7FE8 ^ 0x18AD7FE8 : 0xC2685B28 ^ 0xC2685B29, 0xC383FEB2 ^ 0x3C7C014D);
        }
        this.loadOrCreateCallbackInfo(callback);
        if (callback.canCaptureLocals) {
            Locals.loadLocals(callback.localTypes, callback, callback.frameSize, callback.extraArgs);
        }
        this.invokeHandler(callback, methodNode);
    }

    private String getIdentifier(Callback callback) {
        String string = Strings.isNullOrEmpty((String)this.identifier) ? callback.target.method.name : this.identifier;
        String string2 = this.ids.get(callback.node.getId());
        return string + (Strings.isNullOrEmpty((String)string2) ? \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("") : \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("(") + string2);
    }

    protected void injectCancellationCode(Callback callback) {
        if (!this.cancellable) {
            return;
        }
        callback.add(new VarInsnNode(0x3694A967 ^ 0x3694A97E, this.callbackInfoVar));
        callback.add(new MethodInsnNode(0xA51ACBB7 ^ 0xA51ACB01, this.callbackInfoClass, CallbackInfo.getIsCancelledMethodName(), CallbackInfo.getIsCancelledMethodSig(), (0xC898938C ^ 0xC898938C) != 0));
        LabelNode labelNode = new LabelNode();
        callback.add(new JumpInsnNode(0x90580993 ^ 0x9058090A, labelNode));
        this.injectReturnCode(callback);
        callback.add(labelNode);
    }

    protected void injectReturnCode(Callback callback) {
        if (callback.target.returnType.equals(Type.VOID_TYPE)) {
            callback.add(new InsnNode(0xDC735E14 ^ 0xDC735EA5));
        } else {
            callback.add(new VarInsnNode(0x88A0C4FA ^ 0x88A0C4E3, callback.marshalVar()));
            String string = CallbackInfoReturnable.getReturnAccessor(callback.target.returnType);
            String string2 = CallbackInfoReturnable.getReturnDescriptor(callback.target.returnType);
            callback.add(new MethodInsnNode(0x71953FE0 ^ 0x71953F56, this.callbackInfoClass, string, string2, (0xAACE5A63 ^ 0xAACE5A63) != 0));
            if (callback.target.returnType.getSort() == (0xEB762BD ^ 0xEB762B7)) {
                callback.add(new TypeInsnNode(0xA9B615E8 ^ 0xA9B61528, callback.target.returnType.getInternalName()));
            }
            callback.add(new InsnNode(callback.target.returnType.getOpcode(0x3C4FEC7 ^ 0x3C4FE6B)));
        }
    }

    protected boolean isStatic() {
        return this.isStatic;
    }

    private static List<String> summariseLocals(String string, int n) {
        return CallbackInjector.summariseLocals(Type.getArgumentTypes(string), n);
    }

    private static List<String> summariseLocals(Type[] typeArray, int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (typeArray != null) {
            while (n < typeArray.length) {
                if (typeArray[n] != null) {
                    arrayList.add(typeArray[n].toString());
                }
                ++n;
            }
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     */
    static String meltSnowman(int n, String string) {
        String string2;
        if (string != null) {
            if ((0x6BE81752 ^ 0x6BE83151) == string.charAt(0x97A6ABB1 ^ 0x97A6ABB1)) {
                string2 = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("d\ua7e7\ua4a7") + n;
                return string2;
            }
        }
        string2 = string;
        return string2;
    }

    private class Callback
    extends InsnList {
        private final MethodNode handler;
        private final AbstractInsnNode head;
        final Target target;
        final InjectionNodes.InjectionNode node;
        final LocalVariableNode[] locals;
        final Type[] localTypes;
        final int frameSize;
        final int extraArgs;
        final boolean canCaptureLocals;
        final boolean isAtReturn;
        final String desc;
        final String descl;
        final String[] argNames;
        int ctor;
        int invoke;
        private int marshalVar = 0x723BA804 ^ 0x8DC457FB;
        private boolean captureArgs = 0x5E03F44D ^ 0x5E03F44C;

        Callback(MethodNode methodNode, Target target, InjectionNodes.InjectionNode injectionNode, LocalVariableNode[] localVariableNodeArray, boolean bl) {
            this.handler = methodNode;
            this.target = target;
            this.head = target.insns.getFirst();
            this.node = injectionNode;
            this.locals = localVariableNodeArray;
            this.localTypes = localVariableNodeArray != null ? new Type[localVariableNodeArray.length] : null;
            this.frameSize = Bytecode.getFirstNonArgLocalIndex(target.arguments, (!CallbackInjector.this.isStatic() ? 0x74A03C06 ^ 0x74A03C07 : 0x7706E764 ^ 0x7706E764) != 0);
            ArrayList<String> arrayList = null;
            if (localVariableNodeArray != null) {
                int n = CallbackInjector.this.isStatic() ? 0x9070A1B2 ^ 0x9070A1B2 : 0x34ACE6D ^ 0x34ACE6C;
                arrayList = new ArrayList<String>();
                for (int i = 0xCA70DC44 ^ 0xCA70DC44; i <= localVariableNodeArray.length; ++i) {
                    if (i == this.frameSize) {
                        arrayList.add(target.returnType == Type.VOID_TYPE ? \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("q\ua7ef") : \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("q\ua7ef\ua4a7"));
                    }
                    if (i >= localVariableNodeArray.length || localVariableNodeArray[i] == null) continue;
                    this.localTypes[i] = Type.getType(localVariableNodeArray[i].desc);
                    if (i < n) continue;
                    arrayList.add(CallbackInjector.meltSnowman(i, localVariableNodeArray[i].name));
                }
            }
            this.extraArgs = Math.max(0x70A02BC7 ^ 0x70A02BC7, Bytecode.getFirstNonArgLocalIndex(this.handler) - (this.frameSize + (0x1EE74CF4 ^ 0x1EE74CF5)));
            String[] stringArray = this.argNames = arrayList != null ? arrayList.toArray(new String[arrayList.size()]) : null;
            int n = bl && localVariableNodeArray != null && localVariableNodeArray.length > this.frameSize ? 0xE9D16054 ^ 0xE9D16055 : (int)((this.canCaptureLocals = 0x6F5E525 ^ 0x6F5E525) ? 1 : 0);
            this.isAtReturn = this.node.getCurrentTarget() instanceof InsnNode && this.isValueReturnOpcode(this.node.getCurrentTarget().getOpcode()) ? 0x5EB507F0 ^ 0x5EB507F1 : 0x8203729D ^ 0x8203729D;
            this.desc = target.getCallbackDescriptor(this.localTypes, target.arguments);
            this.descl = target.getCallbackDescriptor((0xEE5F16F1 ^ 0xEE5F16F0) != 0, this.localTypes, target.arguments, this.frameSize, this.extraArgs);
            this.invoke = target.arguments.length + (this.canCaptureLocals ? this.localTypes.length - this.frameSize : 0xB325D458 ^ 0xB325D458);
        }

        /*
         * Enabled aggressive block sorting
         */
        private boolean isValueReturnOpcode(int n) {
            int n2;
            if (n >= (0xCD38D86B ^ 0xCD38D8C7)) {
                if (n < (0xB84A0B2B ^ 0xB84A0B9A)) {
                    n2 = 0xE758A26 ^ 0xE758A27;
                    return n2 != 0;
                }
            }
            n2 = 0x5C23327E ^ 0x5C23327E;
            return n2 != 0;
        }

        String getDescriptor() {
            return this.canCaptureLocals ? this.descl : this.desc;
        }

        String getDescriptorWithAllLocals() {
            return this.target.getCallbackDescriptor((0x1C0B5EA ^ 0x1C0B5EB) != 0, this.localTypes, this.target.arguments, this.frameSize, 0x11C38B11 ^ 0x11C3F4EE);
        }

        String getCallbackInfoConstructorDescriptor() {
            return this.isAtReturn ? CallbackInfo.getConstructorDescriptor(this.target.returnType) : CallbackInfo.getConstructorDescriptor();
        }

        void add(AbstractInsnNode abstractInsnNode, boolean bl, boolean bl2) {
            this.add(abstractInsnNode, bl, bl2, (0x82E430A1 ^ 0x82E430A1) != 0);
        }

        void add(AbstractInsnNode abstractInsnNode, boolean bl, boolean bl2, boolean bl3) {
            if (bl3) {
                this.target.insns.insertBefore(this.head, abstractInsnNode);
            } else {
                this.add(abstractInsnNode);
            }
            this.ctor += bl ? 0x5B14049C ^ 0x5B14049D : 0x387BBCA5 ^ 0x387BBCA5;
            this.invoke += bl2 ? 0x3E56FBD2 ^ 0x3E56FBD3 : 0xF0DF5E7A ^ 0xF0DF5E7A;
        }

        void inject() {
            this.target.insertBefore(this.node, (InsnList)this);
            this.target.addToStack(Math.max(this.invoke, this.ctor));
        }

        boolean checkDescriptor(String string) {
            Type[] typeArray;
            if (this.getDescriptor().equals(string)) {
                return (0xE93C2458 ^ 0xE93C2459) != 0;
            }
            if (this.target.getSimpleCallbackDescriptor().equals(string) && !this.canCaptureLocals) {
                this.captureArgs = 0xB21BAC9F ^ 0xB21BAC9F;
                return (0xC0159A ^ 0xC0159B) != 0;
            }
            Type[] typeArray2 = Type.getArgumentTypes(string);
            if (typeArray2.length != (typeArray = Type.getArgumentTypes(this.descl)).length) {
                return (0x7A676D33 ^ 0x7A676D33) != 0;
            }
            for (int i = 0x469C03B9 ^ 0x469C03B9; i < typeArray.length; ++i) {
                Type type = typeArray2[i];
                if (type.equals(typeArray[i])) continue;
                if (type.getSort() == (0x13409FA ^ 0x13409F3)) {
                    return (0xE01F79CB ^ 0xE01F79CB) != 0;
                }
                if (Annotations.getInvisibleParameter(this.handler, Coerce.class, i) == null) {
                    return (0xE528EB1F ^ 0xE528EB1F) != 0;
                }
                if (Injector.canCoerce(typeArray2[i], typeArray[i])) continue;
                return (0xCF14B970 ^ 0xCF14B970) != 0;
            }
            return (0x38EC70CC ^ 0x38EC70CD) != 0;
        }

        boolean captureArgs() {
            return this.captureArgs;
        }

        int marshalVar() {
            if (this.marshalVar < 0) {
                this.marshalVar = this.target.allocateLocal();
            }
            return this.marshalVar;
        }
    }
}

