/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.injection.modify;

import java.util.Collection;
import java.util.ListIterator;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.VarInsnNode;
import org.spongepowered.asm.mixin.injection.InjectionPoint;
import org.spongepowered.asm.mixin.injection.modify.LocalVariableDiscriminator;
import org.spongepowered.asm.mixin.injection.modify.ModifyVariableInjector;
import org.spongepowered.asm.mixin.injection.struct.InjectionPointData;
import org.spongepowered.asm.mixin.injection.struct.Target;

@InjectionPoint.AtCode(value="LOAD")
public class BeforeLoadLocal
extends ModifyVariableInjector.ContextualInjectionPoint {
    private final Type returnType;
    private final LocalVariableDiscriminator discriminator;
    private final int opcode;
    private final int ordinal;
    private boolean opcodeAfter;

    protected BeforeLoadLocal(InjectionPointData injectionPointData) {
        this(injectionPointData, 0x6B80886D ^ 0x6B808878, (0x550CBCE6 ^ 0x550CBCE6) != 0);
    }

    protected BeforeLoadLocal(InjectionPointData injectionPointData, int n, boolean bl) {
        super(injectionPointData.getContext());
        this.returnType = injectionPointData.getMethodReturnType();
        this.discriminator = injectionPointData.getLocalVariableDiscriminator();
        this.opcode = injectionPointData.getOpcode(this.returnType.getOpcode(n));
        this.ordinal = injectionPointData.getOrdinal();
        this.opcodeAfter = bl;
    }

    @Override
    boolean find(Target target, Collection<AbstractInsnNode> collection) {
        SearchState searchState = new SearchState(this.ordinal, this.discriminator.printLVT());
        ListIterator<AbstractInsnNode> listIterator = target.method.instructions.iterator();
        while (listIterator.hasNext()) {
            int n;
            AbstractInsnNode abstractInsnNode = listIterator.next();
            if (searchState.isPendingCheck()) {
                n = this.discriminator.findLocal(this.returnType, this.discriminator.isArgsOnly(), target, abstractInsnNode);
                searchState.check(collection, abstractInsnNode, n);
                continue;
            }
            if (!(abstractInsnNode instanceof VarInsnNode) || abstractInsnNode.getOpcode() != this.opcode) continue;
            if (this.ordinal != (0x78E7339F ^ 0x8718CC60) && searchState.success()) continue;
            searchState.register((VarInsnNode)abstractInsnNode);
            if (this.opcodeAfter) {
                searchState.setPendingCheck();
                continue;
            }
            n = this.discriminator.findLocal(this.returnType, this.discriminator.isArgsOnly(), target, abstractInsnNode);
            searchState.check(collection, abstractInsnNode, n);
        }
        return searchState.success();
    }

    static class SearchState {
        private final boolean print;
        private final int targetOrdinal;
        private int ordinal = 0xA2A60DAC ^ 0xA2A60DAC;
        private boolean pendingCheck = 0xBBEC6B36 ^ 0xBBEC6B36;
        private boolean found = 0x4B77E4C9 ^ 0x4B77E4C9;
        private VarInsnNode varNode;

        SearchState(int n, boolean bl) {
            this.targetOrdinal = n;
            this.print = bl;
        }

        boolean success() {
            return this.found;
        }

        boolean isPendingCheck() {
            return this.pendingCheck;
        }

        void setPendingCheck() {
            this.pendingCheck = 0x9A35C2C2 ^ 0x9A35C2C3;
        }

        void register(VarInsnNode varInsnNode) {
            this.varNode = varInsnNode;
        }

        void check(Collection<AbstractInsnNode> collection, AbstractInsnNode abstractInsnNode, int n) {
            this.pendingCheck = 0x2114EFA2 ^ 0x2114EFA2;
            if (n != this.varNode.var) {
                if (n > (0xC5A6C40F ^ 0x3A593BF1) || !this.print) {
                    return;
                }
            }
            if (this.targetOrdinal == (0x58147F92 ^ 0xA7EB806D) || this.targetOrdinal == this.ordinal) {
                collection.add(abstractInsnNode);
                this.found = 0xE97BD7EF ^ 0xE97BD7EE;
            }
            this.ordinal += 0x5C74C632 ^ 0x5C74C633;
            this.varNode = null;
        }
    }
}

