/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.injection.struct;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.util.Bytecode;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2;

public class InjectionNodes
extends ArrayList<InjectionNode> {
    private static final long serialVersionUID = 1L;

    public InjectionNode add(AbstractInsnNode abstractInsnNode) {
        InjectionNode injectionNode = this.get(abstractInsnNode);
        if (injectionNode == null) {
            injectionNode = new InjectionNode(abstractInsnNode);
            this.add(injectionNode);
        }
        return injectionNode;
    }

    public InjectionNode get(AbstractInsnNode abstractInsnNode) {
        for (InjectionNode injectionNode : this) {
            if (!injectionNode.matches(abstractInsnNode)) continue;
            return injectionNode;
        }
        return null;
    }

    public boolean contains(AbstractInsnNode abstractInsnNode) {
        return (this.get(abstractInsnNode) != null ? 0x4C06439C ^ 0x4C06439D : 0x11D00892 ^ 0x11D00892) != 0;
    }

    public void replace(AbstractInsnNode abstractInsnNode, AbstractInsnNode abstractInsnNode2) {
        InjectionNode injectionNode = this.get(abstractInsnNode);
        if (injectionNode != null) {
            injectionNode.replace(abstractInsnNode2);
        }
    }

    public void remove(AbstractInsnNode abstractInsnNode) {
        InjectionNode injectionNode = this.get(abstractInsnNode);
        if (injectionNode != null) {
            injectionNode.remove();
        }
    }

    public static class InjectionNode
    implements Comparable<InjectionNode> {
        private static int nextId = 0x2F200ED1 ^ 0x2F200ED1;
        private final int id;
        private final AbstractInsnNode originalTarget;
        private AbstractInsnNode currentTarget;
        private Map<String, Object> decorations;

        public InjectionNode(AbstractInsnNode abstractInsnNode) {
            this.currentTarget = this.originalTarget = abstractInsnNode;
            int n = nextId;
            nextId = n + (0x7879DD75 ^ 0x7879DD74);
            this.id = n;
        }

        public int getId() {
            return this.id;
        }

        public AbstractInsnNode getOriginalTarget() {
            return this.originalTarget;
        }

        public AbstractInsnNode getCurrentTarget() {
            return this.currentTarget;
        }

        public InjectionNode replace(AbstractInsnNode abstractInsnNode) {
            this.currentTarget = abstractInsnNode;
            return this;
        }

        public InjectionNode remove() {
            this.currentTarget = null;
            return this;
        }

        public boolean matches(AbstractInsnNode abstractInsnNode) {
            return (this.originalTarget == abstractInsnNode || this.currentTarget == abstractInsnNode ? 0x6C876D73 ^ 0x6C876D72 : 0xF16EEE25 ^ 0xF16EEE25) != 0;
        }

        public boolean isReplaced() {
            return (this.originalTarget != this.currentTarget ? 0x89DBDA1B ^ 0x89DBDA1A : 0xC9173578 ^ 0xC9173578) != 0;
        }

        public boolean isRemoved() {
            return (this.currentTarget == null ? 0x8955D6CF ^ 0x8955D6CE : 0xE0298CF0 ^ 0xE0298CF0) != 0;
        }

        public <V> InjectionNode decorate(String string, V v) {
            if (this.decorations == null) {
                this.decorations = new HashMap<String, Object>();
            }
            this.decorations.put(string, v);
            return this;
        }

        public boolean hasDecoration(String string) {
            return (this.decorations != null && this.decorations.get(string) != null ? 0xCE212481 ^ 0xCE212480 : 0x58A311A8 ^ 0x58A311A8) != 0;
        }

        public <V> V getDecoration(String string) {
            return (V)(this.decorations == null ? null : this.decorations.get(string));
        }

        @Override
        public int compareTo(InjectionNode injectionNode) {
            return injectionNode == null ? 0xB8AD11A4 ^ 0xC752EE5B : this.hashCode() - injectionNode.hashCode();
        }

        public String toString() {
            Object[] objectArray = new Object[0x62ACD3EA ^ 0x62ACD3EB];
            objectArray[0xF9AE1741 ^ 0xF9AE1741] = Bytecode.describeNode(this.currentTarget).replaceAll(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("N\ua7f5\ua4fe"), \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2"));
            return String.format(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("[\ua7e8\ua4bf\ua074\ua906\u7d62\u8e43\u2475\u8b39\u3459}\ua7e2\ua4b0\ua04a\ua940\u7d65\u8e77"), objectArray);
        }
    }
}

