/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.injection.struct;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.mixin.injection.Group;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.injection.throwables.InjectionValidationException;
import org.spongepowered.asm.util.Annotations;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2;

public class InjectorGroupInfo {
    private final String name;
    private final List<InjectionInfo> members = new ArrayList<InjectionInfo>();
    private final boolean isDefault;
    private int minCallbackCount = 0xB4F94711 ^ 0x4B06B8EE;
    private int maxCallbackCount = 0x380B2EA7 ^ 0x47F4D158;

    public InjectorGroupInfo(String string) {
        this(string, (0x512E86A ^ 0x512E86A) != 0);
    }

    InjectorGroupInfo(String string, boolean bl) {
        this.name = string;
        this.isDefault = bl;
    }

    public String toString() {
        Object[] objectArray = new Object[0x4CDECD01 ^ 0x4CDECD02];
        objectArray[0x38051E55 ^ 0x38051E55] = this.getName();
        objectArray[0x66E66BBB ^ 0x66E66BBA] = this.getMinRequired();
        objectArray[0x8E625668 ^ 0x8E62566A] = this.getMaxAllowed();
        return String.format(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("R\ua7c1\ua4a7\ua07e\ua910\u7d66\u8e02\u2474\u8b36\u347aw\ua7bb\ua4f0\ua062\ua949\u7d36\u8e47\u2473\u8b39\u342a7\ua7e2\ua4f9\ua031\ua908\u7d77\u8e52\u2427\u8b72\u3473;"), objectArray);
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public String getName() {
        return this.name;
    }

    public int getMinRequired() {
        return Math.max(this.minCallbackCount, 0x441DB983 ^ 0x441DB982);
    }

    public int getMaxAllowed() {
        return Math.min(this.maxCallbackCount, 0x4159797A ^ 0x3EA68685);
    }

    public Collection<InjectionInfo> getMembers() {
        return Collections.unmodifiableCollection(this.members);
    }

    public void setMinRequired(int n) {
        if (n < (0x18DB0C02 ^ 0x18DB0C03)) {
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("Q\ua7e7\ua4bb\ua07f\ua90a\u7d62\u8e0a\u2469\u8b32\u34632\ua7fc\ua4b0\ua063\ua90a\u7d36\u8e45\u2468\u8b77\u3479w\ua7e1\ua4b4\ua065\ua90c\u7d60\u8e4f\u243a\u8b21\u3476~\ua7f3\ua4b0\ua031\ua903\u7d79\u8e58\u243a\u8b3e\u3479x\ua7e3\ua4b6\ua065\ua90a\u7d64\u8e0a\u247d\u8b25\u3478g\ua7f6\ua4f5\ua07c\ua90c\u7d78\u8e0a\u2479\u8b38\u3462|\ua7f2\ua4fb\ua031\ua924\u7d62\u8e5e\u247f\u8b3a\u3467f\ua7e3\ua4b1\ua031\ua911\u7d79\u8e0a\u2469\u8b32\u34632\ua7eb\ua4bc\ua07f\ua958") + n + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2\ua7e9\ua4bb\ua031") + this);
        }
        if (this.minCallbackCount > 0 && this.minCallbackCount != n) {
            Object[] objectArray = new Object[0xE24D0506 ^ 0xE24D0505];
            objectArray[0xE6BF7D22 ^ 0xE6BF7D22] = n;
            objectArray[0xF51E0ED2 ^ 0xF51E0ED3] = this.name;
            objectArray[0xFEBC9E7C ^ 0xFEBC9E7E] = this.minCallbackCount;
            LogManager.getLogger((String)\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("\u007f\ua7ef\ua4ad\ua078\ua90b")).warn(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("Q\ua7e9\ua4bb\ua077\ua909\u7d7f\u8e49\u246e\u8b3e\u3479u\ua7a6\ua4b8\ua078\ua90b\u7d36\u8e5c\u247b\u8b3b\u3462w\ua7a6\ua4f2\ua06a\ua918\u7d31\u8e0a\u2475\u8b39\u3437R\ua7c1\ua4a7\ua07e\ua910\u7d66\u8e02\u2461\u8b2a\u343e>\ua7a6\ua4a5\ua063\ua900\u7d60\u8e43\u2475\u8b22\u3464~\ua7ff\ua4f5\ua062\ua915\u7d73\u8e49\u2473\u8b31\u347ew\ua7e2\ua4f5\ua06a\ua918"), objectArray);
        }
        this.minCallbackCount = Math.max(this.minCallbackCount, n);
    }

    public void setMaxAllowed(int n) {
        if (n < (0xF55DB90D ^ 0xF55DB90C)) {
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("Q\ua7e7\ua4bb\ua07f\ua90a\u7d62\u8e0a\u2469\u8b32\u34632\ua7fc\ua4b0\ua063\ua90a\u7d36\u8e45\u2468\u8b77\u3479w\ua7e1\ua4b4\ua065\ua90c\u7d60\u8e4f\u243a\u8b21\u3476~\ua7f3\ua4b0\ua031\ua903\u7d79\u8e58\u243a\u8b3e\u3479x\ua7e3\ua4b6\ua065\ua90a\u7d64\u8e0a\u247d\u8b25\u3478g\ua7f6\ua4f5\ua07c\ua904\u7d6e\u8e0a\u2479\u8b38\u3462|\ua7f2\ua4fb\ua031\ua924\u7d62\u8e5e\u247f\u8b3a\u3467f\ua7e3\ua4b1\ua031\ua911\u7d79\u8e0a\u2469\u8b32\u34632\ua7eb\ua4b4\ua069\ua958") + n + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2\ua7e9\ua4bb\ua031") + this);
        }
        if (this.maxCallbackCount < (0x272E8421 ^ 0x58D17BDE) && this.maxCallbackCount != n) {
            Object[] objectArray = new Object[0xC7120812 ^ 0xC7120811];
            objectArray[0xB06B896 ^ 0xB06B896] = n;
            objectArray[0x4003DB75 ^ 0x4003DB74] = this.name;
            objectArray[0xF6D71487 ^ 0xF6D71485] = this.maxCallbackCount;
            LogManager.getLogger((String)\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("\u007f\ua7ef\ua4ad\ua078\ua90b")).warn(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("Q\ua7e9\ua4bb\ua077\ua909\u7d7f\u8e49\u246e\u8b3e\u3479u\ua7a6\ua4b8\ua070\ua91d\u7d36\u8e5c\u247b\u8b3b\u3462w\ua7a6\ua4f2\ua06a\ua918\u7d31\u8e0a\u2475\u8b39\u3437R\ua7c1\ua4a7\ua07e\ua910\u7d66\u8e02\u2461\u8b2a\u343e>\ua7a6\ua4a5\ua063\ua900\u7d60\u8e43\u2475\u8b22\u3464~\ua7ff\ua4f5\ua062\ua915\u7d73\u8e49\u2473\u8b31\u347ew\ua7e2\ua4f5\ua06a\ua918"), objectArray);
        }
        this.maxCallbackCount = Math.min(this.maxCallbackCount, n);
    }

    public InjectorGroupInfo add(InjectionInfo injectionInfo) {
        this.members.add(injectionInfo);
        return this;
    }

    public InjectorGroupInfo validate() throws InjectionValidationException {
        if (this.members.size() == 0) {
            return this;
        }
        int n = 0xF684AEC2 ^ 0xF684AEC2;
        for (InjectionInfo injectionInfo : this.members) {
            n += injectionInfo.getInjectedCallbackCount();
        }
        int n2 = this.getMinRequired();
        int n3 = this.getMaxAllowed();
        if (n < n2) {
            Object[] objectArray = new Object[0x1FFE3038 ^ 0x1FFE303A];
            objectArray[0xFE3A4F2D ^ 0xFE3A4F2D] = n2;
            objectArray[0xBFA35463 ^ 0xBFA35462] = n;
            throw new InjectionValidationException(this, String.format(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("w\ua7fe\ua4a5\ua074\ua906\u7d62\u8e4f\u247e\u8b77\u3432v\ua7a6\ua4bc\ua07f\ua913\u7d79\u8e49\u247b\u8b23\u347e}\ua7e8\ua4fd\ua062\ua94c\u7d36\u8e48\u246f\u8b23\u3437}\ua7e8\ua4b9\ua068\ua945\u7d33\u8e4e\u243a\u8b24\u3462q\ua7e5\ua4b0\ua074\ua901\u7d73\u8e4e"), objectArray));
        }
        if (n > n3) {
            Object[] objectArray = new Object[0x14692AA0 ^ 0x14692AA2];
            objectArray[0x39DA7D92 ^ 0x39DA7D92] = n3;
            objectArray[0xDB629F9F ^ 0xDB629F9E] = n;
            throw new InjectionValidationException(this, String.format(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("\u007f\ua7e7\ua4ad\ua078\ua908\u7d63\u8e47\u243a\u8b38\u34712\ua7a3\ua4b1\ua031\ua90c\u7d78\u8e5c\u2475\u8b34\u3476f\ua7ef\ua4ba\ua07f\ua94d\u7d65\u8e03\u243a\u8b36\u347b~\ua7e9\ua4a2\ua074\ua901\u7d36\u8e48\u246f\u8b23\u34377\ua7e2\ua4f5\ua062\ua910\u7d75\u8e49\u247f\u8b32\u3473w\ua7e2"), objectArray));
        }
        return this;
    }

    public static final class Map
    extends HashMap<String, InjectorGroupInfo> {
        private static final long serialVersionUID = 1L;
        private static final InjectorGroupInfo NO_GROUP = new InjectorGroupInfo(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("\\\ua7c9\ua49b\ua054"), (0x492398 ^ 0x492399) != 0);

        @Override
        public InjectorGroupInfo get(Object object) {
            return this.forName(object.toString());
        }

        public InjectorGroupInfo forName(String string) {
            InjectorGroupInfo injectorGroupInfo = (InjectorGroupInfo)super.get(string);
            if (injectorGroupInfo == null) {
                injectorGroupInfo = new InjectorGroupInfo(string);
                this.put(string, injectorGroupInfo);
            }
            return injectorGroupInfo;
        }

        public InjectorGroupInfo parseGroup(MethodNode methodNode, String string) {
            return this.parseGroup(Annotations.getInvisible(methodNode, Group.class), string);
        }

        public InjectorGroupInfo parseGroup(AnnotationNode annotationNode, String string) {
            Integer n;
            if (annotationNode == null) {
                return NO_GROUP;
            }
            String string2 = (String)Annotations.getValue(annotationNode, \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("|\ua7e7\ua4b8\ua074"));
            if (string2 == null || string2.isEmpty()) {
                string2 = string;
            }
            InjectorGroupInfo injectorGroupInfo = this.forName(string2);
            Integer n2 = (Integer)Annotations.getValue(annotationNode, \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("\u007f\ua7ef\ua4bb"));
            if (n2 != null) {
                if (n2 != (0x23D5AB7C ^ 0xDC2A5483)) {
                    injectorGroupInfo.setMinRequired(n2);
                }
            }
            if ((n = (Integer)Annotations.getValue(annotationNode, \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("\u007f\ua7e7\ua4ad"))) != null) {
                if (n != (0x9A8C7856 ^ 0x657387A9)) {
                    injectorGroupInfo.setMaxAllowed(n);
                }
            }
            return injectorGroupInfo;
        }

        public void validateAll() throws InjectionValidationException {
            for (InjectorGroupInfo injectorGroupInfo : this.values()) {
                injectorGroupInfo.validate();
            }
        }
    }
}

