/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.struct;

import org.spongepowered.asm.lib.tree.FieldInsnNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.mixin.transformer.throwables.MixinTransformerError;
import org.spongepowered.asm.util.Bytecode;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2;

public abstract class MemberRef {
    private static final int[] H_OPCODES;

    public abstract boolean isField();

    public abstract int getOpcode();

    public abstract void setOpcode(int var1);

    public abstract String getOwner();

    public abstract void setOwner(String var1);

    public abstract String getName();

    public abstract void setName(String var1);

    public abstract String getDesc();

    public abstract void setDesc(String var1);

    public String toString() {
        String string = Bytecode.getOpcodeName(this.getOpcode());
        Object[] objectArray = new Object[0xA217FDDF ^ 0xA217FDDA];
        objectArray[0x4AF2F0C4 ^ 0x4AF2F0C4] = string;
        objectArray[0xABC9A3C6 ^ 0xABC9A3C7] = this.getOwner();
        objectArray[0x112A9C95 ^ 0x112A9C97] = this.getName();
        objectArray[0x92D3A1E4 ^ 0x92D3A1E7] = this.isField() ? \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("(") : \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("");
        objectArray[0x34C574AB ^ 0x34C574AF] = this.getDesc();
        return String.format(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("7\ua7f5\ua4f5\ua077\ua90a\u7d64\u8e0a\u243f\u8b24\u34397\ua7f5\ua4f0\ua062\ua940\u7d65"), objectArray);
    }

    public boolean equals(Object object) {
        if (!(object instanceof MemberRef)) {
            return (0xBEAC176F ^ 0xBEAC176F) != 0;
        }
        MemberRef memberRef = (MemberRef)object;
        return (this.getOpcode() == memberRef.getOpcode() && this.getOwner().equals(memberRef.getOwner()) && this.getName().equals(memberRef.getName()) && this.getDesc().equals(memberRef.getDesc()) ? 0xE6A1310C ^ 0xE6A1310D : 0xCB85D5BA ^ 0xCB85D5BA) != 0;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    static int opcodeFromTag(int n) {
        return n >= 0 && n < H_OPCODES.length ? H_OPCODES[n] : 0x2D2F4E79 ^ 0x2D2F4E79;
    }

    static int tagFromOpcode(int n) {
        for (int i = 0x907178AA ^ 0x907178AB; i < H_OPCODES.length; ++i) {
            if (H_OPCODES[i] != n) continue;
            return i;
        }
        return 0x6F85C71A ^ 0x6F85C71A;
    }

    static {
        int[] nArray = new int[0xA8A2A6EB ^ 0xA8A2A6E1];
        nArray[0x13C26690 ^ 0x13C26690] = 0x309D275D ^ 0x309D275D;
        nArray[0x7323540 ^ 0x7323541] = 0xBCDF4744 ^ 0xBCDF47F0;
        nArray[0x8514F0C9 ^ 0x8514F0CB] = 0xC39F723E ^ 0xC39F728C;
        nArray[0xC643DA5B ^ 0xC643DA58] = 0x4186BC01 ^ 0x4186BCB4;
        nArray[0xCE8043EC ^ 0xCE8043E8] = 0xD7EBFF7A ^ 0xD7EBFFC9;
        nArray[0x8717516D ^ 0x87175168] = 0xF9B27976 ^ 0xF9B279C0;
        nArray[0x8E91FDEE ^ 0x8E91FDE8] = 0xA9E89B75 ^ 0xA9E89BCD;
        nArray[0x62614080 ^ 0x62614087] = 0xAA5F3A8C ^ 0xAA5F3A3B;
        nArray[0xAAF89D00 ^ 0xAAF89D08] = 0x4381D22B ^ 0x4381D29C;
        nArray[0xCF491F99 ^ 0xCF491F90] = 0x2F7835CC ^ 0x2F783575;
        H_OPCODES = nArray;
    }

    public static final class Handle
    extends MemberRef {
        private org.spongepowered.asm.lib.Handle handle;

        public Handle(org.spongepowered.asm.lib.Handle handle) {
            this.handle = handle;
        }

        public org.spongepowered.asm.lib.Handle getMethodHandle() {
            return this.handle;
        }

        @Override
        public boolean isField() {
            switch (this.handle.getTag()) {
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    return (0xA4B36E4D ^ 0xA4B36E4D) != 0;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    return (0x39B2D09F ^ 0x39B2D09E) != 0;
                }
            }
            throw new MixinTransformerError(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b23\u3476u\ua7a6") + this.handle.getTag() + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2\ua7e0\ua4ba\ua063\ua945\u7d7b\u8e4f\u246e\u8b3f\u3478v\ua7a6\ua4bd\ua070\ua90b\u7d72\u8e46\u247f\u8b77") + this.handle + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("<"));
        }

        @Override
        public int getOpcode() {
            int n = MemberRef.opcodeFromTag(this.handle.getTag());
            if (n == 0) {
                throw new MixinTransformerError(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b23\u3476u\ua7a6") + this.handle.getTag() + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2\ua7e0\ua4ba\ua063\ua945\u7d7b\u8e4f\u246e\u8b3f\u3478v\ua7a6\ua4bd\ua070\ua90b\u7d72\u8e46\u247f\u8b77") + this.handle + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("<"));
            }
            return n;
        }

        @Override
        public void setOpcode(int n) {
            int n2 = MemberRef.tagFromOpcode(n);
            if (n2 == 0) {
                throw new MixinTransformerError(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b38\u3467q\ua7e9\ua4b1\ua074\ua945") + Bytecode.getOpcodeName(n) + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2\ua7e0\ua4ba\ua063\ua945\u7d7b\u8e4f\u246e\u8b3f\u3478v\ua7a6\ua4bd\ua070\ua90b\u7d72\u8e46\u247f\u8b77") + this.handle + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("<"));
            }
            int n3 = n2 == (0xF041E53C ^ 0xF041E535) ? 0x587DDD4 ^ 0x587DDD5 : 0xB0ED3629 ^ 0xB0ED3629;
            this.handle = new org.spongepowered.asm.lib.Handle(n2, this.handle.getOwner(), this.handle.getName(), this.handle.getDesc(), n3 != 0);
        }

        @Override
        public String getOwner() {
            return this.handle.getOwner();
        }

        @Override
        public void setOwner(String string) {
            int n = this.handle.getTag() == (0x66A3D10D ^ 0x66A3D104) ? 0xB0D12F28 ^ 0xB0D12F29 : 0x30F47D7B ^ 0x30F47D7B;
            this.handle = new org.spongepowered.asm.lib.Handle(this.handle.getTag(), string, this.handle.getName(), this.handle.getDesc(), n != 0);
        }

        @Override
        public String getName() {
            return this.handle.getName();
        }

        @Override
        public void setName(String string) {
            int n = this.handle.getTag() == (0xAAE8A85C ^ 0xAAE8A855) ? 0x1868C686 ^ 0x1868C687 : 0xDBF8FA53 ^ 0xDBF8FA53;
            this.handle = new org.spongepowered.asm.lib.Handle(this.handle.getTag(), this.handle.getOwner(), string, this.handle.getDesc(), n != 0);
        }

        @Override
        public String getDesc() {
            return this.handle.getDesc();
        }

        @Override
        public void setDesc(String string) {
            int n = this.handle.getTag() == (0x59A7DD50 ^ 0x59A7DD59) ? 0x688B27A3 ^ 0x688B27A2 : 0x1692A91D ^ 0x1692A91D;
            this.handle = new org.spongepowered.asm.lib.Handle(this.handle.getTag(), this.handle.getOwner(), this.handle.getName(), string, n != 0);
        }
    }

    public static final class Field
    extends MemberRef {
        private static final int OPCODES = 183;
        public final FieldInsnNode insn;

        public Field(FieldInsnNode fieldInsnNode) {
            this.insn = fieldInsnNode;
        }

        @Override
        public boolean isField() {
            return (0xFE116A78 ^ 0xFE116A79) != 0;
        }

        @Override
        public int getOpcode() {
            return this.insn.getOpcode();
        }

        @Override
        public void setOpcode(int n) {
            if ((n & (0x70868AE3 ^ 0x70868A54)) == 0) {
                throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b38\u3467q\ua7e9\ua4b1\ua074\ua945\u7d70\u8e45\u2468\u8b77\u3471{\ua7e3\ua4b9\ua075\ua945\u7d7f\u8e44\u2469\u8b23\u3465g\ua7e5\ua4a1\ua078\ua90a\u7d78\u8e10\u243a\u8b67\u346f") + Integer.toHexString(n));
            }
            this.insn.setOpcode(n);
        }

        @Override
        public String getOwner() {
            return this.insn.owner;
        }

        @Override
        public void setOwner(String string) {
            this.insn.owner = string;
        }

        @Override
        public String getName() {
            return this.insn.name;
        }

        @Override
        public void setName(String string) {
            this.insn.name = string;
        }

        @Override
        public String getDesc() {
            return this.insn.desc;
        }

        @Override
        public void setDesc(String string) {
            this.insn.desc = string;
        }
    }

    public static final class Method
    extends MemberRef {
        private static final int OPCODES = 191;
        public final MethodInsnNode insn;

        public Method(MethodInsnNode methodInsnNode) {
            this.insn = methodInsnNode;
        }

        @Override
        public boolean isField() {
            return (0x2869C1A9 ^ 0x2869C1A9) != 0;
        }

        @Override
        public int getOpcode() {
            return this.insn.getOpcode();
        }

        @Override
        public void setOpcode(int n) {
            if ((n & (0x771D8D5D ^ 0x771D8DE2)) == 0) {
                throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b38\u3467q\ua7e9\ua4b1\ua074\ua945\u7d70\u8e45\u2468\u8b77\u347aw\ua7f2\ua4bd\ua07e\ua901\u7d36\u8e43\u2474\u8b24\u3463`\ua7f3\ua4b6\ua065\ua90c\u7d79\u8e44\u2420\u8b77\u3427j") + Integer.toHexString(n));
            }
            this.insn.setOpcode(n);
        }

        @Override
        public String getOwner() {
            return this.insn.owner;
        }

        @Override
        public void setOwner(String string) {
            this.insn.owner = string;
        }

        @Override
        public String getName() {
            return this.insn.name;
        }

        @Override
        public void setName(String string) {
            this.insn.name = string;
        }

        @Override
        public String getDesc() {
            return this.insn.desc;
        }

        @Override
        public void setDesc(String string) {
            this.insn.desc = string;
        }
    }
}

