/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.lib.tree.FieldInsnNode;
import org.spongepowered.asm.lib.tree.FieldNode;
import org.spongepowered.asm.lib.tree.FrameNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.gen.Invoker;
import org.spongepowered.asm.mixin.transformer.MethodMapper;
import org.spongepowered.asm.mixin.transformer.MixinInfo;
import org.spongepowered.asm.service.MixinService;
import org.spongepowered.asm.util.Annotations;
import org.spongepowered.asm.util.ClassSignature;
import org.spongepowered.asm.util.perf.Profiler;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2;

public final class ClassInfo {
    public static final int INCLUDE_PRIVATE = 2;
    public static final int INCLUDE_STATIC = 8;
    public static final int INCLUDE_ALL = 10;
    private static final Logger logger = LogManager.getLogger((String)\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("\u007f\ua7ef\ua4ad\ua078\ua90b"));
    private static final Profiler profiler = MixinEnvironment.getProfiler();
    private static final String JAVA_LANG_OBJECT = "java/lang/Object";
    private static final Map<String, ClassInfo> cache = new HashMap<String, ClassInfo>();
    private static final ClassInfo OBJECT = new ClassInfo();
    private final String name;
    private final String superName;
    private final String outerName;
    private final boolean isProbablyStatic;
    private final Set<String> interfaces;
    private final Set<Method> methods;
    private final Set<Field> fields;
    private final Set<MixinInfo> mixins = new HashSet<MixinInfo>();
    private final Map<ClassInfo, ClassInfo> correspondingTypes = new HashMap<ClassInfo, ClassInfo>();
    private final MixinInfo mixin;
    private final MethodMapper methodMapper;
    private final boolean isMixin;
    private final boolean isInterface;
    private final int access;
    private ClassInfo superClass;
    private ClassInfo outerClass;
    private ClassSignature signature;

    private ClassInfo() {
        this.name = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438]\ua7e4\ua4bf\ua074\ua906\u7d62");
        this.superName = null;
        this.outerName = null;
        this.isProbablyStatic = 0x8AEE72F0 ^ 0x8AEE72F1;
        Object[] objectArray = new Method[0xA1F9BD9 ^ 0xA1F9BDC];
        objectArray[0x8CC8D5C6 ^ 0x8CC8D5C6] = new Method(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("|\ua7e9\ua4a1\ua078\ua903\u7d6f\u8e6b\u2476\u8b3b"), \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b(":\ua7af\ua483"));
        objectArray[0x160E3C70 ^ 0x160E3C71] = new Method(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("e\ua7e7\ua4bc\ua065"), \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b(":\ua7cc\ua4fc\ua047"));
        objectArray[0xE07F98A6 ^ 0xE07F98A4] = new Method(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("e\ua7e7\ua4bc\ua065"), \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b(":\ua7cc\ua49c\ua038\ua933"));
        objectArray[0xB26C2123 ^ 0xB26C2120] = new Method(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("e\ua7e7\ua4bc\ua065"), \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b(":\ua7af\ua483"));
        objectArray[0x9D1C704D ^ 0x9D1C7049] = new Method(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("t\ua7ef\ua4bb\ua070\ua909\u7d7f\u8e50\u247f"), \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b(":\ua7af\ua483"));
        this.methods = ImmutableSet.of((Object)new Method(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("u\ua7e3\ua4a1\ua052\ua909\u7d77\u8e59\u2469"), \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b(":\ua7af\ua499\ua07b\ua904\u7d60\u8e4b\u2435\u8b3b\u3476|\ua7e1\ua4fa\ua052\ua909\u7d77\u8e59\u2469\u8b6c")), (Object)new Method(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("z\ua7e7\ua4a6\ua079\ua926\u7d79\u8e4e\u247f"), \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b(":\ua7af\ua49c")), (Object)new Method(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("w\ua7f7\ua4a0\ua070\ua909\u7d65"), \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b(":\ua7ca\ua4bf\ua070\ua913\u7d77\u8e05\u2476\u8b36\u3479u\ua7a9\ua49a\ua073\ua90f\u7d73\u8e49\u246e\u8b6c\u343eH")), (Object)new Method(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("q\ua7ea\ua4ba\ua07f\ua900"), \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b(":\ua7af\ua499\ua07b\ua904\u7d60\u8e4b\u2435\u8b3b\u3476|\ua7e1\ua4fa\ua05e\ua907\u7d7c\u8e4f\u2479\u8b23\u342c")), (Object)new Method(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("f\ua7e9\ua486\ua065\ua917\u7d7f\u8e44\u247d"), \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b(":\ua7af\ua499\ua07b\ua904\u7d60\u8e4b\u2435\u8b3b\u3476|\ua7e1\ua4fa\ua042\ua911\u7d64\u8e43\u2474\u8b30\u342c")), (Object)new Method(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("|\ua7e9\ua4a1\ua078\ua903\u7d6f"), \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b(":\ua7af\ua483")), (Object[])objectArray);
        this.fields = Collections.emptySet();
        this.isInterface = 0x435548D8 ^ 0x435548D8;
        this.interfaces = Collections.emptySet();
        this.access = 0x537D806C ^ 0x537D806D;
        this.isMixin = 0x42295B81 ^ 0x42295B81;
        this.mixin = null;
        this.methodMapper = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private ClassInfo(ClassNode classNode) {
        Profiler.Section section = profiler.begin(0xEC4C8AE4 ^ 0xEC4C8AE5, \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("q\ua7ea\ua4b4\ua062\ua916\u7d38\u8e47\u247f\u8b23\u3476"));
        try {
            void var4_7;
            this.name = classNode.name;
            this.superName = classNode.superName != null ? classNode.superName : \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438]\ua7e4\ua4bf\ua074\ua906\u7d62");
            this.methods = new HashSet<Method>();
            this.fields = new HashSet<Field>();
            this.isInterface = (classNode.access & (0xD2B2C846 ^ 0xD2B2CA46)) != 0 ? 0x65F4B33C ^ 0x65F4B33D : 0xCCFF42CF ^ 0xCCFF42CF;
            this.interfaces = new HashSet<String>();
            this.access = classNode.access;
            this.isMixin = classNode instanceof MixinInfo.MixinClassNode;
            this.mixin = this.isMixin ? ((MixinInfo.MixinClassNode)classNode).getMixin() : null;
            this.interfaces.addAll(classNode.interfaces);
            for (MethodNode object2 : classNode.methods) {
                this.addMethod(object2, this.isMixin);
            }
            int n = 0xFBBCFC68 ^ 0xFBBCFC69;
            String string = classNode.outerClass;
            for (FieldNode fieldNode : classNode.fields) {
                if ((fieldNode.access & (0xB7FF8BC6 ^ 0xB7FF9BC6)) != 0 && fieldNode.name.startsWith(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("f\ua7ee\ua4bc\ua062\ua941"))) {
                    String string2;
                    n = 0x836F04EA ^ 0x836F04EA;
                    if (var4_7 == null && (string2 = fieldNode.desc) != null && string2.startsWith(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("^"))) {
                        String string3 = string2.substring(0x2BFD83D5 ^ 0x2BFD83D4, string2.length() - (0xD2EAA4DE ^ 0xD2EAA4DF));
                    }
                }
                this.fields.add(new Field(fieldNode, this.isMixin));
            }
            this.isProbablyStatic = n;
            this.outerName = var4_7;
            this.methodMapper = new MethodMapper(MixinEnvironment.getCurrentEnvironment(), this);
            this.signature = ClassSignature.ofLazy(classNode);
        }
        finally {
            section.end();
        }
    }

    void addInterface(String string) {
        this.interfaces.add(string);
        this.getSignature().addInterface(string);
    }

    void addMethod(MethodNode methodNode) {
        this.addMethod(methodNode, (0x5E5B23C1 ^ 0x5E5B23C0) != 0);
    }

    private void addMethod(MethodNode methodNode, boolean bl) {
        if (!methodNode.name.startsWith(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("."))) {
            this.methods.add(new Method(methodNode, bl));
        }
    }

    void addMixin(MixinInfo mixinInfo) {
        if (this.isMixin) {
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("Q\ua7e7\ua4bb\ua07f\ua90a\u7d62\u8e0a\u247b\u8b33\u34732\ua7f2\ua4b4\ua063\ua902\u7d73\u8e5e\u243a") + this.name + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2\ua7e0\ua4ba\ua063\ua945") + mixinInfo.getClassName() + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2\ua7e4\ua4b0\ua072\ua904\u7d63\u8e59\u247f\u8b77\u3463z\ua7e3\ua4f5\ua065\ua904\u7d64\u8e4d\u247f\u8b23\u3437{\ua7f5\ua4f5\ua070\ua945\u7d7b\u8e43\u2462\u8b3e\u3479"));
        }
        this.mixins.add(mixinInfo);
    }

    public Set<MixinInfo> getMixins() {
        return Collections.unmodifiableSet(this.mixins);
    }

    public boolean isMixin() {
        return this.isMixin;
    }

    public boolean isPublic() {
        return ((this.access & (0xA0F4A4B6 ^ 0xA0F4A4B7)) != 0 ? 0x1BDF9D66 ^ 0x1BDF9D67 : 0x305C97C5 ^ 0x305C97C5) != 0;
    }

    public boolean isAbstract() {
        return ((this.access & (0x367C4E48 ^ 0x367C4A48)) != 0 ? 0x6BB9A967 ^ 0x6BB9A966 : 0x1E9E44F5 ^ 0x1E9E44F5) != 0;
    }

    public boolean isSynthetic() {
        return ((this.access & (0x377B2F13 ^ 0x377B3F13)) != 0 ? 0xFC1CF9 ^ 0xFC1CF8 : 0x4D41B640 ^ 0x4D41B640) != 0;
    }

    public boolean isProbablyStatic() {
        return this.isProbablyStatic;
    }

    public boolean isInner() {
        return (this.outerName != null ? 0x4596C918 ^ 0x4596C919 : 0x2E9D7E56 ^ 0x2E9D7E56) != 0;
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public Set<String> getInterfaces() {
        return Collections.unmodifiableSet(this.interfaces);
    }

    public String toString() {
        return this.name;
    }

    public MethodMapper getMethodMapper() {
        return this.methodMapper;
    }

    public int getAccess() {
        return this.access;
    }

    public String getName() {
        return this.name;
    }

    public String getClassName() {
        return this.name.replace((char)(0xFF8B1729 ^ 0xFF8B1706), (char)(0x372BBA51 ^ 0x372BBA7F));
    }

    public String getSuperName() {
        return this.superName;
    }

    public ClassInfo getSuperClass() {
        if (this.superClass == null && this.superName != null) {
            this.superClass = ClassInfo.forName(this.superName);
        }
        return this.superClass;
    }

    public String getOuterName() {
        return this.outerName;
    }

    public ClassInfo getOuterClass() {
        if (this.outerClass == null && this.outerName != null) {
            this.outerClass = ClassInfo.forName(this.outerName);
        }
        return this.outerClass;
    }

    public ClassSignature getSignature() {
        return this.signature.wake();
    }

    List<ClassInfo> getTargets() {
        if (this.mixin != null) {
            ArrayList<ClassInfo> arrayList = new ArrayList<ClassInfo>();
            arrayList.add(this);
            arrayList.addAll(this.mixin.getTargets());
            return arrayList;
        }
        return ImmutableList.of((Object)this);
    }

    public Set<Method> getMethods() {
        return Collections.unmodifiableSet(this.methods);
    }

    public Set<Method> getInterfaceMethods(boolean bl) {
        HashSet<Method> hashSet = new HashSet<Method>();
        if (!this.isInterface) {
            for (ClassInfo classInfo = this.addMethodsRecursive(hashSet, bl); classInfo != null && classInfo != OBJECT; classInfo = classInfo.addMethodsRecursive(hashSet, bl)) {
            }
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            if (((Method)iterator.next()).isAbstract()) continue;
            iterator.remove();
        }
        return Collections.unmodifiableSet(hashSet);
    }

    private ClassInfo addMethodsRecursive(Set<Method> set, boolean bl) {
        if (this.isInterface) {
            for (Method object : this.methods) {
                if (!object.isAbstract()) {
                    set.remove(object);
                }
                set.add(object);
            }
        } else if (!this.isMixin && bl) {
            for (MixinInfo mixinInfo : this.mixins) {
                mixinInfo.getClassInfo().addMethodsRecursive(set, bl);
            }
        }
        for (String string : this.interfaces) {
            ClassInfo.forName(string).addMethodsRecursive(set, bl);
        }
        return this.getSuperClass();
    }

    public boolean hasSuperClass(String string) {
        return this.hasSuperClass(string, Traversal.NONE);
    }

    public boolean hasSuperClass(String string, Traversal traversal) {
        if (\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438]\ua7e4\ua4bf\ua074\ua906\u7d62").equals(string)) {
            return (0xB343CDDB ^ 0xB343CDDA) != 0;
        }
        return (this.findSuperClass(string, traversal) != null ? 0xFBE56DE ^ 0xFBE56DF : 0x82C718F4 ^ 0x82C718F4) != 0;
    }

    public boolean hasSuperClass(ClassInfo classInfo) {
        return this.hasSuperClass(classInfo, Traversal.NONE, (0x1215C727 ^ 0x1215C727) != 0);
    }

    public boolean hasSuperClass(ClassInfo classInfo, Traversal traversal) {
        return this.hasSuperClass(classInfo, traversal, (0xF057D3C3 ^ 0xF057D3C3) != 0);
    }

    public boolean hasSuperClass(ClassInfo classInfo, Traversal traversal, boolean bl) {
        if (OBJECT == classInfo) {
            return (0x5B422FD8 ^ 0x5B422FD9) != 0;
        }
        return (this.findSuperClass(classInfo.name, traversal, bl) != null ? 0x286B31B5 ^ 0x286B31B4 : 0x183B800B ^ 0x183B800B) != 0;
    }

    public ClassInfo findSuperClass(String string) {
        return this.findSuperClass(string, Traversal.NONE);
    }

    public ClassInfo findSuperClass(String string, Traversal traversal) {
        return this.findSuperClass(string, traversal, (0xB2D1CF16 ^ 0xB2D1CF16) != 0, new HashSet<String>());
    }

    public ClassInfo findSuperClass(String string, Traversal traversal, boolean bl) {
        if (ClassInfo.OBJECT.name.equals(string)) {
            return null;
        }
        return this.findSuperClass(string, traversal, bl, new HashSet<String>());
    }

    private ClassInfo findSuperClass(String string, Traversal traversal, boolean bl, Set<String> set) {
        Object object;
        Iterator<MixinInfo> iterator;
        ClassInfo classInfo = this.getSuperClass();
        if (classInfo != null) {
            iterator = classInfo.getTargets().iterator();
            while (iterator.hasNext()) {
                ClassInfo object2 = (ClassInfo)iterator.next();
                if (string.equals(object2.getName())) {
                    return classInfo;
                }
                object = object2.findSuperClass(string, traversal.next(), bl, set);
                if (object == null) continue;
                return object;
            }
        }
        if (bl && (iterator = this.findInterface(string)) != null) {
            return iterator;
        }
        if (traversal.canTraverse()) {
            for (MixinInfo mixinInfo : this.mixins) {
                object = mixinInfo.getClassName();
                if (set.contains(object)) continue;
                set.add((String)object);
                ClassInfo classInfo2 = mixinInfo.getClassInfo();
                if (string.equals(classInfo2.getName())) {
                    return classInfo2;
                }
                ClassInfo classInfo3 = classInfo2.findSuperClass(string, Traversal.ALL, bl, set);
                if (classInfo3 == null) continue;
                return classInfo3;
            }
        }
        return null;
    }

    private ClassInfo findInterface(String string) {
        for (String string2 : this.getInterfaces()) {
            ClassInfo classInfo = ClassInfo.forName(string2);
            if (string.equals(string2)) {
                return classInfo;
            }
            ClassInfo classInfo2 = classInfo.findInterface(string);
            if (classInfo2 == null) continue;
            return classInfo2;
        }
        return null;
    }

    ClassInfo findCorrespondingType(ClassInfo classInfo) {
        if (classInfo == null || !classInfo.isMixin || this.isMixin) {
            return null;
        }
        ClassInfo classInfo2 = this.correspondingTypes.get(classInfo);
        if (classInfo2 == null) {
            classInfo2 = this.findSuperTypeForMixin(classInfo);
            this.correspondingTypes.put(classInfo, classInfo2);
        }
        return classInfo2;
    }

    private ClassInfo findSuperTypeForMixin(ClassInfo classInfo) {
        for (ClassInfo classInfo2 = this; classInfo2 != null && classInfo2 != OBJECT; classInfo2 = classInfo2.getSuperClass()) {
            for (MixinInfo mixinInfo : classInfo2.mixins) {
                if (!mixinInfo.getClassInfo().equals(classInfo)) continue;
                return classInfo2;
            }
        }
        return null;
    }

    public boolean hasMixinInHierarchy() {
        if (!this.isMixin) {
            return (0xFCA6B457 ^ 0xFCA6B457) != 0;
        }
        for (ClassInfo classInfo = this.getSuperClass(); classInfo != null && classInfo != OBJECT; classInfo = classInfo.getSuperClass()) {
            if (!classInfo.isMixin) continue;
            return (0x4E58AFFD ^ 0x4E58AFFC) != 0;
        }
        return (0x1AFA0626 ^ 0x1AFA0626) != 0;
    }

    public boolean hasMixinTargetInHierarchy() {
        if (this.isMixin) {
            return (0x652BA949 ^ 0x652BA949) != 0;
        }
        for (ClassInfo classInfo = this.getSuperClass(); classInfo != null && classInfo != OBJECT; classInfo = classInfo.getSuperClass()) {
            if (classInfo.mixins.size() <= 0) continue;
            return (0x822F5453 ^ 0x822F5452) != 0;
        }
        return (0x7FCCADFD ^ 0x7FCCADFD) != 0;
    }

    public Method findMethodInHierarchy(MethodNode methodNode, SearchType searchType) {
        return this.findMethodInHierarchy(methodNode.name, methodNode.desc, searchType, Traversal.NONE);
    }

    public Method findMethodInHierarchy(MethodNode methodNode, SearchType searchType, int n) {
        return this.findMethodInHierarchy(methodNode.name, methodNode.desc, searchType, Traversal.NONE, n);
    }

    public Method findMethodInHierarchy(MethodInsnNode methodInsnNode, SearchType searchType) {
        return this.findMethodInHierarchy(methodInsnNode.name, methodInsnNode.desc, searchType, Traversal.NONE);
    }

    public Method findMethodInHierarchy(MethodInsnNode methodInsnNode, SearchType searchType, int n) {
        return this.findMethodInHierarchy(methodInsnNode.name, methodInsnNode.desc, searchType, Traversal.NONE, n);
    }

    public Method findMethodInHierarchy(String string, String string2, SearchType searchType) {
        return this.findMethodInHierarchy(string, string2, searchType, Traversal.NONE);
    }

    public Method findMethodInHierarchy(String string, String string2, SearchType searchType, Traversal traversal) {
        return this.findMethodInHierarchy(string, string2, searchType, traversal, 0xA1453063 ^ 0xA1453063);
    }

    public Method findMethodInHierarchy(String string, String string2, SearchType searchType, Traversal traversal, int n) {
        return (Method)this.findInHierarchy(string, string2, searchType, traversal, n, Member.Type.METHOD);
    }

    public Field findFieldInHierarchy(FieldNode fieldNode, SearchType searchType) {
        return this.findFieldInHierarchy(fieldNode.name, fieldNode.desc, searchType, Traversal.NONE);
    }

    public Field findFieldInHierarchy(FieldNode fieldNode, SearchType searchType, int n) {
        return this.findFieldInHierarchy(fieldNode.name, fieldNode.desc, searchType, Traversal.NONE, n);
    }

    public Field findFieldInHierarchy(FieldInsnNode fieldInsnNode, SearchType searchType) {
        return this.findFieldInHierarchy(fieldInsnNode.name, fieldInsnNode.desc, searchType, Traversal.NONE);
    }

    public Field findFieldInHierarchy(FieldInsnNode fieldInsnNode, SearchType searchType, int n) {
        return this.findFieldInHierarchy(fieldInsnNode.name, fieldInsnNode.desc, searchType, Traversal.NONE, n);
    }

    public Field findFieldInHierarchy(String string, String string2, SearchType searchType) {
        return this.findFieldInHierarchy(string, string2, searchType, Traversal.NONE);
    }

    public Field findFieldInHierarchy(String string, String string2, SearchType searchType, Traversal traversal) {
        return this.findFieldInHierarchy(string, string2, searchType, traversal, 0x54751AB6 ^ 0x54751AB6);
    }

    public Field findFieldInHierarchy(String string, String string2, SearchType searchType, Traversal traversal, int n) {
        return (Field)this.findInHierarchy(string, string2, searchType, traversal, n, Member.Type.FIELD);
    }

    private <M extends Member> M findInHierarchy(String string, String string2, SearchType searchType, Traversal traversal, int n, Member.Type type) {
        ClassInfo classInfo;
        ClassInfo classInfo2;
        if (searchType == SearchType.ALL_CLASSES) {
            classInfo2 = this.findMember(string, string2, n, type);
            if (classInfo2 != null) {
                return (M)classInfo2;
            }
            if (traversal.canTraverse()) {
                for (MixinInfo object : this.mixins) {
                    classInfo = object.getClassInfo().findMember(string, string2, n, type);
                    if (classInfo == null) continue;
                    return (M)this.cloneMember(classInfo);
                }
            }
        }
        if ((classInfo2 = this.getSuperClass()) != null) {
            for (ClassInfo classInfo3 : classInfo2.getTargets()) {
                classInfo = classInfo3.findInHierarchy(string, string2, SearchType.ALL_CLASSES, traversal.next(), n & (0xE424E010 ^ 0x1BDB1FED), type);
                if (classInfo == null) continue;
                return (M)classInfo;
            }
        }
        if (type == Member.Type.METHOD && (this.isInterface || MixinEnvironment.getCompatibilityLevel().supportsMethodsInInterfaces())) {
            for (String string3 : this.interfaces) {
                classInfo = ClassInfo.forName(string3);
                if (classInfo == null) {
                    Object[] objectArray = new Object[0x3250ADD3 ^ 0x3250ADD1];
                    objectArray[0xFC7DA684 ^ 0xFC7DA684] = string3;
                    objectArray[0x6580106D ^ 0x6580106C] = this.name;
                    logger.debug(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("T\ua7e7\ua4bc\ua07d\ua900\u7d72\u8e0a\u246e\u8b38\u3437`\ua7e3\ua4a6\ua07e\ua909\u7d60\u8e4f\u243a\u8b33\u3472q\ua7ea\ua4b4\ua063\ua900\u7d72\u8e0a\u2473\u8b39\u3463w\ua7f4\ua4b3\ua070\ua906\u7d73\u8e0a\u2461\u8b2a\u3437}\ua7e8\ua4f5\ua06a\ua918"), objectArray);
                    continue;
                }
                M m = classInfo.findInHierarchy(string, string2, SearchType.ALL_CLASSES, traversal.next(), n & (0x31ED0AEB ^ 0xCE12F516), type);
                if (m == null) continue;
                return (M)(this.isInterface ? m : new InterfaceMethod((Member)m));
            }
        }
        return null;
    }

    private <M extends Member> M cloneMember(M m) {
        if (m instanceof Method) {
            return (M)new Method(m);
        }
        return (M)new Field(m);
    }

    public Method findMethod(MethodNode methodNode) {
        return this.findMethod(methodNode.name, methodNode.desc, methodNode.access);
    }

    public Method findMethod(MethodNode methodNode, int n) {
        return this.findMethod(methodNode.name, methodNode.desc, n);
    }

    public Method findMethod(MethodInsnNode methodInsnNode) {
        return this.findMethod(methodInsnNode.name, methodInsnNode.desc, 0xD54E148F ^ 0xD54E148F);
    }

    public Method findMethod(MethodInsnNode methodInsnNode, int n) {
        return this.findMethod(methodInsnNode.name, methodInsnNode.desc, n);
    }

    public Method findMethod(String string, String string2, int n) {
        return (Method)this.findMember(string, string2, n, Member.Type.METHOD);
    }

    public Field findField(FieldNode fieldNode) {
        return this.findField(fieldNode.name, fieldNode.desc, fieldNode.access);
    }

    public Field findField(FieldInsnNode fieldInsnNode, int n) {
        return this.findField(fieldInsnNode.name, fieldInsnNode.desc, n);
    }

    public Field findField(String string, String string2, int n) {
        return (Field)this.findMember(string, string2, n, Member.Type.FIELD);
    }

    private <M extends Member> M findMember(String string, String string2, int n, Member.Type type) {
        Set<Member> set = type == Member.Type.METHOD ? this.methods : this.fields;
        for (Member member : set) {
            if (!member.equals(string, string2) || !member.matchesFlags(n)) continue;
            return (M)member;
        }
        return null;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ClassInfo)) {
            return (0x6A30F56D ^ 0x6A30F56D) != 0;
        }
        return ((ClassInfo)object).name.equals(this.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    static ClassInfo fromClassNode(ClassNode classNode) {
        ClassInfo classInfo = cache.get(classNode.name);
        if (classInfo == null) {
            classInfo = new ClassInfo(classNode);
            cache.put(classNode.name, classInfo);
        }
        return classInfo;
    }

    public static ClassInfo forName(String string) {
        ClassInfo classInfo = cache.get(string = string.replace((char)(0x52FAA4D7 ^ 0x52FAA4F9), (char)(0x68C89150 ^ 0x68C8917F)));
        if (classInfo == null) {
            try {
                ClassNode classNode = MixinService.getService().getBytecodeProvider().getClassNode(string);
                classInfo = new ClassInfo(classNode);
            }
            catch (Exception exception) {
                logger.catching(Level.TRACE, (Throwable)exception);
                Object[] objectArray = new Object[0xDFDF7030 ^ 0xDFDF7033];
                objectArray[0xCC5F9B5D ^ 0xCC5F9B5D] = string;
                objectArray[0x5207D699 ^ 0x5207D698] = exception.getClass().getName();
                objectArray[0x9624B29D ^ 0x9624B29F] = exception.getMessage();
                logger.warn(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("W\ua7f4\ua4a7\ua07e\ua917\u7d36\u8e46\u2475\u8b36\u3473{\ua7e8\ua4b2\ua031\ua906\u7d7a\u8e4b\u2469\u8b24\u342d2\ua7fd\ua4a8\ua031\ua94d\u7d6d\u8e57\u2420\u8b77\u346co\ua7af"), objectArray);
            }
            cache.put(string, classInfo);
            Object[] objectArray = new Object[0x4CB0B91D ^ 0x4CB0B91C];
            objectArray[0x113CD17D ^ 0x113CD17D] = string;
            logger.trace(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("S\ua7e2\ua4b1\ua074\ua901\u7d36\u8e49\u2476\u8b36\u3464a\ua7a6\ua4b8\ua074\ua911\u7d77\u8e4e\u247b\u8b23\u34762\ua7e0\ua4ba\ua063\ua945\u7d6d\u8e57\u243a\u8b23\u34782\ua7eb\ua4b0\ua065\ua904\u7d72\u8e4b\u246e\u8b36\u3437q\ua7e7\ua4b6\ua079\ua900"), objectArray);
        }
        return classInfo;
    }

    public static ClassInfo forType(Type type) {
        if (type.getSort() == (0x92D17515 ^ 0x92D1751C)) {
            return ClassInfo.forType(type.getElementType());
        }
        if (type.getSort() < (0xC89CBEDC ^ 0xC89CBED5)) {
            return null;
        }
        return ClassInfo.forName(type.getClassName().replace((char)(0x6392FDBF ^ 0x6392FD91), (char)(0x721ABC99 ^ 0x721ABCB6)));
    }

    public static ClassInfo getCommonSuperClass(String string, String string2) {
        if (string == null || string2 == null) {
            return OBJECT;
        }
        return ClassInfo.getCommonSuperClass(ClassInfo.forName(string), ClassInfo.forName(string2));
    }

    public static ClassInfo getCommonSuperClass(Type type, Type type2) {
        block3: {
            block2: {
                if (type == null || type2 == null) break block2;
                if (type.getSort() != (0x3E27B152 ^ 0x3E27B158)) break block2;
                if (type2.getSort() == (0x71EDB22 ^ 0x71EDB28)) break block3;
            }
            return OBJECT;
        }
        return ClassInfo.getCommonSuperClass(ClassInfo.forType(type), ClassInfo.forType(type2));
    }

    private static ClassInfo getCommonSuperClass(ClassInfo classInfo, ClassInfo classInfo2) {
        return ClassInfo.getCommonSuperClass(classInfo, classInfo2, (0x98EB8634 ^ 0x98EB8634) != 0);
    }

    public static ClassInfo getCommonSuperClassOrInterface(String string, String string2) {
        if (string == null || string2 == null) {
            return OBJECT;
        }
        return ClassInfo.getCommonSuperClassOrInterface(ClassInfo.forName(string), ClassInfo.forName(string2));
    }

    public static ClassInfo getCommonSuperClassOrInterface(Type type, Type type2) {
        block3: {
            block2: {
                if (type == null || type2 == null) break block2;
                if (type.getSort() != (0xAF4D5ADD ^ 0xAF4D5AD7)) break block2;
                if (type2.getSort() == (0xC428544B ^ 0xC4285441)) break block3;
            }
            return OBJECT;
        }
        return ClassInfo.getCommonSuperClassOrInterface(ClassInfo.forType(type), ClassInfo.forType(type2));
    }

    public static ClassInfo getCommonSuperClassOrInterface(ClassInfo classInfo, ClassInfo classInfo2) {
        return ClassInfo.getCommonSuperClass(classInfo, classInfo2, (0x76D9D3B2 ^ 0x76D9D3B3) != 0);
    }

    private static ClassInfo getCommonSuperClass(ClassInfo classInfo, ClassInfo classInfo2, boolean bl) {
        if (classInfo.hasSuperClass(classInfo2, Traversal.NONE, bl)) {
            return classInfo2;
        }
        if (classInfo2.hasSuperClass(classInfo, Traversal.NONE, bl)) {
            return classInfo;
        }
        if (classInfo.isInterface() || classInfo2.isInterface()) {
            return OBJECT;
        }
        do {
            if ((classInfo = classInfo.getSuperClass()) != null) continue;
            return OBJECT;
        } while (!classInfo2.hasSuperClass(classInfo, Traversal.NONE, bl));
        return classInfo;
    }

    static {
        cache.put(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438]\ua7e4\ua4bf\ua074\ua906\u7d62"), OBJECT);
    }

    class Field
    extends Member {
        public Field(Member member) {
            super(member);
        }

        public Field(FieldNode fieldNode) {
            this(fieldNode, (0xCC62FA34 ^ 0xCC62FA34) != 0);
        }

        public Field(FieldNode fieldNode, boolean bl) {
            super(Member.Type.FIELD, fieldNode.name, fieldNode.desc, fieldNode.access, bl);
            this.setUnique((Annotations.getVisible(fieldNode, Unique.class) != null ? 0xC2B972F9 ^ 0xC2B972F8 : 0x4E5DA734 ^ 0x4E5DA734) != 0);
            if (Annotations.getVisible(fieldNode, Shadow.class) != null) {
                int n;
                int n2 = Annotations.getVisible(fieldNode, Final.class) != null ? 0x3E41CA24 ^ 0x3E41CA25 : (n = 0x601DE7A3 ^ 0x601DE7A3);
                int n3 = Annotations.getVisible(fieldNode, Mutable.class) != null ? 0x96747FF3 ^ 0x96747FF2 : 0x2CF7268E ^ 0x2CF7268E;
                this.setDecoratedFinal(n != 0, n3 != 0);
            }
        }

        public Field(String string, String string2, int n) {
            super(Member.Type.FIELD, string, string2, n, (0x8313C740 ^ 0x8313C740) != 0);
        }

        public Field(String string, String string2, int n, boolean bl) {
            super(Member.Type.FIELD, string, string2, n, bl);
        }

        @Override
        public ClassInfo getOwner() {
            return ClassInfo.this;
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof Field)) {
                return (0xFB97DD6A ^ 0xFB97DD6A) != 0;
            }
            return super.equals(object);
        }

        @Override
        protected String getDisplayFormat() {
            return \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("7\ua7f5\ua4ef\ua034\ua916");
        }
    }

    public class InterfaceMethod
    extends Method {
        private final ClassInfo owner;

        public InterfaceMethod(Member member) {
            super(member);
            this.owner = member.getOwner();
        }

        @Override
        public ClassInfo getOwner() {
            return this.owner;
        }

        @Override
        public ClassInfo getImplementor() {
            return ClassInfo.this;
        }
    }

    public class Method
    extends Member {
        private final List<FrameData> frames;
        private boolean isAccessor;

        public Method(Member member) {
            super(member);
            this.frames = member instanceof Method ? ((Method)member).frames : null;
        }

        public Method(MethodNode methodNode) {
            this(methodNode, (0xCE9B1907 ^ 0xCE9B1907) != 0);
            this.setUnique((Annotations.getVisible(methodNode, Unique.class) != null ? 0x1D080563 ^ 0x1D080562 : 0x72E3E26E ^ 0x72E3E26E) != 0);
            Class[] classArray = new Class[0x4529DEB8 ^ 0x4529DEBA];
            classArray[0xD72A1B95 ^ 0xD72A1B95] = Accessor.class;
            classArray[0xD19FA88D ^ 0xD19FA88C] = Invoker.class;
            this.isAccessor = Annotations.getSingleVisible(methodNode, classArray) != null ? 0x24588089 ^ 0x24588088 : 0xD0FEC8B4 ^ 0xD0FEC8B4;
        }

        public Method(MethodNode methodNode, boolean bl) {
            super(Member.Type.METHOD, methodNode.name, methodNode.desc, methodNode.access, bl);
            this.frames = this.gatherFrames(methodNode);
            this.setUnique((Annotations.getVisible(methodNode, Unique.class) != null ? 0x8D542138 ^ 0x8D542139 : 0x7AD2BC8E ^ 0x7AD2BC8E) != 0);
            Class[] classArray = new Class[0xDE0F7475 ^ 0xDE0F7477];
            classArray[0xB44E5346 ^ 0xB44E5346] = Accessor.class;
            classArray[0xF591B06F ^ 0xF591B06E] = Invoker.class;
            this.isAccessor = Annotations.getSingleVisible(methodNode, classArray) != null ? 0x87424336 ^ 0x87424337 : 0x76FEC1CD ^ 0x76FEC1CD;
        }

        public Method(String string, String string2) {
            super(Member.Type.METHOD, string, string2, 0x7FB24174 ^ 0x7FB24175, (0xD49C473E ^ 0xD49C473E) != 0);
            this.frames = null;
        }

        public Method(String string, String string2, int n) {
            super(Member.Type.METHOD, string, string2, n, (0x221065EF ^ 0x221065EF) != 0);
            this.frames = null;
        }

        public Method(String string, String string2, int n, boolean bl) {
            super(Member.Type.METHOD, string, string2, n, bl);
            this.frames = null;
        }

        private List<FrameData> gatherFrames(MethodNode methodNode) {
            ArrayList<FrameData> arrayList = new ArrayList<FrameData>();
            ListIterator<AbstractInsnNode> listIterator = methodNode.instructions.iterator();
            while (listIterator.hasNext()) {
                AbstractInsnNode abstractInsnNode = (AbstractInsnNode)listIterator.next();
                if (!(abstractInsnNode instanceof FrameNode)) continue;
                arrayList.add(new FrameData(methodNode.instructions.indexOf(abstractInsnNode), (FrameNode)abstractInsnNode));
            }
            return arrayList;
        }

        public List<FrameData> getFrames() {
            return this.frames;
        }

        @Override
        public ClassInfo getOwner() {
            return ClassInfo.this;
        }

        public boolean isAccessor() {
            return this.isAccessor;
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof Method)) {
                return (0x9349141D ^ 0x9349141D) != 0;
            }
            return super.equals(object);
        }
    }

    static abstract class Member {
        private final Type type;
        private final String memberName;
        private final String memberDesc;
        private final boolean isInjected;
        private final int modifiers;
        private String currentName;
        private String currentDesc;
        private boolean decoratedFinal;
        private boolean decoratedMutable;
        private boolean unique;

        protected Member(Member member) {
            this(member.type, member.memberName, member.memberDesc, member.modifiers, member.isInjected);
            this.currentName = member.currentName;
            this.currentDesc = member.currentDesc;
            this.unique = member.unique;
        }

        protected Member(Type type, String string, String string2, int n) {
            this(type, string, string2, n, (0x39A3A666 ^ 0x39A3A666) != 0);
        }

        protected Member(Type type, String string, String string2, int n, boolean bl) {
            this.type = type;
            this.memberName = string;
            this.memberDesc = string2;
            this.isInjected = bl;
            this.currentName = string;
            this.currentDesc = string2;
            this.modifiers = n;
        }

        public String getOriginalName() {
            return this.memberName;
        }

        public String getName() {
            return this.currentName;
        }

        public String getOriginalDesc() {
            return this.memberDesc;
        }

        public String getDesc() {
            return this.currentDesc;
        }

        public boolean isInjected() {
            return this.isInjected;
        }

        public boolean isRenamed() {
            return (!this.currentName.equals(this.memberName) ? 0x50A5DD29 ^ 0x50A5DD28 : 0x74FBC33B ^ 0x74FBC33B) != 0;
        }

        public boolean isRemapped() {
            return (!this.currentDesc.equals(this.memberDesc) ? 0x3208DFC5 ^ 0x3208DFC4 : 0x1473BCFC ^ 0x1473BCFC) != 0;
        }

        public boolean isPrivate() {
            return ((this.modifiers & (0xB7FC230B ^ 0xB7FC2309)) != 0 ? 0x65A9D00C ^ 0x65A9D00D : 0x6BBB2CA0 ^ 0x6BBB2CA0) != 0;
        }

        public boolean isStatic() {
            return ((this.modifiers & (0x7697B31 ^ 0x7697B39)) != 0 ? 0x719C04C ^ 0x719C04D : 0x8794B403 ^ 0x8794B403) != 0;
        }

        public boolean isAbstract() {
            return ((this.modifiers & (0xF3D1F7DA ^ 0xF3D1F3DA)) != 0 ? 0x36FC0AB6 ^ 0x36FC0AB7 : 0xCAD6E05D ^ 0xCAD6E05D) != 0;
        }

        public boolean isFinal() {
            return ((this.modifiers & (0x1ECC5A53 ^ 0x1ECC5A43)) != 0 ? 0xF396BA4C ^ 0xF396BA4D : 0xD8E11411 ^ 0xD8E11411) != 0;
        }

        public boolean isSynthetic() {
            return ((this.modifiers & (0x8F8B946B ^ 0x8F8B846B)) != 0 ? 0x60ADEB6E ^ 0x60ADEB6F : 0x11B2934A ^ 0x11B2934A) != 0;
        }

        public boolean isUnique() {
            return this.unique;
        }

        public void setUnique(boolean bl) {
            this.unique = bl;
        }

        public boolean isDecoratedFinal() {
            return this.decoratedFinal;
        }

        public boolean isDecoratedMutable() {
            return this.decoratedMutable;
        }

        public void setDecoratedFinal(boolean bl, boolean bl2) {
            this.decoratedFinal = bl;
            this.decoratedMutable = bl2;
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean matchesFlags(int n) {
            int n2;
            if (((this.modifiers ^ (0xE30D6782 ^ 0x1CF2987D) | n & (0x1A060BE7 ^ 0x1A060BE5)) & (0xC81A5A06 ^ 0xC81A5A04)) != 0) {
                if (((this.modifiers ^ (0x1BB3B7A7 ^ 0xE44C4858) | n & (0x6B27A0E4 ^ 0x6B27A0EC)) & (0xB0B91786 ^ 0xB0B9178E)) != 0) {
                    n2 = 0x9D5A0EC6 ^ 0x9D5A0EC7;
                    return n2 != 0;
                }
            }
            n2 = 0x9190BD50 ^ 0x9190BD50;
            return n2 != 0;
        }

        public abstract ClassInfo getOwner();

        public ClassInfo getImplementor() {
            return this.getOwner();
        }

        public int getAccess() {
            return this.modifiers;
        }

        public String renameTo(String string) {
            this.currentName = string;
            return string;
        }

        public String remapTo(String string) {
            this.currentDesc = string;
            return string;
        }

        public boolean equals(String string, String string2) {
            return ((this.memberName.equals(string) || this.currentName.equals(string)) && (this.memberDesc.equals(string2) || this.currentDesc.equals(string2)) ? 0x352CD93F ^ 0x352CD93E : 0x43BE2FCD ^ 0x43BE2FCD) != 0;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Member)) {
                return (0x74CD659C ^ 0x74CD659C) != 0;
            }
            Member member = (Member)object;
            return ((member.memberName.equals(this.memberName) || member.currentName.equals(this.currentName)) && (member.memberDesc.equals(this.memberDesc) || member.currentDesc.equals(this.currentDesc)) ? 0xF41C515 ^ 0xF41C514 : 0x19B52109 ^ 0x19B52109) != 0;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public String toString() {
            Object[] objectArray = new Object[0x87D41967 ^ 0x87D41965];
            objectArray[0x275D831C ^ 0x275D831C] = this.memberName;
            objectArray[0x9348166F ^ 0x9348166E] = this.memberDesc;
            return String.format(this.getDisplayFormat(), objectArray);
        }

        protected String getDisplayFormat() {
            return \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("7\ua7f5\ua4f0\ua062");
        }

        static final class Type
        extends Enum<Type> {
            public static final /* enum */ Type METHOD = new Type();
            public static final /* enum */ Type FIELD = new Type();
            private static final /* synthetic */ Type[] $VALUES;

            public static Type[] values() {
                return (Type[])$VALUES.clone();
            }

            public static Type valueOf(String string) {
                return Enum.valueOf(Type.class, string);
            }

            static {
                Type[] typeArray = new Type[0xC6020DF6 ^ 0xC6020DF4];
                typeArray[0x632E2D60 ^ 0x632E2D60] = METHOD;
                typeArray[0x7F877317 ^ 0x7F877316] = FIELD;
                $VALUES = typeArray;
            }
        }
    }

    public static class FrameData {
        private static final String[] FRAMETYPES;
        public final int index;
        public final int type;
        public final int locals;

        FrameData(int n, int n2, int n3) {
            this.index = n;
            this.type = n2;
            this.locals = n3;
        }

        FrameData(int n, FrameNode frameNode) {
            this.index = n;
            this.type = frameNode.type;
            this.locals = frameNode.local != null ? frameNode.local.size() : 0xE78E1707 ^ 0xE78E1707;
        }

        public String toString() {
            Object[] objectArray = new Object[0xCC3F77D7 ^ 0xCC3F77D4];
            objectArray[0xFD29B32E ^ 0xFD29B32E] = this.index;
            objectArray[0x52EBCB07 ^ 0x52EBCB06] = FRAMETYPES[this.type + (0xBAF23007 ^ 0xBAF23006)];
            objectArray[0x22D7F564 ^ 0x22D7F566] = this.locals;
            return String.format(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("T\ua7f4\ua4b4\ua07c\ua900\u7d52\u8e4b\u246e\u8b36\u344c{\ua7e8\ua4b1\ua074\ua91d\u7d2b\u8e0f\u247e\u8b7b\u3437f\ua7ff\ua4a5\ua074\ua958\u7d33\u8e59\u2436\u8b77\u347b}\ua7e5\ua4b4\ua07d\ua916\u7d2b\u8e0f\u247e\u8b0a"), objectArray);
        }

        static {
            String[] stringArray = new String[0xE62F5ED7 ^ 0xE62F5ED1];
            stringArray[0x451389D0 ^ 0x451389D0] = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("\\\ua7c3\ua482");
            stringArray[0xD00D462C ^ 0xD00D462D] = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("T\ua7d3\ua499\ua05d");
            stringArray[0xE6AC5D95 ^ 0xE6AC5D97] = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("S\ua7d6\ua485\ua054\ua92b\u7d52");
            stringArray[0x4E1B5361 ^ 0x4E1B5362] = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("Q\ua7ce\ua49a\ua041");
            stringArray[0x81A7145D ^ 0x81A71459] = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("A\ua7c7\ua498\ua054");
            stringArray[0xA6C88116 ^ 0xA6C88113] = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("A\ua7c7\ua498\ua054\ua954");
            FRAMETYPES = stringArray;
        }
    }

    public static final class Traversal
    extends Enum<Traversal> {
        public static final /* enum */ Traversal NONE = new Traversal(null, (0xDE84A3B ^ 0xDE84A3B) != 0, SearchType.SUPER_CLASSES_ONLY);
        public static final /* enum */ Traversal ALL = new Traversal(null, (0x8A2F13EA ^ 0x8A2F13EB) != 0, SearchType.ALL_CLASSES);
        public static final /* enum */ Traversal IMMEDIATE = new Traversal(NONE, (0x142E48FF ^ 0x142E48FE) != 0, SearchType.SUPER_CLASSES_ONLY);
        public static final /* enum */ Traversal SUPER = new Traversal(ALL, (0x501C2296 ^ 0x501C2296) != 0, SearchType.SUPER_CLASSES_ONLY);
        private final Traversal next;
        private final boolean traverse;
        private final SearchType searchType;
        private static final /* synthetic */ Traversal[] $VALUES;

        public static Traversal[] values() {
            return (Traversal[])$VALUES.clone();
        }

        public static Traversal valueOf(String string) {
            return Enum.valueOf(Traversal.class, string);
        }

        private Traversal(Traversal traversal, boolean bl, SearchType searchType) {
            this.next = traversal != null ? traversal : this;
            this.traverse = bl;
            this.searchType = searchType;
        }

        public Traversal next() {
            return this.next;
        }

        public boolean canTraverse() {
            return this.traverse;
        }

        public SearchType getSearchType() {
            return this.searchType;
        }

        static {
            Traversal[] traversalArray = new Traversal[0xB8A14FA7 ^ 0xB8A14FA3];
            traversalArray[0xCE26ED83 ^ 0xCE26ED83] = NONE;
            traversalArray[0x4A144B59 ^ 0x4A144B58] = ALL;
            traversalArray[0x76ED7243 ^ 0x76ED7241] = IMMEDIATE;
            traversalArray[0x39FFE3C6 ^ 0x39FFE3C5] = SUPER;
            $VALUES = traversalArray;
        }
    }

    public static final class SearchType
    extends Enum<SearchType> {
        public static final /* enum */ SearchType ALL_CLASSES = new SearchType();
        public static final /* enum */ SearchType SUPER_CLASSES_ONLY = new SearchType();
        private static final /* synthetic */ SearchType[] $VALUES;

        public static SearchType[] values() {
            return (SearchType[])$VALUES.clone();
        }

        public static SearchType valueOf(String string) {
            return Enum.valueOf(SearchType.class, string);
        }

        static {
            SearchType[] searchTypeArray = new SearchType[0x5F0790DC ^ 0x5F0790DE];
            searchTypeArray[0xB412A071 ^ 0xB412A071] = ALL_CLASSES;
            searchTypeArray[0x276F3FD4 ^ 0x276F3FD5] = SUPER_CLASSES_ONLY;
            $VALUES = searchTypeArray;
        }
    }
}

