/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer;

import java.util.HashSet;
import java.util.Set;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import org.spongepowered.asm.mixin.transformer.MixinInfo;
import org.spongepowered.asm.mixin.transformer.meta.MixinRenamed;
import org.spongepowered.asm.mixin.transformer.throwables.InvalidMixinException;
import org.spongepowered.asm.util.Annotations;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2;

public final class InterfaceInfo {
    private final MixinInfo mixin;
    private final String prefix;
    private final Type iface;
    private final boolean unique;
    private Set<String> methods;

    private InterfaceInfo(MixinInfo mixinInfo, String string, Type type, boolean bl) {
        block3: {
            block2: {
                if (string == null) break block2;
                if (string.length() >= (0x1F35AE16 ^ 0x1F35AE14) && string.endsWith(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("6"))) break block3;
            }
            Object[] objectArray = new Object[0xAEB2F852 ^ 0xAEB2F850];
            objectArray[0x294554AC ^ 0x294554AC] = string;
            objectArray[0xAF38AF92 ^ 0xAF38AF93] = type.toString();
            throw new InvalidMixinException((IMixinInfo)mixinInfo, String.format(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("B\ua7f4\ua4b0\ua077\ua90c\u7d6e\u8e0a\u243f\u8b24\u3437t\ua7e9\ua4a7\ua031\ua90c\u7d70\u8e4b\u2479\u8b32\u34377\ua7f5\ua4f5\ua078\ua916\u7d36\u8e44\u2475\u8b23\u3437d\ua7e7\ua4b9\ua078\ua901"), objectArray));
        }
        this.mixin = mixinInfo;
        this.prefix = string;
        this.iface = type;
        this.unique = bl;
    }

    private void initMethods() {
        this.methods = new HashSet<String>();
        this.readInterface(this.iface.getInternalName());
    }

    private void readInterface(String string) {
        ClassInfo classInfo = ClassInfo.forName(string);
        for (ClassInfo.Method object : classInfo.getMethods()) {
            this.methods.add(object.toString());
        }
        for (String string2 : classInfo.getInterfaces()) {
            this.readInterface(string2);
        }
    }

    public String getPrefix() {
        return this.prefix;
    }

    public Type getIface() {
        return this.iface;
    }

    public String getName() {
        return this.iface.getClassName();
    }

    public String getInternalName() {
        return this.iface.getInternalName();
    }

    public boolean isUnique() {
        return this.unique;
    }

    public boolean renameMethod(MethodNode methodNode) {
        if (this.methods == null) {
            this.initMethods();
        }
        if (!methodNode.name.startsWith(this.prefix)) {
            if (this.methods.contains(methodNode.name + methodNode.desc)) {
                this.decorateUniqueMethod(methodNode);
            }
            return (0x91E7595D ^ 0x91E7595D) != 0;
        }
        String string = methodNode.name.substring(this.prefix.length());
        String string2 = string + methodNode.desc;
        if (!this.methods.contains(string2)) {
            Object[] objectArray = new Object[0xE88B93F0 ^ 0xE88B93F2];
            objectArray[0xB2AA0A28 ^ 0xB2AA0A28] = string;
            objectArray[0xC0DAC1BC ^ 0xC0DAC1BD] = this.getName();
            throw new InvalidMixinException((IMixinInfo)this.mixin, String.format(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("7\ua7f5\ua4f5\ua075\ua90a\u7d73\u8e59\u243a\u8b39\u3478f\ua7a6\ua4b0\ua069\ua90c\u7d65\u8e5e\u243a\u8b3e\u34792\ua7f2\ua4b4\ua063\ua902\u7d73\u8e5e\u243a\u8b3e\u3479f\ua7e3\ua4a7\ua077\ua904\u7d75\u8e4f\u243a\u8b72\u3464"), objectArray));
        }
        if ((methodNode.access & (0xA9453CC5 ^ 0xA9453CC4)) == 0) {
            Object[] objectArray = new Object[0x30355901 ^ 0x30355903];
            objectArray[0x25D33F61 ^ 0x25D33F61] = string;
            objectArray[0x4237142C ^ 0x4237142D] = this.getName();
            throw new InvalidMixinException((IMixinInfo)this.mixin, String.format(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("7\ua7f5\ua4f5\ua072\ua904\u7d78\u8e44\u2475\u8b23\u3437{\ua7eb\ua4a5\ua07d\ua900\u7d7b\u8e4f\u2474\u8b23\u34377\ua7f5\ua4f5\ua073\ua900\u7d75\u8e4b\u246f\u8b24\u34722\ua7ef\ua4a1\ua031\ua90c\u7d65\u8e0a\u2474\u8b38\u34632\ua7f0\ua4bc\ua062\ua90c\u7d74\u8e46\u247f"), objectArray));
        }
        Object[] objectArray = new Object[0x45DE8B4F ^ 0x45DE8B4B];
        objectArray[0x56EAA9F9 ^ 0x56EAA9F9] = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("}\ua7f4\ua4bc\ua076\ua90c\u7d78\u8e4b\u2476\u8b19\u3476\u007f\ua7e3");
        objectArray[0x2AE27831 ^ 0x2AE27830] = methodNode.name;
        objectArray[0x31DC533A ^ 0x31DC5338] = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("{\ua7f5\ua49c\ua07f\ua911\u7d73\u8e58\u247c\u8b36\u3474w\ua7cb\ua4b0\ua07c\ua907\u7d73\u8e58");
        objectArray[0x34675977 ^ 0x34675974] = (0x5FF46847 ^ 0x5FF46846) != 0;
        Annotations.setVisible(methodNode, MixinRenamed.class, objectArray);
        this.decorateUniqueMethod(methodNode);
        methodNode.name = string;
        return (0xB9F7C434 ^ 0xB9F7C435) != 0;
    }

    private void decorateUniqueMethod(MethodNode methodNode) {
        if (!this.unique) {
            return;
        }
        if (Annotations.getVisible(methodNode, Unique.class) == null) {
            Annotations.setVisible(methodNode, Unique.class, new Object[0xCDCD67C1 ^ 0xCDCD67C1]);
            this.mixin.getClassInfo().findMethod(methodNode).setUnique((0x36661F08 ^ 0x36661F09) != 0);
        }
    }

    static InterfaceInfo fromAnnotation(MixinInfo mixinInfo, AnnotationNode annotationNode) {
        String string = (String)Annotations.getValue(annotationNode, \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("b\ua7f4\ua4b0\ua077\ua90c\u7d6e"));
        Type type = (Type)Annotations.getValue(annotationNode, \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("{\ua7e0\ua4b4\ua072\ua900"));
        Boolean bl = (Boolean)Annotations.getValue(annotationNode, \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("g\ua7e8\ua4bc\ua060\ua910\u7d73"));
        if (string == null || type == null) {
            Object[] objectArray = new Object[0x10B61E05 ^ 0x10B61E04];
            objectArray[0xC70D5393 ^ 0xC70D5393] = mixinInfo;
            throw new InvalidMixinException((IMixinInfo)mixinInfo, String.format(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("R\ua7cf\ua4bb\ua065\ua900\u7d64\u8e4c\u247b\u8b34\u34722\ua7e7\ua4bb\ua07f\ua90a\u7d62\u8e4b\u246e\u8b3e\u3478|\ua7a6\ua4ba\ua07f\ua945\u7d33\u8e59\u243a\u8b3e\u34642\ua7eb\ua4bc\ua062\ua916\u7d7f\u8e44\u247d\u8b77\u34762\ua7f4\ua4b0\ua060\ua910\u7d7f\u8e58\u247f\u8b33\u3437b\ua7e7\ua4a7\ua070\ua908\u7d73\u8e5e\u247f\u8b25"), objectArray));
        }
        return new InterfaceInfo(mixinInfo, string, type, (bl != null && bl.booleanValue() ? 0xEFF240AE ^ 0xEFF240AF : 0xE3F1AD49 ^ 0xE3F1AD49) != 0);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return (0x89888032 ^ 0x89888033) != 0;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return (0x8C0A6942 ^ 0x8C0A6942) != 0;
        }
        InterfaceInfo interfaceInfo = (InterfaceInfo)object;
        return (this.mixin.equals(interfaceInfo.mixin) && this.prefix.equals(interfaceInfo.prefix) && this.iface.equals(interfaceInfo.iface) ? 0x3CAC9D6E ^ 0x3CAC9D6F : 0xDDEC7545 ^ 0xDDEC7545) != 0;
    }

    public int hashCode() {
        int n = this.mixin.hashCode();
        n = (0xDAAB17C4 ^ 0xDAAB17DB) * n + this.prefix.hashCode();
        n = (0x5761CDB8 ^ 0x5761CDA7) * n + this.iface.hashCode();
        return n;
    }
}

