/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import org.spongepowered.asm.mixin.transformer.MixinInfo;
import org.spongepowered.asm.util.Counter;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2;

public class MethodMapper {
    private static final Logger logger = LogManager.getLogger((String)\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("\u007f\ua7ef\ua4ad\ua078\ua90b"));
    private static final List<String> classes = new ArrayList<String>();
    private static final Map<String, Counter> methods = new HashMap<String, Counter>();
    private final ClassInfo info;

    public MethodMapper(MixinEnvironment mixinEnvironment, ClassInfo classInfo) {
        this.info = classInfo;
    }

    public ClassInfo getClassInfo() {
        return this.info;
    }

    public void remapHandlerMethod(MixinInfo mixinInfo, MethodNode methodNode, ClassInfo.Method method) {
        if (!(methodNode instanceof MixinInfo.MixinMethodNode) || !((MixinInfo.MixinMethodNode)methodNode).isInjector()) {
            return;
        }
        if (method.isUnique()) {
            Object[] objectArray = new Object[0x2C5546C8 ^ 0x2C5546CA];
            objectArray[0xFB01BDA ^ 0xFB01BDA] = method;
            objectArray[0x418F30EB ^ 0x418F30EA] = mixinInfo;
            logger.warn(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("@\ua7e3\ua4b1\ua064\ua90b\u7d72\u8e4b\u2474\u8b23\u3437R\ua7d3\ua4bb\ua078\ua914\u7d63\u8e4f\u243a\u8b38\u34792\ua7ef\ua4bb\ua07b\ua900\u7d75\u8e5e\u2475\u8b25\u3437\u007f\ua7e3\ua4a1\ua079\ua90a\u7d72\u8e0a\u2461\u8b2a\u3437{\ua7e8\ua4f5\ua06a\ua918\u7d38\u8e0a\u2453\u8b39\u347dw\ua7e5\ua4a1\ua07e\ua917\u7d65\u8e0a\u247b\u8b25\u34722\ua7ef\ua4b8\ua061\ua909\u7d7f\u8e49\u2473\u8b23\u347bk\ua7a6\ua4a0\ua07f\ua90c\u7d67\u8e5f\u247f"), objectArray);
        }
        if (method.isRenamed()) {
            methodNode.name = method.getName();
            return;
        }
        String string = this.getHandlerName((MixinInfo.MixinMethodNode)methodNode);
        methodNode.name = method.renameTo(string);
    }

    public String getHandlerName(MixinInfo.MixinMethodNode mixinMethodNode) {
        String string = InjectionInfo.getInjectorPrefix(mixinMethodNode.getInjectorAnnotation());
        String string2 = MethodMapper.getClassUID(mixinMethodNode.getOwner().getClassRef());
        String string3 = MethodMapper.getMethodUID(mixinMethodNode.name, mixinMethodNode.desc, (!mixinMethodNode.isSurrogate() ? 0x36BD6E6B ^ 0x36BD6E6A : 0xA78DFE80 ^ 0xA78DFE80) != 0);
        Object[] objectArray = new Object[0x3BB4702B ^ 0x3BB4702F];
        objectArray[0x50248B75 ^ 0x50248B75] = string;
        objectArray[0xCC9F5186 ^ 0xCC9F5187] = mixinMethodNode.name;
        objectArray[0xFE321B24 ^ 0xFE321B26] = string2;
        objectArray[0x44FC89F ^ 0x44FC89C] = string3;
        return String.format(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("7\ua7f5\ua4f1\ua034\ua916\u7d32\u8e0f\u2469\u8b72\u3464"), objectArray);
    }

    private static String getClassUID(String string) {
        int n = classes.indexOf(string);
        if (n < 0) {
            n = classes.size();
            classes.add(string);
        }
        return MethodMapper.finagle(n);
    }

    private static String getMethodUID(String string, String string2, boolean bl) {
        Object[] objectArray = new Object[0x7D6F7633 ^ 0x7D6F7631];
        objectArray[0xF6157906 ^ 0xF6157906] = string;
        objectArray[0xEA7C43CE ^ 0xEA7C43CF] = string2;
        String string3 = String.format(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("7\ua7f5\ua4f0\ua062"), objectArray);
        Counter counter = methods.get(string3);
        if (counter == null) {
            counter = new Counter();
            methods.put(string3, counter);
        } else if (bl) {
            counter.value += 0x900AF23A ^ 0x900AF23B;
        }
        Object[] objectArray2 = new Object[0x3B6BB9D7 ^ 0x3B6BB9D6];
        objectArray2[0x7EE97E0C ^ 0x7EE97E0C] = counter.value;
        return String.format(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("7\ua7b6\ua4e6\ua069"), objectArray2);
    }

    private static String finagle(int n) {
        String string = Integer.toHexString(n);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0x3769B3F0 ^ 0x3769B3F0; i < string.length(); ++i) {
            char c = string.charAt(i);
            c = (char)(c + (c < (0x366A0FD3 ^ 0x366A0FE9) ? 0x87330B6D ^ 0x87330B5C : 0x7BD32B51 ^ 0x7BD32B5B));
            stringBuilder.append(c);
        }
        return Strings.padStart((String)stringBuilder.toString(), (int)(0x4F700DE0 ^ 0x4F700DE3), (char)(0xCDC0C7AE ^ 0xCDC0C7D4));
    }
}

