/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer;

import com.google.common.collect.ImmutableList;
import java.lang.annotation.Annotation;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.SortedSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.lib.Label;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.signature.SignatureReader;
import org.spongepowered.asm.lib.signature.SignatureVisitor;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.lib.tree.FieldInsnNode;
import org.spongepowered.asm.lib.tree.FieldNode;
import org.spongepowered.asm.lib.tree.JumpInsnNode;
import org.spongepowered.asm.lib.tree.LabelNode;
import org.spongepowered.asm.lib.tree.LineNumberNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.refmap.IMixinContext;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import org.spongepowered.asm.mixin.transformer.MixinInfo;
import org.spongepowered.asm.mixin.transformer.MixinTargetContext;
import org.spongepowered.asm.mixin.transformer.TargetClassContext;
import org.spongepowered.asm.mixin.transformer.ext.extensions.ExtensionClassExporter;
import org.spongepowered.asm.mixin.transformer.meta.MixinMerged;
import org.spongepowered.asm.mixin.transformer.meta.MixinRenamed;
import org.spongepowered.asm.mixin.transformer.throwables.InvalidMixinException;
import org.spongepowered.asm.util.Annotations;
import org.spongepowered.asm.util.Bytecode;
import org.spongepowered.asm.util.ConstraintParser;
import org.spongepowered.asm.util.perf.Profiler;
import org.spongepowered.asm.util.throwables.ConstraintViolationException;
import org.spongepowered.asm.util.throwables.InvalidConstraintException;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2;

class MixinApplicatorStandard {
    protected static final List<Class<? extends Annotation>> CONSTRAINED_ANNOTATIONS = ImmutableList.of(Overwrite.class, Inject.class, ModifyArg.class, ModifyArgs.class, Redirect.class, ModifyVariable.class, ModifyConstant.class);
    protected static final int[] INITIALISER_OPCODE_BLACKLIST;
    protected final Logger logger = LogManager.getLogger((String)\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("\u007f\ua7ef\ua4ad\ua078\ua90b"));
    protected final TargetClassContext context;
    protected final String targetName;
    protected final ClassNode targetClass;
    protected final Profiler profiler = MixinEnvironment.getProfiler();
    protected final boolean mergeSignatures;

    MixinApplicatorStandard(TargetClassContext targetClassContext) {
        this.context = targetClassContext;
        this.targetName = targetClassContext.getClassName();
        this.targetClass = targetClassContext.getClassNode();
        ExtensionClassExporter extensionClassExporter = (ExtensionClassExporter)targetClassContext.getExtensions().getExtension(ExtensionClassExporter.class);
        this.mergeSignatures = extensionClassExporter.isDecompilerActive() && MixinEnvironment.getCurrentEnvironment().getOption(MixinEnvironment.Option.DEBUG_EXPORT_DECOMPILE_MERGESIGNATURES) ? 0x4653B50F ^ 0x4653B50E : 0x6A7D4381 ^ 0x6A7D4381;
    }

    void apply(SortedSet<MixinInfo> sortedSet) {
        ArrayList<MixinTargetContext> arrayList = new ArrayList<MixinTargetContext>();
        for (MixinInfo object2 : sortedSet) {
            Object[] objectArray = new Object[0x11320CEE ^ 0x11320CED];
            objectArray[0xFFCFA0BF ^ 0xFFCFA0BF] = object2.getName();
            objectArray[0x2797975 ^ 0x2797974] = object2.getParent();
            objectArray[0x53BD6689 ^ 0x53BD668B] = this.targetName;
            this.logger.log(object2.getLoggingLevel(), \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("_\ua7ef\ua4ad\ua078\ua90b\u7d71\u8e0a\u2461\u8b2a\u3437t\ua7f4\ua4ba\ua07c\ua945\u7d6d\u8e57\u243a\u8b3e\u3479f\ua7e9\ua4f5\ua06a\ua918"), objectArray);
            arrayList.add(object2.createContextFor(this.context));
        }
        Object object = null;
        try {
            for (MixinTargetContext mixinTargetContext : arrayList) {
                object = mixinTargetContext;
                ((MixinTargetContext)object).preApply(this.targetName, this.targetClass);
            }
            ApplicatorPass[] exception = ApplicatorPass.values();
            int n = exception.length;
            for (int i = 0x9568FC4C ^ 0x9568FC4C; i < n; ++i) {
                ApplicatorPass applicatorPass = exception[i];
                String[] stringArray = new String[0x8AB0BE27 ^ 0x8AB0BE25];
                stringArray[0x916E3504 ^ 0x916E3504] = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("b\ua7e7\ua4a6\ua062");
                stringArray[0x12F94076 ^ 0x12F94077] = applicatorPass.name().toLowerCase();
                Profiler.Section section = this.profiler.begin(stringArray);
                for (MixinTargetContext mixinTargetContext : arrayList) {
                    object = mixinTargetContext;
                    this.applyMixin((MixinTargetContext)object, applicatorPass);
                }
                section.end();
            }
            for (MixinTargetContext mixinTargetContext : arrayList) {
                object = mixinTargetContext;
                ((MixinTargetContext)object).postApply(this.targetName, this.targetClass);
            }
        }
        catch (InvalidMixinException invalidMixinException) {
            throw invalidMixinException;
        }
        catch (Exception exception) {
            throw new InvalidMixinException((IMixinContext)object, \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("G\ua7e8\ua4b0\ua069\ua915\u7d73\u8e49\u246e\u8b32\u3473w\ua7e2\ua4f5") + exception.getClass().getSimpleName() + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2\ua7f1\ua4bd\ua078\ua909\u7d65\u8e5e\u243a\u8b36\u3467b\ua7ea\ua4ac\ua078\ua90b\u7d71\u8e0a\u246e\u8b3f\u34722\ua7eb\ua4bc\ua069\ua90c\u7d78\u8e0a\u2479\u8b3b\u3476a\ua7f5\ua4ef\ua031") + exception.getMessage(), (Throwable)exception);
        }
        this.applySourceMap(this.context);
        this.context.processDebugTasks();
    }

    protected final void applyMixin(MixinTargetContext mixinTargetContext, ApplicatorPass applicatorPass) {
        switch (1.$SwitchMap$org$spongepowered$asm$mixin$transformer$MixinApplicatorStandard$ApplicatorPass[applicatorPass.ordinal()]) {
            case 1: {
                this.applySignature(mixinTargetContext);
                this.applyInterfaces(mixinTargetContext);
                this.applyAttributes(mixinTargetContext);
                this.applyAnnotations(mixinTargetContext);
                this.applyFields(mixinTargetContext);
                this.applyMethods(mixinTargetContext);
                this.applyInitialisers(mixinTargetContext);
                break;
            }
            case 2: {
                this.prepareInjections(mixinTargetContext);
                break;
            }
            case 3: {
                this.applyAccessors(mixinTargetContext);
                this.applyInjections(mixinTargetContext);
                break;
            }
            default: {
                throw new IllegalStateException(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b27\u3476a\ua7f5\ua4f5\ua062\ua915\u7d73\u8e49\u2473\u8b31\u347ew\ua7e2\ua4f5") + (Object)((Object)applicatorPass));
            }
        }
    }

    protected void applySignature(MixinTargetContext mixinTargetContext) {
        if (this.mergeSignatures) {
            this.context.mergeSignature(mixinTargetContext.getSignature());
        }
    }

    protected void applyInterfaces(MixinTargetContext mixinTargetContext) {
        for (String string : mixinTargetContext.getInterfaces()) {
            if (this.targetClass.interfaces.contains(string)) continue;
            this.targetClass.interfaces.add(string);
            mixinTargetContext.getTargetClassInfo().addInterface(string);
        }
    }

    protected void applyAttributes(MixinTargetContext mixinTargetContext) {
        if (mixinTargetContext.shouldSetSourceFile()) {
            this.targetClass.sourceFile = mixinTargetContext.getSourceFile();
        }
        this.targetClass.version = Math.max(this.targetClass.version, mixinTargetContext.getMinRequiredClassVersion());
    }

    protected void applyAnnotations(MixinTargetContext mixinTargetContext) {
        ClassNode classNode = mixinTargetContext.getClassNode();
        Bytecode.mergeAnnotations(classNode, this.targetClass);
    }

    protected void applyFields(MixinTargetContext mixinTargetContext) {
        this.mergeShadowFields(mixinTargetContext);
        this.mergeNewFields(mixinTargetContext);
    }

    protected void mergeShadowFields(MixinTargetContext mixinTargetContext) {
        for (Map.Entry<FieldNode, ClassInfo.Field> entry : mixinTargetContext.getShadowFields()) {
            FieldNode fieldNode = entry.getKey();
            FieldNode fieldNode2 = this.findTargetField(fieldNode);
            if (fieldNode2 == null) continue;
            Bytecode.mergeAnnotations(fieldNode, fieldNode2);
            if (!entry.getValue().isDecoratedMutable()) continue;
            if (Bytecode.hasFlag(fieldNode2, 0xE443943 ^ 0xE443941)) continue;
            fieldNode2.access &= 0xB7BFCA12 ^ 0x484035FD;
        }
    }

    protected void mergeNewFields(MixinTargetContext mixinTargetContext) {
        for (FieldNode fieldNode : mixinTargetContext.getFields()) {
            FieldNode fieldNode2 = this.findTargetField(fieldNode);
            if (fieldNode2 != null) continue;
            this.targetClass.fields.add(fieldNode);
            if (fieldNode.signature == null) continue;
            if (this.mergeSignatures) {
                SignatureVisitor signatureVisitor = mixinTargetContext.getSignature().getRemapper();
                new SignatureReader(fieldNode.signature).accept(signatureVisitor);
                fieldNode.signature = signatureVisitor.toString();
                continue;
            }
            fieldNode.signature = null;
        }
    }

    protected void applyMethods(MixinTargetContext mixinTargetContext) {
        for (MethodNode methodNode : mixinTargetContext.getShadowMethods()) {
            this.applyShadowMethod(mixinTargetContext, methodNode);
        }
        for (MethodNode methodNode : mixinTargetContext.getMethods()) {
            this.applyNormalMethod(mixinTargetContext, methodNode);
        }
    }

    protected void applyShadowMethod(MixinTargetContext mixinTargetContext, MethodNode methodNode) {
        MethodNode methodNode2 = this.findTargetMethod(methodNode);
        if (methodNode2 != null) {
            Bytecode.mergeAnnotations(methodNode, methodNode2);
        }
    }

    protected void applyNormalMethod(MixinTargetContext mixinTargetContext, MethodNode methodNode) {
        mixinTargetContext.transformMethod(methodNode);
        if (!methodNode.name.startsWith(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("."))) {
            this.checkMethodVisibility(mixinTargetContext, methodNode);
            this.checkMethodConstraints(mixinTargetContext, methodNode);
            this.mergeMethod(mixinTargetContext, methodNode);
        } else if (\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b(".\ua7e5\ua4b9\ua078\ua90b\u7d7f\u8e5e\u2424").equals(methodNode.name)) {
            this.appendInsns(mixinTargetContext, methodNode);
        }
    }

    protected void mergeMethod(MixinTargetContext mixinTargetContext, MethodNode methodNode) {
        Object object;
        int n = Annotations.getVisible(methodNode, Overwrite.class) != null ? 0x9C936119 ^ 0x9C936118 : 0xFBCA760A ^ 0xFBCA760A;
        MethodNode methodNode2 = this.findTargetMethod(methodNode);
        if (methodNode2 != null) {
            if (this.isAlreadyMerged(mixinTargetContext, methodNode, n != 0, methodNode2)) {
                return;
            }
            object = Annotations.getInvisible(methodNode, Intrinsic.class);
            if (object != null) {
                if (this.mergeIntrinsic(mixinTargetContext, methodNode, n != 0, methodNode2, (AnnotationNode)object)) {
                    mixinTargetContext.getTarget().methodMerged(methodNode);
                    return;
                }
            } else {
                if (mixinTargetContext.requireOverwriteAnnotations() && !n) {
                    Object[] objectArray = new Object[0x1D79CCA5 ^ 0x1D79CCA1];
                    objectArray[0xBBA2D923 ^ 0xBBA2D923] = methodNode.name;
                    objectArray[0xECBBF393 ^ 0xECBBF392] = methodNode.desc;
                    objectArray[0xBF96EDF5 ^ 0xBF96EDF7] = mixinTargetContext;
                    objectArray[0x2B385F34 ^ 0x2B385F37] = mixinTargetContext.getTarget().getClassName();
                    throw new InvalidMixinException((IMixinContext)mixinTargetContext, String.format(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("7\ua7f5\ua4f0\ua062\ua945\u7d7f\u8e44\u243a\u8b72\u34642\ua7e5\ua4b4\ua07f\ua90b\u7d79\u8e5e\u243a\u8b38\u3461w\ua7f4\ua4a2\ua063\ua90c\u7d62\u8e4f\u243a\u8b3a\u3472f\ua7ee\ua4ba\ua075\ua945\u7d7f\u8e44\u243a\u8b72\u34642\ua7e4\ua4b0\ua072\ua904\u7d63\u8e59\u247f\u8b77\u3457]\ua7f0\ua4b0\ua063\ua912\u7d64\u8e43\u246e\u8b32\u3437{\ua7f5\ua4f5\ua063\ua900\u7d67\u8e5f\u2473\u8b25\u3472v\ua7a6\ua4b7\ua068\ua945\u7d62\u8e42\u247f\u8b77\u3467s\ua7f4\ua4b0\ua07f\ua911\u7d36\u8e49\u2475\u8b39\u3471{\ua7e1\ua4a0\ua063\ua904\u7d62\u8e43\u2475\u8b39"), objectArray));
                }
                this.targetClass.methods.remove(methodNode2);
            }
        } else if (n) {
            Object[] objectArray = new Object[0x62354A05 ^ 0x62354A07];
            objectArray[0x401DF3E8 ^ 0x401DF3E8] = methodNode.name;
            objectArray[0xC080267E ^ 0xC080267F] = mixinTargetContext.getTargetClassRef();
            throw new InvalidMixinException((IMixinContext)mixinTargetContext, String.format(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("]\ua7f0\ua4b0\ua063\ua912\u7d64\u8e43\u246e\u8b32\u3437f\ua7e7\ua4a7\ua076\ua900\u7d62\u8e0a\u2438\u8b72\u34640\ua7a6\ua4a2\ua070\ua916\u7d36\u8e44\u2475\u8b23\u3437~\ua7e9\ua4b6\ua070\ua911\u7d73\u8e4e\u243a\u8b3e\u34792\ua7f2\ua4b4\ua063\ua902\u7d73\u8e5e\u243a\u8b34\u347bs\ua7f5\ua4a6\ua031\ua940\u7d65"), objectArray));
        }
        this.targetClass.methods.add(methodNode);
        mixinTargetContext.methodMerged(methodNode);
        if (methodNode.signature != null) {
            if (this.mergeSignatures) {
                object = mixinTargetContext.getSignature().getRemapper();
                new SignatureReader(methodNode.signature).accept((SignatureVisitor)object);
                methodNode.signature = object.toString();
            } else {
                methodNode.signature = null;
            }
        }
    }

    protected boolean isAlreadyMerged(MixinTargetContext mixinTargetContext, MethodNode methodNode, boolean bl, MethodNode methodNode2) {
        AnnotationNode annotationNode = Annotations.getVisible(methodNode2, MixinMerged.class);
        if (annotationNode == null) {
            if (Annotations.getVisible(methodNode2, Final.class) != null) {
                Object[] objectArray = new Object[0x918A7AAB ^ 0x918A7AA9];
                objectArray[0xC233ECAB ^ 0xC233ECAB] = methodNode.name;
                objectArray[0x16E94F43 ^ 0x16E94F42] = mixinTargetContext;
                this.logger.warn(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("]\ua7f0\ua4b0\ua063\ua912\u7d64\u8e43\u246e\u8b32\u3437b\ua7f4\ua4ba\ua079\ua90c\u7d74\u8e43\u246e\u8b32\u34732\ua7e0\ua4ba\ua063\ua945\u7d56\u8e6c\u2473\u8b39\u3476~\ua7a6\ua4b8\ua074\ua911\u7d7e\u8e45\u247e\u8b77\u346co\ua7a6\ua4bc\ua07f\ua945\u7d6d\u8e57\u2434\u8b77\u3444y\ua7ef\ua4a5\ua061\ua90c\u7d78\u8e4d\u243a\u8b3a\u3472f\ua7ee\ua4ba\ua075\ua94b"), objectArray);
                return (0x7E4742C ^ 0x7E4742D) != 0;
            }
            return (0x95C722D9 ^ 0x95C722D9) != 0;
        }
        String string = (String)Annotations.getValue(annotationNode, \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("a\ua7e3\ua4a6\ua062\ua90c\u7d79\u8e44\u2453\u8b33"));
        if (!this.context.getSessionId().equals(string)) {
            throw new ClassFormatError(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b17\u345a{\ua7fe\ua4bc\ua07f\ua928\u7d73\u8e58\u247d\u8b32\u34732\ua7e7\ua4bb\ua07f\ua90a\u7d62\u8e4b\u246e\u8b3e\u3478|\ua7a6\ua4b3\ua07e\ua910\u7d78\u8e4e\u243a\u8b3e\u3479") + mixinTargetContext + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2\ua7e7\ua4a1\ua031") + methodNode.name + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2\ua7ef\ua4bb\ua031") + this.targetClass.name);
        }
        if (Bytecode.hasFlag(methodNode2, 0x80E4F0D0 ^ 0x80E4E090)) {
            if (Bytecode.hasFlag(methodNode, 0xD44BCE29 ^ 0xD44BDE69)) {
                if (mixinTargetContext.getEnvironment().getOption(MixinEnvironment.Option.DEBUG_VERBOSE)) {
                    Object[] objectArray = new Object[0x83755078 ^ 0x8375507A];
                    objectArray[0x34B78B19 ^ 0x34B78B19] = methodNode.name;
                    objectArray[0xADBF6740 ^ 0xADBF6741] = mixinTargetContext;
                    this.logger.warn(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("A\ua7ff\ua4bb\ua065\ua90d\u7d73\u8e5e\u2473\u8b34\u3437p\ua7f4\ua4bc\ua075\ua902\u7d73\u8e0a\u2477\u8b32\u3463z\ua7e9\ua4b1\ua031\ua906\u7d7a\u8e4b\u2469\u8b3f\u3437t\ua7e9\ua4a7\ua031\ua91e\u7d6b\u8e0a\u2473\u8b39\u3437i\ua7fb"), objectArray);
                }
                return (0xD8EB483 ^ 0xD8EB482) != 0;
            }
        }
        String string2 = (String)Annotations.getValue(annotationNode, \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("\u007f\ua7ef\ua4ad\ua078\ua90b"));
        int n = (Integer)Annotations.getValue(annotationNode, \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("b\ua7f4\ua4bc\ua07e\ua917\u7d7f\u8e5e\u2463"));
        if (n >= mixinTargetContext.getPriority() && !string2.equals(mixinTargetContext.getClassName())) {
            Object[] objectArray = new Object[0xAC446375 ^ 0xAC446376];
            objectArray[0xEC40EEF7 ^ 0xEC40EEF7] = methodNode.name;
            objectArray[0xD3CA84D3 ^ 0xD3CA84D2] = mixinTargetContext;
            objectArray[0x2DF3FAEA ^ 0x2DF3FAE8] = string2;
            this.logger.warn(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("_\ua7e3\ua4a1\ua079\ua90a\u7d72\u8e0a\u2475\u8b21\u3472`\ua7f1\ua4a7\ua078\ua911\u7d73\u8e0a\u2479\u8b38\u3479t\ua7ea\ua4bc\ua072\ua911\u7d36\u8e4c\u2475\u8b25\u3437i\ua7fb\ua4f5\ua078\ua90b\u7d36\u8e51\u2467\u8b7b\u3437b\ua7f4\ua4b0\ua067\ua90c\u7d79\u8e5f\u2469\u8b3b\u346e2\ua7f1\ua4a7\ua078\ua911\u7d62\u8e4f\u2474\u8b77\u3475k\ua7a6\ua4ae\ua06c\ua94b\u7d36\u8e79\u2471\u8b3e\u3467b\ua7ef\ua4bb\ua076\ua945\u7d7b\u8e4f\u246e\u8b3f\u3478v\ua7a8"), objectArray);
            return (0xCD553417 ^ 0xCD553416) != 0;
        }
        if (Annotations.getVisible(methodNode2, Final.class) != null) {
            Object[] objectArray = new Object[0x4AAEA0E8 ^ 0x4AAEA0EB];
            objectArray[0xB04C7F8D ^ 0xB04C7F8D] = methodNode.name;
            objectArray[0xB115F9F0 ^ 0xB115F9F1] = mixinTargetContext;
            objectArray[0xEFED5821 ^ 0xEFED5823] = string2;
            this.logger.warn(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("_\ua7e3\ua4a1\ua079\ua90a\u7d72\u8e0a\u2475\u8b21\u3472`\ua7f1\ua4a7\ua078\ua911\u7d73\u8e0a\u2479\u8b38\u3479t\ua7ea\ua4bc\ua072\ua911\u7d36\u8e4c\u2475\u8b25\u3437R\ua7c0\ua4bc\ua07f\ua904\u7d7a\u8e0a\u2477\u8b32\u3463z\ua7e9\ua4b1\ua031\ua91e\u7d6b\u8e0a\u2473\u8b39\u3437i\ua7fb\ua4f5\ua075\ua900\u7d75\u8e46\u247b\u8b25\u3472v\ua7a6\ua4b7\ua068\ua945\u7d6d\u8e57\u2434\u8b77\u3444y\ua7ef\ua4a5\ua061\ua90c\u7d78\u8e4d\u243a\u8b3a\u3472f\ua7ee\ua4ba\ua075\ua94b"), objectArray);
            return (0x2ED8C83E ^ 0x2ED8C83F) != 0;
        }
        return (0x8757A3C9 ^ 0x8757A3C9) != 0;
    }

    protected boolean mergeIntrinsic(MixinTargetContext mixinTargetContext, MethodNode methodNode, boolean bl, MethodNode methodNode2, AnnotationNode annotationNode) {
        AnnotationNode annotationNode2;
        if (bl) {
            throw new InvalidMixinException((IMixinContext)mixinTargetContext, \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("R\ua7cf\ua4bb\ua065\ua917\u7d7f\u8e44\u2469\u8b3e\u34742\ua7ef\ua4a6\ua031\ua90b\u7d79\u8e5e\u243a\u8b34\u3478\u007f\ua7f6\ua4b4\ua065\ua90c\u7d74\u8e46\u247f\u8b77\u3460{\ua7f2\ua4bd\ua031\ua925\u7d59\u8e5c\u247f\u8b25\u3460`\ua7ef\ua4a1\ua074\ua949\u7d36\u8e58\u247f\u8b3a\u3478d\ua7e3\ua4f5\ua07e\ua90b\u7d73\u8e0a\u2475\u8b31\u3437f\ua7ee\ua4b0\ua062\ua900\u7d36\u8e4b\u2474\u8b39\u3478f\ua7e7\ua4a1\ua078\ua90a\u7d78\u8e59\u243a\u8b38\u34792") + methodNode.name + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2\ua7ef\ua4bb\ua031") + mixinTargetContext);
        }
        String string = methodNode.name + methodNode.desc;
        if (Bytecode.hasFlag(methodNode, 0xA170E5E8 ^ 0xA170E5E0)) {
            throw new InvalidMixinException((IMixinContext)mixinTargetContext, \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("R\ua7cf\ua4bb\ua065\ua917\u7d7f\u8e44\u2469\u8b3e\u34742\ua7eb\ua4b0\ua065\ua90d\u7d79\u8e4e\u243a\u8b34\u3476|\ua7e8\ua4ba\ua065\ua945\u7d74\u8e4f\u243a\u8b24\u3463s\ua7f2\ua4bc\ua072\ua949\u7d36\u8e4c\u2475\u8b22\u3479v\ua7a6") + string + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2\ua7ef\ua4bb\ua031") + mixinTargetContext);
        }
        if (!(Bytecode.hasFlag(methodNode, 0xE8A62204 ^ 0xE8A63204) || (annotationNode2 = Annotations.getVisible(methodNode, MixinRenamed.class)) != null && Annotations.getValue(annotationNode2, \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("{\ua7f5\ua49c\ua07f\ua911\u7d73\u8e58\u247c\u8b36\u3474w\ua7cb\ua4b0\ua07c\ua907\u7d73\u8e58"), Boolean.FALSE).booleanValue())) {
            throw new InvalidMixinException((IMixinContext)mixinTargetContext, \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("R\ua7cf\ua4bb\ua065\ua917\u7d7f\u8e44\u2469\u8b3e\u34742\ua7eb\ua4b0\ua065\ua90d\u7d79\u8e4e\u243a\u8b3a\u3462a\ua7f2\ua4f5\ua073\ua900\u7d36\u8e5a\u2468\u8b32\u3471{\ua7fe\ua4b0\ua075\ua945\u7d7f\u8e44\u246e\u8b32\u3465t\ua7e7\ua4b6\ua074\ua945\u7d7b\u8e4f\u246e\u8b3f\u3478v\ua7aa\ua4f5\ua07f\ua90a\u7d36\u8e58\u247f\u8b39\u3476\u007f\ua7e3\ua4f5\ua074\ua90b\u7d75\u8e45\u246f\u8b39\u3463w\ua7f4\ua4b0\ua075\ua945\u7d79\u8e44\u243a") + string + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2\ua7ef\ua4bb\ua031") + mixinTargetContext);
        }
        if (!Annotations.getValue(annotationNode, \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("v\ua7ef\ua4a6\ua061\ua909\u7d77\u8e49\u247f"), Boolean.FALSE).booleanValue()) {
            Object[] objectArray = new Object[0x53D3040A ^ 0x53D30408];
            objectArray[0xD6E46D93 ^ 0xD6E46D93] = string;
            objectArray[0xF4190975 ^ 0xF4190974] = mixinTargetContext.getTargetClassRef();
            this.logger.log(mixinTargetContext.getLoggingLevel(), \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("A\ua7ed\ua4bc\ua061\ua915\u7d7f\u8e44\u247d\u8b77\u345e|\ua7f2\ua4a7\ua078\ua90b\u7d65\u8e43\u2479\u8b77\u347a{\ua7fe\ua4bc\ua07f\ua945\u7d7b\u8e4f\u246e\u8b3f\u3478v\ua7a6\ua4ae\ua06c\ua945\u7d70\u8e45\u2468\u8b77\u346co"), objectArray);
            return (0xDC374998 ^ 0xDC374999) != 0;
        }
        this.displaceIntrinsic(mixinTargetContext, methodNode, methodNode2);
        return (0xF078B2A8 ^ 0xF078B2A8) != 0;
    }

    protected void displaceIntrinsic(MixinTargetContext mixinTargetContext, MethodNode methodNode, MethodNode methodNode2) {
        String string = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("b\ua7f4\ua4ba\ua069\ua91c\u7d3d") + methodNode2.name;
        ListIterator<AbstractInsnNode> listIterator = methodNode.instructions.iterator();
        while (listIterator.hasNext()) {
            AbstractInsnNode abstractInsnNode = (AbstractInsnNode)listIterator.next();
            if (!(abstractInsnNode instanceof MethodInsnNode)) continue;
            if (abstractInsnNode.getOpcode() == (0x80E63F83 ^ 0x80E63F3B)) continue;
            MethodInsnNode methodInsnNode = (MethodInsnNode)abstractInsnNode;
            if (!methodInsnNode.owner.equals(this.targetClass.name) || !methodInsnNode.name.equals(methodNode2.name) || !methodInsnNode.desc.equals(methodNode2.desc)) continue;
            methodInsnNode.name = string;
        }
        methodNode2.name = string;
    }

    protected final void appendInsns(MixinTargetContext mixinTargetContext, MethodNode methodNode) {
        if (Type.getReturnType(methodNode.desc) != Type.VOID_TYPE) {
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("S\ua7f2\ua4a1\ua074\ua908\u7d66\u8e5e\u247f\u8b33\u3437f\ua7e9\ua4f5\ua07c\ua900\u7d64\u8e4d\u247f\u8b77\u347e|\ua7f5\ua4bb\ua062\ua945\u7d70\u8e58\u2475\u8b3a\u3437s\ua7a6\ua4b8\ua074\ua911\u7d7e\u8e45\u247e\u8b77\u3460z\ua7ef\ua4b6\ua079\ua945\u7d72\u8e45\u247f\u8b24\u3437|\ua7e9\ua4a1\ua031\ua917\u7d73\u8e5e\u246f\u8b25\u34792\ua7f0\ua4ba\ua078\ua901"));
        }
        MethodNode methodNode2 = this.findTargetMethod(methodNode);
        if (methodNode2 != null) {
            AbstractInsnNode abstractInsnNode = Bytecode.findInsn(methodNode2, 0x5A35CE9F ^ 0x5A35CE2E);
            if (abstractInsnNode != null) {
                ListIterator<AbstractInsnNode> listIterator = methodNode.instructions.iterator();
                while (listIterator.hasNext()) {
                    AbstractInsnNode abstractInsnNode2 = (AbstractInsnNode)listIterator.next();
                    if (abstractInsnNode2 instanceof LineNumberNode) continue;
                    if (abstractInsnNode2.getOpcode() == (0x459DA7A9 ^ 0x459DA718)) continue;
                    methodNode2.instructions.insertBefore(abstractInsnNode, abstractInsnNode2);
                }
                methodNode2.maxLocals = Math.max(methodNode2.maxLocals, methodNode.maxLocals);
                methodNode2.maxStack = Math.max(methodNode2.maxStack, methodNode.maxStack);
            }
            return;
        }
        this.targetClass.methods.add(methodNode);
    }

    protected void applyInitialisers(MixinTargetContext mixinTargetContext) {
        MethodNode methodNode = this.getConstructor(mixinTargetContext);
        if (methodNode == null) {
            return;
        }
        Deque<AbstractInsnNode> deque = this.getInitialiser(mixinTargetContext, methodNode);
        if (deque == null || deque.size() == 0) {
            return;
        }
        for (MethodNode methodNode2 : this.targetClass.methods) {
            if (!\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b(".\ua7ef\ua4bb\ua078\ua911\u7d28").equals(methodNode2.name)) continue;
            methodNode2.maxStack = Math.max(methodNode2.maxStack, methodNode.maxStack);
            this.injectInitialiser(mixinTargetContext, methodNode2, deque);
        }
    }

    protected MethodNode getConstructor(MixinTargetContext mixinTargetContext) {
        MethodNode methodNode = null;
        for (MethodNode methodNode2 : mixinTargetContext.getMethods()) {
            if (!\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b(".\ua7ef\ua4bb\ua078\ua911\u7d28").equals(methodNode2.name) || !Bytecode.methodHasLineNumbers(methodNode2)) continue;
            if (methodNode == null) {
                methodNode = methodNode2;
                continue;
            }
            Object[] objectArray = new Object[0xFEAA0E1B ^ 0xFEAA0E19];
            objectArray[0xC0F90865 ^ 0xC0F90865] = mixinTargetContext;
            objectArray[0xF5975163 ^ 0xF5975162] = methodNode.desc;
            this.logger.warn(String.format(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("_\ua7ef\ua4ad\ua078\ua90b\u7d36\u8e0f\u2469\u8b77\u347fs\ua7f5\ua4f5\ua07c\ua910\u7d7a\u8e5e\u2473\u8b27\u347bw\ua7a6\ua4b6\ua07e\ua90b\u7d65\u8e5e\u2468\u8b22\u3474f\ua7e9\ua4a7\ua062\ua949\u7d36\u8e0f\u2469\u8b77\u3460s\ua7f5\ua4f5\ua062\ua900\u7d7a\u8e4f\u2479\u8b23\u3472v\ua78c"), objectArray));
        }
        return methodNode;
    }

    private Range getConstructorRange(MethodNode methodNode) {
        int n = 0xAECE3FC7 ^ 0xAECE3FC7;
        AbstractInsnNode abstractInsnNode = null;
        int n2 = 0x1382359C ^ 0x1382359C;
        int n3 = 0x80184403 ^ 0x80184403;
        int n4 = 0x2CEE9284 ^ 0x2CEE9284;
        int n5 = 0x971E490F ^ 0x68E1B6F0;
        Object object = methodNode.instructions.iterator();
        while (object.hasNext()) {
            AbstractInsnNode abstractInsnNode2 = (AbstractInsnNode)object.next();
            if (abstractInsnNode2 instanceof LineNumberNode) {
                n2 = ((LineNumberNode)abstractInsnNode2).line;
                n = 0x6A1CB23 ^ 0x6A1CB22;
                continue;
            }
            if (abstractInsnNode2 instanceof MethodInsnNode) {
                if (abstractInsnNode2.getOpcode() != (0xD5E2A76E ^ 0xD5E2A7D9) || !\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b(".\ua7ef\ua4bb\ua078\ua911\u7d28").equals(((MethodInsnNode)abstractInsnNode2).name)) continue;
                if (n5 != (0xC8C4B8E1 ^ 0x373B471E)) continue;
                n5 = methodNode.instructions.indexOf(abstractInsnNode2);
                n3 = n2;
                continue;
            }
            if (abstractInsnNode2.getOpcode() == (0xF23F8007 ^ 0xF23F80B2)) {
                n = 0xFC61EF7A ^ 0xFC61EF7A;
                continue;
            }
            if (abstractInsnNode2.getOpcode() != (0xF82B1943 ^ 0xF82B19F2)) continue;
            if (n != 0) {
                n4 = n2;
                continue;
            }
            n4 = n3;
            abstractInsnNode = abstractInsnNode2;
        }
        if (abstractInsnNode != null) {
            object = new LabelNode(new Label());
            methodNode.instructions.insertBefore(abstractInsnNode, (AbstractInsnNode)object);
            methodNode.instructions.insertBefore(abstractInsnNode, new LineNumberNode(n3, (LabelNode)object));
        }
        return new Range(n3, n4, n5);
    }

    protected final Deque<AbstractInsnNode> getInitialiser(MixinTargetContext mixinTargetContext, MethodNode methodNode) {
        Range range = this.getConstructorRange(methodNode);
        if (!range.isValid()) {
            return null;
        }
        int n = 0xEC4AEC1 ^ 0xEC4AEC1;
        ArrayDeque<AbstractInsnNode> arrayDeque = new ArrayDeque<AbstractInsnNode>();
        int n2 = 0xC6791974 ^ 0xC6791974;
        int n3 = 0x5DAB9C68 ^ 0xA2546397;
        LabelNode labelNode = null;
        Object object = methodNode.instructions.iterator(range.marker);
        while (object.hasNext()) {
            AbstractInsnNode abstractInsnNode = (AbstractInsnNode)object.next();
            if (abstractInsnNode instanceof LineNumberNode) {
                n = ((LineNumberNode)abstractInsnNode).line;
                AbstractInsnNode abstractInsnNode2 = methodNode.instructions.get(methodNode.instructions.indexOf(abstractInsnNode) + (0x859AF7D2 ^ 0x859AF7D3));
                if (n == range.end) {
                    if (abstractInsnNode2.getOpcode() != (0x4A6A46A8 ^ 0x4A6A4619)) {
                        n2 = 0xD0B5FCD ^ 0xD0B5FCC;
                        n3 = 0xD4AD6EB9 ^ 0xD4AD6E08;
                        continue;
                    }
                }
                n2 = range.excludes(n) ? 1 : 0;
                n3 = 0x1F411336 ^ 0xE0BEECC9;
                continue;
            }
            if (n2 == 0) continue;
            if (labelNode != null) {
                arrayDeque.add(labelNode);
                labelNode = null;
            }
            if (abstractInsnNode instanceof LabelNode) {
                labelNode = (LabelNode)abstractInsnNode;
                continue;
            }
            int n4 = abstractInsnNode.getOpcode();
            if (n4 == n3) {
                n3 = 0x377F2B3D ^ 0xC880D4C2;
                continue;
            }
            int[] nArray = INITIALISER_OPCODE_BLACKLIST;
            int n5 = nArray.length;
            for (int i = 0x40C4EBD9 ^ 0x40C4EBD9; i < n5; ++i) {
                int n6 = nArray[i];
                if (n4 != n6) continue;
                throw new InvalidMixinException((IMixinContext)mixinTargetContext, \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("Q\ua7e7\ua4bb\ua07f\ua90a\u7d62\u8e0a\u2472\u8b36\u3479v\ua7ea\ua4b0\ua031") + Bytecode.getOpcodeName(n4) + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2\ua7e9\ua4a5\ua072\ua90a\u7d72\u8e4f\u243a\u8b7f\u3427j") + Integer.toHexString(n4).toUpperCase() + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b(";\ua7a6\ua4bc\ua07f\ua945\u7d75\u8e46\u247b\u8b24\u34642\ua7ef\ua4bb\ua078\ua911\u7d7f\u8e4b\u2476\u8b3e\u3464w\ua7f4"));
            }
            arrayDeque.add(abstractInsnNode);
        }
        object = (AbstractInsnNode)arrayDeque.peekLast();
        if (object != null) {
            if (((AbstractInsnNode)object).getOpcode() != (0x83418C65 ^ 0x83418CD0)) {
                throw new InvalidMixinException((IMixinContext)mixinTargetContext, \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("Q\ua7e9\ua4a0\ua07d\ua901\u7d36\u8e44\u2475\u8b23\u3437b\ua7e7\ua4a7\ua062\ua900\u7d36\u8e43\u2474\u8b3e\u3463{\ua7e7\ua4b9\ua078\ua916\u7d73\u8e58\u2436\u8b77\u3472j\ua7f6\ua4b0\ua072\ua911\u7d73\u8e4e\u243a\u8b67\u346fP\ua7b3\ua4f9\ua031\ua903\u7d79\u8e5f\u2474\u8b33\u3437\"\ua7fe") + Integer.toHexString(((AbstractInsnNode)object).getOpcode()) + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2\ua7ef\ua4bb\ua031") + mixinTargetContext);
            }
        }
        return arrayDeque;
    }

    protected final void injectInitialiser(MixinTargetContext mixinTargetContext, MethodNode methodNode, Deque<AbstractInsnNode> deque) {
        Map<LabelNode, LabelNode> map = Bytecode.cloneLabels(methodNode.instructions);
        AbstractInsnNode abstractInsnNode = this.findInitialiserInjectionPoint(mixinTargetContext, methodNode, deque);
        if (abstractInsnNode == null) {
            Object[] objectArray = new Object[0x27BBE5AB ^ 0x27BBE5AA];
            objectArray[0x89AB16EB ^ 0x89AB16EB] = methodNode.desc;
            this.logger.warn(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("T\ua7e7\ua4bc\ua07d\ua900\u7d72\u8e0a\u246e\u8b38\u3437~\ua7e9\ua4b6\ua070\ua911\u7d73\u8e0a\u2473\u8b39\u347ef\ua7ef\ua4b4\ua07d\ua90c\u7d65\u8e4f\u2468\u8b77\u347e|\ua7ec\ua4b0\ua072\ua911\u7d7f\u8e45\u2474\u8b77\u3467}\ua7ef\ua4bb\ua065\ua945\u7d7f\u8e44\u243a\u8b6b\u347e|\ua7ef\ua4a1\ua02f\ua91e\u7d6b\u8e06\u243a\u8b3e\u3479{\ua7f2\ua4bc\ua070\ua909\u7d7f\u8e59\u247f\u8b25\u3437e\ua7e7\ua4a6\ua031\ua90b\u7d79\u8e5e\u243a\u8b3a\u347ej\ua7e3\ua4b1\ua031\ua90c\u7d78\u8e04"), objectArray);
            return;
        }
        for (AbstractInsnNode abstractInsnNode2 : deque) {
            if (abstractInsnNode2 instanceof LabelNode) continue;
            if (abstractInsnNode2 instanceof JumpInsnNode) {
                throw new InvalidMixinException((IMixinContext)mixinTargetContext, \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("G\ua7e8\ua4a6\ua064\ua915\u7d66\u8e45\u2468\u8b23\u3472v\ua7a6\ua49f\ua044\ua928\u7d46\u8e0a\u2475\u8b27\u3474}\ua7e2\ua4b0\ua031\ua90c\u7d78\u8e0a\u2473\u8b39\u347ef\ua7ef\ua4b4\ua07d\ua90c\u7d65\u8e4f\u2468\u8b77\u347e|\ua7a6") + mixinTargetContext);
            }
            AbstractInsnNode abstractInsnNode3 = abstractInsnNode2.clone(map);
            methodNode.instructions.insert(abstractInsnNode, abstractInsnNode3);
            abstractInsnNode = abstractInsnNode3;
        }
    }

    protected AbstractInsnNode findInitialiserInjectionPoint(MixinTargetContext mixinTargetContext, MethodNode methodNode, Deque<AbstractInsnNode> deque) {
        HashSet<String> hashSet = new HashSet<String>();
        for (AbstractInsnNode object2 : deque) {
            if (object2.getOpcode() != (0xFE2E36D7 ^ 0xFE2E3662)) continue;
            hashSet.add(MixinApplicatorStandard.fieldKey((FieldInsnNode)object2));
        }
        Object object3 = this.getInitialiserInjectionMode(mixinTargetContext.getEnvironment());
        String string = mixinTargetContext.getTargetClassInfo().getName();
        String string2 = mixinTargetContext.getTargetClassInfo().getSuperName();
        AbstractInsnNode abstractInsnNode = null;
        ListIterator<AbstractInsnNode> listIterator = methodNode.instructions.iterator();
        while (listIterator.hasNext()) {
            String string3;
            AbstractInsnNode abstractInsnNode2 = (AbstractInsnNode)listIterator.next();
            if (abstractInsnNode2.getOpcode() == (0xDD0AA8A ^ 0xDD0AA3D) && \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b(".\ua7ef\ua4bb\ua078\ua911\u7d28").equals(((MethodInsnNode)abstractInsnNode2).name)) {
                string3 = ((MethodInsnNode)abstractInsnNode2).owner;
                if (!string3.equals(string) && !string3.equals(string2)) continue;
                abstractInsnNode = abstractInsnNode2;
                if (object3 != InitialiserInjectionMode.SAFE) continue;
                break;
            }
            if (abstractInsnNode2.getOpcode() != (0x8F07416A ^ 0x8F0741DF) || object3 != InitialiserInjectionMode.DEFAULT || !hashSet.contains(string3 = MixinApplicatorStandard.fieldKey((FieldInsnNode)abstractInsnNode2))) continue;
            abstractInsnNode = abstractInsnNode2;
        }
        return abstractInsnNode;
    }

    private InitialiserInjectionMode getInitialiserInjectionMode(MixinEnvironment mixinEnvironment) {
        String string = mixinEnvironment.getOptionValue(MixinEnvironment.Option.INITIALISER_INJECTION_MODE);
        if (string == null) {
            return InitialiserInjectionMode.DEFAULT;
        }
        try {
            return InitialiserInjectionMode.valueOf(string.toUpperCase());
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[0x345B695C ^ 0x345B695D];
            objectArray[0xE9372CFD ^ 0xE9372CFD] = string;
            this.logger.warn(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("Q\ua7e9\ua4a0\ua07d\ua901\u7d36\u8e44\u2475\u8b23\u3437b\ua7e7\ua4a7\ua062\ua900\u7d36\u8e5f\u2474\u8b32\u346fb\ua7e3\ua4b6\ua065\ua900\u7d72\u8e0a\u246c\u8b36\u347bg\ua7e3\ua4f5\ua033\ua91e\u7d6b\u8e08\u243a\u8b31\u3478`\ua7a6\ua4b8\ua078\ua91d\u7d7f\u8e44\u2434\u8b3e\u3479{\ua7f2\ua4bc\ua070\ua909\u7d7f\u8e59\u247f\u8b25\u345e|\ua7ec\ua4b0\ua072\ua911\u7d7f\u8e45\u2474\u8b1a\u3478v\ua7e3\ua4f9\ua031\ua917\u7d73\u8e5c\u247f\u8b25\u3463{\ua7e8\ua4b2\ua031\ua911\u7d79\u8e0a\u245e\u8b12\u3451S\ua7d3\ua499\ua045"), objectArray);
            return InitialiserInjectionMode.DEFAULT;
        }
    }

    private static String fieldKey(FieldInsnNode fieldInsnNode) {
        Object[] objectArray = new Object[0x7B4D7146 ^ 0x7B4D7144];
        objectArray[0xA551EB0 ^ 0xA551EB0] = fieldInsnNode.desc;
        objectArray[0x9399A9C ^ 0x9399A9D] = fieldInsnNode.name;
        return String.format(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("7\ua7f5\ua4ef\ua034\ua916"), objectArray);
    }

    protected void prepareInjections(MixinTargetContext mixinTargetContext) {
        mixinTargetContext.prepareInjections();
    }

    protected void applyInjections(MixinTargetContext mixinTargetContext) {
        mixinTargetContext.applyInjections();
    }

    protected void applyAccessors(MixinTargetContext mixinTargetContext) {
        List<MethodNode> list = mixinTargetContext.generateAccessors();
        for (MethodNode methodNode : list) {
            if (methodNode.name.startsWith(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("."))) continue;
            this.mergeMethod(mixinTargetContext, methodNode);
        }
    }

    protected void checkMethodVisibility(MixinTargetContext mixinTargetContext, MethodNode methodNode) {
        if (Bytecode.hasFlag(methodNode, 0xDE180518 ^ 0xDE180510)) {
            if (!Bytecode.hasFlag(methodNode, 0x61287C25 ^ 0x61287C27)) {
                if (!Bytecode.hasFlag(methodNode, 0x73136A6 ^ 0x73126A6) && Annotations.getVisible(methodNode, Overwrite.class) == null) {
                    Object[] objectArray = new Object[0x88BFED88 ^ 0x88BFED8A];
                    objectArray[0x4E83EB1E ^ 0x4E83EB1E] = mixinTargetContext;
                    objectArray[0xA0FDEA4C ^ 0xA0FDEA4D] = methodNode;
                    throw new InvalidMixinException((IMixinContext)mixinTargetContext, String.format(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("_\ua7ef\ua4ad\ua078\ua90b\u7d36\u8e0f\u2469\u8b77\u3474}\ua7e8\ua4a1\ua070\ua90c\u7d78\u8e59\u243a\u8b39\u3478|\ua7ab\ua4a5\ua063\ua90c\u7d60\u8e4b\u246e\u8b32\u3437a\ua7f2\ua4b4\ua065\ua90c\u7d75\u8e0a\u2477\u8b32\u3463z\ua7e9\ua4b1\ua031\ua940\u7d65"), objectArray));
                }
            }
        }
    }

    protected void applySourceMap(TargetClassContext targetClassContext) {
        this.targetClass.sourceDebug = targetClassContext.getSourceMap().toString();
    }

    protected void checkMethodConstraints(MixinTargetContext mixinTargetContext, MethodNode methodNode) {
        for (Class<? extends Annotation> clazz : CONSTRAINED_ANNOTATIONS) {
            AnnotationNode annotationNode = Annotations.getVisible(methodNode, clazz);
            if (annotationNode == null) continue;
            this.checkConstraints(mixinTargetContext, methodNode, annotationNode);
        }
    }

    protected final void checkConstraints(MixinTargetContext mixinTargetContext, MethodNode methodNode, AnnotationNode annotationNode) {
        try {
            ConstraintParser.Constraint constraint = ConstraintParser.parse(annotationNode);
            try {
                constraint.check(mixinTargetContext.getEnvironment());
            }
            catch (ConstraintViolationException constraintViolationException) {
                Object[] objectArray = new Object[0xC016DD52 ^ 0xC016DD51];
                objectArray[0x637A6E74 ^ 0x637A6E74] = constraintViolationException.getMessage();
                objectArray[0xB254C78F ^ 0xB254C78E] = methodNode;
                objectArray[0xDBAE4EA8 ^ 0xDBAE4EAA] = mixinTargetContext;
                String string = String.format(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("Q\ua7e9\ua4bb\ua062\ua911\u7d64\u8e4b\u2473\u8b39\u34632\ua7f0\ua4bc\ua07e\ua909\u7d77\u8e5e\u2473\u8b38\u3479(\ua7a6\ua4f0\ua062\ua945\u7d79\u8e44\u243a\u8b72\u34642\ua7ef\ua4bb\ua031\ua940\u7d65"), objectArray);
                this.logger.warn(string);
                if (!mixinTargetContext.getEnvironment().getOption(MixinEnvironment.Option.IGNORE_CONSTRAINTS)) {
                    throw new InvalidMixinException(mixinTargetContext, string, (Throwable)constraintViolationException);
                }
            }
        }
        catch (InvalidConstraintException invalidConstraintException) {
            throw new InvalidMixinException((IMixinContext)mixinTargetContext, invalidConstraintException.getMessage());
        }
    }

    protected final MethodNode findTargetMethod(MethodNode methodNode) {
        for (MethodNode methodNode2 : this.targetClass.methods) {
            if (!methodNode2.name.equals(methodNode.name) || !methodNode2.desc.equals(methodNode.desc)) continue;
            return methodNode2;
        }
        return null;
    }

    protected final FieldNode findTargetField(FieldNode fieldNode) {
        for (FieldNode fieldNode2 : this.targetClass.fields) {
            if (!fieldNode2.name.equals(fieldNode.name)) continue;
            return fieldNode2;
        }
        return null;
    }

    static {
        int[] nArray = new int[0xEE4B51C2 ^ 0xEE4B51D8];
        nArray[0xB325CB34 ^ 0xB325CB34] = 0x54D0F9EF ^ 0x54D0F95E;
        nArray[0x8346061 ^ 0x8346060] = 0x5EC82C95 ^ 0x5EC82C80;
        nArray[0x6EA94B32 ^ 0x6EA94B30] = 0x45812FD3 ^ 0x45812FC5;
        nArray[0xBDC4F23F ^ 0xBDC4F23C] = 0x9E9CE8A7 ^ 0x9E9CE8B0;
        nArray[0x5D0049E3 ^ 0x5D0049E7] = 0x1349E59E ^ 0x1349E586;
        nArray[0x6839F3EC ^ 0x6839F3E9] = 0xCD0C3B1F ^ 0xCD0C3B31;
        nArray[0x82FF7D58 ^ 0x82FF7D5E] = 0xE52BF5F9 ^ 0xE52BF5D6;
        nArray[0xEA72066E ^ 0xEA720669] = 0xDCF10307 ^ 0xDCF10337;
        nArray[0xCC4DB91F ^ 0xCC4DB917] = 0x2DB56E90 ^ 0x2DB56EA1;
        nArray[0x82347352 ^ 0x8234735B] = 0x7A0ACC4C ^ 0x7A0ACC7E;
        nArray[0xC128B6A ^ 0xC128B60] = 0x22FE9813 ^ 0x22FE9820;
        nArray[0x2325F988 ^ 0x2325F983] = 0xFF39D04F ^ 0xFF39D07B;
        nArray[0xB7874EE9 ^ 0xB7874EE5] = 0x90A66CC7 ^ 0x90A66CF2;
        nArray[0xD70BCD5A ^ 0xD70BCD57] = 0x59C0448F ^ 0x59C044B9;
        nArray[0xB29C62A1 ^ 0xB29C62AF] = 0x7C355123 ^ 0x7C355114;
        nArray[0x4551DC5D ^ 0x4551DC52] = 0x22050B9E ^ 0x22050BA6;
        nArray[0x76D8788 ^ 0x76D8798] = 0xC736FA0D ^ 0xC736FA34;
        nArray[0xA739FAAB ^ 0xA739FABA] = 0xD906E08B ^ 0xD906E0B1;
        nArray[0x8CD806BA ^ 0x8CD806A8] = 0xF19722F0 ^ 0xF19722BF;
        nArray[0x3107BAC7 ^ 0x3107BAD4] = 0xFAD14301 ^ 0xFAD14351;
        nArray[0xBFE2B0B9 ^ 0xBFE2B0AD] = 0x41897048 ^ 0x41897019;
        nArray[0x95AAADB ^ 0x95AAACE] = 0xC85C1F09 ^ 0xC85C1F5B;
        nArray[0x952169A4 ^ 0x952169B2] = 0xA42211BF ^ 0xA42211EC;
        nArray[0xF210EBFF ^ 0xF210EBE8] = 0x54EDDF21 ^ 0x54EDDF75;
        nArray[0x28042674 ^ 0x2804266C] = 0x7AD4E540 ^ 0x7AD4E515;
        nArray[0xEB24781D ^ 0xEB247804] = 0x55D17A0B ^ 0x55D17A5D;
        INITIALISER_OPCODE_BLACKLIST = nArray;
    }

    class Range {
        final int start;
        final int end;
        final int marker;

        Range(int n, int n2, int n3) {
            this.start = n;
            this.end = n2;
            this.marker = n3;
        }

        boolean isValid() {
            return (this.start != 0 && this.end != 0 && this.end >= this.start ? 0xA89980F4 ^ 0xA89980F5 : 0x86F9FA79 ^ 0x86F9FA79) != 0;
        }

        boolean contains(int n) {
            return (n >= this.start && n <= this.end ? 0x3F0DC897 ^ 0x3F0DC896 : 0x235955E4 ^ 0x235955E4) != 0;
        }

        boolean excludes(int n) {
            return (n < this.start || n > this.end ? 0x9E4B0A72 ^ 0x9E4B0A73 : 0xF51293CB ^ 0xF51293CB) != 0;
        }

        public String toString() {
            Object[] objectArray = new Object[0x33EB0CF6 ^ 0x33EB0CF2];
            objectArray[0x4B2EA3F5 ^ 0x4B2EA3F5] = this.start;
            objectArray[0x397A8D56 ^ 0x397A8D57] = this.end;
            objectArray[0x1CC54594 ^ 0x1CC54596] = this.marker;
            objectArray[0xBBE8B9ED ^ 0xBBE8B9EE] = this.isValid();
            return String.format(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("@\ua7e7\ua4bb\ua076\ua900\u7d4d\u8e0f\u247e\u8b7a\u3432v\ua7aa\ua4f0\ua075\ua949\u7d60\u8e4b\u2476\u8b3e\u3473/\ua7a3\ua4a6\ua038"), objectArray);
        }
    }

    static final class InitialiserInjectionMode
    extends Enum<InitialiserInjectionMode> {
        public static final /* enum */ InitialiserInjectionMode DEFAULT = new InitialiserInjectionMode();
        public static final /* enum */ InitialiserInjectionMode SAFE = new InitialiserInjectionMode();
        private static final /* synthetic */ InitialiserInjectionMode[] $VALUES;

        public static InitialiserInjectionMode[] values() {
            return (InitialiserInjectionMode[])$VALUES.clone();
        }

        public static InitialiserInjectionMode valueOf(String string) {
            return Enum.valueOf(InitialiserInjectionMode.class, string);
        }

        static {
            InitialiserInjectionMode[] initialiserInjectionModeArray = new InitialiserInjectionMode[0xD5B94281 ^ 0xD5B94283];
            initialiserInjectionModeArray[0x33B1BAF3 ^ 0x33B1BAF3] = DEFAULT;
            initialiserInjectionModeArray[0x31B70F12 ^ 0x31B70F13] = SAFE;
            $VALUES = initialiserInjectionModeArray;
        }
    }

    static final class ApplicatorPass
    extends Enum<ApplicatorPass> {
        public static final /* enum */ ApplicatorPass MAIN = new ApplicatorPass();
        public static final /* enum */ ApplicatorPass PREINJECT = new ApplicatorPass();
        public static final /* enum */ ApplicatorPass INJECT = new ApplicatorPass();
        private static final /* synthetic */ ApplicatorPass[] $VALUES;

        public static ApplicatorPass[] values() {
            return (ApplicatorPass[])$VALUES.clone();
        }

        public static ApplicatorPass valueOf(String string) {
            return Enum.valueOf(ApplicatorPass.class, string);
        }

        static {
            ApplicatorPass[] applicatorPassArray = new ApplicatorPass[0xD647D7CD ^ 0xD647D7CE];
            applicatorPassArray[0xA8E0D126 ^ 0xA8E0D126] = MAIN;
            applicatorPassArray[0x9E07C40 ^ 0x9E07C41] = PREINJECT;
            applicatorPassArray[0x9BB5871A ^ 0x9BB58718] = INJECT;
            $VALUES = applicatorPassArray;
        }
    }
}

