/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer;

import com.google.common.base.Strings;
import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.ListIterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.FieldInsnNode;
import org.spongepowered.asm.lib.tree.FieldNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.mixin.Dynamic;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.gen.Invoker;
import org.spongepowered.asm.mixin.gen.throwables.InvalidAccessorException;
import org.spongepowered.asm.mixin.refmap.IMixinContext;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import org.spongepowered.asm.mixin.transformer.InterfaceInfo;
import org.spongepowered.asm.mixin.transformer.MethodMapper;
import org.spongepowered.asm.mixin.transformer.MixinInfo;
import org.spongepowered.asm.mixin.transformer.MixinTargetContext;
import org.spongepowered.asm.mixin.transformer.TargetClassContext;
import org.spongepowered.asm.mixin.transformer.meta.MixinRenamed;
import org.spongepowered.asm.mixin.transformer.throwables.InvalidMixinException;
import org.spongepowered.asm.util.Annotations;
import org.spongepowered.asm.util.Bytecode;
import org.spongepowered.asm.util.perf.Profiler;
import org.spongepowered.asm.util.throwables.SyntheticBridgeException;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2;

class MixinPreProcessorStandard {
    private static final Logger logger = LogManager.getLogger((String)\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("\u007f\ua7ef\ua4ad\ua078\ua90b"));
    protected final MixinInfo mixin;
    protected final MixinInfo.MixinClassNode classNode;
    protected final MixinEnvironment env;
    protected final Profiler profiler = MixinEnvironment.getProfiler();
    private final boolean verboseLogging;
    private final boolean strictUnique;
    private boolean prepared;
    private boolean attached;

    MixinPreProcessorStandard(MixinInfo mixinInfo, MixinInfo.MixinClassNode mixinClassNode) {
        this.mixin = mixinInfo;
        this.classNode = mixinClassNode;
        this.env = mixinInfo.getParent().getEnvironment();
        this.verboseLogging = this.env.getOption(MixinEnvironment.Option.DEBUG_VERBOSE);
        this.strictUnique = this.env.getOption(MixinEnvironment.Option.DEBUG_UNIQUE);
    }

    final MixinPreProcessorStandard prepare() {
        if (this.prepared) {
            return this;
        }
        this.prepared = 0x93A21DE6 ^ 0x93A21DE7;
        Profiler.Section section = this.profiler.begin(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("b\ua7f4\ua4b0\ua061\ua904\u7d64\u8e4f"));
        for (MixinInfo.MixinMethodNode object : this.classNode.mixinMethods) {
            ClassInfo.Method method = this.mixin.getClassInfo().findMethod(object);
            this.prepareMethod(object, method);
        }
        for (FieldNode fieldNode : this.classNode.fields) {
            this.prepareField(fieldNode);
        }
        section.end();
        return this;
    }

    protected void prepareMethod(MixinInfo.MixinMethodNode mixinMethodNode, ClassInfo.Method method) {
        this.prepareShadow(mixinMethodNode, method);
        this.prepareSoftImplements(mixinMethodNode, method);
    }

    protected void prepareShadow(MixinInfo.MixinMethodNode mixinMethodNode, ClassInfo.Method method) {
        AnnotationNode annotationNode = Annotations.getVisible(mixinMethodNode, Shadow.class);
        if (annotationNode == null) {
            return;
        }
        String string = (String)Annotations.getValue(annotationNode, \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("b\ua7f4\ua4b0\ua077\ua90c\u7d6e"), Shadow.class);
        if (mixinMethodNode.name.startsWith(string)) {
            Object[] objectArray = new Object[0xED88B208 ^ 0xED88B20A];
            objectArray[0x12294512 ^ 0x12294512] = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("}\ua7f4\ua4bc\ua076\ua90c\u7d78\u8e4b\u2476\u8b19\u3476\u007f\ua7e3");
            objectArray[0x8A60FEC0 ^ 0x8A60FEC1] = mixinMethodNode.name;
            Annotations.setVisible(mixinMethodNode, MixinRenamed.class, objectArray);
            String string2 = mixinMethodNode.name.substring(string.length());
            mixinMethodNode.name = method.renameTo(string2);
        }
    }

    protected void prepareSoftImplements(MixinInfo.MixinMethodNode mixinMethodNode, ClassInfo.Method method) {
        for (InterfaceInfo interfaceInfo : this.mixin.getSoftImplements()) {
            if (!interfaceInfo.renameMethod(mixinMethodNode)) continue;
            method.renameTo(mixinMethodNode.name);
        }
    }

    protected void prepareField(FieldNode fieldNode) {
    }

    final MixinPreProcessorStandard conform(TargetClassContext targetClassContext) {
        return this.conform(targetClassContext.getClassInfo());
    }

    final MixinPreProcessorStandard conform(ClassInfo classInfo) {
        Profiler.Section section = this.profiler.begin(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("q\ua7e9\ua4bb\ua077\ua90a\u7d64\u8e47"));
        for (MixinInfo.MixinMethodNode mixinMethodNode : this.classNode.mixinMethods) {
            if (!mixinMethodNode.isInjector()) continue;
            ClassInfo.Method method = this.mixin.getClassInfo().findMethod(mixinMethodNode, 0x285CD3A ^ 0x285CD30);
            this.conformInjector(classInfo, mixinMethodNode, method);
        }
        section.end();
        return this;
    }

    private void conformInjector(ClassInfo classInfo, MixinInfo.MixinMethodNode mixinMethodNode, ClassInfo.Method method) {
        MethodMapper methodMapper = classInfo.getMethodMapper();
        methodMapper.remapHandlerMethod(this.mixin, mixinMethodNode, method);
    }

    MixinTargetContext createContextFor(TargetClassContext targetClassContext) {
        MixinTargetContext mixinTargetContext = new MixinTargetContext(this.mixin, this.classNode, targetClassContext);
        this.conform(targetClassContext);
        this.attach(mixinTargetContext);
        return mixinTargetContext;
    }

    final MixinPreProcessorStandard attach(MixinTargetContext mixinTargetContext) {
        if (this.attached) {
            throw new IllegalStateException(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("B\ua7f4\ua4b0\ua061\ua917\u7d79\u8e49\u247f\u8b24\u3464}\ua7f4\ua4f5\ua066\ua904\u7d65\u8e0a\u247b\u8b3b\u3465w\ua7e7\ua4b1\ua068\ua945\u7d77\u8e5e\u246e\u8b36\u3474z\ua7e3\ua4b1"));
        }
        this.attached = 0x1F88BF8E ^ 0x1F88BF8F;
        Profiler.Section section = this.profiler.begin(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("s\ua7f2\ua4a1\ua070\ua906\u7d7e"));
        Profiler.Section section2 = this.profiler.begin(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("\u007f\ua7e3\ua4a1\ua079\ua90a\u7d72\u8e59"));
        this.attachMethods(mixinTargetContext);
        section2 = section2.next(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("t\ua7ef\ua4b0\ua07d\ua901\u7d65"));
        this.attachFields(mixinTargetContext);
        section2 = section2.next(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("f\ua7f4\ua4b4\ua07f\ua916\u7d70\u8e45\u2468\u8b3a"));
        this.transform(mixinTargetContext);
        section2.end();
        section.end();
        return this;
    }

    protected void attachMethods(MixinTargetContext mixinTargetContext) {
        Iterator<MixinInfo.MixinMethodNode> iterator = this.classNode.mixinMethods.iterator();
        while (iterator.hasNext()) {
            MixinInfo.MixinMethodNode mixinMethodNode = iterator.next();
            if (!this.validateMethod(mixinTargetContext, mixinMethodNode)) {
                iterator.remove();
                continue;
            }
            if (this.attachInjectorMethod(mixinTargetContext, mixinMethodNode)) {
                mixinTargetContext.addMixinMethod(mixinMethodNode);
                continue;
            }
            if (this.attachAccessorMethod(mixinTargetContext, mixinMethodNode)) {
                iterator.remove();
                continue;
            }
            if (this.attachShadowMethod(mixinTargetContext, mixinMethodNode)) {
                mixinTargetContext.addShadowMethod(mixinMethodNode);
                iterator.remove();
                continue;
            }
            if (this.attachOverwriteMethod(mixinTargetContext, mixinMethodNode)) {
                mixinTargetContext.addMixinMethod(mixinMethodNode);
                continue;
            }
            if (this.attachUniqueMethod(mixinTargetContext, mixinMethodNode)) {
                iterator.remove();
                continue;
            }
            this.attachMethod(mixinTargetContext, mixinMethodNode);
            mixinTargetContext.addMixinMethod(mixinMethodNode);
        }
    }

    protected boolean validateMethod(MixinTargetContext mixinTargetContext, MixinInfo.MixinMethodNode mixinMethodNode) {
        return (0xEFF04682 ^ 0xEFF04683) != 0;
    }

    protected boolean attachInjectorMethod(MixinTargetContext mixinTargetContext, MixinInfo.MixinMethodNode mixinMethodNode) {
        return mixinMethodNode.isInjector();
    }

    protected boolean attachAccessorMethod(MixinTargetContext mixinTargetContext, MixinInfo.MixinMethodNode mixinMethodNode) {
        return (this.attachAccessorMethod(mixinTargetContext, mixinMethodNode, SpecialMethod.ACCESSOR) || this.attachAccessorMethod(mixinTargetContext, mixinMethodNode, SpecialMethod.INVOKER) ? 0xF939AF9 ^ 0xF939AF8 : 0x52E93907 ^ 0x52E93907) != 0;
    }

    protected boolean attachAccessorMethod(MixinTargetContext mixinTargetContext, MixinInfo.MixinMethodNode mixinMethodNode, SpecialMethod specialMethod) {
        AnnotationNode annotationNode = mixinMethodNode.getVisibleAnnotation(specialMethod.annotation);
        if (annotationNode == null) {
            return (0x5E140961 ^ 0x5E140961) != 0;
        }
        String string = (Object)((Object)specialMethod) + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2\ua7eb\ua4b0\ua065\ua90d\u7d79\u8e4e\u243a") + mixinMethodNode.name;
        ClassInfo.Method method = this.getSpecialMethod(mixinMethodNode, specialMethod);
        if (MixinEnvironment.getCompatibilityLevel().isAtLeast(MixinEnvironment.CompatibilityLevel.JAVA_8) && method.isStatic()) {
            if (this.mixin.getTargets().size() > (0x140B9A84 ^ 0x140B9A85)) {
                throw new InvalidAccessorException((IMixinContext)mixinTargetContext, string + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2\ua7ef\ua4bb\ua031\ua908\u7d63\u8e46\u246e\u8b3e\u343af\ua7e7\ua4a7\ua076\ua900\u7d62\u8e0a\u2477\u8b3e\u346f{\ua7e8\ua4f5\ua078\ua916\u7d36\u8e43\u2474\u8b21\u3476~\ua7ef\ua4b1\ua03f\ua945\u7d5b\u8e43\u2462\u8b3e\u34792\ua7eb\ua4a0\ua062\ua911\u7d36\u8e42\u247b\u8b21\u34722\ua7e3\ua4ad\ua070\ua906\u7d62\u8e46\u2463\u8b77\u34262\ua7f2\ua4b4\ua063\ua902\u7d73\u8e5e\u2434"));
            }
            String string2 = mixinTargetContext.getUniqueName(mixinMethodNode, (0x5A16E84F ^ 0x5A16E84E) != 0);
            Object[] objectArray = new Object[0xF13935AB ^ 0xF13935AF];
            objectArray[0x71DB045B ^ 0x71DB045B] = mixinMethodNode.name;
            objectArray[0xACCD879B ^ 0xACCD879A] = mixinMethodNode.desc;
            objectArray[0x7948459E ^ 0x7948459C] = string2;
            objectArray[0x3E9D35BF ^ 0x3E9D35BC] = this.mixin;
            logger.log(this.mixin.getLoggingLevel(), \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("@\ua7e3\ua4bb\ua070\ua908\u7d7f\u8e44\u247d\u8b77\u3457G\ua7e8\ua4bc\ua060\ua910\u7d73\u8e0a\u2477\u8b32\u3463z\ua7e9\ua4b1\ua031\ua91e\u7d6b\u8e51\u2467\u8b77\u3463}\ua7a6\ua4ae\ua06c\ua945\u7d7f\u8e44\u243a\u8b2c\u346a"), objectArray);
            mixinMethodNode.name = method.renameTo(string2);
        } else {
            if (!method.isAbstract()) {
                throw new InvalidAccessorException((IMixinContext)mixinTargetContext, string + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2\ua7ef\ua4a6\ua031\ua90b\u7d79\u8e5e\u243a\u8b36\u3475a\ua7f2\ua4a7\ua070\ua906\u7d62"));
            }
            if (method.isStatic()) {
                throw new InvalidAccessorException((IMixinContext)mixinTargetContext, string + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2\ua7e5\ua4b4\ua07f\ua90b\u7d79\u8e5e\u243a\u8b35\u34722\ua7f5\ua4a1\ua070\ua911\u7d7f\u8e49"));
            }
        }
        mixinTargetContext.addAccessorMethod(mixinMethodNode, specialMethod.annotation);
        return (0x2F367493 ^ 0x2F367492) != 0;
    }

    protected boolean attachShadowMethod(MixinTargetContext mixinTargetContext, MixinInfo.MixinMethodNode mixinMethodNode) {
        return this.attachSpecialMethod(mixinTargetContext, mixinMethodNode, SpecialMethod.SHADOW);
    }

    protected boolean attachOverwriteMethod(MixinTargetContext mixinTargetContext, MixinInfo.MixinMethodNode mixinMethodNode) {
        return this.attachSpecialMethod(mixinTargetContext, mixinMethodNode, SpecialMethod.OVERWRITE);
    }

    protected boolean attachSpecialMethod(MixinTargetContext mixinTargetContext, MixinInfo.MixinMethodNode mixinMethodNode, SpecialMethod specialMethod) {
        AnnotationNode annotationNode = mixinMethodNode.getVisibleAnnotation(specialMethod.annotation);
        if (annotationNode == null) {
            return (0x89492F1 ^ 0x89492F1) != 0;
        }
        if (specialMethod.isOverwrite) {
            this.checkMixinNotUnique(mixinMethodNode, specialMethod);
        }
        ClassInfo.Method method = this.getSpecialMethod(mixinMethodNode, specialMethod);
        MethodNode methodNode = mixinTargetContext.findMethod(mixinMethodNode, annotationNode);
        if (methodNode == null) {
            if (specialMethod.isOverwrite) {
                return (0xB35788 ^ 0xB35788) != 0;
            }
            methodNode = mixinTargetContext.findRemappedMethod(mixinMethodNode);
            if (methodNode == null) {
                Object[] objectArray = new Object[0xE1738C10 ^ 0xE1738C16];
                objectArray[0x37A2CE75 ^ 0x37A2CE75] = specialMethod;
                objectArray[0x101929B1 ^ 0x101929B0] = mixinMethodNode.name;
                objectArray[0x36D2A6F2 ^ 0x36D2A6F0] = this.mixin;
                objectArray[0xD45AB21C ^ 0xD45AB21F] = mixinTargetContext.getTarget();
                objectArray[0x5FB41A33 ^ 0x5FB41A37] = mixinTargetContext.getReferenceMapper().getStatus();
                objectArray[0xCD51D372 ^ 0xCD51D377] = MixinPreProcessorStandard.getDynamicInfo(mixinMethodNode);
                throw new InvalidMixinException((IMixinInfo)this.mixin, String.format(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("7\ua7f5\ua4f5\ua07c\ua900\u7d62\u8e42\u2475\u8b33\u34377\ua7f5\ua4f5\ua078\ua90b\u7d36\u8e0f\u2469\u8b77\u3460s\ua7f5\ua4f5\ua07f\ua90a\u7d62\u8e0a\u2476\u8b38\u3474s\ua7f2\ua4b0\ua075\ua945\u7d7f\u8e44\u243a\u8b23\u347fw\ua7a6\ua4a1\ua070\ua917\u7d71\u8e4f\u246e\u8b77\u3474~\ua7e7\ua4a6\ua062\ua945\u7d33\u8e59\u2434\u8b77\u3432a\ua7a3\ua4a6"), objectArray));
            }
            mixinMethodNode.name = method.renameTo(methodNode.name);
        }
        if (\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b(".\ua7ef\ua4bb\ua078\ua911\u7d28").equals(methodNode.name)) {
            Object[] objectArray = new Object[0x6BEC4427 ^ 0x6BEC4425];
            objectArray[0xEFCED9F ^ 0xEFCED9F] = mixinMethodNode.name;
            objectArray[0x488AF253 ^ 0x488AF252] = this.mixin;
            throw new InvalidMixinException((IMixinInfo)this.mixin, String.format(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("\\\ua7ef\ua4b6\ua074\ua945\u7d62\u8e58\u2463\u8b76\u34377\ua7f5\ua4f5\ua078\ua90b\u7d36\u8e0f\u2469\u8b77\u3474s\ua7e8\ua4bb\ua07e\ua911\u7d36\u8e4b\u2476\u8b3e\u3476a\ua7a6\ua4b4\ua031\ua906\u7d79\u8e44\u2469\u8b23\u3465g\ua7e5\ua4a1\ua07e\ua917"), objectArray));
        }
        if (!Bytecode.compareFlags(mixinMethodNode, methodNode, 0x59F6DC41 ^ 0x59F6DC49)) {
            Object[] objectArray = new Object[0xAEE44310 ^ 0xAEE44313];
            objectArray[0xBA133445 ^ 0xBA133445] = specialMethod;
            objectArray[0x36731FB9 ^ 0x36731FB8] = mixinMethodNode.name;
            objectArray[0xE658FACA ^ 0xE658FAC8] = this.mixin;
            throw new InvalidMixinException((IMixinInfo)this.mixin, String.format(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("A\ua7d2\ua494\ua045\ua92c\u7d55\u8e0a\u2477\u8b38\u3473{\ua7e0\ua4bc\ua074\ua917\u7d36\u8e45\u247c\u8b77\u3432a\ua7a6\ua4b8\ua074\ua911\u7d7e\u8e45\u247e\u8b77\u3432a\ua7a6\ua4bc\ua07f\ua945\u7d33\u8e59\u243a\u8b33\u3478w\ua7f5\ua4f5\ua07f\ua90a\u7d62\u8e0a\u2477\u8b36\u3463q\ua7ee\ua4f5\ua065\ua90d\u7d73\u8e0a\u246e\u8b36\u3465u\ua7e3\ua4a1"), objectArray));
        }
        this.conformVisibility(mixinTargetContext, mixinMethodNode, specialMethod, methodNode);
        if (!methodNode.name.equals(mixinMethodNode.name)) {
            if (specialMethod.isOverwrite) {
                if ((methodNode.access & (0x2EC2532A ^ 0x2EC25328)) == 0) {
                    throw new InvalidMixinException((IMixinInfo)this.mixin, \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("\\\ua7e9\ua4bb\ua03c\ua915\u7d64\u8e43\u246c\u8b36\u3463w\ua7a6\ua4b8\ua074\ua911\u7d7e\u8e45\u247e\u8b77\u3474s\ua7e8\ua4bb\ua07e\ua911\u7d36\u8e48\u247f\u8b77\u3476~\ua7ef\ua4b4\ua062\ua900\u7d72\u8e04\u243a\u8b11\u3478g\ua7e8\ua4b1\ua031") + methodNode.name);
                }
            }
            mixinMethodNode.name = method.renameTo(methodNode.name);
        }
        return (0xC73B672A ^ 0xC73B672B) != 0;
    }

    private void conformVisibility(MixinTargetContext mixinTargetContext, MixinInfo.MixinMethodNode mixinMethodNode, SpecialMethod specialMethod, MethodNode methodNode) {
        Bytecode.Visibility visibility = Bytecode.getVisibility(methodNode);
        Bytecode.Visibility visibility2 = Bytecode.getVisibility(mixinMethodNode);
        if (visibility2.ordinal() >= visibility.ordinal()) {
            if (visibility == Bytecode.Visibility.PRIVATE && visibility2.ordinal() > Bytecode.Visibility.PRIVATE.ordinal()) {
                mixinTargetContext.getTarget().addUpgradedMethod(methodNode);
            }
            return;
        }
        Object[] objectArray = new Object[0x4C6E426C ^ 0x4C6E4269];
        objectArray[0xCD2C9D4B ^ 0xCD2C9D4B] = visibility2;
        objectArray[0xD146F0D6 ^ 0xD146F0D7] = specialMethod;
        objectArray[0x45171442 ^ 0x45171440] = mixinMethodNode.name;
        objectArray[0x9DE8024D ^ 0x9DE8024E] = this.mixin;
        objectArray[0x8CAF4DEE ^ 0x8CAF4DEA] = visibility;
        String string = String.format(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("7\ua7f5\ua4f5\ua034\ua916\u7d36\u8e47\u247f\u8b23\u347f}\ua7e2\ua4f5\ua034\ua916\u7d36\u8e43\u2474\u8b77\u3432a\ua7a6\ua4b6\ua070\ua90b\u7d78\u8e45\u246e\u8b77\u3465w\ua7e2\ua4a0\ua072\ua900\u7d36\u8e5c\u2473\u8b24\u347ep\ua7ef\ua4b9\ua078\ua91c\u7d36\u8e45\u247c\u8b77\u3432a\ua7a6\ua4a1\ua070\ua917\u7d71\u8e4f\u246e\u8b77\u347aw\ua7f2\ua4bd\ua07e\ua901"), objectArray);
        if (specialMethod.isOverwrite && !this.mixin.getParent().conformOverwriteVisibility()) {
            throw new InvalidMixinException((IMixinInfo)this.mixin, string);
        }
        if (visibility2 == Bytecode.Visibility.PRIVATE) {
            if (specialMethod.isOverwrite) {
                Object[] objectArray2 = new Object[0x9707F28A ^ 0x9707F28B];
                objectArray2[0x727418B2 ^ 0x727418B2] = string;
                logger.warn(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("A\ua7f2\ua4b4\ua065\ua90c\u7d75\u8e0a\u2478\u8b3e\u3479v\ua7ef\ua4bb\ua076\ua945\u7d60\u8e43\u2475\u8b3b\u3476f\ua7ef\ua4ba\ua07f\ua95f\u7d36\u8e51\u2467\u8b7b\u3437d\ua7ef\ua4a6\ua078\ua907\u7d7f\u8e46\u2473\u8b23\u346e2\ua7f1\ua4bc\ua07d\ua909\u7d36\u8e48\u247f\u8b77\u3462b\ua7e1\ua4a7\ua070\ua901\u7d73\u8e4e\u2434"), objectArray2);
            }
            mixinTargetContext.addUpgradedMethod(mixinMethodNode);
            Bytecode.setVisibility((MethodNode)mixinMethodNode, visibility);
        }
    }

    protected ClassInfo.Method getSpecialMethod(MixinInfo.MixinMethodNode mixinMethodNode, SpecialMethod specialMethod) {
        ClassInfo.Method method = this.mixin.getClassInfo().findMethod(mixinMethodNode, 0x8514EB7E ^ 0x8514EB74);
        this.checkMethodNotUnique(method, specialMethod);
        return method;
    }

    protected void checkMethodNotUnique(ClassInfo.Method method, SpecialMethod specialMethod) {
        if (method.isUnique()) {
            Object[] objectArray = new Object[0x8E431482 ^ 0x8E431481];
            objectArray[0x3F0606E7 ^ 0x3F0606E7] = specialMethod;
            objectArray[0xBC5D5B1F ^ 0xBC5D5B1E] = method.getName();
            objectArray[0x44FB5E10 ^ 0x44FB5E12] = this.mixin;
            throw new InvalidMixinException((IMixinInfo)this.mixin, String.format(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("7\ua7f5\ua4f5\ua07c\ua900\u7d62\u8e42\u2475\u8b33\u34377\ua7f5\ua4f5\ua078\ua90b\u7d36\u8e0f\u2469\u8b77\u3474s\ua7e8\ua4bb\ua07e\ua911\u7d36\u8e48\u247f\u8b77\u3457G\ua7e8\ua4bc\ua060\ua910\u7d73"), objectArray));
        }
    }

    protected void checkMixinNotUnique(MixinInfo.MixinMethodNode mixinMethodNode, SpecialMethod specialMethod) {
        if (this.mixin.isUnique()) {
            Object[] objectArray = new Object[0x16FFBBC9 ^ 0x16FFBBCA];
            objectArray[0xF48B9086 ^ 0xF48B9086] = specialMethod;
            objectArray[0x2D3826AB ^ 0x2D3826AA] = mixinMethodNode.name;
            objectArray[0xD58479AA ^ 0xD58479A8] = this.mixin;
            throw new InvalidMixinException((IMixinInfo)this.mixin, String.format(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("7\ua7f5\ua4f5\ua07c\ua900\u7d62\u8e42\u2475\u8b33\u34377\ua7f5\ua4f5\ua077\ua90a\u7d63\u8e44\u247e\u8b77\u347e|\ua7a6\ua4b4\ua031\ua925\u7d43\u8e44\u2473\u8b26\u3462w\ua7a6\ua4b8\ua078\ua91d\u7d7f\u8e44\u243a\u8b72\u3464"), objectArray));
        }
    }

    protected boolean attachUniqueMethod(MixinTargetContext mixinTargetContext, MixinInfo.MixinMethodNode mixinMethodNode) {
        String string;
        MethodNode methodNode;
        ClassInfo.Method method = this.mixin.getClassInfo().findMethod(mixinMethodNode, 0xF2082CB5 ^ 0xF2082CBF);
        if (method == null || !method.isUnique() && !this.mixin.isUnique() && !method.isSynthetic()) {
            return (0xCDDDA992 ^ 0xCDDDA992) != 0;
        }
        if (method.isSynthetic()) {
            mixinTargetContext.transformDescriptor(mixinMethodNode);
            method.remapTo(mixinMethodNode.desc);
        }
        if ((methodNode = mixinTargetContext.findMethod(mixinMethodNode, null)) == null) {
            return (0x95EDAC89 ^ 0x95EDAC89) != 0;
        }
        String string2 = string = method.isSynthetic() ? \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("a\ua7ff\ua4bb\ua065\ua90d\u7d73\u8e5e\u2473\u8b34") : \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("R\ua7d3\ua4bb\ua078\ua914\u7d63\u8e4f");
        if (Bytecode.getVisibility(mixinMethodNode).ordinal() < Bytecode.Visibility.PUBLIC.ordinal()) {
            String string3 = mixinTargetContext.getUniqueName(mixinMethodNode, (0x939C8AFE ^ 0x939C8AFE) != 0);
            Object[] objectArray = new Object[0xA67BC774 ^ 0xA67BC771];
            objectArray[0xCDE6F65B ^ 0xCDE6F65B] = string;
            objectArray[0x5BC56028 ^ 0x5BC56029] = mixinMethodNode.name;
            objectArray[0xA6495E1E ^ 0xA6495E1C] = mixinMethodNode.desc;
            objectArray[0xAA0D6BAB ^ 0xAA0D6BA8] = string3;
            objectArray[0x3EE01390 ^ 0x3EE01394] = this.mixin;
            logger.log(this.mixin.getLoggingLevel(), \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("@\ua7e3\ua4bb\ua070\ua908\u7d7f\u8e44\u247d\u8b77\u346co\ua7a6\ua4b8\ua074\ua911\u7d7e\u8e45\u247e\u8b77\u346co\ua7fd\ua4a8\ua031\ua911\u7d79\u8e0a\u2461\u8b2a\u3437{\ua7e8\ua4f5\ua06a\ua918"), objectArray);
            mixinMethodNode.name = method.renameTo(string3);
            return (0x8AF51178 ^ 0x8AF51178) != 0;
        }
        if (this.strictUnique) {
            Object[] objectArray = new Object[0xC50CFD71 ^ 0xC50CFD77];
            objectArray[0x936148F0 ^ 0x936148F0] = string;
            objectArray[0xD773C24C ^ 0xD773C24D] = mixinMethodNode.name;
            objectArray[0x4438B71B ^ 0x4438B719] = this.mixin;
            objectArray[0x6369DF00 ^ 0x6369DF03] = methodNode.name;
            objectArray[0x8C657CA1 ^ 0x8C657CA5] = methodNode.desc;
            objectArray[0x3F2AC59D ^ 0x3F2AC598] = mixinTargetContext.getTarget();
            throw new InvalidMixinException((IMixinInfo)this.mixin, String.format(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("_\ua7e3\ua4a1\ua079\ua90a\u7d72\u8e0a\u2479\u8b38\u3479t\ua7ea\ua4bc\ua072\ua911\u7d3a\u8e0a\u243f\u8b24\u3437\u007f\ua7e3\ua4a1\ua079\ua90a\u7d72\u8e0a\u243f\u8b24\u3437{\ua7e8\ua4f5\ua034\ua916\u7d36\u8e49\u247b\u8b39\u3479}\ua7f2\ua4f5\ua07e\ua913\u7d73\u8e58\u246d\u8b25\u347ef\ua7e3\ua4f5\ua034\ua916\u7d33\u8e59\u243a\u8b3e\u34792\ua7a3\ua4a6"), objectArray));
        }
        AnnotationNode annotationNode = Annotations.getVisible(mixinMethodNode, Unique.class);
        if (annotationNode == null || !Annotations.getValue(annotationNode, \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("a\ua7ef\ua4b9\ua074\ua90b\u7d62"), Boolean.FALSE).booleanValue()) {
            if (Bytecode.hasFlag(mixinMethodNode, 0xEC3463BB ^ 0xEC3463FB)) {
                try {
                    Bytecode.compareBridgeMethods(methodNode, mixinMethodNode);
                    Object[] objectArray = new Object[0xFB25B34E ^ 0xFB25B34A];
                    objectArray[0x31FCEE7F ^ 0x31FCEE7F] = string;
                    objectArray[0xB9A6E9FC ^ 0xB9A6E9FD] = mixinMethodNode.name;
                    objectArray[0x2F639975 ^ 0x2F639977] = this.mixin;
                    objectArray[0xD63CBA54 ^ 0xD63CBA57] = mixinTargetContext.getTarget();
                    logger.debug(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("V\ua7ef\ua4a6\ua072\ua904\u7d64\u8e4e\u2473\u8b39\u34702\ua7f5\ua4ac\ua065\ua90d\u7d73\u8e5e\u2473\u8b34\u3437p\ua7f4\ua4bc\ua075\ua902\u7d73\u8e0a\u2477\u8b32\u3463z\ua7e9\ua4b1\ua031\ua91e\u7d6b\u8e0a\u2473\u8b39\u3437i\ua7fb\ua4f5\ua073\ua900\u7d75\u8e4b\u246f\u8b24\u34722\ua7e3\ua4ad\ua078\ua916\u7d62\u8e43\u2474\u8b30\u3437\u007f\ua7e3\ua4a1\ua079\ua90a\u7d72\u8e0a\u2473\u8b39\u3437i\ua7fb\ua4f5\ua078\ua916\u7d36\u8e49\u2475\u8b3a\u3467s\ua7f2\ua4bc\ua073\ua909\u7d73"), objectArray);
                    return (0xED829505 ^ 0xED829504) != 0;
                }
                catch (SyntheticBridgeException syntheticBridgeException) {
                    if (this.verboseLogging || this.env.getOption(MixinEnvironment.Option.DEBUG_VERIFY)) {
                        syntheticBridgeException.printAnalysis(mixinTargetContext, methodNode, mixinMethodNode);
                    }
                    throw new InvalidMixinException((IMixinInfo)this.mixin, syntheticBridgeException.getMessage());
                }
            }
            Object[] objectArray = new Object[0x829E60E0 ^ 0x829E60E4];
            objectArray[0x86F2D2DF ^ 0x86F2D2DF] = string;
            objectArray[0x6A2F5383 ^ 0x6A2F5382] = mixinMethodNode.name;
            objectArray[0x47FD81AA ^ 0x47FD81A8] = this.mixin;
            objectArray[0xA7B05FD ^ 0xA7B05FE] = mixinTargetContext.getTarget();
            logger.warn(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("V\ua7ef\ua4a6\ua072\ua904\u7d64\u8e4e\u2473\u8b39\u34702\ua7fd\ua4a8\ua031\ua915\u7d63\u8e48\u2476\u8b3e\u34742\ua7eb\ua4b0\ua065\ua90d\u7d79\u8e4e\u243a\u8b2c\u346a2\ua7ef\ua4bb\ua031\ua91e\u7d6b\u8e0a\u2478\u8b32\u3474s\ua7f3\ua4a6\ua074\ua945\u7d7f\u8e5e\u243a\u8b36\u347b`\ua7e3\ua4b4\ua075\ua91c\u7d36\u8e4f\u2462\u8b3e\u3464f\ua7f5\ua4f5\ua078\ua90b\u7d36\u8e51\u2467"), objectArray);
            return (0x55AD2AD9 ^ 0x55AD2AD8) != 0;
        }
        mixinTargetContext.addMixinMethod(mixinMethodNode);
        return (0x94B9D8F0 ^ 0x94B9D8F1) != 0;
    }

    protected void attachMethod(MixinTargetContext mixinTargetContext, MixinInfo.MixinMethodNode mixinMethodNode) {
        MethodNode methodNode;
        ClassInfo.Method method = this.mixin.getClassInfo().findMethod(mixinMethodNode);
        if (method == null) {
            return;
        }
        ClassInfo.Method method2 = this.mixin.getClassInfo().findMethodInHierarchy(mixinMethodNode, ClassInfo.SearchType.SUPER_CLASSES_ONLY);
        if (method2 != null && method2.isRenamed()) {
            mixinMethodNode.name = method.renameTo(method2.getName());
        }
        if ((methodNode = mixinTargetContext.findMethod(mixinMethodNode, null)) != null) {
            this.conformVisibility(mixinTargetContext, mixinMethodNode, SpecialMethod.MERGE, methodNode);
        }
    }

    protected void attachFields(MixinTargetContext mixinTargetContext) {
        Iterator iterator = this.classNode.fields.iterator();
        while (iterator.hasNext()) {
            int n;
            FieldNode fieldNode = (FieldNode)iterator.next();
            AnnotationNode annotationNode = Annotations.getVisible(fieldNode, Shadow.class);
            int n2 = annotationNode != null ? 0x37799F36 ^ 0x37799F37 : (n = 0x82E8E1D0 ^ 0x82E8E1D0);
            if (!this.validateField(mixinTargetContext, fieldNode, annotationNode)) {
                iterator.remove();
                continue;
            }
            ClassInfo.Field field = this.mixin.getClassInfo().findField(fieldNode);
            mixinTargetContext.transformDescriptor(fieldNode);
            field.remapTo(fieldNode.desc);
            if (field.isUnique() && n != 0) {
                Object[] objectArray = new Object[0x17C77A1A ^ 0x17C77A1B];
                objectArray[0x9B30114E ^ 0x9B30114E] = fieldNode.name;
                throw new InvalidMixinException((IMixinInfo)this.mixin, String.format(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("R\ua7d5\ua4bd\ua070\ua901\u7d79\u8e5d\u243a\u8b31\u347ew\ua7ea\ua4b1\ua031\ua940\u7d65\u8e0a\u2479\u8b36\u3479|\ua7e9\ua4a1\ua031\ua907\u7d73\u8e0a\u245a\u8b02\u3479{\ua7f7\ua4a0\ua074"), objectArray));
            }
            FieldNode fieldNode2 = mixinTargetContext.findField(fieldNode, annotationNode);
            if (fieldNode2 == null) {
                if (annotationNode == null) continue;
                fieldNode2 = mixinTargetContext.findRemappedField(fieldNode);
                if (fieldNode2 == null) {
                    Object[] objectArray = new Object[0x51E9DB3 ^ 0x51E9DB7];
                    objectArray[0x37B5465 ^ 0x37B5465] = fieldNode.name;
                    objectArray[0xA3D9A394 ^ 0xA3D9A395] = mixinTargetContext.getTarget();
                    objectArray[0xE19FFD0B ^ 0xE19FFD09] = mixinTargetContext.getReferenceMapper().getStatus();
                    objectArray[0x81C02464 ^ 0x81C02467] = MixinPreProcessorStandard.getDynamicInfo(fieldNode);
                    throw new InvalidMixinException((IMixinInfo)this.mixin, String.format(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("A\ua7ee\ua4b4\ua075\ua90a\u7d61\u8e0a\u247c\u8b3e\u3472~\ua7e2\ua4f5\ua034\ua916\u7d36\u8e5d\u247b\u8b24\u3437|\ua7e9\ua4a1\ua031\ua909\u7d79\u8e49\u247b\u8b23\u3472v\ua7a6\ua4bc\ua07f\ua945\u7d62\u8e42\u247f\u8b77\u3463s\ua7f4\ua4b2\ua074\ua911\u7d36\u8e49\u2476\u8b36\u3464a\ua7a6\ua4f0\ua062\ua94b\u7d36\u8e0f\u2469\u8b72\u3464"), objectArray));
                }
                fieldNode.name = field.renameTo(fieldNode2.name);
            }
            if (!Bytecode.compareFlags(fieldNode, fieldNode2, 0x91DDDB0D ^ 0x91DDDB05)) {
                Object[] objectArray = new Object[0xC3FFD150 ^ 0xC3FFD152];
                objectArray[0x533D15A ^ 0x533D15A] = fieldNode.name;
                objectArray[0xAE80A45D ^ 0xAE80A45C] = this.mixin;
                throw new InvalidMixinException((IMixinInfo)this.mixin, String.format(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("A\ua7d2\ua494\ua045\ua92c\u7d55\u8e0a\u2477\u8b38\u3473{\ua7e0\ua4bc\ua074\ua917\u7d36\u8e45\u247c\u8b77\u3457A\ua7ee\ua4b4\ua075\ua90a\u7d61\u8e0a\u247c\u8b3e\u3472~\ua7e2\ua4f5\ua034\ua916\u7d36\u8e43\u2474\u8b77\u3432a\ua7a6\ua4b1\ua07e\ua900\u7d65\u8e0a\u2474\u8b38\u34632\ua7eb\ua4b4\ua065\ua906\u7d7e\u8e0a\u246e\u8b3f\u34722\ua7f2\ua4b4\ua063\ua902\u7d73\u8e5e"), objectArray));
            }
            if (field.isUnique()) {
                if ((fieldNode.access & (0xB21F3DAA ^ 0xB21F3DAC)) != 0) {
                    String string = mixinTargetContext.getUniqueName(fieldNode);
                    Object[] objectArray = new Object[0x61F3C79A ^ 0x61F3C79E];
                    objectArray[0x4A3130A2 ^ 0x4A3130A2] = fieldNode.name;
                    objectArray[0x9988E0D2 ^ 0x9988E0D3] = fieldNode.desc;
                    objectArray[0x89B706B0 ^ 0x89B706B2] = string;
                    objectArray[0x1B1D56BF ^ 0x1B1D56BC] = this.mixin;
                    logger.log(this.mixin.getLoggingLevel(), \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("@\ua7e3\ua4bb\ua070\ua908\u7d7f\u8e44\u247d\u8b77\u3457G\ua7e8\ua4bc\ua060\ua910\u7d73\u8e0a\u247c\u8b3e\u3472~\ua7e2\ua4f5\ua06a\ua918\u7d6d\u8e57\u243a\u8b23\u34782\ua7fd\ua4a8\ua031\ua90c\u7d78\u8e0a\u2461\u8b2a"), objectArray);
                    fieldNode.name = field.renameTo(string);
                    continue;
                }
                if (this.strictUnique) {
                    Object[] objectArray = new Object[0x2986712F ^ 0x2986712A];
                    objectArray[0x5190CCAB ^ 0x5190CCAB] = fieldNode.name;
                    objectArray[0xCD5BE965 ^ 0xCD5BE964] = this.mixin;
                    objectArray[0x5959CE96 ^ 0x5959CE94] = fieldNode2.name;
                    objectArray[0x6F409E6A ^ 0x6F409E69] = fieldNode2.desc;
                    objectArray[0x337464A2 ^ 0x337464A6] = mixinTargetContext.getTarget();
                    throw new InvalidMixinException((IMixinInfo)this.mixin, String.format(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("T\ua7ef\ua4b0\ua07d\ua901\u7d36\u8e49\u2475\u8b39\u3471~\ua7ef\ua4b6\ua065\ua949\u7d36\u8e6a\u244f\u8b39\u347ec\ua7f3\ua4b0\ua031\ua903\u7d7f\u8e4f\u2476\u8b33\u34377\ua7f5\ua4f5\ua078\ua90b\u7d36\u8e0f\u2469\u8b77\u3474s\ua7e8\ua4bb\ua07e\ua911\u7d36\u8e45\u246c\u8b32\u3465e\ua7f4\ua4bc\ua065\ua900\u7d36\u8e0f\u2469\u8b72\u34642\ua7ef\ua4bb\ua031\ua940\u7d65"), objectArray));
                }
                Object[] objectArray = new Object[0x260B91CC ^ 0x260B91CF];
                objectArray[0xF4F1CF57 ^ 0xF4F1CF57] = fieldNode.name;
                objectArray[0x690EA834 ^ 0x690EA835] = this.mixin;
                objectArray[0xBB7F721F ^ 0xBB7F721D] = mixinTargetContext.getTarget();
                logger.warn(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("V\ua7ef\ua4a6\ua072\ua904\u7d64\u8e4e\u2473\u8b39\u34702\ua7c6\ua480\ua07f\ua90c\u7d67\u8e5f\u247f\u8b77\u3467g\ua7e4\ua4b9\ua078\ua906\u7d36\u8e4c\u2473\u8b32\u347bv\ua7a6\ua4ae\ua06c\ua945\u7d7f\u8e44\u243a\u8b2c\u346a2\ua7e4\ua4b0\ua072\ua904\u7d63\u8e59\u247f\u8b77\u347ef\ua7a6\ua4b4\ua07d\ua917\u7d73\u8e4b\u247e\u8b2e\u3437w\ua7fe\ua4bc\ua062\ua911\u7d65\u8e0a\u2473\u8b39\u3437i\ua7fb\ua4fb\ua031\ua92b\u7d79\u8e5e\u247f\u8b77\u3463z\ua7e7\ua4a1\ua031\ua901\u7d73\u8e49\u2476\u8b36\u3465w\ua7e2\ua4f5\ua057\ua92c\u7d53\u8e66\u245e\u8b77\u345e\\\ua7cf\ua481\ua058\ua924\u7d5a\u8e63\u2449\u8b12\u3445A\ua7a6\ua4a2\ua078\ua909\u7d7a\u8e0a\u2454\u8b18\u34432\ua7e4\ua4b0\ua031\ua917\u7d73\u8e47\u2475\u8b21\u3472v\ua7a7"), objectArray);
                iterator.remove();
                continue;
            }
            if (!fieldNode2.desc.equals(fieldNode.desc)) {
                Object[] objectArray = new Object[0xFD86D3C5 ^ 0xFD86D3C4];
                objectArray[0xE9304234 ^ 0xE9304234] = fieldNode.name;
                throw new InvalidMixinException((IMixinInfo)this.mixin, String.format(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("F\ua7ee\ua4b0\ua031\ua903\u7d7f\u8e4f\u2476\u8b33\u34377\ua7f5\ua4f5\ua078\ua90b\u7d36\u8e5e\u2472\u8b32\u3437f\ua7e7\ua4a7\ua076\ua900\u7d62\u8e0a\u2479\u8b3b\u3476a\ua7f5\ua4f5\ua079\ua904\u7d65\u8e0a\u247b\u8b77\u3474}\ua7e8\ua4b3\ua07d\ua90c\u7d75\u8e5e\u2473\u8b39\u34702\ua7f5\ua4bc\ua076\ua90b\u7d77\u8e5e\u246f\u8b25\u3472"), objectArray));
            }
            if (!fieldNode2.name.equals(fieldNode.name)) {
                if ((fieldNode2.access & (0x5D41B34B ^ 0x5D41B349)) == 0) {
                    if ((fieldNode2.access & (0x7E772BFE ^ 0x7E773BFE)) == 0) {
                        throw new InvalidMixinException((IMixinInfo)this.mixin, \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("\\\ua7e9\ua4bb\ua03c\ua915\u7d64\u8e43\u246c\u8b36\u3463w\ua7a6\ua4b3\ua078\ua900\u7d7a\u8e4e\u243a\u8b34\u3476|\ua7e8\ua4ba\ua065\ua945\u7d74\u8e4f\u243a\u8b36\u347b{\ua7e7\ua4a6\ua074\ua901\u7d38\u8e0a\u245c\u8b38\u3462|\ua7e2\ua4f5") + fieldNode2.name);
                    }
                }
                fieldNode.name = field.renameTo(fieldNode2.name);
            }
            iterator.remove();
            if (n == 0) continue;
            boolean bl = field.isDecoratedFinal();
            if (this.verboseLogging) {
                if (Bytecode.hasFlag(fieldNode2, 0xFA63E419 ^ 0xFA63E409) != bl) {
                    String string = bl ? \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("R\ua7d5\ua4bd\ua070\ua901\u7d79\u8e5d\u243a\u8b31\u347ew\ua7ea\ua4b1\ua031\ua91e\u7d6b\u8e10\u2420\u8b2c\u346a2\ua7ef\ua4a6\ua031\ua901\u7d73\u8e49\u2475\u8b25\u3476f\ua7e3\ua4b1\ua031\ua912\u7d7f\u8e5e\u2472\u8b77\u3457T\ua7ef\ua4bb\ua070\ua909\u7d36\u8e48\u246f\u8b23\u3437f\ua7e7\ua4a7\ua076\ua900\u7d62\u8e0a\u2473\u8b24\u3437|\ua7e9\ua4a1\ua031\ua903\u7d7f\u8e44\u247b\u8b3b") : \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("R\ua7d5\ua4bd\ua070\ua901\u7d79\u8e5d\u243a\u8b23\u3476`\ua7e1\ua4b0\ua065\ua945\u7d6d\u8e57\u2420\u8b6d\u346co\ua7a6\ua4bc\ua062\ua945\u7d70\u8e43\u2474\u8b36\u347b2\ua7e4\ua4a0\ua065\ua945\u7d65\u8e42\u247b\u8b33\u3478e\ua7a6\ua4bc\ua062\ua945\u7d78\u8e45\u246e\u8b77\u3473w\ua7e5\ua4ba\ua063\ua904\u7d62\u8e4f\u247e\u8b77\u3460{\ua7f2\ua4bd\ua031\ua925\u7d50\u8e43\u2474\u8b36\u347b");
                    Object[] objectArray = new Object[0x26405082 ^ 0x26405080];
                    objectArray[0xB25E2CB2 ^ 0xB25E2CB2] = this.mixin;
                    objectArray[0xAD933AE2 ^ 0xAD933AE3] = fieldNode.name;
                    logger.warn(string, objectArray);
                }
            }
            mixinTargetContext.addShadowField(fieldNode, field);
        }
    }

    protected boolean validateField(MixinTargetContext mixinTargetContext, FieldNode fieldNode, AnnotationNode annotationNode) {
        String string;
        if (Bytecode.hasFlag(fieldNode, 0xB92EF3E1 ^ 0xB92EF3E9)) {
            if (!Bytecode.hasFlag(fieldNode, 0xE338FEED ^ 0xE338FEEF)) {
                if (!Bytecode.hasFlag(fieldNode, 0x7A71F334 ^ 0x7A71E334) && annotationNode == null) {
                    Object[] objectArray = new Object[0x79DA53E7 ^ 0x79DA53E4];
                    objectArray[0x264AED77 ^ 0x264AED77] = mixinTargetContext;
                    objectArray[0x9A5290A9 ^ 0x9A5290A8] = fieldNode.name;
                    objectArray[0x9ECDF810 ^ 0x9ECDF812] = fieldNode.desc;
                    throw new InvalidMixinException((IMixinContext)mixinTargetContext, String.format(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("_\ua7ef\ua4ad\ua078\ua90b\u7d36\u8e0f\u2469\u8b77\u3474}\ua7e8\ua4a1\ua070\ua90c\u7d78\u8e59\u243a\u8b39\u3478|\ua7ab\ua4a5\ua063\ua90c\u7d60\u8e4b\u246e\u8b32\u3437a\ua7f2\ua4b4\ua065\ua90c\u7d75\u8e0a\u247c\u8b3e\u3472~\ua7e2\ua4f5\ua034\ua916\u7d2c\u8e0f\u2469"), objectArray));
                }
            }
        }
        if (fieldNode.name.startsWith(string = (String)Annotations.getValue(annotationNode, \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("b\ua7f4\ua4b0\ua077\ua90c\u7d6e"), Shadow.class))) {
            Object[] objectArray = new Object[0x2A9D8EDA ^ 0x2A9D8ED8];
            objectArray[0xEA5C3A01 ^ 0xEA5C3A01] = mixinTargetContext;
            objectArray[0x2EFCDA32 ^ 0x2EFCDA33] = fieldNode.name;
            throw new InvalidMixinException((IMixinContext)mixinTargetContext, String.format(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("R\ua7d5\ua4bd\ua070\ua901\u7d79\u8e5d\u243a\u8b31\u347ew\ua7ea\ua4b1\ua031\ua940\u7d65\u8e04\u243f\u8b24\u3437z\ua7e7\ua4a6\ua031\ua904\u7d36\u8e59\u2472\u8b36\u3473}\ua7f1\ua4f5\ua061\ua917\u7d73\u8e4c\u2473\u8b2f\u34392\ua7d2\ua4bd\ua078\ua916\u7d36\u8e43\u2469\u8b77\u3479}\ua7f2\ua4f5\ua070\ua909\u7d7a\u8e45\u246d\u8b32\u3473<"), objectArray));
        }
        if (\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("a\ua7f3\ua4a5\ua074\ua917\u7d32").equals(fieldNode.name)) {
            if (fieldNode.access != (0x7E6275E2 ^ 0x7E6275E0)) {
                Object[] objectArray = new Object[0x4FC4E9B1 ^ 0x4FC4E9B3];
                objectArray[0x3704336A ^ 0x3704336A] = mixinTargetContext;
                objectArray[0x76F05331 ^ 0x76F05330] = fieldNode.name;
                throw new InvalidMixinException((IMixinInfo)this.mixin, String.format(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("[\ua7eb\ua4b4\ua076\ua90c\u7d78\u8e4b\u2468\u8b2e\u3437a\ua7f3\ua4a5\ua074\ua917\u7d36\u8e4c\u2473\u8b32\u347bv\ua7a6\ua4f0\ua062\ua94b\u7d33\u8e59\u243a\u8b3a\u3462a\ua7f2\ua4f5\ua073\ua900\u7d36\u8e5a\u2468\u8b3e\u3461s\ua7f2\ua4b0\ua031\ua904\u7d78\u8e4e\u243a\u8b39\u3478|\ua7ab\ua4b3\ua078\ua90b\u7d77\u8e46"), objectArray));
            }
            if (!fieldNode.desc.equals(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("^") + this.mixin.getClassRef() + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b(")"))) {
                Object[] objectArray = new Object[0xF9FB293B ^ 0xF9FB2938];
                objectArray[0x7F2B3131 ^ 0x7F2B3131] = mixinTargetContext;
                objectArray[0x7CD6F6A3 ^ 0x7CD6F6A2] = fieldNode.name;
                objectArray[0x90F20C1F ^ 0x90F20C1D] = this.mixin.getClassName();
                throw new InvalidMixinException((IMixinInfo)this.mixin, String.format(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("[\ua7eb\ua4b4\ua076\ua90c\u7d78\u8e4b\u2468\u8b2e\u3437a\ua7f3\ua4a5\ua074\ua917\u7d36\u8e4c\u2473\u8b32\u347bv\ua7a6\ua4f0\ua062\ua94b\u7d33\u8e59\u243a\u8b3a\u3462a\ua7f2\ua4f5\ua079\ua904\u7d60\u8e4f\u243a\u8b23\u347fw\ua7a6\ua4a6\ua070\ua908\u7d73\u8e0a\u246e\u8b2e\u3467w\ua7a6\ua4b4\ua062\ua945\u7d62\u8e42\u247f\u8b77\u3467s\ua7f4\ua4b0\ua07f\ua911\u7d36\u8e47\u2473\u8b2f\u347e|\ua7a6\ua4fd\ua034\ua916\u7d3f"), objectArray));
            }
            return (0x62F561A7 ^ 0x62F561A7) != 0;
        }
        return (0xAD8BD0E9 ^ 0xAD8BD0E8) != 0;
    }

    protected void transform(MixinTargetContext mixinTargetContext) {
        for (MethodNode methodNode : this.classNode.methods) {
            ListIterator<AbstractInsnNode> listIterator = methodNode.instructions.iterator();
            while (listIterator.hasNext()) {
                AbstractInsnNode abstractInsnNode = (AbstractInsnNode)listIterator.next();
                if (abstractInsnNode instanceof MethodInsnNode) {
                    this.transformMethod((MethodInsnNode)abstractInsnNode);
                    continue;
                }
                if (!(abstractInsnNode instanceof FieldInsnNode)) continue;
                this.transformField((FieldInsnNode)abstractInsnNode);
            }
        }
    }

    protected void transformMethod(MethodInsnNode methodInsnNode) {
        Profiler.Section section = this.profiler.begin(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("\u007f\ua7e3\ua4a1\ua070"));
        ClassInfo classInfo = ClassInfo.forName(methodInsnNode.owner);
        if (classInfo == null) {
            throw new RuntimeException(new ClassNotFoundException(methodInsnNode.owner.replace((char)(0x559254A9 ^ 0x55925486), (char)(0xD0A04CA4 ^ 0xD0A04C8A))));
        }
        ClassInfo.Method method = classInfo.findMethodInHierarchy(methodInsnNode, ClassInfo.SearchType.ALL_CLASSES, 0xAF43896 ^ 0xAF43894);
        section.end();
        if (method != null && method.isRenamed()) {
            methodInsnNode.name = method.getName();
        }
    }

    protected void transformField(FieldInsnNode fieldInsnNode) {
        Profiler.Section section = this.profiler.begin(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("\u007f\ua7e3\ua4a1\ua070"));
        ClassInfo classInfo = ClassInfo.forName(fieldInsnNode.owner);
        if (classInfo == null) {
            throw new RuntimeException(new ClassNotFoundException(fieldInsnNode.owner.replace((char)(0xAFFCDEFB ^ 0xAFFCDED4), (char)(0x3DB58132 ^ 0x3DB5811C))));
        }
        ClassInfo.Field field = classInfo.findField(fieldInsnNode, 0xD01C3D7D ^ 0xD01C3D7F);
        section.end();
        if (field != null && field.isRenamed()) {
            fieldInsnNode.name = field.getName();
        }
    }

    protected static String getDynamicInfo(MethodNode methodNode) {
        return MixinPreProcessorStandard.getDynamicInfo(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("_\ua7e3\ua4a1\ua079\ua90a\u7d72"), Annotations.getInvisible(methodNode, Dynamic.class));
    }

    protected static String getDynamicInfo(FieldNode fieldNode) {
        return MixinPreProcessorStandard.getDynamicInfo(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("T\ua7ef\ua4b0\ua07d\ua901"), Annotations.getInvisible(fieldNode, Dynamic.class));
    }

    private static String getDynamicInfo(String string, AnnotationNode annotationNode) {
        String string2;
        String string3 = Strings.nullToEmpty((String)((String)Annotations.getValue(annotationNode)));
        Type type = (Type)Annotations.getValue(annotationNode, \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("\u007f\ua7ef\ua4ad\ua078\ua90b"));
        if (type != null) {
            Object[] objectArray = new Object[0xB2F16903 ^ 0xB2F16901];
            objectArray[0xE4E4DF67 ^ 0xE4E4DF67] = type.getClassName();
            objectArray[0xADEC9C6B ^ 0xADEC9C6A] = string3;
            string3 = String.format(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("i\ua7a3\ua4a6\ua06c\ua945\u7d33\u8e59"), objectArray).trim();
        }
        if (string3.length() > 0) {
            Object[] objectArray = new Object[0x72AAC107 ^ 0x72AAC105];
            objectArray[0x383D6C12 ^ 0x383D6C12] = string;
            objectArray[0x5B983CEB ^ 0x5B983CEA] = string3;
            string2 = String.format(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2\ua7a3\ua4a6\ua031\ua90c\u7d65\u8e0a\u245a\u8b13\u346e|\ua7e7\ua4b8\ua078\ua906\u7d3e\u8e0f\u2469\u8b7e"), objectArray);
        } else {
            string2 = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("");
        }
        return string2;
    }

    static final class SpecialMethod
    extends Enum<SpecialMethod> {
        public static final /* enum */ SpecialMethod MERGE = new SpecialMethod((0x7AF9C66C ^ 0x7AF9C66D) != 0);
        public static final /* enum */ SpecialMethod OVERWRITE = new SpecialMethod((0x1B832421 ^ 0x1B832420) != 0, Overwrite.class);
        public static final /* enum */ SpecialMethod SHADOW = new SpecialMethod((0xC5C86303 ^ 0xC5C86303) != 0, Shadow.class);
        public static final /* enum */ SpecialMethod ACCESSOR = new SpecialMethod((0x176EEE31 ^ 0x176EEE31) != 0, Accessor.class);
        public static final /* enum */ SpecialMethod INVOKER = new SpecialMethod((0x9AE31190 ^ 0x9AE31190) != 0, Invoker.class);
        final boolean isOverwrite;
        final Class<? extends Annotation> annotation;
        final String description;
        private static final /* synthetic */ SpecialMethod[] $VALUES;

        public static SpecialMethod[] values() {
            return (SpecialMethod[])$VALUES.clone();
        }

        public static SpecialMethod valueOf(String string) {
            return Enum.valueOf(SpecialMethod.class, string);
        }

        private SpecialMethod(boolean bl, Class<? extends Annotation> clazz) {
            this.isOverwrite = bl;
            this.annotation = clazz;
            this.description = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("R") + Bytecode.getSimpleName(clazz);
        }

        private SpecialMethod(boolean bl) {
            this.isOverwrite = bl;
            this.annotation = null;
            this.description = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("}\ua7f0\ua4b0\ua063\ua912\u7d64\u8e43\u246e\u8b32");
        }

        public String toString() {
            return this.description;
        }

        static {
            SpecialMethod[] specialMethodArray = new SpecialMethod[0x75219F4 ^ 0x75219F1];
            specialMethodArray[0x4D457292 ^ 0x4D457292] = MERGE;
            specialMethodArray[0xA33FD82A ^ 0xA33FD82B] = OVERWRITE;
            specialMethodArray[0xCDAFE8D4 ^ 0xCDAFE8D6] = SHADOW;
            specialMethodArray[0xFEBDD0A4 ^ 0xFEBDD0A7] = ACCESSOR;
            specialMethodArray[0x27A8A74D ^ 0x27A8A749] = INVOKER;
            $VALUES = specialMethodArray;
        }
    }
}

