/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.UUID;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.Mixins;
import org.spongepowered.asm.mixin.extensibility.IMixinConfig;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinErrorHandler;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.injection.invoke.arg.ArgsClassGenerator;
import org.spongepowered.asm.mixin.throwables.ClassAlreadyLoadedException;
import org.spongepowered.asm.mixin.throwables.MixinApplyError;
import org.spongepowered.asm.mixin.throwables.MixinException;
import org.spongepowered.asm.mixin.throwables.MixinPrepareError;
import org.spongepowered.asm.mixin.transformer.Config;
import org.spongepowered.asm.mixin.transformer.InnerClassGenerator;
import org.spongepowered.asm.mixin.transformer.MixinConfig;
import org.spongepowered.asm.mixin.transformer.MixinInfo;
import org.spongepowered.asm.mixin.transformer.MixinPostProcessor;
import org.spongepowered.asm.mixin.transformer.TargetClassContext;
import org.spongepowered.asm.mixin.transformer.ext.Extensions;
import org.spongepowered.asm.mixin.transformer.ext.IClassGenerator;
import org.spongepowered.asm.mixin.transformer.ext.IHotSwap;
import org.spongepowered.asm.mixin.transformer.ext.extensions.ExtensionCheckClass;
import org.spongepowered.asm.mixin.transformer.ext.extensions.ExtensionCheckInterfaces;
import org.spongepowered.asm.mixin.transformer.ext.extensions.ExtensionClassExporter;
import org.spongepowered.asm.mixin.transformer.throwables.InvalidMixinException;
import org.spongepowered.asm.mixin.transformer.throwables.MixinTransformerError;
import org.spongepowered.asm.service.IMixinService;
import org.spongepowered.asm.service.ITransformer;
import org.spongepowered.asm.service.MixinService;
import org.spongepowered.asm.transformers.TreeTransformer;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.asm.util.ReEntranceLock;
import org.spongepowered.asm.util.perf.Profiler;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2;

public class MixinTransformer
extends TreeTransformer {
    private static final String MIXIN_AGENT_CLASS = "org.spongepowered.tools.agent.MixinAgent";
    private static final String METRONOME_AGENT_CLASS = "org.spongepowered.metronome.Agent";
    static final Logger logger = LogManager.getLogger((String)\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("\u007f\ua7ef\ua4ad\ua078\ua90b"));
    private final IMixinService service = MixinService.getService();
    private final List<MixinConfig> configs = new ArrayList<MixinConfig>();
    private final List<MixinConfig> pendingConfigs = new ArrayList<MixinConfig>();
    private final ReEntranceLock lock;
    private final String sessionId = UUID.randomUUID().toString();
    private final Extensions extensions;
    private final IHotSwap hotSwapper;
    private final MixinPostProcessor postProcessor;
    private final Profiler profiler;
    private MixinEnvironment currentEnvironment;
    private Level verboseLoggingLevel = Level.DEBUG;
    private boolean errorState = 0xD1F03EAC ^ 0xD1F03EAC;
    private int transformedCount = 0x748FE530 ^ 0x748FE530;

    MixinTransformer() {
        MixinEnvironment mixinEnvironment = MixinEnvironment.getCurrentEnvironment();
        Object object = mixinEnvironment.getActiveTransformer();
        if (object instanceof ITransformer) {
            throw new MixinException(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("F\ua7e3\ua4a7\ua07c\ua90c\u7d78\u8e4b\u246e\u8b3e\u3479u\ua7a6\ua498\ua078\ua91d\u7d7f\u8e44\u244e\u8b25\u3476|\ua7f5\ua4b3\ua07e\ua917\u7d7b\u8e4f\u2468\u8b77\u347e|\ua7f5\ua4a1\ua070\ua90b\u7d75\u8e4f\u243a") + this);
        }
        mixinEnvironment.setActiveTransformer(this);
        this.lock = this.service.getReEntranceLock();
        this.extensions = new Extensions(this);
        this.hotSwapper = this.initHotSwapper(mixinEnvironment);
        this.postProcessor = new MixinPostProcessor();
        this.extensions.add(new ArgsClassGenerator());
        this.extensions.add(new InnerClassGenerator());
        this.extensions.add(new ExtensionClassExporter(mixinEnvironment));
        this.extensions.add(new ExtensionCheckClass());
        this.extensions.add(new ExtensionCheckInterfaces());
        this.profiler = MixinEnvironment.getProfiler();
    }

    private IHotSwap initHotSwapper(MixinEnvironment mixinEnvironment) {
        if (!mixinEnvironment.getOption(MixinEnvironment.Option.HOT_SWAP)) {
            return null;
        }
        try {
            logger.info(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("S\ua7f2\ua4a1\ua074\ua908\u7d66\u8e5e\u2473\u8b39\u34702\ua7f2\ua4ba\ua031\ua909\u7d79\u8e4b\u247e\u8b77\u345f}\ua7f2\ua4f8\ua042\ua912\u7d77\u8e5a\u243a\u8b36\u3470w\ua7e8\ua4a1"));
            Class<?> clazz = Class.forName(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("}\ua7f4\ua4b2\ua03f\ua916\u7d66\u8e45\u2474\u8b30\u3472b\ua7e9\ua4a2\ua074\ua917\u7d73\u8e4e\u2434\u8b23\u3478}\ua7ea\ua4a6\ua03f\ua904\u7d71\u8e4f\u2474\u8b23\u3439_\ua7ef\ua4ad\ua078\ua90b\u7d57\u8e4d\u247f\u8b39\u3463"));
            Class[] classArray = new Class[0xA0AB7F7C ^ 0xA0AB7F7D];
            classArray[0x440376E8 ^ 0x440376E8] = MixinTransformer.class;
            Constructor<?> constructor = clazz.getDeclaredConstructor(classArray);
            Object[] objectArray = new Object[0x99A375FB ^ 0x99A375FA];
            objectArray[0x7D0CAE44 ^ 0x7D0CAE44] = this;
            return (IHotSwap)constructor.newInstance(objectArray);
        }
        catch (Throwable throwable) {
            Object[] objectArray = new Object[0x14F2C9C ^ 0x14F2C9E];
            objectArray[0x210C114A ^ 0x210C114A] = throwable.getClass().getSimpleName();
            objectArray[0x493E24F9 ^ 0x493E24F8] = throwable.getMessage();
            logger.info(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("Z\ua7e9\ua4a1\ua03c\ua916\u7d61\u8e4b\u246a\u8b77\u3476u\ua7e3\ua4bb\ua065\ua945\u7d75\u8e45\u246f\u8b3b\u34732\ua7e8\ua4ba\ua065\ua945\u7d74\u8e4f\u243a\u8b3b\u3478s\ua7e2\ua4b0\ua075\ua949\u7d36\u8e42\u2475\u8b23\u3437a\ua7f1\ua4b4\ua061\ua915\u7d7f\u8e44\u247d\u8b77\u3478t\ua7a6\ua4b8\ua078\ua91d\u7d7f\u8e44\u2469\u8b77\u3460}\ua7e8\ua4f2\ua065\ua945\u7d61\u8e45\u2468\u8b3c\u34392\ua7fd\ua4a8\ua02b\ua945\u7d6d\u8e57"), objectArray);
            return null;
        }
    }

    public void audit(MixinEnvironment mixinEnvironment) {
        HashSet<String> hashSet = new HashSet<String>();
        for (MixinConfig iterator : this.configs) {
            hashSet.addAll(iterator.getUnhandledTargets());
        }
        Logger logger = LogManager.getLogger((String)\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("\u007f\ua7ef\ua4ad\ua078\ua90b\u7d39\u8e4b\u246f\u8b33\u347ef"));
        for (String string : hashSet) {
            try {
                Object[] objectArray = new Object[0xB54C0821 ^ 0xB54C0820];
                objectArray[0x5C05BABE ^ 0x5C05BABE] = string;
                logger.info(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("T\ua7e9\ua4a7\ua072\ua900\u7d3b\u8e46\u2475\u8b36\u3473{\ua7e8\ua4b2\ua031\ua906\u7d7a\u8e4b\u2469\u8b24\u3437i\ua7fb"), objectArray);
                this.service.getClassProvider().findClass(string, (0x1EE8513B ^ 0x1EE8513A) != 0);
            }
            catch (ClassNotFoundException classNotFoundException) {
                logger.error(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("Q\ua7e9\ua4a0\ua07d\ua901\u7d36\u8e44\u2475\u8b23\u3437t\ua7e9\ua4a7\ua072\ua900\u7d3b\u8e46\u2475\u8b36\u34732") + string, (Throwable)classNotFoundException);
            }
        }
        for (MixinConfig mixinConfig : this.configs) {
            for (String string : mixinConfig.getUnhandledTargets()) {
                ClassAlreadyLoadedException classAlreadyLoadedException = new ClassAlreadyLoadedException(string + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2\ua7f1\ua4b4\ua062\ua945\u7d77\u8e46\u2468\u8b32\u3476v\ua7ff\ua4f5\ua072\ua909\u7d77\u8e59\u2469\u8b3b\u3478s\ua7e2\ua4b0\ua075"));
                logger.error(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("Q\ua7e9\ua4a0\ua07d\ua901\u7d36\u8e44\u2475\u8b23\u3437t\ua7e9\ua4a7\ua072\ua900\u7d3b\u8e46\u2475\u8b36\u34732") + string, (Throwable)classAlreadyLoadedException);
            }
        }
        if (mixinEnvironment.getOption(MixinEnvironment.Option.DEBUG_PROFILER)) {
            this.printProfilerSummary();
        }
    }

    private void printProfilerSummary() {
        DecimalFormat decimalFormat = new DecimalFormat(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b(":\ua7a5\ua4f6\ua032\ua955\u7d38\u8e1a\u242a\u8b67"));
        DecimalFormat decimalFormat2 = new DecimalFormat(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b(":\ua7a5\ua4f6\ua032\ua955\u7d38\u8e1a"));
        PrettyPrinter prettyPrinter = this.profiler.printer((0x5327BB5 ^ 0x5327BB5) != 0, (0xEC5214DB ^ 0xEC5214DB) != 0);
        long l = this.profiler.get(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("\u007f\ua7ef\ua4ad\ua078\ua90b\u7d38\u8e5a\u2468\u8b32\u3467s\ua7f4\ua4b0")).getTotalTime();
        long l2 = this.profiler.get(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("\u007f\ua7ef\ua4ad\ua078\ua90b\u7d38\u8e58\u247f\u8b36\u3473")).getTotalTime();
        long l3 = this.profiler.get(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("\u007f\ua7ef\ua4ad\ua078\ua90b\u7d38\u8e4b\u246a\u8b27\u347bk")).getTotalTime();
        long l4 = this.profiler.get(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("\u007f\ua7ef\ua4ad\ua078\ua90b\u7d38\u8e5d\u2468\u8b3e\u3463w")).getTotalTime();
        long l5 = this.profiler.get(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("\u007f\ua7ef\ua4ad\ua078\ua90b")).getTotalTime();
        long l6 = this.profiler.get(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("q\ua7ea\ua4b4\ua062\ua916\u7d38\u8e46\u2475\u8b36\u3473")).getTotalTime();
        long l7 = this.profiler.get(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("q\ua7ea\ua4b4\ua062\ua916\u7d38\u8e5e\u2468\u8b36\u3479a\ua7e0\ua4ba\ua063\ua908")).getTotalTime();
        long l8 = this.profiler.get(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("\u007f\ua7ef\ua4ad\ua078\ua90b\u7d38\u8e4e\u247f\u8b35\u3462u\ua7a8\ua4b0\ua069\ua915\u7d79\u8e58\u246e")).getTotalTime();
        long l9 = l5 - l6 - l7 - l8;
        double d = (double)l9 / (double)l5 * 100.0;
        double d2 = (double)l6 / (double)l5 * 100.0;
        double d3 = (double)l7 / (double)l5 * 100.0;
        double d4 = (double)l8 / (double)l5 * 100.0;
        long l10 = 0x267BE6C5D92C2698L ^ 0x267BE6C5D92C2698L;
        Profiler.Section section = null;
        for (Profiler.Section object : this.profiler.getSections()) {
            long method = object.getName().startsWith(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("q\ua7ea\ua4b4\ua062\ua916\u7d38\u8e5e\u2468\u8b36\u3479a\ua7e0\ua4ba\ua063\ua908\u7d38")) ? object.getTotalTime() : 0x71FA04A4BB8DB714L ^ 0x71FA04A4BB8DB714L;
            if (method <= l10) continue;
            l10 = method;
            section = object;
        }
        prettyPrinter.hr().add(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("A\ua7f3\ua4b8\ua07c\ua904\u7d64\u8e53")).hr().add();
        String string = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("7\ua7bf\ua4b1\ua031\ua908\u7d65\u8e0a\u243f\u8b66\u3425a\ua7a6\ua4a6\ua074\ua906\u7d79\u8e44\u247e\u8b24\u343e");
        Object[] objectArray = new Object[0x8CBE3D60 ^ 0x8CBE3D62];
        objectArray[0xD11263E3 ^ 0xD11263E3] = l5;
        objectArray[0xC9F93DF0 ^ 0xC9F93DF1] = decimalFormat.format((double)l5 * 0.001);
        prettyPrinter.kv(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("F\ua7e9\ua4a1\ua070\ua909\u7d36\u8e47\u2473\u8b2f\u347e|\ua7a6\ua4a1\ua078\ua908\u7d73"), string, objectArray).add();
        Object[] objectArray2 = new Object[0x4DDE3FBD ^ 0x4DDE3FBF];
        objectArray2[0x3BDAA26D ^ 0x3BDAA26D] = l;
        objectArray2[0x86BAB2C9 ^ 0x86BAB2C8] = decimalFormat.format((double)l * 0.001);
        prettyPrinter.kv(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("B\ua7f4\ua4b0\ua061\ua904\u7d64\u8e43\u2474\u8b30\u3437\u007f\ua7ef\ua4ad\ua078\ua90b\u7d65"), string, objectArray2);
        Object[] objectArray3 = new Object[0xB9BE62AF ^ 0xB9BE62AD];
        objectArray3[0xAB5CEC03 ^ 0xAB5CEC03] = l2;
        objectArray3[0x871F794E ^ 0x871F794F] = decimalFormat.format((double)l2 * 0.001);
        prettyPrinter.kv(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("@\ua7e3\ua4b4\ua075\ua90c\u7d78\u8e4d\u243a\u8b3e\u3479b\ua7f3\ua4a1"), string, objectArray3);
        Object[] objectArray4 = new Object[0xC5700DC9 ^ 0xC5700DCB];
        objectArray4[0xA08D5900 ^ 0xA08D5900] = l3;
        objectArray4[0xED61DA85 ^ 0xED61DA84] = decimalFormat.format((double)l3 * 0.001);
        prettyPrinter.kv(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("S\ua7f6\ua4a5\ua07d\ua91c\u7d7f\u8e44\u247d\u8b77\u347a{\ua7fe\ua4bc\ua07f\ua916"), string, objectArray4);
        Object[] objectArray5 = new Object[0x7F2A632B ^ 0x7F2A6329];
        objectArray5[0xC9E9B11C ^ 0xC9E9B11C] = l4;
        objectArray5[0x4D601719 ^ 0x4D601718] = decimalFormat.format((double)l4 * 0.001);
        prettyPrinter.kv(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("E\ua7f4\ua4bc\ua065\ua90c\u7d78\u8e4d\u243a\u8b38\u3462f\ua7f6\ua4a0\ua065"), string, objectArray5).add();
        prettyPrinter.kv(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("}\ua7e0\ua4f5\ua066\ua90d\u7d7f\u8e49\u2472"), \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b(""));
        Object[] objectArray6 = new Object[0x70B95647 ^ 0x70B95645];
        objectArray6[0x4274CF9B ^ 0x4274CF9B] = l6;
        objectArray6[0x3F212D62 ^ 0x3F212D63] = decimalFormat.format((double)l6 * 0.001);
        prettyPrinter.kv(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("F\ua7ef\ua4b8\ua074\ua945\u7d65\u8e5a\u247f\u8b39\u34632\ua7ea\ua4ba\ua070\ua901\u7d7f\u8e44\u247d\u8b77\u3471`\ua7e9\ua4b8\ua031\ua901\u7d7f\u8e59\u2471"), string, objectArray6);
        Object[] objectArray7 = new Object[0xE709C5CF ^ 0xE709C5CD];
        objectArray7[0xC969263F ^ 0xC969263F] = l7;
        objectArray7[0xC78CF2C4 ^ 0xC78CF2C5] = decimalFormat.format((double)l7 * 0.001);
        prettyPrinter.kv(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("F\ua7ef\ua4b8\ua074\ua945\u7d65\u8e5a\u247f\u8b39\u34632\ua7f2\ua4a7\ua070\ua90b\u7d65\u8e4c\u2475\u8b25\u347a{\ua7e8\ua4b2\ua031\ua906\u7d7a\u8e4b\u2469\u8b24\u3472a"), string, objectArray7).add();
        if (section != null) {
            prettyPrinter.kv(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("E\ua7e9\ua4a7\ua062\ua911\u7d36\u8e5e\u2468\u8b36\u3479a\ua7e0\ua4ba\ua063\ua908\u7d73\u8e58"), section.getName());
            prettyPrinter.kv(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("Q\ua7ea\ua4b4\ua062\ua916"), section.getInfo());
            Object[] objectArray8 = new Object[0xC8E86B15 ^ 0xC8E86B14];
            objectArray8[0xDFE6CEAC ^ 0xDFE6CEAC] = section.getTotalSeconds();
            prettyPrinter.kv(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("F\ua7ef\ua4b8\ua074\ua945\u7d65\u8e5a\u247f\u8b39\u3463"), \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("7\ua7f5\ua4f5\ua062\ua900\u7d75\u8e45\u2474\u8b33\u3464"), objectArray8);
            Object[] objectArray9 = new Object[0xAB66022F ^ 0xAB66022E];
            objectArray9[0x5F13A085 ^ 0x5F13A085] = section.getTotalCount();
            prettyPrinter.kv(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("q\ua7e7\ua4b9\ua07d\ua900\u7d72"), \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("7\ua7e2\ua4f5\ua065\ua90c\u7d7b\u8e4f\u2469"), objectArray9).add();
        }
        Object[] objectArray10 = new Object[0x27ACCB40 ^ 0x27ACCB42];
        objectArray10[0xBE5681B ^ 0xBE5681B] = l9;
        objectArray10[0x3B10299D ^ 0x3B10299C] = decimalFormat2.format(d);
        prettyPrinter.kv(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2\ua7a6\ua4f5\ua045\ua90c\u7d7b\u8e4f\u243a\u8b36\u347b~\ua7e9\ua4b6\ua070\ua911\u7d7f\u8e45\u2474\u8b6d\u34372\ua7a6\ua4f5\ua031\ua935\u7d64\u8e45\u2479\u8b32\u3464a\ua7ef\ua4bb\ua076\ua945\u7d7b\u8e43\u2462\u8b3e\u3479a"), \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("7\ua7bf\ua4b1\ua031\ua908\u7d65\u8e0a\u243f\u8b66\u3427a\ua7a3\ua4f0\ua031\ua90a\u7d70\u8e0a\u246e\u8b38\u3463s\ua7ea\ua4fc"), objectArray10);
        Object[] objectArray11 = new Object[0x9A7CDDEC ^ 0x9A7CDDEE];
        objectArray11[0x5297E9C2 ^ 0x5297E9C2] = l6;
        objectArray11[0xCC1709AA ^ 0xCC1709AB] = decimalFormat2.format(d2);
        prettyPrinter.kv(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("^\ua7e9\ua4b4\ua075\ua90c\u7d78\u8e4d\u243a\u8b34\u347bs\ua7f5\ua4a6\ua074\ua916"), \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("7\ua7bf\ua4b1\ua031\ua908\u7d65\u8e0a\u243f\u8b66\u3427a\ua7a3\ua4f0\ua031\ua90a\u7d70\u8e0a\u246e\u8b38\u3463s\ua7ea\ua4fc"), objectArray11);
        Object[] objectArray12 = new Object[0x3317A370 ^ 0x3317A372];
        objectArray12[0x9EE7BCEF ^ 0x9EE7BCEF] = l7;
        objectArray12[0x4C65C567 ^ 0x4C65C566] = decimalFormat2.format(d3);
        prettyPrinter.kv(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("@\ua7f3\ua4bb\ua07f\ua90c\u7d78\u8e4d\u243a\u8b23\u3465s\ua7e8\ua4a6\ua077\ua90a\u7d64\u8e47\u247f\u8b25\u3464"), \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("7\ua7bf\ua4b1\ua031\ua908\u7d65\u8e0a\u243f\u8b66\u3427a\ua7a3\ua4f0\ua031\ua90a\u7d70\u8e0a\u246e\u8b38\u3463s\ua7ea\ua4fc"), objectArray12);
        if (l8 > (0xA24A78BA3E993F23L ^ 0xA24A78BA3E993F23L)) {
            Object[] objectArray13 = new Object[0x4BA2F608 ^ 0x4BA2F60A];
            objectArray13[0xCFC9CA59 ^ 0xCFC9CA59] = l8;
            objectArray13[0x55E291D2 ^ 0x55E291D3] = decimalFormat2.format(d4);
            prettyPrinter.kv(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("W\ua7fe\ua4a5\ua07e\ua917\u7d62\u8e43\u2474\u8b30\u3437q\ua7ea\ua4b4\ua062\ua916\u7d73\u8e59\u243a\u8b7f\u3473w\ua7e4\ua4a0\ua076\ua94c"), \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("7\ua7bf\ua4b1\ua031\ua908\u7d65\u8e0a\u243f\u8b66\u3427a\ua7a3\ua4f0\ua031\ua90a\u7d70\u8e0a\u246e\u8b38\u3463s\ua7ea\ua4fc"), objectArray13);
        }
        prettyPrinter.add();
        try {
            Class<?> throwable = this.service.getClassProvider().findAgentClass(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("}\ua7f4\ua4b2\ua03f\ua916\u7d66\u8e45\u2474\u8b30\u3472b\ua7e9\ua4a2\ua074\ua917\u7d73\u8e4e\u2434\u8b3a\u3472f\ua7f4\ua4ba\ua07f\ua90a\u7d7b\u8e4f\u2434\u8b16\u3470w\ua7e8\ua4a1"), (0x97BC32C ^ 0x97BC32C) != 0);
            Method method = throwable.getDeclaredMethod(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("u\ua7e3\ua4a1\ua045\ua90c\u7d7b\u8e4f\u2469"), new Class[0xCF9A8EEE ^ 0xCF9A8EEE]);
            Map map = (Map)method.invoke(null, new Object[0x69392458 ^ 0x69392458]);
            prettyPrinter.hr().add(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("F\ua7f4\ua4b4\ua07f\ua916\u7d70\u8e45\u2468\u8b3a\u3472`\ua7a6\ua481\ua078\ua908\u7d73\u8e59")).hr().add();
            int n = 0x5194041C ^ 0x51940416;
            for (Map.Entry entry : map.entrySet()) {
                n = Math.max(n, ((String)entry.getKey()).length());
            }
            for (Map.Entry entry : map.entrySet()) {
                String string2 = (String)entry.getKey();
                long l11 = 0x79C43749D48F3525L ^ 0x79C43749D48F3525L;
                for (Profiler.Section section2 : this.profiler.getSections()) {
                    if (!string2.equals(section2.getInfo())) continue;
                    l11 = section2.getTotalTime();
                    break;
                }
                if (l11 > (0x8717DDBDE2D1F584L ^ 0x8717DDBDE2D1F584L)) {
                    Object[] objectArray14 = new Object[0xF5AE619B ^ 0xF5AE6198];
                    objectArray14[0xEC284BEA ^ 0xEC284BEA] = string2;
                    objectArray14[0x4EA46148 ^ 0x4EA46149] = (Long)entry.getValue() + l11;
                    objectArray14[0xCE3B0F60 ^ 0xCE3B0F62] = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b(":") + l11;
                    prettyPrinter.add(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("7\ua7ab") + n + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("a\ua7a6\ua4f0\ua029\ua916\u7d36\u8e47\u2469\u8b77\u3432*\ua7f5\ua4f5\ua07c\ua916\u7d36\u8e43\u2474\u8b77\u347a{\ua7fe\ua4bc\ua07f\ua94c"), objectArray14);
                    continue;
                }
                Object[] objectArray15 = new Object[0xFCE03914 ^ 0xFCE03916];
                objectArray15[0xE1D06260 ^ 0xE1D06260] = string2;
                objectArray15[0x972CCC95 ^ 0x972CCC94] = entry.getValue();
                prettyPrinter.add(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("7\ua7ab") + n + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("a\ua7a6\ua4f0\ua029\ua916\u7d36\u8e47\u2469"), objectArray15);
            }
            prettyPrinter.add();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        prettyPrinter.print();
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public boolean isDelegationExcluded() {
        return (0x13E7B69B ^ 0x13E7B69A) != 0;
    }

    @Override
    public synchronized byte[] transformClassBytes(String string, String string2, byte[] byArray) {
        if (string2 == null || this.errorState) {
            return byArray;
        }
        MixinEnvironment mixinEnvironment = MixinEnvironment.getCurrentEnvironment();
        if (byArray == null) {
            for (IClassGenerator iClassGenerator : this.extensions.getGenerators()) {
                String[] stringArray = new String[0xCF7688A0 ^ 0xCF7688A2];
                stringArray[0xDB9DC5F2 ^ 0xDB9DC5F2] = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("u\ua7e3\ua4bb\ua074\ua917\u7d77\u8e5e\u2475\u8b25");
                stringArray[0x76984640 ^ 0x76984641] = iClassGenerator.getClass().getSimpleName().toLowerCase();
                Profiler.Section section = this.profiler.begin(stringArray);
                byArray = iClassGenerator.generate(string2);
                section.end();
                if (byArray == null) continue;
                this.extensions.export(mixinEnvironment, string2.replace((char)(0x87F05C0E ^ 0x87F05C20), (char)(0x2C531121 ^ 0x2C53110E)), (0xE6B312BF ^ 0xE6B312BF) != 0, byArray);
                return byArray;
            }
            return byArray;
        }
        boolean bl = this.lock.push().check();
        Profiler.Section section = this.profiler.begin(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("\u007f\ua7ef\ua4ad\ua078\ua90b"));
        if (!bl) {
            try {
                this.checkSelect(mixinEnvironment);
            }
            catch (Exception exception) {
                this.lock.pop();
                section.end();
                throw new MixinException(exception);
            }
        }
        try {
            Object object;
            if (this.postProcessor.canTransform(string2)) {
                Profiler.Section section2 = this.profiler.begin(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("b\ua7e9\ua4a6\ua065\ua915\u7d64\u8e45\u2479\u8b32\u3464a\ua7e9\ua4a7"));
                byte[] byArray2 = this.postProcessor.transformClassBytes(string, string2, byArray);
                section2.end();
                this.extensions.export(mixinEnvironment, string2, (0xE8E5E793 ^ 0xE8E5E793) != 0, byArray2);
                byte[] byArray3 = byArray2;
                return byArray3;
            }
            TreeSet<MixinInfo> treeSet = null;
            int n = 0xC0BB066D ^ 0xC0BB066D;
            for (MixinConfig object2 : this.configs) {
                if (object2.packageMatch(string2)) {
                    n = 0x6C2EAAC0 ^ 0x6C2EAAC1;
                    continue;
                }
                if (!object2.hasMixinsFor(string2)) continue;
                if (treeSet == null) {
                    treeSet = new TreeSet<MixinInfo>();
                }
                treeSet.addAll(object2.getMixinsFor(string2));
            }
            if (n != 0) {
                Object[] objectArray = new Object[0x82B9991F ^ 0x82B9991E];
                objectArray[0x53E3409A ^ 0x53E3409A] = string2;
                throw new NoClassDefFoundError(String.format(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("7\ua7f5\ua4f5\ua078\ua916\u7d36\u8e4b\u243a\u8b3a\u347ej\ua7ef\ua4bb\ua031\ua906\u7d7a\u8e4b\u2469\u8b24\u3437s\ua7e8\ua4b1\ua031\ua906\u7d77\u8e44\u2474\u8b38\u34632\ua7e4\ua4b0\ua031\ua917\u7d73\u8e4c\u247f\u8b25\u3472|\ua7e5\ua4b0\ua075\ua945\u7d72\u8e43\u2468\u8b32\u3474f\ua7ea\ua4ac"), objectArray));
            }
            if (treeSet != null) {
                if (bl) {
                    logger.warn(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("@\ua7e3\ua4f8\ua074\ua90b\u7d62\u8e58\u247b\u8b39\u3474w\ua7a6\ua4b1\ua074\ua911\u7d73\u8e49\u246e\u8b32\u3473>\ua7a6\ua4a1\ua079\ua90c\u7d65\u8e0a\u246d\u8b3e\u347b~\ua7a6\ua4b6\ua070\ua910\u7d65\u8e4f\u243a\u8b24\u3472`\ua7ef\ua4ba\ua064\ua916\u7d36\u8e5a\u2468\u8b38\u3475~\ua7e3\ua4b8\ua062\ua94b"), (Throwable)new MixinException());
                    throw new MixinApplyError(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("@\ua7e3\ua4f8\ua074\ua90b\u7d62\u8e58\u247b\u8b39\u3474w\ua7a6\ua4b0\ua063\ua917\u7d79\u8e58\u2434"));
                }
                if (this.hotSwapper != null) {
                    this.hotSwapper.registerTargetClass(string2, byArray);
                }
                try {
                    object = this.profiler.begin(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("`\ua7e3\ua4b4\ua075"));
                    ClassNode classNode = this.readClass(byArray, (0x3F29BAF0 ^ 0x3F29BAF1) != 0);
                    TargetClassContext targetClassContext = new TargetClassContext(mixinEnvironment, this.extensions, this.sessionId, string2, classNode, treeSet);
                    ((Profiler.Section)object).end();
                    byArray = this.applyMixins(mixinEnvironment, targetClassContext);
                    this.transformedCount += 0xC74241C5 ^ 0xC74241C4;
                }
                catch (InvalidMixinException invalidMixinException) {
                    this.dumpClassOnFailure(string2, byArray, mixinEnvironment);
                    this.handleMixinApplyError(string2, invalidMixinException, mixinEnvironment);
                }
            }
            object = byArray;
            return object;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.dumpClassOnFailure(string2, byArray, mixinEnvironment);
            throw new MixinTransformerError(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("S\ua7e8\ua4f5\ua064\ua90b\u7d73\u8e52\u246a\u8b32\u3474f\ua7e3\ua4b1\ua031\ua906\u7d64\u8e43\u246e\u8b3e\u3474s\ua7ea\ua4f5\ua074\ua917\u7d64\u8e45\u2468\u8b77\u3460s\ua7f5\ua4f5\ua074\ua90b\u7d75\u8e45\u246f\u8b39\u3463w\ua7f4\ua4b0\ua075"), throwable);
        }
        finally {
            this.lock.pop();
            section.end();
        }
    }

    public List<String> reload(String string, byte[] byArray) {
        if (this.lock.getDepth() > 0) {
            throw new MixinApplyError(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("Q\ua7e7\ua4bb\ua07f\ua90a\u7d62\u8e0a\u2468\u8b32\u347b}\ua7e7\ua4b1\ua031\ua908\u7d7f\u8e52\u2473\u8b39\u3437{\ua7e0\ua4f5\ua063\ua900\u7d3b\u8e4f\u2474\u8b23\u3465s\ua7e8\ua4a1\ua031\ua909\u7d79\u8e49\u2471\u8b77\u3472|\ua7f2\ua4b0\ua063\ua900\u7d72"));
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (MixinConfig mixinConfig : this.configs) {
            arrayList.addAll(mixinConfig.reloadMixin(string, byArray));
        }
        return arrayList;
    }

    private void checkSelect(MixinEnvironment mixinEnvironment) {
        if (this.currentEnvironment != mixinEnvironment) {
            this.select(mixinEnvironment);
            return;
        }
        int n = Mixins.getUnvisitedCount();
        if (n > 0 && this.transformedCount == 0) {
            this.select(mixinEnvironment);
        }
    }

    private void select(MixinEnvironment mixinEnvironment) {
        Level level = this.verboseLoggingLevel = mixinEnvironment.getOption(MixinEnvironment.Option.DEBUG_VERBOSE) ? Level.INFO : Level.DEBUG;
        if (this.transformedCount > 0) {
            Object[] objectArray = new Object[0xAF087BE0 ^ 0xAF087BE2];
            objectArray[0xBEC73571 ^ 0xBEC73571] = this.currentEnvironment;
            objectArray[0x8C73A5B4 ^ 0x8C73A5B5] = this.transformedCount;
            logger.log(this.verboseLoggingLevel, \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("W\ua7e8\ua4b1\ua078\ua90b\u7d71\u8e0a\u2461\u8b2a\u343b2\ua7e7\ua4a5\ua061\ua909\u7d7f\u8e4f\u247e\u8b77\u346co\ua7a6\ua4b8\ua078\ua91d\u7d7f\u8e44\u2469"), objectArray);
        }
        String string = this.currentEnvironment == mixinEnvironment ? \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("Q\ua7ee\ua4b0\ua072\ua90e\u7d7f\u8e44\u247d\u8b77\u3471}\ua7f4\ua4f5\ua070\ua901\u7d72\u8e43\u246e\u8b3e\u3478|\ua7e7\ua4b9") : \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("B\ua7f4\ua4b0\ua061\ua904\u7d64\u8e43\u2474\u8b30");
        Object[] objectArray = new Object[0x7E08D311 ^ 0x7E08D313];
        objectArray[0xBD3B5DCA ^ 0xBD3B5DCA] = string;
        objectArray[0xA72C6635 ^ 0xA72C6634] = mixinEnvironment;
        logger.log(this.verboseLoggingLevel, \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("i\ua7fb\ua4f5\ua07c\ua90c\u7d6e\u8e43\u2474\u8b24\u3437t\ua7e9\ua4a7\ua031\ua91e\u7d6b"), objectArray);
        this.profiler.setActive((0x79159A51 ^ 0x79159A50) != 0);
        this.profiler.mark(mixinEnvironment.getPhase().toString() + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("(\ua7f6\ua4a7\ua074\ua915\u7d77\u8e58\u247f"));
        Profiler.Section section = this.profiler.begin(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("b\ua7f4\ua4b0\ua061\ua904\u7d64\u8e4f"));
        this.selectConfigs(mixinEnvironment);
        this.extensions.select(mixinEnvironment);
        int n = this.prepareConfigs(mixinEnvironment);
        this.currentEnvironment = mixinEnvironment;
        this.transformedCount = 0x6618C57D ^ 0x6618C57D;
        section.end();
        long l = section.getTime();
        double d = section.getSeconds();
        if (d > 0.25) {
            long l2 = this.profiler.get(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("q\ua7ea\ua4b4\ua062\ua916\u7d38\u8e46\u2475\u8b36\u3473")).getTime();
            long l3 = this.profiler.get(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("q\ua7ea\ua4b4\ua062\ua916\u7d38\u8e5e\u2468\u8b36\u3479a\ua7e0\ua4ba\ua063\ua908")).getTime();
            long l4 = this.profiler.get(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("\u007f\ua7ef\ua4ad\ua078\ua90b\u7d38\u8e5a\u2476\u8b22\u3470{\ua7e8")).getTime();
            String string2 = new DecimalFormat(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("1\ua7a5\ua4f6\ua021\ua94b\u7d26\u8e1a\u242a")).format(d);
            String string3 = new DecimalFormat(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("1\ua7a5\ua4f6\ua021\ua94b\u7d26")).format((double)l / (double)n);
            Object[] objectArray2 = new Object[0x5AECB029 ^ 0x5AECB02F];
            objectArray2[0xD1419BD3 ^ 0xD1419BD3] = n;
            objectArray2[0xF3FA60C8 ^ 0xF3FA60C9] = string2;
            objectArray2[0x13FCA2DE ^ 0x13FCA2DC] = string3;
            objectArray2[0x87EE6E82 ^ 0x87EE6E81] = l2;
            objectArray2[0x38788D04 ^ 0x38788D00] = l3;
            objectArray2[0x32B2DC75 ^ 0x32B2DC70] = l4;
            logger.log(this.verboseLoggingLevel, \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("B\ua7f4\ua4b0\ua061\ua904\u7d64\u8e4f\u247e\u8b77\u346co\ua7a6\ua4b8\ua078\ua91d\u7d7f\u8e44\u2469\u8b77\u347e|\ua7a6\ua4ae\ua06c\ua945\u7d65\u8e4f\u2479\u8b77\u343fi\ua7fb\ua4b8\ua062\ua945\u7d77\u8e5c\u247d\u8b7e\u3437:\ua7fd\ua4a8\ua07c\ua916\u7d36\u8e46\u2475\u8b36\u3473>\ua7a6\ua4ae\ua06c\ua908\u7d65\u8e0a\u246e\u8b25\u3476|\ua7f5\ua4b3\ua07e\ua917\u7d7b\u8e06\u243a\u8b2c\u346a\u007f\ua7f5\ua4f5\ua061\ua909\u7d63\u8e4d\u2473\u8b39\u343e"), objectArray2);
        }
        this.profiler.mark(mixinEnvironment.getPhase().toString() + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("(\ua7e7\ua4a5\ua061\ua909\u7d6f"));
        this.profiler.setActive(mixinEnvironment.getOption(MixinEnvironment.Option.DEBUG_PROFILER));
    }

    private void selectConfigs(MixinEnvironment mixinEnvironment) {
        Iterator<Config> iterator = Mixins.getConfigs().iterator();
        while (iterator.hasNext()) {
            Config config = iterator.next();
            try {
                MixinConfig mixinConfig = config.get();
                if (!mixinConfig.select(mixinEnvironment)) continue;
                iterator.remove();
                Object[] objectArray = new Object[0x6548E748 ^ 0x6548E749];
                objectArray[0x5C40ED70 ^ 0x5C40ED70] = mixinConfig;
                logger.log(this.verboseLoggingLevel, \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("A\ua7e3\ua4b9\ua074\ua906\u7d62\u8e43\u2474\u8b30\u3437q\ua7e9\ua4bb\ua077\ua90c\u7d71\u8e0a\u2461\u8b2a"), objectArray);
                mixinConfig.onSelect();
                this.pendingConfigs.add(mixinConfig);
            }
            catch (Exception exception) {
                Object[] objectArray = new Object[0x5A266EB5 ^ 0x5A266EB4];
                objectArray[0x4573B4A3 ^ 0x4573B4A3] = config;
                logger.warn(String.format(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("T\ua7e7\ua4bc\ua07d\ua900\u7d72\u8e0a\u246e\u8b38\u3437a\ua7e3\ua4b9\ua074\ua906\u7d62\u8e0a\u2477\u8b3e\u346f{\ua7e8\ua4f5\ua072\ua90a\u7d78\u8e4c\u2473\u8b30\u342d2\ua7a3\ua4a6"), objectArray), (Throwable)exception);
            }
        }
        Collections.sort(this.pendingConfigs);
    }

    private int prepareConfigs(MixinEnvironment mixinEnvironment) {
        Object object;
        int n = 0xFF3A4E57 ^ 0xFF3A4E57;
        final IHotSwap iHotSwap = this.hotSwapper;
        for (MixinConfig mixinConfig : this.pendingConfigs) {
            mixinConfig.addListener(this.postProcessor);
            if (iHotSwap == null) continue;
            mixinConfig.addListener(new MixinConfig.IListener(){

                @Override
                public void onPrepare(MixinInfo mixinInfo) {
                    iHotSwap.registerMixinClass(mixinInfo.getClassName());
                }

                @Override
                public void onInit(MixinInfo mixinInfo) {
                }
            });
        }
        for (MixinConfig mixinConfig : this.pendingConfigs) {
            try {
                Object[] objectArray = new Object[0x663311F7 ^ 0x663311F5];
                objectArray[0x410EE0A5 ^ 0x410EE0A5] = mixinConfig;
                objectArray[0x8B6B7E5B ^ 0x8B6B7E5A] = mixinConfig.getDeclaredMixinCount();
                logger.log(this.verboseLoggingLevel, \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("B\ua7f4\ua4b0\ua061\ua904\u7d64\u8e43\u2474\u8b30\u3437i\ua7fb\ua4f5\ua039\ua91e\u7d6b\u8e03"), objectArray);
                mixinConfig.prepare();
                n += mixinConfig.getMixinCount();
            }
            catch (InvalidMixinException invalidMixinException) {
                this.handleMixinPrepareError(mixinConfig, invalidMixinException, mixinEnvironment);
            }
            catch (Exception exception) {
                object = exception.getMessage();
                logger.error(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("W\ua7f4\ua4a7\ua07e\ua917\u7d36\u8e4f\u2474\u8b34\u3478g\ua7e8\ua4a1\ua074\ua917\u7d73\u8e4e\u243a\u8b20\u347f{\ua7ea\ua4a6\ua065\ua945\u7d7f\u8e44\u2473\u8b23\u347es\ua7ea\ua4bc\ua062\ua90c\u7d78\u8e4d\u243a\u8b3a\u347ej\ua7ef\ua4bb\ua031\ua906\u7d79\u8e44\u247c\u8b3e\u34702\ua7a1") + mixinConfig.getName() + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("5\ua7bc\ua4f5") + (String)object, (Throwable)exception);
            }
        }
        for (MixinConfig mixinConfig : this.pendingConfigs) {
            IMixinConfigPlugin iMixinConfigPlugin = mixinConfig.getPlugin();
            if (iMixinConfigPlugin == null) continue;
            object = new HashSet();
            for (MixinConfig mixinConfig2 : this.pendingConfigs) {
                if (mixinConfig2.equals(mixinConfig)) continue;
                object.addAll(mixinConfig2.getTargets());
            }
            iMixinConfigPlugin.acceptTargets(mixinConfig.getTargets(), Collections.unmodifiableSet(object));
        }
        for (MixinConfig mixinConfig : this.pendingConfigs) {
            try {
                mixinConfig.postInitialise();
            }
            catch (InvalidMixinException invalidMixinException) {
                this.handleMixinPrepareError(mixinConfig, invalidMixinException, mixinEnvironment);
            }
            catch (Exception exception) {
                object = exception.getMessage();
                logger.error(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("W\ua7f4\ua4a7\ua07e\ua917\u7d36\u8e4f\u2474\u8b34\u3478g\ua7e8\ua4a1\ua074\ua917\u7d73\u8e4e\u243a\u8b33\u3462`\ua7ef\ua4bb\ua076\ua945\u7d7b\u8e43\u2462\u8b3e\u34792\ua7e5\ua4ba\ua07f\ua903\u7d7f\u8e4d\u243a\u8b27\u3478a\ua7f2\ua49c\ua07f\ua90c\u7d62\u8e0a\u2469\u8b23\u3472b\ua7a1") + mixinConfig.getName() + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("5\ua7bc\ua4f5") + (String)object, (Throwable)exception);
            }
        }
        this.configs.addAll(this.pendingConfigs);
        Collections.sort(this.configs);
        this.pendingConfigs.clear();
        return n;
    }

    private byte[] applyMixins(MixinEnvironment mixinEnvironment, TargetClassContext targetClassContext) {
        Profiler.Section section;
        block2: {
            section = this.profiler.begin(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("b\ua7f4\ua4b0\ua070\ua915\u7d66\u8e46\u2463"));
            this.extensions.preApply(targetClassContext);
            section = section.next(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("s\ua7f6\ua4a5\ua07d\ua91c"));
            this.apply(targetClassContext);
            section = section.next(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("b\ua7e9\ua4a6\ua065\ua904\u7d66\u8e5a\u2476\u8b2e"));
            try {
                this.extensions.postApply(targetClassContext);
            }
            catch (ExtensionCheckClass.ValidationFailedException validationFailedException) {
                logger.info(validationFailedException.getMessage());
                if (!targetClassContext.isExportForced() && !mixinEnvironment.getOption(MixinEnvironment.Option.DEBUG_EXPORT)) break block2;
                this.writeClass(targetClassContext);
            }
        }
        section.end();
        return this.writeClass(targetClassContext);
    }

    private void apply(TargetClassContext targetClassContext) {
        targetClassContext.applyMixins();
    }

    private void handleMixinPrepareError(MixinConfig mixinConfig, InvalidMixinException invalidMixinException, MixinEnvironment mixinEnvironment) throws MixinPrepareError {
        this.handleMixinError(mixinConfig.getName(), invalidMixinException, mixinEnvironment, ErrorPhase.PREPARE);
    }

    private void handleMixinApplyError(String string, InvalidMixinException invalidMixinException, MixinEnvironment mixinEnvironment) throws MixinApplyError {
        this.handleMixinError(string, invalidMixinException, mixinEnvironment, ErrorPhase.APPLY);
    }

    private void handleMixinError(String string, InvalidMixinException invalidMixinException, MixinEnvironment mixinEnvironment, ErrorPhase errorPhase) throws Error {
        IMixinErrorHandler.ErrorAction errorAction;
        this.errorState = 0x2854FE8F ^ 0x2854FE8E;
        IMixinInfo iMixinInfo = invalidMixinException.getMixin();
        if (iMixinInfo == null) {
            logger.error(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u2457\u8b3e\u346f{\ua7e8\ua490\ua069\ua906\u7d73\u8e5a\u246e\u8b3e\u3478|\ua7a6\ua4bd\ua070\ua916\u7d36\u8e44\u2475\u8b77\u347a{\ua7fe\ua4bc\ua07f\ua944"), (Throwable)invalidMixinException);
            throw invalidMixinException;
        }
        IMixinConfig iMixinConfig = iMixinInfo.getConfig();
        MixinEnvironment.Phase phase = iMixinInfo.getPhase();
        IMixinErrorHandler.ErrorAction errorAction2 = errorAction = iMixinConfig.isRequired() ? IMixinErrorHandler.ErrorAction.ERROR : IMixinErrorHandler.ErrorAction.WARN;
        if (mixinEnvironment.getOption(MixinEnvironment.Option.DEBUG_VERBOSE)) {
            Object[] objectArray = new Object[0xA41DB168 ^ 0xA41DB169];
            objectArray[0x77A99FC7 ^ 0x77A99FC7] = invalidMixinException.getClass().getName();
            Object[] objectArray2 = new Object[0x9073E9E0 ^ 0x9073E9E1];
            objectArray2[0x38329DF9 ^ 0x38329DF9] = invalidMixinException.getMessage();
            new PrettyPrinter().add(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b1a\u347ej\ua7ef\ua4bb")).centre().hr((char)(0xD486A778 ^ 0xD486A755)).kvWidth(0x67D0DEC2 ^ 0x67D0DEC8).kv(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("S\ua7e5\ua4a1\ua078\ua90a\u7d78"), errorPhase.name()).kv(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("_\ua7ef\ua4ad\ua078\ua90b"), iMixinInfo.getClassName()).kv(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("Q\ua7e9\ua4bb\ua077\ua90c\u7d71"), iMixinConfig.getName()).kv(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("B\ua7ee\ua4b4\ua062\ua900"), phase).hr((char)(0xC64D0794 ^ 0xC64D07B9)).add(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2\ua7a6\ua4f5\ua031\ua940\u7d65"), objectArray).hr((char)(0xCBAA3EDB ^ 0xCBAA3EF6)).addWrapped(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2\ua7a6\ua4f5\ua031\ua940\u7d65"), objectArray2).hr((char)(0xE25C35EB ^ 0xE25C35C6)).add(invalidMixinException, 0x5E51E503 ^ 0x5E51E50B).trace(errorAction.logLevel);
        }
        for (IMixinErrorHandler iMixinErrorHandler : this.getErrorHandlers(iMixinInfo.getPhase())) {
            IMixinErrorHandler.ErrorAction errorAction3 = errorPhase.onError(iMixinErrorHandler, string, invalidMixinException, iMixinInfo, errorAction);
            if (errorAction3 == null) continue;
            errorAction = errorAction3;
        }
        logger.log(errorAction.logLevel, errorPhase.getLogMessage(string, invalidMixinException, iMixinInfo), (Throwable)invalidMixinException);
        this.errorState = 0xE292C712 ^ 0xE292C712;
        if (errorAction == IMixinErrorHandler.ErrorAction.ERROR) {
            throw new MixinApplyError(errorPhase.getErrorMessage(iMixinInfo, iMixinConfig, phase), invalidMixinException);
        }
    }

    private List<IMixinErrorHandler> getErrorHandlers(MixinEnvironment.Phase phase) {
        ArrayList<IMixinErrorHandler> arrayList = new ArrayList<IMixinErrorHandler>();
        for (String string : Mixins.getErrorHandlerClasses()) {
            try {
                Object[] objectArray = new Object[0x7D68E4C8 ^ 0x7D68E4C9];
                objectArray[0x479A3542 ^ 0x479A3542] = string;
                logger.info(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("[\ua7e8\ua4a6\ua065\ua904\u7d78\u8e49\u2473\u8b39\u34702\ua7e3\ua4a7\ua063\ua90a\u7d64\u8e0a\u2472\u8b36\u3479v\ua7ea\ua4b0\ua063\ua945\u7d75\u8e46\u247b\u8b24\u34642\ua7fd\ua4a8"), objectArray);
                Class<?> clazz = this.service.getClassProvider().findClass(string, (0x5B030143 ^ 0x5B030142) != 0);
                IMixinErrorHandler iMixinErrorHandler = (IMixinErrorHandler)clazz.newInstance();
                if (iMixinErrorHandler == null) continue;
                arrayList.add(iMixinErrorHandler);
            }
            catch (Throwable throwable) {}
        }
        return arrayList;
    }

    private byte[] writeClass(TargetClassContext targetClassContext) {
        return this.writeClass(targetClassContext.getClassName(), targetClassContext.getClassNode(), targetClassContext.isExportForced());
    }

    private byte[] writeClass(String string, ClassNode classNode, boolean bl) {
        Profiler.Section section = this.profiler.begin(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("e\ua7f4\ua4bc\ua065\ua900"));
        byte[] byArray = this.writeClass(classNode);
        section.end();
        this.extensions.export(this.currentEnvironment, string, bl, byArray);
        return byArray;
    }

    private void dumpClassOnFailure(String string, byte[] byArray, MixinEnvironment mixinEnvironment) {
        if (mixinEnvironment.getOption(MixinEnvironment.Option.DUMP_TARGET_ON_FAILURE)) {
            ExtensionClassExporter extensionClassExporter = (ExtensionClassExporter)this.extensions.getExtension(ExtensionClassExporter.class);
            extensionClassExporter.dumpClass(string.replace((char)(0xDB192360 ^ 0xDB19234E), (char)(0x42CA6CA0 ^ 0x42CA6C8F)) + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("<\ua7f2\ua4b4\ua063\ua902\u7d73\u8e5e"), byArray);
        }
    }

    static abstract class ErrorPhase
    extends Enum<ErrorPhase> {
        public static final /* enum */ ErrorPhase PREPARE = new ErrorPhase(){

            @Override
            IMixinErrorHandler.ErrorAction onError(IMixinErrorHandler iMixinErrorHandler, String string, InvalidMixinException invalidMixinException, IMixinInfo iMixinInfo, IMixinErrorHandler.ErrorAction errorAction) {
                try {
                    return iMixinErrorHandler.onPrepareError(iMixinInfo.getConfig(), invalidMixinException, iMixinInfo, errorAction);
                }
                catch (AbstractMethodError abstractMethodError) {
                    return errorAction;
                }
            }

            @Override
            protected String getContext(IMixinInfo iMixinInfo, String string) {
                Object[] objectArray = new Object[0x5E281865 ^ 0x5E281867];
                objectArray[0xF0DBDD44 ^ 0xF0DBDD44] = iMixinInfo.getName();
                objectArray[0x43D8D8A3 ^ 0x43D8D8A2] = string;
                return String.format(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("b\ua7f4\ua4b0\ua061\ua904\u7d64\u8e43\u2474\u8b30\u34377\ua7f5\ua4f5\ua078\ua90b\u7d36\u8e0f\u2469"), objectArray);
            }
        };
        public static final /* enum */ ErrorPhase APPLY = new ErrorPhase(){

            @Override
            IMixinErrorHandler.ErrorAction onError(IMixinErrorHandler iMixinErrorHandler, String string, InvalidMixinException invalidMixinException, IMixinInfo iMixinInfo, IMixinErrorHandler.ErrorAction errorAction) {
                try {
                    return iMixinErrorHandler.onApplyError(string, invalidMixinException, iMixinInfo, errorAction);
                }
                catch (AbstractMethodError abstractMethodError) {
                    return errorAction;
                }
            }

            @Override
            protected String getContext(IMixinInfo iMixinInfo, String string) {
                Object[] objectArray = new Object[0xBB3631D2 ^ 0xBB3631D0];
                objectArray[0x5FE5DAF9 ^ 0x5FE5DAF9] = iMixinInfo;
                objectArray[0x187B2675 ^ 0x187B2674] = string;
                return String.format(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("7\ua7f5\ua4f5\ua03c\ua95b\u7d36\u8e0f\u2469"), objectArray);
            }
        };
        private final String text = this.name().toLowerCase();
        private static final /* synthetic */ ErrorPhase[] $VALUES;

        public static ErrorPhase[] values() {
            return (ErrorPhase[])$VALUES.clone();
        }

        public static ErrorPhase valueOf(String string) {
            return Enum.valueOf(ErrorPhase.class, string);
        }

        abstract IMixinErrorHandler.ErrorAction onError(IMixinErrorHandler var1, String var2, InvalidMixinException var3, IMixinInfo var4, IMixinErrorHandler.ErrorAction var5);

        protected abstract String getContext(IMixinInfo var1, String var2);

        public String getLogMessage(String string, InvalidMixinException invalidMixinException, IMixinInfo iMixinInfo) {
            Object[] objectArray = new Object[0xCAD73A01 ^ 0xCAD73A05];
            objectArray[0xAE53BEF8 ^ 0xAE53BEF8] = this.text;
            objectArray[0xC495D40A ^ 0xC495D40B] = this.getContext(iMixinInfo, string);
            objectArray[0x537A7AB8 ^ 0x537A7ABA] = invalidMixinException.getClass().getName();
            objectArray[0xF11536AF ^ 0xF11536AC] = invalidMixinException.getMessage();
            return String.format(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("_\ua7ef\ua4ad\ua078\ua90b\u7d36\u8e0f\u2469\u8b77\u3471s\ua7ef\ua4b9\ua074\ua901\u7d36\u8e0f\u2469\u8b6d\u34377\ua7f5\ua4f5\ua034\ua916"), objectArray);
        }

        public String getErrorMessage(IMixinInfo iMixinInfo, IMixinConfig iMixinConfig, MixinEnvironment.Phase phase) {
            Object[] objectArray = new Object[0xF0AA5938 ^ 0xF0AA593C];
            objectArray[0xC5010F42 ^ 0xC5010F42] = iMixinInfo;
            objectArray[0x85002C72 ^ 0x85002C73] = phase;
            objectArray[0xD13809B6 ^ 0xD13809B4] = iMixinConfig;
            objectArray[0x334C3457 ^ 0x334C3454] = this.name();
            return String.format(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("_\ua7ef\ua4ad\ua078\ua90b\u7d36\u8e71\u243f\u8b24\u344a2\ua7e0\ua4a7\ua07e\ua908\u7d36\u8e5a\u2472\u8b36\u3464w\ua7a6\ua48e\ua034\ua916\u7d4b\u8e0a\u2473\u8b39\u3437q\ua7e9\ua4bb\ua077\ua90c\u7d71\u8e0a\u2441\u8b72\u3464O\ua7a6\ua493\ua050\ua92c\u7d5a\u8e6f\u245e\u8b77\u3473g\ua7f4\ua4bc\ua07f\ua902\u7d36\u8e0f\u2469"), objectArray);
        }

        static {
            ErrorPhase[] errorPhaseArray = new ErrorPhase[0x45B6AF1B ^ 0x45B6AF19];
            errorPhaseArray[0x2212E250 ^ 0x2212E250] = PREPARE;
            errorPhaseArray[0xE6CC0BFA ^ 0xE6CC0BFB] = APPLY;
            $VALUES = errorPhaseArray;
        }
    }
}

