/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer.ext.extensions;

import com.google.common.base.Charsets;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import org.spongepowered.asm.mixin.transformer.ext.IExtension;
import org.spongepowered.asm.mixin.transformer.ext.ITargetClassContext;
import org.spongepowered.asm.util.Constants;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.asm.util.SignaturePrinter;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2;

public class ExtensionCheckInterfaces
implements IExtension {
    private static final String AUDIT_DIR = "audit";
    private static final String IMPL_REPORT_FILENAME = "mixin_implementation_report";
    private static final String IMPL_REPORT_CSV_FILENAME = "mixin_implementation_report.csv";
    private static final String IMPL_REPORT_TXT_FILENAME = "mixin_implementation_report.txt";
    private static final Logger logger = LogManager.getLogger((String)\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("\u007f\ua7ef\ua4ad\ua078\ua90b"));
    private final File csv;
    private final File report;
    private final Multimap<ClassInfo, ClassInfo.Method> interfaceMethods = HashMultimap.create();
    private boolean strict;

    public ExtensionCheckInterfaces() {
        File file = new File(Constants.DEBUG_OUTPUT_DIR, \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("s\ua7f3\ua4b1\ua078\ua911"));
        file.mkdirs();
        this.csv = new File(file, \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("\u007f\ua7ef\ua4ad\ua078\ua90b\u7d49\u8e43\u2477\u8b27\u347bw\ua7eb\ua4b0\ua07f\ua911\u7d77\u8e5e\u2473\u8b38\u3479M\ua7f4\ua4b0\ua061\ua90a\u7d64\u8e5e\u2434\u8b34\u3464d"));
        this.report = new File(file, \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("\u007f\ua7ef\ua4ad\ua078\ua90b\u7d49\u8e43\u2477\u8b27\u347bw\ua7eb\ua4b0\ua07f\ua911\u7d77\u8e5e\u2473\u8b38\u3479M\ua7f4\ua4b0\ua061\ua90a\u7d64\u8e5e\u2434\u8b23\u346ff"));
        try {
            Files.write((CharSequence)\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("Q\ua7ea\ua4b4\ua062\ua916\u7d3a\u8e67\u247f\u8b23\u347f}\ua7e2\ua4f9\ua042\ua90c\u7d71\u8e44\u247b\u8b23\u3462`\ua7e3\ua4f9\ua058\ua90b\u7d62\u8e4f\u2468\u8b31\u3476q\ua7e3\ua4df"), (File)this.csv, (Charset)Charsets.ISO_8859_1);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            String string = new SimpleDateFormat(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("k\ua7ff\ua4ac\ua068\ua948\u7d5b\u8e67\u2437\u8b33\u34732\ua7ce\ua49d\ua02b\ua908\u7d7b\u8e10\u2469\u8b24")).format(new Date());
            Files.write((CharSequence)(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("_\ua7ef\ua4ad\ua078\ua90b\u7d36\u8e63\u2477\u8b27\u347bw\ua7eb\ua4b0\ua07f\ua911\u7d77\u8e5e\u2473\u8b38\u34792\ua7d4\ua4b0\ua061\ua90a\u7d64\u8e5e\u243a\u8b30\u3472|\ua7e3\ua4a7\ua070\ua911\u7d73\u8e4e\u243a\u8b38\u34792") + string + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("\u0018")), (File)this.report, (Charset)Charsets.ISO_8859_1);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public boolean checkActive(MixinEnvironment mixinEnvironment) {
        this.strict = mixinEnvironment.getOption(MixinEnvironment.Option.CHECK_IMPLEMENTS_STRICT);
        return mixinEnvironment.getOption(MixinEnvironment.Option.CHECK_IMPLEMENTS);
    }

    @Override
    public void preApply(ITargetClassContext iTargetClassContext) {
        ClassInfo classInfo = iTargetClassContext.getClassInfo();
        for (ClassInfo.Method method : classInfo.getInterfaceMethods((0x7D4EEAA5 ^ 0x7D4EEAA5) != 0)) {
            this.interfaceMethods.put((Object)classInfo, (Object)method);
        }
    }

    @Override
    public void postApply(ITargetClassContext iTargetClassContext) {
        ClassInfo classInfo = iTargetClassContext.getClassInfo();
        if (classInfo.isAbstract() && !this.strict) {
            Object[] objectArray = new Object[0x75836010 ^ 0x75836012];
            objectArray[0x1BDC17B7 ^ 0x1BDC17B7] = this.getClass().getSimpleName();
            objectArray[0xB0D2CAA2 ^ 0xB0D2CAA3] = iTargetClassContext;
            logger.info(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("i\ua7fb\ua4f5\ua078\ua916\u7d36\u8e59\u2471\u8b3e\u3467b\ua7ef\ua4bb\ua076\ua945\u7d77\u8e48\u2469\u8b23\u3465s\ua7e5\ua4a1\ua031\ua911\u7d77\u8e58\u247d\u8b32\u34632\ua7fd\ua4a8"), objectArray);
            return;
        }
        String string = classInfo.getName().replace((char)(0x2BD88DC9 ^ 0x2BD88DE6), (char)(0xEDFC324E ^ 0xEDFC3260));
        int n = 0x67C06CB0 ^ 0x67C06CB0;
        PrettyPrinter prettyPrinter = new PrettyPrinter();
        Object[] objectArray = new Object[0x9FF73474 ^ 0x9FF73475];
        objectArray[0xA12AE932 ^ 0xA12AE932] = string;
        prettyPrinter.add(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("Q\ua7ea\ua4b4\ua062\ua916\u7d2c\u8e0a\u243f\u8b24"), objectArray).hr();
        Object[] objectArray2 = new Object[0xCAA12B7 ^ 0xCAA12B4];
        objectArray2[0xCE6AB63D ^ 0xCE6AB63D] = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("@\ua7e3\ua4a1\ua064\ua917\u7d78\u8e0a\u244e\u8b2e\u3467w");
        objectArray2[0xD666095 ^ 0xD666094] = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("_\ua7ef\ua4a6\ua062\ua90c\u7d78\u8e4d\u243a\u8b1a\u3472f\ua7ee\ua4ba\ua075");
        objectArray2[0xA9028DD8 ^ 0xA9028DDA] = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("T\ua7f4\ua4ba\ua07c\ua945\u7d5f\u8e44\u246e\u8b32\u3465t\ua7e7\ua4b6\ua074");
        prettyPrinter.add(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("7\ua7ab\ua4e6\ua023\ua916\u7d36\u8e0f\u2437\u8b63\u3420a\ua7a6\ua4f5\ua034\ua916"), objectArray2).hr();
        Set<ClassInfo.Method> set = classInfo.getInterfaceMethods((0x426B5AEC ^ 0x426B5AED) != 0);
        HashSet<ClassInfo.Method> hashSet = new HashSet<ClassInfo.Method>(classInfo.getSuperClass().getInterfaceMethods((0x1D45AA91 ^ 0x1D45AA90) != 0));
        hashSet.addAll(this.interfaceMethods.removeAll((Object)classInfo));
        for (ClassInfo.Method method : set) {
            ClassInfo.Method method2 = classInfo.findMethodInHierarchy(method.getName(), method.getDesc(), ClassInfo.SearchType.ALL_CLASSES, ClassInfo.Traversal.ALL);
            if (method2 != null && !method2.isAbstract() || hashSet.contains(method)) continue;
            if (n > 0) {
                prettyPrinter.add();
            }
            SignaturePrinter signaturePrinter = new SignaturePrinter(method.getName(), method.getDesc()).setModifiers(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b(""));
            String string2 = method.getOwner().getName().replace((char)(0x3DE22F61 ^ 0x3DE22F4E), (char)(0x62E76A7C ^ 0x62E76A52));
            ++n;
            Object[] objectArray3 = new Object[0xA005986C ^ 0xA005986E];
            objectArray3[0x9FFAC68 ^ 0x9FFAC68] = signaturePrinter.getReturnType();
            objectArray3[0xF7677A44 ^ 0xF7677A45] = signaturePrinter;
            prettyPrinter.add(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("7\ua7ab\ua4e6\ua023\ua916\u7d33\u8e59"), objectArray3);
            Object[] objectArray4 = new Object[0x847DF540 ^ 0x847DF542];
            objectArray4[0x4334EADB ^ 0x4334EADB] = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("");
            objectArray4[0xB38327CD ^ 0xB38327CC] = string2;
            prettyPrinter.add(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("7\ua7ab\ua4ed\ua021\ua916\u7d36\u8e0a\u243f\u8b24"), objectArray4);
            this.appendToCSVReport(string, method, string2);
        }
        if (n > 0) {
            Object[] objectArray5 = new Object[0x791A4AB7 ^ 0x791A4AB4];
            objectArray5[0x3EAE7E92 ^ 0x3EAE7E92] = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("");
            objectArray5[0xAFE09BE7 ^ 0xAFE09BE6] = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("F\ua7e9\ua4a1\ua070\ua909\u7d36\u8e5f\u2474\u8b3e\u347ab\ua7ea\ua4b0\ua07c\ua900\u7d78\u8e5e\u247f\u8b33");
            objectArray5[0xC13DE327 ^ 0xC13DE325] = n;
            prettyPrinter.hr().add(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("7\ua7be\ua4e7\ua062\ua940\u7d65\u8e10\u243a\u8b72\u3473"), objectArray5);
            prettyPrinter.print(System.err);
            this.appendToTextReport(prettyPrinter);
        }
    }

    @Override
    public void export(MixinEnvironment mixinEnvironment, String string, boolean bl, byte[] byArray) {
    }

    private void appendToCSVReport(String string, ClassInfo.Method method, String string2) {
        try {
            Object[] objectArray = new Object[0x2CE23F09 ^ 0x2CE23F0D];
            objectArray[0xF1282D96 ^ 0xF1282D96] = string;
            objectArray[0x7A4A1291 ^ 0x7A4A1290] = method.getName();
            objectArray[0x3E554C5A ^ 0x3E554C58] = method.getDesc();
            objectArray[0xA2027918 ^ 0xA202791B] = string2;
            Files.append((CharSequence)String.format(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("7\ua7f5\ua4f9\ua034\ua916\u7d3a\u8e0f\u2469\u8b7b\u3432a\ua78c"), objectArray), (File)this.csv, (Charset)Charsets.ISO_8859_1);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendToTextReport(PrettyPrinter prettyPrinter) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(this.report, (0x81A38F89 ^ 0x81A38F88) != 0);
            PrintStream printStream = new PrintStream(fileOutputStream);
            printStream.print(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("\u0018"));
            prettyPrinter.print(printStream);
        }
        catch (Exception exception) {
            IOUtils.closeQuietly(fileOutputStream);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fileOutputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)fileOutputStream);
    }
}

