/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer.ext.extensions;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.transformer.ext.IDecompiler;
import org.spongepowered.asm.mixin.transformer.ext.IExtension;
import org.spongepowered.asm.mixin.transformer.ext.ITargetClassContext;
import org.spongepowered.asm.util.Constants;
import org.spongepowered.asm.util.perf.Profiler;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2;

public class ExtensionClassExporter
implements IExtension {
    private static final String DECOMPILER_CLASS = "org.spongepowered.asm.mixin.transformer.debug.RuntimeDecompiler";
    private static final String EXPORT_CLASS_DIR = "class";
    private static final String EXPORT_JAVA_DIR = "java";
    private static final Logger logger = LogManager.getLogger((String)\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("\u007f\ua7ef\ua4ad\ua078\ua90b"));
    private final File classExportDir = new File(Constants.DEBUG_OUTPUT_DIR, \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("q\ua7ea\ua4b4\ua062\ua916"));
    private final IDecompiler decompiler;

    public ExtensionClassExporter(MixinEnvironment mixinEnvironment) {
        this.decompiler = this.initDecompiler(mixinEnvironment, new File(Constants.DEBUG_OUTPUT_DIR, \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("x\ua7e7\ua4a3\ua070")));
        try {
            FileUtils.deleteDirectory((File)this.classExportDir);
        }
        catch (IOException iOException) {
            Object[] objectArray = new Object[0xD67732FD ^ 0xD67732FC];
            objectArray[0x183490BF ^ 0x183490BF] = iOException.getMessage();
            logger.warn(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("W\ua7f4\ua4a7\ua07e\ua917\u7d36\u8e49\u2476\u8b32\u3476|\ua7ef\ua4bb\ua076\ua945\u7d75\u8e46\u247b\u8b24\u34642\ua7e9\ua4a0\ua065\ua915\u7d63\u8e5e\u243a\u8b33\u347e`\ua7e3\ua4b6\ua065\ua90a\u7d64\u8e53\u2420\u8b77\u346co"), objectArray);
        }
    }

    public boolean isDecompilerActive() {
        return (this.decompiler != null ? 0x127E5016 ^ 0x127E5017 : 0x18EEF5DA ^ 0x18EEF5DA) != 0;
    }

    private IDecompiler initDecompiler(MixinEnvironment mixinEnvironment, File file) {
        if (!mixinEnvironment.getOption(MixinEnvironment.Option.DEBUG_EXPORT_DECOMPILE)) {
            return null;
        }
        try {
            boolean bl = mixinEnvironment.getOption(MixinEnvironment.Option.DEBUG_EXPORT_DECOMPILE_THREADED);
            Object[] objectArray = new Object[0x7C885135 ^ 0x7C885134];
            objectArray[0xCBFAD976 ^ 0xCBFAD976] = bl ? \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2\ua7ae\ua481\ua079\ua917\u7d73\u8e4b\u247e\u8b32\u34732\ua7eb\ua4ba\ua075\ua900\u7d3f") : \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("");
            logger.info(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("S\ua7f2\ua4a1\ua074\ua908\u7d66\u8e5e\u2473\u8b39\u34702\ua7f2\ua4ba\ua031\ua909\u7d79\u8e4b\u247e\u8b77\u3451w\ua7f4\ua4bb\ua077\ua909\u7d79\u8e5d\u247f\u8b25\u3437v\ua7e3\ua4b6\ua07e\ua908\u7d66\u8e43\u2476\u8b32\u3465i\ua7fb"), objectArray);
            String string = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("}\ua7f4\ua4b2\ua03f\ua916\u7d66\u8e45\u2474\u8b30\u3472b\ua7e9\ua4a2\ua074\ua917\u7d73\u8e4e\u2434\u8b36\u3464\u007f\ua7a8\ua4b8\ua078\ua91d\u7d7f\u8e44\u2434\u8b23\u3465s\ua7e8\ua4a6\ua077\ua90a\u7d64\u8e47\u247f\u8b25\u3439v\ua7e3\ua4b7\ua064\ua902\u7d38\u8e78\u246f\u8b39\u3463{\ua7eb\ua4b0\ua055\ua900\u7d75\u8e45\u2477\u8b27\u347e~\ua7e3\ua4a7") + (bl ? \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("S\ua7f5\ua4ac\ua07f\ua906") : \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b(""));
            Class<?> clazz = Class.forName(string);
            Class[] classArray = new Class[0x53B15357 ^ 0x53B15356];
            classArray[0x4F91CA44 ^ 0x4F91CA44] = File.class;
            Constructor<?> constructor = clazz.getDeclaredConstructor(classArray);
            Object[] objectArray2 = new Object[0x833843A1 ^ 0x833843A0];
            objectArray2[0xFA91C5C8 ^ 0xFA91C5C8] = file;
            IDecompiler iDecompiler = (IDecompiler)constructor.newInstance(objectArray2);
            Object[] objectArray3 = new Object[0x27657B4A ^ 0x27657B4B];
            objectArray3[0x75616AE5 ^ 0x75616AE5] = bl ? \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2\ua7ef\ua4bb\ua031\ua904\u7d36\u8e59\u247f\u8b27\u3476`\ua7e7\ua4a1\ua074\ua945\u7d62\u8e42\u2468\u8b32\u3476v") : \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("");
            logger.info(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("T\ua7e3\ua4a7\ua07f\ua903\u7d7a\u8e45\u246d\u8b32\u34652\ua7e2\ua4b0\ua072\ua90a\u7d7b\u8e5a\u2473\u8b3b\u3472`\ua7a6\ua4a2\ua070\ua916\u7d36\u8e59\u246f\u8b34\u3474w\ua7f5\ua4a6\ua077\ua910\u7d7a\u8e46\u2463\u8b77\u347e|\ua7ef\ua4a1\ua078\ua904\u7d7a\u8e43\u2469\u8b32\u3473>\ua7a6\ua4b0\ua069\ua915\u7d79\u8e58\u246e\u8b32\u34732\ua7e5\ua4b9\ua070\ua916\u7d65\u8e4f\u2469\u8b77\u3460{\ua7ea\ua4b9\ua031\ua907\u7d73\u8e0a\u247e\u8b32\u3474}\ua7eb\ua4a5\ua078\ua909\u7d73\u8e4e\u2461\u8b2a"), objectArray3);
            return iDecompiler;
        }
        catch (Throwable throwable) {
            Object[] objectArray = new Object[0xC671E0A5 ^ 0xC671E0A7];
            objectArray[0x401C57DC ^ 0x401C57DC] = throwable.getClass().getSimpleName();
            objectArray[0x2DAD272D ^ 0x2DAD272C] = throwable.getMessage();
            logger.info(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("T\ua7e3\ua4a7\ua07f\ua903\u7d7a\u8e45\u246d\u8b32\u34652\ua7e5\ua4ba\ua064\ua909\u7d72\u8e0a\u2474\u8b38\u34632\ua7e4\ua4b0\ua031\ua909\u7d79\u8e4b\u247e\u8b32\u3473>\ua7a6\ua4b0\ua069\ua915\u7d79\u8e58\u246e\u8b32\u34732\ua7e5\ua4b9\ua070\ua916\u7d65\u8e4f\u2469\u8b77\u3460{\ua7ea\ua4b9\ua031\ua90b\u7d79\u8e5e\u243a\u8b35\u34722\ua7e2\ua4b0\ua072\ua90a\u7d7b\u8e5a\u2473\u8b3b\u3472v\ua7a8\ua4f5\ua06a\ua918\u7d2c\u8e0a\u2461\u8b2a"), objectArray);
            return null;
        }
    }

    private String prepareFilter(String string) {
        string = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("L\ua7da\ua484") + string.replace(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("8\ua7ac"), \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("\u0093")).replace(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("8"), \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("\u0090")).replace(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("-"), \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("\u0091")) + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("N\ua7c3\ua4f1");
        return string.replace(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("\u0093"), \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("N\ua7c3\ua4fb\ua03b\ua939\u7d47")).replace(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("\u0090"), \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("N\ua7c3\ua48e\ua04f\ua939\u7d38\u8e77\u2431\u8b0b\u3446")).replace(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("\u0091"), \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("N\ua7c3\ua4fb\ua04d\ua934")).replace(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("N\ua7d7\ua489\ua054"), \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b(""));
    }

    private boolean applyFilter(String string, String string2) {
        return Pattern.compile(this.prepareFilter(string), 0x7E56CE7 ^ 0x7E56CE5).matcher(string2).matches();
    }

    @Override
    public boolean checkActive(MixinEnvironment mixinEnvironment) {
        return (0x6132EA5B ^ 0x6132EA5A) != 0;
    }

    @Override
    public void preApply(ITargetClassContext iTargetClassContext) {
    }

    @Override
    public void postApply(ITargetClassContext iTargetClassContext) {
    }

    @Override
    public void export(MixinEnvironment mixinEnvironment, String string, boolean bl, byte[] byArray) {
        if (bl || mixinEnvironment.getOption(MixinEnvironment.Option.DEBUG_EXPORT)) {
            String string2 = mixinEnvironment.getOptionValue(MixinEnvironment.Option.DEBUG_EXPORT_FILTER);
            if (bl || string2 == null || this.applyFilter(string2, string)) {
                Profiler.Section section = MixinEnvironment.getProfiler().begin(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("v\ua7e3\ua4b7\ua064\ua902\u7d38\u8e4f\u2462\u8b27\u3478`\ua7f2"));
                File file = this.dumpClass(string.replace((char)(0x759698D5 ^ 0x759698FB), (char)(0x4697A3D1 ^ 0x4697A3FE)), byArray);
                if (this.decompiler != null) {
                    this.decompiler.decompile(file);
                }
                section.end();
            }
        }
    }

    public File dumpClass(String string, byte[] byArray) {
        File file = new File(this.classExportDir, string + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("<\ua7e5\ua4b9\ua070\ua916\u7d65"));
        try {
            FileUtils.writeByteArrayToFile((File)file, (byte[])byArray);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return file;
    }
}

