/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.service;

import java.util.HashSet;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.service.IMixinService;
import org.spongepowered.asm.service.IMixinServiceBootstrap;
import org.spongepowered.asm.service.ServiceNotAvailableError;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2;

public final class MixinService {
    private static final Logger logger = LogManager.getLogger((String)\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("\u007f\ua7ef\ua4ad\ua078\ua90b"));
    private static MixinService instance;
    private ServiceLoader<IMixinServiceBootstrap> bootstrapServiceLoader;
    private final Set<String> bootedServices = new HashSet<String>();
    private ServiceLoader<IMixinService> serviceLoader;
    private IMixinService service = null;

    private MixinService() {
        this.runBootServices();
    }

    private void runBootServices() {
        this.bootstrapServiceLoader = ServiceLoader.load(IMixinServiceBootstrap.class, this.getClass().getClassLoader());
        for (IMixinServiceBootstrap iMixinServiceBootstrap : this.bootstrapServiceLoader) {
            try {
                iMixinServiceBootstrap.bootstrap();
                this.bootedServices.add(iMixinServiceBootstrap.getServiceClassName());
            }
            catch (Throwable throwable) {
                logger.catching(throwable);
            }
        }
    }

    private static MixinService getInstance() {
        if (instance == null) {
            instance = new MixinService();
        }
        return instance;
    }

    public static void boot() {
        MixinService.getInstance();
    }

    public static IMixinService getService() {
        return MixinService.getInstance().getServiceInstance();
    }

    private synchronized IMixinService getServiceInstance() {
        if (this.service == null) {
            this.service = this.initService();
            if (this.service == null) {
                throw new ServiceNotAvailableError(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("\\\ua7e9\ua4f5\ua07c\ua90c\u7d6e\u8e43\u2474\u8b77\u347f}\ua7f5\ua4a1\ua031\ua916\u7d73\u8e58\u246c\u8b3e\u3474w\ua7a6\ua4bc\ua062\ua945\u7d77\u8e5c\u247b\u8b3e\u347bs\ua7e4\ua4b9\ua074"));
            }
        }
        return this.service;
    }

    private IMixinService initService() {
        this.serviceLoader = ServiceLoader.load(IMixinService.class, this.getClass().getClassLoader());
        Iterator<IMixinService> iterator = this.serviceLoader.iterator();
        while (iterator.hasNext()) {
            try {
                IMixinService iMixinService = iterator.next();
                if (this.bootedServices.contains(iMixinService.getClass().getName())) {
                    Object[] objectArray = new Object[0x3F10119C ^ 0x3F10119E];
                    objectArray[0x96D07AAA ^ 0x96D07AAA] = iMixinService.getName();
                    objectArray[0x6A465E08 ^ 0x6A465E09] = this.getClass().getClassLoader();
                    logger.debug(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("_\ua7ef\ua4ad\ua078\ua90b\u7d45\u8e4f\u2468\u8b21\u347eq\ua7e3\ua4f5\ua04a\ua91e\u7d6b\u8e77\u243a\u8b20\u3476a\ua7a6\ua4a6\ua064\ua906\u7d75\u8e4f\u2469\u8b24\u3471g\ua7ea\ua4b9\ua068\ua945\u7d74\u8e45\u2475\u8b23\u3472v\ua7a6\ua4bc\ua07f\ua945\u7d6d\u8e57"), objectArray);
                }
                if (!iMixinService.isValid()) continue;
                return iMixinService;
            }
            catch (ServiceConfigurationError serviceConfigurationError) {
                serviceConfigurationError.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return null;
    }
}

