/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.util;

import com.google.common.base.Joiner;
import com.google.common.primitives.Ints;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.lib.ClassReader;
import org.spongepowered.asm.lib.ClassWriter;
import org.spongepowered.asm.lib.MethodVisitor;
import org.spongepowered.asm.lib.Opcodes;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.lib.tree.FieldInsnNode;
import org.spongepowered.asm.lib.tree.FieldNode;
import org.spongepowered.asm.lib.tree.FrameNode;
import org.spongepowered.asm.lib.tree.InsnList;
import org.spongepowered.asm.lib.tree.IntInsnNode;
import org.spongepowered.asm.lib.tree.JumpInsnNode;
import org.spongepowered.asm.lib.tree.LabelNode;
import org.spongepowered.asm.lib.tree.LdcInsnNode;
import org.spongepowered.asm.lib.tree.LineNumberNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.lib.tree.TypeInsnNode;
import org.spongepowered.asm.lib.tree.VarInsnNode;
import org.spongepowered.asm.lib.util.CheckClassAdapter;
import org.spongepowered.asm.lib.util.TraceClassVisitor;
import org.spongepowered.asm.mixin.Debug;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.util.Constants;
import org.spongepowered.asm.util.throwables.SyntheticBridgeException;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2;

public final class Bytecode {
    public static final int[] CONSTANTS_INT;
    public static final int[] CONSTANTS_FLOAT;
    public static final int[] CONSTANTS_DOUBLE;
    public static final int[] CONSTANTS_LONG;
    public static final int[] CONSTANTS_ALL;
    private static final Object[] CONSTANTS_VALUES;
    private static final String[] CONSTANTS_TYPES;
    private static final String[] BOXING_TYPES;
    private static final String[] UNBOXING_METHODS;
    private static final Class<?>[] MERGEABLE_MIXIN_ANNOTATIONS;
    private static Pattern mergeableAnnotationPattern;
    private static final Logger logger;

    private Bytecode() {
    }

    public static MethodNode findMethod(ClassNode classNode, String string, String string2) {
        for (MethodNode methodNode : classNode.methods) {
            if (!methodNode.name.equals(string) || !methodNode.desc.equals(string2)) continue;
            return methodNode;
        }
        return null;
    }

    public static AbstractInsnNode findInsn(MethodNode methodNode, int n) {
        ListIterator<AbstractInsnNode> listIterator = methodNode.instructions.iterator();
        while (listIterator.hasNext()) {
            AbstractInsnNode abstractInsnNode = (AbstractInsnNode)listIterator.next();
            if (abstractInsnNode.getOpcode() != n) continue;
            return abstractInsnNode;
        }
        return null;
    }

    public static MethodInsnNode findSuperInit(MethodNode methodNode, String string) {
        if (!\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b(".\ua7ef\ua4bb\ua078\ua911\u7d28").equals(methodNode.name)) {
            return null;
        }
        int n = 0x6CFBB0C1 ^ 0x6CFBB0C1;
        ListIterator<AbstractInsnNode> listIterator = methodNode.instructions.iterator();
        while (listIterator.hasNext()) {
            AbstractInsnNode abstractInsnNode = (AbstractInsnNode)listIterator.next();
            if (abstractInsnNode instanceof TypeInsnNode) {
                if (abstractInsnNode.getOpcode() == (0x16256EB3 ^ 0x16256E08)) {
                    ++n;
                    continue;
                }
            }
            if (!(abstractInsnNode instanceof MethodInsnNode)) continue;
            if (abstractInsnNode.getOpcode() != (0x1624C8EF ^ 0x1624C858)) continue;
            MethodInsnNode methodInsnNode = (MethodInsnNode)abstractInsnNode;
            if (!\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b(".\ua7ef\ua4bb\ua078\ua911\u7d28").equals(methodInsnNode.name)) continue;
            if (n > 0) {
                --n;
                continue;
            }
            if (!methodInsnNode.owner.equals(string)) continue;
            return methodInsnNode;
        }
        return null;
    }

    public static void textify(ClassNode classNode, OutputStream outputStream) {
        classNode.accept(new TraceClassVisitor(new PrintWriter(outputStream)));
    }

    public static void textify(MethodNode methodNode, OutputStream outputStream) {
        TraceClassVisitor traceClassVisitor = new TraceClassVisitor(new PrintWriter(outputStream));
        MethodVisitor methodVisitor = traceClassVisitor.visitMethod(methodNode.access, methodNode.name, methodNode.desc, methodNode.signature, methodNode.exceptions.toArray(new String[0xA1977DF1 ^ 0xA1977DF1]));
        methodNode.accept(methodVisitor);
        traceClassVisitor.visitEnd();
    }

    public static void dumpClass(ClassNode classNode) {
        ClassWriter classWriter = new ClassWriter(0x2B9AE8EB ^ 0x2B9AE8E8);
        classNode.accept(classWriter);
        Bytecode.dumpClass(classWriter.toByteArray());
    }

    public static void dumpClass(byte[] byArray) {
        ClassReader classReader = new ClassReader(byArray);
        CheckClassAdapter.verify(classReader, (0xE60603A ^ 0xE60603B) != 0, new PrintWriter(System.out));
    }

    public static void printMethodWithOpcodeIndices(MethodNode methodNode) {
        Object[] objectArray = new Object[0x57898AA1 ^ 0x57898AA3];
        objectArray[0x8AB931D2 ^ 0x8AB931D2] = methodNode.name;
        objectArray[0x5BEDAE6E ^ 0x5BEDAE6F] = methodNode.desc;
        System.err.printf(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("7\ua7f5\ua4f0\ua062\ua96f"), objectArray);
        int n = 0x51FFBE8C ^ 0x51FFBE8C;
        ListIterator<AbstractInsnNode> listIterator = methodNode.instructions.iterator();
        while (listIterator.hasNext()) {
            Object[] objectArray2 = new Object[0x988C02C4 ^ 0x988C02C6];
            objectArray2[0xBCAAD3EB ^ 0xBCAAD3EB] = n++;
            objectArray2[0xAA41C463 ^ 0xAA41C462] = Bytecode.describeNode((AbstractInsnNode)listIterator.next());
            System.err.printf(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("I\ua7a3\ua4e1\ua075\ua938\u7d36\u8e0f\u2469\u8b5d"), objectArray2);
        }
    }

    public static void printMethod(MethodNode methodNode) {
        Object[] objectArray = new Object[0x434003F4 ^ 0x434003F6];
        objectArray[0x31A8A17A ^ 0x31A8A17A] = methodNode.name;
        objectArray[0x30516919 ^ 0x30516918] = methodNode.desc;
        System.err.printf(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("7\ua7f5\ua4f0\ua062\ua96f"), objectArray);
        ListIterator<AbstractInsnNode> listIterator = methodNode.instructions.iterator();
        while (listIterator.hasNext()) {
            System.err.print(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2\ua7a6"));
            Bytecode.printNode((AbstractInsnNode)listIterator.next());
        }
    }

    public static void printNode(AbstractInsnNode abstractInsnNode) {
        Object[] objectArray = new Object[0x5B20EFE4 ^ 0x5B20EFE5];
        objectArray[0xAD8BA0D5 ^ 0xAD8BA0D5] = Bytecode.describeNode(abstractInsnNode);
        System.err.printf(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("7\ua7f5\ua4df"), objectArray);
    }

    public static String describeNode(AbstractInsnNode abstractInsnNode) {
        if (abstractInsnNode == null) {
            Object[] objectArray = new Object[0xC4F8D87E ^ 0xC4F8D87F];
            objectArray[0x46368DCF ^ 0x46368DCF] = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("|\ua7f3\ua4b9\ua07d");
            return String.format(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2\ua7a6\ua4f5\ua034\ua948\u7d27\u8e1e\u2469\u8b77"), objectArray);
        }
        if (abstractInsnNode instanceof LabelNode) {
            Object[] objectArray = new Object[0xE5BBE72E ^ 0xE5BBE72F];
            objectArray[0x52C7141 ^ 0x52C7141] = ((LabelNode)abstractInsnNode).getLabel();
            return String.format(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("I\ua7a3\ua4a6\ua04c"), objectArray);
        }
        Object[] objectArray = new Object[0xDA8B23BB ^ 0xDA8B23BA];
        objectArray[0xF248692E ^ 0xF248692E] = abstractInsnNode.getClass().getSimpleName().replace(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("\\\ua7e9\ua4b1\ua074"), \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b(""));
        String string = String.format(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2\ua7a6\ua4f5\ua034\ua948\u7d27\u8e1e\u2469\u8b77"), objectArray);
        if (abstractInsnNode instanceof JumpInsnNode) {
            Object[] objectArray2 = new Object[0x717D3BEB ^ 0x717D3BE9];
            objectArray2[0xE51309FD ^ 0xE51309FD] = Bytecode.getOpcodeName(abstractInsnNode);
            objectArray2[0x1B9BDF3C ^ 0x1B9BDF3D] = ((JumpInsnNode)abstractInsnNode).label.getLabel();
            string = string + String.format(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("I\ua7a3\ua4a6\ua04c\ua945\u7d4d\u8e0f\u2469\u8b0a"), objectArray2);
        } else if (abstractInsnNode instanceof VarInsnNode) {
            Object[] objectArray3 = new Object[0x55A6884A ^ 0x55A68848];
            objectArray3[0x44600E32 ^ 0x44600E32] = Bytecode.getOpcodeName(abstractInsnNode);
            objectArray3[0x7A36A772 ^ 0x7A36A773] = ((VarInsnNode)abstractInsnNode).var;
            string = string + String.format(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("I\ua7a3\ua4a6\ua04c\ua945\u7d33\u8e4e"), objectArray3);
        } else if (abstractInsnNode instanceof MethodInsnNode) {
            MethodInsnNode methodInsnNode = (MethodInsnNode)abstractInsnNode;
            Object[] objectArray4 = new Object[0xB1D5A1E9 ^ 0xB1D5A1ED];
            objectArray4[0xAEFB2C3D ^ 0xAEFB2C3D] = Bytecode.getOpcodeName(abstractInsnNode);
            objectArray4[0x4B455E9A ^ 0x4B455E9B] = methodInsnNode.owner;
            objectArray4[0x6D70D2D ^ 0x6D70D2F] = methodInsnNode.name;
            objectArray4[0x3B8ACC41 ^ 0x3B8ACC42] = methodInsnNode.desc;
            string = string + String.format(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("I\ua7a3\ua4a6\ua04c\ua945\u7d33\u8e59\u243a\u8b72\u34642\ua7a3\ua4a6"), objectArray4);
        } else if (abstractInsnNode instanceof FieldInsnNode) {
            FieldInsnNode fieldInsnNode = (FieldInsnNode)abstractInsnNode;
            Object[] objectArray5 = new Object[0x340BBE60 ^ 0x340BBE64];
            objectArray5[0x27798A34 ^ 0x27798A34] = Bytecode.getOpcodeName(abstractInsnNode);
            objectArray5[0x76870E85 ^ 0x76870E84] = fieldInsnNode.owner;
            objectArray5[0xA129DFCC ^ 0xA129DFCE] = fieldInsnNode.name;
            objectArray5[0xBEE38060 ^ 0xBEE38063] = fieldInsnNode.desc;
            string = string + String.format(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("I\ua7a3\ua4a6\ua04c\ua945\u7d33\u8e59\u243a\u8b72\u34642\ua7a3\ua4a6"), objectArray5);
        } else if (abstractInsnNode instanceof LineNumberNode) {
            LineNumberNode lineNumberNode = (LineNumberNode)abstractInsnNode;
            Object[] objectArray6 = new Object[0xE677DD15 ^ 0xE677DD17];
            objectArray6[0xEE2E5EB7 ^ 0xEE2E5EB7] = lineNumberNode.line;
            objectArray6[0xA5092A7F ^ 0xA5092A7E] = lineNumberNode.start.getLabel();
            string = string + String.format(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("^\ua7cf\ua49b\ua054\ua958\u7d4d\u8e0f\u247e\u8b0a\u3437^\ua7c7\ua497\ua054\ua929\u7d2b\u8e71\u243f\u8b24\u344a"), objectArray6);
        } else if (abstractInsnNode instanceof LdcInsnNode) {
            string = string + ((LdcInsnNode)abstractInsnNode).cst;
        } else if (abstractInsnNode instanceof IntInsnNode) {
            string = string + ((IntInsnNode)abstractInsnNode).operand;
        } else if (abstractInsnNode instanceof FrameNode) {
            Object[] objectArray7 = new Object[0x39B8FF2D ^ 0x39B8FF2C];
            objectArray7[0x2F650033 ^ 0x2F650033] = Bytecode.getOpcodeName(((FrameNode)abstractInsnNode).type, \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("Z\ua7d9\ua49c\ua05f\ua933\u7d59\u8e61\u245f\u8b1e\u3459F\ua7c3\ua487\ua057\ua924\u7d55\u8e6f"), 0xD0741D79 ^ 0x2F8BE286);
            string = string + String.format(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("I\ua7a3\ua4a6\ua04c\ua945"), objectArray7);
        } else {
            Object[] objectArray8 = new Object[0xEE995D11 ^ 0xEE995D10];
            objectArray8[0xD346FF4 ^ 0xD346FF4] = Bytecode.getOpcodeName(abstractInsnNode);
            string = string + String.format(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("I\ua7a3\ua4a6\ua04c\ua945"), objectArray8);
        }
        return string;
    }

    public static String getOpcodeName(AbstractInsnNode abstractInsnNode) {
        return abstractInsnNode != null ? Bytecode.getOpcodeName(abstractInsnNode.getOpcode()) : \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("");
    }

    public static String getOpcodeName(int n) {
        return Bytecode.getOpcodeName(n, \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("G\ua7c8\ua49c\ua05f\ua92c\u7d42\u8e63\u245b\u8b1b\u345eH\ua7c3\ua491\ua04e\ua931\u7d5e\u8e63\u2449"), 0x23A358A7 ^ 0x23A358A6);
    }

    private static String getOpcodeName(int n, String string, int n2) {
        if (n >= n2) {
            int n3 = 0xA09A4C04 ^ 0xA09A4C04;
            try {
                Field[] fieldArray = Opcodes.class.getDeclaredFields();
                int n4 = fieldArray.length;
                for (int i = 0xFA25DAAD ^ 0xFA25DAAD; i < n4; ++i) {
                    Field field = fieldArray[i];
                    if (n3 == 0 && !field.getName().equals(string)) continue;
                    n3 = 0x5D0C28D6 ^ 0x5D0C28D7;
                    if (field.getType() != Integer.TYPE || field.getInt(null) != n) continue;
                    return field.getName();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n >= 0 ? String.valueOf(n) : \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("G\ua7c8\ua49e\ua05f\ua92a\u7d41\u8e64");
    }

    public static boolean methodHasLineNumbers(MethodNode methodNode) {
        ListIterator<AbstractInsnNode> listIterator = methodNode.instructions.iterator();
        while (listIterator.hasNext()) {
            if (!(listIterator.next() instanceof LineNumberNode)) continue;
            return (0x9C6B507B ^ 0x9C6B507A) != 0;
        }
        return (0xAC3C2A59 ^ 0xAC3C2A59) != 0;
    }

    public static boolean methodIsStatic(MethodNode methodNode) {
        return ((methodNode.access & (0x24E21665 ^ 0x24E2166D)) == (0x89693A1C ^ 0x89693A14) ? 0xE03C2936 ^ 0xE03C2937 : 0x5E5DF507 ^ 0x5E5DF507) != 0;
    }

    public static boolean fieldIsStatic(FieldNode fieldNode) {
        return ((fieldNode.access & (0x551A0C67 ^ 0x551A0C6F)) == (0x13861FD4 ^ 0x13861FDC) ? 0xBC4FAFFE ^ 0xBC4FAFFF : 0xDA9773A3 ^ 0xDA9773A3) != 0;
    }

    public static int getFirstNonArgLocalIndex(MethodNode methodNode) {
        return Bytecode.getFirstNonArgLocalIndex(Type.getArgumentTypes(methodNode.desc), ((methodNode.access & (0x2A392CF4 ^ 0x2A392CFC)) == 0 ? 0x8624730 ^ 0x8624731 : 0x75D5E7A8 ^ 0x75D5E7A8) != 0);
    }

    public static int getFirstNonArgLocalIndex(Type[] typeArray, boolean bl) {
        return Bytecode.getArgsSize(typeArray) + (bl ? 0x2869C938 ^ 0x2869C939 : 0x30C9EBDD ^ 0x30C9EBDD);
    }

    public static int getArgsSize(Type[] typeArray) {
        int n = 0x8006711A ^ 0x8006711A;
        Type[] typeArray2 = typeArray;
        int n2 = typeArray2.length;
        for (int i = 0x7D2B89F9 ^ 0x7D2B89F9; i < n2; ++i) {
            Type type = typeArray2[i];
            n += type.getSize();
        }
        return n;
    }

    public static void loadArgs(Type[] typeArray, InsnList insnList, int n) {
        Bytecode.loadArgs(typeArray, insnList, n, 0xA2D6490D ^ 0x5D29B6F2);
    }

    public static void loadArgs(Type[] typeArray, InsnList insnList, int n, int n2) {
        Bytecode.loadArgs(typeArray, insnList, n, n2, null);
    }

    public static void loadArgs(Type[] typeArray, InsnList insnList, int n, int n2, Type[] typeArray2) {
        int n3 = n;
        int n4 = 0x4AC143E7 ^ 0x4AC143E7;
        Type[] typeArray3 = typeArray;
        int n5 = typeArray3.length;
        for (int i = 0x7362AB35 ^ 0x7362AB35; i < n5; ++i) {
            Type type = typeArray3[i];
            insnList.add(new VarInsnNode(type.getOpcode(0x6E34EE3D ^ 0x6E34EE28), n3));
            if (typeArray2 != null && n4 < typeArray2.length && typeArray2[n4] != null) {
                insnList.add(new TypeInsnNode(0xB00DE384 ^ 0xB00DE344, typeArray2[n4].getInternalName()));
            }
            if (n2 >= n && (n3 += type.getSize()) >= n2) {
                return;
            }
            ++n4;
        }
    }

    public static Map<LabelNode, LabelNode> cloneLabels(InsnList insnList) {
        HashMap<LabelNode, LabelNode> hashMap = new HashMap<LabelNode, LabelNode>();
        ListIterator<AbstractInsnNode> listIterator = insnList.iterator();
        while (listIterator.hasNext()) {
            AbstractInsnNode abstractInsnNode = (AbstractInsnNode)listIterator.next();
            if (!(abstractInsnNode instanceof LabelNode)) continue;
            hashMap.put((LabelNode)abstractInsnNode, new LabelNode(((LabelNode)abstractInsnNode).getLabel()));
        }
        return hashMap;
    }

    public static String generateDescriptor(Object object, Object ... objectArray) {
        StringBuilder stringBuilder = new StringBuilder().append((char)(0x80C00224 ^ 0x80C0020C));
        Object[] objectArray2 = objectArray;
        int n = objectArray2.length;
        for (int i = 0x923EF146 ^ 0x923EF146; i < n; ++i) {
            Object object2 = objectArray2[i];
            stringBuilder.append(Bytecode.toDescriptor(object2));
        }
        return stringBuilder.append((char)(0x99FC6ABF ^ 0x99FC6A96)).append(object != null ? Bytecode.toDescriptor(object) : \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("D")).toString();
    }

    private static String toDescriptor(Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Type) {
            return object.toString();
        }
        if (object instanceof Class) {
            return Type.getDescriptor((Class)object);
        }
        return object == null ? \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("") : object.toString();
    }

    public static String getDescriptor(Type[] typeArray) {
        return \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b(":") + Joiner.on((String)\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("")).join((Object[])typeArray) + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b(";");
    }

    public static String getDescriptor(Type[] typeArray, Type type) {
        return Bytecode.getDescriptor(typeArray) + type.toString();
    }

    public static String changeDescriptorReturnType(String string, String string2) {
        if (string == null) {
            return null;
        }
        if (string2 == null) {
            return string;
        }
        return string.substring(0x8594DE4A ^ 0x8594DE4A, string.lastIndexOf(0xFCC42D54 ^ 0xFCC42D7D) + (0xD4BC1AFF ^ 0xD4BC1AFE)) + string2;
    }

    public static String getSimpleName(Class<? extends Annotation> clazz) {
        return clazz.getSimpleName();
    }

    public static String getSimpleName(AnnotationNode annotationNode) {
        return Bytecode.getSimpleName(annotationNode.desc);
    }

    public static String getSimpleName(String string) {
        int n = Math.max(string.lastIndexOf(0xBE0580EA ^ 0xBE0580C5), 0xFC2DECF0 ^ 0xFC2DECF0);
        return string.substring(n + (0x50693598 ^ 0x50693599)).replace(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b(")"), \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b(""));
    }

    public static boolean isConstant(AbstractInsnNode abstractInsnNode) {
        if (abstractInsnNode == null) {
            return (0x8C52983C ^ 0x8C52983C) != 0;
        }
        return Ints.contains((int[])CONSTANTS_ALL, (int)abstractInsnNode.getOpcode());
    }

    public static Object getConstant(AbstractInsnNode abstractInsnNode) {
        block5: {
            block7: {
                int n;
                block6: {
                    if (abstractInsnNode == null) {
                        return null;
                    }
                    if (abstractInsnNode instanceof LdcInsnNode) {
                        return ((LdcInsnNode)abstractInsnNode).cst;
                    }
                    if (!(abstractInsnNode instanceof IntInsnNode)) break block5;
                    n = ((IntInsnNode)abstractInsnNode).operand;
                    if (abstractInsnNode.getOpcode() == (0xE9B0EC2C ^ 0xE9B0EC3C)) break block6;
                    if (abstractInsnNode.getOpcode() != (0x1930FDFD ^ 0x1930FDEC)) break block7;
                }
                return n;
            }
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("[\ua7e8\ua4a1\ua058\ua90b\u7d65\u8e44\u2454\u8b38\u3473w\ua7a6\ua4a2\ua078\ua911\u7d7e\u8e0a\u2473\u8b39\u3461s\ua7ea\ua4bc\ua075\ua945\u7d79\u8e5a\u2479\u8b38\u3473w\ua7a6") + abstractInsnNode.getOpcode() + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2\ua7ef\ua4bb\ua031\ua902\u7d73\u8e5e\u2459\u8b38\u3479a\ua7f2\ua4b4\ua07f\ua911"));
        }
        int n = Ints.indexOf((int[])CONSTANTS_ALL, (int)abstractInsnNode.getOpcode());
        return n < 0 ? null : CONSTANTS_VALUES[n];
    }

    public static Type getConstantType(AbstractInsnNode abstractInsnNode) {
        if (abstractInsnNode == null) {
            return null;
        }
        if (abstractInsnNode instanceof LdcInsnNode) {
            Object object = ((LdcInsnNode)abstractInsnNode).cst;
            if (object instanceof Integer) {
                return Type.getType(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("["));
            }
            if (object instanceof Float) {
                return Type.getType(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("T"));
            }
            if (object instanceof Long) {
                return Type.getType(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("X"));
            }
            if (object instanceof Double) {
                return Type.getType(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("V"));
            }
            if (object instanceof String) {
                return Type.getType(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("^\ua7ec\ua4b4\ua067\ua904\u7d39\u8e46\u247b\u8b39\u3470=\ua7d5\ua4a1\ua063\ua90c\u7d78\u8e4d\u2421"));
            }
            if (object instanceof Type) {
                return Type.getType(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("^\ua7ec\ua4b4\ua067\ua904\u7d39\u8e46\u247b\u8b39\u3470=\ua7c5\ua4b9\ua070\ua916\u7d65\u8e11"));
            }
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("^\ua7e2\ua4b6\ua058\ua90b\u7d65\u8e44\u2454\u8b38\u3473w\ua7a6\ua4a2\ua078\ua911\u7d7e\u8e0a\u2473\u8b39\u3461s\ua7ea\ua4bc\ua075\ua945\u7d66\u8e4b\u2463\u8b3b\u3478s\ua7e2\ua4f5\ua065\ua91c\u7d66\u8e4f\u243a") + object.getClass() + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2\ua7ef\ua4bb\ua031\ua902\u7d73\u8e5e\u2459\u8b38\u3479a\ua7f2\ua4b4\ua07f\ua911"));
        }
        int n = Ints.indexOf((int[])CONSTANTS_ALL, (int)abstractInsnNode.getOpcode());
        return n < 0 ? null : Type.getType(CONSTANTS_TYPES[n]);
    }

    public static boolean hasFlag(ClassNode classNode, int n) {
        return ((classNode.access & n) == n ? 0x5AEE4123 ^ 0x5AEE4122 : 0x61043435 ^ 0x61043435) != 0;
    }

    public static boolean hasFlag(MethodNode methodNode, int n) {
        return ((methodNode.access & n) == n ? 0x2D7B9012 ^ 0x2D7B9013 : 0x32A4ABB2 ^ 0x32A4ABB2) != 0;
    }

    public static boolean hasFlag(FieldNode fieldNode, int n) {
        return ((fieldNode.access & n) == n ? 0x1215EC68 ^ 0x1215EC69 : 0xC3897F5 ^ 0xC3897F5) != 0;
    }

    public static boolean compareFlags(MethodNode methodNode, MethodNode methodNode2, int n) {
        return (Bytecode.hasFlag(methodNode, n) == Bytecode.hasFlag(methodNode2, n) ? 0xC031B81 ^ 0xC031B80 : 0xC9E81109 ^ 0xC9E81109) != 0;
    }

    public static boolean compareFlags(FieldNode fieldNode, FieldNode fieldNode2, int n) {
        return (Bytecode.hasFlag(fieldNode, n) == Bytecode.hasFlag(fieldNode2, n) ? 0xCC30CF3C ^ 0xCC30CF3D : 0x24C0EA3B ^ 0x24C0EA3B) != 0;
    }

    public static Visibility getVisibility(MethodNode methodNode) {
        return Bytecode.getVisibility(methodNode.access & (0xE7CABD8 ^ 0xE7CABDF));
    }

    public static Visibility getVisibility(FieldNode fieldNode) {
        return Bytecode.getVisibility(fieldNode.access & (0xCAC2FC38 ^ 0xCAC2FC3F));
    }

    private static Visibility getVisibility(int n) {
        if ((n & (0x9B0C09D7 ^ 0x9B0C09D3)) != 0) {
            return Visibility.PROTECTED;
        }
        if ((n & (0x5DFB050E ^ 0x5DFB050C)) != 0) {
            return Visibility.PRIVATE;
        }
        if ((n & (0xF6EE9FD1 ^ 0xF6EE9FD0)) != 0) {
            return Visibility.PUBLIC;
        }
        return Visibility.PACKAGE;
    }

    public static void setVisibility(MethodNode methodNode, Visibility visibility) {
        methodNode.access = Bytecode.setVisibility(methodNode.access, visibility.access);
    }

    public static void setVisibility(FieldNode fieldNode, Visibility visibility) {
        fieldNode.access = Bytecode.setVisibility(fieldNode.access, visibility.access);
    }

    public static void setVisibility(MethodNode methodNode, int n) {
        methodNode.access = Bytecode.setVisibility(methodNode.access, n);
    }

    public static void setVisibility(FieldNode fieldNode, int n) {
        fieldNode.access = Bytecode.setVisibility(fieldNode.access, n);
    }

    private static int setVisibility(int n, int n2) {
        return n & (0x8857B28F ^ 0x77A84D77) | n2 & (0xA9EBC3EB ^ 0xA9EBC3EC);
    }

    public static int getMaxLineNumber(ClassNode classNode, int n, int n2) {
        int n3 = 0xCD824436 ^ 0xCD824436;
        for (MethodNode methodNode : classNode.methods) {
            ListIterator<AbstractInsnNode> listIterator = methodNode.instructions.iterator();
            while (listIterator.hasNext()) {
                AbstractInsnNode abstractInsnNode = (AbstractInsnNode)listIterator.next();
                if (!(abstractInsnNode instanceof LineNumberNode)) continue;
                n3 = Math.max(n3, ((LineNumberNode)abstractInsnNode).line);
            }
        }
        return Math.max(n, n3 + n2);
    }

    public static String getBoxingType(Type type) {
        return type == null ? null : BOXING_TYPES[type.getSort()];
    }

    public static String getUnboxingMethod(Type type) {
        return type == null ? null : UNBOXING_METHODS[type.getSort()];
    }

    public static void mergeAnnotations(ClassNode classNode, ClassNode classNode2) {
        classNode2.visibleAnnotations = Bytecode.mergeAnnotations(classNode.visibleAnnotations, classNode2.visibleAnnotations, \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("q\ua7ea\ua4b4\ua062\ua916"), classNode.name);
        classNode2.invisibleAnnotations = Bytecode.mergeAnnotations(classNode.invisibleAnnotations, classNode2.invisibleAnnotations, \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("q\ua7ea\ua4b4\ua062\ua916"), classNode.name);
    }

    public static void mergeAnnotations(MethodNode methodNode, MethodNode methodNode2) {
        methodNode2.visibleAnnotations = Bytecode.mergeAnnotations(methodNode.visibleAnnotations, methodNode2.visibleAnnotations, \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("\u007f\ua7e3\ua4a1\ua079\ua90a\u7d72"), methodNode.name);
        methodNode2.invisibleAnnotations = Bytecode.mergeAnnotations(methodNode.invisibleAnnotations, methodNode2.invisibleAnnotations, \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("\u007f\ua7e3\ua4a1\ua079\ua90a\u7d72"), methodNode.name);
    }

    public static void mergeAnnotations(FieldNode fieldNode, FieldNode fieldNode2) {
        fieldNode2.visibleAnnotations = Bytecode.mergeAnnotations(fieldNode.visibleAnnotations, fieldNode2.visibleAnnotations, \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("t\ua7ef\ua4b0\ua07d\ua901"), fieldNode.name);
        fieldNode2.invisibleAnnotations = Bytecode.mergeAnnotations(fieldNode.invisibleAnnotations, fieldNode2.invisibleAnnotations, \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("t\ua7ef\ua4b0\ua07d\ua901"), fieldNode.name);
    }

    private static List<AnnotationNode> mergeAnnotations(List<AnnotationNode> list, List<AnnotationNode> list2, String string, String string2) {
        try {
            if (list == null) {
                return list2;
            }
            if (list2 == null) {
                list2 = new ArrayList<AnnotationNode>();
            }
            for (AnnotationNode annotationNode : list) {
                if (!Bytecode.isMergeableAnnotation(annotationNode)) continue;
                Iterator<AnnotationNode> iterator = list2.iterator();
                while (iterator.hasNext()) {
                    if (!iterator.next().desc.equals(annotationNode.desc)) continue;
                    iterator.remove();
                    break;
                }
                list2.add(annotationNode);
            }
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[0x91445732 ^ 0x91445730];
            objectArray[0x5659B7C9 ^ 0x5659B7C9] = string;
            objectArray[0xA29789D2 ^ 0xA29789D3] = string2;
            logger.warn(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("W\ua7fe\ua4b6\ua074\ua915\u7d62\u8e43\u2475\u8b39\u3437w\ua7e8\ua4b6\ua07e\ua910\u7d78\u8e5e\u247f\u8b25\u3472v\ua7a6\ua4a2\ua079\ua90c\u7d7a\u8e59\u246e\u8b77\u347aw\ua7f4\ua4b2\ua078\ua90b\u7d71\u8e0a\u247b\u8b39\u3479}\ua7f2\ua4b4\ua065\ua90c\u7d79\u8e44\u2469\u8b77\u3471}\ua7f4\ua4f5\ua06a\ua918\u7d36\u8e51\u2467"), objectArray);
        }
        return list2;
    }

    private static boolean isMergeableAnnotation(AnnotationNode annotationNode) {
        if (annotationNode.desc.startsWith(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("^") + Constants.MIXIN_PACKAGE_REF)) {
            return mergeableAnnotationPattern.matcher(annotationNode.desc).matches();
        }
        return (0xD8AF6EB ^ 0xD8AF6EA) != 0;
    }

    private static Pattern getMergeableAnnotationPattern() {
        StringBuilder stringBuilder = new StringBuilder(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("L\ua7ca\ua4fd"));
        for (int i = 0x4AEC917 ^ 0x4AEC917; i < MERGEABLE_MIXIN_ANNOTATIONS.length; ++i) {
            if (i > 0) {
                stringBuilder.append((char)(0xF6C5610A ^ 0xF6C56176));
            }
            stringBuilder.append(MERGEABLE_MIXIN_ANNOTATIONS[i].getName().replace((char)(0x2FFF24B4 ^ 0x2FFF249A), (char)(0xBC6C7015 ^ 0xBC6C703A)));
        }
        return Pattern.compile(stringBuilder.append(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b(";\ua7bd\ua4f1")).toString());
    }

    public static void compareBridgeMethods(MethodNode methodNode, MethodNode methodNode2) {
        ListIterator<AbstractInsnNode> listIterator = methodNode.instructions.iterator();
        ListIterator<AbstractInsnNode> listIterator2 = methodNode2.instructions.iterator();
        int n = 0x86FF17FE ^ 0x86FF17FE;
        while (listIterator.hasNext() && listIterator2.hasNext()) {
            AbstractInsnNode abstractInsnNode = listIterator.next();
            AbstractInsnNode abstractInsnNode2 = listIterator2.next();
            if (!(abstractInsnNode instanceof LabelNode)) {
                AbstractInsnNode abstractInsnNode3;
                AbstractInsnNode abstractInsnNode4;
                if (abstractInsnNode instanceof MethodInsnNode) {
                    abstractInsnNode4 = (MethodInsnNode)abstractInsnNode;
                    abstractInsnNode3 = (MethodInsnNode)abstractInsnNode2;
                    if (!((MethodInsnNode)abstractInsnNode4).name.equals(abstractInsnNode3.name)) {
                        throw new SyntheticBridgeException(SyntheticBridgeException.Problem.BAD_INVOKE_NAME, methodNode.name, methodNode.desc, n, abstractInsnNode, abstractInsnNode2);
                    }
                    if (!((MethodInsnNode)abstractInsnNode4).desc.equals(abstractInsnNode3.desc)) {
                        throw new SyntheticBridgeException(SyntheticBridgeException.Problem.BAD_INVOKE_DESC, methodNode.name, methodNode.desc, n, abstractInsnNode, abstractInsnNode2);
                    }
                } else {
                    if (abstractInsnNode.getOpcode() != abstractInsnNode2.getOpcode()) {
                        throw new SyntheticBridgeException(SyntheticBridgeException.Problem.BAD_INSN, methodNode.name, methodNode.desc, n, abstractInsnNode, abstractInsnNode2);
                    }
                    if (abstractInsnNode instanceof VarInsnNode) {
                        abstractInsnNode4 = (VarInsnNode)abstractInsnNode;
                        abstractInsnNode3 = (VarInsnNode)abstractInsnNode2;
                        if (((VarInsnNode)abstractInsnNode4).var != ((VarInsnNode)abstractInsnNode3).var) {
                            throw new SyntheticBridgeException(SyntheticBridgeException.Problem.BAD_LOAD, methodNode.name, methodNode.desc, n, abstractInsnNode, abstractInsnNode2);
                        }
                    } else if (abstractInsnNode instanceof TypeInsnNode) {
                        abstractInsnNode4 = (TypeInsnNode)abstractInsnNode;
                        abstractInsnNode3 = (TypeInsnNode)abstractInsnNode2;
                        if (abstractInsnNode4.getOpcode() == (0x2C96F72 ^ 0x2C96FB2) && !((TypeInsnNode)abstractInsnNode4).desc.equals(((TypeInsnNode)abstractInsnNode3).desc)) {
                            throw new SyntheticBridgeException(SyntheticBridgeException.Problem.BAD_CAST, methodNode.name, methodNode.desc, n, abstractInsnNode, abstractInsnNode2);
                        }
                    }
                }
            }
            ++n;
        }
        if (listIterator.hasNext() || listIterator2.hasNext()) {
            throw new SyntheticBridgeException(SyntheticBridgeException.Problem.BAD_LENGTH, methodNode.name, methodNode.desc, n, null, null);
        }
    }

    static {
        int[] nArray = new int[0xA529D388 ^ 0xA529D38F];
        nArray[0xC28192F6 ^ 0xC28192F6] = 0xCB153DDA ^ 0xCB153DD8;
        nArray[0x7A98EDC0 ^ 0x7A98EDC1] = 0x121B6E7A ^ 0x121B6E79;
        nArray[0xD61CB4DF ^ 0xD61CB4DD] = 0x31B18302 ^ 0x31B18306;
        nArray[0x20D6CC17 ^ 0x20D6CC14] = 0x92D37BC1 ^ 0x92D37BC4;
        nArray[0x845DF3B6 ^ 0x845DF3B2] = 0x8FD7B9EA ^ 0x8FD7B9EC;
        nArray[0x99E34EC2 ^ 0x99E34EC7] = 0xFC178FAF ^ 0xFC178FA8;
        nArray[0x3565A4F2 ^ 0x3565A4F4] = 0x748892C7 ^ 0x748892CF;
        CONSTANTS_INT = nArray;
        int[] nArray2 = new int[0x84E6859F ^ 0x84E6859C];
        nArray2[0xB7BB2CA1 ^ 0xB7BB2CA1] = 0x87616E9F ^ 0x87616E94;
        nArray2[0xCA14710C ^ 0xCA14710D] = 0x195E7318 ^ 0x195E7314;
        nArray2[0x1C2B5A72 ^ 0x1C2B5A70] = 0x7434B033 ^ 0x7434B03E;
        CONSTANTS_FLOAT = nArray2;
        int[] nArray3 = new int[0x1A7A5C9C ^ 0x1A7A5C9E];
        nArray3[0xA4E05099 ^ 0xA4E05099] = 0x833D5034 ^ 0x833D503A;
        nArray3[0x81C4C312 ^ 0x81C4C313] = 0x90088A7F ^ 0x90088A70;
        CONSTANTS_DOUBLE = nArray3;
        int[] nArray4 = new int[0x440A724E ^ 0x440A724C];
        nArray4[0x101665F6 ^ 0x101665F6] = 0x61143872 ^ 0x6114387B;
        nArray4[0xC739A96 ^ 0xC739A97] = 0xA1D8EC23 ^ 0xA1D8EC29;
        CONSTANTS_LONG = nArray4;
        int[] nArray5 = new int[0x6CF5A888 ^ 0x6CF5A89A];
        nArray5[0x85987CE1 ^ 0x85987CE1] = 0x987CDC9B ^ 0x987CDC9A;
        nArray5[0x43738D4F ^ 0x43738D4E] = 0xFCA85EB3 ^ 0xFCA85EB1;
        nArray5[0x364E624B ^ 0x364E6249] = 0x5D6D4651 ^ 0x5D6D4652;
        nArray5[0x70334EA ^ 0x70334E9] = 0x9F81D8DD ^ 0x9F81D8D9;
        nArray5[0x9365F75B ^ 0x9365F75F] = 0xD562793B ^ 0xD562793E;
        nArray5[0x8AEE17E1 ^ 0x8AEE17E4] = 0xCCFE7827 ^ 0xCCFE7821;
        nArray5[0xC947261C ^ 0xC947261A] = 0x55652A23 ^ 0x55652A24;
        nArray5[0xC46E3A12 ^ 0xC46E3A15] = 0x5E9D9E19 ^ 0x5E9D9E11;
        nArray5[0xCE28FC80 ^ 0xCE28FC88] = 0x13019AD4 ^ 0x13019ADD;
        nArray5[0x91B49026 ^ 0x91B4902F] = 0x400AECBF ^ 0x400AECB5;
        nArray5[0x7841D8B3 ^ 0x7841D8B9] = 0xD7DC2635 ^ 0xD7DC263E;
        nArray5[0x91533FB2 ^ 0x91533FB9] = 0x5B9D4F1E ^ 0x5B9D4F12;
        nArray5[0x2166E3D8 ^ 0x2166E3D4] = 0x2AFAA62C ^ 0x2AFAA621;
        nArray5[0x706F48EC ^ 0x706F48E1] = 0x20AE564B ^ 0x20AE5645;
        nArray5[0xE64D790A ^ 0xE64D7904] = 0xD4E39FAE ^ 0xD4E39FA1;
        nArray5[0x23A0C6FE ^ 0x23A0C6F1] = 0xC951FFA0 ^ 0xC951FFB0;
        nArray5[0x26CAA6E8 ^ 0x26CAA6F8] = 0xCBA37DE4 ^ 0xCBA37DF5;
        nArray5[0xB0B711CF ^ 0xB0B711DE] = 0xF0F9510B ^ 0xF0F95119;
        CONSTANTS_ALL = nArray5;
        Object[] objectArray = new Object[0x67203AFE ^ 0x67203AF1];
        objectArray[0xF4ECCBE9 ^ 0xF4ECCBE9] = null;
        objectArray[0x80927AEF ^ 0x80927AEE] = 0x56A5BEC ^ 0xFA95A413;
        objectArray[0x14E1BBE3 ^ 0x14E1BBE1] = 0x265908BF ^ 0x265908BF;
        objectArray[0x6AEBEC0D ^ 0x6AEBEC0E] = 0x6DA9679C ^ 0x6DA9679D;
        objectArray[0x6554DF0 ^ 0x6554DF4] = 0x937D9E2D ^ 0x937D9E2F;
        objectArray[0xF0AD43A ^ 0xF0AD43F] = 0x27319F5E ^ 0x27319F5D;
        objectArray[0xD83F7AC4 ^ 0xD83F7AC2] = 0x238B696F ^ 0x238B696B;
        objectArray[0x58BA6C6B ^ 0x58BA6C6C] = 0x9E5DA67B ^ 0x9E5DA67E;
        objectArray[0x60BE620A ^ 0x60BE6202] = 0x84C742CF5D5EA8C5L ^ 0x84C742CF5D5EA8C5L;
        objectArray[0x2B76214B ^ 0x2B762142] = 0xA5F3E0BD938276EAL ^ 0xA5F3E0BD938276EBL;
        objectArray[0xE9B95795 ^ 0xE9B9579F] = Float.valueOf(0.0f);
        objectArray[0xC82CEF94 ^ 0xC82CEF9F] = Float.valueOf(1.0f);
        objectArray[0xC3027730 ^ 0xC302773C] = Float.valueOf(2.0f);
        objectArray[0x30B514BB ^ 0x30B514B6] = 0.0;
        objectArray[0x783BD848 ^ 0x783BD846] = 1.0;
        CONSTANTS_VALUES = objectArray;
        String[] stringArray = new String[0x34F6FA5B ^ 0x34F6FA4A];
        stringArray[0x4AE3C7A1 ^ 0x4AE3C7A1] = null;
        stringArray[0x4EA62911 ^ 0x4EA62910] = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("[");
        stringArray[0x73C8CC8A ^ 0x73C8CC88] = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("[");
        stringArray[0x60635D8 ^ 0x60635DB] = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("[");
        stringArray[0x463C695 ^ 0x463C691] = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("[");
        stringArray[0x42414E42 ^ 0x42414E47] = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("[");
        stringArray[0x7C1A2687 ^ 0x7C1A2681] = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("[");
        stringArray[0xAADF0581 ^ 0xAADF0586] = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("[");
        stringArray[0x41F6A956 ^ 0x41F6A95E] = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("X");
        stringArray[0xDEB8EC37 ^ 0xDEB8EC3E] = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("X");
        stringArray[0x12AB69B1 ^ 0x12AB69BB] = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("T");
        stringArray[0xFD2A89E9 ^ 0xFD2A89E2] = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("T");
        stringArray[0xE6BB8CFD ^ 0xE6BB8CF1] = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("T");
        stringArray[0x3E40D1E4 ^ 0x3E40D1E9] = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("V");
        stringArray[0x17489A7A ^ 0x17489A74] = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("V");
        stringArray[0x7339332D ^ 0x73393322] = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("[");
        stringArray[0x90F2C9DA ^ 0x90F2C9CA] = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("[");
        CONSTANTS_TYPES = stringArray;
        String[] stringArray2 = new String[0x98523CD8 ^ 0x98523CD4];
        stringArray2[0x3B746C43 ^ 0x3B746C43] = null;
        stringArray2[0x3D51B0E ^ 0x3D51B0F] = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438P\ua7e9\ua4ba\ua07d\ua900\u7d77\u8e44");
        stringArray2[0x6348810E ^ 0x6348810C] = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438Q\ua7ee\ua4b4\ua063\ua904\u7d75\u8e5e\u247f\u8b25");
        stringArray2[0xC730AF86 ^ 0xC730AF85] = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438P\ua7ff\ua4a1\ua074");
        stringArray2[0x8D61A502 ^ 0x8D61A506] = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438A\ua7ee\ua4ba\ua063\ua911");
        stringArray2[0x7089FF9 ^ 0x7089FFC] = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438[\ua7e8\ua4a1\ua074\ua902\u7d73\u8e58");
        stringArray2[0xD6F84DBC ^ 0xD6F84DBA] = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438T\ua7ea\ua4ba\ua070\ua911");
        stringArray2[0x72846E6B ^ 0x72846E6C] = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438^\ua7e9\ua4bb\ua076");
        stringArray2[0xB9AE07E0 ^ 0xB9AE07E8] = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438V\ua7e9\ua4a0\ua073\ua909\u7d73");
        stringArray2[0x2F38E1C9 ^ 0x2F38E1C0] = null;
        stringArray2[0x196A44D6 ^ 0x196A44DC] = null;
        stringArray2[0xC43FECE1 ^ 0xC43FECEA] = null;
        BOXING_TYPES = stringArray2;
        String[] stringArray3 = new String[0x7C421051 ^ 0x7C42105D];
        stringArray3[0x96D87109 ^ 0x96D87109] = null;
        stringArray3[0xA9AFB300 ^ 0xA9AFB301] = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("p\ua7e9\ua4ba\ua07d\ua900\u7d77\u8e44\u244c\u8b36\u347bg\ua7e3");
        stringArray3[0x6343CCEC ^ 0x6343CCEE] = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("q\ua7ee\ua4b4\ua063\ua933\u7d77\u8e46\u246f\u8b32");
        stringArray3[0x64404955 ^ 0x64404956] = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("p\ua7ff\ua4a1\ua074\ua933\u7d77\u8e46\u246f\u8b32");
        stringArray3[0x55A6D26C ^ 0x55A6D268] = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("a\ua7ee\ua4ba\ua063\ua911\u7d40\u8e4b\u2476\u8b22\u3472");
        stringArray3[0x63286DD ^ 0x63286D8] = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("{\ua7e8\ua4a1\ua047\ua904\u7d7a\u8e5f\u247f");
        stringArray3[0xAC0B4BF2 ^ 0xAC0B4BF4] = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("t\ua7ea\ua4ba\ua070\ua911\u7d40\u8e4b\u2476\u8b22\u3472");
        stringArray3[0x5B5EB59C ^ 0x5B5EB59B] = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("~\ua7e9\ua4bb\ua076\ua933\u7d77\u8e46\u246f\u8b32");
        stringArray3[0xC61FA6FE ^ 0xC61FA6F6] = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("v\ua7e9\ua4a0\ua073\ua909\u7d73\u8e7c\u247b\u8b3b\u3462w");
        stringArray3[0x6BE9C118 ^ 0x6BE9C111] = null;
        stringArray3[0x6ECB84DA ^ 0x6ECB84D0] = null;
        stringArray3[0x345EC179 ^ 0x345EC172] = null;
        UNBOXING_METHODS = stringArray3;
        Class[] classArray = new Class[0x376FB4E6 ^ 0x376FB4E2];
        classArray[0x62CCB8AC ^ 0x62CCB8AC] = Overwrite.class;
        classArray[0xB211BC4C ^ 0xB211BC4D] = Intrinsic.class;
        classArray[0x3BEC6227 ^ 0x3BEC6225] = Final.class;
        classArray[0x2D4F13E3 ^ 0x2D4F13E0] = Debug.class;
        MERGEABLE_MIXIN_ANNOTATIONS = classArray;
        mergeableAnnotationPattern = Bytecode.getMergeableAnnotationPattern();
        logger = LogManager.getLogger((String)\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("\u007f\ua7ef\ua4ad\ua078\ua90b"));
    }

    public static final class Visibility
    extends Enum<Visibility> {
        public static final /* enum */ Visibility PRIVATE = new Visibility(0xA175FAFB ^ 0xA175FAF9);
        public static final /* enum */ Visibility PROTECTED = new Visibility(0xD39485 ^ 0xD39481);
        public static final /* enum */ Visibility PACKAGE = new Visibility(0xB4A2ABC ^ 0xB4A2ABC);
        public static final /* enum */ Visibility PUBLIC = new Visibility(0xD1E7698C ^ 0xD1E7698D);
        static final int MASK = 7;
        final int access;
        private static final /* synthetic */ Visibility[] $VALUES;

        public static Visibility[] values() {
            return (Visibility[])$VALUES.clone();
        }

        public static Visibility valueOf(String string) {
            return Enum.valueOf(Visibility.class, string);
        }

        private Visibility(int n2) {
            this.access = n2;
        }

        static {
            Visibility[] visibilityArray = new Visibility[0x92B09DA1 ^ 0x92B09DA5];
            visibilityArray[0xF898CA3E ^ 0xF898CA3E] = PRIVATE;
            visibilityArray[0x4F222A2 ^ 0x4F222A3] = PROTECTED;
            visibilityArray[0x9A1A96A2 ^ 0x9A1A96A0] = PACKAGE;
            visibilityArray[0x9453511D ^ 0x9453511E] = PUBLIC;
            $VALUES = visibilityArray;
        }
    }
}

