/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.util;

import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.spongepowered.asm.lib.signature.SignatureReader;
import org.spongepowered.asm.lib.signature.SignatureVisitor;
import org.spongepowered.asm.lib.signature.SignatureWriter;
import org.spongepowered.asm.lib.tree.ClassNode;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2;

public class ClassSignature {
    protected static final String OBJECT = "java/lang/Object";
    private final Map<TypeVar, TokenHandle> types = new LinkedHashMap<TypeVar, TokenHandle>();
    private Token superClass = new Token(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438]\ua7e4\ua4bf\ua074\ua906\u7d62"));
    private final List<Token> interfaces = new ArrayList<Token>();
    private final Deque<String> rawInterfaces = new LinkedList<String>();

    ClassSignature() {
    }

    private ClassSignature read(String string) {
        if (string != null) {
            try {
                new SignatureReader(string).accept(new SignatureParser());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return this;
    }

    protected TypeVar getTypeVar(String string) {
        for (TypeVar typeVar : this.types.keySet()) {
            if (!typeVar.matches(string)) continue;
            return typeVar;
        }
        return null;
    }

    protected TokenHandle getType(String string) {
        for (TypeVar typeVar : this.types.keySet()) {
            if (!typeVar.matches(string)) continue;
            return this.types.get(typeVar);
        }
        TokenHandle tokenHandle = new TokenHandle();
        this.types.put(new TypeVar(string), tokenHandle);
        return tokenHandle;
    }

    protected String getTypeVar(TokenHandle tokenHandle) {
        for (Map.Entry<TypeVar, TokenHandle> entry : this.types.entrySet()) {
            TypeVar typeVar = entry.getKey();
            TokenHandle tokenHandle2 = entry.getValue();
            if (tokenHandle != tokenHandle2 && tokenHandle.asToken() != tokenHandle2.asToken()) continue;
            return \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("F") + typeVar + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b(")");
        }
        return tokenHandle.token.asType();
    }

    protected void addTypeVar(TypeVar typeVar, TokenHandle tokenHandle) throws IllegalArgumentException {
        if (this.types.containsKey(typeVar)) {
            throw new IllegalArgumentException(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("F\ua7ff\ua4a5\ua074\ua933\u7d77\u8e58\u243a") + typeVar + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2\ua7ef\ua4a6\ua031\ua904\u7d7a\u8e58\u247f\u8b36\u3473k\ua7a6\ua4a5\ua063\ua900\u7d65\u8e4f\u2474\u8b23\u3437}\ua7e8\ua4f5") + this);
        }
        this.types.put(typeVar, tokenHandle);
    }

    protected void setSuperClass(Token token) {
        this.superClass = token;
    }

    public String getSuperClass() {
        return this.superClass.asType((0x38294438 ^ 0x38294439) != 0);
    }

    protected void addInterface(Token token) {
        if (!token.isRaw()) {
            String string = token.asType((0xEFD2168D ^ 0xEFD2168C) != 0);
            ListIterator<Token> listIterator = this.interfaces.listIterator();
            while (listIterator.hasNext()) {
                Token token2 = listIterator.next();
                if (!token2.isRaw()) continue;
                if (!token2.asType((0x2187D666 ^ 0x2187D667) != 0).equals(string)) continue;
                listIterator.set(token);
                return;
            }
        }
        this.interfaces.add(token);
    }

    public void addInterface(String string) {
        this.rawInterfaces.add(string);
    }

    protected void addRawInterface(String string) {
        Token token = new Token(string);
        String string2 = token.asType((0xFE5252CB ^ 0xFE5252CA) != 0);
        for (Token token2 : this.interfaces) {
            if (!token2.asType((0xBA0566EB ^ 0xBA0566EA) != 0).equals(string2)) continue;
            return;
        }
        this.interfaces.add(token);
    }

    public void merge(ClassSignature classSignature) {
        try {
            Iterator<Token> iterator = new HashSet<String>();
            for (TypeVar typeVar : this.types.keySet()) {
                iterator.add((Token)((Object)typeVar.toString()));
            }
            classSignature.conform((Set<String>)((Object)iterator));
        }
        catch (IllegalStateException illegalStateException) {
            illegalStateException.printStackTrace();
            return;
        }
        for (Map.Entry entry : classSignature.types.entrySet()) {
            this.addTypeVar((TypeVar)entry.getKey(), (TokenHandle)entry.getValue());
        }
        for (Token token : classSignature.interfaces) {
            this.addInterface(token);
        }
    }

    private void conform(Set<String> set) {
        for (TypeVar typeVar : this.types.keySet()) {
            String string = this.findUniqueName(typeVar.getOriginalName(), set);
            typeVar.rename(string);
            set.add(string);
        }
    }

    private String findUniqueName(String string, Set<String> set) {
        String string2;
        if (!set.contains(string)) {
            return string;
        }
        if (string.length() == (0xAEE794CC ^ 0xAEE794CD)) {
            string2 = this.findOffsetName(string.charAt(0x484FEA5A ^ 0x484FEA5A), set);
            if (string2 != null) {
                return string2;
            }
        }
        if ((string2 = this.findOffsetName((char)(0x40FC9D80 ^ 0x40FC9DD4), set, \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b(""), string)) != null) {
            return string2;
        }
        string2 = this.findOffsetName((char)(0xC252FB72 ^ 0xC252FB26), set, string, \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b(""));
        if (string2 != null) {
            return string2;
        }
        string2 = this.findOffsetName((char)(0x59AA843D ^ 0x59AA8469), set, \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("F"), string);
        if (string2 != null) {
            return string2;
        }
        string2 = this.findOffsetName((char)(0x42360B58 ^ 0x42360B0C), set, \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b(""), string + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("F\ua7ff\ua4a5\ua074"));
        if (string2 != null) {
            return string2;
        }
        throw new IllegalStateException(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("T\ua7e7\ua4bc\ua07d\ua900\u7d72\u8e0a\u246e\u8b38\u3437q\ua7e9\ua4bb\ua077\ua90a\u7d64\u8e47\u243a\u8b23\u346eb\ua7e3\ua4f5\ua067\ua904\u7d64\u8e10\u243a") + string);
    }

    private String findOffsetName(char c, Set<String> set) {
        return this.findOffsetName(c, set, \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b(""), \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b(""));
    }

    private String findOffsetName(char c, Set<String> set, String string, String string2) {
        Object[] objectArray = new Object[0x60301D30 ^ 0x60301D33];
        objectArray[0x33B5DF62 ^ 0x33B5DF62] = string;
        objectArray[0x3C80D5FD ^ 0x3C80D5FC] = Character.valueOf(c);
        objectArray[0xFC57155C ^ 0xFC57155E] = string2;
        String string3 = String.format(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("7\ua7f5\ua4f0\ua062\ua940\u7d65"), objectArray);
        if (!set.contains(string3)) {
            return string3;
        }
        if (c > (0x86F427F4 ^ 0x86F427B4)) {
            if (c < (0x57DC4D82 ^ 0x57DC4DD9)) {
                int n = c - (0xBCB05053 ^ 0xBCB05013);
                while (true) {
                    if (n + (0x329860A ^ 0x329864B) == c) break;
                    Object[] objectArray2 = new Object[0x5E0CB82F ^ 0x5E0CB82C];
                    objectArray2[0xD5A99B0E ^ 0xD5A99B0E] = string;
                    objectArray2[0x74C8FB2E ^ 0x74C8FB2F] = Character.valueOf((char)(n + (0x8C69DA91 ^ 0x8C69DAD0)));
                    objectArray2[0x16464B3B ^ 0x16464B39] = string2;
                    string3 = String.format(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("7\ua7f5\ua4f0\ua062\ua940\u7d65"), objectArray2);
                    if (!set.contains(string3)) {
                        return string3;
                    }
                    ++n;
                    n %= 0x6396C764 ^ 0x6396C77E;
                }
            }
        }
        return null;
    }

    public SignatureVisitor getRemapper() {
        return new SignatureRemapper();
    }

    public String toString() {
        while (this.rawInterfaces.size() > 0) {
            this.addRawInterface(this.rawInterfaces.remove());
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (this.types.size() > 0) {
            int n = 0x34136139 ^ 0x34136139;
            StringBuilder object = new StringBuilder();
            for (Map.Entry<TypeVar, TokenHandle> entry : this.types.entrySet()) {
                String string = entry.getValue().asBound();
                if (string.isEmpty()) continue;
                object.append(entry.getKey()).append((char)(0x3B775F2D ^ 0x3B775F17)).append(string);
                n = 0xFCE1AC8C ^ 0xFCE1AC8D;
            }
            if (n != 0) {
                stringBuilder.append((char)(0xFABD7371 ^ 0xFABD734D)).append((CharSequence)object).append((char)(0x8F18B77A ^ 0x8F18B744));
            }
        }
        stringBuilder.append(this.superClass.asType());
        for (Token token : this.interfaces) {
            stringBuilder.append(token.asType());
        }
        return stringBuilder.toString();
    }

    public ClassSignature wake() {
        return this;
    }

    public static ClassSignature of(String string) {
        return new ClassSignature().read(string);
    }

    public static ClassSignature of(ClassNode classNode) {
        if (classNode.signature != null) {
            return ClassSignature.of(classNode.signature);
        }
        return ClassSignature.generate(classNode);
    }

    public static ClassSignature ofLazy(ClassNode classNode) {
        if (classNode.signature != null) {
            return new Lazy(classNode.signature);
        }
        return ClassSignature.generate(classNode);
    }

    private static ClassSignature generate(ClassNode classNode) {
        ClassSignature classSignature = new ClassSignature();
        classSignature.setSuperClass(new Token(classNode.superName != null ? classNode.superName : \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438]\ua7e4\ua4bf\ua074\ua906\u7d62")));
        for (String string : classNode.interfaces) {
            classSignature.addInterface(new Token(string));
        }
        return classSignature;
    }

    class SignatureRemapper
    extends SignatureWriter {
        private final Set<String> localTypeVars = new HashSet<String>();

        SignatureRemapper() {
        }

        @Override
        public void visitFormalTypeParameter(String string) {
            this.localTypeVars.add(string);
            super.visitFormalTypeParameter(string);
        }

        @Override
        public void visitTypeVariable(String string) {
            TypeVar typeVar;
            if (!this.localTypeVars.contains(string) && (typeVar = ClassSignature.this.getTypeVar(string)) != null) {
                super.visitTypeVariable(typeVar.toString());
                return;
            }
            super.visitTypeVariable(string);
        }
    }

    class SignatureParser
    extends SignatureVisitor {
        private FormalParamElement param;

        SignatureParser() {
            super(0x3084FC51 ^ 0x3081FC51);
        }

        @Override
        public void visitFormalTypeParameter(String string) {
            this.param = new FormalParamElement(string);
        }

        @Override
        public SignatureVisitor visitClassBound() {
            return this.param.visitClassBound();
        }

        @Override
        public SignatureVisitor visitInterfaceBound() {
            return this.param.visitInterfaceBound();
        }

        @Override
        public SignatureVisitor visitSuperclass() {
            return new SuperClassElement();
        }

        @Override
        public SignatureVisitor visitInterface() {
            return new InterfaceElement();
        }

        class InterfaceElement
        extends TokenElement {
            InterfaceElement() {
            }

            @Override
            public void visitEnd() {
                ClassSignature.this.addInterface(this.token);
            }
        }

        class SuperClassElement
        extends TokenElement {
            SuperClassElement() {
            }

            @Override
            public void visitEnd() {
                ClassSignature.this.setSuperClass(this.token);
            }
        }

        class BoundElement
        extends TokenElement {
            private final TokenElement type;
            private final boolean classBound;

            BoundElement(TokenElement tokenElement, boolean bl) {
                this.type = tokenElement;
                this.classBound = bl;
            }

            @Override
            public void visitClassType(String string) {
                this.token = this.type.token.addBound(string, this.classBound);
            }

            @Override
            public void visitTypeArgument() {
                this.token.addTypeArgument((char)(0xFAEEA96E ^ 0xFAEEA944));
            }

            @Override
            public SignatureVisitor visitTypeArgument(char c) {
                return new TypeArgElement(this, c);
            }
        }

        class TypeArgElement
        extends TokenElement {
            private final TokenElement type;
            private final char wildcard;

            TypeArgElement(TokenElement tokenElement, char c) {
                this.type = tokenElement;
                this.wildcard = c;
            }

            @Override
            public SignatureVisitor visitArrayType() {
                this.type.setArray();
                return this;
            }

            @Override
            public void visitBaseType(char c) {
                this.token = this.type.addTypeArgument(c).asToken();
            }

            @Override
            public void visitTypeVariable(String string) {
                TokenHandle tokenHandle = ClassSignature.this.getType(string);
                this.token = this.type.addTypeArgument(tokenHandle).setWildcard(this.wildcard).asToken();
            }

            @Override
            public void visitClassType(String string) {
                this.token = this.type.addTypeArgument(string).setWildcard(this.wildcard).asToken();
            }

            @Override
            public void visitTypeArgument() {
                this.token.addTypeArgument((char)(0x5DA1DD79 ^ 0x5DA1DD53));
            }

            @Override
            public SignatureVisitor visitTypeArgument(char c) {
                return new TypeArgElement(this, c);
            }

            @Override
            public void visitEnd() {
            }
        }

        class FormalParamElement
        extends TokenElement {
            private final TokenHandle handle;

            FormalParamElement(String string) {
                this.handle = ClassSignature.this.getType(string);
                this.token = this.handle.asToken();
            }
        }

        abstract class TokenElement
        extends SignatureElement {
            protected Token token;
            private boolean array;

            TokenElement() {
            }

            public Token getToken() {
                if (this.token == null) {
                    this.token = new Token();
                }
                return this.token;
            }

            protected void setArray() {
                this.array = 0x3E9B660D ^ 0x3E9B660C;
            }

            private boolean getArray() {
                boolean bl = this.array;
                this.array = 0x3ACD2A1E ^ 0x3ACD2A1E;
                return bl;
            }

            @Override
            public void visitClassType(String string) {
                this.getToken().setType(string);
            }

            @Override
            public SignatureVisitor visitClassBound() {
                this.getToken();
                return new BoundElement(this, (0x24F4F788 ^ 0x24F4F789) != 0);
            }

            @Override
            public SignatureVisitor visitInterfaceBound() {
                this.getToken();
                return new BoundElement(this, (0x8C3324E1 ^ 0x8C3324E1) != 0);
            }

            @Override
            public void visitInnerClassType(String string) {
                this.token.addInnerClass(string);
            }

            @Override
            public SignatureVisitor visitArrayType() {
                this.setArray();
                return this;
            }

            @Override
            public SignatureVisitor visitTypeArgument(char c) {
                return new TypeArgElement(this, c);
            }

            Token addTypeArgument() {
                return this.token.addTypeArgument((char)(0xAF8DF5ED ^ 0xAF8DF5C7)).asToken();
            }

            IToken addTypeArgument(char c) {
                return this.token.addTypeArgument(c).setArray(this.getArray());
            }

            IToken addTypeArgument(String string) {
                return this.token.addTypeArgument(string).setArray(this.getArray());
            }

            IToken addTypeArgument(Token token) {
                return this.token.addTypeArgument(token).setArray(this.getArray());
            }

            IToken addTypeArgument(TokenHandle tokenHandle) {
                return this.token.addTypeArgument(tokenHandle).setArray(this.getArray());
            }
        }

        abstract class SignatureElement
        extends SignatureVisitor {
            public SignatureElement() {
                super(0xFA997212 ^ 0xFA9C7212);
            }
        }
    }

    class TokenHandle
    implements IToken {
        final Token token;
        boolean array;
        char wildcard;

        TokenHandle() {
            this(new Token());
        }

        TokenHandle(Token token) {
            this.token = token;
        }

        @Override
        public IToken setArray(boolean bl) {
            this.array |= bl;
            return this;
        }

        @Override
        public IToken setWildcard(char c) {
            if (\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("9\ua7ab").indexOf(c) > (0x40851CD8 ^ 0xBF7AE327)) {
                this.wildcard = c;
            }
            return this;
        }

        @Override
        public String asBound() {
            return this.token.asBound();
        }

        @Override
        public String asType() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.wildcard > '\u0000') {
                stringBuilder.append(this.wildcard);
            }
            if (this.array) {
                stringBuilder.append((char)(0xD8AFBC54 ^ 0xD8AFBC0F));
            }
            return stringBuilder.append(ClassSignature.this.getTypeVar(this)).toString();
        }

        @Override
        public Token asToken() {
            return this.token;
        }

        public String toString() {
            return this.token.toString();
        }

        public TokenHandle clone() {
            return new TokenHandle(this.token);
        }
    }

    static class Token
    implements IToken {
        static final String SYMBOLS = "+-*";
        private final boolean inner;
        private boolean array;
        private char symbol = (char)(0xA250E1F7 ^ 0xA250E1F7);
        private String type;
        private List<Token> classBound;
        private List<Token> ifaceBound;
        private List<IToken> signature;
        private List<IToken> suffix;
        private Token tail;

        Token() {
            this((0x7194F057 ^ 0x7194F057) != 0);
        }

        Token(String string) {
            this(string, (0xAEEE6A9D ^ 0xAEEE6A9D) != 0);
        }

        Token(char c) {
            this();
            this.symbol = c;
        }

        Token(boolean bl) {
            this(null, bl);
        }

        Token(String string, boolean bl) {
            this.inner = bl;
            this.type = string;
        }

        Token setSymbol(char c) {
            if (this.symbol == '\u0000') {
                if (\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("9\ua7ab\ua4ff").indexOf(c) > (0xA0ED0717 ^ 0x5F12F8E8)) {
                    this.symbol = c;
                }
            }
            return this;
        }

        Token setType(String string) {
            if (this.type == null) {
                this.type = string;
            }
            return this;
        }

        boolean hasClassBound() {
            return (this.classBound != null ? 0xBDE61172 ^ 0xBDE61173 : 0xBC5159AD ^ 0xBC5159AD) != 0;
        }

        boolean hasInterfaceBound() {
            return (this.ifaceBound != null ? 0xB3D87F3 ^ 0xB3D87F2 : 0x963546E1 ^ 0x963546E1) != 0;
        }

        @Override
        public IToken setArray(boolean bl) {
            this.array |= bl;
            return this;
        }

        @Override
        public IToken setWildcard(char c) {
            if (\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("9\ua7ab").indexOf(c) == (0xA5307C40 ^ 0x5ACF83BF)) {
                return this;
            }
            return this.setSymbol(c);
        }

        private List<Token> getClassBound() {
            if (this.classBound == null) {
                this.classBound = new ArrayList<Token>();
            }
            return this.classBound;
        }

        private List<Token> getIfaceBound() {
            if (this.ifaceBound == null) {
                this.ifaceBound = new ArrayList<Token>();
            }
            return this.ifaceBound;
        }

        private List<IToken> getSignature() {
            if (this.signature == null) {
                this.signature = new ArrayList<IToken>();
            }
            return this.signature;
        }

        private List<IToken> getSuffix() {
            if (this.suffix == null) {
                this.suffix = new ArrayList<IToken>();
            }
            return this.suffix;
        }

        IToken addTypeArgument(char c) {
            if (this.tail != null) {
                return this.tail.addTypeArgument(c);
            }
            Token token = new Token(c);
            this.getSignature().add(token);
            return token;
        }

        IToken addTypeArgument(String string) {
            if (this.tail != null) {
                return this.tail.addTypeArgument(string);
            }
            Token token = new Token(string);
            this.getSignature().add(token);
            return token;
        }

        IToken addTypeArgument(Token token) {
            if (this.tail != null) {
                return this.tail.addTypeArgument(token);
            }
            this.getSignature().add(token);
            return token;
        }

        IToken addTypeArgument(TokenHandle tokenHandle) {
            if (this.tail != null) {
                return this.tail.addTypeArgument(tokenHandle);
            }
            TokenHandle tokenHandle2 = tokenHandle.clone();
            this.getSignature().add(tokenHandle2);
            return tokenHandle2;
        }

        Token addBound(String string, boolean bl) {
            if (bl) {
                return this.addClassBound(string);
            }
            return this.addInterfaceBound(string);
        }

        Token addClassBound(String string) {
            Token token = new Token(string);
            this.getClassBound().add(token);
            return token;
        }

        Token addInterfaceBound(String string) {
            Token token = new Token(string);
            this.getIfaceBound().add(token);
            return token;
        }

        Token addInnerClass(String string) {
            this.tail = new Token(string, (0x39966F44 ^ 0x39966F45) != 0);
            this.getSuffix().add(this.tail);
            return this.tail;
        }

        public String toString() {
            return this.asType();
        }

        @Override
        public String asBound() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.type != null) {
                stringBuilder.append(this.type);
            }
            if (this.classBound != null) {
                for (Token token : this.classBound) {
                    stringBuilder.append(token.asType());
                }
            }
            if (this.ifaceBound != null) {
                for (Token token : this.ifaceBound) {
                    stringBuilder.append((char)(0xE189A0B ^ 0xE189A31)).append(token.asType());
                }
            }
            return stringBuilder.toString();
        }

        @Override
        public String asType() {
            return this.asType((0x5E6F86EF ^ 0x5E6F86EF) != 0);
        }

        public String asType(boolean bl) {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.array) {
                stringBuilder.append((char)(0xBD6FD0A0 ^ 0xBD6FD0FB));
            }
            if (this.symbol != '\u0000') {
                stringBuilder.append(this.symbol);
            }
            if (this.type == null) {
                return stringBuilder.toString();
            }
            if (!this.inner) {
                stringBuilder.append((char)(0x19CCB1DC ^ 0x19CCB190));
            }
            stringBuilder.append(this.type);
            if (!bl) {
                if (this.signature != null) {
                    stringBuilder.append((char)(0x9CAF94A9 ^ 0x9CAF9495));
                    for (IToken iToken : this.signature) {
                        stringBuilder.append(iToken.asType());
                    }
                    stringBuilder.append((char)(0xAE7FE939 ^ 0xAE7FE907));
                }
                if (this.suffix != null) {
                    for (IToken iToken : this.suffix) {
                        stringBuilder.append((char)(0x19542D4E ^ 0x19542D60)).append(iToken.asType());
                    }
                }
            }
            if (!this.inner) {
                stringBuilder.append((char)(0x27D12DE3 ^ 0x27D12DD8));
            }
            return stringBuilder.toString();
        }

        boolean isRaw() {
            return (this.signature == null ? 0x79FF875A ^ 0x79FF875B : 0xEAD274F1 ^ 0xEAD274F1) != 0;
        }

        String getClassType() {
            return this.type != null ? this.type : \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("x\ua7e7\ua4a3\ua070\ua94a\u7d7a\u8e4b\u2474\u8b30\u3438]\ua7e4\ua4bf\ua074\ua906\u7d62");
        }

        @Override
        public Token asToken() {
            return this;
        }
    }

    static interface IToken {
        public static final String WILDCARDS = "+-";

        public String asType();

        public String asBound();

        public Token asToken();

        public IToken setArray(boolean var1);

        public IToken setWildcard(char var1);
    }

    static class TypeVar
    implements Comparable<TypeVar> {
        private final String originalName;
        private String currentName;

        TypeVar(String string) {
            this.currentName = this.originalName = string;
        }

        @Override
        public int compareTo(TypeVar typeVar) {
            return this.currentName.compareTo(typeVar.currentName);
        }

        public String toString() {
            return this.currentName;
        }

        String getOriginalName() {
            return this.originalName;
        }

        void rename(String string) {
            this.currentName = string;
        }

        public boolean matches(String string) {
            return this.originalName.equals(string);
        }

        public boolean equals(Object object) {
            return this.currentName.equals(object);
        }

        public int hashCode() {
            return this.currentName.hashCode();
        }
    }

    static class Lazy
    extends ClassSignature {
        private final String sig;
        private ClassSignature generated;

        Lazy(String string) {
            this.sig = string;
        }

        @Override
        public ClassSignature wake() {
            if (this.generated == null) {
                this.generated = ClassSignature.of(this.sig);
            }
            return this.generated;
        }
    }
}

