/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.util.Annotations;
import org.spongepowered.asm.util.ITokenProvider;
import org.spongepowered.asm.util.throwables.ConstraintViolationException;
import org.spongepowered.asm.util.throwables.InvalidConstraintException;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2;

public final class ConstraintParser {
    private ConstraintParser() {
    }

    public static Constraint parse(String string) {
        if (string == null || string.length() == 0) {
            return Constraint.NONE;
        }
        String[] stringArray = string.replaceAll(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("N\ua7f5"), \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("")).toUpperCase().split(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b(")"));
        Constraint constraint = null;
        String[] stringArray2 = stringArray;
        int n = stringArray2.length;
        for (int i = 0xD88A8D36 ^ 0xD88A8D36; i < n; ++i) {
            String string2 = stringArray2[i];
            Constraint constraint2 = new Constraint(string2);
            if (constraint == null) {
                constraint = constraint2;
                continue;
            }
            constraint.append(constraint2);
        }
        return constraint != null ? constraint : Constraint.NONE;
    }

    public static Constraint parse(AnnotationNode annotationNode) {
        String string = Annotations.getValue(annotationNode, \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("q\ua7e9\ua4bb\ua062\ua911\u7d64\u8e4b\u2473\u8b39\u3463a"), \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b(""));
        return ConstraintParser.parse(string);
    }

    public static class Constraint {
        public static final Constraint NONE = new Constraint();
        private static final Pattern pattern = Pattern.compile(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("L\ua7ae\ua48e\ua050\ua948\u7d4c\u8e1a\u2437\u8b6e\u344b?\ua7d9\ua489\ua03f\ua938\u7d3d\u8e03\u2446\u8b7f\u343f-\ua7bc\ua4fd\ua02d\ua919\u7d2a\u8e17\u2466\u8b69\u346b,\ua7bb\ua4a9\ua02c\ua94c\u7d29\u8e02\u2441\u8b67\u343a+\ua7db\ua4fe\ua038\ua94d\u7d2a\u8e56\u2432\u8b7a\u343e:\ua7dd\ua4e5\ua03c\ua95c\u7d4b\u8e01\u2433\u8b68\u346b,\ua7fa\ua4fd\ua04d\ua94e\u7d3f\u8e02\u2441\u8b67\u343a+\ua7db\ua4fe\ua038\ua95a\u7d3f\u8e15\u2433\u8b68\u344b;\ua7a2"));
        private final String expr;
        private String token;
        private String[] constraint;
        private int min;
        private int max;
        private Constraint next;

        Constraint(String string) {
            this.min = 0x3629ABCE ^ 0xB629ABCE;
            this.max = 0x6CD25937 ^ 0x132DA6C8;
            this.expr = string;
            Matcher matcher = pattern.matcher(string);
            if (!matcher.matches()) {
                throw new InvalidConstraintException(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("Q\ua7e9\ua4bb\ua062\ua911\u7d64\u8e4b\u2473\u8b39\u34632\ua7f5\ua4ac\ua07f\ua911\u7d77\u8e52\u243a\u8b20\u3476a\ua7a6\ua4bc\ua07f\ua913\u7d77\u8e46\u2473\u8b33\u3437b\ua7e7\ua4a7\ua062\ua90c\u7d78\u8e4d\u2420\u8b77") + this.expr);
            }
            this.token = matcher.group(0x2138B8A8 ^ 0x2138B8A9);
            String[] stringArray = new String[0xC77C9B58 ^ 0xC77C9B5F];
            stringArray[0x425A2B6F ^ 0x425A2B6F] = matcher.group(0x7DA708BB ^ 0x7DA708B9);
            stringArray[0x2FA4ECA9 ^ 0x2FA4ECA8] = matcher.group(0x7B6AD4C ^ 0x7B6AD4F);
            stringArray[0x91D34033 ^ 0x91D34031] = matcher.group(0x722D02DF ^ 0x722D02DB);
            stringArray[0x1EDA3E62 ^ 0x1EDA3E61] = matcher.group(0x6D2DC57D ^ 0x6D2DC578);
            stringArray[0xD8483EDE ^ 0xD8483EDA] = matcher.group(0x3DE9FC2E ^ 0x3DE9FC28);
            stringArray[0x25820573 ^ 0x25820576] = matcher.group(0x574AFE91 ^ 0x574AFE96);
            stringArray[0x475AE21F ^ 0x475AE219] = matcher.group(0xD743CBCA ^ 0xD743CBC2);
            this.constraint = stringArray;
            this.parse();
        }

        private Constraint() {
            this.min = 0x8A9B9CB3 ^ 0xA9B9CB3;
            this.max = 0x5C1901AB ^ 0x23E6FE54;
            this.expr = null;
            this.token = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("8");
            this.constraint = new String[0x9003ED99 ^ 0x9003ED99];
        }

        private void parse() {
            if (!this.has(0x1D1F667D ^ 0x1D1F667C)) {
                return;
            }
            this.max = this.min = this.val(0x7753AD0 ^ 0x7753AD1);
            boolean bl = this.has(0x892EFF41 ^ 0x892EFF41);
            if (this.has(0x5F01E76E ^ 0x5F01E76A)) {
                if (bl) {
                    throw new InvalidConstraintException(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("G\ua7e8\ua4b0\ua069\ua915\u7d73\u8e49\u246e\u8b32\u34732\ua7eb\ua4ba\ua075\ua90c\u7d70\u8e43\u247f\u8b25\u34375") + this.elem(0x40B048D ^ 0x40B048D) + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("5\ua7a6\ua4bc\ua07f\ua945") + this.expr + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2\ua7f6\ua4b4\ua063\ua916\u7d7f\u8e44\u247d\u8b77\u3465s\ua7e8\ua4b2\ua074"));
                }
                this.max = this.val(0x43E2A144 ^ 0x43E2A140);
                if (this.max < this.min) {
                    throw new InvalidConstraintException(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b25\u3476|\ua7e1\ua4b0\ua031\ua916\u7d66\u8e4f\u2479\u8b3e\u3471{\ua7e3\ua4b1\ua031\ua942") + this.max + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("5\ua7a6\ua4bc\ua062\ua945\u7d7a\u8e4f\u2469\u8b24\u3437f\ua7ee\ua4b4\ua07f\ua945") + this.min + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2\ua7ef\ua4bb\ua031") + this.expr);
                }
                return;
            }
            if (this.has(0x254951E6 ^ 0x254951E0)) {
                if (bl) {
                    throw new InvalidConstraintException(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("G\ua7e8\ua4b0\ua069\ua915\u7d73\u8e49\u246e\u8b32\u34732\ua7eb\ua4ba\ua075\ua90c\u7d70\u8e43\u247f\u8b25\u34375") + this.elem(0xE315E3E ^ 0xE315E3E) + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("5\ua7a6\ua4bc\ua07f\ua945") + this.expr + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2\ua7f6\ua4b4\ua063\ua916\u7d7f\u8e44\u247d\u8b77\u3465s\ua7e8\ua4b2\ua074"));
                }
                this.max = this.min + this.val(0xE3D85320 ^ 0xE3D85326);
                return;
            }
            if (bl) {
                if (this.has(0xBC81C2F9 ^ 0xBC81C2FA)) {
                    throw new InvalidConstraintException(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("G\ua7e8\ua4b0\ua069\ua915\u7d73\u8e49\u246e\u8b32\u34732\ua7f2\ua4a7\ua070\ua90c\u7d7a\u8e43\u2474\u8b30\u3437\u007f\ua7e9\ua4b1\ua078\ua903\u7d7f\u8e4f\u2468\u8b77\u3430") + this.elem(0x29E5978D ^ 0x29E5978E) + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("5\ua7a6\ua4bc\ua07f\ua945") + this.expr);
                }
                String string = this.elem(0x916ED8A1 ^ 0x916ED8A1);
                if (\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b(",").equals(string)) {
                    this.min += 0x7857D0B3 ^ 0x7857D0B2;
                    this.max = 0x496EE967 ^ 0x36911698;
                } else if (\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b(",\ua7bb").equals(string)) {
                    this.max = 0x6FFBE676 ^ 0x10041989;
                } else if (\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b(".").equals(string)) {
                    this.max = this.min -= 0xFFC76665 ^ 0xFFC76664;
                    this.min = 0x993EBA24 ^ 0x193EBA24;
                } else if (\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b(".\ua7bb").equals(string)) {
                    this.max = this.min;
                    this.min = 0x50B36EE6 ^ 0xD0B36EE6;
                }
            } else if (this.has(0x2EAC69D5 ^ 0x2EAC69D7)) {
                String string = this.elem(0x10837350 ^ 0x10837352);
                if (\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b(".").equals(string)) {
                    this.max = this.min;
                    this.min = 0x8EEE7F23 ^ 0xEEE7F23;
                } else {
                    this.max = 0xF8F00FB ^ 0x7070FF04;
                }
            }
        }

        private boolean has(int n) {
            return (this.constraint[n] != null ? 0x2F6B4369 ^ 0x2F6B4368 : 0x7264CCBE ^ 0x7264CCBE) != 0;
        }

        private String elem(int n) {
            return this.constraint[n];
        }

        private int val(int n) {
            return this.constraint[n] != null ? Integer.parseInt(this.constraint[n]) : 0xC9AB923A ^ 0xC9AB923A;
        }

        void append(Constraint constraint) {
            if (this.next != null) {
                this.next.append(constraint);
                return;
            }
            this.next = constraint;
        }

        public String getToken() {
            return this.token;
        }

        public int getMin() {
            return this.min;
        }

        public int getMax() {
            return this.max;
        }

        public void check(ITokenProvider iTokenProvider) throws ConstraintViolationException {
            if (this != NONE) {
                Integer n = iTokenProvider.getToken(this.token);
                if (n == null) {
                    throw new ConstraintViolationException(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("F\ua7ee\ua4b0\ua031\ua911\u7d79\u8e41\u247f\u8b39\u34375") + this.token + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("5\ua7a6\ua4b6\ua07e\ua910\u7d7a\u8e4e\u243a\u8b39\u3478f\ua7a6\ua4b7\ua074\ua945\u7d64\u8e4f\u2469\u8b38\u347bd\ua7e3\ua4b1\ua031\ua90c\u7d78\u8e0a") + iTokenProvider, this);
                }
                if (n < this.min) {
                    throw new ConstraintViolationException(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("F\ua7e9\ua4be\ua074\ua90b\u7d36\u8e0d") + this.token + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("5\ua7a6\ua4bd\ua070\ua916\u7d36\u8e4b\u243a\u8b21\u3476~\ua7f3\ua4b0\ua031\ua94d") + n + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b(";\ua7a6\ua4a2\ua079\ua90c\u7d75\u8e42\u243a\u8b3e\u34642\ua7ea\ua4b0\ua062\ua916\u7d36\u8e5e\u2472\u8b36\u34792\ua7f2\ua4bd\ua074\ua945\u7d7b\u8e43\u2474\u8b3e\u347ag\ua7eb\ua4f5\ua067\ua904\u7d7a\u8e5f\u247f\u8b77") + this.min + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2\ua7ef\ua4bb\ua031") + iTokenProvider, this, (int)n);
                }
                if (n > this.max) {
                    throw new ConstraintViolationException(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("F\ua7e9\ua4be\ua074\ua90b\u7d36\u8e0d") + this.token + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("5\ua7a6\ua4bd\ua070\ua916\u7d36\u8e4b\u243a\u8b21\u3476~\ua7f3\ua4b0\ua031\ua94d") + n + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b(";\ua7a6\ua4a2\ua079\ua90c\u7d75\u8e42\u243a\u8b3e\u34642\ua7e1\ua4a7\ua074\ua904\u7d62\u8e4f\u2468\u8b77\u3463z\ua7e7\ua4bb\ua031\ua911\u7d7e\u8e4f\u243a\u8b3a\u3476j\ua7ef\ua4b8\ua064\ua908\u7d36\u8e5c\u247b\u8b3b\u3462w\ua7a6") + this.max + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2\ua7ef\ua4bb\ua031") + iTokenProvider, this, (int)n);
                }
            }
            if (this.next != null) {
                this.next.check(iTokenProvider);
            }
        }

        public String getRangeHumanReadable() {
            if (this.min == (0x542A8E6B ^ 0xD42A8E6B)) {
                if (this.max == (0xF636711D ^ 0x89C98EE2)) {
                    return \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("S\ua7c8\ua48c\ua031\ua933\u7d57\u8e66\u244f\u8b12");
                }
            }
            if (this.min == (0x22FBF2E7 ^ 0xA2FBF2E7)) {
                Object[] objectArray = new Object[0xBDDD853A ^ 0xBDDD853B];
                objectArray[0xF4934732 ^ 0xF4934732] = this.max;
                return String.format(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("~\ua7e3\ua4a6\ua062\ua945\u7d62\u8e42\u247b\u8b39\u3437}\ua7f4\ua4f5\ua074\ua914\u7d63\u8e4b\u2476\u8b77\u3463}\ua7a6\ua4f0\ua075"), objectArray);
            }
            if (this.max == (0xE1F424C4 ^ 0x9E0BDB3B)) {
                Object[] objectArray = new Object[0x6A09F735 ^ 0x6A09F734];
                objectArray[0xBFB741D5 ^ 0xBFB741D5] = this.min;
                return String.format(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("u\ua7f4\ua4b0\ua070\ua911\u7d73\u8e58\u243a\u8b23\u347fs\ua7e8\ua4f5\ua07e\ua917\u7d36\u8e4f\u246b\u8b22\u3476~\ua7a6\ua4a1\ua07e\ua945\u7d33\u8e4e"), objectArray);
            }
            if (this.min == this.max) {
                Object[] objectArray = new Object[0xB53E7B15 ^ 0xB53E7B14];
                objectArray[0x7E76F488 ^ 0x7E76F488] = this.min;
                return String.format(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("7\ua7e2"), objectArray);
            }
            Object[] objectArray = new Object[0xF32E367E ^ 0xF32E367C];
            objectArray[0x997F73E1 ^ 0x997F73E1] = this.min;
            objectArray[0x27771012 ^ 0x27771013] = this.max;
            return String.format(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("p\ua7e3\ua4a1\ua066\ua900\u7d73\u8e44\u243a\u8b72\u34732\ua7e7\ua4bb\ua075\ua945\u7d33\u8e4e"), objectArray);
        }

        public String toString() {
            Object[] objectArray = new Object[0xB2A918F1 ^ 0xB2A918F2];
            objectArray[0xE7C8D6AB ^ 0xE7C8D6AB] = this.token;
            objectArray[0xED19B11 ^ 0xED19B10] = this.min;
            objectArray[0x9E597CCC ^ 0x9E597CCE] = this.max;
            return String.format(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("Q\ua7e9\ua4bb\ua062\ua911\u7d64\u8e4b\u2473\u8b39\u3463:\ua7a3\ua4a6\ua031\ua93e\u7d33\u8e4e\u2437\u8b72\u3473O\ua7af"), objectArray);
        }
    }
}

