/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.spongepowered.asm.lib.Opcodes;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.lib.tree.FrameNode;
import org.spongepowered.asm.lib.tree.InsnList;
import org.spongepowered.asm.lib.tree.LabelNode;
import org.spongepowered.asm.lib.tree.LineNumberNode;
import org.spongepowered.asm.lib.tree.LocalVariableNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.lib.tree.VarInsnNode;
import org.spongepowered.asm.lib.tree.analysis.Analyzer;
import org.spongepowered.asm.lib.tree.analysis.AnalyzerException;
import org.spongepowered.asm.lib.tree.analysis.BasicValue;
import org.spongepowered.asm.lib.tree.analysis.Frame;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import org.spongepowered.asm.util.asm.MixinVerifier;
import org.spongepowered.asm.util.throwables.LVTGeneratorException;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2;

public final class Locals {
    private static final Map<String, List<LocalVariableNode>> calculatedLocalVariables = new HashMap<String, List<LocalVariableNode>>();

    private Locals() {
    }

    public static void loadLocals(Type[] typeArray, InsnList insnList, int n, int n2) {
        while (n < typeArray.length && n2 > 0) {
            if (typeArray[n] != null) {
                insnList.add(new VarInsnNode(typeArray[n].getOpcode(0xA4ABFBD4 ^ 0xA4ABFBC1), n));
                --n2;
            }
            ++n;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LocalVariableNode[] getLocalsAt(ClassNode classNode, MethodNode methodNode, AbstractInsnNode abstractInsnNode) {
        Object object;
        int n;
        int n2 = 0xB83E1DA7 ^ 0xB83E1DA7;
        while (true) {
            if (n2 >= (0x837C6015 ^ 0x837C6016) || !(abstractInsnNode instanceof LabelNode) && !(abstractInsnNode instanceof LineNumberNode)) break;
            abstractInsnNode = Locals.nextNode(methodNode.instructions, abstractInsnNode);
            ++n2;
        }
        ClassInfo classInfo = ClassInfo.forName(classNode.name);
        if (classInfo == null) {
            throw new LVTGeneratorException(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("Q\ua7e9\ua4a0\ua07d\ua901\u7d36\u8e44\u2475\u8b23\u3437~\ua7e9\ua4b4\ua075\ua945\u7d75\u8e46\u247b\u8b24\u34642\ua7eb\ua4b0\ua065\ua904\u7d72\u8e4b\u246e\u8b36\u3437t\ua7e9\ua4a7\ua031") + classNode.name + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2\ua7e1\ua4b0\ua07f\ua900\u7d64\u8e4b\u246e\u8b3e\u3479u\ua7a6\ua499\ua047\ua931\u7d36\u8e4c\u2475\u8b25\u3437") + methodNode.name);
        }
        ClassInfo.Method method = classInfo.findMethod(methodNode);
        if (method == null) {
            throw new LVTGeneratorException(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("Q\ua7e9\ua4a0\ua07d\ua901\u7d36\u8e44\u2475\u8b23\u3437~\ua7e9\ua4b6\ua070\ua911\u7d73\u8e0a\u2477\u8b32\u3463z\ua7e9\ua4b1\ua031\ua908\u7d73\u8e5e\u247b\u8b33\u3476f\ua7e7\ua4f5\ua077\ua90a\u7d64\u8e0a") + methodNode.name + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2\ua7e1\ua4b0\ua07f\ua900\u7d64\u8e4b\u246e\u8b3e\u3479u\ua7a6\ua499\ua047\ua931\u7d36\u8e43\u2474\u8b77") + classNode.name);
        }
        List<ClassInfo.FrameData> list = method.getFrames();
        LocalVariableNode[] localVariableNodeArray = new LocalVariableNode[methodNode.maxLocals];
        int n3 = 0xF4664FE4 ^ 0xF4664FE4;
        int n4 = 0x6A735A2F ^ 0x6A735A2F;
        if ((methodNode.access & (0x4FCAA570 ^ 0x4FCAA578)) == 0) {
            int n5 = n3++;
            localVariableNodeArray[n5] = new LocalVariableNode(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("f\ua7ee\ua4bc\ua062"), classNode.name, null, null, null, 0xBF0F870D ^ 0xBF0F870D);
        }
        Type[] typeArray = Type.getArgumentTypes(methodNode.desc);
        int n6 = typeArray.length;
        for (n = 0xC9EF5839 ^ 0xC9EF5839; n < n6; ++n) {
            object = typeArray[n];
            localVariableNodeArray[n3] = new LocalVariableNode(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("s\ua7f4\ua4b2") + n4++, ((Type)object).toString(), null, null, null, n3);
            n3 += ((Type)object).getSize();
        }
        int n7 = n3;
        n6 = 0xF15A9F41 ^ 0xEA560BE;
        n = 0xB0F387AB ^ 0xB0F387AB;
        object = methodNode.instructions.iterator();
        while (object.hasNext()) {
            AbstractInsnNode abstractInsnNode2;
            AbstractInsnNode abstractInsnNode3 = (AbstractInsnNode)object.next();
            if (abstractInsnNode3 instanceof FrameNode) {
                abstractInsnNode2 = (FrameNode)abstractInsnNode3;
                ClassInfo.FrameData frameData = ++n6 < list.size() ? list.get(n6) : null;
                n = frameData != null && frameData.type == 0 ? Math.min(n, frameData.locals) : abstractInsnNode2.local.size();
                int n8 = 0xFC643A7C ^ 0xFC643A7C;
                int n9 = 0xDF8A5294 ^ 0xDF8A5294;
                while (n9 < localVariableNodeArray.length) {
                    Object object2;
                    Object object3 = object2 = n8 < abstractInsnNode2.local.size() ? abstractInsnNode2.local.get(n8) : null;
                    if (object2 instanceof String) {
                        localVariableNodeArray[n9] = Locals.getLocalVariableAt(classNode, methodNode, abstractInsnNode, n9);
                    } else if (object2 instanceof Integer) {
                        int n10;
                        int n11;
                        int n12;
                        int n13 = object2 == Opcodes.UNINITIALIZED_THIS || object2 == Opcodes.NULL ? 0x31D87FD2 ^ 0x31D87FD3 : (n12 = 0x5264A85F ^ 0x5264A85F);
                        int n14 = object2 == Opcodes.INTEGER || object2 == Opcodes.FLOAT ? 0x377337C0 ^ 0x377337C1 : (n11 = 0xE31E113A ^ 0xE31E113A);
                        int n15 = object2 == Opcodes.DOUBLE || object2 == Opcodes.LONG ? 0x392C6E88 ^ 0x392C6E89 : (n10 = 0x35CF04F3 ^ 0x35CF04F3);
                        if (object2 != Opcodes.TOP) {
                            if (n12 != 0) {
                                localVariableNodeArray[n9] = null;
                            } else {
                                if (n11 == 0 && n10 == 0) throw new LVTGeneratorException(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("G\ua7e8\ua4a7\ua074\ua906\u7d79\u8e4d\u2474\u8b3e\u3464w\ua7e2\ua4f5\ua07d\ua90a\u7d75\u8e4b\u2476\u8b24\u3437}\ua7f6\ua4b6\ua07e\ua901\u7d73\u8e0a") + object2 + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2\ua7ef\ua4bb\ua031\ua909\u7d79\u8e49\u247b\u8b3b\u34642\ua7e7\ua4a7\ua063\ua904\u7d6f\u8e0a\u247b\u8b23\u3437b\ua7e9\ua4a6\ua078\ua911\u7d7f\u8e45\u2474\u8b77") + n8 + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2\ua7ef\ua4bb\ua031") + classNode.name + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("<") + methodNode.name + methodNode.desc);
                                localVariableNodeArray[n9] = Locals.getLocalVariableAt(classNode, methodNode, abstractInsnNode, n9);
                                if (n10 != 0) {
                                    localVariableNodeArray[++n9] = null;
                                }
                            }
                        }
                    } else {
                        if (object2 != null) throw new LVTGeneratorException(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("[\ua7e8\ua4a3\ua070\ua909\u7d7f\u8e4e\u243a\u8b21\u3476~\ua7f3\ua4b0\ua031") + object2 + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2\ua7ef\ua4bb\ua031\ua909\u7d79\u8e49\u247b\u8b3b\u34642\ua7e7\ua4a7\ua063\ua904\u7d6f\u8e0a\u247b\u8b23\u3437b\ua7e9\ua4a6\ua078\ua911\u7d7f\u8e45\u2474\u8b77") + n8 + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2\ua7ef\ua4bb\ua031") + classNode.name + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("<") + methodNode.name + methodNode.desc);
                        if (n9 >= n7 && n9 >= n && n > 0) {
                            localVariableNodeArray[n9] = null;
                        }
                    }
                    ++n9;
                    ++n8;
                }
            } else if (abstractInsnNode3 instanceof VarInsnNode) {
                abstractInsnNode2 = (VarInsnNode)abstractInsnNode3;
                localVariableNodeArray[((VarInsnNode)abstractInsnNode2).var] = Locals.getLocalVariableAt(classNode, methodNode, abstractInsnNode, ((VarInsnNode)abstractInsnNode2).var);
            }
            if (abstractInsnNode3 != abstractInsnNode) continue;
            break;
        }
        for (int i = 0x349C311C ^ 0x349C311C; i < localVariableNodeArray.length; ++i) {
            if (localVariableNodeArray[i] == null || localVariableNodeArray[i].desc != null) continue;
            localVariableNodeArray[i] = null;
        }
        return localVariableNodeArray;
    }

    public static LocalVariableNode getLocalVariableAt(ClassNode classNode, MethodNode methodNode, AbstractInsnNode abstractInsnNode, int n) {
        return Locals.getLocalVariableAt(classNode, methodNode, methodNode.instructions.indexOf(abstractInsnNode), n);
    }

    private static LocalVariableNode getLocalVariableAt(ClassNode classNode, MethodNode methodNode, int n, int n2) {
        LocalVariableNode localVariableNode = null;
        LocalVariableNode localVariableNode2 = null;
        for (LocalVariableNode localVariableNode3 : Locals.getLocalVariableTable(classNode, methodNode)) {
            if (localVariableNode3.index != n2) continue;
            if (Locals.isOpcodeInRange(methodNode.instructions, localVariableNode3, n)) {
                localVariableNode = localVariableNode3;
                continue;
            }
            if (localVariableNode != null) continue;
            localVariableNode2 = localVariableNode3;
        }
        if (localVariableNode == null && !methodNode.localVariables.isEmpty()) {
            for (LocalVariableNode localVariableNode3 : Locals.getGeneratedLocalVariableTable(classNode, methodNode)) {
                if (localVariableNode3.index != n2 || !Locals.isOpcodeInRange(methodNode.instructions, localVariableNode3, n)) continue;
                localVariableNode = localVariableNode3;
            }
        }
        return localVariableNode != null ? localVariableNode : localVariableNode2;
    }

    private static boolean isOpcodeInRange(InsnList insnList, LocalVariableNode localVariableNode, int n) {
        return (insnList.indexOf(localVariableNode.start) < n && insnList.indexOf(localVariableNode.end) > n ? 0x2476DC3E ^ 0x2476DC3F : 0xBD8B2772 ^ 0xBD8B2772) != 0;
    }

    public static List<LocalVariableNode> getLocalVariableTable(ClassNode classNode, MethodNode methodNode) {
        if (methodNode.localVariables.isEmpty()) {
            return Locals.getGeneratedLocalVariableTable(classNode, methodNode);
        }
        return methodNode.localVariables;
    }

    public static List<LocalVariableNode> getGeneratedLocalVariableTable(ClassNode classNode, MethodNode methodNode) {
        Object[] objectArray = new Object[0xDF64E28C ^ 0xDF64E28F];
        objectArray[0xB5DDDA43 ^ 0xB5DDDA43] = classNode.name;
        objectArray[0xE43612CA ^ 0xE43612CB] = methodNode.name;
        objectArray[0x4E131201 ^ 0x4E131203] = methodNode.desc;
        String string = String.format(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("7\ua7f5\ua4fb\ua034\ua916\u7d33\u8e59"), objectArray);
        List<LocalVariableNode> list = calculatedLocalVariables.get(string);
        if (list != null) {
            return list;
        }
        list = Locals.generateLocalVariableTable(classNode, methodNode);
        calculatedLocalVariables.put(string, list);
        return list;
    }

    public static List<LocalVariableNode> generateLocalVariableTable(ClassNode classNode, MethodNode methodNode) {
        int n;
        ArrayList<Type> arrayList = null;
        if (classNode.interfaces != null) {
            arrayList = new ArrayList<Type>();
            for (String object2 : classNode.interfaces) {
                arrayList.add(Type.getObjectType(object2));
            }
        }
        Object object3 = null;
        if (classNode.superName != null) {
            object3 = Type.getObjectType(classNode.superName);
        }
        Analyzer<BasicValue> analyzer = new Analyzer<BasicValue>(new MixinVerifier(Type.getObjectType(classNode.name), (Type)object3, arrayList, (0xD45785A6 ^ 0xD45785A6) != 0));
        try {
            analyzer.analyze(classNode.name, methodNode);
        }
        catch (AnalyzerException frameArray) {
            frameArray.printStackTrace();
        }
        Frame<BasicValue>[] frameArray = analyzer.getFrames();
        int n2 = methodNode.instructions.size();
        ArrayList<LocalVariableNode> arrayList2 = new ArrayList<LocalVariableNode>();
        LocalVariableNode[] localVariableNodeArray = new LocalVariableNode[methodNode.maxLocals];
        BasicValue[] basicValueArray = new BasicValue[methodNode.maxLocals];
        LabelNode[] labelNodeArray = new LabelNode[n2];
        String[] stringArray = new String[methodNode.maxLocals];
        for (int labelNode = 0xE35131A0 ^ 0xE35131A0; labelNode < n2; ++labelNode) {
            Frame<BasicValue> n3 = frameArray[labelNode];
            if (n3 == null) continue;
            LabelNode labelNode2 = null;
            for (int i = 0xCD46E6E7 ^ 0xCD46E6E7; i < n3.getLocals(); ++i) {
                Object object;
                BasicValue basicValue = n3.getLocal(i);
                if (basicValue == null && basicValueArray[i] == null || basicValue != null && basicValue.equals(basicValueArray[i])) continue;
                if (labelNode2 == null) {
                    object = methodNode.instructions.get(labelNode);
                    if (object instanceof LabelNode) {
                        labelNode2 = (LabelNode)object;
                    } else {
                        labelNodeArray[labelNode] = labelNode2 = new LabelNode();
                    }
                }
                if (basicValue == null && basicValueArray[i] != null) {
                    arrayList2.add(localVariableNodeArray[i]);
                    localVariableNodeArray[i].end = labelNode2;
                    localVariableNodeArray[i] = null;
                } else if (basicValue != null) {
                    if (basicValueArray[i] != null) {
                        arrayList2.add(localVariableNodeArray[i]);
                        localVariableNodeArray[i].end = labelNode2;
                        localVariableNodeArray[i] = null;
                    }
                    object = basicValue.getType() != null ? basicValue.getType().getDescriptor() : stringArray[i];
                    localVariableNodeArray[i] = new LocalVariableNode(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("d\ua7e7\ua4a7") + i, (String)object, null, labelNode2, null, i);
                    if (object != null) {
                        stringArray[i] = object;
                    }
                }
                basicValueArray[i] = basicValue;
            }
        }
        LabelNode labelNode = null;
        for (n = 0x28AA5E7 ^ 0x28AA5E7; n < localVariableNodeArray.length; ++n) {
            if (localVariableNodeArray[n] == null) continue;
            if (labelNode == null) {
                labelNode = new LabelNode();
                methodNode.instructions.add(labelNode);
            }
            localVariableNodeArray[n].end = labelNode;
            arrayList2.add(localVariableNodeArray[n]);
        }
        for (n = n2 - (0x1D1A846A ^ 0x1D1A846B); n >= 0; --n) {
            if (labelNodeArray[n] == null) continue;
            methodNode.instructions.insert(methodNode.instructions.get(n), labelNodeArray[n]);
        }
        return arrayList2;
    }

    private static AbstractInsnNode nextNode(InsnList insnList, AbstractInsnNode abstractInsnNode) {
        int n = insnList.indexOf(abstractInsnNode) + (0x9E1BA279 ^ 0x9E1BA278);
        if (n > 0 && n < insnList.size()) {
            return insnList.get(n);
        }
        return abstractInsnNode;
    }
}

