/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.util;

import com.google.common.base.Strings;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pers.XiaoShadiao.\u5c0f\u6c99\u96d5\u7684\u7b2c\u4e00\u4e2amod.\u5b9e\u7528\u7684\u5c0f\u5de5\u5177awa.\u7eb3\u897f\u59b2;

public class PrettyPrinter {
    private final HorizontalRule horizontalRule;
    private final List<Object> lines;
    private Table table;
    private boolean recalcWidth;
    protected int width;
    protected int wrapWidth;
    protected int kvKeyWidth;
    protected String kvFormat;

    public PrettyPrinter() {
        this(0x3CC600AE ^ 0x3CC600CA);
    }

    public PrettyPrinter(int n) {
        char[] cArray = new char[0x2214B16B ^ 0x2214B16A];
        cArray[0x4DE7B5D2 ^ 0x4DE7B5D2] = 0xA8916ED2 ^ 0xA8916EF8;
        this.horizontalRule = new HorizontalRule(cArray);
        this.lines = new ArrayList<Object>();
        this.recalcWidth = 0xEF11B108 ^ 0xEF11B108;
        this.width = 0x86D13927 ^ 0x86D13943;
        this.wrapWidth = 0x38F114F3 ^ 0x38F114A3;
        this.kvKeyWidth = 0x870FBCE4 ^ 0x870FBCEE;
        this.kvFormat = PrettyPrinter.makeKvFormat(this.kvKeyWidth);
        this.width = n;
    }

    public PrettyPrinter wrapTo(int n) {
        this.wrapWidth = n;
        return this;
    }

    public int wrapTo() {
        return this.wrapWidth;
    }

    public PrettyPrinter table() {
        this.table = new Table();
        return this;
    }

    public PrettyPrinter table(String ... stringArray) {
        this.table = new Table();
        String[] stringArray2 = stringArray;
        int n = stringArray2.length;
        for (int i = 0xE89F1D29 ^ 0xE89F1D29; i < n; ++i) {
            String string = stringArray2[i];
            this.table.addColumn(string);
        }
        return this;
    }

    public PrettyPrinter table(Object ... objectArray) {
        this.table = new Table();
        Column column = null;
        Object[] objectArray2 = objectArray;
        int n = objectArray2.length;
        for (int i = 0xD4EA465F ^ 0xD4EA465F; i < n; ++i) {
            Object object = objectArray2[i];
            if (object instanceof String) {
                column = this.table.addColumn((String)object);
                continue;
            }
            if (object instanceof Integer && column != null) {
                int n2 = (Integer)object;
                if (n2 > 0) {
                    column.setWidth(n2);
                    continue;
                }
                if (n2 >= 0) continue;
                column.setMaxWidth(-n2);
                continue;
            }
            if (object instanceof Alignment && column != null) {
                column.setAlignment((Alignment)((Object)object));
                continue;
            }
            if (object == null) continue;
            column = this.table.addColumn(object.toString());
        }
        return this;
    }

    public PrettyPrinter spacing(int n) {
        if (this.table == null) {
            this.table = new Table();
        }
        this.table.setColSpacing(n);
        return this;
    }

    public PrettyPrinter th() {
        return this.th((0xA40C8092 ^ 0xA40C8092) != 0);
    }

    private PrettyPrinter th(boolean bl) {
        if (this.table == null) {
            this.table = new Table();
        }
        if (!bl || this.table.addHeader) {
            this.table.headerAdded();
            this.addLine(this.table);
        }
        return this;
    }

    public PrettyPrinter tr(Object ... objectArray) {
        this.th((0xF6B02B83 ^ 0xF6B02B82) != 0);
        this.addLine(this.table.addRow(objectArray));
        this.recalcWidth = 0x9E4B90A0 ^ 0x9E4B90A1;
        return this;
    }

    public PrettyPrinter add() {
        this.addLine(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b(""));
        return this;
    }

    public PrettyPrinter add(String string) {
        this.addLine(string);
        this.width = Math.max(this.width, string.length());
        return this;
    }

    public PrettyPrinter add(String string, Object ... objectArray) {
        String string2 = String.format(string, objectArray);
        this.addLine(string2);
        this.width = Math.max(this.width, string2.length());
        return this;
    }

    public PrettyPrinter add(Object[] objectArray) {
        return this.add(objectArray, \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("7\ua7f5"));
    }

    public PrettyPrinter add(Object[] objectArray, String string) {
        Object[] objectArray2 = objectArray;
        int n = objectArray2.length;
        for (int i = 0x835BB179 ^ 0x835BB179; i < n; ++i) {
            Object object = objectArray2[i];
            Object[] objectArray3 = new Object[0x574920D2 ^ 0x574920D3];
            objectArray3[0x59E7A23E ^ 0x59E7A23E] = object;
            this.add(string, objectArray3);
        }
        return this;
    }

    public PrettyPrinter addIndexed(Object[] objectArray) {
        int n = String.valueOf(objectArray.length - (0xBF137044 ^ 0xBF137045)).length();
        String string = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("I\ua7a3") + n + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("v\ua7db\ua4f5\ua034\ua916");
        for (int i = 0x5BD4D6A3 ^ 0x5BD4D6A3; i < objectArray.length; ++i) {
            Object[] objectArray2 = new Object[0xFFC4DF1 ^ 0xFFC4DF3];
            objectArray2[0x7A44AA42 ^ 0x7A44AA42] = i;
            objectArray2[0x3C327287 ^ 0x3C327286] = objectArray[i];
            this.add(string, objectArray2);
        }
        return this;
    }

    public PrettyPrinter addWithIndices(Collection<?> collection) {
        return this.addIndexed(collection.toArray());
    }

    public PrettyPrinter add(IPrettyPrintable iPrettyPrintable) {
        if (iPrettyPrintable != null) {
            iPrettyPrintable.print(this);
        }
        return this;
    }

    public PrettyPrinter add(Throwable throwable) {
        return this.add(throwable, 0x49A0386C ^ 0x49A03868);
    }

    public PrettyPrinter add(Throwable throwable, int n) {
        while (throwable != null) {
            Object[] objectArray = new Object[0x88A59761 ^ 0x88A59763];
            objectArray[0x6AD7AD50 ^ 0x6AD7AD50] = throwable.getClass().getName();
            objectArray[0x5223D013 ^ 0x5223D012] = throwable.getMessage();
            this.add(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("7\ua7f5\ua4ef\ua031\ua940\u7d65"), objectArray);
            this.add(throwable.getStackTrace(), n);
            throwable = throwable.getCause();
        }
        return this;
    }

    public PrettyPrinter add(StackTraceElement[] stackTraceElementArray, int n) {
        String string = Strings.repeat((String)\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2"), (int)n);
        StackTraceElement[] stackTraceElementArray2 = stackTraceElementArray;
        int n2 = stackTraceElementArray2.length;
        for (int i = 0x912FB82E ^ 0x912FB82E; i < n2; ++i) {
            StackTraceElement stackTraceElement = stackTraceElementArray2[i];
            Object[] objectArray = new Object[0x72F27DEC ^ 0x72F27DEE];
            objectArray[0x78737641 ^ 0x78737641] = string;
            objectArray[0x7236553C ^ 0x7236553D] = stackTraceElement;
            this.add(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("7\ua7f5\ua4f0\ua062"), objectArray);
        }
        return this;
    }

    public PrettyPrinter add(Object object) {
        return this.add(object, 0x6023FE48 ^ 0x6023FE48);
    }

    public PrettyPrinter add(Object object, int n) {
        String string = Strings.repeat((String)\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2"), (int)n);
        return this.append(object, n, string);
    }

    private PrettyPrinter append(Object object, int n, String string) {
        if (object instanceof String) {
            Object[] objectArray = new Object[0xA56B22E8 ^ 0xA56B22EA];
            objectArray[0x7241D27E ^ 0x7241D27E] = string;
            objectArray[0x41A45075 ^ 0x41A45074] = object;
            return this.add(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("7\ua7f5\ua4f0\ua062"), objectArray);
        }
        if (object instanceof Iterable) {
            for (Object t : (Iterable)object) {
                this.append(t, n, string);
            }
            return this;
        }
        if (object instanceof Map) {
            this.kvWidth(n);
            return this.add((Map)object);
        }
        if (object instanceof IPrettyPrintable) {
            return this.add((IPrettyPrintable)object);
        }
        if (object instanceof Throwable) {
            return this.add((Throwable)object, n);
        }
        if (object.getClass().isArray()) {
            return this.add((Object[])object, n + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("7\ua7f5"));
        }
        Object[] objectArray = new Object[0x36AFA149 ^ 0x36AFA14B];
        objectArray[0xFEB9047 ^ 0xFEB9047] = string;
        objectArray[0x4A8A94DD ^ 0x4A8A94DC] = object;
        return this.add(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("7\ua7f5\ua4f0\ua062"), objectArray);
    }

    public PrettyPrinter addWrapped(String string, Object ... objectArray) {
        return this.addWrapped(this.wrapWidth, string, objectArray);
    }

    public PrettyPrinter addWrapped(int n, String string, Object ... objectArray) {
        String string2 = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("");
        String string3 = String.format(string, objectArray).replace(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("\u001b"), \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2\ua7a6\ua4f5\ua031"));
        Matcher matcher = Pattern.compile(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("L\ua7ae\ua489\ua062\ua94e\u7d3f\u8e02\u2434\u8b7d\u343e6")).matcher(string3);
        if (matcher.matches()) {
            string2 = matcher.group(0x54FF76ED ^ 0x54FF76EC);
        }
        try {
            for (String string4 : this.getWrapped(n, string3, string2)) {
                this.addLine(string4);
            }
        }
        catch (Exception exception) {
            this.add(string3);
        }
        return this;
    }

    private List<String> getWrapped(int n, String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        while (string.length() > n) {
            int n2 = string.lastIndexOf(0x7F2BB21A ^ 0x7F2BB23A, n);
            if (n2 < (0x99C79A2A ^ 0x99C79A20)) {
                n2 = n;
            }
            String string3 = string.substring(0xC667D26B ^ 0xC667D26B, n2);
            arrayList.add(string3);
            string = string2 + string.substring(n2 + (0xA11A3BDF ^ 0xA11A3BDE));
        }
        if (string.length() > 0) {
            arrayList.add(string);
        }
        return arrayList;
    }

    public PrettyPrinter kv(String string, String string2, Object ... objectArray) {
        return this.kv(string, String.format(string2, objectArray));
    }

    public PrettyPrinter kv(String string, Object object) {
        this.addLine(new KeyValue(string, object));
        return this.kvWidth(string.length());
    }

    public PrettyPrinter kvWidth(int n) {
        if (n > this.kvKeyWidth) {
            this.kvKeyWidth = n;
            this.kvFormat = PrettyPrinter.makeKvFormat(n);
        }
        this.recalcWidth = 0x77B19AC7 ^ 0x77B19AC6;
        return this;
    }

    public PrettyPrinter add(Map<?, ?> map) {
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            String string = entry.getKey() == null ? \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("|\ua7f3\ua4b9\ua07d") : entry.getKey().toString();
            this.kv(string, entry.getValue());
        }
        return this;
    }

    public PrettyPrinter hr() {
        return this.hr((char)(0x6EAF65BB ^ 0x6EAF6591));
    }

    public PrettyPrinter hr(char c) {
        char[] cArray = new char[0xD303C20E ^ 0xD303C20F];
        cArray[0xC01E565D ^ 0xC01E565D] = c;
        this.addLine(new HorizontalRule(cArray));
        return this;
    }

    public PrettyPrinter centre() {
        if (!this.lines.isEmpty()) {
            Object object = this.lines.get(this.lines.size() - (0x7376601B ^ 0x7376601A));
            if (object instanceof String) {
                this.addLine(new CentredText(this.lines.remove(this.lines.size() - (0x336E3EFB ^ 0x336E3EFA))));
            }
        }
        return this;
    }

    private void addLine(Object object) {
        if (object == null) {
            return;
        }
        this.lines.add(object);
        this.recalcWidth |= object instanceof IVariableWidthEntry;
    }

    public PrettyPrinter trace() {
        return this.trace(PrettyPrinter.getDefaultLoggerName());
    }

    public PrettyPrinter trace(Level level) {
        return this.trace(PrettyPrinter.getDefaultLoggerName(), level);
    }

    public PrettyPrinter trace(String string) {
        return this.trace(System.err, LogManager.getLogger((String)string));
    }

    public PrettyPrinter trace(String string, Level level) {
        return this.trace(System.err, LogManager.getLogger((String)string), level);
    }

    public PrettyPrinter trace(Logger logger) {
        return this.trace(System.err, logger);
    }

    public PrettyPrinter trace(Logger logger, Level level) {
        return this.trace(System.err, logger, level);
    }

    public PrettyPrinter trace(PrintStream printStream) {
        return this.trace(printStream, PrettyPrinter.getDefaultLoggerName());
    }

    public PrettyPrinter trace(PrintStream printStream, Level level) {
        return this.trace(printStream, PrettyPrinter.getDefaultLoggerName(), level);
    }

    public PrettyPrinter trace(PrintStream printStream, String string) {
        return this.trace(printStream, LogManager.getLogger((String)string));
    }

    public PrettyPrinter trace(PrintStream printStream, String string, Level level) {
        return this.trace(printStream, LogManager.getLogger((String)string), level);
    }

    public PrettyPrinter trace(PrintStream printStream, Logger logger) {
        return this.trace(printStream, logger, Level.DEBUG);
    }

    public PrettyPrinter trace(PrintStream printStream, Logger logger, Level level) {
        this.log(logger, level);
        this.print(printStream);
        return this;
    }

    public PrettyPrinter print() {
        return this.print(System.err);
    }

    public PrettyPrinter print(PrintStream printStream) {
        this.updateWidth();
        this.printSpecial(printStream, this.horizontalRule);
        for (Object object : this.lines) {
            if (object instanceof ISpecialEntry) {
                this.printSpecial(printStream, (ISpecialEntry)object);
                continue;
            }
            this.printString(printStream, object.toString());
        }
        this.printSpecial(printStream, this.horizontalRule);
        return this;
    }

    private void printSpecial(PrintStream printStream, ISpecialEntry iSpecialEntry) {
        Object[] objectArray = new Object[0x8E9FCDD ^ 0x8E9FCDC];
        objectArray[0xD60FE2A1 ^ 0xD60FE2A1] = iSpecialEntry.toString();
        printStream.printf(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("=\ua7ac\ua4f0\ua062\ua94f\u7d39\u8e20"), objectArray);
    }

    private void printString(PrintStream printStream, String string) {
        if (string != null) {
            Object[] objectArray = new Object[0xBBC0D6ED ^ 0xBBC0D6EC];
            objectArray[0xF1C8EF74 ^ 0xF1C8EF74] = string;
            printStream.printf(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("=\ua7ac\ua4f5\ua034\ua948") + this.width + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("a\ua7a6\ua4ff\ua03e\ua96f"), objectArray);
        }
    }

    public PrettyPrinter log(Logger logger) {
        return this.log(logger, Level.INFO);
    }

    public PrettyPrinter log(Logger logger, Level level) {
        this.updateWidth();
        this.logSpecial(logger, level, this.horizontalRule);
        for (Object object : this.lines) {
            if (object instanceof ISpecialEntry) {
                this.logSpecial(logger, level, (ISpecialEntry)object);
                continue;
            }
            this.logString(logger, level, object.toString());
        }
        this.logSpecial(logger, level, this.horizontalRule);
        return this;
    }

    private void logSpecial(Logger logger, Level level, ISpecialEntry iSpecialEntry) {
        Object[] objectArray = new Object[0x780886A7 ^ 0x780886A6];
        objectArray[0xFD5465FC ^ 0xFD5465FC] = iSpecialEntry.toString();
        logger.log(level, \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("=\ua7ac\ua4ae\ua06c\ua94f\u7d39"), objectArray);
    }

    private void logString(Logger logger, Level level, String string) {
        if (string != null) {
            Object[] objectArray = new Object[0xBCAAB8B6 ^ 0xBCAAB8B7];
            objectArray[0x81E4429B ^ 0x81E4429B] = string;
            logger.log(level, String.format(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("=\ua7ac\ua4f5\ua034\ua948") + this.width + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("a\ua7a6\ua4ff\ua03e"), objectArray));
        }
    }

    private void updateWidth() {
        if (this.recalcWidth) {
            this.recalcWidth = 0x2CA07E45 ^ 0x2CA07E45;
            for (Object object : this.lines) {
                if (!(object instanceof IVariableWidthEntry)) continue;
                this.width = Math.min(0xF653D071 ^ 0xF653C071, Math.max(this.width, ((IVariableWidthEntry)object).getWidth()));
            }
        }
    }

    private static String makeKvFormat(int n) {
        Object[] objectArray = new Object[0x126F7BF0 ^ 0x126F7BF1];
        objectArray[0x7F3EAEAA ^ 0x7F3EAEAA] = n;
        return String.format(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("7\ua7a3\ua4f0\ua075\ua916\u7d36\u8e10\u243a\u8b72\u3432a"), objectArray);
    }

    private static String getDefaultLoggerName() {
        String string = new Throwable().getStackTrace()[0xF4754C2 ^ 0xF4754C0].getClassName();
        int n = string.lastIndexOf(0x89D744EB ^ 0x89D744C5);
        return n == (0xED162ECD ^ 0x12E9D132) ? string : string.substring(n + (0x895E6816 ^ 0x895E6817));
    }

    public static void dumpStack() {
        new PrettyPrinter().add(new Exception(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("A\ua7f2\ua4b4\ua072\ua90e\u7d36\u8e5e\u2468\u8b36\u3474w"))).print(System.err);
    }

    public static void print(Throwable throwable) {
        new PrettyPrinter().add(throwable).print(System.err);
    }

    static class Row
    implements IVariableWidthEntry {
        final Table table;
        final String[] args;

        public Row(Table table, Object ... objectArray) {
            this.table = table.grow(objectArray.length);
            this.args = new String[objectArray.length];
            for (int i = 0x3C0B45B5 ^ 0x3C0B45B5; i < objectArray.length; ++i) {
                this.args[i] = objectArray[i].toString();
                this.table.columns.get(i).setMinWidth(this.args[i].length());
            }
        }

        public String toString() {
            Object[] objectArray = new Object[this.table.columns.size()];
            for (int i = 0xB068D4F ^ 0xB068D4F; i < objectArray.length; ++i) {
                Column column = this.table.columns.get(i);
                if (i >= this.args.length) {
                    objectArray[i] = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("");
                    continue;
                }
                objectArray[i] = this.args[i].length() > column.getMaxWidth() ? this.args[i].substring(0x61D405C7 ^ 0x61D405C7, column.getMaxWidth()) : this.args[i];
            }
            return String.format(this.table.format, objectArray);
        }

        @Override
        public int getWidth() {
            return this.toString().length();
        }
    }

    static class Column {
        private final Table table;
        private Alignment align = Alignment.LEFT;
        private int minWidth = 0x2396615B ^ 0x2396615A;
        private int maxWidth = 0x91044276 ^ 0xEEFBBD89;
        private int size = 0x53137A36 ^ 0x53137A36;
        private String title = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("");
        private String format = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("7\ua7f5");

        Column(Table table) {
            this.table = table;
        }

        Column(Table table, String string) {
            this(table);
            this.title = string;
            this.minWidth = string.length();
            this.updateFormat();
        }

        Column(Table table, Alignment alignment, int n, String string) {
            this(table, string);
            this.align = alignment;
            this.size = n;
        }

        void setAlignment(Alignment alignment) {
            this.align = alignment;
            this.updateFormat();
        }

        void setWidth(int n) {
            if (n > this.size) {
                this.size = n;
                this.updateFormat();
            }
        }

        void setMinWidth(int n) {
            if (n > this.minWidth) {
                this.minWidth = n;
                this.updateFormat();
            }
        }

        void setMaxWidth(int n) {
            this.size = Math.min(this.size, this.maxWidth);
            this.maxWidth = Math.max(0x7B9EEFAF ^ 0x7B9EEFAE, n);
            this.updateFormat();
        }

        void setTitle(String string) {
            this.title = string;
            this.setWidth(string.length());
        }

        private void updateFormat() {
            int n = Math.min(this.maxWidth, this.size == 0 ? this.minWidth : this.size);
            this.format = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("7") + (this.align == Alignment.RIGHT ? \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("") : \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("?")) + n + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("a");
            this.table.updateFormat();
        }

        int getMaxWidth() {
            return this.maxWidth;
        }

        String getTitle() {
            return this.title;
        }

        String getFormat() {
            return this.format;
        }

        public String toString() {
            if (this.title.length() > this.maxWidth) {
                return this.title.substring(0xE1E09FCD ^ 0xE1E09FCD, this.maxWidth);
            }
            return this.title;
        }
    }

    static class Table
    implements IVariableWidthEntry {
        final List<Column> columns = new ArrayList<Column>();
        final List<Row> rows = new ArrayList<Row>();
        String format = \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("7\ua7f5");
        int colSpacing = 0x127093A5 ^ 0x127093A7;
        boolean addHeader = 0x5E389157 ^ 0x5E389156;

        Table() {
        }

        void headerAdded() {
            this.addHeader = 0xE2742F60 ^ 0xE2742F60;
        }

        void setColSpacing(int n) {
            this.colSpacing = Math.max(0x39C9846B ^ 0x39C9846B, n);
            this.updateFormat();
        }

        Table grow(int n) {
            while (this.columns.size() < n) {
                this.columns.add(new Column(this));
            }
            this.updateFormat();
            return this;
        }

        Column add(Column column) {
            this.columns.add(column);
            return column;
        }

        Row add(Row row) {
            this.rows.add(row);
            return row;
        }

        Column addColumn(String string) {
            return this.add(new Column(this, string));
        }

        Column addColumn(Alignment alignment, int n, String string) {
            return this.add(new Column(this, alignment, n, string));
        }

        Row addRow(Object ... objectArray) {
            return this.add(new Row(this, objectArray));
        }

        void updateFormat() {
            String string = Strings.repeat((String)\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("2"), (int)this.colSpacing);
            StringBuilder stringBuilder = new StringBuilder();
            int n = 0x3930454 ^ 0x3930454;
            for (Column column : this.columns) {
                if (n != 0) {
                    stringBuilder.append(string);
                }
                n = 0x6FAB560F ^ 0x6FAB560E;
                stringBuilder.append(column.getFormat());
            }
            this.format = stringBuilder.toString();
        }

        String getFormat() {
            return this.format;
        }

        Object[] getTitles() {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Column column : this.columns) {
                arrayList.add(column.getTitle());
            }
            return arrayList.toArray();
        }

        public String toString() {
            int n = 0xD7B8C421 ^ 0xD7B8C421;
            String[] stringArray = new String[this.columns.size()];
            for (int i = 0x8CE4B586 ^ 0x8CE4B586; i < this.columns.size(); ++i) {
                stringArray[i] = this.columns.get(i).toString();
                n |= !stringArray[i].isEmpty() ? 0x5B2E337C ^ 0x5B2E337D : 0xB6317D4A ^ 0xB6317D4A;
            }
            return n != 0 ? String.format(this.format, stringArray) : null;
        }

        @Override
        public int getWidth() {
            String string = this.toString();
            return string != null ? string.length() : 0x7D3AD715 ^ 0x7D3AD715;
        }
    }

    public static final class Alignment
    extends Enum<Alignment> {
        public static final /* enum */ Alignment LEFT = new Alignment();
        public static final /* enum */ Alignment RIGHT = new Alignment();
        private static final /* synthetic */ Alignment[] $VALUES;

        public static Alignment[] values() {
            return (Alignment[])$VALUES.clone();
        }

        public static Alignment valueOf(String string) {
            return Enum.valueOf(Alignment.class, string);
        }

        static {
            Alignment[] alignmentArray = new Alignment[0x479CC39 ^ 0x479CC3B];
            alignmentArray[0x3D17B2A2 ^ 0x3D17B2A2] = LEFT;
            alignmentArray[0x27622959 ^ 0x27622958] = RIGHT;
            $VALUES = alignmentArray;
        }
    }

    class CentredText {
        private final Object centred;

        public CentredText(Object object) {
            this.centred = object;
        }

        public String toString() {
            String string = this.centred.toString();
            Object[] objectArray = new Object[0x1E7C945B ^ 0x1E7C945A];
            objectArray[0x8AFE153C ^ 0x8AFE153C] = string;
            return String.format(\u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("7") + ((PrettyPrinter.this.width - string.length()) / (0x7AED2550 ^ 0x7AED2552) + string.length()) + \u7eb3\u897f\u59b2.\u67af\u840e\u4e4b\u523b("a"), objectArray);
        }
    }

    class HorizontalRule
    implements ISpecialEntry {
        private final char[] hrChars;

        public HorizontalRule(char ... cArray) {
            this.hrChars = cArray;
        }

        public String toString() {
            return Strings.repeat((String)new String(this.hrChars), (int)(PrettyPrinter.this.width + (0x5C5386D5 ^ 0x5C5386D7)));
        }
    }

    class KeyValue
    implements IVariableWidthEntry {
        private final String key;
        private final Object value;

        public KeyValue(String string, Object object) {
            this.key = string;
            this.value = object;
        }

        public String toString() {
            Object[] objectArray = new Object[0xDFB76C9C ^ 0xDFB76C9E];
            objectArray[0x1B57EEE7 ^ 0x1B57EEE7] = this.key;
            objectArray[0x8060D469 ^ 0x8060D468] = this.value;
            return String.format(PrettyPrinter.this.kvFormat, objectArray);
        }

        @Override
        public int getWidth() {
            return this.toString().length();
        }
    }

    static interface ISpecialEntry {
    }

    static interface IVariableWidthEntry {
        public int getWidth();
    }

    public static interface IPrettyPrintable {
        public void print(PrettyPrinter var1);
    }
}

